/*
 * Copyright (c) 2008-2022
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_EIG_MPFR_H_
#define _MPLAPACK_EIG_MPFR_H_

#include "mplapack_config.h"
#include "mpc_class.h"
#include "gmpxx.h"
#include "mpreal.h"
#include "mpcomplex.h"

using namespace mpfr;

bool Clctes(mpcomplex const z, mpcomplex const d);
bool Clctsx(mpcomplex const, mpcomplex const);
bool Cslect(mpcomplex const z);
bool Rlctes(mpreal const zr, mpreal const zi, mpreal const d);
bool Rlctsx(mpreal const, mpreal const, mpreal const);
bool Rslect(mpreal const zr, mpreal const zi);
mplapackint iMlaenv2stage_mpfr(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv_mpfr(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mpreal Rlamch_mpfr(const char *cmach);
mpreal Rsxt1(mplapackint const ijob, mpreal *d1, mplapackint const n1, mpreal *d2, mplapackint const n2, mpreal const abstol, mpreal const ulp, mpreal const unfl);
void Alahdg(mplapackint const iounit, const char *path);
void Alareq(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alarqg(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alasmg(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasum(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasvm(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Cbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, mpcomplex *a, mplapackint const lda, mpcomplex *q, mplapackint const ldq, mpreal *d, mpreal *e, mpcomplex *pt, mplapackint const ldpt, mpcomplex *work, mpreal *rwork, mpreal &resid);
void Cbdt02(mplapackint const m, mplapackint const n, mpcomplex *b, mplapackint const ldb, mpcomplex *c, mplapackint const ldc, mpcomplex *u, mplapackint const ldu, mpcomplex *work, mpreal *rwork, mpreal &resid);
void Cbdt03(const char *uplo, mplapackint const n, mplapackint const kd, mpreal *d, mpreal *e, mpcomplex *u, mplapackint const ldu, mpreal *s, mpcomplex *vt, mplapackint const ldvt, mpcomplex *work, mpreal &resid);
void Cbdt05(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpreal *s, mplapackint const ns, mpcomplex *u, mplapackint const ldu, mpcomplex *vt, mplapackint const ldvt, mpcomplex *work, mpreal &resid);
void Cchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *ab, mplapackint const ldab, mpreal *bd, mpreal *be, mpcomplex *q, mplapackint const ldq, mpcomplex *p, mplapackint const ldp, mpcomplex *c, mplapackint const ldc, mpcomplex *cc, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result, mplapackint &info);
void Cchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, mpreal const thresh, mpcomplex *a, mplapackint const lda, mpreal *bd, mpreal *be, mpreal *s1, mpreal *s2, mpcomplex *x, mplapackint const ldx, mpcomplex *y, mpcomplex *z, mpcomplex *q, mplapackint const ldq, mpcomplex *pt, mplapackint const ldpt, mpcomplex *u, mpcomplex *vt, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const nout, mplapackint &info);
void Cchkbk(mplapackint const nin, mplapackint const nout);
void Cchkbl(mplapackint const nin, mplapackint const nout);
void Cchkec(mpreal const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Cchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, bool const tstdif, mpreal const thrshn, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *b, mpcomplex *h, mpcomplex *t, mpcomplex *s1, mpcomplex *s2, mpcomplex *p1, mpcomplex *p2, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mpcomplex *q, mpcomplex *z, mpcomplex *alpha1, mpcomplex *beta1, mpcomplex *alpha3, mpcomplex *beta3, mpcomplex *evectl, mpcomplex *evectr, mpcomplex *work, mplapackint const lwork, mpreal *rwork, bool *llwork, mpreal *result, mplapackint &info);
void Cchkgk(mplapackint const nin, mplapackint const nout);
void Cchkgl(mplapackint const nin, mplapackint const nout);
void Cchkhb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpreal *sd, mpreal *se, mpcomplex *u, mplapackint const ldu, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result, mplapackint &info);
void Cchkhb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpreal *sd, mpreal *se, mpreal *d1, mpreal *d2, mpreal *d3, mpcomplex *u, mplapackint const ldu, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result, mplapackint &info);
void Cchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *h, mpcomplex *t1, mpcomplex *t2, mpcomplex *u, mplapackint const ldu, mpcomplex *z, mpcomplex *uz, mpcomplex *w1, mpcomplex *w3, mpcomplex *evectl, mpcomplex *evectr, mpcomplex *evecty, mpcomplex *evectx, mpcomplex *uu, mpcomplex *tau, mpcomplex *work, mplapackint const nwork, mpreal *rwork, mplapackint *iwork, bool *select, mpreal *result, mplapackint &info);
void Cchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *ap, mpreal *sd, mpreal *se, mpreal *d1, mpreal *d2, mpreal *d3, mpreal *d4, mpreal *d5, mpreal *wa1, mpreal *wa2, mpreal *wa3, mpreal *wr, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mpcomplex *vp, mpcomplex *tau, mpcomplex *z, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, mplapackint &info);
void Cchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *ap, mpreal *sd, mpreal *se, mpreal *d1, mpreal *d2, mpreal *d3, mpreal *d4, mpreal *d5, mpreal *wa1, mpreal *wa2, mpreal *wa3, mpreal *wr, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mpcomplex *vp, mpcomplex *tau, mpcomplex *z, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, mplapackint &info);
void Cckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, mpreal const thresh, mplapackint const mmax, mpcomplex *x, mpcomplex *xf, mpcomplex *u1, mpcomplex *u2, mpcomplex *v1t, mpcomplex *v2t, mpreal *theta, mplapackint *iwork, mpcomplex *work, mpreal *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckglm(mplapackint const nn, mplapackint *nval, mplapackint *mval, mplapackint *pval, mplapackint const nmats, mplapackint *iseed, mpreal const thresh, mplapackint const nmax, mpcomplex *a, mpcomplex *af, mpcomplex *b, mpcomplex *bf, mpcomplex *x, mpcomplex *work, mpreal *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpreal const thresh, mplapackint const nmax, mpcomplex *a, mpcomplex *af, mpcomplex *aq, mpcomplex *ar, mpcomplex *taua, mpcomplex *b, mpcomplex *bf, mpcomplex *bz, mpcomplex *bt, mpcomplex *bwk, mpcomplex *taub, mpcomplex *work, mpreal *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpreal const thresh, mplapackint const nmax, mpcomplex *a, mpcomplex *af, mpcomplex *b, mpcomplex *bf, mpcomplex *u, mpcomplex *v, mpcomplex *q, mpreal *alpha, mpreal *beta, mpcomplex *r, mplapackint *iwork, mpcomplex *work, mpreal *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpreal const thresh, mplapackint const nmax, mpcomplex *a, mpcomplex *af, mpcomplex *b, mpcomplex *bf, mpcomplex *x, mpcomplex *work, mpreal *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccsdts(mplapackint const m, mplapackint const p, mplapackint const q, mpcomplex *x, mpcomplex *xf, mplapackint const ldx, mpcomplex *u1, mplapackint const ldu1, mpcomplex *u2, mplapackint const ldu2, mpcomplex *v1t, mplapackint const ldv1t, mpcomplex *v2t, mplapackint const ldv2t, mpreal *theta, mplapackint *iwork, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Cdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *b, mpcomplex *s, mpcomplex *t, mpcomplex *q, mplapackint const ldq, mpcomplex *z, mpcomplex *alpha, mpcomplex *beta, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result, bool *bwork, mplapackint &info);
void Cdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *b, mpcomplex *s, mpcomplex *t, mpcomplex *q, mplapackint const ldq, mpcomplex *z, mpcomplex *alpha, mpcomplex *beta, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result, bool *bwork, mplapackint &info);
void Cdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *b, mpcomplex *s, mpcomplex *t, mpcomplex *q, mplapackint const ldq, mpcomplex *z, mpcomplex *qe, mplapackint const ldqe, mpcomplex *alpha, mpcomplex *beta, mpcomplex *alpha1, mpcomplex *beta1, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result, mplapackint &info);
void Cdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *b, mpcomplex *s, mpcomplex *t, mpcomplex *q, mplapackint const ldq, mpcomplex *z, mpcomplex *qe, mplapackint const ldqe, mpcomplex *alpha, mpcomplex *beta, mpcomplex *alpha1, mpcomplex *beta1, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result, mplapackint &info);
void Cdrgsx(mplapackint const nsize, mplapackint const ncmax, mpreal const thresh, mplapackint const nin, mplapackint const nout, mpcomplex *a, mplapackint const lda, mpcomplex *b, mpcomplex *ai, mpcomplex *bi, mpcomplex *z, mpcomplex *q, mpcomplex *alpha, mpcomplex *beta, mpcomplex *c, mplapackint const ldc, mpreal *s, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Cdrgvx(mplapackint const nsize, mpreal const thresh, mplapackint const nin, mplapackint const nout, mpcomplex *a, mplapackint const lda, mpcomplex *b, mpcomplex *ai, mpcomplex *bi, mpcomplex *alpha, mpcomplex *beta, mpcomplex *vl, mpcomplex *vr, mplapackint &ilo, mplapackint &ihi, mpreal *lscale, mpreal *rscale, mpreal *s, mpreal *dtru, mpreal *dif, mpreal *diftru, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, bool *bwork, mplapackint &info);
void Cdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mpcomplex *a, mplapackint const lda, mpcomplex *u, mplapackint const ldu, mpcomplex *vt, mplapackint const ldvt, mpcomplex *asav, mpcomplex *usav, mpcomplex *vtsav, mpreal *s, mpreal *ssav, mpreal *e, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint *iwork, mplapackint const nounit, mplapackint &info);
void Cdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *h, mpcomplex *ht, mpcomplex *w, mpcomplex *wt, mpcomplex *vs, mplapackint const ldvs, mpreal *result, mpcomplex *work, mplapackint const nwork, mpreal *rwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Cdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *h, mpcomplex *w, mpcomplex *w1, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mpcomplex *lre, mplapackint const ldlre, mpreal *result, mpcomplex *work, mplapackint const nwork, mpreal *rwork, mplapackint *iwork, mplapackint &info);
void Cdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpreal *d, mpcomplex *z, mplapackint const ldz, mpcomplex *ab, mpcomplex *bb, mpcomplex *ap, mpcomplex *bp, mpcomplex *work, mplapackint const nwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, mplapackint &info);
void Cdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpreal *d, mpreal *d2, mpcomplex *z, mplapackint const ldz, mpcomplex *ab, mpcomplex *bb, mpcomplex *ap, mpcomplex *bp, mpcomplex *work, mplapackint const nwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, mplapackint &info);
void Cdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpreal *d1, mpreal *d2, mpreal *d3, mpreal *wa1, mpreal *wa2, mpreal *wa3, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mpcomplex *tau, mpcomplex *z, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, mplapackint &info);
void Cdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpreal *d1, mpreal *d2, mpreal *d3, mpreal *wa1, mpreal *wa2, mpreal *wa3, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mpcomplex *tau, mpcomplex *z, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, mplapackint &info);
void Cdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const niunit, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *h, mpcomplex *ht, mpcomplex *w, mpcomplex *wt, mpcomplex *wtmp, mpcomplex *vs, mplapackint const ldvs, mpcomplex *vs1, mpreal *result, mpcomplex *work, mplapackint const lwork, mpreal *rwork, bool *bwork, mplapackint &info);
void Cdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const niunit, mplapackint const nounit, mpcomplex *a, mplapackint const lda, mpcomplex *h, mpcomplex *w, mpcomplex *w1, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mpcomplex *lre, mplapackint const ldlre, mpreal *rcondv, mpreal *rcndv1, mpreal *rcdvin, mpreal *rconde, mpreal *rcnde1, mpreal *rcdein, mpreal *scale, mpreal *scale1, mpreal *result, mpcomplex *work, mplapackint const nwork, mpreal *rwork, mplapackint &info);
void Cerrbd(const char *path, mplapackint const nunit);
void Cerrec(const char *path, mplapackint const nunit);
void Cerred(const char *path, mplapackint const nunit);
void Cerrgg(const char *path, mplapackint const nunit);
void Cerrhs(const char *path, mplapackint const nunit);
void Cerrst(const char *path, mplapackint const nunit);
void Cget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Cget10(mplapackint const m, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *work, mpreal *rwork, mpreal &result);
void Cget22(const char *transa, const char *transe, const char *transw, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *e, mplapackint const lde, mpcomplex *w, mpcomplex *work, mpreal *rwork, mpreal *result);
void Cget23(bool const comp, mplapackint const isrt, const char *balanc, mplapackint const jtype, mpreal const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *h, mpcomplex *w, mpcomplex *w1, mpcomplex *vl, mplapackint const ldvl, mpcomplex *vr, mplapackint const ldvr, mpcomplex *lre, mplapackint const ldlre, mpreal *rcondv, mpreal *rcndv1, mpreal *rcdvin, mpreal *rconde, mpreal *rcnde1, mpreal *rcdein, mpreal *scale, mpreal *scale1, mpreal *result, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mplapackint &info);
void Cget24(bool const comp, mplapackint const jtype, mpreal const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *h, mpcomplex *ht, mpcomplex *w, mpcomplex *wt, mpcomplex *wtmp, mpcomplex *vs, mplapackint const ldvs, mpcomplex *vs1, mpreal const rcdein, mpreal const rcdvin, mplapackint const nslct, mplapackint *islct, mplapackint const isrt, mpreal *result, mpcomplex *work, mplapackint const lwork, mpreal *rwork, bool *bwork, mplapackint &info);
void Cget35(mpreal &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget36(mpreal &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget37(mpreal *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget38(mpreal *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget51(mplapackint const itype, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mplapackint const ldv, mpcomplex *work, mpreal *rwork, mpreal &result);
void Cget52(bool const left, mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *e, mplapackint const lde, mpcomplex *alpha, mpcomplex *beta, mpcomplex *work, mpreal *rwork, mpreal *result);
void Cget54(mplapackint const n, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *s, mplapackint const lds, mpcomplex *t, mplapackint const ldt, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mplapackint const ldv, mpcomplex *work, mpreal &result);
void Cglmts(mplapackint const n, mplapackint const m, mplapackint const p, mpcomplex *a, mpcomplex *af, mplapackint const lda, mpcomplex *b, mpcomplex *bf, mplapackint const ldb, mpcomplex *d, mpcomplex *df, mpcomplex *x, mpcomplex *u, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal &result);
void Cgqrts(mplapackint const n, mplapackint const m, mplapackint const p, mpcomplex *a, mpcomplex *af, mpcomplex *q, mpcomplex *r, mplapackint const lda, mpcomplex *taua, mpcomplex *b, mpcomplex *bf, mpcomplex *z, mpcomplex *t, mpcomplex *bwk, mplapackint const ldb, mpcomplex *taub, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Cgrqts(mplapackint const m, mplapackint const p, mplapackint const n, mpcomplex *a, mpcomplex *af, mpcomplex *q, mpcomplex *r, mplapackint const lda, mpcomplex *taua, mpcomplex *b, mpcomplex *bf, mpcomplex *z, mpcomplex *t, mpcomplex *bwk, mplapackint const ldb, mpcomplex *taub, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Cgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, mpcomplex *a, mpcomplex *af, mplapackint const lda, mpcomplex *b, mpcomplex *bf, mplapackint const ldb, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mplapackint const ldv, mpcomplex *q, mplapackint const ldq, mpreal *alpha, mpreal *beta, mpcomplex *r, mplapackint const ldr, mplapackint *iwork, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Chbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, mpcomplex *a, mplapackint const lda, mpreal *d, mpreal *e, mpcomplex *u, mplapackint const ldu, mpcomplex *work, mpreal *rwork, mpreal *result);
void Chet21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, mpcomplex *a, mplapackint const lda, mpreal *d, mpreal *e, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mplapackint const ldv, mpcomplex *tau, mpcomplex *work, mpreal *rwork, mpreal *result);
void Chet22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, mpcomplex *a, mplapackint const lda, mpreal *d, mpreal *e, mpcomplex *u, mplapackint const ldu, mpcomplex *, mplapackint const ldv, mpcomplex *, mpcomplex *work, mpreal *rwork, mpreal *result);
void Chpt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, mpcomplex *ap, mpreal *d, mpreal *e, mpcomplex *u, mplapackint const ldu, mpcomplex *vp, mpcomplex *tau, mpcomplex *work, mpreal *rwork, mpreal *result);
void Chst01(mplapackint const n, mplapackint const, mplapackint const, mpcomplex *a, mplapackint const lda, mpcomplex *h, mplapackint const ldh, mpcomplex *q, mplapackint const ldq, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Clacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, mpreal *theta, mplapackint *iseed, mpcomplex *x, mplapackint const &ldx, mpcomplex *work);
void Clarfy(const char *uplo, mplapackint const n, mpcomplex *v, mplapackint const incv, mpcomplex const tau, mpcomplex *c, mplapackint const ldc, mpcomplex *work);
void Clarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const ldx, mpcomplex *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Clatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, bool const rsign, mpreal const amagn, mpreal const rcond, mpreal const triang, mplapackint const idist, mplapackint *iseed, mpcomplex *a, mplapackint const lda);
void Clsets(mplapackint const m, mplapackint const p, mplapackint const n, mpcomplex *a, mpcomplex *af, mplapackint const lda, mpcomplex *b, mpcomplex *bf, mplapackint const ldb, mpcomplex *c, mpcomplex *cf, mpcomplex *d, mpcomplex *df, mpcomplex *x, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Csbmv(const char *uplo, mplapackint const n, mplapackint const k, mpcomplex const alpha, mpcomplex *a, mplapackint const lda, mpcomplex *x, mplapackint const incx, mpcomplex const beta, mpcomplex *y, mplapackint const incy);
void Csgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mpcomplex *a, mplapackint const lda, mpcomplex *b, mplapackint const ldb, mpcomplex *z, mplapackint const ldz, mpreal *d, mpcomplex *work, mpreal *rwork, mpreal *result);
void Cstt21(mplapackint const n, mplapackint const kband, mpreal *ad, mpreal *ae, mpreal *sd, mpreal *se, mpcomplex *u, mplapackint const ldu, mpcomplex *work, mpreal *rwork, mpreal *result);
void Cstt22(mplapackint const n, mplapackint const m, mplapackint const kband, mpreal *ad, mpreal *ae, mpreal *sd, mpreal *se, mpcomplex *u, mplapackint const ldu, mpcomplex *work, mplapackint const ldwork, mpreal *rwork, mpreal *result);
void Cunt01(const char *rowcol, mplapackint const m, mplapackint const n, mpcomplex *u, mplapackint const ldu, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal &resid);
void Cunt03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, mpcomplex *u, mplapackint const ldu, mpcomplex *v, mplapackint const ldv, mpcomplex *work, mplapackint const lwork, mpreal *rwork, mpreal &result, mplapackint &info);
void Mxerbla_mpfr(const char *srname, int info);
void Rbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, mpreal *a, mplapackint const lda, mpreal *q, mplapackint const ldq, mpreal *d, mpreal *e, mpreal *pt, mplapackint const ldpt, mpreal *work, mpreal &resid);
void Rbdt02(mplapackint const m, mplapackint const n, mpreal *b, mplapackint const ldb, mpreal *c, mplapackint const ldc, mpreal *u, mplapackint const ldu, mpreal *work, mpreal &resid);
void Rbdt03(const char *uplo, mplapackint const n, mplapackint const kd, mpreal *d, mpreal *e, mpreal *u, mplapackint const ldu, mpreal *s, mpreal *vt, mplapackint const ldvt, mpreal *work, mpreal &resid);
void Rbdt04(const char *uplo, mplapackint const n, mpreal *d, mpreal *e, mpreal *s, mplapackint const ns, mpreal *u, mplapackint const ldu, mpreal *vt, mplapackint const ldvt, mpreal *work, mpreal &resid);
void Rbdt05(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *s, mplapackint const ns, mpreal *u, mplapackint const ldu, mpreal *vt, mplapackint const ldvt, mpreal *work, mpreal &resid);
void Rchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *ab, mplapackint const ldab, mpreal *bd, mpreal *be, mpreal *q, mplapackint const ldq, mpreal *p, mplapackint const ldp, mpreal *c, mplapackint const ldc, mpreal *cc, mpreal *work, mplapackint const lwork, mpreal *result, mplapackint &info);
void Rchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, mpreal const thresh, mpreal *a, mplapackint const lda, mpreal *bd, mpreal *be, mpreal *s1, mpreal *s2, mpreal *x, mplapackint const ldx, mpreal *y, mpreal *z, mpreal *q, mplapackint const ldq, mpreal *pt, mplapackint const ldpt, mpreal *u, mpreal *vt, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rchkbk(mplapackint const nin, mplapackint const nout);
void Rchkbl(mplapackint const nin, mplapackint const nout);
void Rchkec(mpreal const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Rchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, bool const tstdif, mpreal const thrshn, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *b, mpreal *h, mpreal *t, mpreal *s1, mpreal *s2, mpreal *p1, mpreal *p2, mpreal *u, mplapackint const ldu, mpreal *v, mpreal *q, mpreal *z, mpreal *alphr1, mpreal *alphi1, mpreal *beta1, mpreal *alphr3, mpreal *alphi3, mpreal *beta3, mpreal *evectl, mpreal *evectr, mpreal *work, mplapackint const lwork, bool *llwork, mpreal *result, mplapackint &info);
void Rchkgk(mplapackint const nin, mplapackint const nout);
void Rchkgl(mplapackint const nin, mplapackint const nout);
void Rchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *h, mpreal *t1, mpreal *t2, mpreal *u, mplapackint const ldu, mpreal *z, mpreal *uz, mpreal *wr1, mpreal *wi1, mpreal *wr2, mpreal *wi2, mpreal *wr3, mpreal *wi3, mpreal *evectl, mpreal *evectr, mpreal *evecty, mpreal *evectx, mpreal *uu, mpreal *tau, mpreal *work, mplapackint const nwork, mplapackint *iwork, bool *select, mpreal *result, mplapackint &info);
void Rchksb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *sd, mpreal *se, mpreal *u, mplapackint const ldu, mpreal *work, mplapackint const lwork, mpreal *result, mplapackint &info);
void Rchksb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *sd, mpreal *se, mpreal *d1, mpreal *d2, mpreal *d3, mpreal *u, mplapackint const ldu, mpreal *work, mplapackint const lwork, mpreal *result, mplapackint &info);
void Rchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *ap, mpreal *sd, mpreal *se, mpreal *d1, mpreal *d2, mpreal *d3, mpreal *d4, mpreal *d5, mpreal *wa1, mpreal *wa2, mpreal *wa3, mpreal *wr, mpreal *u, mplapackint const ldu, mpreal *v, mpreal *vp, mpreal *tau, mpreal *z, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, mplapackint &info);
void Rchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *ap, mpreal *sd, mpreal *se, mpreal *d1, mpreal *d2, mpreal *d3, mpreal *d4, mpreal *d5, mpreal *wa1, mpreal *wa2, mpreal *wa3, mpreal *wr, mpreal *u, mplapackint const ldu, mpreal *v, mpreal *vp, mpreal *tau, mpreal *z, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, mplapackint &info);
void Rckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, mpreal const thresh, mplapackint const mmax, mpreal *x, mpreal *xf, mpreal *u1, mpreal *u2, mpreal *v1t, mpreal *v2t, mpreal *theta, mplapackint *iwork, mpreal *work, mpreal *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckglm(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpreal const thresh, mplapackint const nmax, mpreal *a, mpreal *af, mpreal *b, mpreal *bf, mpreal *x, mpreal *work, mpreal *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpreal const thresh, mplapackint const nmax, mpreal *a, mpreal *af, mpreal *aq, mpreal *ar, mpreal *taua, mpreal *b, mpreal *bf, mpreal *bz, mpreal *bt, mpreal *bwk, mpreal *taub, mpreal *work, mpreal *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpreal const thresh, mplapackint const nmax, mpreal *a, mpreal *af, mpreal *b, mpreal *bf, mpreal *u, mpreal *v, mpreal *q, mpreal *alpha, mpreal *beta, mpreal *r, mplapackint *iwork, mpreal *work, mpreal *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, mpreal const thresh, mplapackint const nmax, mpreal *a, mpreal *af, mpreal *b, mpreal *bf, mpreal *x, mpreal *work, mpreal *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcsdts(mplapackint const m, mplapackint const p, mplapackint const q, mpreal *x, mpreal *xf, mplapackint const ldx, mpreal *u1, mplapackint const ldu1, mpreal *u2, mplapackint const ldu2, mpreal *v1t, mplapackint const ldv1t, mpreal *v2t, mplapackint const ldv2t, mpreal *theta, mplapackint *iwork, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *b, mpreal *s, mpreal *t, mpreal *q, mplapackint const ldq, mpreal *z, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *work, mplapackint const lwork, mpreal *result, bool *bwork, mplapackint &info);
void Rdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *b, mpreal *s, mpreal *t, mpreal *q, mplapackint const ldq, mpreal *z, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *work, mplapackint const lwork, mpreal *result, bool *bwork, mplapackint &info);
void Rdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *b, mpreal *s, mpreal *t, mpreal *q, mplapackint const ldq, mpreal *z, mpreal *qe, mplapackint const ldqe, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *alphr1, mpreal *alphi1, mpreal *beta1, mpreal *work, mplapackint const lwork, mpreal *result, mplapackint &info);
void Rdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *b, mpreal *s, mpreal *t, mpreal *q, mplapackint const ldq, mpreal *z, mpreal *qe, mplapackint const ldqe, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *alphr1, mpreal *alphi1, mpreal *beta1, mpreal *work, mplapackint const lwork, mpreal *result, mplapackint &info);
void Rdrgsx(mplapackint const nsize, mplapackint const ncmax, mpreal const thresh, mplapackint const nin, mplapackint const nout, mpreal *a, mplapackint const lda, mpreal *b, mpreal *ai, mpreal *bi, mpreal *z, mpreal *q, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *c, mplapackint const ldc, mpreal *s, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rdrgvx(mplapackint const nsize, mpreal const thresh, mplapackint const nin, mplapackint const nout, mpreal *a, mplapackint const lda, mpreal *b, mpreal *ai, mpreal *bi, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *vl, mpreal *vr, mplapackint const ilo, mplapackint const ihi, mpreal *lscale, mpreal *rscale, mpreal *s, mpreal *dtru, mpreal *dif, mpreal *diftru, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, bool *bwork, mplapackint &info);
void Rdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mpreal *a, mplapackint const lda, mpreal *u, mplapackint const ldu, mpreal *vt, mplapackint const ldvt, mpreal *asav, mpreal *usav, mpreal *vtsav, mpreal *s, mpreal *ssav, mpreal *e, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *h, mpreal *ht, mpreal *wr, mpreal *wi, mpreal *wrt, mpreal *wit, mpreal *vs, mplapackint const ldvs, mpreal *result, mpreal *work, mplapackint const nwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *h, mpreal *wr, mpreal *wi, mpreal *wr1, mpreal *wi1, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mpreal *lre, mplapackint const ldlre, mpreal *result, mpreal *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *d, mpreal *z, mplapackint const ldz, mpreal *ab, mpreal *bb, mpreal *ap, mpreal *bp, mpreal *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, mplapackint &info);
void Rdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *d, mpreal *d2, mpreal *z, mplapackint const ldz, mpreal *ab, mpreal *bb, mpreal *ap, mpreal *bp, mpreal *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, mplapackint &info);
void Rdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *d1, mpreal *d2, mpreal *d3, mpreal *d4, mpreal *eveigs, mpreal *wa1, mpreal *wa2, mpreal *wa3, mpreal *u, mplapackint const ldu, mpreal *v, mpreal *tau, mpreal *z, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, mplapackint &info);
void Rdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *d1, mpreal *d2, mpreal *d3, mpreal *d4, mpreal *eveigs, mpreal *wa1, mpreal *wa2, mpreal *wa3, mpreal *u, mplapackint const ldu, mpreal *v, mpreal *tau, mpreal *z, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mpreal *result, mplapackint &info);
void Rdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const niunit, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *h, mpreal *ht, mpreal *wr, mpreal *wi, mpreal *wrt, mpreal *wit, mpreal *wrtmp, mpreal *witmp, mpreal *vs, mplapackint const ldvs, mpreal *vs1, mpreal *result, mpreal *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, mpreal const thresh, mplapackint const niunit, mplapackint const nounit, mpreal *a, mplapackint const lda, mpreal *h, mpreal *wr, mpreal *wi, mpreal *wr1, mpreal *wi1, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mpreal *lre, mplapackint const ldlre, mpreal *rcondv, mpreal *rcndv1, mpreal *rcdvin, mpreal *rconde, mpreal *rcnde1, mpreal *rcdein, mpreal *scale, mpreal *scale1, mpreal *result, mpreal *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rerrbd(const char *path, mplapackint const nunit);
void Rerrec(const char *path, mplapackint const nunit);
void Rerred(const char *path, mplapackint const nunit);
void Rerrgg(const char *path, mplapackint const nunit);
void Rerrhs(const char *path, mplapackint const nunit);
void Rerrst(const char *path, mplapackint const nunit);
void Rget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mpreal *rwork, mpreal &resid);
void Rget10(mplapackint const m, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *work, mpreal &result);
void Rget22(const char *transa, const char *transe, const char *transw, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *e, mplapackint const lde, mpreal *wr, mpreal *wi, mpreal *work, mpreal *result);
void Rget23(bool const comp, const char *balanc, mplapackint const jtype, mpreal const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *h, mpreal *wr, mpreal *wi, mpreal *wr1, mpreal *wi1, mpreal *vl, mplapackint const ldvl, mpreal *vr, mplapackint const ldvr, mpreal *lre, mplapackint const ldlre, mpreal *rcondv, mpreal *rcndv1, mpreal *rcdvin, mpreal *rconde, mpreal *rcnde1, mpreal *rcdein, mpreal *scale, mpreal *scale1, mpreal *result, mpreal *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rget24(bool const comp, mplapackint const jtype, mpreal const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *h, mpreal *ht, mpreal *wr, mpreal *wi, mpreal *wrt, mpreal *wit, mpreal *wrtmp, mpreal *witmp, mpreal *vs, mplapackint const ldvs, mpreal *vs1, mpreal const rcdein, mpreal const rcdvin, mplapackint const nslct, mplapackint *islct, mpreal *result, mpreal *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rget31(mpreal &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget32(mpreal &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget33(mpreal &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget34(mpreal &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget35(mpreal &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget36(mpreal &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget37(mpreal *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget38(mpreal *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget39(mpreal &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget40(mpreal &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget51(mplapackint const itype, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *u, mplapackint const ldu, mpreal *v, mplapackint const ldv, mpreal *work, mpreal &result);
void Rget52(bool const left, mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *e, mplapackint const lde, mpreal *alphar, mpreal *alphai, mpreal *beta, mpreal *work, mpreal *result);
void Rget53(mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal const scale, mpreal const wr, mpreal const wi, mpreal &result, mplapackint &info);
void Rget54(mplapackint const n, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *s, mplapackint const lds, mpreal *t, mplapackint const ldt, mpreal *u, mplapackint const ldu, mpreal *v, mplapackint const ldv, mpreal *work, mpreal &result);
void Rglmts(mplapackint const n, mplapackint const m, mplapackint const p, mpreal *a, mpreal *af, mplapackint const lda, mpreal *b, mpreal *bf, mplapackint const ldb, mpreal *d, mpreal *df, mpreal *x, mpreal *u, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal &result);
void Rgqrts(mplapackint const n, mplapackint const m, mplapackint const p, mpreal *a, mpreal *af, mpreal *q, mpreal *r, mplapackint const lda, mpreal *taua, mpreal *b, mpreal *bf, mpreal *z, mpreal *t, mpreal *bwk, mplapackint const ldb, mpreal *taub, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rgrqts(mplapackint const m, mplapackint const p, mplapackint const n, mpreal *a, mpreal *af, mpreal *q, mpreal *r, mplapackint const lda, mpreal *taua, mpreal *b, mpreal *bf, mpreal *z, mpreal *t, mpreal *bwk, mplapackint const ldb, mpreal *taub, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, mpreal *a, mpreal *af, mplapackint const lda, mpreal *b, mpreal *bf, mplapackint const ldb, mpreal *u, mplapackint const ldu, mpreal *v, mplapackint const ldv, mpreal *q, mplapackint const ldq, mpreal *alpha, mpreal *beta, mpreal *r, mplapackint const ldr, mplapackint *iwork, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rhst01(mplapackint const n, mplapackint const, mplapackint const, mpreal *a, mplapackint const lda, mpreal *h, mplapackint const ldh, mpreal *q, mplapackint const ldq, mpreal *work, mplapackint const lwork, mpreal *result);
void Rlacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, mpreal *theta, mplapackint *iseed, mpreal *x, mplapackint const &ldx, mpreal *work);
void Rlafts(const char *type, mplapackint const m, mplapackint const n, mplapackint const imat, mplapackint const ntests, mpreal *result, mplapackint *iseed, mpreal const thresh, mplapackint const iounit, mplapackint &ie);
void Rlahd2(mplapackint const iounit, const char *path);
void Rlarfy(const char *uplo, mplapackint const n, mpreal *v, mplapackint const incv, mpreal const tau, mpreal *c, mplapackint const ldc, mpreal *work);
void Rlarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpreal *a, mplapackint const lda, mpreal *x, mplapackint const ldx, mpreal *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Rlasum(const char *type, mplapackint const iounit, mplapackint const ie, mplapackint const nrun);
void Rlatb9(const char *path, mplapackint const imat, mplapackint const m, mplapackint const p, mplapackint const n, char *type, mplapackint &kla, mplapackint &kua, mplapackint &klb, mplapackint &kub, mpreal &anorm, mpreal &bnorm, mplapackint &modea, mplapackint &modeb, mpreal &cndnma, mpreal &cndnmb, char *dista, char *distb);
void Rlatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, mplapackint const isign, mpreal const amagn, mpreal const rcond, mpreal const triang, mplapackint const idist, mplapackint *iseed, mpreal *a, mplapackint const lda);
void Rlsets(mplapackint const m, mplapackint const p, mplapackint const n, mpreal *a, mpreal *af, mplapackint const lda, mpreal *b, mpreal *bf, mplapackint const ldb, mpreal *c, mpreal *cf, mpreal *d, mpreal *df, mpreal *x, mpreal *work, mplapackint const lwork, mpreal *rwork, mpreal *result);
void Rort01(const char *rowcol, mplapackint const m, mplapackint const n, mpreal *u, mplapackint const ldu, mpreal *work, mplapackint const lwork, mpreal &resid);
void Rort03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, mpreal *u, mplapackint const ldu, mpreal *v, mplapackint const ldv, mpreal *work, mplapackint const lwork, mpreal &result, mplapackint &info);
void Rsbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, mpreal *a, mplapackint const lda, mpreal *d, mpreal *e, mpreal *u, mplapackint const ldu, mpreal *work, mpreal *result);
void Rsgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mpreal *a, mplapackint const lda, mpreal *b, mplapackint const ldb, mpreal *z, mplapackint const ldz, mpreal *d, mpreal *work, mpreal *result);
void Rspt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, mpreal *ap, mpreal *d, mpreal *e, mpreal *u, mplapackint const ldu, mpreal *vp, mpreal *tau, mpreal *work, mpreal *result);
void Rstech(mplapackint const n, mpreal *a, mpreal *b, mpreal *eig, mpreal const tol, mpreal *work, mplapackint &info);
void Rstect(mplapackint const n, mpreal *a, mpreal *b, mpreal const shift, mplapackint &num);
void Rstt21(mplapackint const n, mplapackint const kband, mpreal *ad, mpreal *ae, mpreal *sd, mpreal *se, mpreal *u, mplapackint const ldu, mpreal *work, mpreal *result);
void Rstt22(mplapackint const n, mplapackint const m, mplapackint const kband, mpreal *ad, mpreal *ae, mpreal *sd, mpreal *se, mpreal *u, mplapackint const ldu, mpreal *work, mplapackint const ldwork, mpreal *result);
void Rsvdch(mplapackint const n, mpreal *s, mpreal *e, mpreal *svd, mpreal const tol, mplapackint &info);
void Rsvdct(mplapackint const n, mpreal *s, mpreal *e, mpreal const shift, mplapackint &num);
void Rsyt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, mpreal *a, mplapackint const lda, mpreal *d, mpreal *e, mpreal *u, mplapackint const ldu, mpreal *v, mplapackint const ldv, mpreal *tau, mpreal *work, mpreal *result);
void Rsyt22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, mpreal *a, mplapackint const lda, mpreal *d, mpreal *e, mpreal *u, mplapackint const ldu, mpreal *, mplapackint const ldv, mpreal *, mpreal *work, mpreal *result);
void chkxer(const char *srnamt, mplapackint const &infot, mplapackint const &nout, bool &lerr, bool &ok);
void xlaenv(mplapackint const &ispec, mplapackint const &nvalue);
#endif
