/*
 * Copyright (c) 2008-2021
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mplapack_double.h,v 1.4 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_EIG_DOUBLE_H_
#define _MPLAPACK_EIG_DOUBLE_H_

#include "mplapack_config.h"

bool Clctes(std::complex<double> const z, std::complex<double> const d);
bool Clctsx(std::complex<double> const, std::complex<double> const);
bool Cslect(std::complex<double> const z);
bool Rlctes(double const zr, double const zi, double const d);
bool Rlctsx(double const, double const, double const);
bool Rslect(double const zr, double const zi);
double Rlamch_double(const char *cmach);
double Rsxt1(mplapackint const ijob, double *d1, mplapackint const n1, double *d2, mplapackint const n2, double const abstol, double const ulp, double const unfl);
mplapackint iMlaenv2stage_double(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv_double(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
void Alahdg(mplapackint const iounit, const char *path);
void Alareq(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alarqg(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alasmg(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasum(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasvm(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Cbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, std::complex<double> *a, mplapackint const lda, std::complex<double> *q, mplapackint const ldq, double *d, double *e, std::complex<double> *pt, mplapackint const ldpt, std::complex<double> *work, double *rwork, double &resid);
void Cbdt02(mplapackint const m, mplapackint const n, std::complex<double> *b, mplapackint const ldb, std::complex<double> *c, mplapackint const ldc, std::complex<double> *u, mplapackint const ldu, std::complex<double> *work, double *rwork, double &resid);
void Cbdt03(const char *uplo, mplapackint const n, mplapackint const kd, double *d, double *e, std::complex<double> *u, mplapackint const ldu, double *s, std::complex<double> *vt, mplapackint const ldvt, std::complex<double> *work, double &resid);
void Cbdt05(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *s, mplapackint const ns, std::complex<double> *u, mplapackint const ldu, std::complex<double> *vt, mplapackint const ldvt, std::complex<double> *work, double &resid);
void Cchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *ab, mplapackint const ldab, double *bd, double *be, std::complex<double> *q, mplapackint const ldq, std::complex<double> *p, mplapackint const ldp, std::complex<double> *c, mplapackint const ldc, std::complex<double> *cc, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result, mplapackint &info);
void Cchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, double const thresh, std::complex<double> *a, mplapackint const lda, double *bd, double *be, double *s1, double *s2, std::complex<double> *x, mplapackint const ldx, std::complex<double> *y, std::complex<double> *z, std::complex<double> *q, mplapackint const ldq, std::complex<double> *pt, mplapackint const ldpt, std::complex<double> *u, std::complex<double> *vt, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const nout, mplapackint &info);
void Cchkbk(mplapackint const nin, mplapackint const nout);
void Cchkbl(mplapackint const nin, mplapackint const nout);
void Cchkec(double const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Cchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, bool const tstdif, double const thrshn, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, std::complex<double> *h, std::complex<double> *t, std::complex<double> *s1, std::complex<double> *s2, std::complex<double> *p1, std::complex<double> *p2, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, std::complex<double> *q, std::complex<double> *z, std::complex<double> *alpha1, std::complex<double> *beta1, std::complex<double> *alpha3, std::complex<double> *beta3, std::complex<double> *evectl, std::complex<double> *evectr, std::complex<double> *work, mplapackint const lwork, double *rwork, bool *llwork, double *result, mplapackint &info);
void Cchkgk(mplapackint const nin, mplapackint const nout);
void Cchkgl(mplapackint const nin, mplapackint const nout);
void Cchkhb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, double *sd, double *se, std::complex<double> *u, mplapackint const ldu, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result, mplapackint &info);
void Cchkhb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, double *sd, double *se, double *d1, double *d2, double *d3, std::complex<double> *u, mplapackint const ldu, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result, mplapackint &info);
void Cchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *h, std::complex<double> *t1, std::complex<double> *t2, std::complex<double> *u, mplapackint const ldu, std::complex<double> *z, std::complex<double> *uz, std::complex<double> *w1, std::complex<double> *w3, std::complex<double> *evectl, std::complex<double> *evectr, std::complex<double> *evecty, std::complex<double> *evectx, std::complex<double> *uu, std::complex<double> *tau, std::complex<double> *work, mplapackint const nwork, double *rwork, mplapackint *iwork, bool *select, double *result, mplapackint &info);
void Cchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *ap, double *sd, double *se, double *d1, double *d2, double *d3, double *d4, double *d5, double *wa1, double *wa2, double *wa3, double *wr, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, std::complex<double> *vp, std::complex<double> *tau, std::complex<double> *z, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, double *result, mplapackint &info);
void Cchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *ap, double *sd, double *se, double *d1, double *d2, double *d3, double *d4, double *d5, double *wa1, double *wa2, double *wa3, double *wr, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, std::complex<double> *vp, std::complex<double> *tau, std::complex<double> *z, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, double *result, mplapackint &info);
void Cckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, double const thresh, mplapackint const mmax, std::complex<double> *x, std::complex<double> *xf, std::complex<double> *u1, std::complex<double> *u2, std::complex<double> *v1t, std::complex<double> *v2t, double *theta, mplapackint *iwork, std::complex<double> *work, double *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckglm(mplapackint const nn, mplapackint *nval, mplapackint *mval, mplapackint *pval, mplapackint const nmats, mplapackint *iseed, double const thresh, mplapackint const nmax, std::complex<double> *a, std::complex<double> *af, std::complex<double> *b, std::complex<double> *bf, std::complex<double> *x, std::complex<double> *work, double *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, double const thresh, mplapackint const nmax, std::complex<double> *a, std::complex<double> *af, std::complex<double> *aq, std::complex<double> *ar, std::complex<double> *taua, std::complex<double> *b, std::complex<double> *bf, std::complex<double> *bz, std::complex<double> *bt, std::complex<double> *bwk, std::complex<double> *taub, std::complex<double> *work, double *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, double const thresh, mplapackint const nmax, std::complex<double> *a, std::complex<double> *af, std::complex<double> *b, std::complex<double> *bf, std::complex<double> *u, std::complex<double> *v, std::complex<double> *q, double *alpha, double *beta, std::complex<double> *r, mplapackint *iwork, std::complex<double> *work, double *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, double const thresh, mplapackint const nmax, std::complex<double> *a, std::complex<double> *af, std::complex<double> *b, std::complex<double> *bf, std::complex<double> *x, std::complex<double> *work, double *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccsdts(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<double> *x, std::complex<double> *xf, mplapackint const ldx, std::complex<double> *u1, mplapackint const ldu1, std::complex<double> *u2, mplapackint const ldu2, std::complex<double> *v1t, mplapackint const ldv1t, std::complex<double> *v2t, mplapackint const ldv2t, double *theta, mplapackint *iwork, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Cdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, std::complex<double> *s, std::complex<double> *t, std::complex<double> *q, mplapackint const ldq, std::complex<double> *z, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result, bool *bwork, mplapackint &info);
void Cdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, std::complex<double> *s, std::complex<double> *t, std::complex<double> *q, mplapackint const ldq, std::complex<double> *z, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result, bool *bwork, mplapackint &info);
void Cdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, std::complex<double> *s, std::complex<double> *t, std::complex<double> *q, mplapackint const ldq, std::complex<double> *z, std::complex<double> *qe, mplapackint const ldqe, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *alpha1, std::complex<double> *beta1, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result, mplapackint &info);
void Cdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, std::complex<double> *s, std::complex<double> *t, std::complex<double> *q, mplapackint const ldq, std::complex<double> *z, std::complex<double> *qe, mplapackint const ldqe, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *alpha1, std::complex<double> *beta1, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result, mplapackint &info);
void Cdrgsx(mplapackint const nsize, mplapackint const ncmax, double const thresh, mplapackint const nin, mplapackint const nout, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, std::complex<double> *ai, std::complex<double> *bi, std::complex<double> *z, std::complex<double> *q, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *c, mplapackint const ldc, double *s, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Cdrgvx(mplapackint const nsize, double const thresh, mplapackint const nin, mplapackint const nout, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, std::complex<double> *ai, std::complex<double> *bi, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *vl, std::complex<double> *vr, mplapackint &ilo, mplapackint &ihi, double *lscale, double *rscale, double *s, double *dtru, double *dif, double *diftru, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint *iwork, mplapackint const liwork, double *result, bool *bwork, mplapackint &info);
void Cdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, std::complex<double> *a, mplapackint const lda, std::complex<double> *u, mplapackint const ldu, std::complex<double> *vt, mplapackint const ldvt, std::complex<double> *asav, std::complex<double> *usav, std::complex<double> *vtsav, double *s, double *ssav, double *e, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint *iwork, mplapackint const nounit, mplapackint &info);
void Cdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *h, std::complex<double> *ht, std::complex<double> *w, std::complex<double> *wt, std::complex<double> *vs, mplapackint const ldvs, double *result, std::complex<double> *work, mplapackint const nwork, double *rwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Cdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *h, std::complex<double> *w, std::complex<double> *w1, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, std::complex<double> *lre, mplapackint const ldlre, double *result, std::complex<double> *work, mplapackint const nwork, double *rwork, mplapackint *iwork, mplapackint &info);
void Cdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, double *d, std::complex<double> *z, mplapackint const ldz, std::complex<double> *ab, std::complex<double> *bb, std::complex<double> *ap, std::complex<double> *bp, std::complex<double> *work, mplapackint const nwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, double *result, mplapackint &info);
void Cdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, double *d, double *d2, std::complex<double> *z, mplapackint const ldz, std::complex<double> *ab, std::complex<double> *bb, std::complex<double> *ap, std::complex<double> *bp, std::complex<double> *work, mplapackint const nwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, double *result, mplapackint &info);
void Cdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, double *d1, double *d2, double *d3, double *wa1, double *wa2, double *wa3, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, std::complex<double> *tau, std::complex<double> *z, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, double *result, mplapackint &info);
void Cdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, double *d1, double *d2, double *d3, double *wa1, double *wa2, double *wa3, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, std::complex<double> *tau, std::complex<double> *z, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, double *result, mplapackint &info);
void Cdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const niunit, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *h, std::complex<double> *ht, std::complex<double> *w, std::complex<double> *wt, std::complex<double> *wtmp, std::complex<double> *vs, mplapackint const ldvs, std::complex<double> *vs1, double *result, std::complex<double> *work, mplapackint const lwork, double *rwork, bool *bwork, mplapackint &info);
void Cdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const niunit, mplapackint const nounit, std::complex<double> *a, mplapackint const lda, std::complex<double> *h, std::complex<double> *w, std::complex<double> *w1, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, std::complex<double> *lre, mplapackint const ldlre, double *rcondv, double *rcndv1, double *rcdvin, double *rconde, double *rcnde1, double *rcdein, double *scale, double *scale1, double *result, std::complex<double> *work, mplapackint const nwork, double *rwork, mplapackint &info);
void Cerrbd(const char *path, mplapackint const nunit);
void Cerrec(const char *path, mplapackint const nunit);
void Cerred(const char *path, mplapackint const nunit);
void Cerrgg(const char *path, mplapackint const nunit);
void Cerrhs(const char *path, mplapackint const nunit);
void Cerrst(const char *path, mplapackint const nunit);
void Cget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double *rwork, double &resid);
void Cget10(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, double *rwork, double &result);
void Cget22(const char *transa, const char *transe, const char *transw, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint const lde, std::complex<double> *w, std::complex<double> *work, double *rwork, double *result);
void Cget23(bool const comp, mplapackint const isrt, const char *balanc, mplapackint const jtype, double const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *h, std::complex<double> *w, std::complex<double> *w1, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, std::complex<double> *lre, mplapackint const ldlre, double *rcondv, double *rcndv1, double *rcdvin, double *rconde, double *rcnde1, double *rcdein, double *scale, double *scale1, double *result, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Cget24(bool const comp, mplapackint const jtype, double const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *h, std::complex<double> *ht, std::complex<double> *w, std::complex<double> *wt, std::complex<double> *wtmp, std::complex<double> *vs, mplapackint const ldvs, std::complex<double> *vs1, double const rcdein, double const rcdvin, mplapackint const nslct, mplapackint *islct, mplapackint const isrt, double *result, std::complex<double> *work, mplapackint const lwork, double *rwork, bool *bwork, mplapackint &info);
void Cget35(double &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget36(double &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget37(double *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget38(double *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget51(mplapackint const itype, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, mplapackint const ldv, std::complex<double> *work, double *rwork, double &result);
void Cget52(bool const left, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *e, mplapackint const lde, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *work, double *rwork, double *result);
void Cget54(mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *s, mplapackint const lds, std::complex<double> *t, mplapackint const ldt, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, mplapackint const ldv, std::complex<double> *work, double &result);
void Cglmts(mplapackint const n, mplapackint const m, mplapackint const p, std::complex<double> *a, std::complex<double> *af, mplapackint const lda, std::complex<double> *b, std::complex<double> *bf, mplapackint const ldb, std::complex<double> *d, std::complex<double> *df, std::complex<double> *x, std::complex<double> *u, std::complex<double> *work, mplapackint const lwork, double *rwork, double &result);
void Cgqrts(mplapackint const n, mplapackint const m, mplapackint const p, std::complex<double> *a, std::complex<double> *af, std::complex<double> *q, std::complex<double> *r, mplapackint const lda, std::complex<double> *taua, std::complex<double> *b, std::complex<double> *bf, std::complex<double> *z, std::complex<double> *t, std::complex<double> *bwk, mplapackint const ldb, std::complex<double> *taub, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Cgrqts(mplapackint const m, mplapackint const p, mplapackint const n, std::complex<double> *a, std::complex<double> *af, std::complex<double> *q, std::complex<double> *r, mplapackint const lda, std::complex<double> *taua, std::complex<double> *b, std::complex<double> *bf, std::complex<double> *z, std::complex<double> *t, std::complex<double> *bwk, mplapackint const ldb, std::complex<double> *taub, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Cgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, std::complex<double> *a, std::complex<double> *af, mplapackint const lda, std::complex<double> *b, std::complex<double> *bf, mplapackint const ldb, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, mplapackint const ldv, std::complex<double> *q, mplapackint const ldq, double *alpha, double *beta, std::complex<double> *r, mplapackint const ldr, mplapackint *iwork, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Chbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, std::complex<double> *a, mplapackint const lda, double *d, double *e, std::complex<double> *u, mplapackint const ldu, std::complex<double> *work, double *rwork, double *result);
void Chet21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, std::complex<double> *a, mplapackint const lda, double *d, double *e, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, mplapackint const ldv, std::complex<double> *tau, std::complex<double> *work, double *rwork, double *result);
void Chet22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, std::complex<double> *a, mplapackint const lda, double *d, double *e, std::complex<double> *u, mplapackint const ldu, std::complex<double> *, mplapackint const ldv, std::complex<double> *, std::complex<double> *work, double *rwork, double *result);
void Chpt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, std::complex<double> *ap, double *d, double *e, std::complex<double> *u, mplapackint const ldu, std::complex<double> *vp, std::complex<double> *tau, std::complex<double> *work, double *rwork, double *result);
void Chst01(mplapackint const n, mplapackint const, mplapackint const, std::complex<double> *a, mplapackint const lda, std::complex<double> *h, mplapackint const ldh, std::complex<double> *q, mplapackint const ldq, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Clacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, double *theta, mplapackint *iseed, std::complex<double> *x, mplapackint const &ldx, std::complex<double> *work);
void Clarfy(const char *uplo, mplapackint const n, std::complex<double> *v, mplapackint const incv, std::complex<double> const tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work);
void Clarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Clatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, bool const rsign, double const amagn, double const rcond, double const triang, mplapackint const idist, mplapackint *iseed, std::complex<double> *a, mplapackint const lda);
void Clsets(mplapackint const m, mplapackint const p, mplapackint const n, std::complex<double> *a, std::complex<double> *af, mplapackint const lda, std::complex<double> *b, std::complex<double> *bf, mplapackint const ldb, std::complex<double> *c, std::complex<double> *cf, std::complex<double> *d, std::complex<double> *df, std::complex<double> *x, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Csbmv(const char *uplo, mplapackint const n, mplapackint const k, std::complex<double> const alpha, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const incx, std::complex<double> const beta, std::complex<double> *y, mplapackint const incy);
void Csgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *z, mplapackint const ldz, double *d, std::complex<double> *work, double *rwork, double *result);
void Cstt21(mplapackint const n, mplapackint const kband, double *ad, double *ae, double *sd, double *se, std::complex<double> *u, mplapackint const ldu, std::complex<double> *work, double *rwork, double *result);
void Cstt22(mplapackint const n, mplapackint const m, mplapackint const kband, double *ad, double *ae, double *sd, double *se, std::complex<double> *u, mplapackint const ldu, std::complex<double> *work, mplapackint const ldwork, double *rwork, double *result);
void Cunt01(const char *rowcol, mplapackint const m, mplapackint const n, std::complex<double> *u, mplapackint const ldu, std::complex<double> *work, mplapackint const lwork, double *rwork, double &resid);
void Cunt03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, mplapackint const ldv, std::complex<double> *work, mplapackint const lwork, double *rwork, double &result, mplapackint &info);
void Mxerbla_double(const char *srname, int info);
void Rbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, double *a, mplapackint const lda, double *q, mplapackint const ldq, double *d, double *e, double *pt, mplapackint const ldpt, double *work, double &resid);
void Rbdt02(mplapackint const m, mplapackint const n, double *b, mplapackint const ldb, double *c, mplapackint const ldc, double *u, mplapackint const ldu, double *work, double &resid);
void Rbdt03(const char *uplo, mplapackint const n, mplapackint const kd, double *d, double *e, double *u, mplapackint const ldu, double *s, double *vt, mplapackint const ldvt, double *work, double &resid);
void Rbdt04(const char *uplo, mplapackint const n, double *d, double *e, double *s, mplapackint const ns, double *u, mplapackint const ldu, double *vt, mplapackint const ldvt, double *work, double &resid);
void Rbdt05(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *s, mplapackint const ns, double *u, mplapackint const ldu, double *vt, mplapackint const ldvt, double *work, double &resid);
void Rchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *ab, mplapackint const ldab, double *bd, double *be, double *q, mplapackint const ldq, double *p, mplapackint const ldp, double *c, mplapackint const ldc, double *cc, double *work, mplapackint const lwork, double *result, mplapackint &info);
void Rchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, double const thresh, double *a, mplapackint const lda, double *bd, double *be, double *s1, double *s2, double *x, mplapackint const ldx, double *y, double *z, double *q, mplapackint const ldq, double *pt, mplapackint const ldpt, double *u, double *vt, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rchkbk(mplapackint const nin, mplapackint const nout);
void Rchkbl(mplapackint const nin, mplapackint const nout);
void Rchkec(double const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Rchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, bool const tstdif, double const thrshn, mplapackint const nounit, double *a, mplapackint const lda, double *b, double *h, double *t, double *s1, double *s2, double *p1, double *p2, double *u, mplapackint const ldu, double *v, double *q, double *z, double *alphr1, double *alphi1, double *beta1, double *alphr3, double *alphi3, double *beta3, double *evectl, double *evectr, double *work, mplapackint const lwork, bool *llwork, double *result, mplapackint &info);
void Rchkgk(mplapackint const nin, mplapackint const nout);
void Rchkgl(mplapackint const nin, mplapackint const nout);
void Rchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *h, double *t1, double *t2, double *u, mplapackint const ldu, double *z, double *uz, double *wr1, double *wi1, double *wr2, double *wi2, double *wr3, double *wi3, double *evectl, double *evectr, double *evecty, double *evectx, double *uu, double *tau, double *work, mplapackint const nwork, mplapackint *iwork, bool *select, double *result, mplapackint &info);
void Rchksb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *sd, double *se, double *u, mplapackint const ldu, double *work, mplapackint const lwork, double *result, mplapackint &info);
void Rchksb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *sd, double *se, double *d1, double *d2, double *d3, double *u, mplapackint const ldu, double *work, mplapackint const lwork, double *result, mplapackint &info);
void Rchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *ap, double *sd, double *se, double *d1, double *d2, double *d3, double *d4, double *d5, double *wa1, double *wa2, double *wa3, double *wr, double *u, mplapackint const ldu, double *v, double *vp, double *tau, double *z, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, double *result, mplapackint &info);
void Rchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *ap, double *sd, double *se, double *d1, double *d2, double *d3, double *d4, double *d5, double *wa1, double *wa2, double *wa3, double *wr, double *u, mplapackint const ldu, double *v, double *vp, double *tau, double *z, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, double *result, mplapackint &info);
void Rckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, double const thresh, mplapackint const mmax, double *x, double *xf, double *u1, double *u2, double *v1t, double *v2t, double *theta, mplapackint *iwork, double *work, double *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckglm(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, double const thresh, mplapackint const nmax, double *a, double *af, double *b, double *bf, double *x, double *work, double *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, double const thresh, mplapackint const nmax, double *a, double *af, double *aq, double *ar, double *taua, double *b, double *bf, double *bz, double *bt, double *bwk, double *taub, double *work, double *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, double const thresh, mplapackint const nmax, double *a, double *af, double *b, double *bf, double *u, double *v, double *q, double *alpha, double *beta, double *r, mplapackint *iwork, double *work, double *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, double const thresh, mplapackint const nmax, double *a, double *af, double *b, double *bf, double *x, double *work, double *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcsdts(mplapackint const m, mplapackint const p, mplapackint const q, double *x, double *xf, mplapackint const ldx, double *u1, mplapackint const ldu1, double *u2, mplapackint const ldu2, double *v1t, mplapackint const ldv1t, double *v2t, mplapackint const ldv2t, double *theta, mplapackint *iwork, double *work, mplapackint const lwork, double *rwork, double *result);
void Rdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *b, double *s, double *t, double *q, mplapackint const ldq, double *z, double *alphar, double *alphai, double *beta, double *work, mplapackint const lwork, double *result, bool *bwork, mplapackint &info);
void Rdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *b, double *s, double *t, double *q, mplapackint const ldq, double *z, double *alphar, double *alphai, double *beta, double *work, mplapackint const lwork, double *result, bool *bwork, mplapackint &info);
void Rdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *b, double *s, double *t, double *q, mplapackint const ldq, double *z, double *qe, mplapackint const ldqe, double *alphar, double *alphai, double *beta, double *alphr1, double *alphi1, double *beta1, double *work, mplapackint const lwork, double *result, mplapackint &info);
void Rdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *b, double *s, double *t, double *q, mplapackint const ldq, double *z, double *qe, mplapackint const ldqe, double *alphar, double *alphai, double *beta, double *alphr1, double *alphi1, double *beta1, double *work, mplapackint const lwork, double *result, mplapackint &info);
void Rdrgsx(mplapackint const nsize, mplapackint const ncmax, double const thresh, mplapackint const nin, mplapackint const nout, double *a, mplapackint const lda, double *b, double *ai, double *bi, double *z, double *q, double *alphar, double *alphai, double *beta, double *c, mplapackint const ldc, double *s, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rdrgvx(mplapackint const nsize, double const thresh, mplapackint const nin, mplapackint const nout, double *a, mplapackint const lda, double *b, double *ai, double *bi, double *alphar, double *alphai, double *beta, double *vl, double *vr, mplapackint const ilo, mplapackint const ihi, double *lscale, double *rscale, double *s, double *dtru, double *dif, double *diftru, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, double *result, bool *bwork, mplapackint &info);
void Rdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, double *a, mplapackint const lda, double *u, mplapackint const ldu, double *vt, mplapackint const ldvt, double *asav, double *usav, double *vtsav, double *s, double *ssav, double *e, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *h, double *ht, double *wr, double *wi, double *wrt, double *wit, double *vs, mplapackint const ldvs, double *result, double *work, mplapackint const nwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *h, double *wr, double *wi, double *wr1, double *wi1, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, double *lre, mplapackint const ldlre, double *result, double *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *d, double *z, mplapackint const ldz, double *ab, double *bb, double *ap, double *bp, double *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, double *result, mplapackint &info);
void Rdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *d, double *d2, double *z, mplapackint const ldz, double *ab, double *bb, double *ap, double *bp, double *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, double *result, mplapackint &info);
void Rdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *d1, double *d2, double *d3, double *d4, double *eveigs, double *wa1, double *wa2, double *wa3, double *u, mplapackint const ldu, double *v, double *tau, double *z, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, double *result, mplapackint &info);
void Rdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const nounit, double *a, mplapackint const lda, double *d1, double *d2, double *d3, double *d4, double *eveigs, double *wa1, double *wa2, double *wa3, double *u, mplapackint const ldu, double *v, double *tau, double *z, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, double *result, mplapackint &info);
void Rdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const niunit, mplapackint const nounit, double *a, mplapackint const lda, double *h, double *ht, double *wr, double *wi, double *wrt, double *wit, double *wrtmp, double *witmp, double *vs, mplapackint const ldvs, double *vs1, double *result, double *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, double const thresh, mplapackint const niunit, mplapackint const nounit, double *a, mplapackint const lda, double *h, double *wr, double *wi, double *wr1, double *wi1, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, double *lre, mplapackint const ldlre, double *rcondv, double *rcndv1, double *rcdvin, double *rconde, double *rcnde1, double *rcdein, double *scale, double *scale1, double *result, double *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rerrbd(const char *path, mplapackint const nunit);
void Rerrec(const char *path, mplapackint const nunit);
void Rerred(const char *path, mplapackint const nunit);
void Rerrgg(const char *path, mplapackint const nunit);
void Rerrhs(const char *path, mplapackint const nunit);
void Rerrst(const char *path, mplapackint const nunit);
void Rget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *rwork, double &resid);
void Rget10(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *work, double &result);
void Rget22(const char *transa, const char *transe, const char *transw, mplapackint const n, double *a, mplapackint const lda, double *e, mplapackint const lde, double *wr, double *wi, double *work, double *result);
void Rget23(bool const comp, const char *balanc, mplapackint const jtype, double const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, double *a, mplapackint const lda, double *h, double *wr, double *wi, double *wr1, double *wi1, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, double *lre, mplapackint const ldlre, double *rcondv, double *rcndv1, double *rcdvin, double *rconde, double *rcnde1, double *rcdein, double *scale, double *scale1, double *result, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rget24(bool const comp, mplapackint const jtype, double const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, double *a, mplapackint const lda, double *h, double *ht, double *wr, double *wi, double *wrt, double *wit, double *wrtmp, double *witmp, double *vs, mplapackint const ldvs, double *vs1, double const rcdein, double const rcdvin, mplapackint const nslct, mplapackint *islct, double *result, double *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rget31(double &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget32(double &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget33(double &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget34(double &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget35(double &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget36(double &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget37(double *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget38(double *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget39(double &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget40(double &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget51(mplapackint const itype, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *u, mplapackint const ldu, double *v, mplapackint const ldv, double *work, double &result);
void Rget52(bool const left, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *e, mplapackint const lde, double *alphar, double *alphai, double *beta, double *work, double *result);
void Rget53(double *a, mplapackint const lda, double *b, mplapackint const ldb, double const scale, double const wr, double const wi, double &result, mplapackint &info);
void Rget54(mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *s, mplapackint const lds, double *t, mplapackint const ldt, double *u, mplapackint const ldu, double *v, mplapackint const ldv, double *work, double &result);
void Rglmts(mplapackint const n, mplapackint const m, mplapackint const p, double *a, double *af, mplapackint const lda, double *b, double *bf, mplapackint const ldb, double *d, double *df, double *x, double *u, double *work, mplapackint const lwork, double *rwork, double &result);
void Rgqrts(mplapackint const n, mplapackint const m, mplapackint const p, double *a, double *af, double *q, double *r, mplapackint const lda, double *taua, double *b, double *bf, double *z, double *t, double *bwk, mplapackint const ldb, double *taub, double *work, mplapackint const lwork, double *rwork, double *result);
void Rgrqts(mplapackint const m, mplapackint const p, mplapackint const n, double *a, double *af, double *q, double *r, mplapackint const lda, double *taua, double *b, double *bf, double *z, double *t, double *bwk, mplapackint const ldb, double *taub, double *work, mplapackint const lwork, double *rwork, double *result);
void Rgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, double *a, double *af, mplapackint const lda, double *b, double *bf, mplapackint const ldb, double *u, mplapackint const ldu, double *v, mplapackint const ldv, double *q, mplapackint const ldq, double *alpha, double *beta, double *r, mplapackint const ldr, mplapackint *iwork, double *work, mplapackint const lwork, double *rwork, double *result);
void Rhst01(mplapackint const n, mplapackint const, mplapackint const, double *a, mplapackint const lda, double *h, mplapackint const ldh, double *q, mplapackint const ldq, double *work, mplapackint const lwork, double *result);
void Rlacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, double *theta, mplapackint *iseed, double *x, mplapackint const &ldx, double *work);
void Rlafts(const char *type, mplapackint const m, mplapackint const n, mplapackint const imat, mplapackint const ntests, double *result, mplapackint *iseed, double const thresh, mplapackint const iounit, mplapackint &ie);
void Rlahd2(mplapackint const iounit, const char *path);
void Rlarfy(const char *uplo, mplapackint const n, double *v, mplapackint const incv, double const tau, double *c, mplapackint const ldc, double *work);
void Rlarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Rlasum(const char *type, mplapackint const iounit, mplapackint const ie, mplapackint const nrun);
void Rlatb9(const char *path, mplapackint const imat, mplapackint const m, mplapackint const p, mplapackint const n, char *type, mplapackint &kla, mplapackint &kua, mplapackint &klb, mplapackint &kub, double &anorm, double &bnorm, mplapackint &modea, mplapackint &modeb, double &cndnma, double &cndnmb, char *dista, char *distb);
void Rlatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, mplapackint const isign, double const amagn, double const rcond, double const triang, mplapackint const idist, mplapackint *iseed, double *a, mplapackint const lda);
void Rlsets(mplapackint const m, mplapackint const p, mplapackint const n, double *a, double *af, mplapackint const lda, double *b, double *bf, mplapackint const ldb, double *c, double *cf, double *d, double *df, double *x, double *work, mplapackint const lwork, double *rwork, double *result);
void Rort01(const char *rowcol, mplapackint const m, mplapackint const n, double *u, mplapackint const ldu, double *work, mplapackint const lwork, double &resid);
void Rort03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, double *u, mplapackint const ldu, double *v, mplapackint const ldv, double *work, mplapackint const lwork, double &result, mplapackint &info);
void Rsbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, double *a, mplapackint const lda, double *d, double *e, double *u, mplapackint const ldu, double *work, double *result);
void Rsgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *z, mplapackint const ldz, double *d, double *work, double *result);
void Rspt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, double *ap, double *d, double *e, double *u, mplapackint const ldu, double *vp, double *tau, double *work, double *result);
void Rstech(mplapackint const n, double *a, double *b, double *eig, double const tol, double *work, mplapackint &info);
void Rstect(mplapackint const n, double *a, double *b, double const shift, mplapackint &num);
void Rstt21(mplapackint const n, mplapackint const kband, double *ad, double *ae, double *sd, double *se, double *u, mplapackint const ldu, double *work, double *result);
void Rstt22(mplapackint const n, mplapackint const m, mplapackint const kband, double *ad, double *ae, double *sd, double *se, double *u, mplapackint const ldu, double *work, mplapackint const ldwork, double *result);
void Rsvdch(mplapackint const n, double *s, double *e, double *svd, double const tol, mplapackint &info);
void Rsvdct(mplapackint const n, double *s, double *e, double const shift, mplapackint &num);
void Rsyt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, double *a, mplapackint const lda, double *d, double *e, double *u, mplapackint const ldu, double *v, mplapackint const ldv, double *tau, double *work, double *result);
void Rsyt22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, double *a, mplapackint const lda, double *d, double *e, double *u, mplapackint const ldu, double *, mplapackint const ldv, double *, double *work, double *result);
void chkxer(const char *srnamt, mplapackint const &infot, mplapackint const &nout, bool &lerr, bool &ok);
void xlaenv(mplapackint const &ispec, mplapackint const &nvalue);
#endif
