/*
 * Copyright (c) 2012-2022
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_EIG__FLOAT64X_H_
#define _MPLAPACK_EIG__FLOAT64X_H_

#include "mplapack_config.h"

_Float64x Rlamch__Float64x(const char *cmach);
_Float64x Rsxt1(mplapackint const ijob, _Float64x *d1, mplapackint const n1, _Float64x *d2, mplapackint const n2, _Float64x const abstol, _Float64x const ulp, _Float64x const unfl);
bool Clctes(std::complex<_Float64x> const z, std::complex<_Float64x> const d);
bool Clctsx(std::complex<_Float64x> const, std::complex<_Float64x> const);
bool Cslect(std::complex<_Float64x> const z);
bool Rlctes(_Float64x const zr, _Float64x const zi, _Float64x const d);
bool Rlctsx(_Float64x const, _Float64x const, _Float64x const);
bool Rslect(_Float64x const zr, _Float64x const zi);
mplapackint iMlaenv2stage__Float64x(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv__Float64x(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
void Alahdg(mplapackint const iounit, const char *path);
void Alareq(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alarqg(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alasmg(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasum(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasvm(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Cbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *q, mplapackint const ldq, _Float64x *d, _Float64x *e, std::complex<_Float64x> *pt, mplapackint const ldpt, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x &resid);
void Cbdt02(mplapackint const m, mplapackint const n, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x &resid);
void Cbdt03(const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *d, _Float64x *e, std::complex<_Float64x> *u, mplapackint const ldu, _Float64x *s, std::complex<_Float64x> *vt, mplapackint const ldvt, std::complex<_Float64x> *work, _Float64x &resid);
void Cbdt05(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *s, mplapackint const ns, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *vt, mplapackint const ldvt, std::complex<_Float64x> *work, _Float64x &resid);
void Cchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *bd, _Float64x *be, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *p, mplapackint const ldp, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *cc, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result, mplapackint &info);
void Cchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, _Float64x const thresh, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *bd, _Float64x *be, _Float64x *s1, _Float64x *s2, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *y, std::complex<_Float64x> *z, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *pt, mplapackint const ldpt, std::complex<_Float64x> *u, std::complex<_Float64x> *vt, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const nout, mplapackint &info);
void Cchkbk(mplapackint const nin, mplapackint const nout);
void Cchkbl(mplapackint const nin, mplapackint const nout);
void Cchkec(_Float64x const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Cchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, bool const tstdif, _Float64x const thrshn, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, std::complex<_Float64x> *h, std::complex<_Float64x> *t, std::complex<_Float64x> *s1, std::complex<_Float64x> *s2, std::complex<_Float64x> *p1, std::complex<_Float64x> *p2, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, std::complex<_Float64x> *q, std::complex<_Float64x> *z, std::complex<_Float64x> *alpha1, std::complex<_Float64x> *beta1, std::complex<_Float64x> *alpha3, std::complex<_Float64x> *beta3, std::complex<_Float64x> *evectl, std::complex<_Float64x> *evectr, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, bool *llwork, _Float64x *result, mplapackint &info);
void Cchkgk(mplapackint const nin, mplapackint const nout);
void Cchkgl(mplapackint const nin, mplapackint const nout);
void Cchkhb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *sd, _Float64x *se, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result, mplapackint &info);
void Cchkhb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *sd, _Float64x *se, _Float64x *d1, _Float64x *d2, _Float64x *d3, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result, mplapackint &info);
void Cchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *h, std::complex<_Float64x> *t1, std::complex<_Float64x> *t2, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *z, std::complex<_Float64x> *uz, std::complex<_Float64x> *w1, std::complex<_Float64x> *w3, std::complex<_Float64x> *evectl, std::complex<_Float64x> *evectr, std::complex<_Float64x> *evecty, std::complex<_Float64x> *evectx, std::complex<_Float64x> *uu, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const nwork, _Float64x *rwork, mplapackint *iwork, bool *select, _Float64x *result, mplapackint &info);
void Cchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *ap, _Float64x *sd, _Float64x *se, _Float64x *d1, _Float64x *d2, _Float64x *d3, _Float64x *d4, _Float64x *d5, _Float64x *wa1, _Float64x *wa2, _Float64x *wa3, _Float64x *wr, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, std::complex<_Float64x> *vp, std::complex<_Float64x> *tau, std::complex<_Float64x> *z, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, mplapackint &info);
void Cchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *ap, _Float64x *sd, _Float64x *se, _Float64x *d1, _Float64x *d2, _Float64x *d3, _Float64x *d4, _Float64x *d5, _Float64x *wa1, _Float64x *wa2, _Float64x *wa3, _Float64x *wr, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, std::complex<_Float64x> *vp, std::complex<_Float64x> *tau, std::complex<_Float64x> *z, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, mplapackint &info);
void Cckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, _Float64x const thresh, mplapackint const mmax, std::complex<_Float64x> *x, std::complex<_Float64x> *xf, std::complex<_Float64x> *u1, std::complex<_Float64x> *u2, std::complex<_Float64x> *v1t, std::complex<_Float64x> *v2t, _Float64x *theta, mplapackint *iwork, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckglm(mplapackint const nn, mplapackint *nval, mplapackint *mval, mplapackint *pval, mplapackint const nmats, mplapackint *iseed, _Float64x const thresh, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *b, std::complex<_Float64x> *bf, std::complex<_Float64x> *x, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float64x const thresh, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *aq, std::complex<_Float64x> *ar, std::complex<_Float64x> *taua, std::complex<_Float64x> *b, std::complex<_Float64x> *bf, std::complex<_Float64x> *bz, std::complex<_Float64x> *bt, std::complex<_Float64x> *bwk, std::complex<_Float64x> *taub, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float64x const thresh, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *b, std::complex<_Float64x> *bf, std::complex<_Float64x> *u, std::complex<_Float64x> *v, std::complex<_Float64x> *q, _Float64x *alpha, _Float64x *beta, std::complex<_Float64x> *r, mplapackint *iwork, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float64x const thresh, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *b, std::complex<_Float64x> *bf, std::complex<_Float64x> *x, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccsdts(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float64x> *x, std::complex<_Float64x> *xf, mplapackint const ldx, std::complex<_Float64x> *u1, mplapackint const ldu1, std::complex<_Float64x> *u2, mplapackint const ldu2, std::complex<_Float64x> *v1t, mplapackint const ldv1t, std::complex<_Float64x> *v2t, mplapackint const ldv2t, _Float64x *theta, mplapackint *iwork, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Cdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, std::complex<_Float64x> *s, std::complex<_Float64x> *t, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *z, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result, bool *bwork, mplapackint &info);
void Cdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, std::complex<_Float64x> *s, std::complex<_Float64x> *t, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *z, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result, bool *bwork, mplapackint &info);
void Cdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, std::complex<_Float64x> *s, std::complex<_Float64x> *t, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *z, std::complex<_Float64x> *qe, mplapackint const ldqe, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *alpha1, std::complex<_Float64x> *beta1, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result, mplapackint &info);
void Cdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, std::complex<_Float64x> *s, std::complex<_Float64x> *t, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *z, std::complex<_Float64x> *qe, mplapackint const ldqe, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *alpha1, std::complex<_Float64x> *beta1, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result, mplapackint &info);
void Cdrgsx(mplapackint const nsize, mplapackint const ncmax, _Float64x const thresh, mplapackint const nin, mplapackint const nout, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, std::complex<_Float64x> *ai, std::complex<_Float64x> *bi, std::complex<_Float64x> *z, std::complex<_Float64x> *q, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *s, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Cdrgvx(mplapackint const nsize, _Float64x const thresh, mplapackint const nin, mplapackint const nout, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, std::complex<_Float64x> *ai, std::complex<_Float64x> *bi, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *vl, std::complex<_Float64x> *vr, mplapackint &ilo, mplapackint &ihi, _Float64x *lscale, _Float64x *rscale, _Float64x *s, _Float64x *dtru, _Float64x *dif, _Float64x *diftru, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, bool *bwork, mplapackint &info);
void Cdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *vt, mplapackint const ldvt, std::complex<_Float64x> *asav, std::complex<_Float64x> *usav, std::complex<_Float64x> *vtsav, _Float64x *s, _Float64x *ssav, _Float64x *e, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint *iwork, mplapackint const nounit, mplapackint &info);
void Cdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *h, std::complex<_Float64x> *ht, std::complex<_Float64x> *w, std::complex<_Float64x> *wt, std::complex<_Float64x> *vs, mplapackint const ldvs, _Float64x *result, std::complex<_Float64x> *work, mplapackint const nwork, _Float64x *rwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Cdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *h, std::complex<_Float64x> *w, std::complex<_Float64x> *w1, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, std::complex<_Float64x> *lre, mplapackint const ldlre, _Float64x *result, std::complex<_Float64x> *work, mplapackint const nwork, _Float64x *rwork, mplapackint *iwork, mplapackint &info);
void Cdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *d, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *ab, std::complex<_Float64x> *bb, std::complex<_Float64x> *ap, std::complex<_Float64x> *bp, std::complex<_Float64x> *work, mplapackint const nwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, mplapackint &info);
void Cdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *d, _Float64x *d2, std::complex<_Float64x> *z, mplapackint const ldz, std::complex<_Float64x> *ab, std::complex<_Float64x> *bb, std::complex<_Float64x> *ap, std::complex<_Float64x> *bp, std::complex<_Float64x> *work, mplapackint const nwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, mplapackint &info);
void Cdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *d1, _Float64x *d2, _Float64x *d3, _Float64x *wa1, _Float64x *wa2, _Float64x *wa3, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, std::complex<_Float64x> *tau, std::complex<_Float64x> *z, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, mplapackint &info);
void Cdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *d1, _Float64x *d2, _Float64x *d3, _Float64x *wa1, _Float64x *wa2, _Float64x *wa3, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, std::complex<_Float64x> *tau, std::complex<_Float64x> *z, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, mplapackint &info);
void Cdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const niunit, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *h, std::complex<_Float64x> *ht, std::complex<_Float64x> *w, std::complex<_Float64x> *wt, std::complex<_Float64x> *wtmp, std::complex<_Float64x> *vs, mplapackint const ldvs, std::complex<_Float64x> *vs1, _Float64x *result, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, bool *bwork, mplapackint &info);
void Cdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const niunit, mplapackint const nounit, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *h, std::complex<_Float64x> *w, std::complex<_Float64x> *w1, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, std::complex<_Float64x> *lre, mplapackint const ldlre, _Float64x *rcondv, _Float64x *rcndv1, _Float64x *rcdvin, _Float64x *rconde, _Float64x *rcnde1, _Float64x *rcdein, _Float64x *scale, _Float64x *scale1, _Float64x *result, std::complex<_Float64x> *work, mplapackint const nwork, _Float64x *rwork, mplapackint &info);
void Cerrbd(const char *path, mplapackint const nunit);
void Cerrec(const char *path, mplapackint const nunit);
void Cerred(const char *path, mplapackint const nunit);
void Cerrgg(const char *path, mplapackint const nunit);
void Cerrhs(const char *path, mplapackint const nunit);
void Cerrst(const char *path, mplapackint const nunit);
void Cget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Cget10(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x &result);
void Cget22(const char *transa, const char *transe, const char *transw, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *e, mplapackint const lde, std::complex<_Float64x> *w, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x *result);
void Cget23(bool const comp, mplapackint const isrt, const char *balanc, mplapackint const jtype, _Float64x const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *h, std::complex<_Float64x> *w, std::complex<_Float64x> *w1, std::complex<_Float64x> *vl, mplapackint const ldvl, std::complex<_Float64x> *vr, mplapackint const ldvr, std::complex<_Float64x> *lre, mplapackint const ldlre, _Float64x *rcondv, _Float64x *rcndv1, _Float64x *rcdvin, _Float64x *rconde, _Float64x *rcnde1, _Float64x *rcdein, _Float64x *scale, _Float64x *scale1, _Float64x *result, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, mplapackint &info);
void Cget24(bool const comp, mplapackint const jtype, _Float64x const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *h, std::complex<_Float64x> *ht, std::complex<_Float64x> *w, std::complex<_Float64x> *wt, std::complex<_Float64x> *wtmp, std::complex<_Float64x> *vs, mplapackint const ldvs, std::complex<_Float64x> *vs1, _Float64x const rcdein, _Float64x const rcdvin, mplapackint const nslct, mplapackint *islct, mplapackint const isrt, _Float64x *result, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, bool *bwork, mplapackint &info);
void Cget35(_Float64x &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget36(_Float64x &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget37(_Float64x *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget38(_Float64x *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget51(mplapackint const itype, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x &result);
void Cget52(bool const left, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *e, mplapackint const lde, std::complex<_Float64x> *alpha, std::complex<_Float64x> *beta, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x *result);
void Cget54(mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *s, mplapackint const lds, std::complex<_Float64x> *t, mplapackint const ldt, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *work, _Float64x &result);
void Cglmts(mplapackint const n, mplapackint const m, mplapackint const p, std::complex<_Float64x> *a, std::complex<_Float64x> *af, mplapackint const lda, std::complex<_Float64x> *b, std::complex<_Float64x> *bf, mplapackint const ldb, std::complex<_Float64x> *d, std::complex<_Float64x> *df, std::complex<_Float64x> *x, std::complex<_Float64x> *u, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x &result);
void Cgqrts(mplapackint const n, mplapackint const m, mplapackint const p, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *q, std::complex<_Float64x> *r, mplapackint const lda, std::complex<_Float64x> *taua, std::complex<_Float64x> *b, std::complex<_Float64x> *bf, std::complex<_Float64x> *z, std::complex<_Float64x> *t, std::complex<_Float64x> *bwk, mplapackint const ldb, std::complex<_Float64x> *taub, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Cgrqts(mplapackint const m, mplapackint const p, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *q, std::complex<_Float64x> *r, mplapackint const lda, std::complex<_Float64x> *taua, std::complex<_Float64x> *b, std::complex<_Float64x> *bf, std::complex<_Float64x> *z, std::complex<_Float64x> *t, std::complex<_Float64x> *bwk, mplapackint const ldb, std::complex<_Float64x> *taub, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Cgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *af, mplapackint const lda, std::complex<_Float64x> *b, std::complex<_Float64x> *bf, mplapackint const ldb, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *q, mplapackint const ldq, _Float64x *alpha, _Float64x *beta, std::complex<_Float64x> *r, mplapackint const ldr, mplapackint *iwork, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Chbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *d, _Float64x *e, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x *result);
void Chet21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *d, _Float64x *e, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x *result);
void Chet22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *d, _Float64x *e, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *, mplapackint const ldv, std::complex<_Float64x> *, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x *result);
void Chpt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, std::complex<_Float64x> *ap, _Float64x *d, _Float64x *e, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *vp, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x *result);
void Chst01(mplapackint const n, mplapackint const, mplapackint const, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *h, mplapackint const ldh, std::complex<_Float64x> *q, mplapackint const ldq, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Clacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, _Float64x *theta, mplapackint *iseed, std::complex<_Float64x> *x, mplapackint const &ldx, std::complex<_Float64x> *work);
void Clarfy(const char *uplo, mplapackint const n, std::complex<_Float64x> *v, mplapackint const incv, std::complex<_Float64x> const tau, std::complex<_Float64x> *c, mplapackint const ldc, std::complex<_Float64x> *work);
void Clarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Clatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, bool const rsign, _Float64x const amagn, _Float64x const rcond, _Float64x const triang, mplapackint const idist, mplapackint *iseed, std::complex<_Float64x> *a, mplapackint const lda);
void Clsets(mplapackint const m, mplapackint const p, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *af, mplapackint const lda, std::complex<_Float64x> *b, std::complex<_Float64x> *bf, mplapackint const ldb, std::complex<_Float64x> *c, std::complex<_Float64x> *cf, std::complex<_Float64x> *d, std::complex<_Float64x> *df, std::complex<_Float64x> *x, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Csbmv(const char *uplo, mplapackint const n, mplapackint const k, std::complex<_Float64x> const alpha, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const incx, std::complex<_Float64x> const beta, std::complex<_Float64x> *y, mplapackint const incy);
void Csgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *z, mplapackint const ldz, _Float64x *d, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x *result);
void Cstt21(mplapackint const n, mplapackint const kband, _Float64x *ad, _Float64x *ae, _Float64x *sd, _Float64x *se, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x *result);
void Cstt22(mplapackint const n, mplapackint const m, mplapackint const kband, _Float64x *ad, _Float64x *ae, _Float64x *sd, _Float64x *se, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *work, mplapackint const ldwork, _Float64x *rwork, _Float64x *result);
void Cunt01(const char *rowcol, mplapackint const m, mplapackint const n, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x &resid);
void Cunt03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, std::complex<_Float64x> *u, mplapackint const ldu, std::complex<_Float64x> *v, mplapackint const ldv, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x &result, mplapackint &info);
void Mxerbla__Float64x(const char *srname, int info);
void Rbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, _Float64x *a, mplapackint const lda, _Float64x *q, mplapackint const ldq, _Float64x *d, _Float64x *e, _Float64x *pt, mplapackint const ldpt, _Float64x *work, _Float64x &resid);
void Rbdt02(mplapackint const m, mplapackint const n, _Float64x *b, mplapackint const ldb, _Float64x *c, mplapackint const ldc, _Float64x *u, mplapackint const ldu, _Float64x *work, _Float64x &resid);
void Rbdt03(const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *d, _Float64x *e, _Float64x *u, mplapackint const ldu, _Float64x *s, _Float64x *vt, mplapackint const ldvt, _Float64x *work, _Float64x &resid);
void Rbdt04(const char *uplo, mplapackint const n, _Float64x *d, _Float64x *e, _Float64x *s, mplapackint const ns, _Float64x *u, mplapackint const ldu, _Float64x *vt, mplapackint const ldvt, _Float64x *work, _Float64x &resid);
void Rbdt05(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *s, mplapackint const ns, _Float64x *u, mplapackint const ldu, _Float64x *vt, mplapackint const ldvt, _Float64x *work, _Float64x &resid);
void Rchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *ab, mplapackint const ldab, _Float64x *bd, _Float64x *be, _Float64x *q, mplapackint const ldq, _Float64x *p, mplapackint const ldp, _Float64x *c, mplapackint const ldc, _Float64x *cc, _Float64x *work, mplapackint const lwork, _Float64x *result, mplapackint &info);
void Rchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, _Float64x const thresh, _Float64x *a, mplapackint const lda, _Float64x *bd, _Float64x *be, _Float64x *s1, _Float64x *s2, _Float64x *x, mplapackint const ldx, _Float64x *y, _Float64x *z, _Float64x *q, mplapackint const ldq, _Float64x *pt, mplapackint const ldpt, _Float64x *u, _Float64x *vt, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rchkbk(mplapackint const nin, mplapackint const nout);
void Rchkbl(mplapackint const nin, mplapackint const nout);
void Rchkec(_Float64x const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Rchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, bool const tstdif, _Float64x const thrshn, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *b, _Float64x *h, _Float64x *t, _Float64x *s1, _Float64x *s2, _Float64x *p1, _Float64x *p2, _Float64x *u, mplapackint const ldu, _Float64x *v, _Float64x *q, _Float64x *z, _Float64x *alphr1, _Float64x *alphi1, _Float64x *beta1, _Float64x *alphr3, _Float64x *alphi3, _Float64x *beta3, _Float64x *evectl, _Float64x *evectr, _Float64x *work, mplapackint const lwork, bool *llwork, _Float64x *result, mplapackint &info);
void Rchkgk(mplapackint const nin, mplapackint const nout);
void Rchkgl(mplapackint const nin, mplapackint const nout);
void Rchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *h, _Float64x *t1, _Float64x *t2, _Float64x *u, mplapackint const ldu, _Float64x *z, _Float64x *uz, _Float64x *wr1, _Float64x *wi1, _Float64x *wr2, _Float64x *wi2, _Float64x *wr3, _Float64x *wi3, _Float64x *evectl, _Float64x *evectr, _Float64x *evecty, _Float64x *evectx, _Float64x *uu, _Float64x *tau, _Float64x *work, mplapackint const nwork, mplapackint *iwork, bool *select, _Float64x *result, mplapackint &info);
void Rchksb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *sd, _Float64x *se, _Float64x *u, mplapackint const ldu, _Float64x *work, mplapackint const lwork, _Float64x *result, mplapackint &info);
void Rchksb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *sd, _Float64x *se, _Float64x *d1, _Float64x *d2, _Float64x *d3, _Float64x *u, mplapackint const ldu, _Float64x *work, mplapackint const lwork, _Float64x *result, mplapackint &info);
void Rchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *ap, _Float64x *sd, _Float64x *se, _Float64x *d1, _Float64x *d2, _Float64x *d3, _Float64x *d4, _Float64x *d5, _Float64x *wa1, _Float64x *wa2, _Float64x *wa3, _Float64x *wr, _Float64x *u, mplapackint const ldu, _Float64x *v, _Float64x *vp, _Float64x *tau, _Float64x *z, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, mplapackint &info);
void Rchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *ap, _Float64x *sd, _Float64x *se, _Float64x *d1, _Float64x *d2, _Float64x *d3, _Float64x *d4, _Float64x *d5, _Float64x *wa1, _Float64x *wa2, _Float64x *wa3, _Float64x *wr, _Float64x *u, mplapackint const ldu, _Float64x *v, _Float64x *vp, _Float64x *tau, _Float64x *z, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, mplapackint &info);
void Rckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, _Float64x const thresh, mplapackint const mmax, _Float64x *x, _Float64x *xf, _Float64x *u1, _Float64x *u2, _Float64x *v1t, _Float64x *v2t, _Float64x *theta, mplapackint *iwork, _Float64x *work, _Float64x *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckglm(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float64x const thresh, mplapackint const nmax, _Float64x *a, _Float64x *af, _Float64x *b, _Float64x *bf, _Float64x *x, _Float64x *work, _Float64x *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float64x const thresh, mplapackint const nmax, _Float64x *a, _Float64x *af, _Float64x *aq, _Float64x *ar, _Float64x *taua, _Float64x *b, _Float64x *bf, _Float64x *bz, _Float64x *bt, _Float64x *bwk, _Float64x *taub, _Float64x *work, _Float64x *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float64x const thresh, mplapackint const nmax, _Float64x *a, _Float64x *af, _Float64x *b, _Float64x *bf, _Float64x *u, _Float64x *v, _Float64x *q, _Float64x *alpha, _Float64x *beta, _Float64x *r, mplapackint *iwork, _Float64x *work, _Float64x *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, _Float64x const thresh, mplapackint const nmax, _Float64x *a, _Float64x *af, _Float64x *b, _Float64x *bf, _Float64x *x, _Float64x *work, _Float64x *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcsdts(mplapackint const m, mplapackint const p, mplapackint const q, _Float64x *x, _Float64x *xf, mplapackint const ldx, _Float64x *u1, mplapackint const ldu1, _Float64x *u2, mplapackint const ldu2, _Float64x *v1t, mplapackint const ldv1t, _Float64x *v2t, mplapackint const ldv2t, _Float64x *theta, mplapackint *iwork, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *b, _Float64x *s, _Float64x *t, _Float64x *q, mplapackint const ldq, _Float64x *z, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *work, mplapackint const lwork, _Float64x *result, bool *bwork, mplapackint &info);
void Rdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *b, _Float64x *s, _Float64x *t, _Float64x *q, mplapackint const ldq, _Float64x *z, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *work, mplapackint const lwork, _Float64x *result, bool *bwork, mplapackint &info);
void Rdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *b, _Float64x *s, _Float64x *t, _Float64x *q, mplapackint const ldq, _Float64x *z, _Float64x *qe, mplapackint const ldqe, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *alphr1, _Float64x *alphi1, _Float64x *beta1, _Float64x *work, mplapackint const lwork, _Float64x *result, mplapackint &info);
void Rdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *b, _Float64x *s, _Float64x *t, _Float64x *q, mplapackint const ldq, _Float64x *z, _Float64x *qe, mplapackint const ldqe, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *alphr1, _Float64x *alphi1, _Float64x *beta1, _Float64x *work, mplapackint const lwork, _Float64x *result, mplapackint &info);
void Rdrgsx(mplapackint const nsize, mplapackint const ncmax, _Float64x const thresh, mplapackint const nin, mplapackint const nout, _Float64x *a, mplapackint const lda, _Float64x *b, _Float64x *ai, _Float64x *bi, _Float64x *z, _Float64x *q, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *c, mplapackint const ldc, _Float64x *s, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rdrgvx(mplapackint const nsize, _Float64x const thresh, mplapackint const nin, mplapackint const nout, _Float64x *a, mplapackint const lda, _Float64x *b, _Float64x *ai, _Float64x *bi, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *vl, _Float64x *vr, mplapackint const ilo, mplapackint const ihi, _Float64x *lscale, _Float64x *rscale, _Float64x *s, _Float64x *dtru, _Float64x *dif, _Float64x *diftru, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, bool *bwork, mplapackint &info);
void Rdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, _Float64x *a, mplapackint const lda, _Float64x *u, mplapackint const ldu, _Float64x *vt, mplapackint const ldvt, _Float64x *asav, _Float64x *usav, _Float64x *vtsav, _Float64x *s, _Float64x *ssav, _Float64x *e, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *h, _Float64x *ht, _Float64x *wr, _Float64x *wi, _Float64x *wrt, _Float64x *wit, _Float64x *vs, mplapackint const ldvs, _Float64x *result, _Float64x *work, mplapackint const nwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *h, _Float64x *wr, _Float64x *wi, _Float64x *wr1, _Float64x *wi1, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, _Float64x *lre, mplapackint const ldlre, _Float64x *result, _Float64x *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *d, _Float64x *z, mplapackint const ldz, _Float64x *ab, _Float64x *bb, _Float64x *ap, _Float64x *bp, _Float64x *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, mplapackint &info);
void Rdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *d, _Float64x *d2, _Float64x *z, mplapackint const ldz, _Float64x *ab, _Float64x *bb, _Float64x *ap, _Float64x *bp, _Float64x *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, mplapackint &info);
void Rdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *d1, _Float64x *d2, _Float64x *d3, _Float64x *d4, _Float64x *eveigs, _Float64x *wa1, _Float64x *wa2, _Float64x *wa3, _Float64x *u, mplapackint const ldu, _Float64x *v, _Float64x *tau, _Float64x *z, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, mplapackint &info);
void Rdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *d1, _Float64x *d2, _Float64x *d3, _Float64x *d4, _Float64x *eveigs, _Float64x *wa1, _Float64x *wa2, _Float64x *wa3, _Float64x *u, mplapackint const ldu, _Float64x *v, _Float64x *tau, _Float64x *z, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, _Float64x *result, mplapackint &info);
void Rdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const niunit, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *h, _Float64x *ht, _Float64x *wr, _Float64x *wi, _Float64x *wrt, _Float64x *wit, _Float64x *wrtmp, _Float64x *witmp, _Float64x *vs, mplapackint const ldvs, _Float64x *vs1, _Float64x *result, _Float64x *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, _Float64x const thresh, mplapackint const niunit, mplapackint const nounit, _Float64x *a, mplapackint const lda, _Float64x *h, _Float64x *wr, _Float64x *wi, _Float64x *wr1, _Float64x *wi1, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, _Float64x *lre, mplapackint const ldlre, _Float64x *rcondv, _Float64x *rcndv1, _Float64x *rcdvin, _Float64x *rconde, _Float64x *rcnde1, _Float64x *rcdein, _Float64x *scale, _Float64x *scale1, _Float64x *result, _Float64x *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rerrbd(const char *path, mplapackint const nunit);
void Rerrec(const char *path, mplapackint const nunit);
void Rerred(const char *path, mplapackint const nunit);
void Rerrgg(const char *path, mplapackint const nunit);
void Rerrhs(const char *path, mplapackint const nunit);
void Rerrst(const char *path, mplapackint const nunit);
void Rget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Rget10(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *work, _Float64x &result);
void Rget22(const char *transa, const char *transe, const char *transw, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *e, mplapackint const lde, _Float64x *wr, _Float64x *wi, _Float64x *work, _Float64x *result);
void Rget23(bool const comp, const char *balanc, mplapackint const jtype, _Float64x const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *h, _Float64x *wr, _Float64x *wi, _Float64x *wr1, _Float64x *wi1, _Float64x *vl, mplapackint const ldvl, _Float64x *vr, mplapackint const ldvr, _Float64x *lre, mplapackint const ldlre, _Float64x *rcondv, _Float64x *rcndv1, _Float64x *rcdvin, _Float64x *rconde, _Float64x *rcnde1, _Float64x *rcdein, _Float64x *scale, _Float64x *scale1, _Float64x *result, _Float64x *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rget24(bool const comp, mplapackint const jtype, _Float64x const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *h, _Float64x *ht, _Float64x *wr, _Float64x *wi, _Float64x *wrt, _Float64x *wit, _Float64x *wrtmp, _Float64x *witmp, _Float64x *vs, mplapackint const ldvs, _Float64x *vs1, _Float64x const rcdein, _Float64x const rcdvin, mplapackint const nslct, mplapackint *islct, _Float64x *result, _Float64x *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rget31(_Float64x &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget32(_Float64x &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget33(_Float64x &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget34(_Float64x &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget35(_Float64x &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget36(_Float64x &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget37(_Float64x *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget38(_Float64x *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget39(_Float64x &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget40(_Float64x &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget51(mplapackint const itype, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *u, mplapackint const ldu, _Float64x *v, mplapackint const ldv, _Float64x *work, _Float64x &result);
void Rget52(bool const left, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *e, mplapackint const lde, _Float64x *alphar, _Float64x *alphai, _Float64x *beta, _Float64x *work, _Float64x *result);
void Rget53(_Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x const scale, _Float64x const wr, _Float64x const wi, _Float64x &result, mplapackint &info);
void Rget54(mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *s, mplapackint const lds, _Float64x *t, mplapackint const ldt, _Float64x *u, mplapackint const ldu, _Float64x *v, mplapackint const ldv, _Float64x *work, _Float64x &result);
void Rglmts(mplapackint const n, mplapackint const m, mplapackint const p, _Float64x *a, _Float64x *af, mplapackint const lda, _Float64x *b, _Float64x *bf, mplapackint const ldb, _Float64x *d, _Float64x *df, _Float64x *x, _Float64x *u, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x &result);
void Rgqrts(mplapackint const n, mplapackint const m, mplapackint const p, _Float64x *a, _Float64x *af, _Float64x *q, _Float64x *r, mplapackint const lda, _Float64x *taua, _Float64x *b, _Float64x *bf, _Float64x *z, _Float64x *t, _Float64x *bwk, mplapackint const ldb, _Float64x *taub, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rgrqts(mplapackint const m, mplapackint const p, mplapackint const n, _Float64x *a, _Float64x *af, _Float64x *q, _Float64x *r, mplapackint const lda, _Float64x *taua, _Float64x *b, _Float64x *bf, _Float64x *z, _Float64x *t, _Float64x *bwk, mplapackint const ldb, _Float64x *taub, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, _Float64x *a, _Float64x *af, mplapackint const lda, _Float64x *b, _Float64x *bf, mplapackint const ldb, _Float64x *u, mplapackint const ldu, _Float64x *v, mplapackint const ldv, _Float64x *q, mplapackint const ldq, _Float64x *alpha, _Float64x *beta, _Float64x *r, mplapackint const ldr, mplapackint *iwork, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rhst01(mplapackint const n, mplapackint const, mplapackint const, _Float64x *a, mplapackint const lda, _Float64x *h, mplapackint const ldh, _Float64x *q, mplapackint const ldq, _Float64x *work, mplapackint const lwork, _Float64x *result);
void Rlacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, _Float64x *theta, mplapackint *iseed, _Float64x *x, mplapackint const &ldx, _Float64x *work);
void Rlafts(const char *type, mplapackint const m, mplapackint const n, mplapackint const imat, mplapackint const ntests, _Float64x *result, mplapackint *iseed, _Float64x const thresh, mplapackint const iounit, mplapackint &ie);
void Rlahd2(mplapackint const iounit, const char *path);
void Rlarfy(const char *uplo, mplapackint const n, _Float64x *v, mplapackint const incv, _Float64x const tau, _Float64x *c, mplapackint const ldc, _Float64x *work);
void Rlarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Rlasum(const char *type, mplapackint const iounit, mplapackint const ie, mplapackint const nrun);
void Rlatb9(const char *path, mplapackint const imat, mplapackint const m, mplapackint const p, mplapackint const n, char *type, mplapackint &kla, mplapackint &kua, mplapackint &klb, mplapackint &kub, _Float64x &anorm, _Float64x &bnorm, mplapackint &modea, mplapackint &modeb, _Float64x &cndnma, _Float64x &cndnmb, char *dista, char *distb);
void Rlatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, mplapackint const isign, _Float64x const amagn, _Float64x const rcond, _Float64x const triang, mplapackint const idist, mplapackint *iseed, _Float64x *a, mplapackint const lda);
void Rlsets(mplapackint const m, mplapackint const p, mplapackint const n, _Float64x *a, _Float64x *af, mplapackint const lda, _Float64x *b, _Float64x *bf, mplapackint const ldb, _Float64x *c, _Float64x *cf, _Float64x *d, _Float64x *df, _Float64x *x, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rort01(const char *rowcol, mplapackint const m, mplapackint const n, _Float64x *u, mplapackint const ldu, _Float64x *work, mplapackint const lwork, _Float64x &resid);
void Rort03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, _Float64x *u, mplapackint const ldu, _Float64x *v, mplapackint const ldv, _Float64x *work, mplapackint const lwork, _Float64x &result, mplapackint &info);
void Rsbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, _Float64x *a, mplapackint const lda, _Float64x *d, _Float64x *e, _Float64x *u, mplapackint const ldu, _Float64x *work, _Float64x *result);
void Rsgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *z, mplapackint const ldz, _Float64x *d, _Float64x *work, _Float64x *result);
void Rspt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, _Float64x *ap, _Float64x *d, _Float64x *e, _Float64x *u, mplapackint const ldu, _Float64x *vp, _Float64x *tau, _Float64x *work, _Float64x *result);
void Rstech(mplapackint const n, _Float64x *a, _Float64x *b, _Float64x *eig, _Float64x const tol, _Float64x *work, mplapackint &info);
void Rstect(mplapackint const n, _Float64x *a, _Float64x *b, _Float64x const shift, mplapackint &num);
void Rstt21(mplapackint const n, mplapackint const kband, _Float64x *ad, _Float64x *ae, _Float64x *sd, _Float64x *se, _Float64x *u, mplapackint const ldu, _Float64x *work, _Float64x *result);
void Rstt22(mplapackint const n, mplapackint const m, mplapackint const kband, _Float64x *ad, _Float64x *ae, _Float64x *sd, _Float64x *se, _Float64x *u, mplapackint const ldu, _Float64x *work, mplapackint const ldwork, _Float64x *result);
void Rsvdch(mplapackint const n, _Float64x *s, _Float64x *e, _Float64x *svd, _Float64x const tol, mplapackint &info);
void Rsvdct(mplapackint const n, _Float64x *s, _Float64x *e, _Float64x const shift, mplapackint &num);
void Rsyt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, _Float64x *a, mplapackint const lda, _Float64x *d, _Float64x *e, _Float64x *u, mplapackint const ldu, _Float64x *v, mplapackint const ldv, _Float64x *tau, _Float64x *work, _Float64x *result);
void Rsyt22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, _Float64x *a, mplapackint const lda, _Float64x *d, _Float64x *e, _Float64x *u, mplapackint const ldu, _Float64x *, mplapackint const ldv, _Float64x *, _Float64x *work, _Float64x *result);
void chkxer(const char *srnamt, mplapackint const &infot, mplapackint const &nout, bool &lerr, bool &ok);
void xlaenv(mplapackint const &ispec, mplapackint const &nvalue);
#endif
