/*
 * Copyright (c) 2008-2021
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mplapack_double.h,v 1.4 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_DOUBLE_H_
#define _MPLAPACK_DOUBLE_H_

#include "mplapack_config.h"

bool Mlsamen_double(mplapackint n, const char *a, const char *b);
bool Risnan(double const din);
bool Rlaisnan(double const din1, double const din2);
double Clangb(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<double> *ab, mplapackint const ldab, double *work);
double Clange(const char *norm, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *work);
double Clangt(const char *norm, mplapackint const n, std::complex<double> *dl, std::complex<double> *d, std::complex<double> *du);
double Clanhb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, std::complex<double> *ab, mplapackint const ldab, double *work);
double Clanhe(const char *norm, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *work);
double Clanhf(const char *norm, const char *transr, const char *uplo, mplapackint const n, std::complex<double> *a, double *work);
double Clanhp(const char *norm, const char *uplo, mplapackint const n, std::complex<double> *ap, double *work);
double Clanhs(const char *norm, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *work);
double Clanht(const char *norm, mplapackint const n, double *d, std::complex<double> *e);
double Clansb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, std::complex<double> *ab, mplapackint const ldab, double *work);
double Clansp(const char *norm, const char *uplo, mplapackint const n, std::complex<double> *ap, double *work);
double Clansy(const char *norm, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *work);
double Clantb(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const k, std::complex<double> *ab, mplapackint const ldab, double *work);
double Clantp(const char *norm, const char *uplo, const char *diag, mplapackint const n, std::complex<double> *ap, double *work);
double Clantr(const char *norm, const char *uplo, const char *diag, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *work);
double Mmaxval(double *dx, mplapackint const start, mplapackint const end, mplapackint incx);
double RCsum1(mplapackint const n, std::complex<double> *cx, mplapackint const incx);
double Rla_gbrcond(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, double *ab, mplapackint const ldab, double *afb, mplapackint const ldafb, mplapackint *ipiv, mplapackint const cmode, double *c, mplapackint &info, double *work, mplapackint *iwork);
double Rla_gbrpvgrw(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const ncols, double *ab, mplapackint const ldab, double *afb, mplapackint const ldafb);
double Rla_gercond(const char *trans, mplapackint const n, double *a, mplapackint const lda, double *af, mplapackint const ldaf, mplapackint *ipiv, mplapackint const cmode, double *c, mplapackint &info, double *work, mplapackint *iwork);
double Rla_gerpvgrw(mplapackint const n, mplapackint const ncols, double *a, mplapackint const lda, double *af, mplapackint const ldaf);
double Rla_porcond(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *af, mplapackint const ldaf, mplapackint const cmode, double *c, mplapackint &info, double *work, mplapackint *iwork);
double Rla_syrcond(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *af, mplapackint const ldaf, mplapackint *ipiv, mplapackint const cmode, double *c, mplapackint &info, double *work, mplapackint *iwork);
double Rla_syrpvgrw(const char *uplo, mplapackint const n, mplapackint const info, double *a, mplapackint const lda, double *af, mplapackint const ldaf, mplapackint *ipiv, double *work);
double Rladiv2(double const &a, double const &b, double const &c, double const &d, double const &r, double const &t);
double Rlamc3(double a, double b);
double Rlamch_double(const char *cmach);
double Rlangb(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, double *ab, mplapackint const ldab, double *work);
double Rlange(const char *norm, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *work);
double Rlangt(const char *norm, mplapackint const n, double *dl, double *d, double *du);
double Rlanhs(const char *norm, mplapackint const n, double *a, mplapackint const lda, double *work);
double Rlansb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, double *ab, mplapackint const ldab, double *work);
double Rlansf(const char *norm, const char *transr, const char *uplo, mplapackint const n, double *a, double *work);
double Rlansp(const char *norm, const char *uplo, mplapackint const n, double *ap, double *work);
double Rlanst(const char *norm, mplapackint const n, double *d, double *e);
double Rlansy(const char *norm, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *work);
double Rlantb(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const k, double *ab, mplapackint const ldab, double *work);
double Rlantp(const char *norm, const char *uplo, const char *diag, mplapackint const n, double *ap, double *work);
double Rlantr(const char *norm, const char *uplo, const char *diag, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *work);
double Rlapy2(double const x, double const y);
double Rlapy3(double const x, double const y, double const z);
mplapackint Mmaxloc(double *dx, mplapackint const start, mplapackint const end, mplapackint const incx);
mplapackint Rlaneg(mplapackint const n, double *d, double *lld, double const sigma, double const, mplapackint const r);
mplapackint iCmax1(mplapackint const n, std::complex<double> *zx, mplapackint const incx);
mplapackint iMieeeck_double(mplapackint const &ispec, double const &zero, double const &one);
mplapackint iMladiag(const char *diag);
mplapackint iMladlc(mplapackint const m, mplapackint const n, double *a, mplapackint const lda);
mplapackint iMladlr(mplapackint const m, mplapackint const n, double *a, mplapackint const lda);
mplapackint iMlaenv2stage_double(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv_double(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaprec(const char *prec);
mplapackint iMlatrans(const char *trans);
mplapackint iMlauplo(const char *uplo);
mplapackint iMlazlc(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda);
mplapackint iMlazlr(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda);
mplapackint iMparam2stage_double(mplapackint const ispec, const char *name, const char *opts, mplapackint const ni, mplapackint const nbi, mplapackint const ibi, mplapackint const nxi);
mplapackint iMparmq_double(mplapackint const ispec, const char *name, const char *opts, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mplapackint const lwork);
std::complex<double> Cladiv(std::complex<double> const x, std::complex<double> const y);
void CRrscl(mplapackint const n, double const sa, std::complex<double> *sx, mplapackint const incx);
void Cbbcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, mplapackint const m, mplapackint const p, mplapackint const q, double *theta, double *phi, std::complex<double> *u1, mplapackint const ldu1, std::complex<double> *u2, mplapackint const ldu2, std::complex<double> *v1t, mplapackint const ldv1t, std::complex<double> *v2t, mplapackint const ldv2t, double *b11d, double *b11e, double *b12d, double *b12e, double *b21d, double *b21e, double *b22d, double *b22e, double *rwork, mplapackint const lrwork, mplapackint &info);
void Cbdsqr(const char *uplo, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, double *d, double *e, std::complex<double> *vt, mplapackint const ldvt, std::complex<double> *u, mplapackint const ldu, std::complex<double> *c, mplapackint const ldc, double *rwork, mplapackint &info);
void Cgbbrd(const char *vect, mplapackint const m, mplapackint const n, mplapackint const ncc, mplapackint const kl, mplapackint const ku, std::complex<double> *ab, mplapackint const ldab, double *d, double *e, std::complex<double> *q, mplapackint const ldq, std::complex<double> *pt, mplapackint const ldpt, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, double *rwork, mplapackint &info);
void Cgbcon(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<double> *ab, mplapackint const ldab, mplapackint *ipiv, double const anorm, double &rcond, std::complex<double> *work, double *rwork, mplapackint &info);
void Cgbequ(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<double> *ab, mplapackint const ldab, double *r, double *c, double &rowcnd, double &colcnd, double &amax, mplapackint &info);
void Cgbequb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<double> *ab, mplapackint const ldab, double *r, double *c, double &rowcnd, double &colcnd, double &amax, mplapackint &info);
void Cgbrfs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *afb, mplapackint const ldafb, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cgbsv(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cgbsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *afb, mplapackint const ldafb, mplapackint *ipiv, char *equed, double *r, double *c, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cgbtf2(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<double> *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Cgbtrf(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<double> *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Cgbtrs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cgebak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *scale, mplapackint const m, std::complex<double> *v, mplapackint const ldv, mplapackint &info);
void Cgebal(const char *job, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint &ilo, mplapackint &ihi, double *scale, mplapackint &info);
void Cgebd2(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *d, double *e, std::complex<double> *tauq, std::complex<double> *taup, std::complex<double> *work, mplapackint &info);
void Cgebrd(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *d, double *e, std::complex<double> *tauq, std::complex<double> *taup, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgecon(const char *norm, mplapackint const n, std::complex<double> *a, mplapackint const lda, double const anorm, double &rcond, std::complex<double> *work, double *rwork, mplapackint &info);
void Cgeequ(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *r, double *c, double &rowcnd, double &colcnd, double &amax, mplapackint &info);
void Cgeequb(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *r, double *c, double &rowcnd, double &colcnd, double &amax, mplapackint &info);
void Cgees(const char *jobvs, const char *sort, bool (*select)(std::complex<double>), mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint &sdim, std::complex<double> *w, std::complex<double> *vs, mplapackint const ldvs, std::complex<double> *work, mplapackint const lwork, double *rwork, bool *bwork, mplapackint &info);
void Cgeesx(const char *jobvs, const char *sort, bool (*select)(std::complex<double>), const char *sense, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint &sdim, std::complex<double> *w, std::complex<double> *vs, mplapackint const ldvs, double &rconde, double &rcondv, std::complex<double> *work, mplapackint const lwork, double *rwork, bool *bwork, mplapackint &info);
void Cgeev(const char *jobvl, const char *jobvr, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *w, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Cgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *w, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, double *scale, double &abnrm, double *rconde, double *rcondv, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Cgehd2(mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint &info);
void Cgehrd(mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgejsv(const char *joba, const char *jobu, const char *jobv, const char *jobr, const char *jobt, const char *jobp, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *sva, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, mplapackint const ldv, std::complex<double> *cwork, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cgelq(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const tsize, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgelq2(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint &info);
void Cgelqf(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgelqt(mplapackint const m, mplapackint const n, mplapackint const mb, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const ldt, std::complex<double> *work, mplapackint &info);
void Cgelqt3(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const ldt, mplapackint &info);
void Cgels(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgelsd(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, double *s, double const rcond, mplapackint &rank, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint *iwork, mplapackint &info);
void Cgelss(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, double *s, double const rcond, mplapackint &rank, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Cgelsy(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, mplapackint *jpvt, double const rcond, mplapackint &rank, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Cgemlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const tsize, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgemlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, std::complex<double> *v, mplapackint const ldv, std::complex<double> *t, mplapackint const ldt, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint &info);
void Cgemqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const tsize, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgemqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const nb, std::complex<double> *v, mplapackint const ldv, std::complex<double> *t, mplapackint const ldt, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint &info);
void Cgeql2(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint &info);
void Cgeqlf(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgeqp3(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *jpvt, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Cgeqr(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const tsize, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgeqr2(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint &info);
void Cgeqr2p(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint &info);
void Cgeqrf(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgeqrfp(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgeqrt(mplapackint const m, mplapackint const n, mplapackint const nb, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const ldt, std::complex<double> *work, mplapackint &info);
void Cgeqrt2(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const ldt, mplapackint &info);
void Cgeqrt3(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const ldt, mplapackint &info);
void Cgerfs(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cgerq2(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint &info);
void Cgerqf(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgesc2(mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *rhs, mplapackint *ipiv, mplapackint *jpiv, double &scale);
void Cgesdd(const char *jobz, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *s, std::complex<double> *u, mplapackint const ldu, std::complex<double> *vt, mplapackint const ldvt, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint *iwork, mplapackint &info);
void Cgesv(mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cgesvd(const char *jobu, const char *jobvt, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *s, std::complex<double> *u, mplapackint const ldu, std::complex<double> *vt, mplapackint const ldvt, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Cgesvdq(const char *joba, const char *jobp, const char *jobr, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *s, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, mplapackint const ldv, mplapackint &numrank, mplapackint *iwork, mplapackint const liwork, std::complex<double> *cwork, mplapackint const lcwork, double *rwork, mplapackint const lrwork, mplapackint &info);
void Cgesvdx(const char *jobu, const char *jobvt, const char *range, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double const vl, double const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, double *s, std::complex<double> *u, mplapackint const ldu, std::complex<double> *vt, mplapackint const ldvt, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint *iwork, mplapackint &info);
void Cgesvj(const char *joba, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *sva, mplapackint const mv, std::complex<double> *v, mplapackint const ldv, std::complex<double> *cwork, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint &info);
void Cgesvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *af, mplapackint const ldaf, mplapackint *ipiv, char *equed, double *r, double *c, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cgetc2(mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, mplapackint *jpiv, mplapackint &info);
void Cgetf2(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetrf(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetrf2(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetri(mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgetrs(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cgetsls(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgetsqrhrt(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const ldt, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cggbak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *lscale, double *rscale, mplapackint const m, std::complex<double> *v, mplapackint const ldv, mplapackint &info);
void Cggbal(const char *job, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, mplapackint &ilo, mplapackint &ihi, double *lscale, double *rscale, double *work, mplapackint &info);
void Cgges(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(std::complex<double>, std::complex<double>), mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, mplapackint &sdim, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *vsl, mplapackint const ldvsl, std::complex<double> *vsr, mplapackint const ldvsr, std::complex<double> *work, mplapackint const lwork, double *rwork, bool *bwork, mplapackint &info);
void Cgges3(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(std::complex<double>, std::complex<double>), mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, mplapackint &sdim, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *vsl, mplapackint const ldvsl, std::complex<double> *vsr, mplapackint const ldvsr, std::complex<double> *work, mplapackint const lwork, double *rwork, bool *bwork, mplapackint &info);
void Cggesx(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(std::complex<double>, std::complex<double>), const char *sense, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, mplapackint &sdim, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *vsl, mplapackint const ldvsl, std::complex<double> *vsr, mplapackint const ldvsr, double *rconde, double *rcondv, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Cggev(const char *jobvl, const char *jobvr, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Cggev3(const char *jobvl, const char *jobvr, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Cggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, mplapackint &ilo, mplapackint &ihi, double *lscale, double *rscale, double &abnrm, double &bbnrm, double *rconde, double *rcondv, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Cggglm(mplapackint const n, mplapackint const m, mplapackint const p, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *d, std::complex<double> *x, std::complex<double> *y, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgghd3(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *q, mplapackint const ldq, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgghrd(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *q, mplapackint const ldq, std::complex<double> *z, mplapackint const ldz, mplapackint &info);
void Cgglse(mplapackint const m, mplapackint const n, mplapackint const p, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *c, std::complex<double> *d, std::complex<double> *x, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cggqrf(mplapackint const n, mplapackint const m, mplapackint const p, std::complex<double> *a, mplapackint const lda, std::complex<double> *taua, std::complex<double> *b, mplapackint const ldb, std::complex<double> *taub, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cggrqf(mplapackint const m, mplapackint const p, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *taua, std::complex<double> *b, mplapackint const ldb, std::complex<double> *taub, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cggsvd3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const n, mplapackint const p, mplapackint &k, mplapackint &l, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, double *alpha, double *beta, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, mplapackint const ldv, std::complex<double> *q, mplapackint const ldq, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint *iwork, mplapackint &info);
void Cggsvp3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, double const tola, double const tolb, mplapackint &k, mplapackint &l, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, mplapackint const ldv, std::complex<double> *q, mplapackint const ldq, mplapackint *iwork, double *rwork, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgsvj0(const char *jobv, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *d, double *sva, mplapackint const mv, std::complex<double> *v, mplapackint const ldv, double const eps, double const sfmin, double const tol, mplapackint const nsweep, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgsvj1(const char *jobv, mplapackint const m, mplapackint const n, mplapackint const n1, std::complex<double> *a, mplapackint const lda, std::complex<double> *d, double *sva, mplapackint const mv, std::complex<double> *v, mplapackint const ldv, double const eps, double const sfmin, double const tol, mplapackint const nsweep, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgtcon(const char *norm, mplapackint const n, std::complex<double> *dl, std::complex<double> *d, std::complex<double> *du, std::complex<double> *du2, mplapackint *ipiv, double const anorm, double &rcond, std::complex<double> *work, mplapackint &info);
void Cgtrfs(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<double> *dl, std::complex<double> *d, std::complex<double> *du, std::complex<double> *dlf, std::complex<double> *df, std::complex<double> *duf, std::complex<double> *du2, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cgtsv(mplapackint const n, mplapackint const nrhs, std::complex<double> *dl, std::complex<double> *d, std::complex<double> *du, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cgtsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<double> *dl, std::complex<double> *d, std::complex<double> *du, std::complex<double> *dlf, std::complex<double> *df, std::complex<double> *duf, std::complex<double> *du2, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cgttrf(mplapackint const n, std::complex<double> *dl, std::complex<double> *d, std::complex<double> *du, std::complex<double> *du2, mplapackint *ipiv, mplapackint &info);
void Cgttrs(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<double> *dl, std::complex<double> *d, std::complex<double> *du, std::complex<double> *du2, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cgtts2(mplapackint const itrans, mplapackint const n, mplapackint const nrhs, std::complex<double> *dl, std::complex<double> *d, std::complex<double> *du, std::complex<double> *du2, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb);
void Chb2st_kernels(const char *uplo, bool const wantz, mplapackint const ttype, mplapackint const st, mplapackint const ed, mplapackint const sweep, mplapackint const n, mplapackint const nb, mplapackint const ib, std::complex<double> *a, mplapackint const lda, std::complex<double> *v, std::complex<double> *tau, mplapackint const ldvt, std::complex<double> *work);
void Chbev(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, double *rwork, mplapackint &info);
void Chbev_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Chbevd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *q, mplapackint const ldq, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *q, mplapackint const ldq, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbgst(const char *vect, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *bb, mplapackint const ldbb, std::complex<double> *x, mplapackint const ldx, std::complex<double> *work, double *rwork, mplapackint &info);
void Chbgv(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *bb, mplapackint const ldbb, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, double *rwork, mplapackint &info);
void Chbgvd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *bb, mplapackint const ldbb, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbgvx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *bb, mplapackint const ldbb, std::complex<double> *q, mplapackint const ldq, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbtrd(const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, double *d, double *e, std::complex<double> *q, mplapackint const ldq, std::complex<double> *work, mplapackint &info);
void Checon(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, double const anorm, double &rcond, std::complex<double> *work, mplapackint &info);
void Checon_3(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, double const anorm, double &rcond, std::complex<double> *work, mplapackint &info);
void Checon_rook(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, double const anorm, double &rcond, std::complex<double> *work, mplapackint &info);
void Cheequb(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *s, double &scond, double &amax, std::complex<double> *work, mplapackint &info);
void Cheev(const char *jobz, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *w, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Cheev_2stage(const char *jobz, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *w, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Cheevd(const char *jobz, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *w, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevd_2stage(const char *jobz, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *w, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevr(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, std::complex<double> *z, mplapackint const ldz, mplapackint *isuppz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevr_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, std::complex<double> *z, mplapackint const ldz, mplapackint *isuppz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cheevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chegs2(mplapackint const itype, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Chegst(mplapackint const itype, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Chegv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, double *w, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Chegv_2stage(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, double *w, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Chegvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, double *w, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chegvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cherfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Chesv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chesv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chesv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chesv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chesv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chesvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Cheswapr(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Chetd2(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *d, double *e, std::complex<double> *tau, mplapackint &info);
void Chetf2(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Chetf2_rk(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, mplapackint &info);
void Chetf2_rook(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Chetrd(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *d, double *e, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chetrd_2stage(const char *vect, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *d, double *e, std::complex<double> *tau, std::complex<double> *hous2, mplapackint const lhous2, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chetrd_hb2st(const char *stage1, const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, double *d, double *e, std::complex<double> *hous, mplapackint const lhous, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chetrd_he2hb(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *a, mplapackint const lda, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chetrf(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chetrf_aa(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chetrf_aa_2stage(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chetrf_rk(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chetrf_rook(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chetri(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint &info);
void Chetri2(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chetri2x(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint const nb, mplapackint &info);
void Chetri_3(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chetri_3x(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *work, mplapackint const nb, mplapackint &info);
void Chetri_rook(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint &info);
void Chetrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Chetrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint &info);
void Chetrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Chetrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Chetrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Chetrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Chfrk(const char *transr, const char *uplo, const char *trans, mplapackint const n, mplapackint const k, double const alpha, std::complex<double> *a, mplapackint const lda, double const beta, std::complex<double> *c);
void Chgeqz(const char *job, const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<double> *h, mplapackint const ldh, std::complex<double> *t, mplapackint const ldt, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *q, mplapackint const ldq, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Chpcon(const char *uplo, mplapackint const n, std::complex<double> *ap, mplapackint *ipiv, double const anorm, double &rcond, std::complex<double> *work, mplapackint &info);
void Chpev(const char *jobz, const char *uplo, mplapackint const n, std::complex<double> *ap, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, double *rwork, mplapackint &info);
void Chpevd(const char *jobz, const char *uplo, mplapackint const n, std::complex<double> *ap, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chpevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<double> *ap, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chpgst(mplapackint const itype, const char *uplo, mplapackint const n, std::complex<double> *ap, std::complex<double> *bp, mplapackint &info);
void Chpgv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<double> *ap, std::complex<double> *bp, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, double *rwork, mplapackint &info);
void Chpgvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<double> *ap, std::complex<double> *bp, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chpgvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<double> *ap, std::complex<double> *bp, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, std::complex<double> *afp, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Chpsv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Chpsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, std::complex<double> *afp, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Chptrd(const char *uplo, mplapackint const n, std::complex<double> *ap, double *d, double *e, std::complex<double> *tau, mplapackint &info);
void Chptrf(const char *uplo, mplapackint const n, std::complex<double> *ap, mplapackint *ipiv, mplapackint &info);
void Chptri(const char *uplo, mplapackint const n, std::complex<double> *ap, mplapackint *ipiv, std::complex<double> *work, mplapackint &info);
void Chptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Chsein(const char *side, const char *eigsrc, const char *initv, bool *select, mplapackint const n, std::complex<double> *h, mplapackint const ldh, std::complex<double> *w, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, std::complex<double> *work, double *rwork, mplapackint *ifaill, mplapackint *ifailr, mplapackint &info);
void Chseqr(const char *job, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<double> *h, mplapackint const ldh, std::complex<double> *w, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Clabrd(mplapackint const m, mplapackint const n, mplapackint const nb, std::complex<double> *a, mplapackint const lda, double *d, double *e, std::complex<double> *tauq, std::complex<double> *taup, std::complex<double> *x, mplapackint const ldx, std::complex<double> *y, mplapackint const ldy);
void Clacgv(mplapackint const n, std::complex<double> *x, mplapackint const incx);
void Clacn2(mplapackint const n, std::complex<double> *v, std::complex<double> *x, double &est, mplapackint &kase, mplapackint *isave);
void Clacon(mplapackint const n, std::complex<double> *v, std::complex<double> *x, double &est, mplapackint &kase);
void Clacp2(const char *uplo, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb);
void Clacpy(const char *uplo, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb);
void Clacrm(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *b, mplapackint const ldb, std::complex<double> *c, mplapackint const ldc, double *rwork);
void Clacrt(mplapackint const n, std::complex<double> *cx, mplapackint const incx, std::complex<double> *cy, mplapackint const incy, std::complex<double> const c, std::complex<double> const s);
void Claed0(mplapackint const qsiz, mplapackint const n, double *d, double *e, std::complex<double> *q, mplapackint const ldq, std::complex<double> *qstore, mplapackint const ldqs, double *rwork, mplapackint *iwork, mplapackint &info);
void Claed7(mplapackint const n, mplapackint const cutpnt, mplapackint const qsiz, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, double *d, std::complex<double> *q, mplapackint const ldq, double rho, mplapackint *indxq, double *qstore, mplapackint *qptr, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, double *givnum, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint &info);
void Claed8(mplapackint &k, mplapackint const n, mplapackint const qsiz, std::complex<double> *q, mplapackint const ldq, double *d, double &rho, mplapackint const cutpnt, double *z, double *dlamda, std::complex<double> *q2, mplapackint const ldq2, double *w, mplapackint *indxp, mplapackint *indx, mplapackint *indxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, double *givnum, mplapackint &info);
void Claein(bool const rightv, bool const noinit, mplapackint const n, std::complex<double> *h, mplapackint const ldh, std::complex<double> const w, std::complex<double> *v, std::complex<double> *b, mplapackint const ldb, double *rwork, double const eps3, double const smlnum, mplapackint &info);
void Claesy(std::complex<double> const a, std::complex<double> const b, std::complex<double> const c, std::complex<double> &rt1, std::complex<double> &rt2, std::complex<double> &evscal, std::complex<double> &cs1, std::complex<double> &sn1);
void Claev2(std::complex<double> const a, std::complex<double> const b, std::complex<double> const c, double &rt1, double &rt2, double &cs1, std::complex<double> &sn1);
void Clags2(bool const upper, double const a1, std::complex<double> const a2, double const a3, double const b1, std::complex<double> const b2, double const b3, double &csu, std::complex<double> &snu, double &csv, std::complex<double> &snv, double &csq, std::complex<double> &snq);
void Clagtm(const char *trans, mplapackint const n, mplapackint const nrhs, double const alpha, std::complex<double> *dl, std::complex<double> *d, std::complex<double> *du, std::complex<double> *x, mplapackint const ldx, double const beta, std::complex<double> *b, mplapackint const ldb);
void Clahef(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *w, mplapackint const ldw, mplapackint &info);
void Clahef_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *h, mplapackint const ldh, std::complex<double> *work);
void Clahef_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *w, mplapackint const ldw, mplapackint &info);
void Clahef_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *w, mplapackint const ldw, mplapackint &info);
void Clahqr(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<double> *h, mplapackint const ldh, std::complex<double> *w, mplapackint const iloz, mplapackint const ihiz, std::complex<double> *z, mplapackint const ldz, mplapackint &info);
void Clahr2(mplapackint const n, mplapackint const k, mplapackint const nb, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *t, mplapackint const ldt, std::complex<double> *y, mplapackint const ldy);
void Claic1(mplapackint const job, mplapackint const j, std::complex<double> *x, double const sest, std::complex<double> *w, std::complex<double> const gamma, double &sestpr, std::complex<double> &s, std::complex<double> &c);
void Clals0(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const nrhs, std::complex<double> *b, mplapackint const ldb, std::complex<double> *bx, mplapackint const ldbx, mplapackint *perm, mplapackint const givptr, mplapackint *givcol, mplapackint const ldgcol, double *givnum, mplapackint const ldgnum, double *poles, double *difl, double *difr, double *z, mplapackint const k, double const c, double const s, double *rwork, mplapackint &info);
void Clalsa(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, std::complex<double> *b, mplapackint const ldb, std::complex<double> *bx, mplapackint const ldbx, double *u, mplapackint const ldu, double *vt, mplapackint *k, double *difl, double *difr, double *z, double *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, double *givnum, double *c, double *s, double *rwork, mplapackint *iwork, mplapackint &info);
void Clalsd(const char *uplo, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, double *d, double *e, std::complex<double> *b, mplapackint const ldb, double const rcond, mplapackint &rank, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint &info);
void Clamswlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const ldt, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Clamtsqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const ldt, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Clapll(mplapackint const n, std::complex<double> *x, mplapackint const incx, std::complex<double> *y, mplapackint const incy, double &ssmin);
void Clapmr(bool const forwrd, mplapackint const m, mplapackint const n, std::complex<double> *x, mplapackint const ldx, mplapackint *k);
void Clapmt(bool const forwrd, mplapackint const m, mplapackint const n, std::complex<double> *x, mplapackint const ldx, mplapackint *k);
void Claqgb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<double> *ab, mplapackint const ldab, double *r, double *c, double const rowcnd, double const colcnd, double const amax, char *equed);
void Claqge(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *r, double *c, double const rowcnd, double const colcnd, double const amax, char *equed);
void Claqhb(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, double *s, double const scond, double const amax, char *equed);
void Claqhe(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *s, double const scond, double const amax, char *equed);
void Claqhp(const char *uplo, mplapackint const n, std::complex<double> *ap, double *s, double const scond, double const amax, char *equed);
void Claqp2(mplapackint const m, mplapackint const n, mplapackint const offset, std::complex<double> *a, mplapackint const lda, mplapackint *jpvt, std::complex<double> *tau, double *vn1, double *vn2, std::complex<double> *work);
void Claqps(mplapackint const m, mplapackint const n, mplapackint const offset, mplapackint const nb, mplapackint &kb, std::complex<double> *a, mplapackint const lda, mplapackint *jpvt, std::complex<double> *tau, double *vn1, double *vn2, std::complex<double> *auxv, std::complex<double> *f, mplapackint const ldf);
void Claqr0(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<double> *h, mplapackint const ldh, std::complex<double> *w, mplapackint const iloz, mplapackint const ihiz, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Claqr1(mplapackint const n, std::complex<double> *h, mplapackint const ldh, std::complex<double> const s1, std::complex<double> const s2, std::complex<double> *v);
void Claqr2(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, std::complex<double> *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, std::complex<double> *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, std::complex<double> *sh, std::complex<double> *v, mplapackint const ldv, mplapackint const nh, std::complex<double> *t, mplapackint const ldt, mplapackint const nv, std::complex<double> *wv, mplapackint const ldwv, std::complex<double> *work, mplapackint const lwork);
void Claqr3(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, std::complex<double> *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, std::complex<double> *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, std::complex<double> *sh, std::complex<double> *v, mplapackint const ldv, mplapackint const nh, std::complex<double> *t, mplapackint const ldt, mplapackint const nv, std::complex<double> *wv, mplapackint const ldwv, std::complex<double> *work, mplapackint const lwork);
void Claqr4(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<double> *h, mplapackint const ldh, std::complex<double> *w, mplapackint const iloz, mplapackint const ihiz, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Claqr5(bool const wantt, bool const wantz, mplapackint const kacc22, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nshfts, std::complex<double> *s, std::complex<double> *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, std::complex<double> *z, mplapackint const ldz, std::complex<double> *v, mplapackint const ldv, std::complex<double> *u, mplapackint const ldu, mplapackint const nv, std::complex<double> *wv, mplapackint const ldwv, mplapackint const nh, std::complex<double> *wh, mplapackint const ldwh);
void Claqsb(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, double *s, double const scond, double const amax, char *equed);
void Claqsp(const char *uplo, mplapackint const n, std::complex<double> *ap, double *s, double const scond, double const amax, char *equed);
void Claqsy(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *s, double const scond, double const amax, char *equed);
void Clar1v(mplapackint const n, mplapackint const b1, mplapackint const bn, double const lambda, double *d, double *l, double *ld, double *lld, double const pivmin, double const gaptol, std::complex<double> *z, bool const wantnc, mplapackint &negcnt, double &ztz, double &mingma, mplapackint &r, mplapackint *isuppz, double &nrminv, double &resid, double &rqcorr, double *work);
void Clar2v(mplapackint const n, std::complex<double> *x, std::complex<double> *y, std::complex<double> *z, mplapackint const incx, double *c, std::complex<double> *s, mplapackint const incc);
void Clarcm(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *c, mplapackint const ldc, double *rwork);
void Clarf(const char *side, mplapackint const m, mplapackint const n, std::complex<double> *v, mplapackint const incv, std::complex<double> const tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work);
void Clarfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *v, mplapackint const ldv, std::complex<double> *t, mplapackint const ldt, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const ldwork);
void Clarfb_gett(const char *ident, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *t, mplapackint const ldt, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const ldwork);
void Clarfg(mplapackint const n, std::complex<double> &alpha, std::complex<double> *x, mplapackint const incx, std::complex<double> &tau);
void Clarfgp(mplapackint const n, std::complex<double> &alpha, std::complex<double> *x, mplapackint const incx, std::complex<double> &tau);
void Clarft(const char *direct, const char *storev, mplapackint const n, mplapackint const k, std::complex<double> *v, mplapackint const ldv, std::complex<double> *tau, std::complex<double> *t, mplapackint const ldt);
void Clarfx(const char *side, mplapackint const m, mplapackint const n, std::complex<double> *v, std::complex<double> const tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work);
void Clarfy(const char *uplo, mplapackint const n, std::complex<double> *v, mplapackint const incv, std::complex<double> const tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work);
void Clargv(mplapackint const n, std::complex<double> *x, mplapackint const incx, std::complex<double> *y, mplapackint const incy, double *c, mplapackint const incc);
void Clarnv(mplapackint const idist, mplapackint *iseed, mplapackint const n, std::complex<double> *x);
void Clarrv(mplapackint const n, double const vl, double const, double *d, double *l, double const pivmin, mplapackint *isplit, mplapackint const m, mplapackint const dol, mplapackint const dou, double const minrgp, double &rtol1, double &rtol2, double *w, double *werr, double *wgap, mplapackint *iblock, mplapackint *indexw, double *gers, std::complex<double> *z, mplapackint const ldz, mplapackint *isuppz, double *work, mplapackint *iwork, mplapackint &info);
void Clarscl2(mplapackint const m, mplapackint const n, double *d, std::complex<double> *x, mplapackint const ldx);
void Clartg(std::complex<double> const f, std::complex<double> const g, double &cs, std::complex<double> &sn, std::complex<double> &r);
void Clartv(mplapackint const n, std::complex<double> *x, mplapackint const incx, std::complex<double> *y, mplapackint const incy, double *c, std::complex<double> *s, mplapackint const incc);
void Clarz(const char *side, mplapackint const m, mplapackint const n, mplapackint const l, std::complex<double> *v, mplapackint const incv, std::complex<double> const tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work);
void Clarzb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<double> *v, mplapackint const ldv, std::complex<double> *t, mplapackint const ldt, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const ldwork);
void Clarzt(const char *direct, const char *storev, mplapackint const n, mplapackint const k, std::complex<double> *v, mplapackint const ldv, std::complex<double> *tau, std::complex<double> *t, mplapackint const ldt);
void Clascl(const char *type, mplapackint const kl, mplapackint const ku, double const cfrom, double const cto, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint &info);
void Clascl2(mplapackint const m, mplapackint const n, double *d, std::complex<double> *x, mplapackint const ldx);
void Claset(const char *uplo, mplapackint const m, mplapackint const n, std::complex<double> const alpha, std::complex<double> const beta, std::complex<double> *a, mplapackint const lda);
void Clasr(const char *side, const char *pivot, const char *direct, mplapackint const m, mplapackint const n, double *c, double *s, std::complex<double> *a, mplapackint const lda);
void Classq(mplapackint const n, std::complex<double> *x, mplapackint const incx, double &scale, double &sumsq);
void Claswlq(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const ldt, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Claswp(mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint const k1, mplapackint const k2, mplapackint *ipiv, mplapackint const incx);
void Clasyf(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *w, mplapackint const ldw, mplapackint &info);
void Clasyf_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *h, mplapackint const ldh, std::complex<double> *work);
void Clasyf_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *w, mplapackint const ldw, mplapackint &info);
void Clasyf_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *w, mplapackint const ldw, mplapackint &info);
void Clatbs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *x, double &scale, double *cnorm, mplapackint &info);
void Clatdf(mplapackint const ijob, mplapackint const n, std::complex<double> *z, mplapackint const ldz, std::complex<double> *rhs, double &rdsum, double &rdscal, mplapackint *ipiv, mplapackint *jpiv);
void Clatps(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, std::complex<double> *ap, std::complex<double> *x, double &scale, double *cnorm, mplapackint &info);
void Clatrd(const char *uplo, mplapackint const n, mplapackint const nb, std::complex<double> *a, mplapackint const lda, double *e, std::complex<double> *tau, std::complex<double> *w, mplapackint const ldw);
void Clatrs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, double &scale, double *cnorm, mplapackint &info);
void Clatrz(mplapackint const m, mplapackint const n, mplapackint const l, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work);
void Clatsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const ldt, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Claunhr_col_getrfnp(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *d, mplapackint &info);
void Claunhr_col_getrfnp2(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *d, mplapackint &info);
void Clauu2(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint &info);
void Clauum(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint &info);
void Cpbcon(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, double const anorm, double &rcond, std::complex<double> *work, double *rwork, mplapackint &info);
void Cpbequ(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, double *s, double &scond, double &amax, mplapackint &info);
void Cpbrfs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *afb, mplapackint const ldafb, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cpbstf(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, mplapackint &info);
void Cpbsv(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cpbsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *afb, mplapackint const ldafb, char *equed, double *s, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cpbtf2(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, mplapackint &info);
void Cpbtrf(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, mplapackint &info);
void Cpbtrs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cpftrf(const char *transr, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint &info);
void Cpftri(const char *transr, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint &info);
void Cpftrs(const char *transr, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cpocon(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double const anorm, double &rcond, std::complex<double> *work, double *rwork, mplapackint &info);
void Cpoequ(mplapackint const n, std::complex<double> *a, mplapackint const lda, double *s, double &scond, double &amax, mplapackint &info);
void Cpoequb(mplapackint const n, std::complex<double> *a, mplapackint const lda, double *s, double &scond, double &amax, mplapackint &info);
void Cporfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *af, mplapackint const ldaf, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cposv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cposvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *af, mplapackint const ldaf, char *equed, double *s, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cpotf2(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint &info);
void Cpotrf(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint &info);
void Cpotrf2(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint &info);
void Cpotri(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint &info);
void Cpotrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cppcon(const char *uplo, mplapackint const n, std::complex<double> *ap, double const anorm, double &rcond, std::complex<double> *work, double *rwork, mplapackint &info);
void Cppequ(const char *uplo, mplapackint const n, std::complex<double> *ap, double *s, double &scond, double &amax, mplapackint &info);
void Cpprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, std::complex<double> *afp, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cppsv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cppsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, std::complex<double> *afp, char *equed, double *s, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cpptrf(const char *uplo, mplapackint const n, std::complex<double> *ap, mplapackint &info);
void Cpptri(const char *uplo, mplapackint const n, std::complex<double> *ap, mplapackint &info);
void Cpptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cpstf2(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, double const tol, double *work, mplapackint &info);
void Cpstrf(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, double const tol, double *work, mplapackint &info);
void Cptcon(mplapackint const n, double *d, std::complex<double> *e, double const anorm, double &rcond, double *rwork, mplapackint &info);
void Cpteqr(const char *compz, mplapackint const n, double *d, double *e, std::complex<double> *z, mplapackint const ldz, double *work, mplapackint &info);
void Cptrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, double *d, std::complex<double> *e, double *df, std::complex<double> *ef, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cptsv(mplapackint const n, mplapackint const nrhs, double *d, std::complex<double> *e, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cptsvx(const char *fact, mplapackint const n, mplapackint const nrhs, double *d, std::complex<double> *e, double *df, std::complex<double> *ef, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cpttrf(mplapackint const n, double *d, std::complex<double> *e, mplapackint &info);
void Cpttrs(const char *uplo, mplapackint const n, mplapackint const nrhs, double *d, std::complex<double> *e, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cptts2(mplapackint const iuplo, mplapackint const n, mplapackint const nrhs, double *d, std::complex<double> *e, std::complex<double> *b, mplapackint const ldb);
void Crot(mplapackint const n, std::complex<double> *cx, mplapackint const incx, std::complex<double> *cy, mplapackint const incy, double const c, std::complex<double> const s);
void Cspcon(const char *uplo, mplapackint const n, std::complex<double> *ap, mplapackint *ipiv, double const anorm, double &rcond, std::complex<double> *work, mplapackint &info);
void Cspmv(const char *uplo, mplapackint const n, std::complex<double> const alpha, std::complex<double> *ap, std::complex<double> *x, mplapackint const incx, std::complex<double> const beta, std::complex<double> *y, mplapackint const incy);
void Cspr(const char *uplo, mplapackint const n, std::complex<double> const alpha, std::complex<double> *x, mplapackint const incx, std::complex<double> *ap);
void Csprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, std::complex<double> *afp, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Cspsv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cspsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, std::complex<double> *afp, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Csptrf(const char *uplo, mplapackint const n, std::complex<double> *ap, mplapackint *ipiv, mplapackint &info);
void Csptri(const char *uplo, mplapackint const n, std::complex<double> *ap, mplapackint *ipiv, std::complex<double> *work, mplapackint &info);
void Csptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Cstedc(const char *compz, mplapackint const n, double *d, double *e, std::complex<double> *z, mplapackint const ldz, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cstein(mplapackint const n, double *d, double *e, mplapackint const m, double *w, mplapackint *iblock, mplapackint *isplit, std::complex<double> *z, mplapackint const ldz, double *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cstemr(const char *jobz, const char *range, mplapackint const n, double *d, double *e, double const vl, double const vu, mplapackint const il, mplapackint const iu, mplapackint &m, double *w, std::complex<double> *z, mplapackint const ldz, mplapackint const nzc, mplapackint *isuppz, bool &tryrac, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Csteqr(const char *compz, mplapackint const n, double *d, double *e, std::complex<double> *z, mplapackint const ldz, double *work, mplapackint &info);
void Csycon(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, double const anorm, double &rcond, std::complex<double> *work, mplapackint &info);
void Csycon_3(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, double const anorm, double &rcond, std::complex<double> *work, mplapackint &info);
void Csycon_rook(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, double const anorm, double &rcond, std::complex<double> *work, mplapackint &info);
void Csyconv(const char *uplo, const char *way, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *e, mplapackint &info);
void Csyconvf(const char *uplo, const char *way, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, mplapackint &info);
void Csyconvf_rook(const char *uplo, const char *way, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, mplapackint &info);
void Csyequb(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *s, double &scond, double &amax, std::complex<double> *work, mplapackint &info);
void Csymv(const char *uplo, mplapackint const n, std::complex<double> const alpha, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const incx, std::complex<double> const beta, std::complex<double> *y, mplapackint const incy);
void Csyr(const char *uplo, mplapackint const n, std::complex<double> const alpha, std::complex<double> *x, mplapackint const incx, std::complex<double> *a, mplapackint const lda);
void Csyrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Csysv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Csysv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Csysv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Csysv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Csysv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Csysvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint &info);
void Csyswapr(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Csytf2(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Csytf2_rk(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, mplapackint &info);
void Csytf2_rook(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Csytrf(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Csytrf_aa(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Csytrf_aa_2stage(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Csytrf_rk(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Csytrf_rook(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Csytri(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint &info);
void Csytri2(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Csytri2x(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint const nb, mplapackint &info);
void Csytri_3(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Csytri_3x(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *work, mplapackint const nb, mplapackint &info);
void Csytri_rook(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *work, mplapackint &info);
void Csytrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Csytrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint &info);
void Csytrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Csytrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Csytrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Csytrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Ctbcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, double &rcond, std::complex<double> *work, double *rwork, mplapackint &info);
void Ctbrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Ctbtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Ctfsm(const char *transr, const char *side, const char *uplo, const char *trans, const char *diag, mplapackint const m, mplapackint const n, std::complex<double> const alpha, std::complex<double> *a, std::complex<double> *b, mplapackint const ldb);
void Ctftri(const char *transr, const char *uplo, const char *diag, mplapackint const n, std::complex<double> *a, mplapackint &info);
void Ctfttp(const char *transr, const char *uplo, mplapackint const n, std::complex<double> *arf, std::complex<double> *ap, mplapackint &info);
void Ctfttr(const char *transr, const char *uplo, mplapackint const n, std::complex<double> *arf, std::complex<double> *a, mplapackint const lda, mplapackint &info);
void Ctgevc(const char *side, const char *howmny, bool *select, mplapackint const n, std::complex<double> *s, mplapackint const lds, std::complex<double> *p, mplapackint const ldp, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, std::complex<double> *work, double *rwork, mplapackint &info);
void Ctgex2(bool const wantq, bool const wantz, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *q, mplapackint const ldq, std::complex<double> *z, mplapackint const ldz, mplapackint const j1, mplapackint &info);
void Ctgexc(bool const wantq, bool const wantz, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *q, mplapackint const ldq, std::complex<double> *z, mplapackint const ldz, mplapackint const ifst, mplapackint &ilst, mplapackint &info);
void Ctgsen(mplapackint const ijob, bool const wantq, bool const wantz, bool *select, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *alpha, std::complex<double> *beta, std::complex<double> *q, mplapackint const ldq, std::complex<double> *z, mplapackint const ldz, mplapackint &m, double &pl, double &pr, double *dif, std::complex<double> *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Ctgsja(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, double const tola, double const tolb, double *alpha, double *beta, std::complex<double> *u, mplapackint const ldu, std::complex<double> *v, mplapackint const ldv, std::complex<double> *q, mplapackint const ldq, std::complex<double> *work, mplapackint &ncycle, mplapackint &info);
void Ctgsna(const char *job, const char *howmny, bool *select, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, double *s, double *dif, mplapackint const mm, mplapackint &m, std::complex<double> *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Ctgsy2(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *c, mplapackint const ldc, std::complex<double> *d, mplapackint const ldd, std::complex<double> *e, mplapackint const lde, std::complex<double> *f, mplapackint const ldf, double &scale, double &rdsum, double &rdscal, mplapackint &info);
void Ctgsyl(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *c, mplapackint const ldc, std::complex<double> *d, mplapackint const ldd, std::complex<double> *e, mplapackint const lde, std::complex<double> *f, mplapackint const ldf, double &scale, double &dif, std::complex<double> *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Ctpcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, std::complex<double> *ap, double &rcond, std::complex<double> *work, double *rwork, mplapackint &info);
void Ctplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *t, mplapackint const ldt, std::complex<double> *work, mplapackint &info);
void Ctplqt2(mplapackint const m, mplapackint const n, mplapackint const l, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *t, mplapackint const ldt, mplapackint &info);
void Ctpmlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const mb, std::complex<double> *v, mplapackint const ldv, std::complex<double> *t, mplapackint const ldt, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint &info);
void Ctpmqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const nb, std::complex<double> *v, mplapackint const ldv, std::complex<double> *t, mplapackint const ldt, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint &info);
void Ctpqrt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *t, mplapackint const ldt, std::complex<double> *work, mplapackint &info);
void Ctpqrt2(mplapackint const m, mplapackint const n, mplapackint const l, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *t, mplapackint const ldt, mplapackint &info);
void Ctprfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<double> *v, mplapackint const ldv, std::complex<double> *t, mplapackint const ldt, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const ldwork);
void Ctprfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Ctptri(const char *uplo, const char *diag, mplapackint const n, std::complex<double> *ap, mplapackint &info);
void Ctptrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Ctpttf(const char *transr, const char *uplo, mplapackint const n, std::complex<double> *ap, std::complex<double> *arf, mplapackint &info);
void Ctpttr(const char *uplo, mplapackint const n, std::complex<double> *ap, std::complex<double> *a, mplapackint const lda, mplapackint &info);
void Ctrcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, std::complex<double> *a, mplapackint const lda, double &rcond, std::complex<double> *work, double *rwork, mplapackint &info);
void Ctrevc(const char *side, const char *howmny, bool *select, mplapackint const n, std::complex<double> *t, mplapackint const ldt, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, std::complex<double> *work, double *rwork, mplapackint &info);
void Ctrevc3(const char *side, const char *howmny, bool *select, mplapackint const n, std::complex<double> *t, mplapackint const ldt, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint &info);
void Ctrexc(const char *compq, mplapackint const n, std::complex<double> *t, mplapackint const ldt, std::complex<double> *q, mplapackint const ldq, mplapackint const ifst, mplapackint const ilst, mplapackint &info);
void Ctrrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, double *ferr, double *berr, std::complex<double> *work, double *rwork, mplapackint &info);
void Ctrsen(const char *job, const char *compq, bool *select, mplapackint const n, std::complex<double> *t, mplapackint const ldt, std::complex<double> *q, mplapackint const ldq, std::complex<double> *w, mplapackint &m, double &s, double &sep, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Ctrsna(const char *job, const char *howmny, bool *select, mplapackint const n, std::complex<double> *t, mplapackint const ldt, std::complex<double> *vl, mplapackint const ldvl, std::complex<double> *vr, mplapackint const ldvr, double *s, double *sep, mplapackint const mm, mplapackint &m, std::complex<double> *work, mplapackint const ldwork, double *rwork, mplapackint &info);
void Ctrsyl(const char *trana, const char *tranb, mplapackint const isgn, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *c, mplapackint const ldc, double &scale, mplapackint &info);
void Ctrti2(const char *uplo, const char *diag, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint &info);
void Ctrtri(const char *uplo, const char *diag, mplapackint const n, std::complex<double> *a, mplapackint const lda, mplapackint &info);
void Ctrtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Ctrttf(const char *transr, const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *arf, mplapackint &info);
void Ctrttp(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *ap, mplapackint &info);
void Ctzrzf(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb(const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, std::complex<double> *x11, mplapackint const ldx11, std::complex<double> *x12, mplapackint const ldx12, std::complex<double> *x21, mplapackint const ldx21, std::complex<double> *x22, mplapackint const ldx22, double *theta, double *phi, std::complex<double> *taup1, std::complex<double> *taup2, std::complex<double> *tauq1, std::complex<double> *tauq2, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb1(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<double> *x11, mplapackint const ldx11, std::complex<double> *x21, mplapackint const ldx21, double *theta, double *phi, std::complex<double> *taup1, std::complex<double> *taup2, std::complex<double> *tauq1, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb2(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<double> *x11, mplapackint const ldx11, std::complex<double> *x21, mplapackint const ldx21, double *theta, double *phi, std::complex<double> *taup1, std::complex<double> *taup2, std::complex<double> *tauq1, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb3(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<double> *x11, mplapackint const ldx11, std::complex<double> *x21, mplapackint const ldx21, double *theta, double *phi, std::complex<double> *taup1, std::complex<double> *taup2, std::complex<double> *tauq1, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb4(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<double> *x11, mplapackint const ldx11, std::complex<double> *x21, mplapackint const ldx21, double *theta, double *phi, std::complex<double> *taup1, std::complex<double> *taup2, std::complex<double> *tauq1, std::complex<double> *phantom, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb5(mplapackint const m1, mplapackint const m2, mplapackint const n, std::complex<double> *x1, mplapackint const incx1, std::complex<double> *x2, mplapackint const incx2, std::complex<double> *q1, mplapackint const ldq1, std::complex<double> *q2, mplapackint const ldq2, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb6(mplapackint const m1, mplapackint const m2, mplapackint const n, std::complex<double> *x1, mplapackint const incx1, std::complex<double> *x2, mplapackint const incx2, std::complex<double> *q1, mplapackint const ldq1, std::complex<double> *q2, mplapackint const ldq2, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cuncsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, std::complex<double> *x11, mplapackint const ldx11, std::complex<double> *x12, mplapackint const ldx12, std::complex<double> *x21, mplapackint const ldx21, std::complex<double> *x22, mplapackint const ldx22, double *theta, std::complex<double> *u1, mplapackint const ldu1, std::complex<double> *u2, mplapackint const ldu2, std::complex<double> *v1t, mplapackint const ldv1t, std::complex<double> *v2t, mplapackint const ldv2t, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cuncsd2by1(const char *jobu1, const char *jobu2, const char *jobv1t, mplapackint const m, mplapackint const p, mplapackint const q, std::complex<double> *x11, mplapackint const ldx11, std::complex<double> *x21, mplapackint const ldx21, double *theta, std::complex<double> *u1, mplapackint const ldu1, std::complex<double> *u2, mplapackint const ldu2, std::complex<double> *v1t, mplapackint const ldv1t, std::complex<double> *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cung2l(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint &info);
void Cung2r(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint &info);
void Cungbr(const char *vect, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunghr(mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cungl2(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint &info);
void Cunglq(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cungql(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cungqr(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cungr2(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint &info);
void Cungrq(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cungtr(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cungtsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const ldt, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cungtsqr_row(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const ldt, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunhr_col(mplapackint const m, mplapackint const n, mplapackint const nb, std::complex<double> *a, mplapackint const lda, std::complex<double> *t, mplapackint const ldt, std::complex<double> *d, mplapackint &info);
void Cunm22(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const n1, mplapackint const n2, std::complex<double> *q, mplapackint const ldq, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunm2l(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint &info);
void Cunm2r(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint &info);
void Cunmbr(const char *vect, const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunmhr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunml2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint &info);
void Cunmlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunmql(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunmqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunmr2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint &info);
void Cunmr3(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint &info);
void Cunmrq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunmrz(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cunmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cupgtr(const char *uplo, mplapackint const n, std::complex<double> *ap, std::complex<double> *tau, std::complex<double> *q, mplapackint const ldq, std::complex<double> *work, mplapackint &info);
void Cupmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, std::complex<double> *ap, std::complex<double> *tau, std::complex<double> *c, mplapackint const ldc, std::complex<double> *work, mplapackint &info);
void Rbbcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, mplapackint const m, mplapackint const p, mplapackint const q, double *theta, double *phi, double *u1, mplapackint const ldu1, double *u2, mplapackint const ldu2, double *v1t, mplapackint const ldv1t, double *v2t, mplapackint const ldv2t, double *b11d, double *b11e, double *b12d, double *b12e, double *b21d, double *b21e, double *b22d, double *b22e, double *work, mplapackint const lwork, mplapackint &info);
void Rbdsdc(const char *uplo, const char *compq, mplapackint const n, double *d, double *e, double *u, mplapackint const ldu, double *vt, mplapackint const ldvt, double *q, mplapackint *iq, double *work, mplapackint *iwork, mplapackint &info);
void Rbdsqr(const char *uplo, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, double *d, double *e, double *vt, mplapackint const ldvt, double *u, mplapackint const ldu, double *c, mplapackint const ldc, double *work, mplapackint &info);
void Rbdsvdx(const char *uplo, const char *jobz, const char *range, mplapackint const n, double *d, double *e, double const vl, double const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, double *s, double *z, mplapackint const ldz, double *work, mplapackint *iwork, mplapackint &info);
void Rcombssq(double *v1, double *v2);
void Rdisna(const char *job, mplapackint const m, mplapackint const n, double *d, double *sep, mplapackint &info);
void Rgbbrd(const char *vect, mplapackint const m, mplapackint const n, mplapackint const ncc, mplapackint const kl, mplapackint const ku, double *ab, mplapackint const ldab, double *d, double *e, double *q, mplapackint const ldq, double *pt, mplapackint const ldpt, double *c, mplapackint const ldc, double *work, mplapackint &info);
void Rgbcon(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, double *ab, mplapackint const ldab, mplapackint *ipiv, double const anorm, double &rcond, double *work, mplapackint *iwork, mplapackint &info);
void Rgbequ(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, double *ab, mplapackint const ldab, double *r, double *c, double &rowcnd, double &colcnd, double &amax, mplapackint &info);
void Rgbequb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, double *ab, mplapackint const ldab, double *r, double *c, double &rowcnd, double &colcnd, double &amax, mplapackint &info);
void Rgbrfs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, double *ab, mplapackint const ldab, double *afb, mplapackint const ldafb, mplapackint *ipiv, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rgbsv(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, double *ab, mplapackint const ldab, mplapackint *ipiv, double *b, mplapackint const ldb, mplapackint &info);
void Rgbsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, double *ab, mplapackint const ldab, double *afb, mplapackint const ldafb, mplapackint *ipiv, char *equed, double *r, double *c, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rgbtf2(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, double *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Rgbtrf(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, double *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Rgbtrs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, double *ab, mplapackint const ldab, mplapackint *ipiv, double *b, mplapackint const ldb, mplapackint &info);
void Rgebak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *scale, mplapackint const m, double *v, mplapackint const ldv, mplapackint &info);
void Rgebal(const char *job, mplapackint const n, double *a, mplapackint const lda, mplapackint &ilo, mplapackint &ihi, double *scale, mplapackint &info);
void Rgebd2(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *d, double *e, double *tauq, double *taup, double *work, mplapackint &info);
void Rgebrd(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *d, double *e, double *tauq, double *taup, double *work, mplapackint const lwork, mplapackint &info);
void Rgecon(const char *norm, mplapackint const n, double *a, mplapackint const lda, double const anorm, double &rcond, double *work, mplapackint *iwork, mplapackint &info);
void Rgeequ(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *r, double *c, double &rowcnd, double &colcnd, double &amax, mplapackint &info);
void Rgeequb(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *r, double *c, double &rowcnd, double &colcnd, double &amax, mplapackint &info);
void Rgees(const char *jobvs, const char *sort, bool (*select)(double, double), mplapackint const n, double *a, mplapackint const lda, mplapackint &sdim, double *wr, double *wi, double *vs, mplapackint const ldvs, double *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rgeesx(const char *jobvs, const char *sort, bool (*select)(double, double), const char *sense, mplapackint const n, double *a, mplapackint const lda, mplapackint &sdim, double *wr, double *wi, double *vs, mplapackint const ldvs, double &rconde, double &rcondv, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rgeev(const char *jobvl, const char *jobvr, mplapackint const n, double *a, mplapackint const lda, double *wr, double *wi, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, double *work, mplapackint const lwork, mplapackint &info);
void Rgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, double *a, mplapackint const lda, double *wr, double *wi, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, double *scale, double &abnrm, double *rconde, double *rcondv, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgehd2(mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *a, mplapackint const lda, double *tau, double *work, mplapackint &info);
void Rgehrd(mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rgejsv(const char *joba, const char *jobu, const char *jobv, const char *jobr, const char *jobt, const char *jobp, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *sva, double *u, mplapackint const ldu, double *v, mplapackint const ldv, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgelq(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *t, mplapackint const tsize, double *work, mplapackint const lwork, mplapackint &info);
void Rgelq2(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *tau, double *work, mplapackint &info);
void Rgelqf(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rgelqt(mplapackint const m, mplapackint const n, mplapackint const mb, double *a, mplapackint const lda, double *t, mplapackint const ldt, double *work, mplapackint &info);
void Rgelqt3(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *t, mplapackint const ldt, mplapackint &info);
void Rgels(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *work, mplapackint const lwork, mplapackint &info);
void Rgelsd(mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *s, double const rcond, mplapackint &rank, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgelss(mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *s, double const rcond, mplapackint &rank, double *work, mplapackint const lwork, mplapackint &info);
void Rgelsy(mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *b, mplapackint const ldb, mplapackint *jpvt, double const rcond, mplapackint &rank, double *work, mplapackint const lwork, mplapackint &info);
void Rgemlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *t, mplapackint const tsize, double *c, mplapackint const ldc, double *work, mplapackint const lwork, mplapackint &info);
void Rgemlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, double *v, mplapackint const ldv, double *t, mplapackint const ldt, double *c, mplapackint const ldc, double *work, mplapackint &info);
void Rgemqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *t, mplapackint const tsize, double *c, mplapackint const ldc, double *work, mplapackint const lwork, mplapackint &info);
void Rgemqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const nb, double *v, mplapackint const ldv, double *t, mplapackint const ldt, double *c, mplapackint const ldc, double *work, mplapackint &info);
void Rgeql2(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *tau, double *work, mplapackint &info);
void Rgeqlf(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rgeqp3(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, mplapackint *jpvt, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rgeqr(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *t, mplapackint const tsize, double *work, mplapackint const lwork, mplapackint &info);
void Rgeqr2(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *tau, double *work, mplapackint &info);
void Rgeqr2p(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *tau, double *work, mplapackint &info);
void Rgeqrf(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rgeqrfp(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rgeqrt(mplapackint const m, mplapackint const n, mplapackint const nb, double *a, mplapackint const lda, double *t, mplapackint const ldt, double *work, mplapackint &info);
void Rgeqrt2(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *t, mplapackint const ldt, mplapackint &info);
void Rgeqrt3(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *t, mplapackint const ldt, mplapackint &info);
void Rgerfs(const char *trans, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *af, mplapackint const ldaf, mplapackint *ipiv, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rgerq2(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *tau, double *work, mplapackint &info);
void Rgerqf(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rgesc2(mplapackint const n, double *a, mplapackint const lda, double *rhs, mplapackint *ipiv, mplapackint *jpiv, double &scale);
void Rgesdd(const char *jobz, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *s, double *u, mplapackint const ldu, double *vt, mplapackint const ldvt, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgesv(mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, mplapackint *ipiv, double *b, mplapackint const ldb, mplapackint &info);
void Rgesvd(const char *jobu, const char *jobvt, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *s, double *u, mplapackint const ldu, double *vt, mplapackint const ldvt, double *work, mplapackint const lwork, mplapackint &info);
void Rgesvdq(const char *joba, const char *jobp, const char *jobr, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *s, double *u, mplapackint const ldu, double *v, mplapackint const ldv, mplapackint &numrank, mplapackint *iwork, mplapackint const liwork, double *work, mplapackint const lwork, double *rwork, mplapackint const lrwork, mplapackint &info);
void Rgesvdx(const char *jobu, const char *jobvt, const char *range, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double const vl, double const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, double *s, double *u, mplapackint const ldu, double *vt, mplapackint const ldvt, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgesvj(const char *joba, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *sva, mplapackint const mv, double *v, mplapackint const ldv, double *work, mplapackint const lwork, mplapackint &info);
void Rgesvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *af, mplapackint const ldaf, mplapackint *ipiv, char *equed, double *r, double *c, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rgetc2(mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, mplapackint *jpiv, mplapackint &info);
void Rgetf2(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetrf(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetrf2(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetri(mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, double *work, mplapackint const lwork, mplapackint &info);
void Rgetrs(const char *trans, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, mplapackint *ipiv, double *b, mplapackint const ldb, mplapackint &info);
void Rgetsls(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *work, mplapackint const lwork, mplapackint &info);
void Rgetsqrhrt(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, double *a, mplapackint const lda, double *t, mplapackint const ldt, double *work, mplapackint const lwork, mplapackint &info);
void Rggbak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *lscale, double *rscale, mplapackint const m, double *v, mplapackint const ldv, mplapackint &info);
void Rggbal(const char *job, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, mplapackint &ilo, mplapackint &ihi, double *lscale, double *rscale, double *work, mplapackint &info);
void Rgges(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(double, double, double), mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, mplapackint &sdim, double *alphar, double *alphai, double *beta, double *vsl, mplapackint const ldvsl, double *vsr, mplapackint const ldvsr, double *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rgges3(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(double, double, double), mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, mplapackint &sdim, double *alphar, double *alphai, double *beta, double *vsl, mplapackint const ldvsl, double *vsr, mplapackint const ldvsr, double *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rggesx(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(double, double, double), const char *sense, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, mplapackint &sdim, double *alphar, double *alphai, double *beta, double *vsl, mplapackint const ldvsl, double *vsr, mplapackint const ldvsr, double *rconde, double *rcondv, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rggev(const char *jobvl, const char *jobvr, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *alphar, double *alphai, double *beta, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, double *work, mplapackint const lwork, mplapackint &info);
void Rggev3(const char *jobvl, const char *jobvr, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *alphar, double *alphai, double *beta, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, double *work, mplapackint const lwork, mplapackint &info);
void Rggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *alphar, double *alphai, double *beta, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, double *lscale, double *rscale, double &abnrm, double &bbnrm, double *rconde, double *rcondv, double *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rggglm(mplapackint const n, mplapackint const m, mplapackint const p, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *d, double *x, double *y, double *work, mplapackint const lwork, mplapackint &info);
void Rgghd3(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *q, mplapackint const ldq, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint &info);
void Rgghrd(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *q, mplapackint const ldq, double *z, mplapackint const ldz, mplapackint &info);
void Rgglse(mplapackint const m, mplapackint const n, mplapackint const p, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *c, double *d, double *x, double *work, mplapackint const lwork, mplapackint &info);
void Rggqrf(mplapackint const n, mplapackint const m, mplapackint const p, double *a, mplapackint const lda, double *taua, double *b, mplapackint const ldb, double *taub, double *work, mplapackint const lwork, mplapackint &info);
void Rggrqf(mplapackint const m, mplapackint const p, mplapackint const n, double *a, mplapackint const lda, double *taua, double *b, mplapackint const ldb, double *taub, double *work, mplapackint const lwork, mplapackint &info);
void Rggsvd3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const n, mplapackint const p, mplapackint &k, mplapackint &l, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *alpha, double *beta, double *u, mplapackint const ldu, double *v, mplapackint const ldv, double *q, mplapackint const ldq, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rggsvp3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double const tola, double const tolb, mplapackint &k, mplapackint &l, double *u, mplapackint const ldu, double *v, mplapackint const ldv, double *q, mplapackint const ldq, mplapackint *iwork, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rgsvj0(const char *jobv, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *d, double *sva, mplapackint const mv, double *v, mplapackint const ldv, double const eps, double const sfmin, double const tol, mplapackint const nsweep, double *work, mplapackint const lwork, mplapackint &info);
void Rgsvj1(const char *jobv, mplapackint const m, mplapackint const n, mplapackint const n1, double *a, mplapackint const lda, double *d, double *sva, mplapackint const mv, double *v, mplapackint const ldv, double const eps, double const sfmin, double const tol, mplapackint const nsweep, double *work, mplapackint const lwork, mplapackint &info);
void Rgtcon(const char *norm, mplapackint const n, double *dl, double *d, double *du, double *du2, mplapackint *ipiv, double const anorm, double &rcond, double *work, mplapackint *iwork, mplapackint &info);
void Rgtrfs(const char *trans, mplapackint const n, mplapackint const nrhs, double *dl, double *d, double *du, double *dlf, double *df, double *duf, double *du2, mplapackint *ipiv, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rgtsv(mplapackint const n, mplapackint const nrhs, double *dl, double *d, double *du, double *b, mplapackint const ldb, mplapackint &info);
void Rgtsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, double *dl, double *d, double *du, double *dlf, double *df, double *duf, double *du2, mplapackint *ipiv, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rgttrf(mplapackint const n, double *dl, double *d, double *du, double *du2, mplapackint *ipiv, mplapackint &info);
void Rgttrs(const char *trans, mplapackint const n, mplapackint const nrhs, double *dl, double *d, double *du, double *du2, mplapackint *ipiv, double *b, mplapackint const ldb, mplapackint &info);
void Rgtts2(mplapackint const itrans, mplapackint const n, mplapackint const nrhs, double *dl, double *d, double *du, double *du2, mplapackint *ipiv, double *b, mplapackint const ldb);
void Rhgeqz(const char *job, const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *h, mplapackint const ldh, double *t, mplapackint const ldt, double *alphar, double *alphai, double *beta, double *q, mplapackint const ldq, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint &info);
void Rhsein(const char *side, const char *eigsrc, const char *initv, bool *select, mplapackint const n, double *h, mplapackint const ldh, double *wr, double *wi, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, double *work, mplapackint *ifaill, mplapackint *ifailr, mplapackint &info);
void Rhseqr(const char *job, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *h, mplapackint const ldh, double *wr, double *wi, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint &info);
void Rla_gbamv(mplapackint const trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, double const alpha, double *ab, mplapackint const ldab, double *x, mplapackint const incx, double const beta, double *y, mplapackint const incy);
void Rla_geamv(mplapackint const trans, mplapackint const m, mplapackint const n, double const alpha, double *a, mplapackint const lda, double *x, mplapackint const incx, double const beta, double *y, mplapackint const incy);
void Rla_syamv(mplapackint const uplo, mplapackint const n, double const alpha, double *a, mplapackint const lda, double *x, mplapackint const incx, double const beta, double *y, mplapackint const incy);
void Rla_wwaddw(mplapackint const n, double *x, double *y, double *w);
void Rlabad(double &small, double &large);
void Rlabrd(mplapackint const m, mplapackint const n, mplapackint const nb, double *a, mplapackint const lda, double *d, double *e, double *tauq, double *taup, double *x, mplapackint const ldx, double *y, mplapackint const ldy);
void Rlacn2(mplapackint const n, double *v, double *x, mplapackint *isgn, double &est, mplapackint &kase, mplapackint *isave);
void Rlacon(mplapackint const n, double *v, double *x, mplapackint *isgn, double &est, mplapackint &kase);
void Rlacpy(const char *uplo, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb);
void Rladiv(double const &a, double const &b, double const &c, double const &d, double &p, double &q);
void Rladiv1(double &a, double const &b, double const &c, double const &d, double &p, double &q);
void Rlae2(double const a, double const b, double const c, double &rt1, double &rt2);
void Rlaebz(mplapackint const ijob, mplapackint const nitmax, mplapackint const n, mplapackint const mmax, mplapackint const minp, mplapackint const nbmin, double const abstol, double const reltol, double const pivmin, double *d, double *e, double *e2, mplapackint *nval, double *ab, double *c, mplapackint &mout, mplapackint *nab, double *work, mplapackint *iwork, mplapackint &info);
void Rlaed0(mplapackint const icompq, mplapackint const qsiz, mplapackint const n, double *d, double *e, double *q, mplapackint const ldq, double *qstore, mplapackint const ldqs, double *work, mplapackint *iwork, mplapackint &info);
void Rlaed1(mplapackint const n, double *d, double *q, mplapackint const ldq, mplapackint *indxq, double rho, mplapackint const cutpnt, double *work, mplapackint *iwork, mplapackint &info);
void Rlaed2(mplapackint &k, mplapackint const n, mplapackint const n1, double *d, double *q, mplapackint const ldq, mplapackint *indxq, double &rho, double *z, double *dlamda, double *w, double *q2, mplapackint *indx, mplapackint *indxc, mplapackint *indxp, mplapackint *coltyp, mplapackint &info);
void Rlaed3(mplapackint const k, mplapackint const n, mplapackint const n1, double *d, double *q, mplapackint const ldq, double const rho, double *dlamda, double *q2, mplapackint *indx, mplapackint *ctot, double *w, double *s, mplapackint &info);
void Rlaed4(mplapackint const n, mplapackint const i, double *d, double *z, double *delta, double const rho, double &dlam, mplapackint &info);
void Rlaed5(mplapackint const i, double *d, double *z, double *delta, double const rho, double &dlam);
void Rlaed6(mplapackint const kniter, bool const orgati, double const rho, double *d, double *z, double const finit, double &tau, mplapackint &info);
void Rlaed7(mplapackint const icompq, mplapackint const n, mplapackint const qsiz, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, double *d, double *q, mplapackint const ldq, mplapackint *indxq, double rho, mplapackint const cutpnt, double *qstore, mplapackint *qptr, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, double *givnum, double *work, mplapackint *iwork, mplapackint &info);
void Rlaed8(mplapackint const icompq, mplapackint &k, mplapackint const n, mplapackint const qsiz, double *d, double *q, mplapackint const ldq, mplapackint *indxq, double &rho, mplapackint const cutpnt, double *z, double *dlamda, double *q2, mplapackint const ldq2, double *w, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, double *givnum, mplapackint *indxp, mplapackint *indx, mplapackint &info);
void Rlaed9(mplapackint const k, mplapackint const kstart, mplapackint const kstop, mplapackint const n, double *d, double *q, mplapackint const ldq, double const rho, double *dlamda, double *w, double *s, mplapackint const lds, mplapackint &info);
void Rlaeda(mplapackint const n, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, double *givnum, double *q, mplapackint *qptr, double *z, double *ztemp, mplapackint &info);
void Rlaein(bool const rightv, bool const noinit, mplapackint const n, double *h, mplapackint const ldh, double const wr, double const wi, double *vr, double *vi, double *b, mplapackint const ldb, double *work, double const eps3, double const smlnum, double const bignum, mplapackint &info);
void Rlaev2(double const a, double const b, double const c, double &rt1, double &rt2, double &cs1, double &sn1);
void Rlaexc(bool const wantq, mplapackint const n, double *t, mplapackint const ldt, double *q, mplapackint const ldq, mplapackint const j1, mplapackint const n1, mplapackint const n2, double *work, mplapackint &info);
void Rlag2(double *a, mplapackint const lda, double *b, mplapackint const ldb, double const safmin, double &scale1, double &scale2, double &wr1, double &wr2, double &wi);
void Rlags2(bool const upper, double const a1, double const a2, double const a3, double const b1, double const b2, double const b3, double &csu, double &snu, double &csv, double &snv, double &csq, double &snq);
void Rlagtf(mplapackint const n, double *a, double const lambda, double *b, double *c, double const tol, double *d, mplapackint *in, mplapackint &info);
void Rlagtm(const char *trans, mplapackint const n, mplapackint const nrhs, double const alpha, double *dl, double *d, double *du, double *x, mplapackint const ldx, double const beta, double *b, mplapackint const ldb);
void Rlagts(mplapackint const job, mplapackint const n, double *a, double *b, double *c, double *d, mplapackint *in, double *y, double &tol, mplapackint &info);
void Rlagv2(double *a, mplapackint const lda, double *b, mplapackint const ldb, double *alphar, double *alphai, double *beta, double &csl, double &snl, double &csr, double &snr);
void Rlahqr(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *h, mplapackint const ldh, double *wr, double *wi, mplapackint const iloz, mplapackint const ihiz, double *z, mplapackint const ldz, mplapackint &info);
void Rlahr2(mplapackint const n, mplapackint const k, mplapackint const nb, double *a, mplapackint const lda, double *tau, double *t, mplapackint const ldt, double *y, mplapackint const ldy);
void Rlaic1(mplapackint const job, mplapackint const j, double *x, double const sest, double *w, double const gamma, double &sestpr, double &s, double &c);
void Rlaln2(bool const ltrans, mplapackint const na, mplapackint const nw, double const smin, double const ca, double *a, mplapackint const lda, double const d1, double const d2, double *b, mplapackint const ldb, double const wr, double const wi, double *x, mplapackint const ldx, double &scale, double &xnorm, mplapackint &info);
void Rlals0(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const nrhs, double *b, mplapackint const ldb, double *bx, mplapackint const ldbx, mplapackint *perm, mplapackint const givptr, mplapackint *givcol, mplapackint const ldgcol, double *givnum, mplapackint const ldgnum, double *poles, double *difl, double *difr, double *z, mplapackint const k, double const c, double const s, double *work, mplapackint &info);
void Rlalsa(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, double *b, mplapackint const ldb, double *bx, mplapackint const ldbx, double *u, mplapackint const ldu, double *vt, mplapackint *k, double *difl, double *difr, double *z, double *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, double *givnum, double *c, double *s, double *work, mplapackint *iwork, mplapackint &info);
void Rlalsd(const char *uplo, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, double *d, double *e, double *b, mplapackint const ldb, double const rcond, mplapackint &rank, double *work, mplapackint *iwork, mplapackint &info);
void Rlamrg(mplapackint const n1, mplapackint const n2, double *a, mplapackint const dtrd1, mplapackint const dtrd2, mplapackint *index);
void Rlamswlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, double *a, mplapackint const lda, double *t, mplapackint const ldt, double *c, mplapackint const ldc, double *work, mplapackint const lwork, mplapackint &info);
void Rlamtsqr(const char *side, const char *trans, mplapackint const &m, mplapackint const &n, mplapackint const &k, mplapackint const &mb, mplapackint const &nb, double *a, mplapackint const &lda, double *t, mplapackint const &ldt, double *c, mplapackint const &ldc, double *work, mplapackint const &lwork, mplapackint &info);
void Rlanv2(double &a, double &b, double &c, double &d, double &rt1r, double &rt1i, double &rt2r, double &rt2i, double &cs, double &sn);
void Rlaorhr_col_getrfnp(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *d, mplapackint &info);
void Rlaorhr_col_getrfnp2(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *d, mplapackint &info);
void Rlapll(mplapackint const n, double *x, mplapackint const incx, double *y, mplapackint const incy, double &ssmin);
void Rlapmr(bool const forwrd, mplapackint const m, mplapackint const n, double *x, mplapackint const ldx, mplapackint *k);
void Rlapmt(bool const forwrd, mplapackint const m, mplapackint const n, double *x, mplapackint const ldx, mplapackint *k);
void Rlaqgb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, double *ab, mplapackint const ldab, double *r, double *c, double const rowcnd, double const colcnd, double const amax, char *equed);
void Rlaqge(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *r, double *c, double const rowcnd, double const colcnd, double const amax, char *equed);
void Rlaqp2(mplapackint const m, mplapackint const n, mplapackint const offset, double *a, mplapackint const lda, mplapackint *jpvt, double *tau, double *vn1, double *vn2, double *work);
void Rlaqps(mplapackint const m, mplapackint const n, mplapackint const offset, mplapackint const nb, mplapackint &kb, double *a, mplapackint const lda, mplapackint *jpvt, double *tau, double *vn1, double *vn2, double *auxv, double *f, mplapackint const ldf);
void Rlaqr0(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *h, mplapackint const ldh, double *wr, double *wi, mplapackint const iloz, mplapackint const ihiz, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint &info);
void Rlaqr1(mplapackint const n, double *h, mplapackint const ldh, double const sr1, double const si1, double const sr2, double const si2, double *v);
void Rlaqr2(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, double *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, double *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, double *sr, double *si, double *v, mplapackint const ldv, mplapackint const nh, double *t, mplapackint const ldt, mplapackint const nv, double *wv, mplapackint const ldwv, double *work, mplapackint const lwork);
void Rlaqr3(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, double *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, double *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, double *sr, double *si, double *v, mplapackint const ldv, mplapackint const nh, double *t, mplapackint const ldt, mplapackint const nv, double *wv, mplapackint const ldwv, double *work, mplapackint const lwork);
void Rlaqr4(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *h, mplapackint const ldh, double *wr, double *wi, mplapackint const iloz, mplapackint const ihiz, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint &info);
void Rlaqr5(bool const wantt, bool const wantz, mplapackint const kacc22, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nshfts, double *sr, double *si, double *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, double *z, mplapackint const ldz, double *v, mplapackint const ldv, double *u, mplapackint const ldu, mplapackint const nv, double *wv, mplapackint const ldwv, mplapackint const nh, double *wh, mplapackint const ldwh);
void Rlaqsb(const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double *s, double const scond, double const amax, char *equed);
void Rlaqsp(const char *uplo, mplapackint const n, double *ap, double *s, double const scond, double const amax, char *equed);
void Rlaqsy(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *s, double const scond, double const amax, char *equed);
void Rlaqtr(bool const ltran, bool const lreal, mplapackint const n, double *t, mplapackint const ldt, double *b, double const w, double &scale, double *x, double *work, mplapackint &info);
void Rlar1v(mplapackint const n, mplapackint const b1, mplapackint const bn, double const lambda, double *d, double *l, double *ld, double *lld, double const pivmin, double const gaptol, double *z, bool const wantnc, mplapackint &negcnt, double &ztz, double &mingma, mplapackint &r, mplapackint *isuppz, double &nrminv, double &resid, double &rqcorr, double *work);
void Rlar2v(mplapackint const n, double *x, double *y, double *z, mplapackint const incx, double *c, double *s, mplapackint const incc);
void Rlarf(const char *side, mplapackint const m, mplapackint const n, double *v, mplapackint const incv, double const tau, double *c, mplapackint const ldc, double *work);
void Rlarfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, double *v, mplapackint const ldv, double *t, mplapackint const ldt, double *c, mplapackint const ldc, double *work, mplapackint const ldwork);
void Rlarfb_gett(const char *ident, mplapackint const m, mplapackint const n, mplapackint const k, double *t, mplapackint const ldt, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *work, mplapackint const ldwork);
void Rlarfg(mplapackint const n, double &alpha, double *x, mplapackint const incx, double &tau);
void Rlarfgp(mplapackint const n, double &alpha, double *x, mplapackint const incx, double &tau);
void Rlarft(const char *direct, const char *storev, mplapackint const n, mplapackint const k, double *v, mplapackint const ldv, double *tau, double *t, mplapackint const ldt);
void Rlarfx(const char *side, mplapackint const m, mplapackint const n, double *v, double const tau, double *c, mplapackint const ldc, double *work);
void Rlarfy(const char *uplo, mplapackint const n, double *v, mplapackint const incv, double const tau, double *c, mplapackint const ldc, double *work);
void Rlargv(mplapackint const n, double *x, mplapackint const incx, double *y, mplapackint const incy, double *c, mplapackint const incc);
void Rlarnv(mplapackint const idist, mplapackint *iseed, mplapackint const n, double *x);
void Rlarra(mplapackint const n, double *d, double *e, double *e2, double const spltol, double const tnrm, mplapackint &nsplit, mplapackint *isplit, mplapackint &info);
void Rlarrb(mplapackint const n, double *d, double *lld, mplapackint const ifirst, mplapackint const ilast, double const rtol1, double const rtol2, mplapackint const offset, double *w, double *wgap, double *werr, double *work, mplapackint *iwork, double const pivmin, double const spdiam, mplapackint const twist, mplapackint &info);
void Rlarrc(const char *jobt, mplapackint const n, double const vl, double const vu, double *d, double *e, double const, mplapackint &eigcnt, mplapackint &lcnt, mplapackint &rcnt, mplapackint &info);
void Rlarrd(const char *range, const char *order, mplapackint const n, double const vl, double const vu, mplapackint const il, mplapackint const iu, double *gers, double const reltol, double *d, double *e, double *e2, double const pivmin, mplapackint const nsplit, mplapackint *isplit, mplapackint &m, double *w, double *werr, double &wl, double &wu, mplapackint *iblock, mplapackint *indexw, double *work, mplapackint *iwork, mplapackint &info);
void Rlarre(const char *range, mplapackint const n, double &vl, double &vu, mplapackint const il, mplapackint const iu, double *d, double *e, double *e2, double const rtol1, double const rtol2, double const spltol, mplapackint nsplit, mplapackint *isplit, mplapackint &m, double *w, double *werr, double *wgap, mplapackint *iblock, mplapackint *indexw, double *gers, double &pivmin, double *work, mplapackint *iwork, mplapackint &info);
void Rlarrf(mplapackint const n, double *d, double *l, double *ld, mplapackint const clstrt, mplapackint const clend, double *w, double *wgap, double *werr, double const spdiam, double const clgapl, double const clgapr, double const pivmin, double &sigma, double *dplus, double *lplus, double *work, mplapackint &info);
void Rlarrj(mplapackint const n, double *d, double *e2, mplapackint const ifirst, mplapackint const ilast, double const rtol, mplapackint const offset, double *w, double *werr, double *work, mplapackint *iwork, double const pivmin, double const spdiam, mplapackint &info);
void Rlarrk(mplapackint const n, mplapackint const iw, double const gl, double const gu, double *d, double *e2, double const pivmin, double const reltol, double &w, double &werr, mplapackint &info);
void Rlarrr(mplapackint const n, double *d, double *e, mplapackint &info);
void Rlarrv(mplapackint const n, double const vl, double const, double *d, double *l, double const pivmin, mplapackint *isplit, mplapackint const m, mplapackint const dol, mplapackint const dou, double const minrgp, double &rtol1, double &rtol2, double *w, double *werr, double *wgap, mplapackint *iblock, mplapackint *indexw, double *gers, double *z, mplapackint const ldz, mplapackint *isuppz, double *work, mplapackint *iwork, mplapackint &info);
void Rlarscl2(mplapackint const m, mplapackint const n, double *d, double *x, mplapackint const ldx);
void Rlartg(double const f, double const g, double &cs, double &sn, double &r);
void Rlartgp(double const f, double const g, double &cs, double &sn, double &r);
void Rlartgs(double const x, double const y, double const sigma, double &cs, double &sn);
void Rlartv(mplapackint const n, double *x, mplapackint const incx, double *y, mplapackint const incy, double *c, double *s, mplapackint const incc);
void Rlaruv(mplapackint *iseed, mplapackint const n, double *x);
void Rlarz(const char *side, mplapackint const m, mplapackint const n, mplapackint const l, double *v, mplapackint const incv, double const tau, double *c, mplapackint const ldc, double *work);
void Rlarzb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, double *v, mplapackint const ldv, double *t, mplapackint const ldt, double *c, mplapackint const ldc, double *work, mplapackint const ldwork);
void Rlarzt(const char *direct, const char *storev, mplapackint const n, mplapackint const k, double *v, mplapackint const ldv, double *tau, double *t, mplapackint const ldt);
void Rlas2(double const f, double const g, double const h, double &ssmin, double &ssmax);
void Rlascl(const char *type, mplapackint const kl, mplapackint const ku, double const cfrom, double const cto, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, mplapackint &info);
void Rlascl2(mplapackint const m, mplapackint const n, double *d, double *x, mplapackint const ldx);
void Rlasd0(mplapackint const n, mplapackint const sqre, double *d, double *e, double *u, mplapackint const ldu, double *vt, mplapackint const ldvt, mplapackint const smlsiz, mplapackint *iwork, double *work, mplapackint &info);
void Rlasd1(mplapackint const nl, mplapackint const nr, mplapackint const sqre, double *d, double &alpha, double &beta, double *u, mplapackint const ldu, double *vt, mplapackint const ldvt, mplapackint *idxq, mplapackint *iwork, double *work, mplapackint &info);
void Rlasd2(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint &k, double *d, double *z, double const alpha, double const beta, double *u, mplapackint const ldu, double *vt, mplapackint const ldvt, double *dsigma, double *u2, mplapackint const ldu2, double *vt2, mplapackint const ldvt2, mplapackint *idxp, mplapackint *idx, mplapackint *idxc, mplapackint *idxq, mplapackint *coltyp, mplapackint &info);
void Rlasd3(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const k, double *d, double *q, mplapackint const ldq, double *dsigma, double *u, mplapackint const ldu, double *u2, mplapackint const ldu2, double *vt, mplapackint const ldvt, double *vt2, mplapackint const ldvt2, mplapackint *idxc, mplapackint *ctot, double *z, mplapackint &info);
void Rlasd4(mplapackint const n, mplapackint const i, double *d, double *z, double *delta, double const rho, double &sigma, double *work, mplapackint &info);
void Rlasd5(mplapackint const i, double *d, double *z, double *delta, double const rho, double &dsigma, double *work);
void Rlasd6(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, double *d, double *vf, double *vl, double &alpha, double &beta, mplapackint *idxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mplapackint const ldgcol, double *givnum, mplapackint const ldgnum, double *poles, double *difl, double *difr, double *z, mplapackint &k, double &c, double &s, double *work, mplapackint *iwork, mplapackint &info);
void Rlasd7(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint &k, double *d, double *z, double *zw, double *vf, double *vfw, double *vl, double *vlw, double const alpha, double const beta, double *dsigma, mplapackint *idx, mplapackint *idxp, mplapackint *idxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mplapackint const ldgcol, double *givnum, mplapackint const ldgnum, double &c, double &s, mplapackint &info);
void Rlasd8(mplapackint const icompq, mplapackint const k, double *d, double *z, double *vf, double *vl, double *difl, double *difr, mplapackint const lddifr, double *dsigma, double *work, mplapackint &info);
void Rlasda(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const sqre, double *d, double *e, double *u, mplapackint const ldu, double *vt, mplapackint *k, double *difl, double *difr, double *z, double *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, double *givnum, double *c, double *s, double *work, mplapackint *iwork, mplapackint &info);
void Rlasdq(const char *uplo, mplapackint const sqre, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, double *d, double *e, double *vt, mplapackint const ldvt, double *u, mplapackint const ldu, double *c, mplapackint const ldc, double *work, mplapackint &info);
void Rlasdt(mplapackint const n, mplapackint &lvl, mplapackint &nd, mplapackint *inode, mplapackint *ndiml, mplapackint *ndimr, mplapackint const msub);
void Rlaset(const char *uplo, mplapackint const m, mplapackint const n, double const alpha, double const beta, double *a, mplapackint const lda);
void Rlasq1(mplapackint const n, double *d, double *e, double *work, mplapackint &info);
void Rlasq2(mplapackint const n, double *z, mplapackint &info);
void Rlasq3(mplapackint const i0, mplapackint &n0, double *z, mplapackint &pp, double &dmin, double &sigma, double &desig, double &qmax, mplapackint &nfail, mplapackint &iter, mplapackint &ndiv, bool const ieee, mplapackint &ttype, double dmin1, double &dmin2, double dn, double dn1, double dn2, double g, double &tau);
void Rlasq4(mplapackint const i0, mplapackint const n0, double *z, mplapackint const pp, mplapackint const n0in, double const dmin, double const dmin1, double const dmin2, double const dn, double const dn1, double const dn2, double &tau, mplapackint &ttype, double &g);
void Rlasq5(mplapackint const i0, mplapackint const n0, double *z, mplapackint const pp, double &tau, double const sigma, double &dmin, double &dmin1, double &dmin2, double &dn, double &dnm1, double &dnm2, bool const ieee, double const eps);
void Rlasq6(mplapackint const i0, mplapackint const n0, double *z, mplapackint const pp, double &dmin, double &dmin1, double &dmin2, double &dn, double &dnm1, double &dnm2);
void Rlasr(const char *side, const char *pivot, const char *direct, mplapackint const m, mplapackint const n, double *c, double *s, double *a, mplapackint const lda);
void Rlasrt(const char *id, mplapackint const n, double *d, mplapackint &info);
void Rlassq(mplapackint const n, double *x, mplapackint const incx, double &scale, double &sumsq);
void Rlasv2(double const f, double const g, double const h, double &ssmin, double &ssmax, double &snr, double &csr, double &snl, double &csl);
void Rlaswlq(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, double *a, mplapackint const lda, double *t, mplapackint const ldt, double *work, mplapackint const lwork, mplapackint &info);
void Rlaswp(mplapackint const n, double *a, mplapackint const lda, mplapackint const k1, mplapackint const k2, mplapackint *ipiv, mplapackint const incx);
void Rlasy2(bool const ltranl, bool const ltranr, mplapackint const isgn, mplapackint const n1, mplapackint const n2, double *tl, mplapackint const ldtl, double *tr, mplapackint const ldtr, double *b, mplapackint const ldb, double &scale, double *x, mplapackint const ldx, double &xnorm, mplapackint &info);
void Rlasyf(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, double *a, mplapackint const lda, mplapackint *ipiv, double *w, mplapackint const ldw, mplapackint &info);
void Rlasyf_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, double *a, mplapackint const lda, mplapackint *ipiv, double *h, mplapackint const ldh, double *work);
void Rlasyf_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, double *a, mplapackint const lda, double *e, mplapackint *ipiv, double *w, mplapackint const ldw, mplapackint &info);
void Rlasyf_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, double *a, mplapackint const lda, mplapackint *ipiv, double *w, mplapackint const ldw, mplapackint &info);
void Rlatbs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double *x, double &scale, double *cnorm, mplapackint &info);
void Rlatdf(mplapackint const ijob, mplapackint const n, double *z, mplapackint const ldz, double *rhs, double &rdsum, double &rdscal, mplapackint *ipiv, mplapackint *jpiv);
void Rlatps(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, double *ap, double *x, double &scale, double *cnorm, mplapackint &info);
void Rlatrd(const char *uplo, mplapackint const n, mplapackint const nb, double *a, mplapackint const lda, double *e, double *tau, double *w, mplapackint const ldw);
void Rlatrs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, double *a, mplapackint const lda, double *x, double &scale, double *cnorm, mplapackint &info);
void Rlatrz(mplapackint const m, mplapackint const n, mplapackint const l, double *a, mplapackint const lda, double *tau, double *work);
void Rlatsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, double *a, mplapackint const lda, double *t, mplapackint const ldt, double *work, mplapackint const lwork, mplapackint &info);
void Rlauu2(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint &info);
void Rlauum(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint &info);
void Ropgtr(const char *uplo, mplapackint const n, double *ap, double *tau, double *q, mplapackint const ldq, double *work, mplapackint &info);
void Ropmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, double *ap, double *tau, double *c, mplapackint const ldc, double *work, mplapackint &info);
void Rorbdb(const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, double *x11, mplapackint const ldx11, double *x12, mplapackint const ldx12, double *x21, mplapackint const ldx21, double *x22, mplapackint const ldx22, double *theta, double *phi, double *taup1, double *taup2, double *tauq1, double *tauq2, double *work, mplapackint const lwork, mplapackint &info);
void Rorbdb1(mplapackint const m, mplapackint const p, mplapackint const q, double *x11, mplapackint const ldx11, double *x21, mplapackint const ldx21, double *theta, double *phi, double *taup1, double *taup2, double *tauq1, double *work, mplapackint const lwork, mplapackint &info);
void Rorbdb2(mplapackint const m, mplapackint const p, mplapackint const q, double *x11, mplapackint const ldx11, double *x21, mplapackint const ldx21, double *theta, double *phi, double *taup1, double *taup2, double *tauq1, double *work, mplapackint const lwork, mplapackint &info);
void Rorbdb3(mplapackint const m, mplapackint const p, mplapackint const q, double *x11, mplapackint const ldx11, double *x21, mplapackint const ldx21, double *theta, double *phi, double *taup1, double *taup2, double *tauq1, double *work, mplapackint const lwork, mplapackint &info);
void Rorbdb4(mplapackint const m, mplapackint const p, mplapackint const q, double *x11, mplapackint const ldx11, double *x21, mplapackint const ldx21, double *theta, double *phi, double *taup1, double *taup2, double *tauq1, double *phantom, double *work, mplapackint const lwork, mplapackint &info);
void Rorbdb5(mplapackint const m1, mplapackint const m2, mplapackint const n, double *x1, mplapackint const incx1, double *x2, mplapackint const incx2, double *q1, mplapackint const ldq1, double *q2, mplapackint const ldq2, double *work, mplapackint const lwork, mplapackint &info);
void Rorbdb6(mplapackint const m1, mplapackint const m2, mplapackint const n, double *x1, mplapackint const incx1, double *x2, mplapackint const incx2, double *q1, mplapackint const ldq1, double *q2, mplapackint const ldq2, double *work, mplapackint const lwork, mplapackint &info);
void Rorcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, double *x11, mplapackint const ldx11, double *x12, mplapackint const ldx12, double *x21, mplapackint const ldx21, double *x22, mplapackint const ldx22, double *theta, double *u1, mplapackint const ldu1, double *u2, mplapackint const ldu2, double *v1t, mplapackint const ldv1t, double *v2t, mplapackint const ldv2t, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rorcsd2by1(const char *jobu1, const char *jobu2, const char *jobv1t, mplapackint const m, mplapackint const p, mplapackint const q, double *x11, mplapackint const ldx11, double *x21, mplapackint const ldx21, double *theta, double *u1, mplapackint const ldu1, double *u2, mplapackint const ldu2, double *v1t, mplapackint const ldv1t, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rorg2l(mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *work, mplapackint &info);
void Rorg2r(mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *work, mplapackint &info);
void Rorgbr(const char *vect, mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rorghr(mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rorgl2(mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *work, mplapackint &info);
void Rorglq(mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rorgql(mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rorgqr(mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rorgr2(mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *work, mplapackint &info);
void Rorgrq(mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rorgtr(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rorgtsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, double *a, mplapackint const lda, double *t, mplapackint const ldt, double *work, mplapackint const lwork, mplapackint &info);
void Rorgtsqr_row(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, double *a, mplapackint const lda, double *t, mplapackint const ldt, double *work, mplapackint const lwork, mplapackint &info);
void Rorhr_col(mplapackint const m, mplapackint const n, mplapackint const nb, double *a, mplapackint const lda, double *t, mplapackint const ldt, double *d, mplapackint &info);
void Rorm22(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const n1, mplapackint const n2, double *q, mplapackint const ldq, double *c, mplapackint const ldc, double *work, mplapackint const lwork, mplapackint &info);
void Rorm2l(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *c, mplapackint const ldc, double *work, mplapackint &info);
void Rorm2r(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *c, mplapackint const ldc, double *work, mplapackint &info);
void Rormbr(const char *vect, const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *c, mplapackint const ldc, double *work, mplapackint const lwork, mplapackint &info);
void Rormhr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const ilo, mplapackint const ihi, double *a, mplapackint const lda, double *tau, double *c, mplapackint const ldc, double *work, mplapackint const lwork, mplapackint &info);
void Rorml2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *c, mplapackint const ldc, double *work, mplapackint &info);
void Rormlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *c, mplapackint const ldc, double *work, mplapackint const lwork, mplapackint &info);
void Rormql(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *c, mplapackint const ldc, double *work, mplapackint const lwork, mplapackint &info);
void Rormqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *c, mplapackint const ldc, double *work, mplapackint const lwork, mplapackint &info);
void Rormr2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *c, mplapackint const ldc, double *work, mplapackint &info);
void Rormr3(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, double *a, mplapackint const lda, double *tau, double *c, mplapackint const ldc, double *work, mplapackint &info);
void Rormrq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, double *a, mplapackint const lda, double *tau, double *c, mplapackint const ldc, double *work, mplapackint const lwork, mplapackint &info);
void Rormrz(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, double *a, mplapackint const lda, double *tau, double *c, mplapackint const ldc, double *work, mplapackint const lwork, mplapackint &info);
void Rormtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *tau, double *c, mplapackint const ldc, double *work, mplapackint const lwork, mplapackint &info);
void Rpbcon(const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double const anorm, double &rcond, double *work, mplapackint *iwork, mplapackint &info);
void Rpbequ(const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double *s, double &scond, double &amax, mplapackint &info);
void Rpbrfs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, double *ab, mplapackint const ldab, double *afb, mplapackint const ldafb, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rpbstf(const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, mplapackint &info);
void Rpbsv(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, double *ab, mplapackint const ldab, double *b, mplapackint const ldb, mplapackint &info);
void Rpbsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, double *ab, mplapackint const ldab, double *afb, mplapackint const ldafb, char *equed, double *s, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rpbtf2(const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, mplapackint &info);
void Rpbtrf(const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, mplapackint &info);
void Rpbtrs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, double *ab, mplapackint const ldab, double *b, mplapackint const ldb, mplapackint &info);
void Rpftrf(const char *transr, const char *uplo, mplapackint const n, double *a, mplapackint &info);
void Rpftri(const char *transr, const char *uplo, mplapackint const n, double *a, mplapackint &info);
void Rpftrs(const char *transr, const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, double *b, mplapackint const ldb, mplapackint &info);
void Rpocon(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double const anorm, double &rcond, double *work, mplapackint *iwork, mplapackint &info);
void Rpoequ(mplapackint const n, double *a, mplapackint const lda, double *s, double &scond, double &amax, mplapackint &info);
void Rpoequb(mplapackint const n, double *a, mplapackint const lda, double *s, double &scond, double &amax, mplapackint &info);
void Rporfs(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *af, mplapackint const ldaf, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rposv(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *b, mplapackint const ldb, mplapackint &info);
void Rposvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *af, mplapackint const ldaf, char *equed, double *s, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rpotf2(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint &info);
void Rpotrf(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint &info);
void Rpotrf2(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint &info);
void Rpotri(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint &info);
void Rpotrs(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *b, mplapackint const ldb, mplapackint &info);
void Rppcon(const char *uplo, mplapackint const n, double *ap, double const anorm, double &rcond, double *work, mplapackint *iwork, mplapackint &info);
void Rppequ(const char *uplo, mplapackint const n, double *ap, double *s, double &scond, double &amax, mplapackint &info);
void Rpprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, double *ap, double *afp, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rppsv(const char *uplo, mplapackint const n, mplapackint const nrhs, double *ap, double *b, mplapackint const ldb, mplapackint &info);
void Rppsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, double *ap, double *afp, char *equed, double *s, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rpptrf(const char *uplo, mplapackint const n, double *ap, mplapackint &info);
void Rpptri(const char *uplo, mplapackint const n, double *ap, mplapackint &info);
void Rpptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, double *ap, double *b, mplapackint const ldb, mplapackint &info);
void Rpstf2(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, double const tol, double *work, mplapackint &info);
void Rpstrf(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, double const tol, double *work, mplapackint &info);
void Rptcon(mplapackint const n, double *d, double *e, double const anorm, double &rcond, double *work, mplapackint &info);
void Rpteqr(const char *compz, mplapackint const n, double *d, double *e, double *z, mplapackint const ldz, double *work, mplapackint &info);
void Rptrfs(mplapackint const n, mplapackint const nrhs, double *d, double *e, double *df, double *ef, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *ferr, double *berr, double *work, mplapackint &info);
void Rptsv(mplapackint const n, mplapackint const nrhs, double *d, double *e, double *b, mplapackint const ldb, mplapackint &info);
void Rptsvx(const char *fact, mplapackint const n, mplapackint const nrhs, double *d, double *e, double *df, double *ef, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, double *work, mplapackint &info);
void Rpttrf(mplapackint const n, double *d, double *e, mplapackint &info);
void Rpttrs(mplapackint const n, mplapackint const nrhs, double *d, double *e, double *b, mplapackint const ldb, mplapackint &info);
void Rptts2(mplapackint const n, mplapackint const nrhs, double *d, double *e, double *b, mplapackint const ldb);
void Rrscl(mplapackint const n, double const sa, double *sx, mplapackint const incx);
void Rsb2st_kernels(const char *uplo, bool const wantz, mplapackint const ttype, mplapackint const st, mplapackint const ed, mplapackint const sweep, mplapackint const n, mplapackint const nb, mplapackint const ib, double *a, mplapackint const lda, double *v, double *tau, mplapackint const ldvt, double *work);
void Rsbev(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double *w, double *z, mplapackint const ldz, double *work, mplapackint &info);
void Rsbev_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double *w, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint &info);
void Rsbevd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double *w, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double *w, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double *q, mplapackint const ldq, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, double *z, mplapackint const ldz, double *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double *q, mplapackint const ldq, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbgst(const char *vect, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, double *ab, mplapackint const ldab, double *bb, mplapackint const ldbb, double *x, mplapackint const ldx, double *work, mplapackint &info);
void Rsbgv(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, double *ab, mplapackint const ldab, double *bb, mplapackint const ldbb, double *w, double *z, mplapackint const ldz, double *work, mplapackint &info);
void Rsbgvd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, double *ab, mplapackint const ldab, double *bb, mplapackint const ldbb, double *w, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbgvx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, double *ab, mplapackint const ldab, double *bb, mplapackint const ldbb, double *q, mplapackint const ldq, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, double *z, mplapackint const ldz, double *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbtrd(const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double *d, double *e, double *q, mplapackint const ldq, double *work, mplapackint &info);
void Rsfrk(const char *transr, const char *uplo, const char *trans, mplapackint const n, mplapackint const k, double const alpha, double *a, mplapackint const lda, double const beta, double *c);
void Rspcon(const char *uplo, mplapackint const n, double *ap, mplapackint *ipiv, double const anorm, double &rcond, double *work, mplapackint *iwork, mplapackint &info);
void Rspev(const char *jobz, const char *uplo, mplapackint const n, double *ap, double *w, double *z, mplapackint const ldz, double *work, mplapackint &info);
void Rspevd(const char *jobz, const char *uplo, mplapackint const n, double *ap, double *w, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rspevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, double *ap, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, double *z, mplapackint const ldz, double *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rspgst(mplapackint const itype, const char *uplo, mplapackint const n, double *ap, double *bp, mplapackint &info);
void Rspgv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, double *ap, double *bp, double *w, double *z, mplapackint const ldz, double *work, mplapackint &info);
void Rspgvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, double *ap, double *bp, double *w, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rspgvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, double *ap, double *bp, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, double *z, mplapackint const ldz, double *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, double *ap, double *afp, mplapackint *ipiv, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rspsv(const char *uplo, mplapackint const n, mplapackint const nrhs, double *ap, mplapackint *ipiv, double *b, mplapackint const ldb, mplapackint &info);
void Rspsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, double *ap, double *afp, mplapackint *ipiv, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rsptrd(const char *uplo, mplapackint const n, double *ap, double *d, double *e, double *tau, mplapackint &info);
void Rsptrf(const char *uplo, mplapackint const n, double *ap, mplapackint *ipiv, mplapackint &info);
void Rsptri(const char *uplo, mplapackint const n, double *ap, mplapackint *ipiv, double *work, mplapackint &info);
void Rsptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, double *ap, mplapackint *ipiv, double *b, mplapackint const ldb, mplapackint &info);
void Rstebz(const char *range, const char *order, mplapackint const n, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, double *d, double *e, mplapackint &m, mplapackint &nsplit, double *w, mplapackint *iblock, mplapackint *isplit, double *work, mplapackint *iwork, mplapackint &info);
void Rstedc(const char *compz, mplapackint const n, double *d, double *e, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstein(mplapackint const n, double *d, double *e, mplapackint const m, double *w, mplapackint *iblock, mplapackint *isplit, double *z, mplapackint const ldz, double *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rstemr(const char *jobz, const char *range, mplapackint const n, double *d, double *e, double const vl, double const vu, mplapackint const il, mplapackint const iu, mplapackint &m, double *w, double *z, mplapackint const ldz, mplapackint const nzc, mplapackint *isuppz, bool &tryrac, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsteqr(const char *compz, mplapackint const n, double *d, double *e, double *z, mplapackint const ldz, double *work, mplapackint &info);
void Rsterf(mplapackint const n, double *d, double *e, mplapackint &info);
void Rstev(const char *jobz, mplapackint const n, double *d, double *e, double *z, mplapackint const ldz, double *work, mplapackint &info);
void Rstevd(const char *jobz, mplapackint const n, double *d, double *e, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstevr(const char *jobz, const char *range, mplapackint const n, double *d, double *e, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, double *z, mplapackint const ldz, mplapackint *isuppz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstevx(const char *jobz, const char *range, mplapackint const n, double *d, double *e, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, double *z, mplapackint const ldz, double *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsycon(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, double const anorm, double &rcond, double *work, mplapackint *iwork, mplapackint &info);
void Rsycon_3(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *e, mplapackint *ipiv, double const anorm, double &rcond, double *work, mplapackint *iwork, mplapackint &info);
void Rsycon_rook(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, double const anorm, double &rcond, double *work, mplapackint *iwork, mplapackint &info);
void Rsyconv(const char *uplo, const char *way, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, double *e, mplapackint &info);
void Rsyconvf(const char *uplo, const char *way, mplapackint const n, double *a, mplapackint const lda, double *e, mplapackint *ipiv, mplapackint &info);
void Rsyconvf_rook(const char *uplo, const char *way, mplapackint const n, double *a, mplapackint const lda, double *e, mplapackint *ipiv, mplapackint &info);
void Rsyequb(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *s, double &scond, double &amax, double *work, mplapackint &info);
void Rsyev(const char *jobz, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *w, double *work, mplapackint const lwork, mplapackint &info);
void Rsyev_2stage(const char *jobz, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *w, double *work, mplapackint const lwork, mplapackint &info);
void Rsyevd(const char *jobz, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *w, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevd_2stage(const char *jobz, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *w, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevr(const char *jobz, const char *range, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, double *z, mplapackint const ldz, mplapackint *isuppz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevr_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, double *z, mplapackint const ldz, mplapackint *isuppz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsyevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsygs2(mplapackint const itype, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, mplapackint &info);
void Rsygst(mplapackint const itype, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, mplapackint &info);
void Rsygv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *w, double *work, mplapackint const lwork, mplapackint &info);
void Rsygv_2stage(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *w, double *work, mplapackint const lwork, mplapackint &info);
void Rsygvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *w, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsygvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double const vl, double const vu, mplapackint const il, mplapackint const iu, double const abstol, mplapackint &m, double *w, double *z, mplapackint const ldz, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsyrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *af, mplapackint const ldaf, mplapackint *ipiv, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rsysv(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, mplapackint *ipiv, double *b, mplapackint const ldb, double *work, mplapackint const lwork, mplapackint &info);
void Rsysv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, mplapackint *ipiv, double *b, mplapackint const ldb, double *work, mplapackint const lwork, mplapackint &info);
void Rsysv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, double *b, mplapackint const ldb, double *work, mplapackint const lwork, mplapackint &info);
void Rsysv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *e, mplapackint *ipiv, double *b, mplapackint const ldb, double *work, mplapackint const lwork, mplapackint &info);
void Rsysv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, mplapackint *ipiv, double *b, mplapackint const ldb, double *work, mplapackint const lwork, mplapackint &info);
void Rsysvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *af, mplapackint const ldaf, mplapackint *ipiv, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double &rcond, double *ferr, double *berr, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rsyswapr(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Rsytd2(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *d, double *e, double *tau, mplapackint &info);
void Rsytf2(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rsytf2_rk(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *e, mplapackint *ipiv, mplapackint &info);
void Rsytf2_rook(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rsytrd(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *d, double *e, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_2stage(const char *vect, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *d, double *e, double *tau, double *hous2, mplapackint const lhous2, double *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_sb2st(const char *stage1, const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double *d, double *e, double *hous, mplapackint const lhous, double *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_sy2sb(const char *uplo, mplapackint const n, mplapackint const kd, double *a, mplapackint const lda, double *ab, mplapackint const ldab, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void Rsytrf(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, double *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_aa(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, double *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_aa_2stage(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, double *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_rk(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *e, mplapackint *ipiv, double *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_rook(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, double *work, mplapackint const lwork, mplapackint &info);
void Rsytri(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, double *work, mplapackint &info);
void Rsytri2(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, double *work, mplapackint const lwork, mplapackint &info);
void Rsytri2x(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, double *work, mplapackint const nb, mplapackint &info);
void Rsytri_3(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *e, mplapackint *ipiv, double *work, mplapackint const lwork, mplapackint &info);
void Rsytri_3x(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *e, mplapackint *ipiv, double *work, mplapackint const nb, mplapackint &info);
void Rsytri_rook(const char *uplo, mplapackint const n, double *a, mplapackint const lda, mplapackint *ipiv, double *work, mplapackint &info);
void Rsytrs(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, mplapackint *ipiv, double *b, mplapackint const ldb, mplapackint &info);
void Rsytrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, mplapackint *ipiv, double *b, mplapackint const ldb, double *work, mplapackint &info);
void Rsytrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *e, mplapackint *ipiv, double *b, mplapackint const ldb, mplapackint &info);
void Rsytrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, mplapackint *ipiv, double *b, mplapackint const ldb, double *work, mplapackint const lwork, mplapackint &info);
void Rsytrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, double *b, mplapackint const ldb, mplapackint &info);
void Rsytrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, mplapackint *ipiv, double *b, mplapackint const ldb, mplapackint &info);
void Rtbcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double &rcond, double *work, mplapackint *iwork, mplapackint &info);
void Rtbrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, double *ab, mplapackint const ldab, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rtbtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, double *ab, mplapackint const ldab, double *b, mplapackint const ldb, mplapackint &info);
void Rtfsm(const char *transr, const char *side, const char *uplo, const char *trans, const char *diag, mplapackint const m, mplapackint const n, double const alpha, double *a, double *b, mplapackint const ldb);
void Rtftri(const char *transr, const char *uplo, const char *diag, mplapackint const n, double *a, mplapackint &info);
void Rtfttp(const char *transr, const char *uplo, mplapackint const n, double *arf, double *ap, mplapackint &info);
void Rtfttr(const char *transr, const char *uplo, mplapackint const n, double *arf, double *a, mplapackint const lda, mplapackint &info);
void Rtgevc(const char *side, const char *howmny, bool *select, mplapackint const n, double *s, mplapackint const lds, double *p, mplapackint const ldp, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, double *work, mplapackint &info);
void Rtgex2(bool const wantq, bool const wantz, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *q, mplapackint const ldq, double *z, mplapackint const ldz, mplapackint const j1, mplapackint const n1, mplapackint const n2, double *work, mplapackint const lwork, mplapackint &info);
void Rtgexc(bool const wantq, bool const wantz, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *q, mplapackint const ldq, double *z, mplapackint const ldz, mplapackint &ifst, mplapackint &ilst, double *work, mplapackint const lwork, mplapackint &info);
void Rtgsen(mplapackint const ijob, bool const wantq, bool const wantz, bool *select, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *alphar, double *alphai, double *beta, double *q, mplapackint const ldq, double *z, mplapackint const ldz, mplapackint &m, double &pl, double &pr, double *dif, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rtgsja(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mplapackint const k, mplapackint const l, double *a, mplapackint const lda, double *b, mplapackint const ldb, double const tola, double const tolb, double *alpha, double *beta, double *u, mplapackint const ldu, double *v, mplapackint const ldv, double *q, mplapackint const ldq, double *work, mplapackint &ncycle, mplapackint &info);
void Rtgsna(const char *job, const char *howmny, bool *select, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, double *s, double *dif, mplapackint const mm, mplapackint &m, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rtgsy2(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *c, mplapackint const ldc, double *d, mplapackint const ldd, double *e, mplapackint const lde, double *f, mplapackint const ldf, double &scale, double &rdsum, double &rdscal, mplapackint *iwork, mplapackint &pq, mplapackint &info);
void Rtgsyl(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *c, mplapackint const ldc, double *d, mplapackint const ldd, double *e, mplapackint const lde, double *f, mplapackint const ldf, double &scale, double &dif, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rtpcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, double *ap, double &rcond, double *work, mplapackint *iwork, mplapackint &info);
void Rtplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *t, mplapackint const ldt, double *work, mplapackint &info);
void Rtplqt2(mplapackint const m, mplapackint const n, mplapackint const l, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *t, mplapackint const ldt, mplapackint &info);
void Rtpmlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const mb, double *v, mplapackint const ldv, double *t, mplapackint const ldt, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *work, mplapackint &info);
void Rtpmqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const nb, double *v, mplapackint const ldv, double *t, mplapackint const ldt, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *work, mplapackint &info);
void Rtpqrt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *t, mplapackint const ldt, double *work, mplapackint &info);
void Rtpqrt2(mplapackint const m, mplapackint const n, mplapackint const l, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *t, mplapackint const ldt, mplapackint &info);
void Rtprfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, double *v, mplapackint const ldv, double *t, mplapackint const ldt, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *work, mplapackint const ldwork);
void Rtprfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, double *ap, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rtptri(const char *uplo, const char *diag, mplapackint const n, double *ap, mplapackint &info);
void Rtptrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, double *ap, double *b, mplapackint const ldb, mplapackint &info);
void Rtpttf(const char *transr, const char *uplo, mplapackint const n, double *ap, double *arf, mplapackint &info);
void Rtpttr(const char *uplo, mplapackint const n, double *ap, double *a, mplapackint const lda, mplapackint &info);
void Rtrcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, double *a, mplapackint const lda, double &rcond, double *work, mplapackint *iwork, mplapackint &info);
void Rtrevc(const char *side, const char *howmny, bool *select, mplapackint const n, double *t, mplapackint const ldt, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, double *work, mplapackint &info);
void Rtrevc3(const char *side, const char *howmny, bool *select, mplapackint const n, double *t, mplapackint const ldt, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, double *work, mplapackint const lwork, mplapackint &info);
void Rtrexc(const char *compq, mplapackint const n, double *t, mplapackint const ldt, double *q, mplapackint const ldq, mplapackint &ifst, mplapackint &ilst, double *work, mplapackint &info);
void Rtrrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *ferr, double *berr, double *work, mplapackint *iwork, mplapackint &info);
void Rtrsen(const char *job, const char *compq, bool *select, mplapackint const n, double *t, mplapackint const ldt, double *q, mplapackint const ldq, double *wr, double *wi, mplapackint &m, double &s, double &sep, double *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rtrsna(const char *job, const char *howmny, bool *select, mplapackint const n, double *t, mplapackint const ldt, double *vl, mplapackint const ldvl, double *vr, mplapackint const ldvr, double *s, double *sep, mplapackint const mm, mplapackint &m, double *work, mplapackint const ldwork, mplapackint *iwork, mplapackint &info);
void Rtrsyl(const char *trana, const char *tranb, mplapackint const isgn, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *c, mplapackint const ldc, double &scale, mplapackint &info);
void Rtrti2(const char *uplo, const char *diag, mplapackint const n, double *a, mplapackint const lda, mplapackint &info);
void Rtrtri(const char *uplo, const char *diag, mplapackint const n, double *a, mplapackint const lda, mplapackint &info);
void Rtrtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *b, mplapackint const ldb, mplapackint &info);
void Rtrttf(const char *transr, const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *arf, mplapackint &info);
void Rtrttp(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *ap, mplapackint &info);
void Rtzrzf(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork, mplapackint &info);
void iMlaver_double(mplapackint &mplapack_ver_major, mplapackint &mplapack_ver_minor, mplapackint &mplapack_ver_patch, mplapackint &lapack_ver_major, mplapackint &lapack_ver_minor, mplapackint &lapack_ver_patch);
#endif
