/*
 * Copyright (c) 2008-2021
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mplapack_dd.h,v 1.31 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_DD_H_
#define _MPLAPACK_DD_H_

#include "mplapack_config.h"
#include "qd/dd_real.h"
#include "dd_complex.h"

bool Mlsamen_dd(mplapackint n, const char *a, const char *b);
bool Risnan(dd_real const din);
bool Rlaisnan(dd_real const din1, dd_real const din2);
dd_complex Cladiv(dd_complex const x, dd_complex const y);
dd_real Clangb(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_complex *ab, mplapackint const ldab, dd_real *work);
dd_real Clange(const char *norm, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *work);
dd_real Clangt(const char *norm, mplapackint const n, dd_complex *dl, dd_complex *d, dd_complex *du);
dd_real Clanhb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, dd_complex *ab, mplapackint const ldab, dd_real *work);
dd_real Clanhe(const char *norm, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *work);
dd_real Clanhf(const char *norm, const char *transr, const char *uplo, mplapackint const n, dd_complex *a, dd_real *work);
dd_real Clanhp(const char *norm, const char *uplo, mplapackint const n, dd_complex *ap, dd_real *work);
dd_real Clanhs(const char *norm, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *work);
dd_real Clanht(const char *norm, mplapackint const n, dd_real *d, dd_complex *e);
dd_real Clansb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, dd_complex *ab, mplapackint const ldab, dd_real *work);
dd_real Clansp(const char *norm, const char *uplo, mplapackint const n, dd_complex *ap, dd_real *work);
dd_real Clansy(const char *norm, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *work);
dd_real Clantb(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const k, dd_complex *ab, mplapackint const ldab, dd_real *work);
dd_real Clantp(const char *norm, const char *uplo, const char *diag, mplapackint const n, dd_complex *ap, dd_real *work);
dd_real Clantr(const char *norm, const char *uplo, const char *diag, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *work);
dd_real Mmaxval(dd_real *dx, mplapackint const start, mplapackint const end, mplapackint incx);
dd_real RCsum1(mplapackint const n, dd_complex *cx, mplapackint const incx);
dd_real Rla_gbrcond(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_real *ab, mplapackint const ldab, dd_real *afb, mplapackint const ldafb, mplapackint *ipiv, mplapackint const cmode, dd_real *c, mplapackint &info, dd_real *work, mplapackint *iwork);
dd_real Rla_gbrpvgrw(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const ncols, dd_real *ab, mplapackint const ldab, dd_real *afb, mplapackint const ldafb);
dd_real Rla_gercond(const char *trans, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *af, mplapackint const ldaf, mplapackint *ipiv, mplapackint const cmode, dd_real *c, mplapackint &info, dd_real *work, mplapackint *iwork);
dd_real Rla_gerpvgrw(mplapackint const n, mplapackint const ncols, dd_real *a, mplapackint const lda, dd_real *af, mplapackint const ldaf);
dd_real Rla_porcond(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *af, mplapackint const ldaf, mplapackint const cmode, dd_real *c, mplapackint &info, dd_real *work, mplapackint *iwork);
dd_real Rla_syrcond(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *af, mplapackint const ldaf, mplapackint *ipiv, mplapackint const cmode, dd_real *c, mplapackint &info, dd_real *work, mplapackint *iwork);
dd_real Rla_syrpvgrw(const char *uplo, mplapackint const n, mplapackint const info, dd_real *a, mplapackint const lda, dd_real *af, mplapackint const ldaf, mplapackint *ipiv, dd_real *work);
dd_real Rladiv2(dd_real const &a, dd_real const &b, dd_real const &c, dd_real const &d, dd_real const &r, dd_real const &t);
dd_real Rlamc3(dd_real a, dd_real b);
dd_real Rlamch_dd(const char *cmach);
dd_real Rlangb(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_real *ab, mplapackint const ldab, dd_real *work);
dd_real Rlange(const char *norm, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *work);
dd_real Rlangt(const char *norm, mplapackint const n, dd_real *dl, dd_real *d, dd_real *du);
dd_real Rlanhs(const char *norm, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *work);
dd_real Rlansb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, dd_real *ab, mplapackint const ldab, dd_real *work);
dd_real Rlansf(const char *norm, const char *transr, const char *uplo, mplapackint const n, dd_real *a, dd_real *work);
dd_real Rlansp(const char *norm, const char *uplo, mplapackint const n, dd_real *ap, dd_real *work);
dd_real Rlanst(const char *norm, mplapackint const n, dd_real *d, dd_real *e);
dd_real Rlansy(const char *norm, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *work);
dd_real Rlantb(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const k, dd_real *ab, mplapackint const ldab, dd_real *work);
dd_real Rlantp(const char *norm, const char *uplo, const char *diag, mplapackint const n, dd_real *ap, dd_real *work);
dd_real Rlantr(const char *norm, const char *uplo, const char *diag, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *work);
dd_real Rlapy2(dd_real const x, dd_real const y);
dd_real Rlapy3(dd_real const x, dd_real const y, dd_real const z);
mplapackint Mmaxloc(dd_real *dx, mplapackint const start, mplapackint const end, mplapackint const incx);
mplapackint Rlaneg(mplapackint const n, dd_real *d, dd_real *lld, dd_real const sigma, dd_real const, mplapackint const r);
mplapackint iCmax1(mplapackint const n, dd_complex *zx, mplapackint const incx);
mplapackint iMieeeck_dd(mplapackint const &ispec, dd_real const &zero, dd_real const &one);
mplapackint iMladiag(const char *diag);
mplapackint iMladlc(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda);
mplapackint iMladlr(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda);
mplapackint iMlaenv2stage_dd(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv_dd(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaprec(const char *prec);
mplapackint iMlatrans(const char *trans);
mplapackint iMlauplo(const char *uplo);
mplapackint iMlazlc(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda);
mplapackint iMlazlr(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda);
mplapackint iMparam2stage_dd(mplapackint const ispec, const char *name, const char *opts, mplapackint const ni, mplapackint const nbi, mplapackint const ibi, mplapackint const nxi);
mplapackint iMparmq_dd(mplapackint const ispec, const char *name, const char *opts, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mplapackint const lwork);
void CRrscl(mplapackint const n, dd_real const sa, dd_complex *sx, mplapackint const incx);
void Cbbcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, mplapackint const m, mplapackint const p, mplapackint const q, dd_real *theta, dd_real *phi, dd_complex *u1, mplapackint const ldu1, dd_complex *u2, mplapackint const ldu2, dd_complex *v1t, mplapackint const ldv1t, dd_complex *v2t, mplapackint const ldv2t, dd_real *b11d, dd_real *b11e, dd_real *b12d, dd_real *b12e, dd_real *b21d, dd_real *b21e, dd_real *b22d, dd_real *b22e, dd_real *rwork, mplapackint const lrwork, mplapackint &info);
void Cbdsqr(const char *uplo, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, dd_real *d, dd_real *e, dd_complex *vt, mplapackint const ldvt, dd_complex *u, mplapackint const ldu, dd_complex *c, mplapackint const ldc, dd_real *rwork, mplapackint &info);
void Cgbbrd(const char *vect, mplapackint const m, mplapackint const n, mplapackint const ncc, mplapackint const kl, mplapackint const ku, dd_complex *ab, mplapackint const ldab, dd_real *d, dd_real *e, dd_complex *q, mplapackint const ldq, dd_complex *pt, mplapackint const ldpt, dd_complex *c, mplapackint const ldc, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cgbcon(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_complex *ab, mplapackint const ldab, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cgbequ(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_complex *ab, mplapackint const ldab, dd_real *r, dd_real *c, dd_real &rowcnd, dd_real &colcnd, dd_real &amax, mplapackint &info);
void Cgbequb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_complex *ab, mplapackint const ldab, dd_real *r, dd_real *c, dd_real &rowcnd, dd_real &colcnd, dd_real &amax, mplapackint &info);
void Cgbrfs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, dd_complex *ab, mplapackint const ldab, dd_complex *afb, mplapackint const ldafb, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cgbsv(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, dd_complex *ab, mplapackint const ldab, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cgbsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, dd_complex *ab, mplapackint const ldab, dd_complex *afb, mplapackint const ldafb, mplapackint *ipiv, char *equed, dd_real *r, dd_real *c, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cgbtf2(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_complex *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Cgbtrf(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_complex *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Cgbtrs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, dd_complex *ab, mplapackint const ldab, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cgebak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *scale, mplapackint const m, dd_complex *v, mplapackint const ldv, mplapackint &info);
void Cgebal(const char *job, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint &ilo, mplapackint &ihi, dd_real *scale, mplapackint &info);
void Cgebd2(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *d, dd_real *e, dd_complex *tauq, dd_complex *taup, dd_complex *work, mplapackint &info);
void Cgebrd(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *d, dd_real *e, dd_complex *tauq, dd_complex *taup, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgecon(const char *norm, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real const anorm, dd_real &rcond, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cgeequ(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *r, dd_real *c, dd_real &rowcnd, dd_real &colcnd, dd_real &amax, mplapackint &info);
void Cgeequb(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *r, dd_real *c, dd_real &rowcnd, dd_real &colcnd, dd_real &amax, mplapackint &info);
void Cgees(const char *jobvs, const char *sort, bool (*select)(dd_complex), mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint &sdim, dd_complex *w, dd_complex *vs, mplapackint const ldvs, dd_complex *work, mplapackint const lwork, dd_real *rwork, bool *bwork, mplapackint &info);
void Cgeesx(const char *jobvs, const char *sort, bool (*select)(dd_complex), const char *sense, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint &sdim, dd_complex *w, dd_complex *vs, mplapackint const ldvs, dd_real &rconde, dd_real &rcondv, dd_complex *work, mplapackint const lwork, dd_real *rwork, bool *bwork, mplapackint &info);
void Cgeev(const char *jobvl, const char *jobvr, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *w, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Cgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *w, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, dd_real *scale, dd_real &abnrm, dd_real *rconde, dd_real *rcondv, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Cgehd2(mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint &info);
void Cgehrd(mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgejsv(const char *joba, const char *jobu, const char *jobv, const char *jobr, const char *jobt, const char *jobp, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *sva, dd_complex *u, mplapackint const ldu, dd_complex *v, mplapackint const ldv, dd_complex *cwork, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cgelq(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const tsize, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgelq2(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint &info);
void Cgelqf(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgelqt(mplapackint const m, mplapackint const n, mplapackint const mb, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const ldt, dd_complex *work, mplapackint &info);
void Cgelqt3(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const ldt, mplapackint &info);
void Cgels(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgelsd(mplapackint const m, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_real *s, dd_real const rcond, mplapackint &rank, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint *iwork, mplapackint &info);
void Cgelss(mplapackint const m, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_real *s, dd_real const rcond, mplapackint &rank, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Cgelsy(mplapackint const m, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, mplapackint *jpvt, dd_real const rcond, mplapackint &rank, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Cgemlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const tsize, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgemlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, dd_complex *v, mplapackint const ldv, dd_complex *t, mplapackint const ldt, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint &info);
void Cgemqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const tsize, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgemqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const nb, dd_complex *v, mplapackint const ldv, dd_complex *t, mplapackint const ldt, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint &info);
void Cgeql2(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint &info);
void Cgeqlf(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgeqp3(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *jpvt, dd_complex *tau, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Cgeqr(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const tsize, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgeqr2(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint &info);
void Cgeqr2p(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint &info);
void Cgeqrf(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgeqrfp(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgeqrt(mplapackint const m, mplapackint const n, mplapackint const nb, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const ldt, dd_complex *work, mplapackint &info);
void Cgeqrt2(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const ldt, mplapackint &info);
void Cgeqrt3(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const ldt, mplapackint &info);
void Cgerfs(const char *trans, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *af, mplapackint const ldaf, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cgerq2(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint &info);
void Cgerqf(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgesc2(mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *rhs, mplapackint *ipiv, mplapackint *jpiv, dd_real &scale);
void Cgesdd(const char *jobz, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *s, dd_complex *u, mplapackint const ldu, dd_complex *vt, mplapackint const ldvt, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint *iwork, mplapackint &info);
void Cgesv(mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cgesvd(const char *jobu, const char *jobvt, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *s, dd_complex *u, mplapackint const ldu, dd_complex *vt, mplapackint const ldvt, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Cgesvdq(const char *joba, const char *jobp, const char *jobr, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *s, dd_complex *u, mplapackint const ldu, dd_complex *v, mplapackint const ldv, mplapackint &numrank, mplapackint *iwork, mplapackint const liwork, dd_complex *cwork, mplapackint const lcwork, dd_real *rwork, mplapackint const lrwork, mplapackint &info);
void Cgesvdx(const char *jobu, const char *jobvt, const char *range, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, dd_real *s, dd_complex *u, mplapackint const ldu, dd_complex *vt, mplapackint const ldvt, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint *iwork, mplapackint &info);
void Cgesvj(const char *joba, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *sva, mplapackint const mv, dd_complex *v, mplapackint const ldv, dd_complex *cwork, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint &info);
void Cgesvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *af, mplapackint const ldaf, mplapackint *ipiv, char *equed, dd_real *r, dd_real *c, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cgetc2(mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, mplapackint *jpiv, mplapackint &info);
void Cgetf2(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetrf(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetrf2(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetri(mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgetrs(const char *trans, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cgetsls(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgetsqrhrt(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const ldt, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cggbak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *lscale, dd_real *rscale, mplapackint const m, dd_complex *v, mplapackint const ldv, mplapackint &info);
void Cggbal(const char *job, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, mplapackint &ilo, mplapackint &ihi, dd_real *lscale, dd_real *rscale, dd_real *work, mplapackint &info);
void Cgges(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(dd_complex, dd_complex), mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, mplapackint &sdim, dd_complex *alpha, dd_complex *beta, dd_complex *vsl, mplapackint const ldvsl, dd_complex *vsr, mplapackint const ldvsr, dd_complex *work, mplapackint const lwork, dd_real *rwork, bool *bwork, mplapackint &info);
void Cgges3(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(dd_complex, dd_complex), mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, mplapackint &sdim, dd_complex *alpha, dd_complex *beta, dd_complex *vsl, mplapackint const ldvsl, dd_complex *vsr, mplapackint const ldvsr, dd_complex *work, mplapackint const lwork, dd_real *rwork, bool *bwork, mplapackint &info);
void Cggesx(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(dd_complex, dd_complex), const char *sense, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, mplapackint &sdim, dd_complex *alpha, dd_complex *beta, dd_complex *vsl, mplapackint const ldvsl, dd_complex *vsr, mplapackint const ldvsr, dd_real *rconde, dd_real *rcondv, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Cggev(const char *jobvl, const char *jobvr, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *alpha, dd_complex *beta, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Cggev3(const char *jobvl, const char *jobvr, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *alpha, dd_complex *beta, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Cggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *alpha, dd_complex *beta, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, mplapackint &ilo, mplapackint &ihi, dd_real *lscale, dd_real *rscale, dd_real &abnrm, dd_real &bbnrm, dd_real *rconde, dd_real *rcondv, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Cggglm(mplapackint const n, mplapackint const m, mplapackint const p, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *d, dd_complex *x, dd_complex *y, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgghd3(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *q, mplapackint const ldq, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgghrd(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *q, mplapackint const ldq, dd_complex *z, mplapackint const ldz, mplapackint &info);
void Cgglse(mplapackint const m, mplapackint const n, mplapackint const p, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *c, dd_complex *d, dd_complex *x, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cggqrf(mplapackint const n, mplapackint const m, mplapackint const p, dd_complex *a, mplapackint const lda, dd_complex *taua, dd_complex *b, mplapackint const ldb, dd_complex *taub, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cggrqf(mplapackint const m, mplapackint const p, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *taua, dd_complex *b, mplapackint const ldb, dd_complex *taub, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cggsvd3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const n, mplapackint const p, mplapackint &k, mplapackint &l, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_real *alpha, dd_real *beta, dd_complex *u, mplapackint const ldu, dd_complex *v, mplapackint const ldv, dd_complex *q, mplapackint const ldq, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint *iwork, mplapackint &info);
void Cggsvp3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_real const tola, dd_real const tolb, mplapackint &k, mplapackint &l, dd_complex *u, mplapackint const ldu, dd_complex *v, mplapackint const ldv, dd_complex *q, mplapackint const ldq, mplapackint *iwork, dd_real *rwork, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgsvj0(const char *jobv, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *d, dd_real *sva, mplapackint const mv, dd_complex *v, mplapackint const ldv, dd_real const eps, dd_real const sfmin, dd_real const tol, mplapackint const nsweep, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgsvj1(const char *jobv, mplapackint const m, mplapackint const n, mplapackint const n1, dd_complex *a, mplapackint const lda, dd_complex *d, dd_real *sva, mplapackint const mv, dd_complex *v, mplapackint const ldv, dd_real const eps, dd_real const sfmin, dd_real const tol, mplapackint const nsweep, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgtcon(const char *norm, mplapackint const n, dd_complex *dl, dd_complex *d, dd_complex *du, dd_complex *du2, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_complex *work, mplapackint &info);
void Cgtrfs(const char *trans, mplapackint const n, mplapackint const nrhs, dd_complex *dl, dd_complex *d, dd_complex *du, dd_complex *dlf, dd_complex *df, dd_complex *duf, dd_complex *du2, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cgtsv(mplapackint const n, mplapackint const nrhs, dd_complex *dl, dd_complex *d, dd_complex *du, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cgtsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, dd_complex *dl, dd_complex *d, dd_complex *du, dd_complex *dlf, dd_complex *df, dd_complex *duf, dd_complex *du2, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cgttrf(mplapackint const n, dd_complex *dl, dd_complex *d, dd_complex *du, dd_complex *du2, mplapackint *ipiv, mplapackint &info);
void Cgttrs(const char *trans, mplapackint const n, mplapackint const nrhs, dd_complex *dl, dd_complex *d, dd_complex *du, dd_complex *du2, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cgtts2(mplapackint const itrans, mplapackint const n, mplapackint const nrhs, dd_complex *dl, dd_complex *d, dd_complex *du, dd_complex *du2, mplapackint *ipiv, dd_complex *b, mplapackint const ldb);
void Chb2st_kernels(const char *uplo, bool const wantz, mplapackint const ttype, mplapackint const st, mplapackint const ed, mplapackint const sweep, mplapackint const n, mplapackint const nb, mplapackint const ib, dd_complex *a, mplapackint const lda, dd_complex *v, dd_complex *tau, mplapackint const ldvt, dd_complex *work);
void Chbev(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, dd_real *rwork, mplapackint &info);
void Chbev_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Chbevd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_complex *q, mplapackint const ldq, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, dd_real *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_complex *q, mplapackint const ldq, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbgst(const char *vect, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, dd_complex *ab, mplapackint const ldab, dd_complex *bb, mplapackint const ldbb, dd_complex *x, mplapackint const ldx, dd_complex *work, dd_real *rwork, mplapackint &info);
void Chbgv(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, dd_complex *ab, mplapackint const ldab, dd_complex *bb, mplapackint const ldbb, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, dd_real *rwork, mplapackint &info);
void Chbgvd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, dd_complex *ab, mplapackint const ldab, dd_complex *bb, mplapackint const ldbb, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbgvx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, dd_complex *ab, mplapackint const ldab, dd_complex *bb, mplapackint const ldbb, dd_complex *q, mplapackint const ldq, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, dd_real *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbtrd(const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_real *d, dd_real *e, dd_complex *q, mplapackint const ldq, dd_complex *work, mplapackint &info);
void Checon(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_complex *work, mplapackint &info);
void Checon_3(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_complex *work, mplapackint &info);
void Checon_rook(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_complex *work, mplapackint &info);
void Cheequb(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *s, dd_real &scond, dd_real &amax, dd_complex *work, mplapackint &info);
void Cheev(const char *jobz, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *w, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Cheev_2stage(const char *jobz, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *w, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Cheevd(const char *jobz, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *w, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevd_2stage(const char *jobz, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *w, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevr(const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_complex *z, mplapackint const ldz, mplapackint *isuppz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevr_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_complex *z, mplapackint const ldz, mplapackint *isuppz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cheevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chegs2(mplapackint const itype, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Chegst(mplapackint const itype, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Chegv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_real *w, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Chegv_2stage(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_real *w, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Chegvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_real *w, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chegvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cherfs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *af, mplapackint const ldaf, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Chesv(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chesv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chesv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chesv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chesv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chesvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *af, mplapackint const ldaf, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Cheswapr(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Chetd2(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *d, dd_real *e, dd_complex *tau, mplapackint &info);
void Chetf2(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Chetf2_rk(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, mplapackint &info);
void Chetf2_rook(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Chetrd(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *d, dd_real *e, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chetrd_2stage(const char *vect, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *d, dd_real *e, dd_complex *tau, dd_complex *hous2, mplapackint const lhous2, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chetrd_hb2st(const char *stage1, const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_real *d, dd_real *e, dd_complex *hous, mplapackint const lhous, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chetrd_he2hb(const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *a, mplapackint const lda, dd_complex *ab, mplapackint const ldab, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chetrf(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chetrf_aa(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chetrf_aa_2stage(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chetrf_rk(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chetrf_rook(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chetri(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint &info);
void Chetri2(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chetri2x(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint const nb, mplapackint &info);
void Chetri_3(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chetri_3x(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_complex *work, mplapackint const nb, mplapackint &info);
void Chetri_rook(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint &info);
void Chetrs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Chetrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint &info);
void Chetrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Chetrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Chetrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Chetrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Chfrk(const char *transr, const char *uplo, const char *trans, mplapackint const n, mplapackint const k, dd_real const alpha, dd_complex *a, mplapackint const lda, dd_real const beta, dd_complex *c);
void Chgeqz(const char *job, const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_complex *h, mplapackint const ldh, dd_complex *t, mplapackint const ldt, dd_complex *alpha, dd_complex *beta, dd_complex *q, mplapackint const ldq, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Chpcon(const char *uplo, mplapackint const n, dd_complex *ap, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_complex *work, mplapackint &info);
void Chpev(const char *jobz, const char *uplo, mplapackint const n, dd_complex *ap, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, dd_real *rwork, mplapackint &info);
void Chpevd(const char *jobz, const char *uplo, mplapackint const n, dd_complex *ap, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chpevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_complex *ap, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, dd_real *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chpgst(mplapackint const itype, const char *uplo, mplapackint const n, dd_complex *ap, dd_complex *bp, mplapackint &info);
void Chpgv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, dd_complex *ap, dd_complex *bp, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, dd_real *rwork, mplapackint &info);
void Chpgvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, dd_complex *ap, dd_complex *bp, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chpgvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_complex *ap, dd_complex *bp, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_complex *z, mplapackint const ldz, dd_complex *work, dd_real *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *ap, dd_complex *afp, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Chpsv(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *ap, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Chpsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *ap, dd_complex *afp, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Chptrd(const char *uplo, mplapackint const n, dd_complex *ap, dd_real *d, dd_real *e, dd_complex *tau, mplapackint &info);
void Chptrf(const char *uplo, mplapackint const n, dd_complex *ap, mplapackint *ipiv, mplapackint &info);
void Chptri(const char *uplo, mplapackint const n, dd_complex *ap, mplapackint *ipiv, dd_complex *work, mplapackint &info);
void Chptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *ap, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Chsein(const char *side, const char *eigsrc, const char *initv, bool *select, mplapackint const n, dd_complex *h, mplapackint const ldh, dd_complex *w, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, dd_complex *work, dd_real *rwork, mplapackint *ifaill, mplapackint *ifailr, mplapackint &info);
void Chseqr(const char *job, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_complex *h, mplapackint const ldh, dd_complex *w, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Clabrd(mplapackint const m, mplapackint const n, mplapackint const nb, dd_complex *a, mplapackint const lda, dd_real *d, dd_real *e, dd_complex *tauq, dd_complex *taup, dd_complex *x, mplapackint const ldx, dd_complex *y, mplapackint const ldy);
void Clacgv(mplapackint const n, dd_complex *x, mplapackint const incx);
void Clacn2(mplapackint const n, dd_complex *v, dd_complex *x, dd_real &est, mplapackint &kase, mplapackint *isave);
void Clacon(mplapackint const n, dd_complex *v, dd_complex *x, dd_real &est, mplapackint &kase);
void Clacp2(const char *uplo, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_complex *b, mplapackint const ldb);
void Clacpy(const char *uplo, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb);
void Clacrm(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_complex *c, mplapackint const ldc, dd_real *rwork);
void Clacrt(mplapackint const n, dd_complex *cx, mplapackint const incx, dd_complex *cy, mplapackint const incy, dd_complex const c, dd_complex const s);
void Claed0(mplapackint const qsiz, mplapackint const n, dd_real *d, dd_real *e, dd_complex *q, mplapackint const ldq, dd_complex *qstore, mplapackint const ldqs, dd_real *rwork, mplapackint *iwork, mplapackint &info);
void Claed7(mplapackint const n, mplapackint const cutpnt, mplapackint const qsiz, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, dd_real *d, dd_complex *q, mplapackint const ldq, dd_real rho, mplapackint *indxq, dd_real *qstore, mplapackint *qptr, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, dd_real *givnum, dd_complex *work, dd_real *rwork, mplapackint *iwork, mplapackint &info);
void Claed8(mplapackint &k, mplapackint const n, mplapackint const qsiz, dd_complex *q, mplapackint const ldq, dd_real *d, dd_real &rho, mplapackint const cutpnt, dd_real *z, dd_real *dlamda, dd_complex *q2, mplapackint const ldq2, dd_real *w, mplapackint *indxp, mplapackint *indx, mplapackint *indxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, dd_real *givnum, mplapackint &info);
void Claein(bool const rightv, bool const noinit, mplapackint const n, dd_complex *h, mplapackint const ldh, dd_complex const w, dd_complex *v, dd_complex *b, mplapackint const ldb, dd_real *rwork, dd_real const eps3, dd_real const smlnum, mplapackint &info);
void Claesy(dd_complex const a, dd_complex const b, dd_complex const c, dd_complex &rt1, dd_complex &rt2, dd_complex &evscal, dd_complex &cs1, dd_complex &sn1);
void Claev2(dd_complex const a, dd_complex const b, dd_complex const c, dd_real &rt1, dd_real &rt2, dd_real &cs1, dd_complex &sn1);
void Clags2(bool const upper, dd_real const a1, dd_complex const a2, dd_real const a3, dd_real const b1, dd_complex const b2, dd_real const b3, dd_real &csu, dd_complex &snu, dd_real &csv, dd_complex &snv, dd_real &csq, dd_complex &snq);
void Clagtm(const char *trans, mplapackint const n, mplapackint const nrhs, dd_real const alpha, dd_complex *dl, dd_complex *d, dd_complex *du, dd_complex *x, mplapackint const ldx, dd_real const beta, dd_complex *b, mplapackint const ldb);
void Clahef(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *w, mplapackint const ldw, mplapackint &info);
void Clahef_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *h, mplapackint const ldh, dd_complex *work);
void Clahef_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_complex *w, mplapackint const ldw, mplapackint &info);
void Clahef_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *w, mplapackint const ldw, mplapackint &info);
void Clahqr(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_complex *h, mplapackint const ldh, dd_complex *w, mplapackint const iloz, mplapackint const ihiz, dd_complex *z, mplapackint const ldz, mplapackint &info);
void Clahr2(mplapackint const n, mplapackint const k, mplapackint const nb, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *t, mplapackint const ldt, dd_complex *y, mplapackint const ldy);
void Claic1(mplapackint const job, mplapackint const j, dd_complex *x, dd_real const sest, dd_complex *w, dd_complex const gamma, dd_real &sestpr, dd_complex &s, dd_complex &c);
void Clals0(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const nrhs, dd_complex *b, mplapackint const ldb, dd_complex *bx, mplapackint const ldbx, mplapackint *perm, mplapackint const givptr, mplapackint *givcol, mplapackint const ldgcol, dd_real *givnum, mplapackint const ldgnum, dd_real *poles, dd_real *difl, dd_real *difr, dd_real *z, mplapackint const k, dd_real const c, dd_real const s, dd_real *rwork, mplapackint &info);
void Clalsa(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, dd_complex *b, mplapackint const ldb, dd_complex *bx, mplapackint const ldbx, dd_real *u, mplapackint const ldu, dd_real *vt, mplapackint *k, dd_real *difl, dd_real *difr, dd_real *z, dd_real *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, dd_real *givnum, dd_real *c, dd_real *s, dd_real *rwork, mplapackint *iwork, mplapackint &info);
void Clalsd(const char *uplo, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, dd_real *d, dd_real *e, dd_complex *b, mplapackint const ldb, dd_real const rcond, mplapackint &rank, dd_complex *work, dd_real *rwork, mplapackint *iwork, mplapackint &info);
void Clamswlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const ldt, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Clamtsqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const ldt, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Clapll(mplapackint const n, dd_complex *x, mplapackint const incx, dd_complex *y, mplapackint const incy, dd_real &ssmin);
void Clapmr(bool const forwrd, mplapackint const m, mplapackint const n, dd_complex *x, mplapackint const ldx, mplapackint *k);
void Clapmt(bool const forwrd, mplapackint const m, mplapackint const n, dd_complex *x, mplapackint const ldx, mplapackint *k);
void Claqgb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_complex *ab, mplapackint const ldab, dd_real *r, dd_real *c, dd_real const rowcnd, dd_real const colcnd, dd_real const amax, char *equed);
void Claqge(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *r, dd_real *c, dd_real const rowcnd, dd_real const colcnd, dd_real const amax, char *equed);
void Claqhb(const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_real *s, dd_real const scond, dd_real const amax, char *equed);
void Claqhe(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *s, dd_real const scond, dd_real const amax, char *equed);
void Claqhp(const char *uplo, mplapackint const n, dd_complex *ap, dd_real *s, dd_real const scond, dd_real const amax, char *equed);
void Claqp2(mplapackint const m, mplapackint const n, mplapackint const offset, dd_complex *a, mplapackint const lda, mplapackint *jpvt, dd_complex *tau, dd_real *vn1, dd_real *vn2, dd_complex *work);
void Claqps(mplapackint const m, mplapackint const n, mplapackint const offset, mplapackint const nb, mplapackint &kb, dd_complex *a, mplapackint const lda, mplapackint *jpvt, dd_complex *tau, dd_real *vn1, dd_real *vn2, dd_complex *auxv, dd_complex *f, mplapackint const ldf);
void Claqr0(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_complex *h, mplapackint const ldh, dd_complex *w, mplapackint const iloz, mplapackint const ihiz, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Claqr1(mplapackint const n, dd_complex *h, mplapackint const ldh, dd_complex const s1, dd_complex const s2, dd_complex *v);
void Claqr2(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, dd_complex *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, dd_complex *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, dd_complex *sh, dd_complex *v, mplapackint const ldv, mplapackint const nh, dd_complex *t, mplapackint const ldt, mplapackint const nv, dd_complex *wv, mplapackint const ldwv, dd_complex *work, mplapackint const lwork);
void Claqr3(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, dd_complex *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, dd_complex *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, dd_complex *sh, dd_complex *v, mplapackint const ldv, mplapackint const nh, dd_complex *t, mplapackint const ldt, mplapackint const nv, dd_complex *wv, mplapackint const ldwv, dd_complex *work, mplapackint const lwork);
void Claqr4(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_complex *h, mplapackint const ldh, dd_complex *w, mplapackint const iloz, mplapackint const ihiz, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Claqr5(bool const wantt, bool const wantz, mplapackint const kacc22, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nshfts, dd_complex *s, dd_complex *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, dd_complex *z, mplapackint const ldz, dd_complex *v, mplapackint const ldv, dd_complex *u, mplapackint const ldu, mplapackint const nv, dd_complex *wv, mplapackint const ldwv, mplapackint const nh, dd_complex *wh, mplapackint const ldwh);
void Claqsb(const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_real *s, dd_real const scond, dd_real const amax, char *equed);
void Claqsp(const char *uplo, mplapackint const n, dd_complex *ap, dd_real *s, dd_real const scond, dd_real const amax, char *equed);
void Claqsy(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *s, dd_real const scond, dd_real const amax, char *equed);
void Clar1v(mplapackint const n, mplapackint const b1, mplapackint const bn, dd_real const lambda, dd_real *d, dd_real *l, dd_real *ld, dd_real *lld, dd_real const pivmin, dd_real const gaptol, dd_complex *z, bool const wantnc, mplapackint &negcnt, dd_real &ztz, dd_real &mingma, mplapackint &r, mplapackint *isuppz, dd_real &nrminv, dd_real &resid, dd_real &rqcorr, dd_real *work);
void Clar2v(mplapackint const n, dd_complex *x, dd_complex *y, dd_complex *z, mplapackint const incx, dd_real *c, dd_complex *s, mplapackint const incc);
void Clarcm(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *c, mplapackint const ldc, dd_real *rwork);
void Clarf(const char *side, mplapackint const m, mplapackint const n, dd_complex *v, mplapackint const incv, dd_complex const tau, dd_complex *c, mplapackint const ldc, dd_complex *work);
void Clarfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *v, mplapackint const ldv, dd_complex *t, mplapackint const ldt, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const ldwork);
void Clarfb_gett(const char *ident, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *t, mplapackint const ldt, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const ldwork);
void Clarfg(mplapackint const n, dd_complex &alpha, dd_complex *x, mplapackint const incx, dd_complex &tau);
void Clarfgp(mplapackint const n, dd_complex &alpha, dd_complex *x, mplapackint const incx, dd_complex &tau);
void Clarft(const char *direct, const char *storev, mplapackint const n, mplapackint const k, dd_complex *v, mplapackint const ldv, dd_complex *tau, dd_complex *t, mplapackint const ldt);
void Clarfx(const char *side, mplapackint const m, mplapackint const n, dd_complex *v, dd_complex const tau, dd_complex *c, mplapackint const ldc, dd_complex *work);
void Clarfy(const char *uplo, mplapackint const n, dd_complex *v, mplapackint const incv, dd_complex const tau, dd_complex *c, mplapackint const ldc, dd_complex *work);
void Clargv(mplapackint const n, dd_complex *x, mplapackint const incx, dd_complex *y, mplapackint const incy, dd_real *c, mplapackint const incc);
void Clarnv(mplapackint const idist, mplapackint *iseed, mplapackint const n, dd_complex *x);
void Clarrv(mplapackint const n, dd_real const vl, dd_real const, dd_real *d, dd_real *l, dd_real const pivmin, mplapackint *isplit, mplapackint const m, mplapackint const dol, mplapackint const dou, dd_real const minrgp, dd_real &rtol1, dd_real &rtol2, dd_real *w, dd_real *werr, dd_real *wgap, mplapackint *iblock, mplapackint *indexw, dd_real *gers, dd_complex *z, mplapackint const ldz, mplapackint *isuppz, dd_real *work, mplapackint *iwork, mplapackint &info);
void Clarscl2(mplapackint const m, mplapackint const n, dd_real *d, dd_complex *x, mplapackint const ldx);
void Clartg(dd_complex const f, dd_complex const g, dd_real &cs, dd_complex &sn, dd_complex &r);
void Clartv(mplapackint const n, dd_complex *x, mplapackint const incx, dd_complex *y, mplapackint const incy, dd_real *c, dd_complex *s, mplapackint const incc);
void Clarz(const char *side, mplapackint const m, mplapackint const n, mplapackint const l, dd_complex *v, mplapackint const incv, dd_complex const tau, dd_complex *c, mplapackint const ldc, dd_complex *work);
void Clarzb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, dd_complex *v, mplapackint const ldv, dd_complex *t, mplapackint const ldt, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const ldwork);
void Clarzt(const char *direct, const char *storev, mplapackint const n, mplapackint const k, dd_complex *v, mplapackint const ldv, dd_complex *tau, dd_complex *t, mplapackint const ldt);
void Clascl(const char *type, mplapackint const kl, mplapackint const ku, dd_real const cfrom, dd_real const cto, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint &info);
void Clascl2(mplapackint const m, mplapackint const n, dd_real *d, dd_complex *x, mplapackint const ldx);
void Claset(const char *uplo, mplapackint const m, mplapackint const n, dd_complex const alpha, dd_complex const beta, dd_complex *a, mplapackint const lda);
void Clasr(const char *side, const char *pivot, const char *direct, mplapackint const m, mplapackint const n, dd_real *c, dd_real *s, dd_complex *a, mplapackint const lda);
void Classq(mplapackint const n, dd_complex *x, mplapackint const incx, dd_real &scale, dd_real &sumsq);
void Claswlq(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const ldt, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Claswp(mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint const k1, mplapackint const k2, mplapackint *ipiv, mplapackint const incx);
void Clasyf(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *w, mplapackint const ldw, mplapackint &info);
void Clasyf_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *h, mplapackint const ldh, dd_complex *work);
void Clasyf_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_complex *w, mplapackint const ldw, mplapackint &info);
void Clasyf_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *w, mplapackint const ldw, mplapackint &info);
void Clatbs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_complex *x, dd_real &scale, dd_real *cnorm, mplapackint &info);
void Clatdf(mplapackint const ijob, mplapackint const n, dd_complex *z, mplapackint const ldz, dd_complex *rhs, dd_real &rdsum, dd_real &rdscal, mplapackint *ipiv, mplapackint *jpiv);
void Clatps(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, dd_complex *ap, dd_complex *x, dd_real &scale, dd_real *cnorm, mplapackint &info);
void Clatrd(const char *uplo, mplapackint const n, mplapackint const nb, dd_complex *a, mplapackint const lda, dd_real *e, dd_complex *tau, dd_complex *w, mplapackint const ldw);
void Clatrs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *x, dd_real &scale, dd_real *cnorm, mplapackint &info);
void Clatrz(mplapackint const m, mplapackint const n, mplapackint const l, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work);
void Clatsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const ldt, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Claunhr_col_getrfnp(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *d, mplapackint &info);
void Claunhr_col_getrfnp2(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *d, mplapackint &info);
void Clauu2(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint &info);
void Clauum(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint &info);
void Cpbcon(const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_real const anorm, dd_real &rcond, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cpbequ(const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_real *s, dd_real &scond, dd_real &amax, mplapackint &info);
void Cpbrfs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, dd_complex *ab, mplapackint const ldab, dd_complex *afb, mplapackint const ldafb, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cpbstf(const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, mplapackint &info);
void Cpbsv(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, dd_complex *ab, mplapackint const ldab, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cpbsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, dd_complex *ab, mplapackint const ldab, dd_complex *afb, mplapackint const ldafb, char *equed, dd_real *s, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cpbtf2(const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, mplapackint &info);
void Cpbtrf(const char *uplo, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, mplapackint &info);
void Cpbtrs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, dd_complex *ab, mplapackint const ldab, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cpftrf(const char *transr, const char *uplo, mplapackint const n, dd_complex *a, mplapackint &info);
void Cpftri(const char *transr, const char *uplo, mplapackint const n, dd_complex *a, mplapackint &info);
void Cpftrs(const char *transr, const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cpocon(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real const anorm, dd_real &rcond, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cpoequ(mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *s, dd_real &scond, dd_real &amax, mplapackint &info);
void Cpoequb(mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *s, dd_real &scond, dd_real &amax, mplapackint &info);
void Cporfs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *af, mplapackint const ldaf, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cposv(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cposvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *af, mplapackint const ldaf, char *equed, dd_real *s, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cpotf2(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint &info);
void Cpotrf(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint &info);
void Cpotrf2(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint &info);
void Cpotri(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint &info);
void Cpotrs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cppcon(const char *uplo, mplapackint const n, dd_complex *ap, dd_real const anorm, dd_real &rcond, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cppequ(const char *uplo, mplapackint const n, dd_complex *ap, dd_real *s, dd_real &scond, dd_real &amax, mplapackint &info);
void Cpprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *ap, dd_complex *afp, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cppsv(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *ap, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cppsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *ap, dd_complex *afp, char *equed, dd_real *s, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cpptrf(const char *uplo, mplapackint const n, dd_complex *ap, mplapackint &info);
void Cpptri(const char *uplo, mplapackint const n, dd_complex *ap, mplapackint &info);
void Cpptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *ap, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cpstf2(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, dd_real const tol, dd_real *work, mplapackint &info);
void Cpstrf(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, dd_real const tol, dd_real *work, mplapackint &info);
void Cptcon(mplapackint const n, dd_real *d, dd_complex *e, dd_real const anorm, dd_real &rcond, dd_real *rwork, mplapackint &info);
void Cpteqr(const char *compz, mplapackint const n, dd_real *d, dd_real *e, dd_complex *z, mplapackint const ldz, dd_real *work, mplapackint &info);
void Cptrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *d, dd_complex *e, dd_real *df, dd_complex *ef, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cptsv(mplapackint const n, mplapackint const nrhs, dd_real *d, dd_complex *e, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cptsvx(const char *fact, mplapackint const n, mplapackint const nrhs, dd_real *d, dd_complex *e, dd_real *df, dd_complex *ef, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cpttrf(mplapackint const n, dd_real *d, dd_complex *e, mplapackint &info);
void Cpttrs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *d, dd_complex *e, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cptts2(mplapackint const iuplo, mplapackint const n, mplapackint const nrhs, dd_real *d, dd_complex *e, dd_complex *b, mplapackint const ldb);
void Crot(mplapackint const n, dd_complex *cx, mplapackint const incx, dd_complex *cy, mplapackint const incy, dd_real const c, dd_complex const s);
void Cspcon(const char *uplo, mplapackint const n, dd_complex *ap, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_complex *work, mplapackint &info);
void Cspmv(const char *uplo, mplapackint const n, dd_complex const alpha, dd_complex *ap, dd_complex *x, mplapackint const incx, dd_complex const beta, dd_complex *y, mplapackint const incy);
void Cspr(const char *uplo, mplapackint const n, dd_complex const alpha, dd_complex *x, mplapackint const incx, dd_complex *ap);
void Csprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *ap, dd_complex *afp, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Cspsv(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *ap, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cspsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *ap, dd_complex *afp, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Csptrf(const char *uplo, mplapackint const n, dd_complex *ap, mplapackint *ipiv, mplapackint &info);
void Csptri(const char *uplo, mplapackint const n, dd_complex *ap, mplapackint *ipiv, dd_complex *work, mplapackint &info);
void Csptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *ap, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Cstedc(const char *compz, mplapackint const n, dd_real *d, dd_real *e, dd_complex *z, mplapackint const ldz, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cstein(mplapackint const n, dd_real *d, dd_real *e, mplapackint const m, dd_real *w, mplapackint *iblock, mplapackint *isplit, dd_complex *z, mplapackint const ldz, dd_real *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cstemr(const char *jobz, const char *range, mplapackint const n, dd_real *d, dd_real *e, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, mplapackint &m, dd_real *w, dd_complex *z, mplapackint const ldz, mplapackint const nzc, mplapackint *isuppz, bool &tryrac, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Csteqr(const char *compz, mplapackint const n, dd_real *d, dd_real *e, dd_complex *z, mplapackint const ldz, dd_real *work, mplapackint &info);
void Csycon(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_complex *work, mplapackint &info);
void Csycon_3(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_complex *work, mplapackint &info);
void Csycon_rook(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_complex *work, mplapackint &info);
void Csyconv(const char *uplo, const char *way, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *e, mplapackint &info);
void Csyconvf(const char *uplo, const char *way, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, mplapackint &info);
void Csyconvf_rook(const char *uplo, const char *way, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, mplapackint &info);
void Csyequb(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real *s, dd_real &scond, dd_real &amax, dd_complex *work, mplapackint &info);
void Csymv(const char *uplo, mplapackint const n, dd_complex const alpha, dd_complex *a, mplapackint const lda, dd_complex *x, mplapackint const incx, dd_complex const beta, dd_complex *y, mplapackint const incy);
void Csyr(const char *uplo, mplapackint const n, dd_complex const alpha, dd_complex *x, mplapackint const incx, dd_complex *a, mplapackint const lda);
void Csyrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *af, mplapackint const ldaf, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Csysv(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Csysv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Csysv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Csysv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Csysv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Csysvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *af, mplapackint const ldaf, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint &info);
void Csyswapr(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Csytf2(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Csytf2_rk(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, mplapackint &info);
void Csytf2_rook(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Csytrf(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Csytrf_aa(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Csytrf_aa_2stage(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Csytrf_rk(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Csytrf_rook(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Csytri(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint &info);
void Csytri2(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Csytri2x(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint const nb, mplapackint &info);
void Csytri_3(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Csytri_3x(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_complex *work, mplapackint const nb, mplapackint &info);
void Csytri_rook(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *work, mplapackint &info);
void Csytrs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Csytrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint &info);
void Csytrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *e, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Csytrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Csytrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Csytrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, mplapackint *ipiv, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Ctbcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, dd_complex *ab, mplapackint const ldab, dd_real &rcond, dd_complex *work, dd_real *rwork, mplapackint &info);
void Ctbrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, dd_complex *ab, mplapackint const ldab, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Ctbtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, dd_complex *ab, mplapackint const ldab, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Ctfsm(const char *transr, const char *side, const char *uplo, const char *trans, const char *diag, mplapackint const m, mplapackint const n, dd_complex const alpha, dd_complex *a, dd_complex *b, mplapackint const ldb);
void Ctftri(const char *transr, const char *uplo, const char *diag, mplapackint const n, dd_complex *a, mplapackint &info);
void Ctfttp(const char *transr, const char *uplo, mplapackint const n, dd_complex *arf, dd_complex *ap, mplapackint &info);
void Ctfttr(const char *transr, const char *uplo, mplapackint const n, dd_complex *arf, dd_complex *a, mplapackint const lda, mplapackint &info);
void Ctgevc(const char *side, const char *howmny, bool *select, mplapackint const n, dd_complex *s, mplapackint const lds, dd_complex *p, mplapackint const ldp, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, dd_complex *work, dd_real *rwork, mplapackint &info);
void Ctgex2(bool const wantq, bool const wantz, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *q, mplapackint const ldq, dd_complex *z, mplapackint const ldz, mplapackint const j1, mplapackint &info);
void Ctgexc(bool const wantq, bool const wantz, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *q, mplapackint const ldq, dd_complex *z, mplapackint const ldz, mplapackint const ifst, mplapackint &ilst, mplapackint &info);
void Ctgsen(mplapackint const ijob, bool const wantq, bool const wantz, bool *select, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *alpha, dd_complex *beta, dd_complex *q, mplapackint const ldq, dd_complex *z, mplapackint const ldz, mplapackint &m, dd_real &pl, dd_real &pr, dd_real *dif, dd_complex *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Ctgsja(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mplapackint const k, mplapackint const l, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_real const tola, dd_real const tolb, dd_real *alpha, dd_real *beta, dd_complex *u, mplapackint const ldu, dd_complex *v, mplapackint const ldv, dd_complex *q, mplapackint const ldq, dd_complex *work, mplapackint &ncycle, mplapackint &info);
void Ctgsna(const char *job, const char *howmny, bool *select, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, dd_real *s, dd_real *dif, mplapackint const mm, mplapackint &m, dd_complex *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Ctgsy2(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *c, mplapackint const ldc, dd_complex *d, mplapackint const ldd, dd_complex *e, mplapackint const lde, dd_complex *f, mplapackint const ldf, dd_real &scale, dd_real &rdsum, dd_real &rdscal, mplapackint &info);
void Ctgsyl(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *c, mplapackint const ldc, dd_complex *d, mplapackint const ldd, dd_complex *e, mplapackint const lde, dd_complex *f, mplapackint const ldf, dd_real &scale, dd_real &dif, dd_complex *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Ctpcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, dd_complex *ap, dd_real &rcond, dd_complex *work, dd_real *rwork, mplapackint &info);
void Ctplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *t, mplapackint const ldt, dd_complex *work, mplapackint &info);
void Ctplqt2(mplapackint const m, mplapackint const n, mplapackint const l, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *t, mplapackint const ldt, mplapackint &info);
void Ctpmlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const mb, dd_complex *v, mplapackint const ldv, dd_complex *t, mplapackint const ldt, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint &info);
void Ctpmqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const nb, dd_complex *v, mplapackint const ldv, dd_complex *t, mplapackint const ldt, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint &info);
void Ctpqrt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *t, mplapackint const ldt, dd_complex *work, mplapackint &info);
void Ctpqrt2(mplapackint const m, mplapackint const n, mplapackint const l, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *t, mplapackint const ldt, mplapackint &info);
void Ctprfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, dd_complex *v, mplapackint const ldv, dd_complex *t, mplapackint const ldt, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *work, mplapackint const ldwork);
void Ctprfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, dd_complex *ap, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Ctptri(const char *uplo, const char *diag, mplapackint const n, dd_complex *ap, mplapackint &info);
void Ctptrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, dd_complex *ap, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Ctpttf(const char *transr, const char *uplo, mplapackint const n, dd_complex *ap, dd_complex *arf, mplapackint &info);
void Ctpttr(const char *uplo, mplapackint const n, dd_complex *ap, dd_complex *a, mplapackint const lda, mplapackint &info);
void Ctrcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, dd_complex *a, mplapackint const lda, dd_real &rcond, dd_complex *work, dd_real *rwork, mplapackint &info);
void Ctrevc(const char *side, const char *howmny, bool *select, mplapackint const n, dd_complex *t, mplapackint const ldt, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, dd_complex *work, dd_real *rwork, mplapackint &info);
void Ctrevc3(const char *side, const char *howmny, bool *select, mplapackint const n, dd_complex *t, mplapackint const ldt, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint &info);
void Ctrexc(const char *compq, mplapackint const n, dd_complex *t, mplapackint const ldt, dd_complex *q, mplapackint const ldq, mplapackint const ifst, mplapackint const ilst, mplapackint &info);
void Ctrrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_complex *work, dd_real *rwork, mplapackint &info);
void Ctrsen(const char *job, const char *compq, bool *select, mplapackint const n, dd_complex *t, mplapackint const ldt, dd_complex *q, mplapackint const ldq, dd_complex *w, mplapackint &m, dd_real &s, dd_real &sep, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Ctrsna(const char *job, const char *howmny, bool *select, mplapackint const n, dd_complex *t, mplapackint const ldt, dd_complex *vl, mplapackint const ldvl, dd_complex *vr, mplapackint const ldvr, dd_real *s, dd_real *sep, mplapackint const mm, mplapackint &m, dd_complex *work, mplapackint const ldwork, dd_real *rwork, mplapackint &info);
void Ctrsyl(const char *trana, const char *tranb, mplapackint const isgn, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, dd_complex *c, mplapackint const ldc, dd_real &scale, mplapackint &info);
void Ctrti2(const char *uplo, const char *diag, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint &info);
void Ctrtri(const char *uplo, const char *diag, mplapackint const n, dd_complex *a, mplapackint const lda, mplapackint &info);
void Ctrtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, dd_complex *a, mplapackint const lda, dd_complex *b, mplapackint const ldb, mplapackint &info);
void Ctrttf(const char *transr, const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *arf, mplapackint &info);
void Ctrttp(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *ap, mplapackint &info);
void Ctzrzf(mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb(const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, dd_complex *x11, mplapackint const ldx11, dd_complex *x12, mplapackint const ldx12, dd_complex *x21, mplapackint const ldx21, dd_complex *x22, mplapackint const ldx22, dd_real *theta, dd_real *phi, dd_complex *taup1, dd_complex *taup2, dd_complex *tauq1, dd_complex *tauq2, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb1(mplapackint const m, mplapackint const p, mplapackint const q, dd_complex *x11, mplapackint const ldx11, dd_complex *x21, mplapackint const ldx21, dd_real *theta, dd_real *phi, dd_complex *taup1, dd_complex *taup2, dd_complex *tauq1, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb2(mplapackint const m, mplapackint const p, mplapackint const q, dd_complex *x11, mplapackint const ldx11, dd_complex *x21, mplapackint const ldx21, dd_real *theta, dd_real *phi, dd_complex *taup1, dd_complex *taup2, dd_complex *tauq1, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb3(mplapackint const m, mplapackint const p, mplapackint const q, dd_complex *x11, mplapackint const ldx11, dd_complex *x21, mplapackint const ldx21, dd_real *theta, dd_real *phi, dd_complex *taup1, dd_complex *taup2, dd_complex *tauq1, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb4(mplapackint const m, mplapackint const p, mplapackint const q, dd_complex *x11, mplapackint const ldx11, dd_complex *x21, mplapackint const ldx21, dd_real *theta, dd_real *phi, dd_complex *taup1, dd_complex *taup2, dd_complex *tauq1, dd_complex *phantom, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb5(mplapackint const m1, mplapackint const m2, mplapackint const n, dd_complex *x1, mplapackint const incx1, dd_complex *x2, mplapackint const incx2, dd_complex *q1, mplapackint const ldq1, dd_complex *q2, mplapackint const ldq2, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunbdb6(mplapackint const m1, mplapackint const m2, mplapackint const n, dd_complex *x1, mplapackint const incx1, dd_complex *x2, mplapackint const incx2, dd_complex *q1, mplapackint const ldq1, dd_complex *q2, mplapackint const ldq2, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cuncsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, dd_complex *x11, mplapackint const ldx11, dd_complex *x12, mplapackint const ldx12, dd_complex *x21, mplapackint const ldx21, dd_complex *x22, mplapackint const ldx22, dd_real *theta, dd_complex *u1, mplapackint const ldu1, dd_complex *u2, mplapackint const ldu2, dd_complex *v1t, mplapackint const ldv1t, dd_complex *v2t, mplapackint const ldv2t, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cuncsd2by1(const char *jobu1, const char *jobu2, const char *jobv1t, mplapackint const m, mplapackint const p, mplapackint const q, dd_complex *x11, mplapackint const ldx11, dd_complex *x21, mplapackint const ldx21, dd_real *theta, dd_complex *u1, mplapackint const ldu1, dd_complex *u2, mplapackint const ldu2, dd_complex *v1t, mplapackint const ldv1t, dd_complex *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cung2l(mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint &info);
void Cung2r(mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint &info);
void Cungbr(const char *vect, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunghr(mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cungl2(mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint &info);
void Cunglq(mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cungql(mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cungqr(mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cungr2(mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint &info);
void Cungrq(mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cungtr(const char *uplo, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cungtsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const ldt, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cungtsqr_row(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const ldt, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunhr_col(mplapackint const m, mplapackint const n, mplapackint const nb, dd_complex *a, mplapackint const lda, dd_complex *t, mplapackint const ldt, dd_complex *d, mplapackint &info);
void Cunm22(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const n1, mplapackint const n2, dd_complex *q, mplapackint const ldq, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunm2l(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint &info);
void Cunm2r(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint &info);
void Cunmbr(const char *vect, const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunmhr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunml2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint &info);
void Cunmlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunmql(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunmqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunmr2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint &info);
void Cunmr3(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint &info);
void Cunmrq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunmrz(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cunmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, dd_complex *a, mplapackint const lda, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint const lwork, mplapackint &info);
void Cupgtr(const char *uplo, mplapackint const n, dd_complex *ap, dd_complex *tau, dd_complex *q, mplapackint const ldq, dd_complex *work, mplapackint &info);
void Cupmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, dd_complex *ap, dd_complex *tau, dd_complex *c, mplapackint const ldc, dd_complex *work, mplapackint &info);
void Rbbcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, mplapackint const m, mplapackint const p, mplapackint const q, dd_real *theta, dd_real *phi, dd_real *u1, mplapackint const ldu1, dd_real *u2, mplapackint const ldu2, dd_real *v1t, mplapackint const ldv1t, dd_real *v2t, mplapackint const ldv2t, dd_real *b11d, dd_real *b11e, dd_real *b12d, dd_real *b12e, dd_real *b21d, dd_real *b21e, dd_real *b22d, dd_real *b22e, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rbdsdc(const char *uplo, const char *compq, mplapackint const n, dd_real *d, dd_real *e, dd_real *u, mplapackint const ldu, dd_real *vt, mplapackint const ldvt, dd_real *q, mplapackint *iq, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rbdsqr(const char *uplo, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, dd_real *d, dd_real *e, dd_real *vt, mplapackint const ldvt, dd_real *u, mplapackint const ldu, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint &info);
void Rbdsvdx(const char *uplo, const char *jobz, const char *range, mplapackint const n, dd_real *d, dd_real *e, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, dd_real *s, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rcombssq(dd_real *v1, dd_real *v2);
void Rdisna(const char *job, mplapackint const m, mplapackint const n, dd_real *d, dd_real *sep, mplapackint &info);
void Rgbbrd(const char *vect, mplapackint const m, mplapackint const n, mplapackint const ncc, mplapackint const kl, mplapackint const ku, dd_real *ab, mplapackint const ldab, dd_real *d, dd_real *e, dd_real *q, mplapackint const ldq, dd_real *pt, mplapackint const ldpt, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint &info);
void Rgbcon(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_real *ab, mplapackint const ldab, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rgbequ(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_real *ab, mplapackint const ldab, dd_real *r, dd_real *c, dd_real &rowcnd, dd_real &colcnd, dd_real &amax, mplapackint &info);
void Rgbequb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_real *ab, mplapackint const ldab, dd_real *r, dd_real *c, dd_real &rowcnd, dd_real &colcnd, dd_real &amax, mplapackint &info);
void Rgbrfs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, dd_real *ab, mplapackint const ldab, dd_real *afb, mplapackint const ldafb, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rgbsv(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, dd_real *ab, mplapackint const ldab, mplapackint *ipiv, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rgbsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, dd_real *ab, mplapackint const ldab, dd_real *afb, mplapackint const ldafb, mplapackint *ipiv, char *equed, dd_real *r, dd_real *c, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rgbtf2(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_real *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Rgbtrf(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_real *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Rgbtrs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, dd_real *ab, mplapackint const ldab, mplapackint *ipiv, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rgebak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *scale, mplapackint const m, dd_real *v, mplapackint const ldv, mplapackint &info);
void Rgebal(const char *job, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint &ilo, mplapackint &ihi, dd_real *scale, mplapackint &info);
void Rgebd2(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *d, dd_real *e, dd_real *tauq, dd_real *taup, dd_real *work, mplapackint &info);
void Rgebrd(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *d, dd_real *e, dd_real *tauq, dd_real *taup, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgecon(const char *norm, mplapackint const n, dd_real *a, mplapackint const lda, dd_real const anorm, dd_real &rcond, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rgeequ(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *r, dd_real *c, dd_real &rowcnd, dd_real &colcnd, dd_real &amax, mplapackint &info);
void Rgeequb(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *r, dd_real *c, dd_real &rowcnd, dd_real &colcnd, dd_real &amax, mplapackint &info);
void Rgees(const char *jobvs, const char *sort, bool (*select)(dd_real, dd_real), mplapackint const n, dd_real *a, mplapackint const lda, mplapackint &sdim, dd_real *wr, dd_real *wi, dd_real *vs, mplapackint const ldvs, dd_real *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rgeesx(const char *jobvs, const char *sort, bool (*select)(dd_real, dd_real), const char *sense, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint &sdim, dd_real *wr, dd_real *wi, dd_real *vs, mplapackint const ldvs, dd_real &rconde, dd_real &rcondv, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rgeev(const char *jobvl, const char *jobvr, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *wr, dd_real *wi, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *wr, dd_real *wi, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, dd_real *scale, dd_real &abnrm, dd_real *rconde, dd_real *rcondv, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgehd2(mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint &info);
void Rgehrd(mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgejsv(const char *joba, const char *jobu, const char *jobv, const char *jobr, const char *jobt, const char *jobp, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *sva, dd_real *u, mplapackint const ldu, dd_real *v, mplapackint const ldv, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgelq(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const tsize, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgelq2(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint &info);
void Rgelqf(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgelqt(mplapackint const m, mplapackint const n, mplapackint const mb, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const ldt, dd_real *work, mplapackint &info);
void Rgelqt3(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const ldt, mplapackint &info);
void Rgels(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgelsd(mplapackint const m, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *s, dd_real const rcond, mplapackint &rank, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgelss(mplapackint const m, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *s, dd_real const rcond, mplapackint &rank, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgelsy(mplapackint const m, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, mplapackint *jpvt, dd_real const rcond, mplapackint &rank, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgemlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const tsize, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgemlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, dd_real *v, mplapackint const ldv, dd_real *t, mplapackint const ldt, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint &info);
void Rgemqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const tsize, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgemqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const nb, dd_real *v, mplapackint const ldv, dd_real *t, mplapackint const ldt, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint &info);
void Rgeql2(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint &info);
void Rgeqlf(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgeqp3(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *jpvt, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgeqr(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const tsize, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgeqr2(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint &info);
void Rgeqr2p(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint &info);
void Rgeqrf(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgeqrfp(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgeqrt(mplapackint const m, mplapackint const n, mplapackint const nb, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const ldt, dd_real *work, mplapackint &info);
void Rgeqrt2(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const ldt, mplapackint &info);
void Rgeqrt3(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const ldt, mplapackint &info);
void Rgerfs(const char *trans, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *af, mplapackint const ldaf, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rgerq2(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint &info);
void Rgerqf(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgesc2(mplapackint const n, dd_real *a, mplapackint const lda, dd_real *rhs, mplapackint *ipiv, mplapackint *jpiv, dd_real &scale);
void Rgesdd(const char *jobz, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *s, dd_real *u, mplapackint const ldu, dd_real *vt, mplapackint const ldvt, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgesv(mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rgesvd(const char *jobu, const char *jobvt, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *s, dd_real *u, mplapackint const ldu, dd_real *vt, mplapackint const ldvt, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgesvdq(const char *joba, const char *jobp, const char *jobr, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *s, dd_real *u, mplapackint const ldu, dd_real *v, mplapackint const ldv, mplapackint &numrank, mplapackint *iwork, mplapackint const liwork, dd_real *work, mplapackint const lwork, dd_real *rwork, mplapackint const lrwork, mplapackint &info);
void Rgesvdx(const char *jobu, const char *jobvt, const char *range, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, dd_real *s, dd_real *u, mplapackint const ldu, dd_real *vt, mplapackint const ldvt, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgesvj(const char *joba, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *sva, mplapackint const mv, dd_real *v, mplapackint const ldv, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgesvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *af, mplapackint const ldaf, mplapackint *ipiv, char *equed, dd_real *r, dd_real *c, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rgetc2(mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, mplapackint *jpiv, mplapackint &info);
void Rgetf2(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetrf(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetrf2(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetri(mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgetrs(const char *trans, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rgetsls(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgetsqrhrt(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const ldt, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rggbak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *lscale, dd_real *rscale, mplapackint const m, dd_real *v, mplapackint const ldv, mplapackint &info);
void Rggbal(const char *job, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, mplapackint &ilo, mplapackint &ihi, dd_real *lscale, dd_real *rscale, dd_real *work, mplapackint &info);
void Rgges(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(dd_real, dd_real, dd_real), mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, mplapackint &sdim, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *vsl, mplapackint const ldvsl, dd_real *vsr, mplapackint const ldvsr, dd_real *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rgges3(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(dd_real, dd_real, dd_real), mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, mplapackint &sdim, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *vsl, mplapackint const ldvsl, dd_real *vsr, mplapackint const ldvsr, dd_real *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rggesx(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(dd_real, dd_real, dd_real), const char *sense, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, mplapackint &sdim, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *vsl, mplapackint const ldvsl, dd_real *vsr, mplapackint const ldvsr, dd_real *rconde, dd_real *rcondv, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rggev(const char *jobvl, const char *jobvr, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rggev3(const char *jobvl, const char *jobvr, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, dd_real *lscale, dd_real *rscale, dd_real &abnrm, dd_real &bbnrm, dd_real *rconde, dd_real *rcondv, dd_real *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rggglm(mplapackint const n, mplapackint const m, mplapackint const p, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *d, dd_real *x, dd_real *y, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgghd3(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *q, mplapackint const ldq, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgghrd(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *q, mplapackint const ldq, dd_real *z, mplapackint const ldz, mplapackint &info);
void Rgglse(mplapackint const m, mplapackint const n, mplapackint const p, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *c, dd_real *d, dd_real *x, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rggqrf(mplapackint const n, mplapackint const m, mplapackint const p, dd_real *a, mplapackint const lda, dd_real *taua, dd_real *b, mplapackint const ldb, dd_real *taub, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rggrqf(mplapackint const m, mplapackint const p, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *taua, dd_real *b, mplapackint const ldb, dd_real *taub, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rggsvd3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const n, mplapackint const p, mplapackint &k, mplapackint &l, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *alpha, dd_real *beta, dd_real *u, mplapackint const ldu, dd_real *v, mplapackint const ldv, dd_real *q, mplapackint const ldq, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rggsvp3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real const tola, dd_real const tolb, mplapackint &k, mplapackint &l, dd_real *u, mplapackint const ldu, dd_real *v, mplapackint const ldv, dd_real *q, mplapackint const ldq, mplapackint *iwork, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgsvj0(const char *jobv, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *d, dd_real *sva, mplapackint const mv, dd_real *v, mplapackint const ldv, dd_real const eps, dd_real const sfmin, dd_real const tol, mplapackint const nsweep, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgsvj1(const char *jobv, mplapackint const m, mplapackint const n, mplapackint const n1, dd_real *a, mplapackint const lda, dd_real *d, dd_real *sva, mplapackint const mv, dd_real *v, mplapackint const ldv, dd_real const eps, dd_real const sfmin, dd_real const tol, mplapackint const nsweep, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rgtcon(const char *norm, mplapackint const n, dd_real *dl, dd_real *d, dd_real *du, dd_real *du2, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rgtrfs(const char *trans, mplapackint const n, mplapackint const nrhs, dd_real *dl, dd_real *d, dd_real *du, dd_real *dlf, dd_real *df, dd_real *duf, dd_real *du2, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rgtsv(mplapackint const n, mplapackint const nrhs, dd_real *dl, dd_real *d, dd_real *du, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rgtsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, dd_real *dl, dd_real *d, dd_real *du, dd_real *dlf, dd_real *df, dd_real *duf, dd_real *du2, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rgttrf(mplapackint const n, dd_real *dl, dd_real *d, dd_real *du, dd_real *du2, mplapackint *ipiv, mplapackint &info);
void Rgttrs(const char *trans, mplapackint const n, mplapackint const nrhs, dd_real *dl, dd_real *d, dd_real *du, dd_real *du2, mplapackint *ipiv, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rgtts2(mplapackint const itrans, mplapackint const n, mplapackint const nrhs, dd_real *dl, dd_real *d, dd_real *du, dd_real *du2, mplapackint *ipiv, dd_real *b, mplapackint const ldb);
void Rhgeqz(const char *job, const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *h, mplapackint const ldh, dd_real *t, mplapackint const ldt, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *q, mplapackint const ldq, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rhsein(const char *side, const char *eigsrc, const char *initv, bool *select, mplapackint const n, dd_real *h, mplapackint const ldh, dd_real *wr, dd_real *wi, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, dd_real *work, mplapackint *ifaill, mplapackint *ifailr, mplapackint &info);
void Rhseqr(const char *job, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *h, mplapackint const ldh, dd_real *wr, dd_real *wi, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rla_gbamv(mplapackint const trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_real const alpha, dd_real *ab, mplapackint const ldab, dd_real *x, mplapackint const incx, dd_real const beta, dd_real *y, mplapackint const incy);
void Rla_geamv(mplapackint const trans, mplapackint const m, mplapackint const n, dd_real const alpha, dd_real *a, mplapackint const lda, dd_real *x, mplapackint const incx, dd_real const beta, dd_real *y, mplapackint const incy);
void Rla_syamv(mplapackint const uplo, mplapackint const n, dd_real const alpha, dd_real *a, mplapackint const lda, dd_real *x, mplapackint const incx, dd_real const beta, dd_real *y, mplapackint const incy);
void Rla_wwaddw(mplapackint const n, dd_real *x, dd_real *y, dd_real *w);
void Rlabad(dd_real &small, dd_real &large);
void Rlabrd(mplapackint const m, mplapackint const n, mplapackint const nb, dd_real *a, mplapackint const lda, dd_real *d, dd_real *e, dd_real *tauq, dd_real *taup, dd_real *x, mplapackint const ldx, dd_real *y, mplapackint const ldy);
void Rlacn2(mplapackint const n, dd_real *v, dd_real *x, mplapackint *isgn, dd_real &est, mplapackint &kase, mplapackint *isave);
void Rlacon(mplapackint const n, dd_real *v, dd_real *x, mplapackint *isgn, dd_real &est, mplapackint &kase);
void Rlacpy(const char *uplo, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb);
void Rladiv(dd_real const &a, dd_real const &b, dd_real const &c, dd_real const &d, dd_real &p, dd_real &q);
void Rladiv1(dd_real &a, dd_real const &b, dd_real const &c, dd_real const &d, dd_real &p, dd_real &q);
void Rlae2(dd_real const a, dd_real const b, dd_real const c, dd_real &rt1, dd_real &rt2);
void Rlaebz(mplapackint const ijob, mplapackint const nitmax, mplapackint const n, mplapackint const mmax, mplapackint const minp, mplapackint const nbmin, dd_real const abstol, dd_real const reltol, dd_real const pivmin, dd_real *d, dd_real *e, dd_real *e2, mplapackint *nval, dd_real *ab, dd_real *c, mplapackint &mout, mplapackint *nab, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rlaed0(mplapackint const icompq, mplapackint const qsiz, mplapackint const n, dd_real *d, dd_real *e, dd_real *q, mplapackint const ldq, dd_real *qstore, mplapackint const ldqs, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rlaed1(mplapackint const n, dd_real *d, dd_real *q, mplapackint const ldq, mplapackint *indxq, dd_real rho, mplapackint const cutpnt, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rlaed2(mplapackint &k, mplapackint const n, mplapackint const n1, dd_real *d, dd_real *q, mplapackint const ldq, mplapackint *indxq, dd_real &rho, dd_real *z, dd_real *dlamda, dd_real *w, dd_real *q2, mplapackint *indx, mplapackint *indxc, mplapackint *indxp, mplapackint *coltyp, mplapackint &info);
void Rlaed3(mplapackint const k, mplapackint const n, mplapackint const n1, dd_real *d, dd_real *q, mplapackint const ldq, dd_real const rho, dd_real *dlamda, dd_real *q2, mplapackint *indx, mplapackint *ctot, dd_real *w, dd_real *s, mplapackint &info);
void Rlaed4(mplapackint const n, mplapackint const i, dd_real *d, dd_real *z, dd_real *delta, dd_real const rho, dd_real &dlam, mplapackint &info);
void Rlaed5(mplapackint const i, dd_real *d, dd_real *z, dd_real *delta, dd_real const rho, dd_real &dlam);
void Rlaed6(mplapackint const kniter, bool const orgati, dd_real const rho, dd_real *d, dd_real *z, dd_real const finit, dd_real &tau, mplapackint &info);
void Rlaed7(mplapackint const icompq, mplapackint const n, mplapackint const qsiz, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, dd_real *d, dd_real *q, mplapackint const ldq, mplapackint *indxq, dd_real rho, mplapackint const cutpnt, dd_real *qstore, mplapackint *qptr, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, dd_real *givnum, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rlaed8(mplapackint const icompq, mplapackint &k, mplapackint const n, mplapackint const qsiz, dd_real *d, dd_real *q, mplapackint const ldq, mplapackint *indxq, dd_real &rho, mplapackint const cutpnt, dd_real *z, dd_real *dlamda, dd_real *q2, mplapackint const ldq2, dd_real *w, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, dd_real *givnum, mplapackint *indxp, mplapackint *indx, mplapackint &info);
void Rlaed9(mplapackint const k, mplapackint const kstart, mplapackint const kstop, mplapackint const n, dd_real *d, dd_real *q, mplapackint const ldq, dd_real const rho, dd_real *dlamda, dd_real *w, dd_real *s, mplapackint const lds, mplapackint &info);
void Rlaeda(mplapackint const n, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, dd_real *givnum, dd_real *q, mplapackint *qptr, dd_real *z, dd_real *ztemp, mplapackint &info);
void Rlaein(bool const rightv, bool const noinit, mplapackint const n, dd_real *h, mplapackint const ldh, dd_real const wr, dd_real const wi, dd_real *vr, dd_real *vi, dd_real *b, mplapackint const ldb, dd_real *work, dd_real const eps3, dd_real const smlnum, dd_real const bignum, mplapackint &info);
void Rlaev2(dd_real const a, dd_real const b, dd_real const c, dd_real &rt1, dd_real &rt2, dd_real &cs1, dd_real &sn1);
void Rlaexc(bool const wantq, mplapackint const n, dd_real *t, mplapackint const ldt, dd_real *q, mplapackint const ldq, mplapackint const j1, mplapackint const n1, mplapackint const n2, dd_real *work, mplapackint &info);
void Rlag2(dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real const safmin, dd_real &scale1, dd_real &scale2, dd_real &wr1, dd_real &wr2, dd_real &wi);
void Rlags2(bool const upper, dd_real const a1, dd_real const a2, dd_real const a3, dd_real const b1, dd_real const b2, dd_real const b3, dd_real &csu, dd_real &snu, dd_real &csv, dd_real &snv, dd_real &csq, dd_real &snq);
void Rlagtf(mplapackint const n, dd_real *a, dd_real const lambda, dd_real *b, dd_real *c, dd_real const tol, dd_real *d, mplapackint *in, mplapackint &info);
void Rlagtm(const char *trans, mplapackint const n, mplapackint const nrhs, dd_real const alpha, dd_real *dl, dd_real *d, dd_real *du, dd_real *x, mplapackint const ldx, dd_real const beta, dd_real *b, mplapackint const ldb);
void Rlagts(mplapackint const job, mplapackint const n, dd_real *a, dd_real *b, dd_real *c, dd_real *d, mplapackint *in, dd_real *y, dd_real &tol, mplapackint &info);
void Rlagv2(dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real &csl, dd_real &snl, dd_real &csr, dd_real &snr);
void Rlahqr(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *h, mplapackint const ldh, dd_real *wr, dd_real *wi, mplapackint const iloz, mplapackint const ihiz, dd_real *z, mplapackint const ldz, mplapackint &info);
void Rlahr2(mplapackint const n, mplapackint const k, mplapackint const nb, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *t, mplapackint const ldt, dd_real *y, mplapackint const ldy);
void Rlaic1(mplapackint const job, mplapackint const j, dd_real *x, dd_real const sest, dd_real *w, dd_real const gamma, dd_real &sestpr, dd_real &s, dd_real &c);
void Rlaln2(bool const ltrans, mplapackint const na, mplapackint const nw, dd_real const smin, dd_real const ca, dd_real *a, mplapackint const lda, dd_real const d1, dd_real const d2, dd_real *b, mplapackint const ldb, dd_real const wr, dd_real const wi, dd_real *x, mplapackint const ldx, dd_real &scale, dd_real &xnorm, mplapackint &info);
void Rlals0(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const nrhs, dd_real *b, mplapackint const ldb, dd_real *bx, mplapackint const ldbx, mplapackint *perm, mplapackint const givptr, mplapackint *givcol, mplapackint const ldgcol, dd_real *givnum, mplapackint const ldgnum, dd_real *poles, dd_real *difl, dd_real *difr, dd_real *z, mplapackint const k, dd_real const c, dd_real const s, dd_real *work, mplapackint &info);
void Rlalsa(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, dd_real *b, mplapackint const ldb, dd_real *bx, mplapackint const ldbx, dd_real *u, mplapackint const ldu, dd_real *vt, mplapackint *k, dd_real *difl, dd_real *difr, dd_real *z, dd_real *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, dd_real *givnum, dd_real *c, dd_real *s, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rlalsd(const char *uplo, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, dd_real *d, dd_real *e, dd_real *b, mplapackint const ldb, dd_real const rcond, mplapackint &rank, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rlamrg(mplapackint const n1, mplapackint const n2, dd_real *a, mplapackint const dtrd1, mplapackint const dtrd2, mplapackint *index);
void Rlamswlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const ldt, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rlamtsqr(const char *side, const char *trans, mplapackint const &m, mplapackint const &n, mplapackint const &k, mplapackint const &mb, mplapackint const &nb, dd_real *a, mplapackint const &lda, dd_real *t, mplapackint const &ldt, dd_real *c, mplapackint const &ldc, dd_real *work, mplapackint const &lwork, mplapackint &info);
void Rlanv2(dd_real &a, dd_real &b, dd_real &c, dd_real &d, dd_real &rt1r, dd_real &rt1i, dd_real &rt2r, dd_real &rt2i, dd_real &cs, dd_real &sn);
void Rlaorhr_col_getrfnp(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *d, mplapackint &info);
void Rlaorhr_col_getrfnp2(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *d, mplapackint &info);
void Rlapll(mplapackint const n, dd_real *x, mplapackint const incx, dd_real *y, mplapackint const incy, dd_real &ssmin);
void Rlapmr(bool const forwrd, mplapackint const m, mplapackint const n, dd_real *x, mplapackint const ldx, mplapackint *k);
void Rlapmt(bool const forwrd, mplapackint const m, mplapackint const n, dd_real *x, mplapackint const ldx, mplapackint *k);
void Rlaqgb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, dd_real *ab, mplapackint const ldab, dd_real *r, dd_real *c, dd_real const rowcnd, dd_real const colcnd, dd_real const amax, char *equed);
void Rlaqge(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *r, dd_real *c, dd_real const rowcnd, dd_real const colcnd, dd_real const amax, char *equed);
void Rlaqp2(mplapackint const m, mplapackint const n, mplapackint const offset, dd_real *a, mplapackint const lda, mplapackint *jpvt, dd_real *tau, dd_real *vn1, dd_real *vn2, dd_real *work);
void Rlaqps(mplapackint const m, mplapackint const n, mplapackint const offset, mplapackint const nb, mplapackint &kb, dd_real *a, mplapackint const lda, mplapackint *jpvt, dd_real *tau, dd_real *vn1, dd_real *vn2, dd_real *auxv, dd_real *f, mplapackint const ldf);
void Rlaqr0(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *h, mplapackint const ldh, dd_real *wr, dd_real *wi, mplapackint const iloz, mplapackint const ihiz, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rlaqr1(mplapackint const n, dd_real *h, mplapackint const ldh, dd_real const sr1, dd_real const si1, dd_real const sr2, dd_real const si2, dd_real *v);
void Rlaqr2(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, dd_real *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, dd_real *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, dd_real *sr, dd_real *si, dd_real *v, mplapackint const ldv, mplapackint const nh, dd_real *t, mplapackint const ldt, mplapackint const nv, dd_real *wv, mplapackint const ldwv, dd_real *work, mplapackint const lwork);
void Rlaqr3(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, dd_real *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, dd_real *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, dd_real *sr, dd_real *si, dd_real *v, mplapackint const ldv, mplapackint const nh, dd_real *t, mplapackint const ldt, mplapackint const nv, dd_real *wv, mplapackint const ldwv, dd_real *work, mplapackint const lwork);
void Rlaqr4(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *h, mplapackint const ldh, dd_real *wr, dd_real *wi, mplapackint const iloz, mplapackint const ihiz, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rlaqr5(bool const wantt, bool const wantz, mplapackint const kacc22, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nshfts, dd_real *sr, dd_real *si, dd_real *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, dd_real *z, mplapackint const ldz, dd_real *v, mplapackint const ldv, dd_real *u, mplapackint const ldu, mplapackint const nv, dd_real *wv, mplapackint const ldwv, mplapackint const nh, dd_real *wh, mplapackint const ldwh);
void Rlaqsb(const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, dd_real *s, dd_real const scond, dd_real const amax, char *equed);
void Rlaqsp(const char *uplo, mplapackint const n, dd_real *ap, dd_real *s, dd_real const scond, dd_real const amax, char *equed);
void Rlaqsy(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *s, dd_real const scond, dd_real const amax, char *equed);
void Rlaqtr(bool const ltran, bool const lreal, mplapackint const n, dd_real *t, mplapackint const ldt, dd_real *b, dd_real const w, dd_real &scale, dd_real *x, dd_real *work, mplapackint &info);
void Rlar1v(mplapackint const n, mplapackint const b1, mplapackint const bn, dd_real const lambda, dd_real *d, dd_real *l, dd_real *ld, dd_real *lld, dd_real const pivmin, dd_real const gaptol, dd_real *z, bool const wantnc, mplapackint &negcnt, dd_real &ztz, dd_real &mingma, mplapackint &r, mplapackint *isuppz, dd_real &nrminv, dd_real &resid, dd_real &rqcorr, dd_real *work);
void Rlar2v(mplapackint const n, dd_real *x, dd_real *y, dd_real *z, mplapackint const incx, dd_real *c, dd_real *s, mplapackint const incc);
void Rlarf(const char *side, mplapackint const m, mplapackint const n, dd_real *v, mplapackint const incv, dd_real const tau, dd_real *c, mplapackint const ldc, dd_real *work);
void Rlarfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *v, mplapackint const ldv, dd_real *t, mplapackint const ldt, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const ldwork);
void Rlarfb_gett(const char *ident, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *t, mplapackint const ldt, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *work, mplapackint const ldwork);
void Rlarfg(mplapackint const n, dd_real &alpha, dd_real *x, mplapackint const incx, dd_real &tau);
void Rlarfgp(mplapackint const n, dd_real &alpha, dd_real *x, mplapackint const incx, dd_real &tau);
void Rlarft(const char *direct, const char *storev, mplapackint const n, mplapackint const k, dd_real *v, mplapackint const ldv, dd_real *tau, dd_real *t, mplapackint const ldt);
void Rlarfx(const char *side, mplapackint const m, mplapackint const n, dd_real *v, dd_real const tau, dd_real *c, mplapackint const ldc, dd_real *work);
void Rlarfy(const char *uplo, mplapackint const n, dd_real *v, mplapackint const incv, dd_real const tau, dd_real *c, mplapackint const ldc, dd_real *work);
void Rlargv(mplapackint const n, dd_real *x, mplapackint const incx, dd_real *y, mplapackint const incy, dd_real *c, mplapackint const incc);
void Rlarnv(mplapackint const idist, mplapackint *iseed, mplapackint const n, dd_real *x);
void Rlarra(mplapackint const n, dd_real *d, dd_real *e, dd_real *e2, dd_real const spltol, dd_real const tnrm, mplapackint &nsplit, mplapackint *isplit, mplapackint &info);
void Rlarrb(mplapackint const n, dd_real *d, dd_real *lld, mplapackint const ifirst, mplapackint const ilast, dd_real const rtol1, dd_real const rtol2, mplapackint const offset, dd_real *w, dd_real *wgap, dd_real *werr, dd_real *work, mplapackint *iwork, dd_real const pivmin, dd_real const spdiam, mplapackint const twist, mplapackint &info);
void Rlarrc(const char *jobt, mplapackint const n, dd_real const vl, dd_real const vu, dd_real *d, dd_real *e, dd_real const, mplapackint &eigcnt, mplapackint &lcnt, mplapackint &rcnt, mplapackint &info);
void Rlarrd(const char *range, const char *order, mplapackint const n, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real *gers, dd_real const reltol, dd_real *d, dd_real *e, dd_real *e2, dd_real const pivmin, mplapackint const nsplit, mplapackint *isplit, mplapackint &m, dd_real *w, dd_real *werr, dd_real &wl, dd_real &wu, mplapackint *iblock, mplapackint *indexw, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rlarre(const char *range, mplapackint const n, dd_real &vl, dd_real &vu, mplapackint const il, mplapackint const iu, dd_real *d, dd_real *e, dd_real *e2, dd_real const rtol1, dd_real const rtol2, dd_real const spltol, mplapackint nsplit, mplapackint *isplit, mplapackint &m, dd_real *w, dd_real *werr, dd_real *wgap, mplapackint *iblock, mplapackint *indexw, dd_real *gers, dd_real &pivmin, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rlarrf(mplapackint const n, dd_real *d, dd_real *l, dd_real *ld, mplapackint const clstrt, mplapackint const clend, dd_real *w, dd_real *wgap, dd_real *werr, dd_real const spdiam, dd_real const clgapl, dd_real const clgapr, dd_real const pivmin, dd_real &sigma, dd_real *dplus, dd_real *lplus, dd_real *work, mplapackint &info);
void Rlarrj(mplapackint const n, dd_real *d, dd_real *e2, mplapackint const ifirst, mplapackint const ilast, dd_real const rtol, mplapackint const offset, dd_real *w, dd_real *werr, dd_real *work, mplapackint *iwork, dd_real const pivmin, dd_real const spdiam, mplapackint &info);
void Rlarrk(mplapackint const n, mplapackint const iw, dd_real const gl, dd_real const gu, dd_real *d, dd_real *e2, dd_real const pivmin, dd_real const reltol, dd_real &w, dd_real &werr, mplapackint &info);
void Rlarrr(mplapackint const n, dd_real *d, dd_real *e, mplapackint &info);
void Rlarrv(mplapackint const n, dd_real const vl, dd_real const, dd_real *d, dd_real *l, dd_real const pivmin, mplapackint *isplit, mplapackint const m, mplapackint const dol, mplapackint const dou, dd_real const minrgp, dd_real &rtol1, dd_real &rtol2, dd_real *w, dd_real *werr, dd_real *wgap, mplapackint *iblock, mplapackint *indexw, dd_real *gers, dd_real *z, mplapackint const ldz, mplapackint *isuppz, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rlarscl2(mplapackint const m, mplapackint const n, dd_real *d, dd_real *x, mplapackint const ldx);
void Rlartg(dd_real const f, dd_real const g, dd_real &cs, dd_real &sn, dd_real &r);
void Rlartgp(dd_real const f, dd_real const g, dd_real &cs, dd_real &sn, dd_real &r);
void Rlartgs(dd_real const x, dd_real const y, dd_real const sigma, dd_real &cs, dd_real &sn);
void Rlartv(mplapackint const n, dd_real *x, mplapackint const incx, dd_real *y, mplapackint const incy, dd_real *c, dd_real *s, mplapackint const incc);
void Rlaruv(mplapackint *iseed, mplapackint const n, dd_real *x);
void Rlarz(const char *side, mplapackint const m, mplapackint const n, mplapackint const l, dd_real *v, mplapackint const incv, dd_real const tau, dd_real *c, mplapackint const ldc, dd_real *work);
void Rlarzb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, dd_real *v, mplapackint const ldv, dd_real *t, mplapackint const ldt, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const ldwork);
void Rlarzt(const char *direct, const char *storev, mplapackint const n, mplapackint const k, dd_real *v, mplapackint const ldv, dd_real *tau, dd_real *t, mplapackint const ldt);
void Rlas2(dd_real const f, dd_real const g, dd_real const h, dd_real &ssmin, dd_real &ssmax);
void Rlascl(const char *type, mplapackint const kl, mplapackint const ku, dd_real const cfrom, dd_real const cto, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint &info);
void Rlascl2(mplapackint const m, mplapackint const n, dd_real *d, dd_real *x, mplapackint const ldx);
void Rlasd0(mplapackint const n, mplapackint const sqre, dd_real *d, dd_real *e, dd_real *u, mplapackint const ldu, dd_real *vt, mplapackint const ldvt, mplapackint const smlsiz, mplapackint *iwork, dd_real *work, mplapackint &info);
void Rlasd1(mplapackint const nl, mplapackint const nr, mplapackint const sqre, dd_real *d, dd_real &alpha, dd_real &beta, dd_real *u, mplapackint const ldu, dd_real *vt, mplapackint const ldvt, mplapackint *idxq, mplapackint *iwork, dd_real *work, mplapackint &info);
void Rlasd2(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint &k, dd_real *d, dd_real *z, dd_real const alpha, dd_real const beta, dd_real *u, mplapackint const ldu, dd_real *vt, mplapackint const ldvt, dd_real *dsigma, dd_real *u2, mplapackint const ldu2, dd_real *vt2, mplapackint const ldvt2, mplapackint *idxp, mplapackint *idx, mplapackint *idxc, mplapackint *idxq, mplapackint *coltyp, mplapackint &info);
void Rlasd3(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const k, dd_real *d, dd_real *q, mplapackint const ldq, dd_real *dsigma, dd_real *u, mplapackint const ldu, dd_real *u2, mplapackint const ldu2, dd_real *vt, mplapackint const ldvt, dd_real *vt2, mplapackint const ldvt2, mplapackint *idxc, mplapackint *ctot, dd_real *z, mplapackint &info);
void Rlasd4(mplapackint const n, mplapackint const i, dd_real *d, dd_real *z, dd_real *delta, dd_real const rho, dd_real &sigma, dd_real *work, mplapackint &info);
void Rlasd5(mplapackint const i, dd_real *d, dd_real *z, dd_real *delta, dd_real const rho, dd_real &dsigma, dd_real *work);
void Rlasd6(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, dd_real *d, dd_real *vf, dd_real *vl, dd_real &alpha, dd_real &beta, mplapackint *idxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mplapackint const ldgcol, dd_real *givnum, mplapackint const ldgnum, dd_real *poles, dd_real *difl, dd_real *difr, dd_real *z, mplapackint &k, dd_real &c, dd_real &s, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rlasd7(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint &k, dd_real *d, dd_real *z, dd_real *zw, dd_real *vf, dd_real *vfw, dd_real *vl, dd_real *vlw, dd_real const alpha, dd_real const beta, dd_real *dsigma, mplapackint *idx, mplapackint *idxp, mplapackint *idxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mplapackint const ldgcol, dd_real *givnum, mplapackint const ldgnum, dd_real &c, dd_real &s, mplapackint &info);
void Rlasd8(mplapackint const icompq, mplapackint const k, dd_real *d, dd_real *z, dd_real *vf, dd_real *vl, dd_real *difl, dd_real *difr, mplapackint const lddifr, dd_real *dsigma, dd_real *work, mplapackint &info);
void Rlasda(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const sqre, dd_real *d, dd_real *e, dd_real *u, mplapackint const ldu, dd_real *vt, mplapackint *k, dd_real *difl, dd_real *difr, dd_real *z, dd_real *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, dd_real *givnum, dd_real *c, dd_real *s, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rlasdq(const char *uplo, mplapackint const sqre, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, dd_real *d, dd_real *e, dd_real *vt, mplapackint const ldvt, dd_real *u, mplapackint const ldu, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint &info);
void Rlasdt(mplapackint const n, mplapackint &lvl, mplapackint &nd, mplapackint *inode, mplapackint *ndiml, mplapackint *ndimr, mplapackint const msub);
void Rlaset(const char *uplo, mplapackint const m, mplapackint const n, dd_real const alpha, dd_real const beta, dd_real *a, mplapackint const lda);
void Rlasq1(mplapackint const n, dd_real *d, dd_real *e, dd_real *work, mplapackint &info);
void Rlasq2(mplapackint const n, dd_real *z, mplapackint &info);
void Rlasq3(mplapackint const i0, mplapackint &n0, dd_real *z, mplapackint &pp, dd_real &dmin, dd_real &sigma, dd_real &desig, dd_real &qmax, mplapackint &nfail, mplapackint &iter, mplapackint &ndiv, bool const ieee, mplapackint &ttype, dd_real dmin1, dd_real &dmin2, dd_real dn, dd_real dn1, dd_real dn2, dd_real g, dd_real &tau);
void Rlasq4(mplapackint const i0, mplapackint const n0, dd_real *z, mplapackint const pp, mplapackint const n0in, dd_real const dmin, dd_real const dmin1, dd_real const dmin2, dd_real const dn, dd_real const dn1, dd_real const dn2, dd_real &tau, mplapackint &ttype, dd_real &g);
void Rlasq5(mplapackint const i0, mplapackint const n0, dd_real *z, mplapackint const pp, dd_real &tau, dd_real const sigma, dd_real &dmin, dd_real &dmin1, dd_real &dmin2, dd_real &dn, dd_real &dnm1, dd_real &dnm2, bool const ieee, dd_real const eps);
void Rlasq6(mplapackint const i0, mplapackint const n0, dd_real *z, mplapackint const pp, dd_real &dmin, dd_real &dmin1, dd_real &dmin2, dd_real &dn, dd_real &dnm1, dd_real &dnm2);
void Rlasr(const char *side, const char *pivot, const char *direct, mplapackint const m, mplapackint const n, dd_real *c, dd_real *s, dd_real *a, mplapackint const lda);
void Rlasrt(const char *id, mplapackint const n, dd_real *d, mplapackint &info);
void Rlassq(mplapackint const n, dd_real *x, mplapackint const incx, dd_real &scale, dd_real &sumsq);
void Rlasv2(dd_real const f, dd_real const g, dd_real const h, dd_real &ssmin, dd_real &ssmax, dd_real &snr, dd_real &csr, dd_real &snl, dd_real &csl);
void Rlaswlq(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const ldt, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rlaswp(mplapackint const n, dd_real *a, mplapackint const lda, mplapackint const k1, mplapackint const k2, mplapackint *ipiv, mplapackint const incx);
void Rlasy2(bool const ltranl, bool const ltranr, mplapackint const isgn, mplapackint const n1, mplapackint const n2, dd_real *tl, mplapackint const ldtl, dd_real *tr, mplapackint const ldtr, dd_real *b, mplapackint const ldb, dd_real &scale, dd_real *x, mplapackint const ldx, dd_real &xnorm, mplapackint &info);
void Rlasyf(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *w, mplapackint const ldw, mplapackint &info);
void Rlasyf_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *h, mplapackint const ldh, dd_real *work);
void Rlasyf_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, dd_real *a, mplapackint const lda, dd_real *e, mplapackint *ipiv, dd_real *w, mplapackint const ldw, mplapackint &info);
void Rlasyf_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *w, mplapackint const ldw, mplapackint &info);
void Rlatbs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, dd_real *x, dd_real &scale, dd_real *cnorm, mplapackint &info);
void Rlatdf(mplapackint const ijob, mplapackint const n, dd_real *z, mplapackint const ldz, dd_real *rhs, dd_real &rdsum, dd_real &rdscal, mplapackint *ipiv, mplapackint *jpiv);
void Rlatps(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, dd_real *ap, dd_real *x, dd_real &scale, dd_real *cnorm, mplapackint &info);
void Rlatrd(const char *uplo, mplapackint const n, mplapackint const nb, dd_real *a, mplapackint const lda, dd_real *e, dd_real *tau, dd_real *w, mplapackint const ldw);
void Rlatrs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *x, dd_real &scale, dd_real *cnorm, mplapackint &info);
void Rlatrz(mplapackint const m, mplapackint const n, mplapackint const l, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work);
void Rlatsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const ldt, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rlauu2(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint &info);
void Rlauum(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint &info);
void Ropgtr(const char *uplo, mplapackint const n, dd_real *ap, dd_real *tau, dd_real *q, mplapackint const ldq, dd_real *work, mplapackint &info);
void Ropmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, dd_real *ap, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint &info);
void Rorbdb(const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, dd_real *x11, mplapackint const ldx11, dd_real *x12, mplapackint const ldx12, dd_real *x21, mplapackint const ldx21, dd_real *x22, mplapackint const ldx22, dd_real *theta, dd_real *phi, dd_real *taup1, dd_real *taup2, dd_real *tauq1, dd_real *tauq2, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorbdb1(mplapackint const m, mplapackint const p, mplapackint const q, dd_real *x11, mplapackint const ldx11, dd_real *x21, mplapackint const ldx21, dd_real *theta, dd_real *phi, dd_real *taup1, dd_real *taup2, dd_real *tauq1, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorbdb2(mplapackint const m, mplapackint const p, mplapackint const q, dd_real *x11, mplapackint const ldx11, dd_real *x21, mplapackint const ldx21, dd_real *theta, dd_real *phi, dd_real *taup1, dd_real *taup2, dd_real *tauq1, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorbdb3(mplapackint const m, mplapackint const p, mplapackint const q, dd_real *x11, mplapackint const ldx11, dd_real *x21, mplapackint const ldx21, dd_real *theta, dd_real *phi, dd_real *taup1, dd_real *taup2, dd_real *tauq1, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorbdb4(mplapackint const m, mplapackint const p, mplapackint const q, dd_real *x11, mplapackint const ldx11, dd_real *x21, mplapackint const ldx21, dd_real *theta, dd_real *phi, dd_real *taup1, dd_real *taup2, dd_real *tauq1, dd_real *phantom, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorbdb5(mplapackint const m1, mplapackint const m2, mplapackint const n, dd_real *x1, mplapackint const incx1, dd_real *x2, mplapackint const incx2, dd_real *q1, mplapackint const ldq1, dd_real *q2, mplapackint const ldq2, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorbdb6(mplapackint const m1, mplapackint const m2, mplapackint const n, dd_real *x1, mplapackint const incx1, dd_real *x2, mplapackint const incx2, dd_real *q1, mplapackint const ldq1, dd_real *q2, mplapackint const ldq2, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, dd_real *x11, mplapackint const ldx11, dd_real *x12, mplapackint const ldx12, dd_real *x21, mplapackint const ldx21, dd_real *x22, mplapackint const ldx22, dd_real *theta, dd_real *u1, mplapackint const ldu1, dd_real *u2, mplapackint const ldu2, dd_real *v1t, mplapackint const ldv1t, dd_real *v2t, mplapackint const ldv2t, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rorcsd2by1(const char *jobu1, const char *jobu2, const char *jobv1t, mplapackint const m, mplapackint const p, mplapackint const q, dd_real *x11, mplapackint const ldx11, dd_real *x21, mplapackint const ldx21, dd_real *theta, dd_real *u1, mplapackint const ldu1, dd_real *u2, mplapackint const ldu2, dd_real *v1t, mplapackint const ldv1t, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rorg2l(mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint &info);
void Rorg2r(mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint &info);
void Rorgbr(const char *vect, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorghr(mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorgl2(mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint &info);
void Rorglq(mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorgql(mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorgqr(mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorgr2(mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint &info);
void Rorgrq(mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorgtr(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorgtsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const ldt, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorgtsqr_row(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const ldt, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorhr_col(mplapackint const m, mplapackint const n, mplapackint const nb, dd_real *a, mplapackint const lda, dd_real *t, mplapackint const ldt, dd_real *d, mplapackint &info);
void Rorm22(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const n1, mplapackint const n2, dd_real *q, mplapackint const ldq, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorm2l(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint &info);
void Rorm2r(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint &info);
void Rormbr(const char *vect, const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rormhr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const ilo, mplapackint const ihi, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rorml2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint &info);
void Rormlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rormql(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rormqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rormr2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint &info);
void Rormr3(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint &info);
void Rormrq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rormrz(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rormtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *c, mplapackint const ldc, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rpbcon(const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, dd_real const anorm, dd_real &rcond, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rpbequ(const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, dd_real *s, dd_real &scond, dd_real &amax, mplapackint &info);
void Rpbrfs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, dd_real *ab, mplapackint const ldab, dd_real *afb, mplapackint const ldafb, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rpbstf(const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, mplapackint &info);
void Rpbsv(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, dd_real *ab, mplapackint const ldab, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rpbsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, dd_real *ab, mplapackint const ldab, dd_real *afb, mplapackint const ldafb, char *equed, dd_real *s, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rpbtf2(const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, mplapackint &info);
void Rpbtrf(const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, mplapackint &info);
void Rpbtrs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, dd_real *ab, mplapackint const ldab, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rpftrf(const char *transr, const char *uplo, mplapackint const n, dd_real *a, mplapackint &info);
void Rpftri(const char *transr, const char *uplo, mplapackint const n, dd_real *a, mplapackint &info);
void Rpftrs(const char *transr, const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rpocon(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real const anorm, dd_real &rcond, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rpoequ(mplapackint const n, dd_real *a, mplapackint const lda, dd_real *s, dd_real &scond, dd_real &amax, mplapackint &info);
void Rpoequb(mplapackint const n, dd_real *a, mplapackint const lda, dd_real *s, dd_real &scond, dd_real &amax, mplapackint &info);
void Rporfs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *af, mplapackint const ldaf, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rposv(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rposvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *af, mplapackint const ldaf, char *equed, dd_real *s, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rpotf2(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint &info);
void Rpotrf(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint &info);
void Rpotrf2(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint &info);
void Rpotri(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint &info);
void Rpotrs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rppcon(const char *uplo, mplapackint const n, dd_real *ap, dd_real const anorm, dd_real &rcond, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rppequ(const char *uplo, mplapackint const n, dd_real *ap, dd_real *s, dd_real &scond, dd_real &amax, mplapackint &info);
void Rpprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *ap, dd_real *afp, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rppsv(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *ap, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rppsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *ap, dd_real *afp, char *equed, dd_real *s, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rpptrf(const char *uplo, mplapackint const n, dd_real *ap, mplapackint &info);
void Rpptri(const char *uplo, mplapackint const n, dd_real *ap, mplapackint &info);
void Rpptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *ap, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rpstf2(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, dd_real const tol, dd_real *work, mplapackint &info);
void Rpstrf(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, dd_real const tol, dd_real *work, mplapackint &info);
void Rptcon(mplapackint const n, dd_real *d, dd_real *e, dd_real const anorm, dd_real &rcond, dd_real *work, mplapackint &info);
void Rpteqr(const char *compz, mplapackint const n, dd_real *d, dd_real *e, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint &info);
void Rptrfs(mplapackint const n, mplapackint const nrhs, dd_real *d, dd_real *e, dd_real *df, dd_real *ef, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint &info);
void Rptsv(mplapackint const n, mplapackint const nrhs, dd_real *d, dd_real *e, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rptsvx(const char *fact, mplapackint const n, mplapackint const nrhs, dd_real *d, dd_real *e, dd_real *df, dd_real *ef, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint &info);
void Rpttrf(mplapackint const n, dd_real *d, dd_real *e, mplapackint &info);
void Rpttrs(mplapackint const n, mplapackint const nrhs, dd_real *d, dd_real *e, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rptts2(mplapackint const n, mplapackint const nrhs, dd_real *d, dd_real *e, dd_real *b, mplapackint const ldb);
void Rrscl(mplapackint const n, dd_real const sa, dd_real *sx, mplapackint const incx);
void Rsb2st_kernels(const char *uplo, bool const wantz, mplapackint const ttype, mplapackint const st, mplapackint const ed, mplapackint const sweep, mplapackint const n, mplapackint const nb, mplapackint const ib, dd_real *a, mplapackint const lda, dd_real *v, dd_real *tau, mplapackint const ldvt, dd_real *work);
void Rsbev(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint &info);
void Rsbev_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsbevd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, dd_real *q, mplapackint const ldq, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, dd_real *q, mplapackint const ldq, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbgst(const char *vect, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, dd_real *ab, mplapackint const ldab, dd_real *bb, mplapackint const ldbb, dd_real *x, mplapackint const ldx, dd_real *work, mplapackint &info);
void Rsbgv(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, dd_real *ab, mplapackint const ldab, dd_real *bb, mplapackint const ldbb, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint &info);
void Rsbgvd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, dd_real *ab, mplapackint const ldab, dd_real *bb, mplapackint const ldbb, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbgvx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, dd_real *ab, mplapackint const ldab, dd_real *bb, mplapackint const ldbb, dd_real *q, mplapackint const ldq, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbtrd(const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, dd_real *d, dd_real *e, dd_real *q, mplapackint const ldq, dd_real *work, mplapackint &info);
void Rsfrk(const char *transr, const char *uplo, const char *trans, mplapackint const n, mplapackint const k, dd_real const alpha, dd_real *a, mplapackint const lda, dd_real const beta, dd_real *c);
void Rspcon(const char *uplo, mplapackint const n, dd_real *ap, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rspev(const char *jobz, const char *uplo, mplapackint const n, dd_real *ap, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint &info);
void Rspevd(const char *jobz, const char *uplo, mplapackint const n, dd_real *ap, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rspevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_real *ap, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rspgst(mplapackint const itype, const char *uplo, mplapackint const n, dd_real *ap, dd_real *bp, mplapackint &info);
void Rspgv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, dd_real *ap, dd_real *bp, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint &info);
void Rspgvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, dd_real *ap, dd_real *bp, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rspgvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_real *ap, dd_real *bp, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *ap, dd_real *afp, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rspsv(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *ap, mplapackint *ipiv, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rspsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *ap, dd_real *afp, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rsptrd(const char *uplo, mplapackint const n, dd_real *ap, dd_real *d, dd_real *e, dd_real *tau, mplapackint &info);
void Rsptrf(const char *uplo, mplapackint const n, dd_real *ap, mplapackint *ipiv, mplapackint &info);
void Rsptri(const char *uplo, mplapackint const n, dd_real *ap, mplapackint *ipiv, dd_real *work, mplapackint &info);
void Rsptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *ap, mplapackint *ipiv, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rstebz(const char *range, const char *order, mplapackint const n, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, dd_real *d, dd_real *e, mplapackint &m, mplapackint &nsplit, dd_real *w, mplapackint *iblock, mplapackint *isplit, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rstedc(const char *compz, mplapackint const n, dd_real *d, dd_real *e, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstein(mplapackint const n, dd_real *d, dd_real *e, mplapackint const m, dd_real *w, mplapackint *iblock, mplapackint *isplit, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rstemr(const char *jobz, const char *range, mplapackint const n, dd_real *d, dd_real *e, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, mplapackint &m, dd_real *w, dd_real *z, mplapackint const ldz, mplapackint const nzc, mplapackint *isuppz, bool &tryrac, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsteqr(const char *compz, mplapackint const n, dd_real *d, dd_real *e, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint &info);
void Rsterf(mplapackint const n, dd_real *d, dd_real *e, mplapackint &info);
void Rstev(const char *jobz, mplapackint const n, dd_real *d, dd_real *e, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint &info);
void Rstevd(const char *jobz, mplapackint const n, dd_real *d, dd_real *e, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstevr(const char *jobz, const char *range, mplapackint const n, dd_real *d, dd_real *e, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_real *z, mplapackint const ldz, mplapackint *isuppz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstevx(const char *jobz, const char *range, mplapackint const n, dd_real *d, dd_real *e, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsycon(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rsycon_3(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *e, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rsycon_rook(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real const anorm, dd_real &rcond, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rsyconv(const char *uplo, const char *way, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *e, mplapackint &info);
void Rsyconvf(const char *uplo, const char *way, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *e, mplapackint *ipiv, mplapackint &info);
void Rsyconvf_rook(const char *uplo, const char *way, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *e, mplapackint *ipiv, mplapackint &info);
void Rsyequb(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *s, dd_real &scond, dd_real &amax, dd_real *work, mplapackint &info);
void Rsyev(const char *jobz, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *w, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsyev_2stage(const char *jobz, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *w, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsyevd(const char *jobz, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *w, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevd_2stage(const char *jobz, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *w, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevr(const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_real *z, mplapackint const ldz, mplapackint *isuppz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevr_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_real *z, mplapackint const ldz, mplapackint *isuppz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsyevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsygs2(mplapackint const itype, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rsygst(mplapackint const itype, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rsygv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *w, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsygv_2stage(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *w, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsygvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *w, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsygvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real const vl, dd_real const vu, mplapackint const il, mplapackint const iu, dd_real const abstol, mplapackint &m, dd_real *w, dd_real *z, mplapackint const ldz, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsyrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *af, mplapackint const ldaf, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rsysv(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsysv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsysv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, dd_real *b, mplapackint const ldb, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsysv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *e, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsysv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsysvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *af, mplapackint const ldaf, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real &rcond, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rsyswapr(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Rsytd2(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *d, dd_real *e, dd_real *tau, mplapackint &info);
void Rsytf2(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rsytf2_rk(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *e, mplapackint *ipiv, mplapackint &info);
void Rsytf2_rook(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rsytrd(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *d, dd_real *e, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_2stage(const char *vect, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *d, dd_real *e, dd_real *tau, dd_real *hous2, mplapackint const lhous2, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_sb2st(const char *stage1, const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, dd_real *d, dd_real *e, dd_real *hous, mplapackint const lhous, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_sy2sb(const char *uplo, mplapackint const n, mplapackint const kd, dd_real *a, mplapackint const lda, dd_real *ab, mplapackint const ldab, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsytrf(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_aa(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_aa_2stage(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_rk(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *e, mplapackint *ipiv, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_rook(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsytri(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *work, mplapackint &info);
void Rsytri2(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsytri2x(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *work, mplapackint const nb, mplapackint &info);
void Rsytri_3(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *e, mplapackint *ipiv, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsytri_3x(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *e, mplapackint *ipiv, dd_real *work, mplapackint const nb, mplapackint &info);
void Rsytri_rook(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *work, mplapackint &info);
void Rsytrs(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rsytrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *work, mplapackint &info);
void Rsytrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *e, mplapackint *ipiv, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rsytrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *b, mplapackint const ldb, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rsytrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rsytrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, mplapackint *ipiv, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rtbcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, dd_real *ab, mplapackint const ldab, dd_real &rcond, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rtbrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, dd_real *ab, mplapackint const ldab, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rtbtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, dd_real *ab, mplapackint const ldab, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rtfsm(const char *transr, const char *side, const char *uplo, const char *trans, const char *diag, mplapackint const m, mplapackint const n, dd_real const alpha, dd_real *a, dd_real *b, mplapackint const ldb);
void Rtftri(const char *transr, const char *uplo, const char *diag, mplapackint const n, dd_real *a, mplapackint &info);
void Rtfttp(const char *transr, const char *uplo, mplapackint const n, dd_real *arf, dd_real *ap, mplapackint &info);
void Rtfttr(const char *transr, const char *uplo, mplapackint const n, dd_real *arf, dd_real *a, mplapackint const lda, mplapackint &info);
void Rtgevc(const char *side, const char *howmny, bool *select, mplapackint const n, dd_real *s, mplapackint const lds, dd_real *p, mplapackint const ldp, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, dd_real *work, mplapackint &info);
void Rtgex2(bool const wantq, bool const wantz, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *q, mplapackint const ldq, dd_real *z, mplapackint const ldz, mplapackint const j1, mplapackint const n1, mplapackint const n2, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rtgexc(bool const wantq, bool const wantz, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *q, mplapackint const ldq, dd_real *z, mplapackint const ldz, mplapackint &ifst, mplapackint &ilst, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rtgsen(mplapackint const ijob, bool const wantq, bool const wantz, bool *select, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *alphar, dd_real *alphai, dd_real *beta, dd_real *q, mplapackint const ldq, dd_real *z, mplapackint const ldz, mplapackint &m, dd_real &pl, dd_real &pr, dd_real *dif, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rtgsja(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mplapackint const k, mplapackint const l, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real const tola, dd_real const tolb, dd_real *alpha, dd_real *beta, dd_real *u, mplapackint const ldu, dd_real *v, mplapackint const ldv, dd_real *q, mplapackint const ldq, dd_real *work, mplapackint &ncycle, mplapackint &info);
void Rtgsna(const char *job, const char *howmny, bool *select, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, dd_real *s, dd_real *dif, mplapackint const mm, mplapackint &m, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rtgsy2(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *c, mplapackint const ldc, dd_real *d, mplapackint const ldd, dd_real *e, mplapackint const lde, dd_real *f, mplapackint const ldf, dd_real &scale, dd_real &rdsum, dd_real &rdscal, mplapackint *iwork, mplapackint &pq, mplapackint &info);
void Rtgsyl(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *c, mplapackint const ldc, dd_real *d, mplapackint const ldd, dd_real *e, mplapackint const lde, dd_real *f, mplapackint const ldf, dd_real &scale, dd_real &dif, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rtpcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, dd_real *ap, dd_real &rcond, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rtplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *t, mplapackint const ldt, dd_real *work, mplapackint &info);
void Rtplqt2(mplapackint const m, mplapackint const n, mplapackint const l, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *t, mplapackint const ldt, mplapackint &info);
void Rtpmlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const mb, dd_real *v, mplapackint const ldv, dd_real *t, mplapackint const ldt, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *work, mplapackint &info);
void Rtpmqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const nb, dd_real *v, mplapackint const ldv, dd_real *t, mplapackint const ldt, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *work, mplapackint &info);
void Rtpqrt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *t, mplapackint const ldt, dd_real *work, mplapackint &info);
void Rtpqrt2(mplapackint const m, mplapackint const n, mplapackint const l, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *t, mplapackint const ldt, mplapackint &info);
void Rtprfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, dd_real *v, mplapackint const ldv, dd_real *t, mplapackint const ldt, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *work, mplapackint const ldwork);
void Rtprfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, dd_real *ap, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rtptri(const char *uplo, const char *diag, mplapackint const n, dd_real *ap, mplapackint &info);
void Rtptrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, dd_real *ap, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rtpttf(const char *transr, const char *uplo, mplapackint const n, dd_real *ap, dd_real *arf, mplapackint &info);
void Rtpttr(const char *uplo, mplapackint const n, dd_real *ap, dd_real *a, mplapackint const lda, mplapackint &info);
void Rtrcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, dd_real *a, mplapackint const lda, dd_real &rcond, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rtrevc(const char *side, const char *howmny, bool *select, mplapackint const n, dd_real *t, mplapackint const ldt, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, dd_real *work, mplapackint &info);
void Rtrevc3(const char *side, const char *howmny, bool *select, mplapackint const n, dd_real *t, mplapackint const ldt, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, dd_real *work, mplapackint const lwork, mplapackint &info);
void Rtrexc(const char *compq, mplapackint const n, dd_real *t, mplapackint const ldt, dd_real *q, mplapackint const ldq, mplapackint &ifst, mplapackint &ilst, dd_real *work, mplapackint &info);
void Rtrrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *x, mplapackint const ldx, dd_real *ferr, dd_real *berr, dd_real *work, mplapackint *iwork, mplapackint &info);
void Rtrsen(const char *job, const char *compq, bool *select, mplapackint const n, dd_real *t, mplapackint const ldt, dd_real *q, mplapackint const ldq, dd_real *wr, dd_real *wi, mplapackint &m, dd_real &s, dd_real &sep, dd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rtrsna(const char *job, const char *howmny, bool *select, mplapackint const n, dd_real *t, mplapackint const ldt, dd_real *vl, mplapackint const ldvl, dd_real *vr, mplapackint const ldvr, dd_real *s, dd_real *sep, mplapackint const mm, mplapackint &m, dd_real *work, mplapackint const ldwork, mplapackint *iwork, mplapackint &info);
void Rtrsyl(const char *trana, const char *tranb, mplapackint const isgn, mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, dd_real *c, mplapackint const ldc, dd_real &scale, mplapackint &info);
void Rtrti2(const char *uplo, const char *diag, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint &info);
void Rtrtri(const char *uplo, const char *diag, mplapackint const n, dd_real *a, mplapackint const lda, mplapackint &info);
void Rtrtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, dd_real *a, mplapackint const lda, dd_real *b, mplapackint const ldb, mplapackint &info);
void Rtrttf(const char *transr, const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *arf, mplapackint &info);
void Rtrttp(const char *uplo, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *ap, mplapackint &info);
void Rtzrzf(mplapackint const m, mplapackint const n, dd_real *a, mplapackint const lda, dd_real *tau, dd_real *work, mplapackint const lwork, mplapackint &info);
void iMlaver_dd(mplapackint &mplapack_ver_major, mplapackint &mplapack_ver_minor, mplapackint &mplapack_ver_patch, mplapackint &lapack_ver_major, mplapackint &lapack_ver_minor, mplapackint &lapack_ver_patch);
#endif
