/*
 * Copyright (c) 2012-2021
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mplapack_double.h,v 1.4 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK__FLOAT128_H_
#define _MPLAPACK__FLOAT128_H_

#include "mplapack_config.h"

#if defined ___MPLAPACK_WANT_LIBQUADMATH___
#include "quadmath.h"
#endif

_Float128 Clangb(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *work);
_Float128 Clange(const char *norm, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *work);
_Float128 Clangt(const char *norm, mplapackint const n, std::complex<_Float128> *dl, std::complex<_Float128> *d, std::complex<_Float128> *du);
_Float128 Clanhb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *work);
_Float128 Clanhe(const char *norm, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *work);
_Float128 Clanhf(const char *norm, const char *transr, const char *uplo, mplapackint const n, std::complex<_Float128> *a, _Float128 *work);
_Float128 Clanhp(const char *norm, const char *uplo, mplapackint const n, std::complex<_Float128> *ap, _Float128 *work);
_Float128 Clanhs(const char *norm, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *work);
_Float128 Clanht(const char *norm, mplapackint const n, _Float128 *d, std::complex<_Float128> *e);
_Float128 Clansb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *work);
_Float128 Clansp(const char *norm, const char *uplo, mplapackint const n, std::complex<_Float128> *ap, _Float128 *work);
_Float128 Clansy(const char *norm, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *work);
_Float128 Clantb(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const k, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *work);
_Float128 Clantp(const char *norm, const char *uplo, const char *diag, mplapackint const n, std::complex<_Float128> *ap, _Float128 *work);
_Float128 Clantr(const char *norm, const char *uplo, const char *diag, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *work);
_Float128 Mmaxval(_Float128 *dx, mplapackint const start, mplapackint const end, mplapackint incx);
_Float128 RCsum1(mplapackint const n, std::complex<_Float128> *cx, mplapackint const incx);
_Float128 Rla_gbrcond(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float128 *ab, mplapackint const ldab, _Float128 *afb, mplapackint const ldafb, mplapackint *ipiv, mplapackint const cmode, _Float128 *c, mplapackint &info, _Float128 *work, mplapackint *iwork);
_Float128 Rla_gbrpvgrw(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const ncols, _Float128 *ab, mplapackint const ldab, _Float128 *afb, mplapackint const ldafb);
_Float128 Rla_gercond(const char *trans, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *af, mplapackint const ldaf, mplapackint *ipiv, mplapackint const cmode, _Float128 *c, mplapackint &info, _Float128 *work, mplapackint *iwork);
_Float128 Rla_gerpvgrw(mplapackint const n, mplapackint const ncols, _Float128 *a, mplapackint const lda, _Float128 *af, mplapackint const ldaf);
_Float128 Rla_porcond(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *af, mplapackint const ldaf, mplapackint const cmode, _Float128 *c, mplapackint &info, _Float128 *work, mplapackint *iwork);
_Float128 Rla_syrcond(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *af, mplapackint const ldaf, mplapackint *ipiv, mplapackint const cmode, _Float128 *c, mplapackint &info, _Float128 *work, mplapackint *iwork);
_Float128 Rla_syrpvgrw(const char *uplo, mplapackint const n, mplapackint const info, _Float128 *a, mplapackint const lda, _Float128 *af, mplapackint const ldaf, mplapackint *ipiv, _Float128 *work);
_Float128 Rladiv2(_Float128 const &a, _Float128 const &b, _Float128 const &c, _Float128 const &d, _Float128 const &r, _Float128 const &t);
_Float128 Rlamc3(_Float128 a, _Float128 b);
_Float128 Rlamch__Float128(const char *cmach);
_Float128 Rlangb(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float128 *ab, mplapackint const ldab, _Float128 *work);
_Float128 Rlange(const char *norm, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *work);
_Float128 Rlangt(const char *norm, mplapackint const n, _Float128 *dl, _Float128 *d, _Float128 *du);
_Float128 Rlanhs(const char *norm, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *work);
_Float128 Rlansb(const char *norm, const char *uplo, mplapackint const n, mplapackint const k, _Float128 *ab, mplapackint const ldab, _Float128 *work);
_Float128 Rlansf(const char *norm, const char *transr, const char *uplo, mplapackint const n, _Float128 *a, _Float128 *work);
_Float128 Rlansp(const char *norm, const char *uplo, mplapackint const n, _Float128 *ap, _Float128 *work);
_Float128 Rlanst(const char *norm, mplapackint const n, _Float128 *d, _Float128 *e);
_Float128 Rlansy(const char *norm, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *work);
_Float128 Rlantb(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const k, _Float128 *ab, mplapackint const ldab, _Float128 *work);
_Float128 Rlantp(const char *norm, const char *uplo, const char *diag, mplapackint const n, _Float128 *ap, _Float128 *work);
_Float128 Rlantr(const char *norm, const char *uplo, const char *diag, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *work);
_Float128 Rlapy2(_Float128 const x, _Float128 const y);
_Float128 Rlapy3(_Float128 const x, _Float128 const y, _Float128 const z);
bool Mlsamen__Float128(mplapackint n, const char *a, const char *b);
bool Risnan(_Float128 const din);
bool Rlaisnan(_Float128 const din1, _Float128 const din2);
mplapackint Mmaxloc(_Float128 *dx, mplapackint const start, mplapackint const end, mplapackint const incx);
mplapackint Rlaneg(mplapackint const n, _Float128 *d, _Float128 *lld, _Float128 const sigma, _Float128 const, mplapackint const r);
mplapackint iCmax1(mplapackint const n, std::complex<_Float128> *zx, mplapackint const incx);
mplapackint iMieeeck__Float128(mplapackint const &ispec, _Float128 const &zero, _Float128 const &one);
mplapackint iMladiag(const char *diag);
mplapackint iMladlc(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda);
mplapackint iMladlr(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda);
mplapackint iMlaenv2stage__Float128(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv__Float128(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaprec(const char *prec);
mplapackint iMlatrans(const char *trans);
mplapackint iMlauplo(const char *uplo);
mplapackint iMlazlc(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda);
mplapackint iMlazlr(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda);
mplapackint iMparam2stage__Float128(mplapackint const ispec, const char *name, const char *opts, mplapackint const ni, mplapackint const nbi, mplapackint const ibi, mplapackint const nxi);
mplapackint iMparmq__Float128(mplapackint const ispec, const char *name, const char *opts, mplapackint const n, mplapackint const ilo, mplapackint const ihi, mplapackint const lwork);
std::complex<_Float128> Cladiv(std::complex<_Float128> const x, std::complex<_Float128> const y);
void CRrscl(mplapackint const n, _Float128 const sa, std::complex<_Float128> *sx, mplapackint const incx);
void Cbbcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, mplapackint const m, mplapackint const p, mplapackint const q, _Float128 *theta, _Float128 *phi, std::complex<_Float128> *u1, mplapackint const ldu1, std::complex<_Float128> *u2, mplapackint const ldu2, std::complex<_Float128> *v1t, mplapackint const ldv1t, std::complex<_Float128> *v2t, mplapackint const ldv2t, _Float128 *b11d, _Float128 *b11e, _Float128 *b12d, _Float128 *b12e, _Float128 *b21d, _Float128 *b21e, _Float128 *b22d, _Float128 *b22e, _Float128 *rwork, mplapackint const lrwork, mplapackint &info);
void Cbdsqr(const char *uplo, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, _Float128 *d, _Float128 *e, std::complex<_Float128> *vt, mplapackint const ldvt, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *c, mplapackint const ldc, _Float128 *rwork, mplapackint &info);
void Cgbbrd(const char *vect, mplapackint const m, mplapackint const n, mplapackint const ncc, mplapackint const kl, mplapackint const ku, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *d, _Float128 *e, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *pt, mplapackint const ldpt, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cgbcon(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float128> *ab, mplapackint const ldab, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cgbequ(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *r, _Float128 *c, _Float128 &rowcnd, _Float128 &colcnd, _Float128 &amax, mplapackint &info);
void Cgbequb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *r, _Float128 *c, _Float128 &rowcnd, _Float128 &colcnd, _Float128 &amax, mplapackint &info);
void Cgbrfs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *afb, mplapackint const ldafb, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cgbsv(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<_Float128> *ab, mplapackint const ldab, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cgbsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *afb, mplapackint const ldafb, mplapackint *ipiv, char *equed, _Float128 *r, _Float128 *c, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cgbtf2(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float128> *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Cgbtrf(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float128> *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Cgbtrs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<_Float128> *ab, mplapackint const ldab, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cgebak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *scale, mplapackint const m, std::complex<_Float128> *v, mplapackint const ldv, mplapackint &info);
void Cgebal(const char *job, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint &ilo, mplapackint &ihi, _Float128 *scale, mplapackint &info);
void Cgebd2(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *d, _Float128 *e, std::complex<_Float128> *tauq, std::complex<_Float128> *taup, std::complex<_Float128> *work, mplapackint &info);
void Cgebrd(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *d, _Float128 *e, std::complex<_Float128> *tauq, std::complex<_Float128> *taup, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgecon(const char *norm, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cgeequ(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *r, _Float128 *c, _Float128 &rowcnd, _Float128 &colcnd, _Float128 &amax, mplapackint &info);
void Cgeequb(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *r, _Float128 *c, _Float128 &rowcnd, _Float128 &colcnd, _Float128 &amax, mplapackint &info);
void Cgees(const char *jobvs, const char *sort, bool (*select)(std::complex<_Float128>), mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint &sdim, std::complex<_Float128> *w, std::complex<_Float128> *vs, mplapackint const ldvs, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, bool *bwork, mplapackint &info);
void Cgeesx(const char *jobvs, const char *sort, bool (*select)(std::complex<_Float128>), const char *sense, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint &sdim, std::complex<_Float128> *w, std::complex<_Float128> *vs, mplapackint const ldvs, _Float128 &rconde, _Float128 &rcondv, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, bool *bwork, mplapackint &info);
void Cgeev(const char *jobvl, const char *jobvr, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *w, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Cgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *w, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, _Float128 *scale, _Float128 &abnrm, _Float128 *rconde, _Float128 *rcondv, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Cgehd2(mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint &info);
void Cgehrd(mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgejsv(const char *joba, const char *jobu, const char *jobv, const char *jobr, const char *jobt, const char *jobp, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *sva, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *cwork, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cgelq(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const tsize, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgelq2(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint &info);
void Cgelqf(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgelqt(mplapackint const m, mplapackint const n, mplapackint const mb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *work, mplapackint &info);
void Cgelqt3(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const ldt, mplapackint &info);
void Cgels(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgelsd(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, _Float128 *s, _Float128 const rcond, mplapackint &rank, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint *iwork, mplapackint &info);
void Cgelss(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, _Float128 *s, _Float128 const rcond, mplapackint &rank, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Cgelsy(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, mplapackint *jpvt, _Float128 const rcond, mplapackint &rank, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Cgemlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const tsize, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgemlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint &info);
void Cgemqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const tsize, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgemqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const nb, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint &info);
void Cgeql2(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint &info);
void Cgeqlf(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgeqp3(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *jpvt, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Cgeqr(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const tsize, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgeqr2(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint &info);
void Cgeqr2p(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint &info);
void Cgeqrf(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgeqrfp(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgeqrt(mplapackint const m, mplapackint const n, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *work, mplapackint &info);
void Cgeqrt2(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const ldt, mplapackint &info);
void Cgeqrt3(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const ldt, mplapackint &info);
void Cgerfs(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cgerq2(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint &info);
void Cgerqf(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgesc2(mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *rhs, mplapackint *ipiv, mplapackint *jpiv, _Float128 &scale);
void Cgesdd(const char *jobz, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *s, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *vt, mplapackint const ldvt, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint *iwork, mplapackint &info);
void Cgesv(mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cgesvd(const char *jobu, const char *jobvt, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *s, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *vt, mplapackint const ldvt, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Cgesvdq(const char *joba, const char *jobp, const char *jobr, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *s, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, mplapackint const ldv, mplapackint &numrank, mplapackint *iwork, mplapackint const liwork, std::complex<_Float128> *cwork, mplapackint const lcwork, _Float128 *rwork, mplapackint const lrwork, mplapackint &info);
void Cgesvdx(const char *jobu, const char *jobvt, const char *range, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, _Float128 *s, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *vt, mplapackint const ldvt, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint *iwork, mplapackint &info);
void Cgesvj(const char *joba, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *sva, mplapackint const mv, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *cwork, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint &info);
void Cgesvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *af, mplapackint const ldaf, mplapackint *ipiv, char *equed, _Float128 *r, _Float128 *c, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cgetc2(mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, mplapackint *jpiv, mplapackint &info);
void Cgetf2(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetrf(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetrf2(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Cgetri(mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgetrs(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cgetsls(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgetsqrhrt(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cggbak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *lscale, _Float128 *rscale, mplapackint const m, std::complex<_Float128> *v, mplapackint const ldv, mplapackint &info);
void Cggbal(const char *job, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &ilo, mplapackint &ihi, _Float128 *lscale, _Float128 *rscale, _Float128 *work, mplapackint &info);
void Cgges(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(std::complex<_Float128>, std::complex<_Float128>), mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &sdim, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *vsl, mplapackint const ldvsl, std::complex<_Float128> *vsr, mplapackint const ldvsr, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, bool *bwork, mplapackint &info);
void Cgges3(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(std::complex<_Float128>, std::complex<_Float128>), mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &sdim, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *vsl, mplapackint const ldvsl, std::complex<_Float128> *vsr, mplapackint const ldvsr, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, bool *bwork, mplapackint &info);
void Cggesx(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(std::complex<_Float128>, std::complex<_Float128>), const char *sense, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &sdim, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *vsl, mplapackint const ldvsl, std::complex<_Float128> *vsr, mplapackint const ldvsr, _Float128 *rconde, _Float128 *rcondv, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Cggev(const char *jobvl, const char *jobvr, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Cggev3(const char *jobvl, const char *jobvr, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Cggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, mplapackint &ilo, mplapackint &ihi, _Float128 *lscale, _Float128 *rscale, _Float128 &abnrm, _Float128 &bbnrm, _Float128 *rconde, _Float128 *rcondv, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Cggglm(mplapackint const n, mplapackint const m, mplapackint const p, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *d, std::complex<_Float128> *x, std::complex<_Float128> *y, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgghd3(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgghrd(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *z, mplapackint const ldz, mplapackint &info);
void Cgglse(mplapackint const m, mplapackint const n, mplapackint const p, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *c, std::complex<_Float128> *d, std::complex<_Float128> *x, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cggqrf(mplapackint const n, mplapackint const m, mplapackint const p, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *taua, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *taub, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cggrqf(mplapackint const m, mplapackint const p, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *taua, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *taub, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cggsvd3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const n, mplapackint const p, mplapackint &k, mplapackint &l, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, _Float128 *alpha, _Float128 *beta, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint *iwork, mplapackint &info);
void Cggsvp3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, _Float128 const tola, _Float128 const tolb, mplapackint &k, mplapackint &l, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *q, mplapackint const ldq, mplapackint *iwork, _Float128 *rwork, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgsvj0(const char *jobv, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *d, _Float128 *sva, mplapackint const mv, std::complex<_Float128> *v, mplapackint const ldv, _Float128 const eps, _Float128 const sfmin, _Float128 const tol, mplapackint const nsweep, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgsvj1(const char *jobv, mplapackint const m, mplapackint const n, mplapackint const n1, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *d, _Float128 *sva, mplapackint const mv, std::complex<_Float128> *v, mplapackint const ldv, _Float128 const eps, _Float128 const sfmin, _Float128 const tol, mplapackint const nsweep, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cgtcon(const char *norm, mplapackint const n, std::complex<_Float128> *dl, std::complex<_Float128> *d, std::complex<_Float128> *du, std::complex<_Float128> *du2, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, mplapackint &info);
void Cgtrfs(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *dl, std::complex<_Float128> *d, std::complex<_Float128> *du, std::complex<_Float128> *dlf, std::complex<_Float128> *df, std::complex<_Float128> *duf, std::complex<_Float128> *du2, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cgtsv(mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *dl, std::complex<_Float128> *d, std::complex<_Float128> *du, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cgtsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *dl, std::complex<_Float128> *d, std::complex<_Float128> *du, std::complex<_Float128> *dlf, std::complex<_Float128> *df, std::complex<_Float128> *duf, std::complex<_Float128> *du2, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cgttrf(mplapackint const n, std::complex<_Float128> *dl, std::complex<_Float128> *d, std::complex<_Float128> *du, std::complex<_Float128> *du2, mplapackint *ipiv, mplapackint &info);
void Cgttrs(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *dl, std::complex<_Float128> *d, std::complex<_Float128> *du, std::complex<_Float128> *du2, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cgtts2(mplapackint const itrans, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *dl, std::complex<_Float128> *d, std::complex<_Float128> *du, std::complex<_Float128> *du2, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb);
void Chb2st_kernels(const char *uplo, bool const wantz, mplapackint const ttype, mplapackint const st, mplapackint const ed, mplapackint const sweep, mplapackint const n, mplapackint const nb, mplapackint const ib, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *v, std::complex<_Float128> *tau, mplapackint const ldvt, std::complex<_Float128> *work);
void Chbev(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Chbev_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Chbevd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *q, mplapackint const ldq, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, _Float128 *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *q, mplapackint const ldq, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbgst(const char *vect, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *bb, mplapackint const ldbb, std::complex<_Float128> *x, mplapackint const ldx, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Chbgv(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *bb, mplapackint const ldbb, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Chbgvd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *bb, mplapackint const ldbb, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chbgvx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *bb, mplapackint const ldbb, std::complex<_Float128> *q, mplapackint const ldq, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, _Float128 *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chbtrd(const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *d, _Float128 *e, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *work, mplapackint &info);
void Checon(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, mplapackint &info);
void Checon_3(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, mplapackint &info);
void Checon_rook(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, mplapackint &info);
void Cheequb(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *s, _Float128 &scond, _Float128 &amax, std::complex<_Float128> *work, mplapackint &info);
void Cheev(const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *w, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Cheev_2stage(const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *w, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Cheevd(const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *w, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevd_2stage(const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *w, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevr(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, mplapackint *isuppz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevr_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, mplapackint *isuppz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cheevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cheevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chegs2(mplapackint const itype, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Chegst(mplapackint const itype, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Chegv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, _Float128 *w, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Chegv_2stage(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, _Float128 *w, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Chegvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, _Float128 *w, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chegvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cherfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Chesv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chesv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chesv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chesv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chesv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chesvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Cheswapr(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Chetd2(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *d, _Float128 *e, std::complex<_Float128> *tau, mplapackint &info);
void Chetf2(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Chetf2_rk(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, mplapackint &info);
void Chetf2_rook(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Chetrd(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *d, _Float128 *e, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chetrd_2stage(const char *vect, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *d, _Float128 *e, std::complex<_Float128> *tau, std::complex<_Float128> *hous2, mplapackint const lhous2, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chetrd_hb2st(const char *stage1, const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *d, _Float128 *e, std::complex<_Float128> *hous, mplapackint const lhous, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chetrd_he2hb(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chetrf(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chetrf_aa(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chetrf_aa_2stage(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chetrf_rk(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chetrf_rook(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chetri(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint &info);
void Chetri2(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chetri2x(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const nb, mplapackint &info);
void Chetri_3(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chetri_3x(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const nb, mplapackint &info);
void Chetri_rook(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint &info);
void Chetrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Chetrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint &info);
void Chetrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Chetrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Chetrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Chetrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Chfrk(const char *transr, const char *uplo, const char *trans, mplapackint const n, mplapackint const k, _Float128 const alpha, std::complex<_Float128> *a, mplapackint const lda, _Float128 const beta, std::complex<_Float128> *c);
void Chgeqz(const char *job, const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float128> *h, mplapackint const ldh, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Chpcon(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, mplapackint &info);
void Chpev(const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float128> *ap, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Chpevd(const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float128> *ap, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chpevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float128> *ap, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, _Float128 *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chpgst(mplapackint const itype, const char *uplo, mplapackint const n, std::complex<_Float128> *ap, std::complex<_Float128> *bp, mplapackint &info);
void Chpgv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float128> *ap, std::complex<_Float128> *bp, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Chpgvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, std::complex<_Float128> *ap, std::complex<_Float128> *bp, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Chpgvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, std::complex<_Float128> *ap, std::complex<_Float128> *bp, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, _Float128 *rwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Chprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, std::complex<_Float128> *afp, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Chpsv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Chpsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, std::complex<_Float128> *afp, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Chptrd(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, _Float128 *d, _Float128 *e, std::complex<_Float128> *tau, mplapackint &info);
void Chptrf(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, mplapackint *ipiv, mplapackint &info);
void Chptri(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint &info);
void Chptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Chsein(const char *side, const char *eigsrc, const char *initv, bool *select, mplapackint const n, std::complex<_Float128> *h, mplapackint const ldh, std::complex<_Float128> *w, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, std::complex<_Float128> *work, _Float128 *rwork, mplapackint *ifaill, mplapackint *ifailr, mplapackint &info);
void Chseqr(const char *job, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float128> *h, mplapackint const ldh, std::complex<_Float128> *w, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Clabrd(mplapackint const m, mplapackint const n, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, _Float128 *d, _Float128 *e, std::complex<_Float128> *tauq, std::complex<_Float128> *taup, std::complex<_Float128> *x, mplapackint const ldx, std::complex<_Float128> *y, mplapackint const ldy);
void Clacgv(mplapackint const n, std::complex<_Float128> *x, mplapackint const incx);
void Clacn2(mplapackint const n, std::complex<_Float128> *v, std::complex<_Float128> *x, _Float128 &est, mplapackint &kase, mplapackint *isave);
void Clacon(mplapackint const n, std::complex<_Float128> *v, std::complex<_Float128> *x, _Float128 &est, mplapackint &kase);
void Clacp2(const char *uplo, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb);
void Clacpy(const char *uplo, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb);
void Clacrm(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, std::complex<_Float128> *c, mplapackint const ldc, _Float128 *rwork);
void Clacrt(mplapackint const n, std::complex<_Float128> *cx, mplapackint const incx, std::complex<_Float128> *cy, mplapackint const incy, std::complex<_Float128> const c, std::complex<_Float128> const s);
void Claed0(mplapackint const qsiz, mplapackint const n, _Float128 *d, _Float128 *e, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *qstore, mplapackint const ldqs, _Float128 *rwork, mplapackint *iwork, mplapackint &info);
void Claed7(mplapackint const n, mplapackint const cutpnt, mplapackint const qsiz, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, _Float128 *d, std::complex<_Float128> *q, mplapackint const ldq, _Float128 rho, mplapackint *indxq, _Float128 *qstore, mplapackint *qptr, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, _Float128 *givnum, std::complex<_Float128> *work, _Float128 *rwork, mplapackint *iwork, mplapackint &info);
void Claed8(mplapackint &k, mplapackint const n, mplapackint const qsiz, std::complex<_Float128> *q, mplapackint const ldq, _Float128 *d, _Float128 &rho, mplapackint const cutpnt, _Float128 *z, _Float128 *dlamda, std::complex<_Float128> *q2, mplapackint const ldq2, _Float128 *w, mplapackint *indxp, mplapackint *indx, mplapackint *indxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, _Float128 *givnum, mplapackint &info);
void Claein(bool const rightv, bool const noinit, mplapackint const n, std::complex<_Float128> *h, mplapackint const ldh, std::complex<_Float128> const w, std::complex<_Float128> *v, std::complex<_Float128> *b, mplapackint const ldb, _Float128 *rwork, _Float128 const eps3, _Float128 const smlnum, mplapackint &info);
void Claesy(std::complex<_Float128> const a, std::complex<_Float128> const b, std::complex<_Float128> const c, std::complex<_Float128> &rt1, std::complex<_Float128> &rt2, std::complex<_Float128> &evscal, std::complex<_Float128> &cs1, std::complex<_Float128> &sn1);
void Claev2(std::complex<_Float128> const a, std::complex<_Float128> const b, std::complex<_Float128> const c, _Float128 &rt1, _Float128 &rt2, _Float128 &cs1, std::complex<_Float128> &sn1);
void Clags2(bool const upper, _Float128 const a1, std::complex<_Float128> const a2, _Float128 const a3, _Float128 const b1, std::complex<_Float128> const b2, _Float128 const b3, _Float128 &csu, std::complex<_Float128> &snu, _Float128 &csv, std::complex<_Float128> &snv, _Float128 &csq, std::complex<_Float128> &snq);
void Clagtm(const char *trans, mplapackint const n, mplapackint const nrhs, _Float128 const alpha, std::complex<_Float128> *dl, std::complex<_Float128> *d, std::complex<_Float128> *du, std::complex<_Float128> *x, mplapackint const ldx, _Float128 const beta, std::complex<_Float128> *b, mplapackint const ldb);
void Clahef(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *w, mplapackint const ldw, mplapackint &info);
void Clahef_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *h, mplapackint const ldh, std::complex<_Float128> *work);
void Clahef_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, std::complex<_Float128> *w, mplapackint const ldw, mplapackint &info);
void Clahef_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *w, mplapackint const ldw, mplapackint &info);
void Clahqr(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float128> *h, mplapackint const ldh, std::complex<_Float128> *w, mplapackint const iloz, mplapackint const ihiz, std::complex<_Float128> *z, mplapackint const ldz, mplapackint &info);
void Clahr2(mplapackint const n, mplapackint const k, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *y, mplapackint const ldy);
void Claic1(mplapackint const job, mplapackint const j, std::complex<_Float128> *x, _Float128 const sest, std::complex<_Float128> *w, std::complex<_Float128> const gamma, _Float128 &sestpr, std::complex<_Float128> &s, std::complex<_Float128> &c);
void Clals0(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const nrhs, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *bx, mplapackint const ldbx, mplapackint *perm, mplapackint const givptr, mplapackint *givcol, mplapackint const ldgcol, _Float128 *givnum, mplapackint const ldgnum, _Float128 *poles, _Float128 *difl, _Float128 *difr, _Float128 *z, mplapackint const k, _Float128 const c, _Float128 const s, _Float128 *rwork, mplapackint &info);
void Clalsa(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *bx, mplapackint const ldbx, _Float128 *u, mplapackint const ldu, _Float128 *vt, mplapackint *k, _Float128 *difl, _Float128 *difr, _Float128 *z, _Float128 *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, _Float128 *givnum, _Float128 *c, _Float128 *s, _Float128 *rwork, mplapackint *iwork, mplapackint &info);
void Clalsd(const char *uplo, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, _Float128 *d, _Float128 *e, std::complex<_Float128> *b, mplapackint const ldb, _Float128 const rcond, mplapackint &rank, std::complex<_Float128> *work, _Float128 *rwork, mplapackint *iwork, mplapackint &info);
void Clamswlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Clamtsqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Clapll(mplapackint const n, std::complex<_Float128> *x, mplapackint const incx, std::complex<_Float128> *y, mplapackint const incy, _Float128 &ssmin);
void Clapmr(bool const forwrd, mplapackint const m, mplapackint const n, std::complex<_Float128> *x, mplapackint const ldx, mplapackint *k);
void Clapmt(bool const forwrd, mplapackint const m, mplapackint const n, std::complex<_Float128> *x, mplapackint const ldx, mplapackint *k);
void Claqgb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *r, _Float128 *c, _Float128 const rowcnd, _Float128 const colcnd, _Float128 const amax, char *equed);
void Claqge(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *r, _Float128 *c, _Float128 const rowcnd, _Float128 const colcnd, _Float128 const amax, char *equed);
void Claqhb(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *s, _Float128 const scond, _Float128 const amax, char *equed);
void Claqhe(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *s, _Float128 const scond, _Float128 const amax, char *equed);
void Claqhp(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, _Float128 *s, _Float128 const scond, _Float128 const amax, char *equed);
void Claqp2(mplapackint const m, mplapackint const n, mplapackint const offset, std::complex<_Float128> *a, mplapackint const lda, mplapackint *jpvt, std::complex<_Float128> *tau, _Float128 *vn1, _Float128 *vn2, std::complex<_Float128> *work);
void Claqps(mplapackint const m, mplapackint const n, mplapackint const offset, mplapackint const nb, mplapackint &kb, std::complex<_Float128> *a, mplapackint const lda, mplapackint *jpvt, std::complex<_Float128> *tau, _Float128 *vn1, _Float128 *vn2, std::complex<_Float128> *auxv, std::complex<_Float128> *f, mplapackint const ldf);
void Claqr0(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float128> *h, mplapackint const ldh, std::complex<_Float128> *w, mplapackint const iloz, mplapackint const ihiz, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Claqr1(mplapackint const n, std::complex<_Float128> *h, mplapackint const ldh, std::complex<_Float128> const s1, std::complex<_Float128> const s2, std::complex<_Float128> *v);
void Claqr2(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, std::complex<_Float128> *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, std::complex<_Float128> *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, std::complex<_Float128> *sh, std::complex<_Float128> *v, mplapackint const ldv, mplapackint const nh, std::complex<_Float128> *t, mplapackint const ldt, mplapackint const nv, std::complex<_Float128> *wv, mplapackint const ldwv, std::complex<_Float128> *work, mplapackint const lwork);
void Claqr3(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, std::complex<_Float128> *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, std::complex<_Float128> *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, std::complex<_Float128> *sh, std::complex<_Float128> *v, mplapackint const ldv, mplapackint const nh, std::complex<_Float128> *t, mplapackint const ldt, mplapackint const nv, std::complex<_Float128> *wv, mplapackint const ldwv, std::complex<_Float128> *work, mplapackint const lwork);
void Claqr4(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float128> *h, mplapackint const ldh, std::complex<_Float128> *w, mplapackint const iloz, mplapackint const ihiz, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Claqr5(bool const wantt, bool const wantz, mplapackint const kacc22, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nshfts, std::complex<_Float128> *s, std::complex<_Float128> *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *u, mplapackint const ldu, mplapackint const nv, std::complex<_Float128> *wv, mplapackint const ldwv, mplapackint const nh, std::complex<_Float128> *wh, mplapackint const ldwh);
void Claqsb(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *s, _Float128 const scond, _Float128 const amax, char *equed);
void Claqsp(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, _Float128 *s, _Float128 const scond, _Float128 const amax, char *equed);
void Claqsy(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *s, _Float128 const scond, _Float128 const amax, char *equed);
void Clar1v(mplapackint const n, mplapackint const b1, mplapackint const bn, _Float128 const lambda, _Float128 *d, _Float128 *l, _Float128 *ld, _Float128 *lld, _Float128 const pivmin, _Float128 const gaptol, std::complex<_Float128> *z, bool const wantnc, mplapackint &negcnt, _Float128 &ztz, _Float128 &mingma, mplapackint &r, mplapackint *isuppz, _Float128 &nrminv, _Float128 &resid, _Float128 &rqcorr, _Float128 *work);
void Clar2v(mplapackint const n, std::complex<_Float128> *x, std::complex<_Float128> *y, std::complex<_Float128> *z, mplapackint const incx, _Float128 *c, std::complex<_Float128> *s, mplapackint const incc);
void Clarcm(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *c, mplapackint const ldc, _Float128 *rwork);
void Clarf(const char *side, mplapackint const m, mplapackint const n, std::complex<_Float128> *v, mplapackint const incv, std::complex<_Float128> const tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work);
void Clarfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const ldwork);
void Clarfb_gett(const char *ident, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const ldwork);
void Clarfg(mplapackint const n, std::complex<_Float128> &alpha, std::complex<_Float128> *x, mplapackint const incx, std::complex<_Float128> &tau);
void Clarfgp(mplapackint const n, std::complex<_Float128> &alpha, std::complex<_Float128> *x, mplapackint const incx, std::complex<_Float128> &tau);
void Clarft(const char *direct, const char *storev, mplapackint const n, mplapackint const k, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *tau, std::complex<_Float128> *t, mplapackint const ldt);
void Clarfx(const char *side, mplapackint const m, mplapackint const n, std::complex<_Float128> *v, std::complex<_Float128> const tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work);
void Clarfy(const char *uplo, mplapackint const n, std::complex<_Float128> *v, mplapackint const incv, std::complex<_Float128> const tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work);
void Clargv(mplapackint const n, std::complex<_Float128> *x, mplapackint const incx, std::complex<_Float128> *y, mplapackint const incy, _Float128 *c, mplapackint const incc);
void Clarnv(mplapackint const idist, mplapackint *iseed, mplapackint const n, std::complex<_Float128> *x);
void Clarrv(mplapackint const n, _Float128 const vl, _Float128 const, _Float128 *d, _Float128 *l, _Float128 const pivmin, mplapackint *isplit, mplapackint const m, mplapackint const dol, mplapackint const dou, _Float128 const minrgp, _Float128 &rtol1, _Float128 &rtol2, _Float128 *w, _Float128 *werr, _Float128 *wgap, mplapackint *iblock, mplapackint *indexw, _Float128 *gers, std::complex<_Float128> *z, mplapackint const ldz, mplapackint *isuppz, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Clarscl2(mplapackint const m, mplapackint const n, _Float128 *d, std::complex<_Float128> *x, mplapackint const ldx);
void Clartg(std::complex<_Float128> const f, std::complex<_Float128> const g, _Float128 &cs, std::complex<_Float128> &sn, std::complex<_Float128> &r);
void Clartv(mplapackint const n, std::complex<_Float128> *x, mplapackint const incx, std::complex<_Float128> *y, mplapackint const incy, _Float128 *c, std::complex<_Float128> *s, mplapackint const incc);
void Clarz(const char *side, mplapackint const m, mplapackint const n, mplapackint const l, std::complex<_Float128> *v, mplapackint const incv, std::complex<_Float128> const tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work);
void Clarzb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const ldwork);
void Clarzt(const char *direct, const char *storev, mplapackint const n, mplapackint const k, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *tau, std::complex<_Float128> *t, mplapackint const ldt);
void Clascl(const char *type, mplapackint const kl, mplapackint const ku, _Float128 const cfrom, _Float128 const cto, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint &info);
void Clascl2(mplapackint const m, mplapackint const n, _Float128 *d, std::complex<_Float128> *x, mplapackint const ldx);
void Claset(const char *uplo, mplapackint const m, mplapackint const n, std::complex<_Float128> const alpha, std::complex<_Float128> const beta, std::complex<_Float128> *a, mplapackint const lda);
void Clasr(const char *side, const char *pivot, const char *direct, mplapackint const m, mplapackint const n, _Float128 *c, _Float128 *s, std::complex<_Float128> *a, mplapackint const lda);
void Classq(mplapackint const n, std::complex<_Float128> *x, mplapackint const incx, _Float128 &scale, _Float128 &sumsq);
void Claswlq(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Claswp(mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint const k1, mplapackint const k2, mplapackint *ipiv, mplapackint const incx);
void Clasyf(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *w, mplapackint const ldw, mplapackint &info);
void Clasyf_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *h, mplapackint const ldh, std::complex<_Float128> *work);
void Clasyf_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, std::complex<_Float128> *w, mplapackint const ldw, mplapackint &info);
void Clasyf_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *w, mplapackint const ldw, mplapackint &info);
void Clatbs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *x, _Float128 &scale, _Float128 *cnorm, mplapackint &info);
void Clatdf(mplapackint const ijob, mplapackint const n, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *rhs, _Float128 &rdsum, _Float128 &rdscal, mplapackint *ipiv, mplapackint *jpiv);
void Clatps(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, std::complex<_Float128> *ap, std::complex<_Float128> *x, _Float128 &scale, _Float128 *cnorm, mplapackint &info);
void Clatrd(const char *uplo, mplapackint const n, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, _Float128 *e, std::complex<_Float128> *tau, std::complex<_Float128> *w, mplapackint const ldw);
void Clatrs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *x, _Float128 &scale, _Float128 *cnorm, mplapackint &info);
void Clatrz(mplapackint const m, mplapackint const n, mplapackint const l, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work);
void Clatsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Claunhr_col_getrfnp(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *d, mplapackint &info);
void Claunhr_col_getrfnp2(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *d, mplapackint &info);
void Clauu2(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint &info);
void Clauum(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint &info);
void Cpbcon(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cpbequ(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 *s, _Float128 &scond, _Float128 &amax, mplapackint &info);
void Cpbrfs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *afb, mplapackint const ldafb, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cpbstf(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, mplapackint &info);
void Cpbsv(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cpbsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *afb, mplapackint const ldafb, char *equed, _Float128 *s, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cpbtf2(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, mplapackint &info);
void Cpbtrf(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, mplapackint &info);
void Cpbtrs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cpftrf(const char *transr, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint &info);
void Cpftri(const char *transr, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint &info);
void Cpftrs(const char *transr, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cpocon(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cpoequ(mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *s, _Float128 &scond, _Float128 &amax, mplapackint &info);
void Cpoequb(mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *s, _Float128 &scond, _Float128 &amax, mplapackint &info);
void Cporfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *af, mplapackint const ldaf, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cposv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cposvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *af, mplapackint const ldaf, char *equed, _Float128 *s, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cpotf2(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint &info);
void Cpotrf(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint &info);
void Cpotrf2(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint &info);
void Cpotri(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint &info);
void Cpotrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cppcon(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cppequ(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, _Float128 *s, _Float128 &scond, _Float128 &amax, mplapackint &info);
void Cpprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, std::complex<_Float128> *afp, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cppsv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cppsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, std::complex<_Float128> *afp, char *equed, _Float128 *s, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cpptrf(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, mplapackint &info);
void Cpptri(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, mplapackint &info);
void Cpptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cpstf2(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, _Float128 const tol, _Float128 *work, mplapackint &info);
void Cpstrf(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, _Float128 const tol, _Float128 *work, mplapackint &info);
void Cptcon(mplapackint const n, _Float128 *d, std::complex<_Float128> *e, _Float128 const anorm, _Float128 &rcond, _Float128 *rwork, mplapackint &info);
void Cpteqr(const char *compz, mplapackint const n, _Float128 *d, _Float128 *e, std::complex<_Float128> *z, mplapackint const ldz, _Float128 *work, mplapackint &info);
void Cptrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *d, std::complex<_Float128> *e, _Float128 *df, std::complex<_Float128> *ef, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cptsv(mplapackint const n, mplapackint const nrhs, _Float128 *d, std::complex<_Float128> *e, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cptsvx(const char *fact, mplapackint const n, mplapackint const nrhs, _Float128 *d, std::complex<_Float128> *e, _Float128 *df, std::complex<_Float128> *ef, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cpttrf(mplapackint const n, _Float128 *d, std::complex<_Float128> *e, mplapackint &info);
void Cpttrs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *d, std::complex<_Float128> *e, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cptts2(mplapackint const iuplo, mplapackint const n, mplapackint const nrhs, _Float128 *d, std::complex<_Float128> *e, std::complex<_Float128> *b, mplapackint const ldb);
void Crot(mplapackint const n, std::complex<_Float128> *cx, mplapackint const incx, std::complex<_Float128> *cy, mplapackint const incy, _Float128 const c, std::complex<_Float128> const s);
void Cspcon(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, mplapackint &info);
void Cspmv(const char *uplo, mplapackint const n, std::complex<_Float128> const alpha, std::complex<_Float128> *ap, std::complex<_Float128> *x, mplapackint const incx, std::complex<_Float128> const beta, std::complex<_Float128> *y, mplapackint const incy);
void Cspr(const char *uplo, mplapackint const n, std::complex<_Float128> const alpha, std::complex<_Float128> *x, mplapackint const incx, std::complex<_Float128> *ap);
void Csprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, std::complex<_Float128> *afp, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Cspsv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cspsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, std::complex<_Float128> *afp, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Csptrf(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, mplapackint *ipiv, mplapackint &info);
void Csptri(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint &info);
void Csptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Cstedc(const char *compz, mplapackint const n, _Float128 *d, _Float128 *e, std::complex<_Float128> *z, mplapackint const ldz, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Cstein(mplapackint const n, _Float128 *d, _Float128 *e, mplapackint const m, _Float128 *w, mplapackint *iblock, mplapackint *isplit, std::complex<_Float128> *z, mplapackint const ldz, _Float128 *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Cstemr(const char *jobz, const char *range, mplapackint const n, _Float128 *d, _Float128 *e, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, mplapackint &m, _Float128 *w, std::complex<_Float128> *z, mplapackint const ldz, mplapackint const nzc, mplapackint *isuppz, bool &tryrac, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Csteqr(const char *compz, mplapackint const n, _Float128 *d, _Float128 *e, std::complex<_Float128> *z, mplapackint const ldz, _Float128 *work, mplapackint &info);
void Csycon(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, mplapackint &info);
void Csycon_3(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, mplapackint &info);
void Csycon_rook(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, std::complex<_Float128> *work, mplapackint &info);
void Csyconv(const char *uplo, const char *way, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *e, mplapackint &info);
void Csyconvf(const char *uplo, const char *way, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, mplapackint &info);
void Csyconvf_rook(const char *uplo, const char *way, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, mplapackint &info);
void Csyequb(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 *s, _Float128 &scond, _Float128 &amax, std::complex<_Float128> *work, mplapackint &info);
void Csymv(const char *uplo, mplapackint const n, std::complex<_Float128> const alpha, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *x, mplapackint const incx, std::complex<_Float128> const beta, std::complex<_Float128> *y, mplapackint const incy);
void Csyr(const char *uplo, mplapackint const n, std::complex<_Float128> const alpha, std::complex<_Float128> *x, mplapackint const incx, std::complex<_Float128> *a, mplapackint const lda);
void Csyrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Csysv(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Csysv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Csysv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Csysv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Csysv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Csysvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *af, mplapackint const ldaf, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint &info);
void Csyswapr(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Csytf2(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Csytf2_rk(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, mplapackint &info);
void Csytf2_rook(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Csytrf(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Csytrf_aa(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Csytrf_aa_2stage(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Csytrf_rk(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Csytrf_rook(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Csytri(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint &info);
void Csytri2(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Csytri2x(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const nb, mplapackint &info);
void Csytri_3(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Csytri_3x(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint const nb, mplapackint &info);
void Csytri_rook(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *work, mplapackint &info);
void Csytrs(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Csytrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint &info);
void Csytrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *e, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Csytrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Csytrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Csytrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Ctbcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, std::complex<_Float128> *ab, mplapackint const ldab, _Float128 &rcond, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Ctbrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Ctbtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float128> *ab, mplapackint const ldab, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Ctfsm(const char *transr, const char *side, const char *uplo, const char *trans, const char *diag, mplapackint const m, mplapackint const n, std::complex<_Float128> const alpha, std::complex<_Float128> *a, std::complex<_Float128> *b, mplapackint const ldb);
void Ctftri(const char *transr, const char *uplo, const char *diag, mplapackint const n, std::complex<_Float128> *a, mplapackint &info);
void Ctfttp(const char *transr, const char *uplo, mplapackint const n, std::complex<_Float128> *arf, std::complex<_Float128> *ap, mplapackint &info);
void Ctfttr(const char *transr, const char *uplo, mplapackint const n, std::complex<_Float128> *arf, std::complex<_Float128> *a, mplapackint const lda, mplapackint &info);
void Ctgevc(const char *side, const char *howmny, bool *select, mplapackint const n, std::complex<_Float128> *s, mplapackint const lds, std::complex<_Float128> *p, mplapackint const ldp, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Ctgex2(bool const wantq, bool const wantz, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *z, mplapackint const ldz, mplapackint const j1, mplapackint &info);
void Ctgexc(bool const wantq, bool const wantz, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *z, mplapackint const ldz, mplapackint const ifst, mplapackint &ilst, mplapackint &info);
void Ctgsen(mplapackint const ijob, bool const wantq, bool const wantz, bool *select, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *alpha, std::complex<_Float128> *beta, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *z, mplapackint const ldz, mplapackint &m, _Float128 &pl, _Float128 &pr, _Float128 *dif, std::complex<_Float128> *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Ctgsja(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, _Float128 const tola, _Float128 const tolb, _Float128 *alpha, _Float128 *beta, std::complex<_Float128> *u, mplapackint const ldu, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *work, mplapackint &ncycle, mplapackint &info);
void Ctgsna(const char *job, const char *howmny, bool *select, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, _Float128 *s, _Float128 *dif, mplapackint const mm, mplapackint &m, std::complex<_Float128> *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Ctgsy2(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *d, mplapackint const ldd, std::complex<_Float128> *e, mplapackint const lde, std::complex<_Float128> *f, mplapackint const ldf, _Float128 &scale, _Float128 &rdsum, _Float128 &rdscal, mplapackint &info);
void Ctgsyl(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *d, mplapackint const ldd, std::complex<_Float128> *e, mplapackint const lde, std::complex<_Float128> *f, mplapackint const ldf, _Float128 &scale, _Float128 &dif, std::complex<_Float128> *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Ctpcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, std::complex<_Float128> *ap, _Float128 &rcond, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Ctplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *work, mplapackint &info);
void Ctplqt2(mplapackint const m, mplapackint const n, mplapackint const l, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *t, mplapackint const ldt, mplapackint &info);
void Ctpmlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const mb, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint &info);
void Ctpmqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const nb, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint &info);
void Ctpqrt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *work, mplapackint &info);
void Ctpqrt2(mplapackint const m, mplapackint const n, mplapackint const l, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *t, mplapackint const ldt, mplapackint &info);
void Ctprfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<_Float128> *v, mplapackint const ldv, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *work, mplapackint const ldwork);
void Ctprfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Ctptri(const char *uplo, const char *diag, mplapackint const n, std::complex<_Float128> *ap, mplapackint &info);
void Ctptrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *ap, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Ctpttf(const char *transr, const char *uplo, mplapackint const n, std::complex<_Float128> *ap, std::complex<_Float128> *arf, mplapackint &info);
void Ctpttr(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, std::complex<_Float128> *a, mplapackint const lda, mplapackint &info);
void Ctrcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, _Float128 &rcond, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Ctrevc(const char *side, const char *howmny, bool *select, mplapackint const n, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Ctrevc3(const char *side, const char *howmny, bool *select, mplapackint const n, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint &info);
void Ctrexc(const char *compq, mplapackint const n, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *q, mplapackint const ldq, mplapackint const ifst, mplapackint const ilst, mplapackint &info);
void Ctrrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, std::complex<_Float128> *work, _Float128 *rwork, mplapackint &info);
void Ctrsen(const char *job, const char *compq, bool *select, mplapackint const n, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *w, mplapackint &m, _Float128 &s, _Float128 &sep, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Ctrsna(const char *job, const char *howmny, bool *select, mplapackint const n, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *vl, mplapackint const ldvl, std::complex<_Float128> *vr, mplapackint const ldvr, _Float128 *s, _Float128 *sep, mplapackint const mm, mplapackint &m, std::complex<_Float128> *work, mplapackint const ldwork, _Float128 *rwork, mplapackint &info);
void Ctrsyl(const char *trana, const char *tranb, mplapackint const isgn, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, std::complex<_Float128> *c, mplapackint const ldc, _Float128 &scale, mplapackint &info);
void Ctrti2(const char *uplo, const char *diag, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint &info);
void Ctrtri(const char *uplo, const char *diag, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, mplapackint &info);
void Ctrtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *b, mplapackint const ldb, mplapackint &info);
void Ctrttf(const char *transr, const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *arf, mplapackint &info);
void Ctrttp(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *ap, mplapackint &info);
void Ctzrzf(mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb(const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float128> *x11, mplapackint const ldx11, std::complex<_Float128> *x12, mplapackint const ldx12, std::complex<_Float128> *x21, mplapackint const ldx21, std::complex<_Float128> *x22, mplapackint const ldx22, _Float128 *theta, _Float128 *phi, std::complex<_Float128> *taup1, std::complex<_Float128> *taup2, std::complex<_Float128> *tauq1, std::complex<_Float128> *tauq2, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb1(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float128> *x11, mplapackint const ldx11, std::complex<_Float128> *x21, mplapackint const ldx21, _Float128 *theta, _Float128 *phi, std::complex<_Float128> *taup1, std::complex<_Float128> *taup2, std::complex<_Float128> *tauq1, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb2(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float128> *x11, mplapackint const ldx11, std::complex<_Float128> *x21, mplapackint const ldx21, _Float128 *theta, _Float128 *phi, std::complex<_Float128> *taup1, std::complex<_Float128> *taup2, std::complex<_Float128> *tauq1, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb3(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float128> *x11, mplapackint const ldx11, std::complex<_Float128> *x21, mplapackint const ldx21, _Float128 *theta, _Float128 *phi, std::complex<_Float128> *taup1, std::complex<_Float128> *taup2, std::complex<_Float128> *tauq1, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb4(mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float128> *x11, mplapackint const ldx11, std::complex<_Float128> *x21, mplapackint const ldx21, _Float128 *theta, _Float128 *phi, std::complex<_Float128> *taup1, std::complex<_Float128> *taup2, std::complex<_Float128> *tauq1, std::complex<_Float128> *phantom, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb5(mplapackint const m1, mplapackint const m2, mplapackint const n, std::complex<_Float128> *x1, mplapackint const incx1, std::complex<_Float128> *x2, mplapackint const incx2, std::complex<_Float128> *q1, mplapackint const ldq1, std::complex<_Float128> *q2, mplapackint const ldq2, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunbdb6(mplapackint const m1, mplapackint const m2, mplapackint const n, std::complex<_Float128> *x1, mplapackint const incx1, std::complex<_Float128> *x2, mplapackint const incx2, std::complex<_Float128> *q1, mplapackint const ldq1, std::complex<_Float128> *q2, mplapackint const ldq2, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cuncsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float128> *x11, mplapackint const ldx11, std::complex<_Float128> *x12, mplapackint const ldx12, std::complex<_Float128> *x21, mplapackint const ldx21, std::complex<_Float128> *x22, mplapackint const ldx22, _Float128 *theta, std::complex<_Float128> *u1, mplapackint const ldu1, std::complex<_Float128> *u2, mplapackint const ldu2, std::complex<_Float128> *v1t, mplapackint const ldv1t, std::complex<_Float128> *v2t, mplapackint const ldv2t, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cuncsd2by1(const char *jobu1, const char *jobu2, const char *jobv1t, mplapackint const m, mplapackint const p, mplapackint const q, std::complex<_Float128> *x11, mplapackint const ldx11, std::complex<_Float128> *x21, mplapackint const ldx21, _Float128 *theta, std::complex<_Float128> *u1, mplapackint const ldu1, std::complex<_Float128> *u2, mplapackint const ldu2, std::complex<_Float128> *v1t, mplapackint const ldv1t, std::complex<_Float128> *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint &info);
void Cung2l(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint &info);
void Cung2r(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint &info);
void Cungbr(const char *vect, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunghr(mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cungl2(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint &info);
void Cunglq(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cungql(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cungqr(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cungr2(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint &info);
void Cungrq(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cungtr(const char *uplo, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cungtsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cungtsqr_row(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunhr_col(mplapackint const m, mplapackint const n, mplapackint const nb, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *t, mplapackint const ldt, std::complex<_Float128> *d, mplapackint &info);
void Cunm22(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const n1, mplapackint const n2, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunm2l(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint &info);
void Cunm2r(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint &info);
void Cunmbr(const char *vect, const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunmhr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const ilo, mplapackint const ihi, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunml2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint &info);
void Cunmlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunmql(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunmqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunmr2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint &info);
void Cunmr3(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint &info);
void Cunmrq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunmrz(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cunmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, std::complex<_Float128> *a, mplapackint const lda, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint const lwork, mplapackint &info);
void Cupgtr(const char *uplo, mplapackint const n, std::complex<_Float128> *ap, std::complex<_Float128> *tau, std::complex<_Float128> *q, mplapackint const ldq, std::complex<_Float128> *work, mplapackint &info);
void Cupmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, std::complex<_Float128> *ap, std::complex<_Float128> *tau, std::complex<_Float128> *c, mplapackint const ldc, std::complex<_Float128> *work, mplapackint &info);
void Rbbcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, mplapackint const m, mplapackint const p, mplapackint const q, _Float128 *theta, _Float128 *phi, _Float128 *u1, mplapackint const ldu1, _Float128 *u2, mplapackint const ldu2, _Float128 *v1t, mplapackint const ldv1t, _Float128 *v2t, mplapackint const ldv2t, _Float128 *b11d, _Float128 *b11e, _Float128 *b12d, _Float128 *b12e, _Float128 *b21d, _Float128 *b21e, _Float128 *b22d, _Float128 *b22e, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rbdsdc(const char *uplo, const char *compq, mplapackint const n, _Float128 *d, _Float128 *e, _Float128 *u, mplapackint const ldu, _Float128 *vt, mplapackint const ldvt, _Float128 *q, mplapackint *iq, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rbdsqr(const char *uplo, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, _Float128 *d, _Float128 *e, _Float128 *vt, mplapackint const ldvt, _Float128 *u, mplapackint const ldu, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint &info);
void Rbdsvdx(const char *uplo, const char *jobz, const char *range, mplapackint const n, _Float128 *d, _Float128 *e, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, _Float128 *s, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rcombssq(_Float128 *v1, _Float128 *v2);
void Rdisna(const char *job, mplapackint const m, mplapackint const n, _Float128 *d, _Float128 *sep, mplapackint &info);
void Rgbbrd(const char *vect, mplapackint const m, mplapackint const n, mplapackint const ncc, mplapackint const kl, mplapackint const ku, _Float128 *ab, mplapackint const ldab, _Float128 *d, _Float128 *e, _Float128 *q, mplapackint const ldq, _Float128 *pt, mplapackint const ldpt, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint &info);
void Rgbcon(const char *norm, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float128 *ab, mplapackint const ldab, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rgbequ(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float128 *ab, mplapackint const ldab, _Float128 *r, _Float128 *c, _Float128 &rowcnd, _Float128 &colcnd, _Float128 &amax, mplapackint &info);
void Rgbequb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float128 *ab, mplapackint const ldab, _Float128 *r, _Float128 *c, _Float128 &rowcnd, _Float128 &colcnd, _Float128 &amax, mplapackint &info);
void Rgbrfs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, _Float128 *ab, mplapackint const ldab, _Float128 *afb, mplapackint const ldafb, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rgbsv(mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, _Float128 *ab, mplapackint const ldab, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rgbsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, _Float128 *ab, mplapackint const ldab, _Float128 *afb, mplapackint const ldafb, mplapackint *ipiv, char *equed, _Float128 *r, _Float128 *c, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rgbtf2(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float128 *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Rgbtrf(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float128 *ab, mplapackint const ldab, mplapackint *ipiv, mplapackint &info);
void Rgbtrs(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, _Float128 *ab, mplapackint const ldab, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rgebak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *scale, mplapackint const m, _Float128 *v, mplapackint const ldv, mplapackint &info);
void Rgebal(const char *job, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint &ilo, mplapackint &ihi, _Float128 *scale, mplapackint &info);
void Rgebd2(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *d, _Float128 *e, _Float128 *tauq, _Float128 *taup, _Float128 *work, mplapackint &info);
void Rgebrd(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *d, _Float128 *e, _Float128 *tauq, _Float128 *taup, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgecon(const char *norm, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 const anorm, _Float128 &rcond, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rgeequ(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *r, _Float128 *c, _Float128 &rowcnd, _Float128 &colcnd, _Float128 &amax, mplapackint &info);
void Rgeequb(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *r, _Float128 *c, _Float128 &rowcnd, _Float128 &colcnd, _Float128 &amax, mplapackint &info);
void Rgees(const char *jobvs, const char *sort, bool (*select)(_Float128, _Float128), mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint &sdim, _Float128 *wr, _Float128 *wi, _Float128 *vs, mplapackint const ldvs, _Float128 *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rgeesx(const char *jobvs, const char *sort, bool (*select)(_Float128, _Float128), const char *sense, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint &sdim, _Float128 *wr, _Float128 *wi, _Float128 *vs, mplapackint const ldvs, _Float128 &rconde, _Float128 &rcondv, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rgeev(const char *jobvl, const char *jobvr, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *wr, _Float128 *wi, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *wr, _Float128 *wi, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, _Float128 *scale, _Float128 &abnrm, _Float128 *rconde, _Float128 *rcondv, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgehd2(mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint &info);
void Rgehrd(mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgejsv(const char *joba, const char *jobu, const char *jobv, const char *jobr, const char *jobt, const char *jobp, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *sva, _Float128 *u, mplapackint const ldu, _Float128 *v, mplapackint const ldv, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgelq(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const tsize, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgelq2(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint &info);
void Rgelqf(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgelqt(mplapackint const m, mplapackint const n, mplapackint const mb, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const ldt, _Float128 *work, mplapackint &info);
void Rgelqt3(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const ldt, mplapackint &info);
void Rgels(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgelsd(mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *s, _Float128 const rcond, mplapackint &rank, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgelss(mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *s, _Float128 const rcond, mplapackint &rank, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgelsy(mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, mplapackint *jpvt, _Float128 const rcond, mplapackint &rank, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgemlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const tsize, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgemlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, _Float128 *v, mplapackint const ldv, _Float128 *t, mplapackint const ldt, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint &info);
void Rgemqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const tsize, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgemqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const nb, _Float128 *v, mplapackint const ldv, _Float128 *t, mplapackint const ldt, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint &info);
void Rgeql2(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint &info);
void Rgeqlf(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgeqp3(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *jpvt, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgeqr(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const tsize, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgeqr2(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint &info);
void Rgeqr2p(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint &info);
void Rgeqrf(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgeqrfp(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgeqrt(mplapackint const m, mplapackint const n, mplapackint const nb, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const ldt, _Float128 *work, mplapackint &info);
void Rgeqrt2(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const ldt, mplapackint &info);
void Rgeqrt3(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const ldt, mplapackint &info);
void Rgerfs(const char *trans, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *af, mplapackint const ldaf, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rgerq2(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint &info);
void Rgerqf(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgesc2(mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *rhs, mplapackint *ipiv, mplapackint *jpiv, _Float128 &scale);
void Rgesdd(const char *jobz, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *s, _Float128 *u, mplapackint const ldu, _Float128 *vt, mplapackint const ldvt, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgesv(mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rgesvd(const char *jobu, const char *jobvt, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *s, _Float128 *u, mplapackint const ldu, _Float128 *vt, mplapackint const ldvt, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgesvdq(const char *joba, const char *jobp, const char *jobr, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *s, _Float128 *u, mplapackint const ldu, _Float128 *v, mplapackint const ldv, mplapackint &numrank, mplapackint *iwork, mplapackint const liwork, _Float128 *work, mplapackint const lwork, _Float128 *rwork, mplapackint const lrwork, mplapackint &info);
void Rgesvdx(const char *jobu, const char *jobvt, const char *range, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, mplapackint &ns, _Float128 *s, _Float128 *u, mplapackint const ldu, _Float128 *vt, mplapackint const ldvt, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rgesvj(const char *joba, const char *jobu, const char *jobv, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *sva, mplapackint const mv, _Float128 *v, mplapackint const ldv, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgesvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *af, mplapackint const ldaf, mplapackint *ipiv, char *equed, _Float128 *r, _Float128 *c, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rgetc2(mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, mplapackint *jpiv, mplapackint &info);
void Rgetf2(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetrf(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetrf2(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rgetri(mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgetrs(const char *trans, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rgetsls(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgetsqrhrt(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const ldt, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rggbak(const char *job, const char *side, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *lscale, _Float128 *rscale, mplapackint const m, _Float128 *v, mplapackint const ldv, mplapackint &info);
void Rggbal(const char *job, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, mplapackint &ilo, mplapackint &ihi, _Float128 *lscale, _Float128 *rscale, _Float128 *work, mplapackint &info);
void Rgges(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(_Float128, _Float128, _Float128), mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, mplapackint &sdim, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *vsl, mplapackint const ldvsl, _Float128 *vsr, mplapackint const ldvsr, _Float128 *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rgges3(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(_Float128, _Float128, _Float128), mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, mplapackint &sdim, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *vsl, mplapackint const ldvsl, _Float128 *vsr, mplapackint const ldvsr, _Float128 *work, mplapackint const lwork, bool *bwork, mplapackint &info);
void Rggesx(const char *jobvsl, const char *jobvsr, const char *sort, bool (*selctg)(_Float128, _Float128, _Float128), const char *sense, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, mplapackint &sdim, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *vsl, mplapackint const ldvsl, _Float128 *vsr, mplapackint const ldvsr, _Float128 *rconde, _Float128 *rcondv, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rggev(const char *jobvl, const char *jobvr, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rggev3(const char *jobvl, const char *jobvr, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, mplapackint ilo, mplapackint ihi, _Float128 *lscale, _Float128 *rscale, _Float128 &abnrm, _Float128 &bbnrm, _Float128 *rconde, _Float128 *rcondv, _Float128 *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rggglm(mplapackint const n, mplapackint const m, mplapackint const p, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *d, _Float128 *x, _Float128 *y, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgghd3(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *q, mplapackint const ldq, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgghrd(const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *q, mplapackint const ldq, _Float128 *z, mplapackint const ldz, mplapackint &info);
void Rgglse(mplapackint const m, mplapackint const n, mplapackint const p, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *c, _Float128 *d, _Float128 *x, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rggqrf(mplapackint const n, mplapackint const m, mplapackint const p, _Float128 *a, mplapackint const lda, _Float128 *taua, _Float128 *b, mplapackint const ldb, _Float128 *taub, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rggrqf(mplapackint const m, mplapackint const p, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *taua, _Float128 *b, mplapackint const ldb, _Float128 *taub, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rggsvd3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const n, mplapackint const p, mplapackint &k, mplapackint &l, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *alpha, _Float128 *beta, _Float128 *u, mplapackint const ldu, _Float128 *v, mplapackint const ldv, _Float128 *q, mplapackint const ldq, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rggsvp3(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 const tola, _Float128 const tolb, mplapackint &k, mplapackint &l, _Float128 *u, mplapackint const ldu, _Float128 *v, mplapackint const ldv, _Float128 *q, mplapackint const ldq, mplapackint *iwork, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgsvj0(const char *jobv, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *d, _Float128 *sva, mplapackint const mv, _Float128 *v, mplapackint const ldv, _Float128 const eps, _Float128 const sfmin, _Float128 const tol, mplapackint const nsweep, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgsvj1(const char *jobv, mplapackint const m, mplapackint const n, mplapackint const n1, _Float128 *a, mplapackint const lda, _Float128 *d, _Float128 *sva, mplapackint const mv, _Float128 *v, mplapackint const ldv, _Float128 const eps, _Float128 const sfmin, _Float128 const tol, mplapackint const nsweep, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rgtcon(const char *norm, mplapackint const n, _Float128 *dl, _Float128 *d, _Float128 *du, _Float128 *du2, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rgtrfs(const char *trans, mplapackint const n, mplapackint const nrhs, _Float128 *dl, _Float128 *d, _Float128 *du, _Float128 *dlf, _Float128 *df, _Float128 *duf, _Float128 *du2, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rgtsv(mplapackint const n, mplapackint const nrhs, _Float128 *dl, _Float128 *d, _Float128 *du, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rgtsvx(const char *fact, const char *trans, mplapackint const n, mplapackint const nrhs, _Float128 *dl, _Float128 *d, _Float128 *du, _Float128 *dlf, _Float128 *df, _Float128 *duf, _Float128 *du2, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rgttrf(mplapackint const n, _Float128 *dl, _Float128 *d, _Float128 *du, _Float128 *du2, mplapackint *ipiv, mplapackint &info);
void Rgttrs(const char *trans, mplapackint const n, mplapackint const nrhs, _Float128 *dl, _Float128 *d, _Float128 *du, _Float128 *du2, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rgtts2(mplapackint const itrans, mplapackint const n, mplapackint const nrhs, _Float128 *dl, _Float128 *d, _Float128 *du, _Float128 *du2, mplapackint *ipiv, _Float128 *b, mplapackint const ldb);
void Rhgeqz(const char *job, const char *compq, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *h, mplapackint const ldh, _Float128 *t, mplapackint const ldt, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *q, mplapackint const ldq, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rhsein(const char *side, const char *eigsrc, const char *initv, bool *select, mplapackint const n, _Float128 *h, mplapackint const ldh, _Float128 *wr, _Float128 *wi, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, _Float128 *work, mplapackint *ifaill, mplapackint *ifailr, mplapackint &info);
void Rhseqr(const char *job, const char *compz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *h, mplapackint const ldh, _Float128 *wr, _Float128 *wi, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rla_gbamv(mplapackint const trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float128 const alpha, _Float128 *ab, mplapackint const ldab, _Float128 *x, mplapackint const incx, _Float128 const beta, _Float128 *y, mplapackint const incy);
void Rla_geamv(mplapackint const trans, mplapackint const m, mplapackint const n, _Float128 const alpha, _Float128 *a, mplapackint const lda, _Float128 *x, mplapackint const incx, _Float128 const beta, _Float128 *y, mplapackint const incy);
void Rla_syamv(mplapackint const uplo, mplapackint const n, _Float128 const alpha, _Float128 *a, mplapackint const lda, _Float128 *x, mplapackint const incx, _Float128 const beta, _Float128 *y, mplapackint const incy);
void Rla_wwaddw(mplapackint const n, _Float128 *x, _Float128 *y, _Float128 *w);
void Rlabad(_Float128 &small, _Float128 &large);
void Rlabrd(mplapackint const m, mplapackint const n, mplapackint const nb, _Float128 *a, mplapackint const lda, _Float128 *d, _Float128 *e, _Float128 *tauq, _Float128 *taup, _Float128 *x, mplapackint const ldx, _Float128 *y, mplapackint const ldy);
void Rlacn2(mplapackint const n, _Float128 *v, _Float128 *x, mplapackint *isgn, _Float128 &est, mplapackint &kase, mplapackint *isave);
void Rlacon(mplapackint const n, _Float128 *v, _Float128 *x, mplapackint *isgn, _Float128 &est, mplapackint &kase);
void Rlacpy(const char *uplo, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb);
void Rladiv(_Float128 const &a, _Float128 const &b, _Float128 const &c, _Float128 const &d, _Float128 &p, _Float128 &q);
void Rladiv1(_Float128 &a, _Float128 const &b, _Float128 const &c, _Float128 const &d, _Float128 &p, _Float128 &q);
void Rlae2(_Float128 const a, _Float128 const b, _Float128 const c, _Float128 &rt1, _Float128 &rt2);
void Rlaebz(mplapackint const ijob, mplapackint const nitmax, mplapackint const n, mplapackint const mmax, mplapackint const minp, mplapackint const nbmin, _Float128 const abstol, _Float128 const reltol, _Float128 const pivmin, _Float128 *d, _Float128 *e, _Float128 *e2, mplapackint *nval, _Float128 *ab, _Float128 *c, mplapackint &mout, mplapackint *nab, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rlaed0(mplapackint const icompq, mplapackint const qsiz, mplapackint const n, _Float128 *d, _Float128 *e, _Float128 *q, mplapackint const ldq, _Float128 *qstore, mplapackint const ldqs, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rlaed1(mplapackint const n, _Float128 *d, _Float128 *q, mplapackint const ldq, mplapackint *indxq, _Float128 rho, mplapackint const cutpnt, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rlaed2(mplapackint &k, mplapackint const n, mplapackint const n1, _Float128 *d, _Float128 *q, mplapackint const ldq, mplapackint *indxq, _Float128 &rho, _Float128 *z, _Float128 *dlamda, _Float128 *w, _Float128 *q2, mplapackint *indx, mplapackint *indxc, mplapackint *indxp, mplapackint *coltyp, mplapackint &info);
void Rlaed3(mplapackint const k, mplapackint const n, mplapackint const n1, _Float128 *d, _Float128 *q, mplapackint const ldq, _Float128 const rho, _Float128 *dlamda, _Float128 *q2, mplapackint *indx, mplapackint *ctot, _Float128 *w, _Float128 *s, mplapackint &info);
void Rlaed4(mplapackint const n, mplapackint const i, _Float128 *d, _Float128 *z, _Float128 *delta, _Float128 const rho, _Float128 &dlam, mplapackint &info);
void Rlaed5(mplapackint const i, _Float128 *d, _Float128 *z, _Float128 *delta, _Float128 const rho, _Float128 &dlam);
void Rlaed6(mplapackint const kniter, bool const orgati, _Float128 const rho, _Float128 *d, _Float128 *z, _Float128 const finit, _Float128 &tau, mplapackint &info);
void Rlaed7(mplapackint const icompq, mplapackint const n, mplapackint const qsiz, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, _Float128 *d, _Float128 *q, mplapackint const ldq, mplapackint *indxq, _Float128 rho, mplapackint const cutpnt, _Float128 *qstore, mplapackint *qptr, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, _Float128 *givnum, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rlaed8(mplapackint const icompq, mplapackint &k, mplapackint const n, mplapackint const qsiz, _Float128 *d, _Float128 *q, mplapackint const ldq, mplapackint *indxq, _Float128 &rho, mplapackint const cutpnt, _Float128 *z, _Float128 *dlamda, _Float128 *q2, mplapackint const ldq2, _Float128 *w, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, _Float128 *givnum, mplapackint *indxp, mplapackint *indx, mplapackint &info);
void Rlaed9(mplapackint const k, mplapackint const kstart, mplapackint const kstop, mplapackint const n, _Float128 *d, _Float128 *q, mplapackint const ldq, _Float128 const rho, _Float128 *dlamda, _Float128 *w, _Float128 *s, mplapackint const lds, mplapackint &info);
void Rlaeda(mplapackint const n, mplapackint const tlvls, mplapackint const curlvl, mplapackint const curpbm, mplapackint *prmptr, mplapackint *perm, mplapackint *givptr, mplapackint *givcol, _Float128 *givnum, _Float128 *q, mplapackint *qptr, _Float128 *z, _Float128 *ztemp, mplapackint &info);
void Rlaein(bool const rightv, bool const noinit, mplapackint const n, _Float128 *h, mplapackint const ldh, _Float128 const wr, _Float128 const wi, _Float128 *vr, _Float128 *vi, _Float128 *b, mplapackint const ldb, _Float128 *work, _Float128 const eps3, _Float128 const smlnum, _Float128 const bignum, mplapackint &info);
void Rlaev2(_Float128 const a, _Float128 const b, _Float128 const c, _Float128 &rt1, _Float128 &rt2, _Float128 &cs1, _Float128 &sn1);
void Rlaexc(bool const wantq, mplapackint const n, _Float128 *t, mplapackint const ldt, _Float128 *q, mplapackint const ldq, mplapackint const j1, mplapackint const n1, mplapackint const n2, _Float128 *work, mplapackint &info);
void Rlag2(_Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 const safmin, _Float128 &scale1, _Float128 &scale2, _Float128 &wr1, _Float128 &wr2, _Float128 &wi);
void Rlags2(bool const upper, _Float128 const a1, _Float128 const a2, _Float128 const a3, _Float128 const b1, _Float128 const b2, _Float128 const b3, _Float128 &csu, _Float128 &snu, _Float128 &csv, _Float128 &snv, _Float128 &csq, _Float128 &snq);
void Rlagtf(mplapackint const n, _Float128 *a, _Float128 const lambda, _Float128 *b, _Float128 *c, _Float128 const tol, _Float128 *d, mplapackint *in, mplapackint &info);
void Rlagtm(const char *trans, mplapackint const n, mplapackint const nrhs, _Float128 const alpha, _Float128 *dl, _Float128 *d, _Float128 *du, _Float128 *x, mplapackint const ldx, _Float128 const beta, _Float128 *b, mplapackint const ldb);
void Rlagts(mplapackint const job, mplapackint const n, _Float128 *a, _Float128 *b, _Float128 *c, _Float128 *d, mplapackint *in, _Float128 *y, _Float128 &tol, mplapackint &info);
void Rlagv2(_Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 &csl, _Float128 &snl, _Float128 &csr, _Float128 &snr);
void Rlahqr(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *h, mplapackint const ldh, _Float128 *wr, _Float128 *wi, mplapackint const iloz, mplapackint const ihiz, _Float128 *z, mplapackint const ldz, mplapackint &info);
void Rlahr2(mplapackint const n, mplapackint const k, mplapackint const nb, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *t, mplapackint const ldt, _Float128 *y, mplapackint const ldy);
void Rlaic1(mplapackint const job, mplapackint const j, _Float128 *x, _Float128 const sest, _Float128 *w, _Float128 const gamma, _Float128 &sestpr, _Float128 &s, _Float128 &c);
void Rlaln2(bool const ltrans, mplapackint const na, mplapackint const nw, _Float128 const smin, _Float128 const ca, _Float128 *a, mplapackint const lda, _Float128 const d1, _Float128 const d2, _Float128 *b, mplapackint const ldb, _Float128 const wr, _Float128 const wi, _Float128 *x, mplapackint const ldx, _Float128 &scale, _Float128 &xnorm, mplapackint &info);
void Rlals0(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const nrhs, _Float128 *b, mplapackint const ldb, _Float128 *bx, mplapackint const ldbx, mplapackint *perm, mplapackint const givptr, mplapackint *givcol, mplapackint const ldgcol, _Float128 *givnum, mplapackint const ldgnum, _Float128 *poles, _Float128 *difl, _Float128 *difr, _Float128 *z, mplapackint const k, _Float128 const c, _Float128 const s, _Float128 *work, mplapackint &info);
void Rlalsa(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, _Float128 *b, mplapackint const ldb, _Float128 *bx, mplapackint const ldbx, _Float128 *u, mplapackint const ldu, _Float128 *vt, mplapackint *k, _Float128 *difl, _Float128 *difr, _Float128 *z, _Float128 *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, _Float128 *givnum, _Float128 *c, _Float128 *s, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rlalsd(const char *uplo, mplapackint const smlsiz, mplapackint const n, mplapackint const nrhs, _Float128 *d, _Float128 *e, _Float128 *b, mplapackint const ldb, _Float128 const rcond, mplapackint &rank, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rlamrg(mplapackint const n1, mplapackint const n2, _Float128 *a, mplapackint const dtrd1, mplapackint const dtrd2, mplapackint *index);
void Rlamswlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const mb, mplapackint const nb, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const ldt, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rlamtsqr(const char *side, const char *trans, mplapackint const &m, mplapackint const &n, mplapackint const &k, mplapackint const &mb, mplapackint const &nb, _Float128 *a, mplapackint const &lda, _Float128 *t, mplapackint const &ldt, _Float128 *c, mplapackint const &ldc, _Float128 *work, mplapackint const &lwork, mplapackint &info);
void Rlanv2(_Float128 &a, _Float128 &b, _Float128 &c, _Float128 &d, _Float128 &rt1r, _Float128 &rt1i, _Float128 &rt2r, _Float128 &rt2i, _Float128 &cs, _Float128 &sn);
void Rlaorhr_col_getrfnp(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *d, mplapackint &info);
void Rlaorhr_col_getrfnp2(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *d, mplapackint &info);
void Rlapll(mplapackint const n, _Float128 *x, mplapackint const incx, _Float128 *y, mplapackint const incy, _Float128 &ssmin);
void Rlapmr(bool const forwrd, mplapackint const m, mplapackint const n, _Float128 *x, mplapackint const ldx, mplapackint *k);
void Rlapmt(bool const forwrd, mplapackint const m, mplapackint const n, _Float128 *x, mplapackint const ldx, mplapackint *k);
void Rlaqgb(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float128 *ab, mplapackint const ldab, _Float128 *r, _Float128 *c, _Float128 const rowcnd, _Float128 const colcnd, _Float128 const amax, char *equed);
void Rlaqge(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *r, _Float128 *c, _Float128 const rowcnd, _Float128 const colcnd, _Float128 const amax, char *equed);
void Rlaqp2(mplapackint const m, mplapackint const n, mplapackint const offset, _Float128 *a, mplapackint const lda, mplapackint *jpvt, _Float128 *tau, _Float128 *vn1, _Float128 *vn2, _Float128 *work);
void Rlaqps(mplapackint const m, mplapackint const n, mplapackint const offset, mplapackint const nb, mplapackint &kb, _Float128 *a, mplapackint const lda, mplapackint *jpvt, _Float128 *tau, _Float128 *vn1, _Float128 *vn2, _Float128 *auxv, _Float128 *f, mplapackint const ldf);
void Rlaqr0(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *h, mplapackint const ldh, _Float128 *wr, _Float128 *wi, mplapackint const iloz, mplapackint const ihiz, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rlaqr1(mplapackint const n, _Float128 *h, mplapackint const ldh, _Float128 const sr1, _Float128 const si1, _Float128 const sr2, _Float128 const si2, _Float128 *v);
void Rlaqr2(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, _Float128 *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, _Float128 *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, _Float128 *sr, _Float128 *si, _Float128 *v, mplapackint const ldv, mplapackint const nh, _Float128 *t, mplapackint const ldt, mplapackint const nv, _Float128 *wv, mplapackint const ldwv, _Float128 *work, mplapackint const lwork);
void Rlaqr3(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nw, _Float128 *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, _Float128 *z, mplapackint const ldz, mplapackint &ns, mplapackint &nd, _Float128 *sr, _Float128 *si, _Float128 *v, mplapackint const ldv, mplapackint const nh, _Float128 *t, mplapackint const ldt, mplapackint const nv, _Float128 *wv, mplapackint const ldwv, _Float128 *work, mplapackint const lwork);
void Rlaqr4(bool const wantt, bool const wantz, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *h, mplapackint const ldh, _Float128 *wr, _Float128 *wi, mplapackint const iloz, mplapackint const ihiz, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rlaqr5(bool const wantt, bool const wantz, mplapackint const kacc22, mplapackint const n, mplapackint const ktop, mplapackint const kbot, mplapackint const nshfts, _Float128 *sr, _Float128 *si, _Float128 *h, mplapackint const ldh, mplapackint const iloz, mplapackint const ihiz, _Float128 *z, mplapackint const ldz, _Float128 *v, mplapackint const ldv, _Float128 *u, mplapackint const ldu, mplapackint const nv, _Float128 *wv, mplapackint const ldwv, mplapackint const nh, _Float128 *wh, mplapackint const ldwh);
void Rlaqsb(const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, _Float128 *s, _Float128 const scond, _Float128 const amax, char *equed);
void Rlaqsp(const char *uplo, mplapackint const n, _Float128 *ap, _Float128 *s, _Float128 const scond, _Float128 const amax, char *equed);
void Rlaqsy(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *s, _Float128 const scond, _Float128 const amax, char *equed);
void Rlaqtr(bool const ltran, bool const lreal, mplapackint const n, _Float128 *t, mplapackint const ldt, _Float128 *b, _Float128 const w, _Float128 &scale, _Float128 *x, _Float128 *work, mplapackint &info);
void Rlar1v(mplapackint const n, mplapackint const b1, mplapackint const bn, _Float128 const lambda, _Float128 *d, _Float128 *l, _Float128 *ld, _Float128 *lld, _Float128 const pivmin, _Float128 const gaptol, _Float128 *z, bool const wantnc, mplapackint &negcnt, _Float128 &ztz, _Float128 &mingma, mplapackint &r, mplapackint *isuppz, _Float128 &nrminv, _Float128 &resid, _Float128 &rqcorr, _Float128 *work);
void Rlar2v(mplapackint const n, _Float128 *x, _Float128 *y, _Float128 *z, mplapackint const incx, _Float128 *c, _Float128 *s, mplapackint const incc);
void Rlarf(const char *side, mplapackint const m, mplapackint const n, _Float128 *v, mplapackint const incv, _Float128 const tau, _Float128 *c, mplapackint const ldc, _Float128 *work);
void Rlarfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *v, mplapackint const ldv, _Float128 *t, mplapackint const ldt, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const ldwork);
void Rlarfb_gett(const char *ident, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *t, mplapackint const ldt, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *work, mplapackint const ldwork);
void Rlarfg(mplapackint const n, _Float128 &alpha, _Float128 *x, mplapackint const incx, _Float128 &tau);
void Rlarfgp(mplapackint const n, _Float128 &alpha, _Float128 *x, mplapackint const incx, _Float128 &tau);
void Rlarft(const char *direct, const char *storev, mplapackint const n, mplapackint const k, _Float128 *v, mplapackint const ldv, _Float128 *tau, _Float128 *t, mplapackint const ldt);
void Rlarfx(const char *side, mplapackint const m, mplapackint const n, _Float128 *v, _Float128 const tau, _Float128 *c, mplapackint const ldc, _Float128 *work);
void Rlarfy(const char *uplo, mplapackint const n, _Float128 *v, mplapackint const incv, _Float128 const tau, _Float128 *c, mplapackint const ldc, _Float128 *work);
void Rlargv(mplapackint const n, _Float128 *x, mplapackint const incx, _Float128 *y, mplapackint const incy, _Float128 *c, mplapackint const incc);
void Rlarnv(mplapackint const idist, mplapackint *iseed, mplapackint const n, _Float128 *x);
void Rlarra(mplapackint const n, _Float128 *d, _Float128 *e, _Float128 *e2, _Float128 const spltol, _Float128 const tnrm, mplapackint &nsplit, mplapackint *isplit, mplapackint &info);
void Rlarrb(mplapackint const n, _Float128 *d, _Float128 *lld, mplapackint const ifirst, mplapackint const ilast, _Float128 const rtol1, _Float128 const rtol2, mplapackint const offset, _Float128 *w, _Float128 *wgap, _Float128 *werr, _Float128 *work, mplapackint *iwork, _Float128 const pivmin, _Float128 const spdiam, mplapackint const twist, mplapackint &info);
void Rlarrc(const char *jobt, mplapackint const n, _Float128 const vl, _Float128 const vu, _Float128 *d, _Float128 *e, _Float128 const, mplapackint &eigcnt, mplapackint &lcnt, mplapackint &rcnt, mplapackint &info);
void Rlarrd(const char *range, const char *order, mplapackint const n, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 *gers, _Float128 const reltol, _Float128 *d, _Float128 *e, _Float128 *e2, _Float128 const pivmin, mplapackint const nsplit, mplapackint *isplit, mplapackint &m, _Float128 *w, _Float128 *werr, _Float128 &wl, _Float128 &wu, mplapackint *iblock, mplapackint *indexw, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rlarre(const char *range, mplapackint const n, _Float128 &vl, _Float128 &vu, mplapackint const il, mplapackint const iu, _Float128 *d, _Float128 *e, _Float128 *e2, _Float128 const rtol1, _Float128 const rtol2, _Float128 const spltol, mplapackint nsplit, mplapackint *isplit, mplapackint &m, _Float128 *w, _Float128 *werr, _Float128 *wgap, mplapackint *iblock, mplapackint *indexw, _Float128 *gers, _Float128 &pivmin, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rlarrf(mplapackint const n, _Float128 *d, _Float128 *l, _Float128 *ld, mplapackint const clstrt, mplapackint const clend, _Float128 *w, _Float128 *wgap, _Float128 *werr, _Float128 const spdiam, _Float128 const clgapl, _Float128 const clgapr, _Float128 const pivmin, _Float128 &sigma, _Float128 *dplus, _Float128 *lplus, _Float128 *work, mplapackint &info);
void Rlarrj(mplapackint const n, _Float128 *d, _Float128 *e2, mplapackint const ifirst, mplapackint const ilast, _Float128 const rtol, mplapackint const offset, _Float128 *w, _Float128 *werr, _Float128 *work, mplapackint *iwork, _Float128 const pivmin, _Float128 const spdiam, mplapackint &info);
void Rlarrk(mplapackint const n, mplapackint const iw, _Float128 const gl, _Float128 const gu, _Float128 *d, _Float128 *e2, _Float128 const pivmin, _Float128 const reltol, _Float128 &w, _Float128 &werr, mplapackint &info);
void Rlarrr(mplapackint const n, _Float128 *d, _Float128 *e, mplapackint &info);
void Rlarrv(mplapackint const n, _Float128 const vl, _Float128 const, _Float128 *d, _Float128 *l, _Float128 const pivmin, mplapackint *isplit, mplapackint const m, mplapackint const dol, mplapackint const dou, _Float128 const minrgp, _Float128 &rtol1, _Float128 &rtol2, _Float128 *w, _Float128 *werr, _Float128 *wgap, mplapackint *iblock, mplapackint *indexw, _Float128 *gers, _Float128 *z, mplapackint const ldz, mplapackint *isuppz, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rlarscl2(mplapackint const m, mplapackint const n, _Float128 *d, _Float128 *x, mplapackint const ldx);
void Rlartg(_Float128 const f, _Float128 const g, _Float128 &cs, _Float128 &sn, _Float128 &r);
void Rlartgp(_Float128 const f, _Float128 const g, _Float128 &cs, _Float128 &sn, _Float128 &r);
void Rlartgs(_Float128 const x, _Float128 const y, _Float128 const sigma, _Float128 &cs, _Float128 &sn);
void Rlartv(mplapackint const n, _Float128 *x, mplapackint const incx, _Float128 *y, mplapackint const incy, _Float128 *c, _Float128 *s, mplapackint const incc);
void Rlaruv(mplapackint *iseed, mplapackint const n, _Float128 *x);
void Rlarz(const char *side, mplapackint const m, mplapackint const n, mplapackint const l, _Float128 *v, mplapackint const incv, _Float128 const tau, _Float128 *c, mplapackint const ldc, _Float128 *work);
void Rlarzb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, _Float128 *v, mplapackint const ldv, _Float128 *t, mplapackint const ldt, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const ldwork);
void Rlarzt(const char *direct, const char *storev, mplapackint const n, mplapackint const k, _Float128 *v, mplapackint const ldv, _Float128 *tau, _Float128 *t, mplapackint const ldt);
void Rlas2(_Float128 const f, _Float128 const g, _Float128 const h, _Float128 &ssmin, _Float128 &ssmax);
void Rlascl(const char *type, mplapackint const kl, mplapackint const ku, _Float128 const cfrom, _Float128 const cto, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint &info);
void Rlascl2(mplapackint const m, mplapackint const n, _Float128 *d, _Float128 *x, mplapackint const ldx);
void Rlasd0(mplapackint const n, mplapackint const sqre, _Float128 *d, _Float128 *e, _Float128 *u, mplapackint const ldu, _Float128 *vt, mplapackint const ldvt, mplapackint const smlsiz, mplapackint *iwork, _Float128 *work, mplapackint &info);
void Rlasd1(mplapackint const nl, mplapackint const nr, mplapackint const sqre, _Float128 *d, _Float128 &alpha, _Float128 &beta, _Float128 *u, mplapackint const ldu, _Float128 *vt, mplapackint const ldvt, mplapackint *idxq, mplapackint *iwork, _Float128 *work, mplapackint &info);
void Rlasd2(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint &k, _Float128 *d, _Float128 *z, _Float128 const alpha, _Float128 const beta, _Float128 *u, mplapackint const ldu, _Float128 *vt, mplapackint const ldvt, _Float128 *dsigma, _Float128 *u2, mplapackint const ldu2, _Float128 *vt2, mplapackint const ldvt2, mplapackint *idxp, mplapackint *idx, mplapackint *idxc, mplapackint *idxq, mplapackint *coltyp, mplapackint &info);
void Rlasd3(mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint const k, _Float128 *d, _Float128 *q, mplapackint const ldq, _Float128 *dsigma, _Float128 *u, mplapackint const ldu, _Float128 *u2, mplapackint const ldu2, _Float128 *vt, mplapackint const ldvt, _Float128 *vt2, mplapackint const ldvt2, mplapackint *idxc, mplapackint *ctot, _Float128 *z, mplapackint &info);
void Rlasd4(mplapackint const n, mplapackint const i, _Float128 *d, _Float128 *z, _Float128 *delta, _Float128 const rho, _Float128 &sigma, _Float128 *work, mplapackint &info);
void Rlasd5(mplapackint const i, _Float128 *d, _Float128 *z, _Float128 *delta, _Float128 const rho, _Float128 &dsigma, _Float128 *work);
void Rlasd6(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, _Float128 *d, _Float128 *vf, _Float128 *vl, _Float128 &alpha, _Float128 &beta, mplapackint *idxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mplapackint const ldgcol, _Float128 *givnum, mplapackint const ldgnum, _Float128 *poles, _Float128 *difl, _Float128 *difr, _Float128 *z, mplapackint &k, _Float128 &c, _Float128 &s, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rlasd7(mplapackint const icompq, mplapackint const nl, mplapackint const nr, mplapackint const sqre, mplapackint &k, _Float128 *d, _Float128 *z, _Float128 *zw, _Float128 *vf, _Float128 *vfw, _Float128 *vl, _Float128 *vlw, _Float128 const alpha, _Float128 const beta, _Float128 *dsigma, mplapackint *idx, mplapackint *idxp, mplapackint *idxq, mplapackint *perm, mplapackint &givptr, mplapackint *givcol, mplapackint const ldgcol, _Float128 *givnum, mplapackint const ldgnum, _Float128 &c, _Float128 &s, mplapackint &info);
void Rlasd8(mplapackint const icompq, mplapackint const k, _Float128 *d, _Float128 *z, _Float128 *vf, _Float128 *vl, _Float128 *difl, _Float128 *difr, mplapackint const lddifr, _Float128 *dsigma, _Float128 *work, mplapackint &info);
void Rlasda(mplapackint const icompq, mplapackint const smlsiz, mplapackint const n, mplapackint const sqre, _Float128 *d, _Float128 *e, _Float128 *u, mplapackint const ldu, _Float128 *vt, mplapackint *k, _Float128 *difl, _Float128 *difr, _Float128 *z, _Float128 *poles, mplapackint *givptr, mplapackint *givcol, mplapackint const ldgcol, mplapackint *perm, _Float128 *givnum, _Float128 *c, _Float128 *s, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rlasdq(const char *uplo, mplapackint const sqre, mplapackint const n, mplapackint const ncvt, mplapackint const nru, mplapackint const ncc, _Float128 *d, _Float128 *e, _Float128 *vt, mplapackint const ldvt, _Float128 *u, mplapackint const ldu, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint &info);
void Rlasdt(mplapackint const n, mplapackint &lvl, mplapackint &nd, mplapackint *inode, mplapackint *ndiml, mplapackint *ndimr, mplapackint const msub);
void Rlaset(const char *uplo, mplapackint const m, mplapackint const n, _Float128 const alpha, _Float128 const beta, _Float128 *a, mplapackint const lda);
void Rlasq1(mplapackint const n, _Float128 *d, _Float128 *e, _Float128 *work, mplapackint &info);
void Rlasq2(mplapackint const n, _Float128 *z, mplapackint &info);
void Rlasq3(mplapackint const i0, mplapackint &n0, _Float128 *z, mplapackint &pp, _Float128 &dmin, _Float128 &sigma, _Float128 &desig, _Float128 &qmax, mplapackint &nfail, mplapackint &iter, mplapackint &ndiv, bool const ieee, mplapackint &ttype, _Float128 dmin1, _Float128 &dmin2, _Float128 dn, _Float128 dn1, _Float128 dn2, _Float128 g, _Float128 &tau);
void Rlasq4(mplapackint const i0, mplapackint const n0, _Float128 *z, mplapackint const pp, mplapackint const n0in, _Float128 const dmin, _Float128 const dmin1, _Float128 const dmin2, _Float128 const dn, _Float128 const dn1, _Float128 const dn2, _Float128 &tau, mplapackint &ttype, _Float128 &g);
void Rlasq5(mplapackint const i0, mplapackint const n0, _Float128 *z, mplapackint const pp, _Float128 &tau, _Float128 const sigma, _Float128 &dmin, _Float128 &dmin1, _Float128 &dmin2, _Float128 &dn, _Float128 &dnm1, _Float128 &dnm2, bool const ieee, _Float128 const eps);
void Rlasq6(mplapackint const i0, mplapackint const n0, _Float128 *z, mplapackint const pp, _Float128 &dmin, _Float128 &dmin1, _Float128 &dmin2, _Float128 &dn, _Float128 &dnm1, _Float128 &dnm2);
void Rlasr(const char *side, const char *pivot, const char *direct, mplapackint const m, mplapackint const n, _Float128 *c, _Float128 *s, _Float128 *a, mplapackint const lda);
void Rlasrt(const char *id, mplapackint const n, _Float128 *d, mplapackint &info);
void Rlassq(mplapackint const n, _Float128 *x, mplapackint const incx, _Float128 &scale, _Float128 &sumsq);
void Rlasv2(_Float128 const f, _Float128 const g, _Float128 const h, _Float128 &ssmin, _Float128 &ssmax, _Float128 &snr, _Float128 &csr, _Float128 &snl, _Float128 &csl);
void Rlaswlq(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const ldt, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rlaswp(mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint const k1, mplapackint const k2, mplapackint *ipiv, mplapackint const incx);
void Rlasy2(bool const ltranl, bool const ltranr, mplapackint const isgn, mplapackint const n1, mplapackint const n2, _Float128 *tl, mplapackint const ldtl, _Float128 *tr, mplapackint const ldtr, _Float128 *b, mplapackint const ldb, _Float128 &scale, _Float128 *x, mplapackint const ldx, _Float128 &xnorm, mplapackint &info);
void Rlasyf(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *w, mplapackint const ldw, mplapackint &info);
void Rlasyf_aa(const char *uplo, mplapackint const j1, mplapackint const m, mplapackint const nb, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *h, mplapackint const ldh, _Float128 *work);
void Rlasyf_rk(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, _Float128 *a, mplapackint const lda, _Float128 *e, mplapackint *ipiv, _Float128 *w, mplapackint const ldw, mplapackint &info);
void Rlasyf_rook(const char *uplo, mplapackint const n, mplapackint const nb, mplapackint &kb, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *w, mplapackint const ldw, mplapackint &info);
void Rlatbs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, _Float128 *x, _Float128 &scale, _Float128 *cnorm, mplapackint &info);
void Rlatdf(mplapackint const ijob, mplapackint const n, _Float128 *z, mplapackint const ldz, _Float128 *rhs, _Float128 &rdsum, _Float128 &rdscal, mplapackint *ipiv, mplapackint *jpiv);
void Rlatps(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, _Float128 *ap, _Float128 *x, _Float128 &scale, _Float128 *cnorm, mplapackint &info);
void Rlatrd(const char *uplo, mplapackint const n, mplapackint const nb, _Float128 *a, mplapackint const lda, _Float128 *e, _Float128 *tau, _Float128 *w, mplapackint const ldw);
void Rlatrs(const char *uplo, const char *trans, const char *diag, const char *normin, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *x, _Float128 &scale, _Float128 *cnorm, mplapackint &info);
void Rlatrz(mplapackint const m, mplapackint const n, mplapackint const l, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work);
void Rlatsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const ldt, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rlauu2(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint &info);
void Rlauum(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint &info);
void Ropgtr(const char *uplo, mplapackint const n, _Float128 *ap, _Float128 *tau, _Float128 *q, mplapackint const ldq, _Float128 *work, mplapackint &info);
void Ropmtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, _Float128 *ap, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint &info);
void Rorbdb(const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, _Float128 *x11, mplapackint const ldx11, _Float128 *x12, mplapackint const ldx12, _Float128 *x21, mplapackint const ldx21, _Float128 *x22, mplapackint const ldx22, _Float128 *theta, _Float128 *phi, _Float128 *taup1, _Float128 *taup2, _Float128 *tauq1, _Float128 *tauq2, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorbdb1(mplapackint const m, mplapackint const p, mplapackint const q, _Float128 *x11, mplapackint const ldx11, _Float128 *x21, mplapackint const ldx21, _Float128 *theta, _Float128 *phi, _Float128 *taup1, _Float128 *taup2, _Float128 *tauq1, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorbdb2(mplapackint const m, mplapackint const p, mplapackint const q, _Float128 *x11, mplapackint const ldx11, _Float128 *x21, mplapackint const ldx21, _Float128 *theta, _Float128 *phi, _Float128 *taup1, _Float128 *taup2, _Float128 *tauq1, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorbdb3(mplapackint const m, mplapackint const p, mplapackint const q, _Float128 *x11, mplapackint const ldx11, _Float128 *x21, mplapackint const ldx21, _Float128 *theta, _Float128 *phi, _Float128 *taup1, _Float128 *taup2, _Float128 *tauq1, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorbdb4(mplapackint const m, mplapackint const p, mplapackint const q, _Float128 *x11, mplapackint const ldx11, _Float128 *x21, mplapackint const ldx21, _Float128 *theta, _Float128 *phi, _Float128 *taup1, _Float128 *taup2, _Float128 *tauq1, _Float128 *phantom, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorbdb5(mplapackint const m1, mplapackint const m2, mplapackint const n, _Float128 *x1, mplapackint const incx1, _Float128 *x2, mplapackint const incx2, _Float128 *q1, mplapackint const ldq1, _Float128 *q2, mplapackint const ldq2, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorbdb6(mplapackint const m1, mplapackint const m2, mplapackint const n, _Float128 *x1, mplapackint const incx1, _Float128 *x2, mplapackint const incx2, _Float128 *q1, mplapackint const ldq1, _Float128 *q2, mplapackint const ldq2, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorcsd(const char *jobu1, const char *jobu2, const char *jobv1t, const char *jobv2t, const char *trans, const char *signs, mplapackint const m, mplapackint const p, mplapackint const q, _Float128 *x11, mplapackint const ldx11, _Float128 *x12, mplapackint const ldx12, _Float128 *x21, mplapackint const ldx21, _Float128 *x22, mplapackint const ldx22, _Float128 *theta, _Float128 *u1, mplapackint const ldu1, _Float128 *u2, mplapackint const ldu2, _Float128 *v1t, mplapackint const ldv1t, _Float128 *v2t, mplapackint const ldv2t, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rorcsd2by1(const char *jobu1, const char *jobu2, const char *jobv1t, mplapackint const m, mplapackint const p, mplapackint const q, _Float128 *x11, mplapackint const ldx11, _Float128 *x21, mplapackint const ldx21, _Float128 *theta, _Float128 *u1, mplapackint const ldu1, _Float128 *u2, mplapackint const ldu2, _Float128 *v1t, mplapackint const ldv1t, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rorg2l(mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint &info);
void Rorg2r(mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint &info);
void Rorgbr(const char *vect, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorghr(mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorgl2(mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint &info);
void Rorglq(mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorgql(mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorgqr(mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorgr2(mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint &info);
void Rorgrq(mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorgtr(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorgtsqr(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const ldt, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorgtsqr_row(mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const ldt, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorhr_col(mplapackint const m, mplapackint const n, mplapackint const nb, _Float128 *a, mplapackint const lda, _Float128 *t, mplapackint const ldt, _Float128 *d, mplapackint &info);
void Rorm22(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const n1, mplapackint const n2, _Float128 *q, mplapackint const ldq, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorm2l(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint &info);
void Rorm2r(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint &info);
void Rormbr(const char *vect, const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rormhr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const ilo, mplapackint const ihi, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rorml2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint &info);
void Rormlq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rormql(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rormqr(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rormr2(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint &info);
void Rormr3(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint &info);
void Rormrq(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rormrz(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rormtr(const char *side, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *c, mplapackint const ldc, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rpbcon(const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, _Float128 const anorm, _Float128 &rcond, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rpbequ(const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, _Float128 *s, _Float128 &scond, _Float128 &amax, mplapackint &info);
void Rpbrfs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float128 *ab, mplapackint const ldab, _Float128 *afb, mplapackint const ldafb, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rpbstf(const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, mplapackint &info);
void Rpbsv(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float128 *ab, mplapackint const ldab, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rpbsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float128 *ab, mplapackint const ldab, _Float128 *afb, mplapackint const ldafb, char *equed, _Float128 *s, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rpbtf2(const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, mplapackint &info);
void Rpbtrf(const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, mplapackint &info);
void Rpbtrs(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float128 *ab, mplapackint const ldab, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rpftrf(const char *transr, const char *uplo, mplapackint const n, _Float128 *a, mplapackint &info);
void Rpftri(const char *transr, const char *uplo, mplapackint const n, _Float128 *a, mplapackint &info);
void Rpftrs(const char *transr, const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rpocon(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 const anorm, _Float128 &rcond, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rpoequ(mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *s, _Float128 &scond, _Float128 &amax, mplapackint &info);
void Rpoequb(mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *s, _Float128 &scond, _Float128 &amax, mplapackint &info);
void Rporfs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *af, mplapackint const ldaf, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rposv(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rposvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *af, mplapackint const ldaf, char *equed, _Float128 *s, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rpotf2(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint &info);
void Rpotrf(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint &info);
void Rpotrf2(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint &info);
void Rpotri(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint &info);
void Rpotrs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rppcon(const char *uplo, mplapackint const n, _Float128 *ap, _Float128 const anorm, _Float128 &rcond, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rppequ(const char *uplo, mplapackint const n, _Float128 *ap, _Float128 *s, _Float128 &scond, _Float128 &amax, mplapackint &info);
void Rpprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *ap, _Float128 *afp, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rppsv(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *ap, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rppsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *ap, _Float128 *afp, char *equed, _Float128 *s, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rpptrf(const char *uplo, mplapackint const n, _Float128 *ap, mplapackint &info);
void Rpptri(const char *uplo, mplapackint const n, _Float128 *ap, mplapackint &info);
void Rpptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *ap, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rpstf2(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, _Float128 const tol, _Float128 *work, mplapackint &info);
void Rpstrf(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *piv, mplapackint &rank, _Float128 const tol, _Float128 *work, mplapackint &info);
void Rptcon(mplapackint const n, _Float128 *d, _Float128 *e, _Float128 const anorm, _Float128 &rcond, _Float128 *work, mplapackint &info);
void Rpteqr(const char *compz, mplapackint const n, _Float128 *d, _Float128 *e, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint &info);
void Rptrfs(mplapackint const n, mplapackint const nrhs, _Float128 *d, _Float128 *e, _Float128 *df, _Float128 *ef, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint &info);
void Rptsv(mplapackint const n, mplapackint const nrhs, _Float128 *d, _Float128 *e, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rptsvx(const char *fact, mplapackint const n, mplapackint const nrhs, _Float128 *d, _Float128 *e, _Float128 *df, _Float128 *ef, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint &info);
void Rpttrf(mplapackint const n, _Float128 *d, _Float128 *e, mplapackint &info);
void Rpttrs(mplapackint const n, mplapackint const nrhs, _Float128 *d, _Float128 *e, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rptts2(mplapackint const n, mplapackint const nrhs, _Float128 *d, _Float128 *e, _Float128 *b, mplapackint const ldb);
void Rrscl(mplapackint const n, _Float128 const sa, _Float128 *sx, mplapackint const incx);
void Rsb2st_kernels(const char *uplo, bool const wantz, mplapackint const ttype, mplapackint const st, mplapackint const ed, mplapackint const sweep, mplapackint const n, mplapackint const nb, mplapackint const ib, _Float128 *a, mplapackint const lda, _Float128 *v, _Float128 *tau, mplapackint const ldvt, _Float128 *work);
void Rsbev(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint &info);
void Rsbev_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsbevd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbevd_2stage(const char *jobz, const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, _Float128 *q, mplapackint const ldq, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, _Float128 *q, mplapackint const ldq, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbgst(const char *vect, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, _Float128 *ab, mplapackint const ldab, _Float128 *bb, mplapackint const ldbb, _Float128 *x, mplapackint const ldx, _Float128 *work, mplapackint &info);
void Rsbgv(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, _Float128 *ab, mplapackint const ldab, _Float128 *bb, mplapackint const ldbb, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint &info);
void Rsbgvd(const char *jobz, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, _Float128 *ab, mplapackint const ldab, _Float128 *bb, mplapackint const ldbb, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsbgvx(const char *jobz, const char *range, const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const kb, _Float128 *ab, mplapackint const ldab, _Float128 *bb, mplapackint const ldbb, _Float128 *q, mplapackint const ldq, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsbtrd(const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, _Float128 *d, _Float128 *e, _Float128 *q, mplapackint const ldq, _Float128 *work, mplapackint &info);
void Rsfrk(const char *transr, const char *uplo, const char *trans, mplapackint const n, mplapackint const k, _Float128 const alpha, _Float128 *a, mplapackint const lda, _Float128 const beta, _Float128 *c);
void Rspcon(const char *uplo, mplapackint const n, _Float128 *ap, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rspev(const char *jobz, const char *uplo, mplapackint const n, _Float128 *ap, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint &info);
void Rspevd(const char *jobz, const char *uplo, mplapackint const n, _Float128 *ap, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rspevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float128 *ap, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rspgst(mplapackint const itype, const char *uplo, mplapackint const n, _Float128 *ap, _Float128 *bp, mplapackint &info);
void Rspgv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, _Float128 *ap, _Float128 *bp, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint &info);
void Rspgvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, _Float128 *ap, _Float128 *bp, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rspgvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float128 *ap, _Float128 *bp, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsprfs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *ap, _Float128 *afp, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rspsv(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *ap, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rspsvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *ap, _Float128 *afp, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rsptrd(const char *uplo, mplapackint const n, _Float128 *ap, _Float128 *d, _Float128 *e, _Float128 *tau, mplapackint &info);
void Rsptrf(const char *uplo, mplapackint const n, _Float128 *ap, mplapackint *ipiv, mplapackint &info);
void Rsptri(const char *uplo, mplapackint const n, _Float128 *ap, mplapackint *ipiv, _Float128 *work, mplapackint &info);
void Rsptrs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *ap, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rstebz(const char *range, const char *order, mplapackint const n, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, _Float128 *d, _Float128 *e, mplapackint &m, mplapackint &nsplit, _Float128 *w, mplapackint *iblock, mplapackint *isplit, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rstedc(const char *compz, mplapackint const n, _Float128 *d, _Float128 *e, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstein(mplapackint const n, _Float128 *d, _Float128 *e, mplapackint const m, _Float128 *w, mplapackint *iblock, mplapackint *isplit, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rstemr(const char *jobz, const char *range, mplapackint const n, _Float128 *d, _Float128 *e, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, mplapackint &m, _Float128 *w, _Float128 *z, mplapackint const ldz, mplapackint const nzc, mplapackint *isuppz, bool &tryrac, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsteqr(const char *compz, mplapackint const n, _Float128 *d, _Float128 *e, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint &info);
void Rsterf(mplapackint const n, _Float128 *d, _Float128 *e, mplapackint &info);
void Rstev(const char *jobz, mplapackint const n, _Float128 *d, _Float128 *e, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint &info);
void Rstevd(const char *jobz, mplapackint const n, _Float128 *d, _Float128 *e, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstevr(const char *jobz, const char *range, mplapackint const n, _Float128 *d, _Float128 *e, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, _Float128 *z, mplapackint const ldz, mplapackint *isuppz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rstevx(const char *jobz, const char *range, mplapackint const n, _Float128 *d, _Float128 *e, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsycon(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rsycon_3(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *e, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rsycon_rook(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 const anorm, _Float128 &rcond, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rsyconv(const char *uplo, const char *way, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *e, mplapackint &info);
void Rsyconvf(const char *uplo, const char *way, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *e, mplapackint *ipiv, mplapackint &info);
void Rsyconvf_rook(const char *uplo, const char *way, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *e, mplapackint *ipiv, mplapackint &info);
void Rsyequb(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *s, _Float128 &scond, _Float128 &amax, _Float128 *work, mplapackint &info);
void Rsyev(const char *jobz, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *w, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsyev_2stage(const char *jobz, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *w, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsyevd(const char *jobz, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *w, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevd_2stage(const char *jobz, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *w, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevr(const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, _Float128 *z, mplapackint const ldz, mplapackint *isuppz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevr_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, _Float128 *z, mplapackint const ldz, mplapackint *isuppz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsyevx(const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsyevx_2stage(const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsygs2(mplapackint const itype, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rsygst(mplapackint const itype, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rsygv(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *w, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsygv_2stage(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *w, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsygvd(mplapackint const itype, const char *jobz, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *w, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rsygvx(mplapackint const itype, const char *jobz, const char *range, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 const vl, _Float128 const vu, mplapackint const il, mplapackint const iu, _Float128 const abstol, mplapackint &m, _Float128 *w, _Float128 *z, mplapackint const ldz, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint *ifail, mplapackint &info);
void Rsyrfs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *af, mplapackint const ldaf, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rsysv(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsysv_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsysv_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, _Float128 *b, mplapackint const ldb, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsysv_rk(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *e, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsysv_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsysvx(const char *fact, const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *af, mplapackint const ldaf, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 &rcond, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rsyswapr(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint const i1, mplapackint const i2);
void Rsytd2(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *d, _Float128 *e, _Float128 *tau, mplapackint &info);
void Rsytf2(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rsytf2_rk(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *e, mplapackint *ipiv, mplapackint &info);
void Rsytf2_rook(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, mplapackint &info);
void Rsytrd(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *d, _Float128 *e, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_2stage(const char *vect, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *d, _Float128 *e, _Float128 *tau, _Float128 *hous2, mplapackint const lhous2, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_sb2st(const char *stage1, const char *vect, const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, _Float128 *d, _Float128 *e, _Float128 *hous, mplapackint const lhous, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsytrd_sy2sb(const char *uplo, mplapackint const n, mplapackint const kd, _Float128 *a, mplapackint const lda, _Float128 *ab, mplapackint const ldab, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsytrf(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_aa(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_aa_2stage(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_rk(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *e, mplapackint *ipiv, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsytrf_rook(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsytri(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *work, mplapackint &info);
void Rsytri2(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsytri2x(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *work, mplapackint const nb, mplapackint &info);
void Rsytri_3(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *e, mplapackint *ipiv, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsytri_3x(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *e, mplapackint *ipiv, _Float128 *work, mplapackint const nb, mplapackint &info);
void Rsytri_rook(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *work, mplapackint &info);
void Rsytrs(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rsytrs2(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *work, mplapackint &info);
void Rsytrs_3(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *e, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rsytrs_aa(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rsytrs_aa_2stage(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *tb, mplapackint const ltb, mplapackint *ipiv, mplapackint *ipiv2, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rsytrs_rook(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, mplapackint *ipiv, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rtbcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, _Float128 *ab, mplapackint const ldab, _Float128 &rcond, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rtbrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float128 *ab, mplapackint const ldab, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rtbtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float128 *ab, mplapackint const ldab, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rtfsm(const char *transr, const char *side, const char *uplo, const char *trans, const char *diag, mplapackint const m, mplapackint const n, _Float128 const alpha, _Float128 *a, _Float128 *b, mplapackint const ldb);
void Rtftri(const char *transr, const char *uplo, const char *diag, mplapackint const n, _Float128 *a, mplapackint &info);
void Rtfttp(const char *transr, const char *uplo, mplapackint const n, _Float128 *arf, _Float128 *ap, mplapackint &info);
void Rtfttr(const char *transr, const char *uplo, mplapackint const n, _Float128 *arf, _Float128 *a, mplapackint const lda, mplapackint &info);
void Rtgevc(const char *side, const char *howmny, bool *select, mplapackint const n, _Float128 *s, mplapackint const lds, _Float128 *p, mplapackint const ldp, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, _Float128 *work, mplapackint &info);
void Rtgex2(bool const wantq, bool const wantz, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *q, mplapackint const ldq, _Float128 *z, mplapackint const ldz, mplapackint const j1, mplapackint const n1, mplapackint const n2, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rtgexc(bool const wantq, bool const wantz, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *q, mplapackint const ldq, _Float128 *z, mplapackint const ldz, mplapackint &ifst, mplapackint &ilst, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rtgsen(mplapackint const ijob, bool const wantq, bool const wantz, bool *select, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *alphar, _Float128 *alphai, _Float128 *beta, _Float128 *q, mplapackint const ldq, _Float128 *z, mplapackint const ldz, mplapackint &m, _Float128 &pl, _Float128 &pr, _Float128 *dif, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rtgsja(const char *jobu, const char *jobv, const char *jobq, mplapackint const m, mplapackint const p, mplapackint const n, mplapackint const k, mplapackint const l, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 const tola, _Float128 const tolb, _Float128 *alpha, _Float128 *beta, _Float128 *u, mplapackint const ldu, _Float128 *v, mplapackint const ldv, _Float128 *q, mplapackint const ldq, _Float128 *work, mplapackint &ncycle, mplapackint &info);
void Rtgsna(const char *job, const char *howmny, bool *select, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, _Float128 *s, _Float128 *dif, mplapackint const mm, mplapackint &m, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rtgsy2(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *c, mplapackint const ldc, _Float128 *d, mplapackint const ldd, _Float128 *e, mplapackint const lde, _Float128 *f, mplapackint const ldf, _Float128 &scale, _Float128 &rdsum, _Float128 &rdscal, mplapackint *iwork, mplapackint &pq, mplapackint &info);
void Rtgsyl(const char *trans, mplapackint const ijob, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *c, mplapackint const ldc, _Float128 *d, mplapackint const ldd, _Float128 *e, mplapackint const lde, _Float128 *f, mplapackint const ldf, _Float128 &scale, _Float128 &dif, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rtpcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, _Float128 *ap, _Float128 &rcond, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rtplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *t, mplapackint const ldt, _Float128 *work, mplapackint &info);
void Rtplqt2(mplapackint const m, mplapackint const n, mplapackint const l, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *t, mplapackint const ldt, mplapackint &info);
void Rtpmlqt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const mb, _Float128 *v, mplapackint const ldv, _Float128 *t, mplapackint const ldt, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *work, mplapackint &info);
void Rtpmqrt(const char *side, const char *trans, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, mplapackint const nb, _Float128 *v, mplapackint const ldv, _Float128 *t, mplapackint const ldt, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *work, mplapackint &info);
void Rtpqrt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *t, mplapackint const ldt, _Float128 *work, mplapackint &info);
void Rtpqrt2(mplapackint const m, mplapackint const n, mplapackint const l, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *t, mplapackint const ldt, mplapackint &info);
void Rtprfb(const char *side, const char *trans, const char *direct, const char *storev, mplapackint const m, mplapackint const n, mplapackint const k, mplapackint const l, _Float128 *v, mplapackint const ldv, _Float128 *t, mplapackint const ldt, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *work, mplapackint const ldwork);
void Rtprfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float128 *ap, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rtptri(const char *uplo, const char *diag, mplapackint const n, _Float128 *ap, mplapackint &info);
void Rtptrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float128 *ap, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rtpttf(const char *transr, const char *uplo, mplapackint const n, _Float128 *ap, _Float128 *arf, mplapackint &info);
void Rtpttr(const char *uplo, mplapackint const n, _Float128 *ap, _Float128 *a, mplapackint const lda, mplapackint &info);
void Rtrcon(const char *norm, const char *uplo, const char *diag, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 &rcond, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rtrevc(const char *side, const char *howmny, bool *select, mplapackint const n, _Float128 *t, mplapackint const ldt, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, _Float128 *work, mplapackint &info);
void Rtrevc3(const char *side, const char *howmny, bool *select, mplapackint const n, _Float128 *t, mplapackint const ldt, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, mplapackint const mm, mplapackint &m, _Float128 *work, mplapackint const lwork, mplapackint &info);
void Rtrexc(const char *compq, mplapackint const n, _Float128 *t, mplapackint const ldt, _Float128 *q, mplapackint const ldq, mplapackint &ifst, mplapackint &ilst, _Float128 *work, mplapackint &info);
void Rtrrfs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *x, mplapackint const ldx, _Float128 *ferr, _Float128 *berr, _Float128 *work, mplapackint *iwork, mplapackint &info);
void Rtrsen(const char *job, const char *compq, bool *select, mplapackint const n, _Float128 *t, mplapackint const ldt, _Float128 *q, mplapackint const ldq, _Float128 *wr, _Float128 *wi, mplapackint &m, _Float128 &s, _Float128 &sep, _Float128 *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, mplapackint &info);
void Rtrsna(const char *job, const char *howmny, bool *select, mplapackint const n, _Float128 *t, mplapackint const ldt, _Float128 *vl, mplapackint const ldvl, _Float128 *vr, mplapackint const ldvr, _Float128 *s, _Float128 *sep, mplapackint const mm, mplapackint &m, _Float128 *work, mplapackint const ldwork, mplapackint *iwork, mplapackint &info);
void Rtrsyl(const char *trana, const char *tranb, mplapackint const isgn, mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, _Float128 *c, mplapackint const ldc, _Float128 &scale, mplapackint &info);
void Rtrti2(const char *uplo, const char *diag, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint &info);
void Rtrtri(const char *uplo, const char *diag, mplapackint const n, _Float128 *a, mplapackint const lda, mplapackint &info);
void Rtrtrs(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float128 *a, mplapackint const lda, _Float128 *b, mplapackint const ldb, mplapackint &info);
void Rtrttf(const char *transr, const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *arf, mplapackint &info);
void Rtrttp(const char *uplo, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *ap, mplapackint &info);
void Rtzrzf(mplapackint const m, mplapackint const n, _Float128 *a, mplapackint const lda, _Float128 *tau, _Float128 *work, mplapackint const lwork, mplapackint &info);
void iMlaver__Float128(mplapackint &mplapack_ver_major, mplapackint &mplapack_ver_minor, mplapackint &mplapack_ver_patch, mplapackint &lapack_ver_major, mplapackint &lapack_ver_minor, mplapackint &lapack_ver_patch);
#endif
