/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.util;

public class BitUtils {
    public static byte encodeBooleansToByte(boolean ... booleans) {
        if (booleans.length > 8) {
            throw new IllegalArgumentException("Max 8 input parameters. You put " + booleans.length + " here.");
        }
        byte result = 0;
        for (int i = 0; i < booleans.length; ++i) {
            if (!booleans[i]) continue;
            result = (byte)(result | 1 << i);
        }
        return result;
    }

    public static boolean[] decodeBooleansFromByte(byte b) {
        boolean[] result = new boolean[8];
        int unsignedByte = b & 0xFF;
        for (int i = 0; i < 8; ++i) {
            result[i] = (unsignedByte & 1 << i) != 0;
        }
        return result;
    }

    public static boolean getBooleanDecodeFromByte(byte b, int bitIndex) {
        if (bitIndex < 0 || bitIndex > 7) {
            throw new IllegalArgumentException("Index should be in 0 - 7 , you input " + bitIndex + " here.");
        }
        int unsignedByte = b & 0xFF;
        return (unsignedByte & 1 << bitIndex) != 0;
    }
}

