/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.WirelessDataNetWork;

import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic_t.TeamManager;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import java.util.HashMap;
import tectech.mechanics.dataTransport.QuantumDataPacket;

public class WirelessDataPacket {
    public static HashMap<String, WirelessDataPacket> TeamWirelessData = new HashMap();
    public boolean wirelessEnabled = false;
    public long latestActivatedAstralArray = -1000000L;
    public long[] latestUpload = new long[20];
    public long[] latestDownload = new long[20];
    public final long[] previewUploaded = new long[20];
    public final long[] previewDownloaded = new long[20];
    public Vec3Impl controllerPosition = null;
    public int loopTags = 0;

    private QuantumDataPacket download(long dataIn) {
        long time = System.currentTimeMillis();
        if (!this.wirelessEnabled || Math.abs(time - this.latestActivatedAstralArray) > 10000L || this.controllerPosition == null) {
            return new QuantumDataPacket(Long.valueOf(0L));
        }
        int n = this.loopTags;
        this.latestDownload[n] = this.latestDownload[n] + dataIn;
        double totalRequired = 1.0;
        double totalUploaded = 1.0;
        for (int i = 0; i < 20; ++i) {
            totalRequired += (double)this.latestDownload[i];
            totalUploaded += (double)this.latestUpload[i];
        }
        long result = (long)(Math.min(1.0, totalUploaded / totalRequired) * (double)dataIn);
        return new QuantumDataPacket(Long.valueOf(result)).unifyTraceWith(new Vec3Impl[]{this.controllerPosition});
    }

    private void update(IGregTechTileEntity entity, long aTick) {
        this.latestActivatedAstralArray = System.currentTimeMillis();
        int n = this.loopTags = (this.loopTags + 1) % 20;
        this.latestUpload[n] = this.latestUpload[n] - this.previewUploaded[this.loopTags];
        int n2 = this.loopTags;
        this.latestDownload[n2] = this.latestDownload[n2] - this.previewDownloaded[this.loopTags];
        this.previewUploaded[this.loopTags] = this.latestUpload[this.loopTags];
        this.previewDownloaded[this.loopTags] = this.latestDownload[this.loopTags];
        double totalRequired = 1.0;
        double totalUploaded = 1.0;
        for (int i = 0; i < 20; ++i) {
            totalRequired += (double)this.latestDownload[i];
            totalUploaded += (double)this.latestUpload[i];
        }
    }

    private void setWirelessEnabled(boolean wirelessEnabled) {
        this.wirelessEnabled = wirelessEnabled;
    }

    private void upload(long dataOut) {
        long time = System.currentTimeMillis();
        if (!this.wirelessEnabled || Math.abs(time - this.latestActivatedAstralArray) > 10000L) {
            return;
        }
        int n = this.loopTags;
        this.latestUpload[n] = this.latestUpload[n] + dataOut;
    }

    public static QuantumDataPacket downloadData(String userId, long dataIn) {
        return WirelessDataPacket.getPacketByUserId(userId).download(dataIn);
    }

    public static void uploadData(String userId, long dataOut) {
        WirelessDataPacket.getPacketByUserId(userId).upload(dataOut);
    }

    public static void updatePacket(IGregTechTileEntity entity, long aTick) {
        WirelessDataPacket.getPacketByUserId(entity.getOwnerName()).update(entity, aTick);
    }

    public static boolean enableWirelessNetWork(IGregTechTileEntity entity) {
        WirelessDataPacket packet = WirelessDataPacket.getPacketByUserId(entity.getOwnerName());
        Vec3Impl pos = new Vec3Impl(entity.getXCoord(), (int)entity.getYCoord(), entity.getZCoord());
        if (packet.wirelessEnabled && packet.controllerPosition != null && pos.compareTo(packet.controllerPosition) != 0) {
            return false;
        }
        WirelessDataPacket.getPacketByUserId(entity.getOwnerName()).setWirelessEnabled(true);
        if (packet.controllerPosition == null) {
            packet.controllerPosition = new Vec3Impl(entity.getXCoord(), (int)entity.getYCoord(), entity.getZCoord());
        }
        return true;
    }

    public static void disableWirelessNetWork(IGregTechTileEntity entity) {
        WirelessDataPacket packet = WirelessDataPacket.getPacketByUserId(entity.getOwnerName());
        Vec3Impl pos = new Vec3Impl(entity.getXCoord(), (int)entity.getYCoord(), entity.getZCoord());
        if (packet.controllerPosition != null && packet.controllerPosition.compareTo(pos) != 0) {
            return;
        }
        WirelessDataPacket.getPacketByUserId(entity.getOwnerName()).setWirelessEnabled(false);
    }

    public static WirelessDataPacket getPacketByUserId(String userId) {
        String team = TeamManager.getOrCreatTeam(userId);
        if (TeamWirelessData.get(team) == null) {
            TeamWirelessData.put(team, new WirelessDataPacket());
        }
        return TeamWirelessData.get(team);
    }
}

