/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.RecipePattern;

import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.helpers.PatternHelper;
import appeng.util.item.AEItemStack;
import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.system.RecipePattern.IRecipeProvider;
import com.Nxer.TwistSpaceTechnology.system.RecipePattern.RecipeMatcher;
import com.glodblock.github.common.item.ItemFluidPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class CustomCraftRecipe
implements IRecipeProvider {
    private static final Random random = new Random();
    private final double[] itemPriority;
    private final double[] fluidPriority;
    private int rounds = 0;
    private String provider = "none";
    private static final String NONEPROVIDER = "none";
    public IAEItemStack[] inputs = null;
    public IAEItemStack[] outputs = null;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomCraftRecipe that = (CustomCraftRecipe)o;
        return Arrays.equals(this.getItemPriority(), that.getItemPriority()) && Arrays.equals(this.getFluidPriority(), that.getFluidPriority()) && Objects.equals(this.getProvider(), that.getProvider()) && Arrays.equals(this.getInputs(), that.getInputs()) && Arrays.equals(this.getOutputs(), that.getOutputs());
    }

    public int hashCode() {
        int result = Objects.hash(this.getProvider());
        result = 31 * result + CustomCraftRecipe.rehashAEItemstacks(this.getInputs());
        return result;
    }

    public static int rehashAEItemstacks(IAEItemStack[] stack) {
        int result = 31;
        if (stack != null) {
            for (IAEItemStack item : stack) {
                result = 31 * result + CustomCraftRecipe.rehashAEItemstack(item);
            }
        }
        return result;
    }

    public static int rehashAEItemstack(IAEItemStack itemstack) {
        return (int)((long)(961 * itemstack.getItemStack().func_77977_a().hashCode()) + 31L * itemstack.getStackSize() + (long)itemstack.getItem().getDamage(itemstack.getItemStack()));
    }

    public CustomCraftRecipe(ItemStack[] inputItem, FluidStack[] inputFluid, ItemStack[] outputItem, FluidStack[] outputFluid, double[] itemPriority, double[] fluidPriority, int rounds, String provider) {
        this.provider = provider;
        if (inputItem == null) {
            inputItem = new ItemStack[]{};
        }
        if (inputFluid == null) {
            inputFluid = new FluidStack[]{};
        }
        if (outputItem == null) {
            outputItem = new ItemStack[]{};
        }
        if (outputFluid == null) {
            outputFluid = new FluidStack[]{};
        }
        this.setInputs(CustomCraftRecipe.combineAnyStackList(inputFluid, inputItem));
        this.setOutputs(CustomCraftRecipe.combineAnyStackList(outputFluid, outputItem));
        this.itemPriority = itemPriority;
        this.fluidPriority = fluidPriority;
        this.rounds = rounds;
        this.DEBUG_PRINT();
    }

    public CustomCraftRecipe(IAEItemStack[] in, IAEItemStack[] out, double[] itemPriority, double[] fluidPriority, int rounds, String provider) {
        this.setInputs(in);
        this.setOutputs(out);
        this.itemPriority = itemPriority;
        this.fluidPriority = fluidPriority;
        this.rounds = rounds;
        this.provider = provider;
    }

    public CustomCraftRecipe copy() {
        return new CustomCraftRecipe(this.inputs, this.outputs, this.itemPriority, this.fluidPriority, 0, this.provider);
    }

    public CustomCraftRecipe setRounds(int rounds) {
        this.rounds = rounds;
        return this;
    }

    private void DEBUG_PRINT() {
        TwistSpaceTechnology.LOG.info("--------------------------------------------");
        TwistSpaceTechnology.LOG.info("REGISTER CUSTOM RECIPE:");
        TwistSpaceTechnology.LOG.info("PROVIDER: " + this.provider);
        TwistSpaceTechnology.LOG.info("INPUT ITEMS:");
        if (this.inputs == null) {
            TwistSpaceTechnology.LOG.info("NULL");
        } else {
            for (IAEItemStack items : this.inputs) {
                TwistSpaceTechnology.LOG.info(items.getItem().func_77658_a() + "." + items.getItem().getDamage(items.getItemStack()) + " " + items.getStackSize());
            }
        }
        TwistSpaceTechnology.LOG.info("OUTPUT ITEMS:");
        if (this.outputs == null) {
            TwistSpaceTechnology.LOG.info("NULL");
        } else {
            for (IAEItemStack items : this.outputs) {
                TwistSpaceTechnology.LOG.info(items.getItem().func_77658_a() + "." + items.getItem().getDamage(items.getItemStack()) + " " + items.getStackSize());
            }
        }
        TwistSpaceTechnology.LOG.info("--------------------------------------------");
    }

    @Override
    public String provider() {
        return this.provider;
    }

    public static IAEItemStack[] combineAnyStackList(IAEItemStack[] a, IAEItemStack[] b) {
        IAEItemStack stack;
        int n;
        if (a == null) {
            a = new IAEItemStack[]{};
        }
        if (b == null) {
            b = new IAEItemStack[]{};
        }
        IAEItemStack[] list = new IAEItemStack[a.length + b.length];
        int i = 0;
        IAEItemStack[] iAEItemStackArray = a;
        int n2 = iAEItemStackArray.length;
        for (n = 0; n < n2; ++n) {
            list[i] = stack = iAEItemStackArray[n];
            ++i;
        }
        iAEItemStackArray = b;
        n2 = iAEItemStackArray.length;
        for (n = 0; n < n2; ++n) {
            list[i] = stack = iAEItemStackArray[n];
            ++i;
        }
        return list;
    }

    public static ArrayList<ItemStack> mergeItemstacks(ItemStack[] stack) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack item : stack) {
            if (item == null || item.func_77973_b() == null || item.field_77994_a == 0) continue;
            boolean flag = false;
            for (int i = 0; i < result.size(); ++i) {
                ItemStack inv = result.get(i).func_77946_l();
                if (!CustomCraftRecipe.areStacksEqual(inv, item, true)) continue;
                inv.field_77994_a += item.field_77994_a;
                result.set(i, inv);
                flag = true;
            }
            if (flag) continue;
            result.add(item);
        }
        return result;
    }

    public static Object[] mergeItemstacks(Object[] stack) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object it : stack) {
            int i;
            if (it instanceof ItemStack) {
                ItemStack item = (ItemStack)it;
                if (item.func_77973_b() == null || item.field_77994_a == 0) continue;
                boolean flag = false;
                for (i = 0; i < result.size(); ++i) {
                    ItemStack inv;
                    Object e = result.get(i);
                    if (!(e instanceof ItemStack) || !CustomCraftRecipe.areStacksEqual(inv = (ItemStack)e, item, true)) continue;
                    inv.field_77994_a += item.field_77994_a;
                    result.set(i, inv);
                    flag = true;
                    break;
                }
                if (flag) continue;
                result.add(item.func_77946_l());
                continue;
            }
            if (it instanceof ArrayList) {
                ArrayList itemStacks = (ArrayList)it;
                if (itemStacks.size() == 1) {
                    result.add(itemStacks.get(0));
                    continue;
                }
                ItemStack[] warped = new ItemStack[itemStacks.size()];
                for (i = 0; i < itemStacks.size(); ++i) {
                    warped[i] = (ItemStack)itemStacks.get(i);
                }
                result.add(warped);
                continue;
            }
            if (it == null) continue;
            result.add(it);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.stream().filter(Objects::nonNull).toArray();
    }

    public static boolean areStacksEqual(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return !(aStack1 == null || aStack2 == null || aStack1.func_77973_b() != aStack2.func_77973_b() || !aIgnoreNBT && (aStack1.func_77978_p() == null != (aStack2.func_77978_p() == null) || aStack1.func_77978_p() != null && !aStack1.func_77978_p().equals((Object)aStack2.func_77978_p())) || Items.field_151008_G.getDamage(aStack1) != Items.field_151008_G.getDamage(aStack2) && Items.field_151008_G.getDamage(aStack1) != Short.MAX_VALUE && Items.field_151008_G.getDamage(aStack2) != Short.MAX_VALUE);
    }

    public static IAEItemStack[] combineAnyStackList(IAEItemStack[] a, ItemStack[] b) {
        return CustomCraftRecipe.combineAnyStackList(a, (IAEItemStack[])Arrays.stream(b).map(AEItemStack::create).toArray(IAEItemStack[]::new));
    }

    public static IAEItemStack[] combineAnyStackList(IAEItemStack[] a, FluidStack[] b) {
        return CustomCraftRecipe.combineAnyStackList(a, (IAEItemStack[])Arrays.stream(b).map(stack -> AEItemStack.create((ItemStack)ItemFluidPacket.newStack((FluidStack)stack))).toArray(IAEItemStack[]::new));
    }

    public static IAEItemStack[] combineAnyStackList(ItemStack[] a, ItemStack[] b) {
        return CustomCraftRecipe.combineAnyStackList((IAEItemStack[])Arrays.stream(a).map(AEItemStack::create).toArray(IAEItemStack[]::new), (IAEItemStack[])Arrays.stream(b).map(AEItemStack::create).toArray(IAEItemStack[]::new));
    }

    public static IAEItemStack[] combineAnyStackList(FluidStack[] a, FluidStack[] b) {
        return CustomCraftRecipe.combineAnyStackList((IAEItemStack[])Arrays.stream(a).map(stack -> AEItemStack.create((ItemStack)ItemFluidPacket.newStack((FluidStack)stack))).toArray(IAEItemStack[]::new), (IAEItemStack[])Arrays.stream(b).map(stack -> AEItemStack.create((ItemStack)ItemFluidPacket.newStack((FluidStack)stack))).toArray(IAEItemStack[]::new));
    }

    public static IAEItemStack[] combineAnyStackList(ItemStack[] a, FluidStack[] b) {
        return CustomCraftRecipe.combineAnyStackList((IAEItemStack[])Arrays.stream(a).map(AEItemStack::create).toArray(IAEItemStack[]::new), (IAEItemStack[])Arrays.stream(b).map(stack -> AEItemStack.create((ItemStack)ItemFluidPacket.newStack((FluidStack)stack))).toArray(IAEItemStack[]::new));
    }

    public static IAEItemStack[] combineAnyStackList(FluidStack[] a, ItemStack[] b) {
        return CustomCraftRecipe.combineAnyStackList(b, a);
    }

    public static FluidStack convertAEItemToFluid(IAEItemStack stack) {
        ItemStack fluidPacket = stack.getItemStack();
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidPacket.func_77978_p());
    }

    public boolean setInputs(IAEItemStack[] stack) {
        if (stack.length == 0) {
            return false;
        }
        this.inputs = (IAEItemStack[])Arrays.stream(stack).filter(Objects::nonNull).sorted(RecipeMatcher::compareAEItemStack).toArray(IAEItemStack[]::new);
        return true;
    }

    public boolean setOutputs(IAEItemStack[] stack) {
        IAEItemStack[] condensed = PatternHelper.convertToCondensedList((IAEItemStack[])stack);
        if (condensed.length == 0) {
            return false;
        }
        this.outputs = (IAEItemStack[])Arrays.stream(stack).filter(Objects::nonNull).sorted(RecipeMatcher::compareAEItemStack).toArray(IAEItemStack[]::new);
        return true;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Override
    public ItemStack[] getItemInput() {
        return (ItemStack[])Arrays.stream(this.inputs).filter(IAEStack::isItem).map(IAEItemStack::getItemStack).toArray(ItemStack[]::new);
    }

    @Override
    public FluidStack[] getFluidInput() {
        return (FluidStack[])Arrays.stream(this.inputs).filter(IAEStack::isFluid).map(CustomCraftRecipe::convertAEItemToFluid).toArray(FluidStack[]::new);
    }

    @Override
    public ItemStack[] getItemOutput() {
        return (ItemStack[])Arrays.stream(this.outputs).filter(IAEStack::isItem).map(IAEItemStack::getItemStack).toArray(ItemStack[]::new);
    }

    @Override
    public FluidStack[] getFluidOutput() {
        return (FluidStack[])Arrays.stream(this.outputs).filter(IAEStack::isFluid).map(CustomCraftRecipe::convertAEItemToFluid).toArray(FluidStack[]::new);
    }

    @Override
    public long getRecipeProcessRounds() {
        return this.rounds;
    }

    @Override
    public double[] getItemOutputPriority() {
        return this.itemPriority;
    }

    @Override
    public double[] getFluidOutputPriority() {
        return this.fluidPriority;
    }

    @Override
    public ItemStack[] getRealItemOutput() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ItemStack[] OutputItem = this.getItemOutput();
        for (int i = 0; i < OutputItem.length; ++i) {
            long outputs;
            if (!((double)random.nextInt(100) / 100.0 < this.itemPriority[i])) continue;
            for (outputs = (long)this.rounds * (long)OutputItem[i].field_77994_a; outputs >= Integer.MAX_VALUE; outputs -= Integer.MAX_VALUE) {
                result.add(new ItemStack(OutputItem[i].func_77973_b(), Integer.MAX_VALUE));
            }
            if (outputs == 0L) continue;
            result.add(new ItemStack(OutputItem[i].func_77973_b(), (int)outputs));
        }
        return result.toArray(new ItemStack[0]);
    }

    @Override
    public FluidStack[] getRealFluidOutput() {
        ArrayList<FluidStack> result = new ArrayList<FluidStack>();
        FluidStack[] OutputFluid = this.getFluidOutput();
        for (int i = 0; i < OutputFluid.length; ++i) {
            long outputs;
            if (!((double)random.nextInt(100) / 100.0 < this.itemPriority[i])) continue;
            for (outputs = (long)this.rounds * (long)OutputFluid[i].amount; outputs >= Integer.MAX_VALUE; outputs -= Integer.MAX_VALUE) {
                result.add(new FluidStack(OutputFluid[i].getFluid(), Integer.MAX_VALUE));
            }
            if (outputs == 0L) continue;
            result.add(new FluidStack(OutputFluid[i].getFluid(), (int)outputs));
        }
        return result.toArray(new FluidStack[0]);
    }

    public IAEItemStack[] getRealAEOutput() {
        ArrayList<IAEItemStack> result = new ArrayList<IAEItemStack>();
        for (int i = 0; i < this.outputs.length; ++i) {
            long output;
            if (!((double)random.nextInt(100) / 100.0 < this.itemPriority[i])) continue;
            for (output = (long)this.rounds * this.outputs[i].getStackSize(); output >= Integer.MAX_VALUE; output -= Integer.MAX_VALUE) {
                result.add((IAEItemStack)this.outputs[i].copy().setStackSize(Integer.MAX_VALUE));
            }
            if (output == 0L) continue;
            result.add((IAEItemStack)this.outputs[i].copy().setStackSize(output));
        }
        return result.toArray(new IAEItemStack[0]);
    }

    @Override
    public boolean matchRecipe(Object o) {
        return false;
    }

    @Override
    public void initRecipe() {
    }

    public double[] getItemPriority() {
        return this.itemPriority;
    }

    public double[] getFluidPriority() {
        return this.fluidPriority;
    }

    public String getProvider() {
        return this.provider;
    }

    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }
}

