/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic_t;

import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic_t.DysonSphereManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class TeamManager {
    private static final Map<String, String> User2Team = new HashMap<String, String>();
    private static final Map<String, List<String>> Team2Users = new HashMap<String, List<String>>();

    public static boolean joinUserTeam(String userName, String teamName) {
        if (!Team2Users.containsKey(teamName)) {
            return false;
        }
        String oldTeam = User2Team.put(userName, teamName);
        DysonSphereManager.dirty();
        if (oldTeam != null) {
            List<String> members = Team2Users.get(oldTeam);
            if (members == null) {
                return true;
            }
            members.remove(userName);
            if (members.isEmpty()) {
                Team2Users.remove(oldTeam);
            }
        }
        return true;
    }

    public static boolean hasTeam(String teamName) {
        return Team2Users.containsKey(teamName);
    }

    public static boolean userHasTeam(String user) {
        return User2Team.containsKey(user);
    }

    public static String getOrCreatTeam(String user) {
        String teamName;
        if (!User2Team.containsKey(user)) {
            teamName = user + "'s Team";
            User2Team.put(user, teamName);
            Team2Users.put(teamName, new ArrayList());
            Team2Users.get(teamName).add(user);
            DysonSphereManager.dirty();
        }
        if (Team2Users.containsKey(teamName = User2Team.get(user))) {
            return teamName;
        }
        Team2Users.put(teamName, new ArrayList());
        Team2Users.get(teamName).add(user);
        DysonSphereManager.dirty();
        return teamName;
    }

    public static void clear() {
        Team2Users.clear();
        User2Team.clear();
    }

    public static NBTTagCompound writeToNBT() {
        NBTTagCompound teaminfos = new NBTTagCompound();
        User2Team.forEach((name, teamName) -> {
            if (!teaminfos.func_74764_b(teamName)) {
                teaminfos.func_74782_a(teamName, (NBTBase)new NBTTagList());
            }
            teaminfos.func_150295_c(teamName, 8).func_74742_a((NBTBase)new NBTTagString(name));
        });
        return teaminfos;
    }

    public static void readFromNBT(NBTTagCompound teams) {
        teams.func_150296_c().forEach(name -> {
            NBTTagList members = teams.func_150295_c(name, 9);
            int count = members.func_74745_c();
            while (count-- > 0) {
                User2Team.put(members.func_150307_f(count), (String)name);
            }
        });
    }
}

