/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic_t;

import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic_t.Galaxy;
import java.util.HashMap;
import java.util.Map;

public class Planet {
    private static final Map<Integer, Planet> registeredPlanets = new HashMap<Integer, Planet>();
    private static final Planet Unknown = new Planet();
    public final double planetaryCoefficient;
    public final Galaxy dependentGalaxy;
    public final int dimensionID;

    private Planet() {
        this.dependentGalaxy = Galaxy.Unknown;
        this.planetaryCoefficient = 0.0;
        this.dimensionID = 0;
    }

    public Planet(int dimID, double planetaryCoefficient, Galaxy dependentGalaxy) {
        this.dimensionID = dimID;
        this.planetaryCoefficient = planetaryCoefficient;
        this.dependentGalaxy = dependentGalaxy;
        registeredPlanets.put(dimID, this);
    }

    public static Planet getPlanetFromDimID(int dimID) {
        Planet planet;
        if (dimID >= 180 && dimID != 227) {
            dimID = 0;
        }
        return (planet = registeredPlanets.get(dimID)) == null ? Unknown : planet;
    }

    public static double getPlanetaryCoefficientWithDimID(int dimID) {
        return Planet.getPlanetFromDimID(dimID).getDimensionID();
    }

    public Galaxy getDependentGalaxy() {
        return this.dependentGalaxy;
    }

    public double getPlanetaryCoefficient() {
        return this.planetaryCoefficient;
    }

    public int getDimensionID() {
        return this.dimensionID;
    }
}

