/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic.DSP_DataCell;
import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic.DSP_DataStorageMaps;
import com.Nxer.TwistSpaceTechnology.system.DysonSphereProgram.logic.DSP_Galaxy;
import gregtech.api.objects.XSTR;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class DSP_SolarSailDecreaser {
    public static DSP_SolarSailDecreaser INSTANCE;
    private final Set<DSP_DataCell> dataCell = new HashSet<DSP_DataCell>();
    private int catchedAmountDSP;
    private int tick = 0;

    public DSP_SolarSailDecreaser() {
        this.reloadDSPs();
    }

    public static void init() {
        INSTANCE = new DSP_SolarSailDecreaser();
    }

    public void onTick() {
        ++this.tick;
        if (this.tick >= 36000) {
            this.checkFlushed().tryDecrease();
        }
    }

    private void tryDecrease() {
        this.tick = 0;
        if (1 == XSTR.XSTR_INSTANCE.nextInt(5000)) {
            for (DSP_DataCell dsp : this.dataCell) {
                if (1 != XSTR.XSTR_INSTANCE.nextInt(4)) continue;
                this.decreaseSolarSail(dsp);
            }
        }
    }

    private void decreaseSolarSail(DSP_DataCell dsp) {
        if (dsp.getSolarSailToDelete() < 1L) {
            return;
        }
        dsp.addDSPSolarSail(-dsp.getSolarSailToDelete() / 2L);
    }

    public DSP_SolarSailDecreaser checkFlushed() {
        int sizeSum = 0;
        for (HashMap<DSP_Galaxy, DSP_DataCell> dsps : DSP_DataStorageMaps.DysonSpheres.values()) {
            sizeSum += dsps.size();
        }
        if (sizeSum != this.catchedAmountDSP) {
            TwistSpaceTechnology.LOG.info("Flush DSP SolarSailDecreaser.");
            this.reloadDSPs();
            this.catchedAmountDSP = sizeSum;
        }
        return this;
    }

    public void reloadDSPs() {
        for (HashMap<DSP_Galaxy, DSP_DataCell> DSPs : DSP_DataStorageMaps.DysonSpheres.values()) {
            this.dataCell.addAll(DSPs.values());
        }
    }
}

