/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.recipe.machineRecipe.expanded;

import bartworks.system.material.WerkstoffLoader;
import cofh.lib.util.helpers.FluidHelper;
import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import com.Nxer.TwistSpaceTechnology.util.enums.TierEU;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import com.google.common.collect.Sets;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class StellarForgeRecipePool {
    public static final HashSet<String> IngotHotOreDictNames = new HashSet();
    public static final HashSet<String> IngotOreDictNames = new HashSet();
    public static final HashSet<TST_ItemID> IngotHots = new HashSet();
    public static final HashSet<TST_ItemID> Ingots = new HashSet();
    public static final HashMap<TST_ItemID, ItemStack> IngotHotToIngot = new HashMap();
    public static final HashSet<TST_ItemID> SpecialRecipeOutputs = new HashSet();
    public static final HashMap<Fluid, ItemStack> MoltenToIngot = new HashMap();
    public static Collection<GTRecipe> stellarForgeRecipeListCache;

    private static boolean itemStackArrayEqualFuzzy(ItemStack[] isa1, ItemStack[] isa2) {
        if (isa1.length != isa2.length) {
            return false;
        }
        for (ItemStack itemStack1 : isa1) {
            boolean flag = false;
            for (ItemStack itemStack2 : isa2) {
                if (!GTUtility.areStacksEqual((ItemStack)itemStack1, (ItemStack)itemStack2)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            return false;
        }
        return true;
    }

    private static boolean fluidStackEqualFuzzy(FluidStack[] fsa1, FluidStack[] fsa2) {
        if (fsa1.length != fsa2.length) {
            return false;
        }
        for (FluidStack fluidStack1 : fsa1) {
            boolean flag = false;
            for (FluidStack fluidStack2 : fsa2) {
                if (!GTUtility.areFluidsEqual((FluidStack)fluidStack1, (FluidStack)fluidStack2)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            return false;
        }
        return true;
    }

    public static void initData() {
        for (String name : OreDictionary.getOreNames()) {
            if (name.startsWith("ingotHot")) {
                IngotHotOreDictNames.add(name);
                for (ItemStack items : OreDictionary.getOres((String)name)) {
                    IngotHots.add(TST_ItemID.createNoNBT(items));
                }
                continue;
            }
            if (!name.startsWith("ingot")) continue;
            IngotOreDictNames.add(name);
            for (ItemStack items : OreDictionary.getOres((String)name)) {
                Ingots.add(TST_ItemID.createNoNBT(items));
            }
        }
        for (GTRecipe recipeFreezer : RecipeMaps.vacuumFreezerRecipes.getAllRecipes()) {
            if (recipeFreezer.mInputs == null || recipeFreezer.mInputs.length < 1 || recipeFreezer.mOutputs == null || recipeFreezer.mOutputs.length < 1) continue;
            ItemStack input = recipeFreezer.mInputs[0].func_77946_l();
            ItemStack outputIngot = recipeFreezer.mOutputs[0].func_77946_l();
            IngotHotToIngot.put(TST_ItemID.createNoNBT(input), outputIngot);
        }
        SpecialRecipeOutputs.add(TST_ItemID.create(WerkstoffLoader.CubicZirconia.get(OrePrefixes.gemFlawed, 1)));
        SpecialRecipeOutputs.add(TST_ItemID.create(Materials.MeteoricIron.getIngots(1)));
        SpecialRecipeOutputs.add(TST_ItemID.create(Materials.MeteoricSteel.getIngots(1)));
        SpecialRecipeOutputs.add(TST_ItemID.create(GTModHandler.getModItem((String)"gregtech", (String)"gt.metaitem.01", (long)1L, (int)12129)));
        for (GTRecipe recipeSolidifier : RecipeMaps.fluidSolidifierRecipes.getAllRecipes()) {
            if (recipeSolidifier.mInputs == null || recipeSolidifier.mInputs.length < 1 || recipeSolidifier.mOutputs == null || recipeSolidifier.mOutputs.length < 1) continue;
            if (GTUtility.areStacksEqual((ItemStack)GTModHandler.getModItem((String)Mods.GregTech.ID, (String)"gt.metaitem.01", (long)1L, (int)32306), (ItemStack)recipeSolidifier.mInputs[0]) && !FluidHelper.isFluidEqual((FluidStack)recipeSolidifier.mFluidInputs[0], (FluidStack)Materials.AnnealedCopper.getMolten(1L))) {
                MoltenToIngot.put(recipeSolidifier.mFluidInputs[0].getFluid(), recipeSolidifier.mOutputs[0]);
            }
            MoltenToIngot.put(Materials.AnnealedCopper.getMolten(1L).getFluid(), Materials.AnnealedCopper.getIngots(1));
        }
    }

    public static void prepareEBFRecipes() {
        HashSet protectionGas = Sets.newHashSet((Object[])new Fluid[]{Materials.Hydrogen.mGas, Materials.Oxygen.mGas, Materials.Nitrogen.mGas, WerkstoffLoader.Xenon.getFluidOrGas(1).getFluid(), WerkstoffLoader.Oganesson.getFluidOrGas(1).getFluid(), WerkstoffLoader.Krypton.getFluidOrGas(1).getFluid(), WerkstoffLoader.Neon.getFluidOrGas(1).getFluid(), Materials.Radon.mGas, Materials.Argon.mGas, Materials.Helium.mGas});
        for (GTRecipe recipe : RecipeMaps.blastFurnaceRecipes.getAllRecipes()) {
            if (recipe.mOutputs.length == 1 && SpecialRecipeOutputs.contains((Object)TST_ItemID.create(recipe.mOutputs[0]))) continue;
            ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
            ArrayList<FluidStack> inputFluids = new ArrayList<FluidStack>();
            ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
            ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
            AtomicReference<Integer> integrateNum = new AtomicReference<Integer>(0);
            Arrays.stream(recipe.mInputs).peek(input -> {
                if (GTUtility.areStacksEqual((ItemStack)input, (ItemStack)GTUtility.getIntegratedCircuit((int)1))) {
                    integrateNum.set(1);
                } else if (GTUtility.areStacksEqual((ItemStack)input, (ItemStack)GTUtility.getIntegratedCircuit((int)11))) {
                    integrateNum.set(11);
                }
            }).filter(Objects::nonNull).forEach(inputItems::add);
            for (ItemStack itemStack : recipe.mOutputs) {
                FluidStack fluidStack;
                TST_ItemID outputItemID = TST_ItemID.createNoNBT(itemStack);
                boolean isRecipeAdded = false;
                if (IngotHots.contains((Object)outputItemID)) {
                    ItemStack normalIngot = IngotHotToIngot.get((Object)outputItemID);
                    FluidStack fluidStack2 = StellarForgeRecipePool.getMoltenFluids(normalIngot, itemStack.field_77994_a);
                    if (fluidStack2 != null) {
                        outputFluids.add(fluidStack2);
                        isRecipeAdded = true;
                    }
                } else if (Ingots.contains((Object)outputItemID) && (fluidStack = StellarForgeRecipePool.getMoltenFluids(GTUtility.copyAmountUnsafe((int)1, (ItemStack)itemStack), itemStack.field_77994_a)) != null) {
                    outputFluids.add(fluidStack);
                    isRecipeAdded = true;
                }
                if (isRecipeAdded) continue;
                outputItems.add(GTUtility.copy((ItemStack)itemStack));
            }
            for (ItemStack itemStack : recipe.mFluidInputs) {
                if (protectionGas.contains(itemStack.getFluid())) continue;
                inputFluids.add(itemStack.copy());
            }
            for (ItemStack itemStack : recipe.mFluidOutputs) {
                outputFluids.add(itemStack.copy());
            }
            if (integrateNum.get() != 0 || inputItems.size() < 2) {
                inputItems.add(GTUtility.getIntegratedCircuit((int)1));
            }
            ItemStack[] inputItemsArray = inputItems.toArray(new ItemStack[0]);
            FluidStack[] outputFluidsArray = outputFluids.toArray(new FluidStack[0]);
            boolean canAddNewRecipe = true;
            int n = Math.max(1, recipe.mDuration / 3);
            if (integrateNum.get() != 0) {
                for (GTRecipe recipeCheck : GTCMRecipe.StellarForgeRecipes.getAllRecipes()) {
                    if (!StellarForgeRecipePool.itemStackArrayEqualFuzzy(recipeCheck.mInputs, inputItemsArray) || !StellarForgeRecipePool.fluidStackEqualFuzzy(recipeCheck.mFluidOutputs, outputFluidsArray)) continue;
                    canAddNewRecipe = false;
                    recipeCheck.mDuration = Math.min(recipeCheck.mDuration, n);
                    break;
                }
            }
            if (!canAddNewRecipe) continue;
            int InputItemLength = inputItemsArray.length;
            for (int i = 0; i < InputItemLength; ++i) {
                if (inputItemsArray[i].func_77973_b() != ItemList.Circuit_Integrated.getItem() || i == InputItemLength - 1) continue;
                ItemStack IntegratedCircuit = inputItemsArray[i];
                for (int j = i; j < InputItemLength - 1; ++j) {
                    inputItemsArray[j] = inputItemsArray[j + 1];
                }
                inputItemsArray[InputItemLength - 1] = IntegratedCircuit;
                break;
            }
            StellarForgeRecipePool.addToMiracleDoorRecipes(inputItemsArray, inputFluids.toArray(new FluidStack[0]), outputItems.toArray(new ItemStack[0]), outputFluidsArray, recipe.mEUt, Math.max(1, recipe.mDuration / 3), GTCMRecipe.StellarForgeRecipes);
        }
    }

    public static void prepareABSRecipes() {
        for (GTRecipe recipe : GTPPRecipeMaps.alloyBlastSmelterRecipes.getAllRecipes()) {
            FluidStack aFluidCopy;
            ItemStack aStackCopy;
            int minOutputFluidAmount = 144;
            for (FluidStack aOutputFluid : recipe.mFluidOutputs) {
                minOutputFluidAmount = Math.min(minOutputFluidAmount, aOutputFluid.amount);
            }
            ArrayList<ItemStack> inputItemList = new ArrayList<ItemStack>();
            ArrayList<ItemStack> outputItemList = new ArrayList<ItemStack>();
            ArrayList<FluidStack> inputFluidList = new ArrayList<FluidStack>();
            ArrayList<FluidStack> outputFluidList = new ArrayList<FluidStack>();
            ArrayList<FluidStack> outputFluidListTemp = new ArrayList<FluidStack>();
            int RecipeMultiplier = 1;
            if (minOutputFluidAmount < 144) {
                int CorrectFluidAmount = minOutputFluidAmount;
                while (CorrectFluidAmount % 144 != 0) {
                    CorrectFluidAmount += minOutputFluidAmount;
                }
                RecipeMultiplier = CorrectFluidAmount / minOutputFluidAmount;
            }
            if (recipe.mInputs != null) {
                for (ItemStack aItemStack : recipe.mInputs) {
                    aStackCopy = aItemStack.func_77946_l();
                    aStackCopy.field_77994_a *= RecipeMultiplier;
                    inputItemList.add(aStackCopy);
                }
            }
            if (recipe.mFluidInputs != null) {
                for (FluidStack aFluidStack : recipe.mFluidInputs) {
                    aFluidCopy = aFluidStack.copy();
                    aFluidCopy.amount *= RecipeMultiplier;
                    inputFluidList.add(aFluidCopy);
                }
            }
            if (recipe.mOutputs != null) {
                for (ItemStack aItemStack : recipe.mOutputs) {
                    if (StellarForgeRecipePool.getMoltenFluids(aItemStack, 1) != null) {
                        outputFluidListTemp.add(StellarForgeRecipePool.getMoltenFluids(aItemStack, aItemStack.field_77994_a));
                        continue;
                    }
                    aStackCopy = aItemStack.func_77946_l();
                    aStackCopy.field_77994_a *= RecipeMultiplier;
                    outputItemList.add(aStackCopy);
                }
            }
            if (recipe.mOutputs != null) {
                for (FluidStack aFluidStack : recipe.mFluidOutputs) {
                    aFluidCopy = aFluidStack.copy();
                    aFluidCopy.amount *= RecipeMultiplier;
                    outputFluidListTemp.add(aFluidCopy);
                }
            }
            for (FluidStack aFluidTemp : outputFluidListTemp) {
                boolean isFluidRepetitious = false;
                for (FluidStack aFluidOut : outputFluidList) {
                    if (!GTUtility.areFluidsEqual((FluidStack)aFluidTemp, (FluidStack)aFluidOut)) continue;
                    aFluidOut.amount += aFluidTemp.amount;
                    isFluidRepetitious = true;
                }
                if (isFluidRepetitious) continue;
                outputFluidList.add(aFluidTemp);
            }
            for (int i = 0; i < inputItemList.size(); ++i) {
                if (((ItemStack)inputItemList.get(i)).func_77973_b() != ItemList.Circuit_Integrated.getItem() || i == 0) continue;
                ItemStack integratedCircuit = (ItemStack)inputItemList.remove(i);
                inputItemList.add(0, integratedCircuit);
                break;
            }
            StellarForgeRecipePool.addToMiracleDoorRecipes(inputItemList.toArray(new ItemStack[0]), inputFluidList.toArray(new FluidStack[0]), outputItemList.toArray(new ItemStack[0]), outputFluidList.toArray(new FluidStack[0]), recipe.mEUt, recipe.mDuration, GTCMRecipe.StellarForgeAlloySmelterRecipes);
        }
    }

    public static void addToMiracleDoorRecipes(ItemStack[] inputItems, FluidStack[] inputFluids, ItemStack[] outputItems, FluidStack[] outputFluids, int eut, int duration, IRecipeMap aRecipeMap) {
        GTRecipeBuilder ra = GTValues.RA.stdBuilder();
        if (inputItems != null && inputItems.length > 0) {
            ra.itemInputs(inputItems);
        }
        if (inputFluids != null && inputFluids.length > 0) {
            ra.fluidInputs(inputFluids);
        }
        if (outputItems != null && outputItems.length > 0) {
            ra.itemOutputs(outputItems);
        }
        if (outputFluids != null && outputFluids.length > 0) {
            ra.fluidOutputs(outputFluids);
        }
        ra.special((Object)GTCMItemList.WhiteDwarfMold_Ingot.get(0, new Object[0])).eut(eut).duration(duration).addTo(aRecipeMap);
    }

    public static FluidStack getMoltenFluids(ItemStack ingot, int ingotAmount) {
        FluidStack out = null;
        for (GTRecipe recipeMolten : RecipeMaps.fluidExtractionRecipes.getAllRecipes()) {
            if (!GTUtility.areStacksEqual((ItemStack)ingot, (ItemStack)recipeMolten.mInputs[0])) continue;
            if (recipeMolten.mFluidOutputs[0] == null) break;
            out = recipeMolten.mFluidOutputs[0].copy();
            out.amount = 144 * ingotAmount;
            break;
        }
        return out;
    }

    public static void loadManualRecipes() {
        StellarForgeRecipePool.addToMiracleDoorRecipes(new ItemStack[]{Materials.MeteoricIron.getDust(1), GTUtility.getIntegratedCircuit((int)1)}, null, null, new FluidStack[]{Materials.MeteoricIron.getMolten(144L)}, (int)TierEU.RECIPE_MV, 500, GTCMRecipe.StellarForgeRecipes);
        StellarForgeRecipePool.addToMiracleDoorRecipes(new ItemStack[]{Materials.MeteoricIron.getDust(1), GTUtility.getIntegratedCircuit((int)2)}, null, null, new FluidStack[]{Materials.MeteoricSteel.getMolten(144L)}, (int)TierEU.RECIPE_MV, 200, GTCMRecipe.StellarForgeRecipes);
        StellarForgeRecipePool.addToMiracleDoorRecipes(new ItemStack[]{Materials.Neutronium.getDust(1), GTUtility.getIntegratedCircuit((int)1)}, null, null, new FluidStack[]{Materials.Neutronium.getMolten(144L)}, (int)TierEU.RECIPE_UV, 2240, GTCMRecipe.StellarForgeRecipes);
    }

    private void cacheRecipeList() {
        stellarForgeRecipeListCache = new HashSet<GTRecipe>(GTCMRecipe.StellarForgeRecipes.getAllRecipes());
    }

    private void loadRecipeListCache() {
        for (GTRecipe recipe : stellarForgeRecipeListCache) {
            GTCMRecipe.StellarForgeRecipes.addRecipe(recipe);
        }
    }

    public static void loadRecipes() {
        StellarForgeRecipePool.initData();
    }

    public static void loadOnServerStarted() {
        StellarForgeRecipePool.prepareEBFRecipes();
        StellarForgeRecipePool.prepareABSRecipes();
        StellarForgeRecipePool.loadManualRecipes();
    }
}

