/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.recipe.machineRecipe.expanded;

import bartworks.system.material.WerkstoffLoader;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import com.Nxer.TwistSpaceTechnology.util.recipes.TST_RecipeBuilder;
import gregtech.api.enums.Materials;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.material.MaterialsElements;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class StarKernelForgeRecipePool {
    public static void loadRecipes() {
        StarKernelForgeRecipePool.loadGeneralRecipes();
        StarKernelForgeRecipePool.loadManualRecipes();
    }

    private static void addRecipe(ItemStack[] itemInputs, FluidStack[] fluidInputs, FluidStack[] fluidOutputs, int eut, int duration) {
        TST_RecipeBuilder.builder().itemInputs(itemInputs).fluidInputs(fluidInputs).fluidOutputs(fluidOutputs).specialValue(13500).eut(eut).duration(duration).addTo(GTCMRecipe.BallLightningRecipes);
    }

    private static void addRecipe(FluidStack[] fluidInputs, FluidStack[] fluidOutputs, int eut, int duration) {
        StarKernelForgeRecipePool.addRecipe(null, fluidInputs, fluidOutputs, eut, duration);
    }

    private static void addRecipe(FluidStack fluidInputs, FluidStack fluidOutputs, int eut) {
        StarKernelForgeRecipePool.addRecipe(new FluidStack[]{fluidInputs}, new FluidStack[]{fluidOutputs}, eut, 50);
    }

    private static void addRecipe(ItemStack itemInputs, FluidStack fluidOutputs, int eut) {
        StarKernelForgeRecipePool.addRecipe(new ItemStack[]{itemInputs}, null, new FluidStack[]{fluidOutputs}, eut, 50);
    }

    private static void loadGeneralRecipes() {
        for (GTRecipe plasmaFuel : RecipeMaps.plasmaFuels.getAllRecipes()) {
            FluidStack plasma = GTUtility.getFluidForFilledItem((ItemStack)plasmaFuel.mInputs[0], (boolean)true);
            if (plasma == null) continue;
            int EUL = plasmaFuel.mSpecialValue;
            String plasmaName = FluidRegistry.getFluidName((FluidStack)plasma);
            String[] plasmaNameSplit = plasmaName.split("\\.", 2);
            if (plasmaNameSplit.length != 2) continue;
            String liquidName = plasmaNameSplit[1];
            plasma.amount = 1000;
            FluidStack liquid = FluidRegistry.getFluidStack((String)liquidName, (int)plasma.amount);
            if (liquid == null) {
                liquid = FluidRegistry.getFluidStack((String)("molten." + liquidName), (int)plasma.amount);
            }
            if (liquid == null) {
                switch (liquidName) {
                    case "helium_3": {
                        liquid = Materials.Helium_3.getGas((long)plasma.amount);
                        break;
                    }
                    case "sodium": {
                        liquid = Materials.Sodium.getFluid((long)plasma.amount);
                    }
                }
            }
            if (liquid == null) continue;
            StarKernelForgeRecipePool.addRecipe(liquid, plasma, EUL * 1000);
        }
    }

    public static void loadManualRecipes() {
        StarKernelForgeRecipePool.addRecipe(WerkstoffLoader.Neon.getFluidOrGas(1000), new FluidStack(MaterialsElements.getInstance().NEON.getPlasma(), 1000), 10000000);
        StarKernelForgeRecipePool.addRecipe(WerkstoffLoader.Krypton.getFluidOrGas(1000), new FluidStack(MaterialsElements.getInstance().KRYPTON.getPlasma(), 1000), 30000000);
        StarKernelForgeRecipePool.addRecipe(WerkstoffLoader.Xenon.getFluidOrGas(1000), new FluidStack(MaterialsElements.getInstance().XENON.getPlasma(), 1000), 90000000);
        StarKernelForgeRecipePool.addRecipe(new FluidStack(MaterialsElements.getInstance().TECHNETIUM.getFluid(), 1000), new FluidStack(MaterialsElements.getInstance().TECHNETIUM.getPlasma(), 1000), 100000000);
        StarKernelForgeRecipePool.addRecipe(new FluidStack(MaterialsElements.getInstance().BROMINE.getFluid(), 1000), new FluidStack(MaterialsElements.getInstance().BROMINE.getPlasma(), 1000), 100000000);
        StarKernelForgeRecipePool.addRecipe(Materials.Tritanium.getMolten(1000L), Materials.Tritanium.getPlasma(1000L), 100000000);
        StarKernelForgeRecipePool.addRecipe(Materials.Carbon.getDust(1), Materials.Carbon.getPlasma(144L), GTUtility.getPlasmaFuelValueInEUPerLiterFromMaterial((Materials)Materials.Carbon) * 144);
        StarKernelForgeRecipePool.addRecipe(Materials.Sulfur.getDust(1), Materials.Sulfur.getPlasma(144L), GTUtility.getPlasmaFuelValueInEUPerLiterFromMaterial((Materials)Materials.Sulfur) * 144);
        StarKernelForgeRecipePool.addRecipe(Materials.Phosphorus.getDust(1), Materials.Phosphorus.getPlasma(144L), GTUtility.getPlasmaFuelValueInEUPerLiterFromMaterial((Materials)Materials.Phosphorus) * 144);
        StarKernelForgeRecipePool.addRecipe(Materials.Strontium.getDust(1), Materials.Strontium.getPlasma(144L), GTUtility.getPlasmaFuelValueInEUPerLiterFromMaterial((Materials)Materials.Strontium) * 144);
        StarKernelForgeRecipePool.addRecipe(Materials.Cadmium.getDust(1), Materials.Cadmium.getPlasma(144L), GTUtility.getPlasmaFuelValueInEUPerLiterFromMaterial((Materials)Materials.Cadmium) * 144);
    }
}

