/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.recipe.machineRecipe.expanded.EcoSphereFakeRecipes;

import com.Nxer.TwistSpaceTechnology.common.machine.TST_MegaTreeFarm;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import galaxyspace.BarnardsSystem.BRFluids;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.MTETreeFarm;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TreeGrowthSimulatorWithoutToolFakeRecipe {
    static FluidStack WaterStack = Materials.Water.getFluid(1000L);
    static FluidStack UnknowWaterStack = new FluidStack(BRFluids.UnknowWater, 1000);
    static FluidStack TemporalLiquidStack = new FluidStack(FluidRegistry.getFluid((String)"temporalfluid"), 100);
    static FluidStack DeathWaterStack = new FluidStack(FluidRegistry.getFluid((String)"fluiddeath"), 1000);
    static FluidStack UUMatterStack = Materials.UUMatter.getFluid(500L);
    static ItemStack[] IntegratedCircuitStack = new ItemStack[]{GTUtility.getIntegratedCircuit((int)1), GTUtility.getIntegratedCircuit((int)2), GTUtility.getIntegratedCircuit((int)3), GTUtility.getIntegratedCircuit((int)4)};
    static ItemStack[] allSaplingsIn;
    static ItemStack[] allSaplingWithTag;
    static ItemStack[] allLogs;
    static ItemStack[] allSaplings;
    static ItemStack[] allLeaves;
    static ItemStack[] allFruits;
    public static ItemStack[][] allProducts;

    public static void loadRecipes() {
        TreeGrowthSimulatorWithoutToolFakeRecipe.initStatic();
        TreeGrowthSimulatorWithoutToolFakeRecipe.loadTreeFarmWithoutToolRecipe();
        TreeGrowthSimulatorWithoutToolFakeRecipe.loadManualRecipes();
    }

    static void initStatic() {
        ArrayList<ItemStack> allSaplingsInCopy = new ArrayList<ItemStack>();
        EnumMap<MTETreeFarm.Mode, ArrayList> allProductsMap = new EnumMap<MTETreeFarm.Mode, ArrayList>(MTETreeFarm.Mode.class);
        for (Map.Entry entry : MTETreeFarm.treeProductsMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] keyPart = key.split(":");
            ItemStack saplingIn = (ItemStack)((EnumMap)entry.getValue()).get(MTETreeFarm.Mode.SAPLING);
            if (!key.contains("Forestry:")) {
                saplingIn = GTModHandler.getModItem((String)keyPart[0], (String)keyPart[1], (long)0L, (int)(keyPart[2] == null ? 0 : Integer.parseInt(keyPart[2])));
            }
            saplingIn.field_77994_a = 0;
            allSaplingsInCopy.add(saplingIn);
        }
        allSaplingsIn = allSaplingsInCopy.toArray(new ItemStack[0]);
        ArrayList<ItemStack> allSaplingWithTagCopy = new ArrayList<ItemStack>();
        for (ItemStack aSapling : allSaplingsIn) {
            ItemStack aStack = aSapling.func_77946_l();
            aStack.func_151001_c(TextEnums.tr("ESS.TreeGrowthSimulator.nei.tooltip.7"));
            allSaplingWithTagCopy.add(aStack);
        }
        allSaplingWithTag = allSaplingWithTagCopy.toArray(new ItemStack[0]);
        for (ItemStack aSapling : allSaplingsIn) {
            EnumMap<MTETreeFarm.Mode, ItemStack> productMap = TST_MegaTreeFarm.queryTreeProduct(aSapling);
            for (MTETreeFarm.Mode mode : MTETreeFarm.Mode.values()) {
                ItemStack aStack = productMap.get(mode);
                if (aStack == null) continue;
                ItemStack aStackCopy = aStack.func_77946_l();
                aStackCopy.field_77994_a *= TST_MegaTreeFarm.getModeMultiplier(mode);
                ArrayList productList = allProductsMap.computeIfAbsent(mode, k -> new ArrayList());
                productList.add(aStackCopy);
            }
        }
        allLogs = ((ArrayList)allProductsMap.get(MTETreeFarm.Mode.LOG)).toArray(new ItemStack[0]);
        allSaplings = ((ArrayList)allProductsMap.get(MTETreeFarm.Mode.SAPLING)).toArray(new ItemStack[0]);
        allLeaves = ((ArrayList)allProductsMap.get(MTETreeFarm.Mode.LEAVES)).toArray(new ItemStack[0]);
        allFruits = ((ArrayList)allProductsMap.get(MTETreeFarm.Mode.FRUIT)).toArray(new ItemStack[0]);
        allProducts = new ItemStack[][]{allLogs, allSaplings, allLeaves, allFruits};
    }

    static void loadTreeFarmWithoutToolRecipe() {
        for (ItemStack Sapling : allSaplingsIn) {
            TreeGrowthSimulatorWithoutToolFakeRecipe.addFakeRecipe(Sapling, new ItemStack[]{Sapling}, WaterStack);
        }
    }

    static void loadManualRecipes() {
        if (Mods.GalaxySpace.isModLoaded()) {
            TreeGrowthSimulatorWithoutToolFakeRecipe.addSpecialFakeRecipe(GTModHandler.getModItem((String)Mods.GalaxySpace.ID, (String)"barnardaCsapling", (long)0L, (int)1), UnknowWaterStack);
        }
        if (Mods.TwilightForest.isModLoaded()) {
            TreeGrowthSimulatorWithoutToolFakeRecipe.addSpecialFakeRecipe(GTModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFSapling", (long)0L, (int)5), TemporalLiquidStack);
        }
        ItemStack LogSymbol = new ItemStack(Blocks.field_150364_r, 1, 0);
        LogSymbol.func_151001_c(TextEnums.tr("ESS.TreeGrowthSimulator.nei.fakeItem.0"));
        TreeGrowthSimulatorWithoutToolFakeRecipe.addEnchantmentLight(LogSymbol);
        ItemStack SaplingSymbol = new ItemStack(Blocks.field_150345_g, 1, 0);
        SaplingSymbol.func_151001_c(TextEnums.tr("ESS.TreeGrowthSimulator.nei.fakeItem.1"));
        TreeGrowthSimulatorWithoutToolFakeRecipe.addEnchantmentLight(SaplingSymbol);
        ItemStack LeavesSymbol = new ItemStack((Block)Blocks.field_150362_t, 1, 0);
        LeavesSymbol.func_151001_c(TextEnums.tr("ESS.TreeGrowthSimulator.nei.fakeItem.2"));
        TreeGrowthSimulatorWithoutToolFakeRecipe.addEnchantmentLight(LeavesSymbol);
        ItemStack FruitSymbol = new ItemStack(Items.field_151034_e, 1, 0);
        FruitSymbol.func_151001_c(TextEnums.tr("ESS.TreeGrowthSimulator.nei.fakeItem.3"));
        TreeGrowthSimulatorWithoutToolFakeRecipe.addEnchantmentLight(FruitSymbol);
        TreeGrowthSimulatorWithoutToolFakeRecipe.addFakeRecipe(IntegratedCircuitStack, new ItemStack[]{LogSymbol, SaplingSymbol, LeavesSymbol, FruitSymbol}, allSaplingWithTag, UUMatterStack);
    }

    public static void addEnchantmentLight(ItemStack aStack) {
        if (!aStack.func_77942_o()) {
            aStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = aStack.func_77978_p();
        NBTTagList enchantments = new NBTTagList();
        tag.func_74782_a("ench", (NBTBase)enchantments);
    }

    static void addSpecialFakeRecipe(ItemStack SpecialSapling, FluidStack SpecialFluid) {
        TreeGrowthSimulatorWithoutToolFakeRecipe.addFakeRecipe(SpecialSapling, allSaplingWithTag, SpecialFluid);
    }

    static void addFakeRecipe(ItemStack Sapling, ItemStack[] specialStacks, FluidStack inputFluid) {
        EnumMap<MTETreeFarm.Mode, ItemStack> ProductMap = TST_MegaTreeFarm.queryTreeProduct(Sapling);
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        int count = 0;
        for (MTETreeFarm.Mode mode : MTETreeFarm.Mode.values()) {
            if (ProductMap != null && ProductMap.get(mode) != null) {
                input.add(IntegratedCircuitStack[count]);
                ItemStack stack = ProductMap.get(mode).func_77946_l();
                stack.field_77994_a *= TST_MegaTreeFarm.getModeMultiplier(mode);
                output.add(stack);
            }
            ++count;
        }
        ItemStack[] i = input.toArray(new ItemStack[0]);
        ItemStack[] o = output.toArray(new ItemStack[0]);
        TreeGrowthSimulatorWithoutToolFakeRecipe.addFakeRecipe(i, o, specialStacks, inputFluid);
    }

    static void addFakeRecipe(ItemStack[] inputStacks, ItemStack[] outputStacks, ItemStack[] specialStacks, FluidStack inputFluid) {
        GTValues.RA.stdBuilder().itemInputs(inputStacks).itemOutputs(outputStacks).fluidInputs(new FluidStack[]{inputFluid}).special((Object)specialStacks).fake().duration(100).eut(0).addTo(GTCMRecipe.TreeGrowthSimulatorWithoutToolFakeRecipes);
    }
}

