/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.recipe.machineRecipe.expanded.EcoSphereFakeRecipes;

import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.machine.TST_MegaTreeFarm;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTModHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraftforge.common.FishingHooks;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AquaticZoneSimulatorFakeRecipe {
    private static final Logger LOGGER = LogManager.getLogger(AquaticZoneSimulatorFakeRecipe.class);
    static FluidStack WaterStack = Materials.Water.getFluid(10000L);
    private static final ItemStack Offspring = GTCMItemList.OffSpring.get(1, new Object[0]);
    public static ArrayList<ItemStack> WatersOutputs = new ArrayList();
    public static HashMap<String, Integer> WatersChances = new HashMap();
    private static List<WeightedRandomFishable> cachedFishList = null;

    public static void loadRecipes() {
        AquaticZoneSimulatorFakeRecipe.initStatics();
        AquaticZoneSimulatorFakeRecipe.loadAquaticZoneFakeRecipes();
        AquaticZoneSimulatorFakeRecipe.loadAquaticZoneTrueRecipes();
    }

    static void initStatics() {
        List<WeightedRandomFishable> fishList = AquaticZoneSimulatorFakeRecipe.getFishList();
        for (WeightedRandomFishable fishable : fishList) {
            try {
                Field itemStackField = WeightedRandomFishable.class.getDeclaredField("field_150711_b");
                itemStackField.setAccessible(true);
                ItemStack itemStack = (ItemStack)itemStackField.get(fishable);
                if (itemStack == null) continue;
                ItemStack stackCopy = itemStack.func_77946_l();
                stackCopy.field_77994_a = 4;
                WatersOutputs.add(stackCopy);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOGGER.error("TST_AquaticZoneFakeRecipeGenerateFail", (Throwable)e);
            }
        }
        Collections.addAll(WatersOutputs, GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"waterlily", (long)1L, (int)0), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"vine", (long)3L, (int)0), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"bone", (long)3L, (int)0), GTModHandler.getModItem((String)Mods.Minecraft.ID, (String)"dye", (long)2L, (int)0));
        if (Mods.BiomesOPlenty.isModLoaded()) {
            Collections.addAll(WatersOutputs, GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"lilyBop", (long)1L, (int)0), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"lilyBop", (long)1L, (int)1), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"lilyBop", (long)1L, (int)2), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"lilyBop", (long)1L, (int)3), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"lilyBop", (long)1L, (int)3), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"coral1", (long)2L, (int)12), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"coral1", (long)2L, (int)13), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"coral1", (long)2L, (int)14), GTModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"coral1", (long)2L, (int)15));
        }
        if (Mods.PamsHarvestCraft.isModLoaded()) {
            Collections.addAll(WatersOutputs, GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"cranberryItem", (long)1L, (int)0), GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"riceItem", (long)1L, (int)0), GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"seaweedItem", (long)5L, (int)0), GTModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"waterchestnutItem", (long)2L, (int)0));
        }
        if (Mods.TwilightForest.isModLoaded()) {
            Collections.addAll(WatersOutputs, GTModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.HugeLilyPad", (long)1L, (int)0));
        }
    }

    private static List<WeightedRandomFishable> getFishList() {
        if (cachedFishList == null) {
            try {
                Field fishField = FishingHooks.class.getDeclaredField("fish");
                fishField.setAccessible(true);
                cachedFishList = (ArrayList)fishField.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOGGER.error("TST_AquaticZoneFakeRecipeGenerateFail", (Throwable)e);
                return new ArrayList<WeightedRandomFishable>();
            }
        }
        return cachedFishList;
    }

    static void loadAquaticZoneFakeRecipes() {
        for (ItemStack aStack : WatersOutputs) {
            ItemStack Input = aStack.func_77946_l();
            Input.field_77994_a = 0;
            AquaticZoneSimulatorFakeRecipe.addFakeRecipe(Input, aStack, WaterStack);
        }
    }

    static void loadAquaticZoneTrueRecipes() {
        int TotalSize = 0;
        for (ItemStack aStack : WatersOutputs) {
            TotalSize += aStack.field_77994_a;
        }
        int BasicSize = 10000 / TotalSize;
        for (ItemStack aStack : WatersOutputs) {
            if (aStack == null) continue;
            WatersChances.put(TST_MegaTreeFarm.getItemStackString(aStack), BasicSize * aStack.field_77994_a);
        }
        WatersOutputs.add(Offspring);
        WatersChances.put(TST_MegaTreeFarm.getItemStackString(Offspring), 1);
    }

    static void addFakeRecipe(ItemStack inputStacks, ItemStack outputStacks, FluidStack inputFluid) {
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{inputStacks}).itemOutputs(new ItemStack[]{outputStacks}).fluidInputs(new FluidStack[]{inputFluid}).fake().duration(100).eut(0).addTo(GTCMRecipe.AquaticZoneSimulatorFakeRecipes);
    }
}

