/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.recipeMap.recipeResult;

import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.util.GTUtility;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public class ResultInsufficientTier
implements CheckRecipeResult {
    private int typeRequired;
    private int tierRequired;
    private static final int TYPE_BLOOD_ALTAR = 1;
    private static final int TYPE_BLOOD_ORB = 2;
    private static final int TYPE_ACTIVATION_CRYSTAL = 3;

    private static ResultInsufficientTier of(int typeRequired, int tierRequired) {
        return new ResultInsufficientTier(typeRequired, tierRequired);
    }

    public static ResultInsufficientTier ofBloodAltar(int required) {
        return ResultInsufficientTier.of(1, required);
    }

    public static ResultInsufficientTier ofBloodOrb(int required) {
        return ResultInsufficientTier.of(2, required);
    }

    public static ResultInsufficientTier ofActivationCrystal(int required) {
        return ResultInsufficientTier.of(3, required);
    }

    public ResultInsufficientTier(int typeRequired, int tierRequired) {
        this.typeRequired = typeRequired;
        this.tierRequired = tierRequired;
    }

    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound tag) {
        tag.func_74768_a("typeRequired", this.typeRequired);
        tag.func_74768_a("tierRequired", this.tierRequired);
        return tag;
    }

    public void readFromNBT(@NotNull NBTTagCompound tag) {
        this.typeRequired = tag.func_74762_e("typeRequired");
        this.tierRequired = tag.func_74762_e("tierRequired");
    }

    @NotNull
    public String getID() {
        return "insufficient_tier";
    }

    public boolean wasSuccessful() {
        return false;
    }

    @NotNull
    public String getDisplayString() {
        return StatCollector.func_74837_a((String)"tst.gui.text.insufficient_tier", (Object[])new Object[]{StatCollector.func_74837_a((String)("tst.gui.text.insufficient_tier." + this.typeRequired), (Object[])new Object[0]), GTUtility.formatNumbers((long)this.tierRequired)});
    }

    @NotNull
    public CheckRecipeResult newInstance() {
        return new ResultInsufficientTier(0, 0);
    }

    public void encode(@NotNull PacketBuffer buffer) {
        buffer.func_150787_b(this.typeRequired);
        buffer.func_150787_b(this.tierRequired);
    }

    public void decode(PacketBuffer buffer) {
        this.typeRequired = buffer.func_150792_a();
        this.tierRequired = buffer.func_150792_a();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResultInsufficientTier)) {
            return false;
        }
        ResultInsufficientTier other = (ResultInsufficientTier)obj;
        return this.typeRequired == other.typeRequired && this.tierRequired == other.tierRequired;
    }
}

