/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.misc.CheckRecipeResults;

import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.util.GTUtility;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class SimpleResultWithText
implements CheckRecipeResult {
    private boolean success;
    private String key;
    private boolean persistsOnShutdown;

    SimpleResultWithText(boolean success, String key, boolean persistsOnShutdown) {
        this.success = success;
        this.key = key;
        this.persistsOnShutdown = persistsOnShutdown;
    }

    SimpleResultWithText(boolean success, FluidStack stack, boolean persistsOnShutdown) {
        this.success = success;
        this.key = Objects.requireNonNull(StatCollector.func_74837_a((String)"GT5U.gui.text.out_of_fluid", (Object[])new Object[]{stack.getLocalizedName(), GTUtility.formatNumbers((long)stack.amount)}));
        this.persistsOnShutdown = persistsOnShutdown;
    }

    SimpleResultWithText(boolean success, ItemStack stack, boolean persistsOnShutdown) {
        this.success = success;
        this.key = Objects.requireNonNull(StatCollector.func_74837_a((String)"GT5U.gui.text.out_of_item", (Object[])new Object[]{stack.func_82833_r(), GTUtility.formatNumbers((long)stack.field_77994_a)}));
        this.persistsOnShutdown = persistsOnShutdown;
    }

    @NotNull
    public String getID() {
        return "SimpleResultWithText";
    }

    public boolean wasSuccessful() {
        return this.success;
    }

    @Nonnull
    public String getDisplayString() {
        return Objects.requireNonNull(TextEnums.tr(this.key));
    }

    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound tag) {
        tag.func_74757_a("success", this.success);
        tag.func_74757_a("persistsOnShutdown", this.persistsOnShutdown);
        tag.func_74778_a("key", this.key);
        return tag;
    }

    public void readFromNBT(@NotNull NBTTagCompound tag) {
        this.success = tag.func_74767_n("success");
        this.persistsOnShutdown = tag.func_74767_n("persistsOnShutdown");
        this.key = tag.func_74779_i("key");
    }

    @Nonnull
    public CheckRecipeResult newInstance() {
        return new SimpleResultWithText(false, "", false);
    }

    public void encode(@Nonnull PacketBuffer buffer) {
        buffer.writeBoolean(this.success);
        NetworkUtils.writeStringSafe((PacketBuffer)buffer, (String)this.key);
        buffer.writeBoolean(this.persistsOnShutdown);
    }

    public void decode(@Nonnull PacketBuffer buffer) {
        this.success = buffer.readBoolean();
        this.key = NetworkUtils.readStringSafe((PacketBuffer)buffer);
        this.persistsOnShutdown = buffer.readBoolean();
    }

    public boolean persistsOnShutdown() {
        return this.persistsOnShutdown;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (o instanceof SimpleResultWithText) {
            SimpleResultWithText that = (SimpleResultWithText)o;
            return this.success == that.success && Objects.equals(this.key, that.key) && this.persistsOnShutdown == that.persistsOnShutdown;
        }
        return false;
    }

    @Nonnull
    public static CheckRecipeResult ofSuccess(String key) {
        return new SimpleResultWithText(true, key, false);
    }

    @Nonnull
    public static CheckRecipeResult ofFailure(String key) {
        return new SimpleResultWithText(false, key, false);
    }

    public static CheckRecipeResult ofFailurePersistOnShutdown(String key) {
        return new SimpleResultWithText(false, key, true);
    }

    @Nonnull
    public static CheckRecipeResult outOfFluid(@Nonnull FluidStack requiredFluidStack) {
        return new SimpleResultWithText(false, requiredFluidStack, true);
    }

    @Nonnull
    public static CheckRecipeResult outOfItem(@Nonnull ItemStack requiredItemStack) {
        return new SimpleResultWithText(false, requiredItemStack, true);
    }
}

