/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.material;

import com.Nxer.TwistSpaceTechnology.common.material.MaterialPool;
import com.Nxer.TwistSpaceTechnology.common.material.MaterialsTST;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import goodgenerator.items.GGMaterial;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.metatileentity.implementations.MTECable;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.material.MaterialsElements;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import tectech.recipe.TecTechRecipeMaps;

public class MaterialFix {
    public static void load() {
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{MaterialPool.HolmiumGarnet.get(OrePrefixes.dust, 1)}).fluidOutputs(new FluidStack[]{MaterialPool.HolmiumGarnet.getMolten(144)}).eut(96).duration(72).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
        MaterialFix.addBlastRecipe(MaterialsTST.NeutroniumAlloy, (int)TierEU.RECIPE_UIV, 1080, 12500, true);
        MaterialFix.addVacuumFreezerRecipe(MaterialsTST.NeutroniumAlloy, (int)TierEU.RECIPE_UEV, 360);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.Neutronium.getDust(7), Materials.Duranium.getDust(2), Materials.Flerovium.getDust(1), MaterialsElements.STANDALONE.WHITE_METAL.getDust(1), Materials.DarkIron.getDust(1), GTUtility.getIntegratedCircuit((int)2)}).fluidInputs(new FluidStack[]{Materials.Hydrogen.getPlasma(14000L)}).itemOutputs(new ItemStack[]{MaterialsTST.NeutroniumAlloy.getDust(12)}).eut(TierEU.RECIPE_UHV).duration(240).addTo((IRecipeMap)RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTUtility.getIntegratedCircuit((int)6), Materials.Neutronium.getDust(7), Materials.Duranium.getDust(2), Materials.Flerovium.getDust(1), MaterialsElements.STANDALONE.WHITE_METAL.getDust(1), Materials.DarkIron.getDust(1)}).fluidInputs(new FluidStack[]{Materials.Hydrogen.getGas(14000L)}).fluidOutputs(new FluidStack[]{MaterialsTST.NeutroniumAlloy.getMolten(2304L)}).eut(TierEU.RECIPE_UIV).duration(13200).addTo((IRecipeMap)GTPPRecipeMaps.alloyBlastSmelterRecipes);
        MaterialFix.addBlastRecipe(MaterialsTST.AxonisAlloy, (int)TierEU.RECIPE_UMV, 720, 13200, true);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTUtility.getIntegratedCircuit((int)6), MaterialsElements.STANDALONE.DRAGON_METAL.getDust(5), MaterialsElements.STANDALONE.HYPOGEN.getDust(3), MaterialsUEVplus.Creon.getDust(2), Materials.Ichorium.getDust(1), Materials.Terbium.getDust(1), GGMaterial.shirabon.get(OrePrefixes.dust, 1)}).fluidOutputs(new FluidStack[]{MaterialsTST.AxonisAlloy.getMolten(1728L)}).eut(TierEU.RECIPE_UMV).duration(14400).addTo((IRecipeMap)GTPPRecipeMaps.alloyBlastSmelterRecipes);
        MaterialFix.makeWires(MaterialsTST.Axonium, 20000, 0L, 0L, Integer.MAX_VALUE, Integer.MAX_VALUE, false, true);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{GTUtility.getIntegratedCircuit((int)20)}).fluidInputs(new FluidStack[]{new FluidStack(MaterialsElements.STANDALONE.DRAGON_METAL.getPlasma(), 5000), new FluidStack(MaterialsElements.STANDALONE.HYPOGEN.getPlasma(), 3000), MaterialsUEVplus.Creon.getPlasma(2000L), Materials.Ichorium.getPlasma(1000L), Materials.Terbium.getPlasma(1000L), GGMaterial.shirabon.getMolten(1000), MaterialsUEVplus.PrimordialMatter.getFluid(1000L)}).fluidOutputs(new FluidStack[]{MaterialsTST.Axonium.getPlasma(120000L)}).eut(TierEU.RECIPE_MAX).duration(900).addTo((IRecipeMap)RecipeMaps.transcendentPlasmaMixerRecipes);
        MaterialFix.addGodForgePlasmaRecipes(MaterialsTST.Axonium, 500, false, 2);
        MaterialFix.addGodForgePlasmaRecipes(MaterialsTST.Dubnium, 140, true, 1);
    }

    public static void addBlastRecipe(Materials aMaterial, int EUt, int duration, int level, boolean gas) {
        ItemStack output;
        ItemStack input = aMaterial.getDust(1);
        if (input == null) {
            input = TstUtils.newPlaceholderItemStack("Dust of " + aMaterial.mName);
        }
        ItemStack itemStack = output = level > 1750 ? GTOreDictUnificator.get((OrePrefixes)OrePrefixes.ingotHot, (Object)aMaterial, (long)1L) : aMaterial.getIngots(1);
        if (output == null) {
            output = TstUtils.newPlaceholderItemStack("Ingot or Hot Ingot of " + aMaterial.mName);
        }
        if (gas) {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{input, GTUtility.getIntegratedCircuit((int)11)}).fluidInputs(new FluidStack[]{Materials.Helium.getGas(1000L)}).itemOutputs(new ItemStack[]{output}).eut(EUt).duration(duration * 1).metadata(GTRecipeConstants.COIL_HEAT, (Object)level).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        } else {
            GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{input, GTUtility.getIntegratedCircuit((int)1)}).itemOutputs(new ItemStack[]{output}).eut(EUt).duration(duration * 1).metadata(GTRecipeConstants.COIL_HEAT, (Object)level).addTo((IRecipeMap)RecipeMaps.blastFurnaceRecipes);
        }
    }

    public static void addVacuumFreezerRecipe(Materials aMaterial, FluidStack[] fluidIn, FluidStack[] fluidOut, int eut, int ticks) {
        ItemStack output;
        ItemStack input = GTOreDictUnificator.get((OrePrefixes)OrePrefixes.ingotHot, (Object)aMaterial, (long)1L);
        if (input == null) {
            input = TstUtils.newPlaceholderItemStack("Hot Ingot of " + aMaterial.mName);
        }
        if ((output = aMaterial.getIngots(1)) == null) {
            output = TstUtils.newPlaceholderItemStack("Ingot of " + aMaterial.mName);
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{input}).fluidInputs(fluidIn).itemOutputs(new ItemStack[]{output}).fluidOutputs(fluidOut).eut(eut).duration(ticks).addTo((IRecipeMap)RecipeMaps.vacuumFreezerRecipes);
    }

    public static void addVacuumFreezerRecipe(Materials aMaterial, int eut, int ticks) {
        MaterialFix.addVacuumFreezerRecipe(aMaterial, new FluidStack[0], new FluidStack[0], eut, ticks);
    }

    public static void addGodForgePlasmaRecipes(Materials aMaterial, int duration, boolean isMultistep, int tier) {
        GTValues.RA.stdBuilder().itemInputs(new ItemStack[]{aMaterial.getDust(1)}).fluidOutputs(new FluidStack[]{aMaterial.getPlasma(144L)}).duration(duration).eut(TierEU.RECIPE_MAX).metadata(GTRecipeConstants.FOG_PLASMA_MULTISTEP, (Object)isMultistep).metadata(GTRecipeConstants.FOG_PLASMA_TIER, (Object)tier).addTo((IRecipeMap)TecTechRecipeMaps.godforgePlasmaRecipes);
        GTValues.RA.stdBuilder().fluidInputs(new FluidStack[]{aMaterial.getMolten(144L)}).fluidOutputs(new FluidStack[]{aMaterial.getPlasma(144L)}).duration(duration).eut(TierEU.RECIPE_MAX).metadata(GTRecipeConstants.FOG_PLASMA_MULTISTEP, (Object)isMultistep).metadata(GTRecipeConstants.FOG_PLASMA_TIER, (Object)tier).addTo((IRecipeMap)TecTechRecipeMaps.godforgePlasmaRecipes);
    }

    public static void makeWires(Materials aMaterial, int aStartID, long aLossInsulated, long aLoss, long aAmperage, long aVoltage, boolean aInsulatable, boolean aAutoInsulated) {
        String displayName = GTLanguageManager.i18nPlaceholder ? "%material" : aMaterial.mDefaultLocalName;
        GTOreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt01, (Object)aMaterial, (ItemStack)new MTECable(aStartID, "wire." + aMaterial.mName.toLowerCase() + ".01", "1x " + displayName + " Wire", 0.125f, aMaterial, aLoss, aAmperage, aVoltage, false, !aAutoInsulated).getStackForm(1L));
        GTOreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt02, (Object)aMaterial, (ItemStack)new MTECable(aStartID + 1, "wire." + aMaterial.mName.toLowerCase() + ".02", "2x " + displayName + " Wire", 0.25f, aMaterial, aLoss, 2L * aAmperage, aVoltage, false, !aAutoInsulated).getStackForm(1L));
        GTOreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt04, (Object)aMaterial, (ItemStack)new MTECable(aStartID + 2, "wire." + aMaterial.mName.toLowerCase() + ".04", "4x " + displayName + " Wire", 0.375f, aMaterial, aLoss, 4L * aAmperage, aVoltage, false, !aAutoInsulated).getStackForm(1L));
        GTOreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt08, (Object)aMaterial, (ItemStack)new MTECable(aStartID + 3, "wire." + aMaterial.mName.toLowerCase() + ".08", "8x " + displayName + " Wire", 0.5f, aMaterial, aLoss, 8L * aAmperage, aVoltage, false, !aAutoInsulated).getStackForm(1L));
        GTOreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt12, (Object)aMaterial, (ItemStack)new MTECable(aStartID + 4, "wire." + aMaterial.mName.toLowerCase() + ".12", "12x " + displayName + " Wire", 0.625f, aMaterial, aLoss, 12L * aAmperage, aVoltage, false, !aAutoInsulated).getStackForm(1L));
        GTOreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt16, (Object)aMaterial, (ItemStack)new MTECable(aStartID + 5, "wire." + aMaterial.mName.toLowerCase() + ".16", "16x " + displayName + " Wire", 0.75f, aMaterial, aLoss, 16L * aAmperage, aVoltage, false, !aAutoInsulated).getStackForm(1L));
        if (aInsulatable) {
            GTOreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt01, (Object)aMaterial, (ItemStack)new MTECable(aStartID + 6, "cable." + aMaterial.mName.toLowerCase() + ".01", "1x " + displayName + " Cable", 0.25f, aMaterial, aLossInsulated, 1L * aAmperage, aVoltage, true, false).getStackForm(1L));
            GTOreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt02, (Object)aMaterial, (ItemStack)new MTECable(aStartID + 7, "cable." + aMaterial.mName.toLowerCase() + ".02", "2x " + displayName + " Cable", 0.375f, aMaterial, aLossInsulated, 2L * aAmperage, aVoltage, true, false).getStackForm(1L));
            GTOreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt04, (Object)aMaterial, (ItemStack)new MTECable(aStartID + 8, "cable." + aMaterial.mName.toLowerCase() + ".04", "4x " + displayName + " Cable", 0.5f, aMaterial, aLossInsulated, 4L * aAmperage, aVoltage, true, false).getStackForm(1L));
            GTOreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt08, (Object)aMaterial, (ItemStack)new MTECable(aStartID + 9, "cable." + aMaterial.mName.toLowerCase() + ".08", "8x " + displayName + " Cable", 0.625f, aMaterial, aLossInsulated, 8L * aAmperage, aVoltage, true, false).getStackForm(1L));
            GTOreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt12, (Object)aMaterial, (ItemStack)new MTECable(aStartID + 10, "cable." + aMaterial.mName.toLowerCase() + ".12", "12x " + displayName + " Cable", 0.75f, aMaterial, aLossInsulated, 12L * aAmperage, aVoltage, true, false).getStackForm(1L));
            GTOreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt16, (Object)aMaterial, (ItemStack)new MTECable(aStartID + 11, "cable." + aMaterial.mName.toLowerCase() + ".16", "16x " + displayName + " Cable", 0.875f, aMaterial, aLossInsulated, 16L * aAmperage, aVoltage, true, false).getStackForm(1L));
        }
    }
}

