/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.item.AEItemStack;
import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.machine.TST_MegaCraftingCenter;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.google.common.collect.ImmutableList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class TST_PatternAccessHatch
extends MTEHatch
implements IGridProxyable,
ICellContainer,
IMEInventoryHandler<AEItemStack>,
IPowerChannelState {
    private TST_MegaCraftingCenter controller;
    private AENetworkProxy gridProxy;
    private static final String[] DESC = new String[]{TextEnums.tr("Tooltip_PatternAccessHatch_1"), TextEnums.tr("Tooltip_PatternAccessHatch_2"), TextEnums.tr("Tooltip_PatternAccessHatch_3"), TextEnums.tr("Tooltip_PatternAccessHatch_4"), TextEnums.Mod_TwistSpaceTechnology.getText()};
    private boolean additionalConnection;
    boolean facingJustChanged;
    boolean wasActive;
    List<AEItemStack> lastPattern;

    public TST_PatternAccessHatch(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "", new ITexture[0]);
    }

    public TST_PatternAccessHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    public synchronized String[] getDescription() {
        return DESC;
    }

    public void bind(TST_MegaCraftingCenter controller) {
        this.controller = controller;
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.postChanges();
    }

    public AENetworkProxy getProxy() {
        if (this.gridProxy == null) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this, "proxy", GTCMItemList.PatternAccessHatch.get(1, new Object[0]), true);
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.updateValidGridProxySides();
            if (this.getBaseMetaTileEntity().getWorld() != null) {
                this.gridProxy.setOwner(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()));
            }
        }
        return this.gridProxy;
    }

    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aStack) {
        this.additionalConnection = !this.additionalConnection;
        this.updateValidGridProxySides();
        aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.hatch.additionalConnection." + this.additionalConnection, new Object[0]));
        return true;
    }

    private void updateValidGridProxySides() {
        if (this.additionalConnection) {
            this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(ForgeDirection.UNKNOWN)));
        } else {
            this.getProxy().setValidSides(EnumSet.of(this.getBaseMetaTileEntity().getFrontFacing()));
        }
    }

    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer entityPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.getBaseMetaTileEntity().isValidFacing(wrenchingSide)) {
            this.getBaseMetaTileEntity().setFrontFacing(wrenchingSide);
            return true;
        }
        return false;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        return true;
    }

    public void onFacingChange() {
        this.updateValidGridProxySides();
        this.facingJustChanged = true;
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        this.getProxy().onReady();
        super.onFirstTick(aBaseMetaTileEntity);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_PatternAccessHatch(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_IN), TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ME_HATCH_ACTIVE)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_IN), TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ME_HATCH)};
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        return this.getProxy().getNode();
    }

    public void securityBreak() {
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this.getBaseMetaTileEntity());
    }

    public IGridNode getActionableNode() {
        return this.getProxy().getNode();
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (this.getController() == null) {
            return ImmutableList.of();
        }
        ArrayList<IMEInventoryHandler> list = new ArrayList<IMEInventoryHandler>();
        if (channel == StorageChannel.ITEMS) {
            list.add(this);
        }
        return list;
    }

    public int getPriority() {
        return 0;
    }

    public void saveChanges(IMEInventory cellInventory) {
    }

    public AEItemStack injectItems(AEItemStack in, Actionable mode, BaseActionSource src) {
        if (this.getController() == null) {
            return in;
        }
        if (mode == Actionable.SIMULATE) {
            return null;
        }
        ItemStack rest = this.getController().tryInjectPattern(in.getItemStack());
        return AEItemStack.create((ItemStack)rest);
    }

    public AEItemStack extractItems(AEItemStack request, Actionable mode, BaseActionSource src) {
        if (this.getController() == null) {
            return null;
        }
        if (this.getController().mMaxProgresstime > 0) {
            return null;
        }
        if (request.getStackSize() > 1L) {
            request = (AEItemStack)request.copy().setStackSize(1L);
        }
        if (mode == Actionable.SIMULATE) {
            for (ItemStack pattern : this.getController().getInternalPatterns()) {
                if (!request.isSameType(pattern)) continue;
                return (AEItemStack)request.copy();
            }
            return null;
        }
        return AEItemStack.create((ItemStack)this.getController().extractPattern(request));
    }

    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public boolean isPrioritized(AEItemStack input) {
        return false;
    }

    public boolean canAccept(AEItemStack input) {
        if (this.getController() == null) {
            return false;
        }
        return input.getItem() instanceof ICraftingPatternItem;
    }

    public int getSlot() {
        return 0;
    }

    public IItemList getAvailableItems(IItemList<AEItemStack> out, int iteration) {
        IItemList<AEItemStack> list = out;
        if (this.getController() == null) {
            return list;
        }
        for (ItemStack stack : this.getController().getInternalPatterns()) {
            list.add((IAEStack)AEItemStack.create((ItemStack)stack));
        }
        return list;
    }

    public boolean validForPass(int i) {
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.facingJustChanged) {
                this.facingJustChanged = false;
                try {
                    this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
                this.postChanges();
            }
            if (aTick % 20L == 0L) {
                this.getController();
            }
            boolean active = this.getProxy().isActive();
            if (!aBaseMetaTileEntity.getWorld().field_72995_K) {
                this.getBaseMetaTileEntity().setActive(active);
                if (this.wasActive != active) {
                    this.wasActive = active;
                    try {
                        this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                    this.postChanges();
                }
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public void onChange() {
        this.postChanges();
    }

    private void postChanges() {
        MachineSource src = new MachineSource((IActionHost)this);
        if (this.lastPattern != null) {
            try {
                this.lastPattern.forEach(s -> s.setStackSize(-s.getStackSize()));
                this.getProxy().getStorage().postAlterationOfStoredItems(StorageChannel.ITEMS, this.lastPattern, (BaseActionSource)src);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        this.lastPattern = new ArrayList<AEItemStack>();
        TST_MegaCraftingCenter ctr = this.getController();
        if (ctr != null) {
            ctr.getInternalPatterns().stream().map(AEItemStack::create).forEach(this.lastPattern::add);
        }
        try {
            this.getProxy().getStorage().postAlterationOfStoredItems(StorageChannel.ITEMS, this.lastPattern, (BaseActionSource)src);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public TST_MegaCraftingCenter getController() {
        if (!(this.controller == null || this.controller.isValid() && this.controller.mPatternAccessHatch.contains((Object)this))) {
            this.controller = null;
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            this.postChanges();
        }
        return this.controller;
    }

    public boolean isPowered() {
        return this.getProxy() != null && this.getProxy().isPowered();
    }

    public boolean isActive() {
        return this.getProxy() != null && this.getProxy().isActive();
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        this.getProxy().writeToNBT(aNBT);
        aNBT.func_74757_a("additionalConnection", this.additionalConnection);
        super.saveNBTData(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.getProxy().readFromNBT(aNBT);
        this.additionalConnection = aNBT.func_74767_n("additionalConnection");
        super.loadNBTData(aNBT);
    }
}

