/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import com.Nxer.TwistSpaceTechnology.util.BloodMagicHelper;
import com.Nxer.TwistSpaceTechnology.util.MathUtils;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.TextureFactory;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchFluidGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.Nullable;

public class TST_BloodOrbHatch
extends MTEHatchFluidGenerator {
    private static final String TEXTURE_NAME_OVERLAY_ACTIVE = "gtnhcommunitymod:iconSets/overlay_blood_hatch";
    private static final String TEXTURE_NAME_OVERLAY_INACTIVE = "gtnhcommunitymod:iconSets/overlay_blood_hatch_inactive";
    public static Textures.BlockIcons.CustomIcon OVERLAY_ACTIVE = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:iconSets/overlay_blood_hatch");
    public static Textures.BlockIcons.CustomIcon OVERLAY_INACTIVE = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:iconSets/overlay_blood_hatch_inactive");
    private static final String[] DESC = new String[]{TextEnums.tr("Tooltip_BloodOrbHatch_1"), TextEnums.tr("Tooltip_BloodOrbHatch_2"), TextEnums.tr("Tooltip_BloodOrbHatch_3"), TextEnums.tr("Tooltip_BloodOrbHatch_4"), TextEnums.tr("Tooltip_BloodOrbHatch_5"), TextEnums.Author_Taskeren.getText(), TextEnums.Mod_TwistSpaceTechnology.getText()};
    private static final String[] TOOLTIP = new String[]{TextEnums.tr("Tooltip_BloodOrbHatch_3"), TextEnums.tr("Tooltip_BloodOrbHatch_4"), TextEnums.tr("Tooltip_BloodOrbHatch_5")};

    public TST_BloodOrbHatch(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public TST_BloodOrbHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_BloodOrbHatch(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Nullable
    public ItemStack getOrbItemStack() {
        return this.mInventory[0];
    }

    private int getCapacityFromOrb() {
        int capacity;
        ItemStack orb = this.getOrbItemStack();
        if (orb != null && (capacity = BloodMagicHelper.getOrbCapacity(orb)) != -1) {
            return capacity;
        }
        return 0;
    }

    private int getMaxCanDrainFromOrb() {
        ItemStack orb = this.getOrbItemStack();
        if (orb != null) {
            if (BloodMagicHelper.isCreativeOrb(orb)) {
                return this.getCapacity() - this.getFluidAmount();
            }
            return BloodMagicHelper.getOrbOwnerLpAmount(orb);
        }
        return 0;
    }

    private int drainFromOrb(int lpAmount) {
        ItemStack orb = this.getOrbItemStack();
        if (orb != null) {
            if (BloodMagicHelper.isCreativeOrb(orb)) {
                return lpAmount;
            }
            return SoulNetworkHandler.syphonFromNetwork((ItemStack)orb, (int)lpAmount);
        }
        return 0;
    }

    public synchronized String[] getDescription() {
        return DESC;
    }

    public String[] getCustomTooltip() {
        return TOOLTIP;
    }

    public Fluid getFluidToGenerate() {
        return FluidUtils.getFluidStack((Fluid)AlchemicalWizardry.lifeEssenceFluid, (int)1).getFluid();
    }

    public int getAmountOfFluidToGenerate() {
        return 0;
    }

    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        return aFluid == this.getFluidToGenerate();
    }

    public int getMaxTickTime() {
        return 1;
    }

    public int getCapacity() {
        return this.getCapacityFromOrb();
    }

    public boolean doesHatchMeetConditionsToGenerate() {
        return BloodMagicHelper.getOrbOwnerName(this.getOrbItemStack()) != null || BloodMagicHelper.isCreativeOrb(this.getOrbItemStack());
    }

    public void generateParticles(World aWorld, String name) {
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)OVERLAY_ACTIVE)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)OVERLAY_INACTIVE)};
    }

    public boolean addFluidToHatch(long aTick) {
        if (!this.getBaseMetaTileEntity().isServerSide()) {
            return false;
        }
        if (!this.doesHatchMeetConditionsToGenerate()) {
            return false;
        }
        if (this.getFluid() != null && this.getFluidAmount() > this.getCapacity()) {
            this.getFluid().amount = this.getCapacity();
            return false;
        }
        int maxDrainAmount = MathUtils.clamp(this.getCapacity() - this.getFluidAmount(), 0, this.getMaxCanDrainFromOrb());
        int drainedAmount = this.drainFromOrb(maxDrainAmount);
        if (drainedAmount > 0) {
            super.fill(FluidUtils.getFluidStack((Fluid)this.getFluidToGenerate(), (int)drainedAmount), true);
            return true;
        }
        return false;
    }

    public void refundBlood() {
        if (!this.getBaseMetaTileEntity().isServerSide()) {
            return;
        }
        if (this.getFluid() != null && this.getFluidAmount() > 0) {
            int added = BloodMagicHelper.addBloodToNetwork(this.getOrbItemStack(), this.getFluidAmount());
            this.mFluid.amount -= added;
            if (this.mFluid.amount <= 0) {
                this.mFluid = null;
            }
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isAllowedToWork()) {
            this.getBaseMetaTileEntity().setActive(true);
            this.mMaxProgresstime = this.getMaxTickTime();
            if (++this.mProgresstime >= this.mMaxProgresstime) {
                if (this.getOrbItemStack() == null) {
                    this.mFluid = null;
                } else {
                    this.addFluidToHatch(aTick);
                }
                this.mProgresstime = 0;
            }
        } else {
            this.getBaseMetaTileEntity().setActive(false);
            this.refundBlood();
            this.mProgresstime = 0;
            this.mMaxProgresstime = 0;
        }
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return true;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return true;
    }
}

