/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.singleBlock.hatch;

import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.fluid.FluidStackTank;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import ggfab.GGItemList;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.render.TextureFactory;
import gregtech.common.tileentities.machines.IDualInputHatch;
import gregtech.common.tileentities.machines.IDualInputInventory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class GT_MetaTileEntity_Hatch_Solidify
extends MTEHatchInputBus
implements IAddUIWidgets,
IDualInputHatch {
    public static final HashSet<TST_ItemID> solidifierMolds = new HashSet();
    private final FluidStack[] mStoredFluid;
    private final FluidStackTank[] fluidTanks;
    public final int mCapacityPer;
    private static final int ITEM_SLOT_AMOUNT = 1;
    private static final int MOLD_SLOT = 0;
    Inventory inventory;

    public GT_MetaTileEntity_Hatch_Solidify(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{TextEnums.tr("ToolTip_SolidifyHatch_1"), TextLocalization.FluidCapacity + " " + GT_MetaTileEntity_Hatch_Solidify.getCapacityPerTank(aTier) + " L x " + GT_MetaTileEntity_Hatch_Solidify.getFluidSlotsAmount(aTier), TextLocalization.AutoSeparation, TextLocalization.ModNameDesc});
        this.mStoredFluid = new FluidStack[GT_MetaTileEntity_Hatch_Solidify.getFluidSlotsAmount(aTier)];
        this.fluidTanks = new FluidStackTank[GT_MetaTileEntity_Hatch_Solidify.getFluidSlotsAmount(aTier)];
        this.mCapacityPer = GT_MetaTileEntity_Hatch_Solidify.getCapacityPerTank(aTier);
        this.inventory = new Inventory(this.mInventory, this.mStoredFluid);
    }

    public GT_MetaTileEntity_Hatch_Solidify(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
        this.mStoredFluid = new FluidStack[GT_MetaTileEntity_Hatch_Solidify.getFluidSlotsAmount(aTier)];
        this.fluidTanks = new FluidStackTank[GT_MetaTileEntity_Hatch_Solidify.getFluidSlotsAmount(aTier)];
        this.mCapacityPer = GT_MetaTileEntity_Hatch_Solidify.getCapacityPerTank(aTier);
        for (int i = 0; i < GT_MetaTileEntity_Hatch_Solidify.getFluidSlotsAmount(aTier); ++i) {
            int index = i;
            this.fluidTanks[i] = new FluidStackTank(() -> this.mStoredFluid[index], fluid -> {
                this.mStoredFluid[index] = fluid;
            }, this.mCapacityPer);
        }
        this.inventory = new Inventory(this.mInventory, this.mStoredFluid);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Solidify(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.mStoredFluid != null) {
            for (int i = 0; i < this.getMaxType(); ++i) {
                if (this.mStoredFluid[i] == null) continue;
                aNBT.func_74782_a("mFluid" + i, (NBTBase)this.mStoredFluid[i].writeToNBT(new NBTTagCompound()));
            }
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (this.mStoredFluid != null) {
            for (int i = 0; i < this.getMaxType(); ++i) {
                if (!aNBT.func_74764_b("mFluid" + i)) continue;
                this.mStoredFluid[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid" + i));
            }
        }
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ME_CRAFTING_INPUT_BUFFER)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ME_CRAFTING_INPUT_BUFFER)};
    }

    public FluidStack getFluid() {
        for (FluidStack tFluid : this.mStoredFluid) {
            if (tFluid == null || tFluid.amount <= 0) continue;
            return tFluid;
        }
        return null;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return super.allowPullStack(aBaseMetaTileEntity, aIndex, side, aStack) && aIndex != 0;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return solidifierMolds.contains((Object)TST_ItemID.createNoNBT(aStack));
    }

    public FluidStack getFluid(int aSlot) {
        if (this.mStoredFluid == null || aSlot < 0 || aSlot >= this.getMaxType()) {
            return null;
        }
        return this.mStoredFluid[aSlot];
    }

    public int getFluidAmount() {
        if (this.getFluid() != null) {
            return this.getFluid().amount;
        }
        return 0;
    }

    public int getCapacity() {
        return this.mCapacityPer;
    }

    public int getFirstEmptySlot() {
        for (int i = 0; i < this.getMaxType(); ++i) {
            if (this.mStoredFluid[i] != null) continue;
            return i;
        }
        return -1;
    }

    public boolean hasFluid(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        for (FluidStack tFluid : this.mStoredFluid) {
            if (!aFluid.isFluidEqual(tFluid)) continue;
            return true;
        }
        return false;
    }

    public int getFluidSlot(FluidStack tFluid) {
        if (tFluid == null) {
            return -1;
        }
        for (int i = 0; i < this.getMaxType(); ++i) {
            if (!tFluid.isFluidEqual(this.mStoredFluid[i])) continue;
            return i;
        }
        return -1;
    }

    public int getFluidAmount(FluidStack tFluid) {
        int tSlot = this.getFluidSlot(tFluid);
        if (tSlot != -1) {
            return this.mStoredFluid[tSlot].amount;
        }
        return 0;
    }

    public void setFluid(FluidStack aFluid, int aSlot) {
        if (aSlot < 0 || aSlot >= this.getMaxType()) {
            return;
        }
        this.mStoredFluid[aSlot] = aFluid;
    }

    public void addFluid(FluidStack aFluid, int aSlot) {
        if (aSlot < 0 || aSlot >= this.getMaxType()) {
            return;
        }
        if (aFluid.equals((Object)this.mStoredFluid[aSlot])) {
            this.mStoredFluid[aSlot].amount += aFluid.amount;
        }
        if (this.mStoredFluid[aSlot] == null) {
            this.mStoredFluid[aSlot] = aFluid.copy();
        }
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mFluid = this.getFluid();
        }
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    public boolean justUpdated() {
        return false;
    }

    public Iterator<? extends IDualInputInventory> inventories() {
        return Arrays.stream(new Inventory[]{this.inventory}).filter(Objects::nonNull).iterator();
    }

    public Optional<IDualInputInventory> getFirstNonEmptyInventory() {
        if (!this.inventory.isEmpty()) {
            return Optional.of(this.inventory);
        }
        return Optional.empty();
    }

    public boolean supportsFluids() {
        return true;
    }

    public ItemStack[] getSharedItems() {
        return new ItemStack[0];
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean allowSelectCircuit() {
        return false;
    }

    public int fill(FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0 || aFluid.amount <= 0 || !this.canTankBeFilled() || !this.isFluidInputAllowed(aFluid)) {
            return 0;
        }
        if (!this.hasFluid(aFluid) && this.getFirstEmptySlot() != -1) {
            int tFilled = Math.min(aFluid.amount, this.mCapacityPer);
            if (doFill) {
                FluidStack tFluid = aFluid.copy();
                tFluid.amount = tFilled;
                this.addFluid(tFluid, this.getFirstEmptySlot());
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return tFilled;
        }
        if (this.hasFluid(aFluid)) {
            int tLeft = this.mCapacityPer - this.getFluidAmount(aFluid);
            int tFilled = Math.min(tLeft, aFluid.amount);
            if (doFill) {
                FluidStack tFluid = aFluid.copy();
                tFluid.amount = tFilled;
                this.addFluid(tFluid, this.getFluidSlot(tFluid));
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return tFilled;
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack nowFluid = this.getFluid();
        if (nowFluid == null) {
            return null;
        }
        return this.drain(ForgeDirection.UNKNOWN, new FluidStack(nowFluid.getFluid(), maxDrain), doDrain);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack aFluid, boolean doDrain) {
        if (aFluid == null || !this.hasFluid(aFluid)) {
            return null;
        }
        FluidStack tStored = this.mStoredFluid[this.getFluidSlot(aFluid)];
        if (tStored.amount <= 0 && this.isFluidChangingAllowed()) {
            this.setFluid(null, this.getFluidSlot(tStored));
            this.getBaseMetaTileEntity().func_70296_d();
            return null;
        }
        FluidStack tRemove = tStored.copy();
        tRemove.amount = Math.min(aFluid.amount, tRemove.amount);
        if (doDrain) {
            tStored.amount -= tRemove.amount;
            this.getBaseMetaTileEntity().func_70296_d();
        }
        if (tStored.amount <= 0 && this.isFluidChangingAllowed()) {
            this.setFluid(null, this.getFluidSlot(tStored));
            this.getBaseMetaTileEntity().func_70296_d();
        }
        return tRemove;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.updateSlots();
        }
    }

    public void updateSlots() {
        if (this.mStoredFluid != null) {
            for (int i = 0; i < this.getMaxType(); ++i) {
                if (this.mStoredFluid[i] == null || this.mStoredFluid[i].amount > 0) continue;
                this.mStoredFluid[i] = null;
            }
        }
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] FTI = new FluidTankInfo[this.getMaxType()];
        for (int i = 0; i < this.getMaxType(); ++i) {
            FTI[i] = new FluidTankInfo(this.mStoredFluid[i], this.mCapacityPer);
        }
        return FTI;
    }

    public int getMaxType() {
        return this.mStoredFluid.length;
    }

    public static int getFluidSlotsAmount(int tier) {
        int n;
        switch (tier) {
            case 5: {
                n = 1;
                break;
            }
            case 6: 
            case 7: {
                n = 2;
                break;
            }
            case 8: {
                n = 4;
                break;
            }
            case 9: {
                n = 6;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public static int getCapacityPerTank(int aTier) {
        int n;
        switch (aTier) {
            case 5: {
                n = 256000;
                break;
            }
            case 6: {
                n = 512000;
                break;
            }
            case 7: {
                n = 1024000;
                break;
            }
            case 8: {
                n = 2048000;
                break;
            }
            case 9: {
                n = 4096000;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        Pos2d[] pos2dArray;
        int SLOT_NUMBER = this.fluidTanks.length;
        switch (SLOT_NUMBER) {
            case 1: {
                Pos2d[] pos2dArray2 = new Pos2d[1];
                pos2dArray = pos2dArray2;
                pos2dArray2[0] = new Pos2d(79, 34);
                break;
            }
            case 2: {
                Pos2d[] pos2dArray3 = new Pos2d[2];
                pos2dArray3[0] = new Pos2d(70, 34);
                pos2dArray = pos2dArray3;
                pos2dArray3[1] = new Pos2d(88, 34);
                break;
            }
            case 4: {
                Pos2d[] pos2dArray4 = new Pos2d[4];
                pos2dArray4[0] = new Pos2d(70, 25);
                pos2dArray4[1] = new Pos2d(88, 25);
                pos2dArray4[2] = new Pos2d(70, 43);
                pos2dArray = pos2dArray4;
                pos2dArray4[3] = new Pos2d(88, 43);
                break;
            }
            case 6: {
                Pos2d[] pos2dArray5 = new Pos2d[6];
                pos2dArray5[0] = new Pos2d(61, 25);
                pos2dArray5[1] = new Pos2d(79, 25);
                pos2dArray5[2] = new Pos2d(97, 25);
                pos2dArray5[3] = new Pos2d(61, 43);
                pos2dArray5[4] = new Pos2d(79, 43);
                pos2dArray = pos2dArray5;
                pos2dArray5[5] = new Pos2d(97, 43);
                break;
            }
            default: {
                pos2dArray = new Pos2d[]{};
            }
        }
        Pos2d[] positions = pos2dArray;
        for (int i = 0; i < SLOT_NUMBER; ++i) {
            builder.widget(new FluidSlotWidget((IFluidTank)this.fluidTanks[i]).setBackground(new IDrawable[]{ModularUITextures.FLUID_SLOT}).setPos(positions[i]));
        }
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)2).startFromSlot(0).endAtSlot(0).background(new IDrawable[]{ModularUITextures.ITEM_SLOT, GTUITextures.OVERLAY_SLOT_MOLD}).build().setPos(7, 7));
    }

    static {
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Bottle.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Plate.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Ingot.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Casing.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Gear.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Gear_Small.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Credit.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Nugget.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Block.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Ball.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Cylinder.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Anvil.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Arrow.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Rod.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Bolt.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Round.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Screw.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Ring.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Rod_Long.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Rotor.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Turbine_Blade.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Pipe_Tiny.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Pipe_Small.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Pipe_Medium.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Pipe_Large.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_Pipe_Huge.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(ItemList.Shape_Mold_ToolHeadDrill.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(GGItemList.SingleUseFile.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(GGItemList.SingleUseWrench.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(GGItemList.SingleUseCrowbar.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(GGItemList.SingleUseWireCutter.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(GGItemList.SingleUseHardHammer.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(GGItemList.SingleUseSoftMallet.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(GGItemList.SingleUseScrewdriver.get(1L, new Object[0]));
        TST_ItemID.createNoNBT(GGItemList.SingleUseSaw.get(1L, new Object[0]));
    }

    public static class Inventory
    implements IDualInputInventory {
        private final ItemStack[] itemInventory;
        private final FluidStack[] fluidInventory;

        public Inventory(ItemStack[] items, FluidStack[] fluid) {
            this.itemInventory = items;
            this.fluidInventory = fluid;
        }

        public ItemStack[] getItemInputs() {
            if (this.isEmpty()) {
                return new ItemStack[0];
            }
            return (ItemStack[])Arrays.stream(this.itemInventory).filter(Objects::nonNull).toArray(ItemStack[]::new);
        }

        public FluidStack[] getFluidInputs() {
            if (this.isEmpty()) {
                return new FluidStack[0];
            }
            return (FluidStack[])Arrays.stream(this.fluidInventory).filter(Objects::nonNull).toArray(FluidStack[]::new);
        }

        public boolean isEmpty() {
            if (this.fluidInventory != null) {
                for (FluidStack fluid : this.fluidInventory) {
                    if (fluid == null || fluid.amount <= 0) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

