/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.multiStructureMachine;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.zip.ZipInputStream;

public class StructureLoader {
    public static HashMap<String, MultiStructureDefinition> structureDefinition = new HashMap();
    public static String assetRoot = "/assets/gtnhcommunitymod/structure/";

    public static MultiStructureDefinition readStructure(String name) {
        if (!structureDefinition.containsKey(name)) {
            structureDefinition.put(name, new MultiStructureDefinition());
        }
        return structureDefinition.get(name);
    }

    public static MultiStructureDefinition.OffSet getOffSet(String name, String piece) {
        if (StructureLoader.readStructure((String)name).pieces == null) {
            TwistSpaceTechnology.LOG.error("pieces is null");
        } else if (StructureLoader.readStructure((String)name).pieces.get(piece) == null) {
            for (String i : StructureLoader.readStructure((String)name).pieces.keySet()) {
                TwistSpaceTechnology.LOG.info(i);
            }
            TwistSpaceTechnology.LOG.error("get OffSet is null:" + name + "->" + piece);
        }
        MultiStructureDefinition structure = StructureLoader.readStructure(name);
        return structure.offSet.get(structure.pieces.get(piece));
    }

    public static String[][] getShape(String name, String piece) {
        MultiStructureDefinition structure = StructureLoader.readStructure(name);
        if (structure.pieces.get(piece) == null) {
            StructureLoader.load(name, piece);
        }
        return structure.shape.get(structure.pieces.get(piece));
    }

    public static HashMap<String, Integer> getPieces(String name) {
        return StructureLoader.readStructure((String)name).pieces;
    }

    public static void load(String name, String pieces) {
        MultiStructureDefinition structure = StructureLoader.readStructure(name);
        if (structure.pieces.get(pieces) != null) {
            return;
        }
        MultiStructureDefinition.OffSet offSet = structure.machineOffSet;
        TwistSpaceTechnology.LOG.info(Objects.requireNonNull(TwistSpaceTechnology.class.getResource("")).getPath());
        try (ZipInputStream zipInputStream = new ZipInputStream(Objects.requireNonNull(TwistSpaceTechnology.class.getResourceAsStream(assetRoot + name + ".zip")), StandardCharsets.UTF_8);){
            String line;
            zipInputStream.getNextEntry();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)zipInputStream, StandardCharsets.UTF_8));
            int cnt = 0;
            while ((line = reader.readLine()) != null) {
                String[] off = line.split(" ");
                MultiStructureDefinition.OffSet offset = new MultiStructureDefinition.OffSet(offSet.horizontalOffSet - Integer.parseInt(off[2]), offSet.verticalOffSet - Integer.parseInt(off[1]), offSet.depthOffSet - Integer.parseInt(off[0]));
                line = reader.readLine();
                String[][] shape = new String[16][16];
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        int t = 256 * i + 16 * j;
                        shape[i][j] = line.substring(t, t + 16);
                    }
                }
                structure.shape.add(shape);
                structure.pieces.put(pieces + cnt, structure.pieces.size());
                structure.offSet.add(offset);
                TwistSpaceTechnology.LOG.info("loaded :" + name + " with sub pieces:" + pieces + cnt);
                ++cnt;
            }
            reader.close();
        }
        catch (IOException e) {
            TwistSpaceTechnology.LOG.info("structure file " + name + " not find!");
        }
    }

    public static void setOffSet(String name, int horizontalOffSet, int verticalOffSet, int depthOffSet) {
        StructureLoader.readStructure((String)name).machineOffSet = new MultiStructureDefinition.OffSet(horizontalOffSet, verticalOffSet, depthOffSet);
    }

    public static class MultiStructureDefinition {
        public ArrayList<OffSet> offSet = new ArrayList();
        public OffSet machineOffSet;
        public ArrayList<String[][]> shape = new ArrayList();
        public HashMap<String, Integer> pieces = new HashMap();

        MultiStructureDefinition() {
        }

        public static class OffSet {
            public int horizontalOffSet;
            public int verticalOffSet;
            public int depthOffSet;

            public OffSet(int horizontalOffSet, int verticalOffSet, int depthOffSet) {
                this.horizontalOffSet = horizontalOffSet;
                this.verticalOffSet = verticalOffSet;
                this.depthOffSet = depthOffSet;
            }
        }
    }
}

