/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.multiStructureMachine;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.common.machine.multiStructureMachine.GT_TileEntity_MultiStructureMachine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;

public class MultiStructureManager
extends WorldSavedData {
    private static final HashMap<Integer, GT_TileEntity_MultiStructureMachine<?>> machines = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> subMachines = new HashMap();
    private static final HashMap<Integer, ArrayList<Integer>> validSubTypeCode = new HashMap();
    private static Integer endID = 0;

    public MultiStructureManager() {
        super("MultiStructureManagementSavedData");
    }

    public static GT_TileEntity_MultiStructureMachine<?> getMachine(int ID) {
        if (ID == -1) {
            return null;
        }
        return machines.get(ID);
    }

    public static void registryMachine(GT_TileEntity_MultiStructureMachine<?> machine) {
        if (machine == null) {
            TwistSpaceTechnology.LOG.info("unexpected multi-structure registry");
            return;
        }
        if (machine.ID != -1) {
            machines.put(machine.ID, machine);
        } else {
            Integer n = endID;
            endID = endID + 1;
            machine.ID = endID;
            machines.put(endID, machine);
            subMachines.put(endID, new HashSet());
        }
        TwistSpaceTechnology.LOG.info("machine registered:" + machine.getLocalName() + " with ID:" + endID.toString());
    }

    public static void registryTypeMap(Integer type, ArrayList<Integer> typeCode) {
        validSubTypeCode.put(type, typeCode);
    }

    public static boolean linkMachine(GT_TileEntity_MultiStructureMachine<?> mainMachine, GT_TileEntity_MultiStructureMachine<?> subMachine) {
        if (mainMachine == null || subMachine == null) {
            return false;
        }
        if (mainMachine.checkStructure(false) || subMachine.checkStructure(false)) {
            return false;
        }
        int mainID = mainMachine.ID;
        int subID = subMachine.ID;
        if (!validSubTypeCode.get(mainMachine.Type).contains(subMachine.Type)) {
            return false;
        }
        subMachine.fatherID = mainID;
        subMachines.get(mainID).add(subID);
        TwistSpaceTechnology.LOG.info("machine linked:" + mainMachine.getLocalName() + " and " + subMachine.getLocalName());
        return true;
    }

    public static void removeLink(GT_TileEntity_MultiStructureMachine<?> mainMachine, GT_TileEntity_MultiStructureMachine<?> subMachine) {
        if (mainMachine == null || subMachine == null) {
            return;
        }
        int mainID = mainMachine.ID;
        int subID = subMachine.ID;
        subMachine.fatherID = -1;
        subMachines.get(mainID).remove(subID);
    }

    public static void removeMachine(GT_TileEntity_MultiStructureMachine<?> machine) {
        if (machine == null) {
            return;
        }
        int ID = machine.ID;
        machines.remove(ID);
        subMachines.remove(ID);
        MultiStructureManager.removeLink(MultiStructureManager.getMachine(machine.fatherID), machine);
        TwistSpaceTechnology.LOG.info("machine removed:" + machine.getLocalName());
    }

    public void func_76184_a(NBTTagCompound p_76184_1_) {
    }

    public void func_76187_b(NBTTagCompound p_76187_1_) {
    }
}

