/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses;

import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoMulti;

public abstract class TST_GeneratorBase<T extends TST_GeneratorBase<T>>
extends GTCM_MultiMachineBase<T> {
    protected List<MTEHatchDynamoMulti> mExoticDynamoHatches = new ArrayList<MTEHatchDynamoMulti>();

    public TST_GeneratorBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_GeneratorBase(String aName) {
        super(aName);
    }

    public boolean addDynamoToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchDynamo) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDynamoHatches.add((MTEHatchDynamo)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchDynamoMulti) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mExoticDynamoHatches.add((MTEHatchDynamoMulti)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return super.addToMachineList(aTileEntity, aBaseCasingIndex) || this.addDynamoToMachineList(aTileEntity, aBaseCasingIndex);
    }

    @Override
    public boolean addEnergyOutputMultipleDynamos(long totalEU, boolean aAllowMixedVoltageDynamos) {
        long freeCapacity;
        if (totalEU < 0L) {
            totalEU = -totalEU;
        }
        for (MTEHatchDynamo tHatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mDynamoHatches)) {
            freeCapacity = tHatch.maxEUStore() - tHatch.getBaseMetaTileEntity().getStoredEU();
            if (freeCapacity <= 0L) continue;
            if (totalEU > freeCapacity) {
                tHatch.setEUVar(tHatch.maxEUStore());
                totalEU -= freeCapacity;
                continue;
            }
            tHatch.setEUVar(tHatch.getBaseMetaTileEntity().getStoredEU() + totalEU);
            return true;
        }
        for (MTEHatchDynamo tHatch : (List)GTUtility.filterValidMTEs(this.mExoticDynamoHatches)) {
            freeCapacity = tHatch.maxEUStore() - tHatch.getBaseMetaTileEntity().getStoredEU();
            if (freeCapacity <= 0L) continue;
            if (totalEU > freeCapacity) {
                tHatch.setEUVar(tHatch.maxEUStore());
                totalEU -= freeCapacity;
                continue;
            }
            tHatch.setEUVar(tHatch.getBaseMetaTileEntity().getStoredEU() + totalEU);
            return true;
        }
        return false;
    }

    public static enum HatchElement implements IHatchElement<TST_GeneratorBase>
    {
        ExoticDynamo(TST_GeneratorBase::addDynamoToMachineList, new Class[]{MTEHatchDynamoMulti.class}){

            public long count(TST_GeneratorBase tstGeneratorBase) {
                return tstGeneratorBase.mExoticDynamoHatches.size();
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGTHatchAdder<TST_GeneratorBase> adder;

        @SafeVarargs
        private HatchElement(IGTHatchAdder<TST_GeneratorBase> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.adder = adder;
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
        }

        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        public IGTHatchAdder<? super TST_GeneratorBase> adder() {
            return this.adder;
        }
    }
}

