/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import bartworks.API.BorosilicateGlass;
import com.Nxer.TwistSpaceTechnology.client.texture.UITextures;
import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.init.TstBlocks;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.misc.CheckRecipeResults.CheckRecipeResults;
import com.Nxer.TwistSpaceTechnology.common.misc.CheckRecipeResults.SimpleResultWithText;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.RecipeMathUtils;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import cpw.mods.fml.common.registry.GameRegistry;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.thermalfoundation.fluid.TFFluids;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class TST_SwelegfyrBlastFurnace
extends GTCM_MultiMachineBase<TST_SwelegfyrBlastFurnace> {
    private static final int baseHorizontalOffSet = 5;
    private static final int baseVerticalOffSet = 17;
    private static final int baseDepthOffSet = 1;
    private static final int BlazeHorizontalOffSet = 3;
    private static final int BlazeVerticalOffSet = 10;
    private static final int BlazeDepthOffSet = -1;
    private static final String STRUCTURE_PIECE_MAIN_T1 = "mainT1";
    private static final String STRUCTURE_PIECE_MAIN_T2 = "mainT2";
    private static final String STRUCTURE_PIECE_Blaze_T1 = "BlazeT1";
    private static final String STRUCTURE_PIECE_Blaze_T2 = "BlazeT2";
    private static final String[][] shapeMainT1 = new String[][]{{"           ", "           ", "   NNNNN   ", "  NNNNNNN  ", "  NNNNNNN  ", "  NNNNNNN  ", "  NNNNNNN  ", "  NNNNNNN  ", "   NNNNN   ", "           ", "           "}, {"           ", "   NNNNN   ", "  NHHHHHN  ", " NHDDDDDHN ", " NHDDDDDHN ", " NHDDDDDHN ", " NHDDDDDHN ", " NHDDDDDHN ", "  NHHHHHN  ", "   NNNNN   ", "           "}, {"   FFFFF   ", "  FMMMMMF  ", " FMFKKKFMF ", "FMFEEEEEFMF", "FMKEEEEEKMF", "FMKEECEEKMF", "FMKEEEEEKMF", "FMFEEEEEFMF", " FMFKKKFMF ", "  FMMMMMF  ", "   FFFFF   "}, {"           ", "   HHHHH   ", "  HFFFFFH  ", " HFEEEEEFH ", " HFEEEEEFH ", " HFEECEEFH ", " HFEEEEEFH ", " HFEEEEEFH ", "  HFFFFFH  ", "   HHHHH   ", "           "}, {"           ", "   J   J   ", "  BFAAAFB  ", " JFEEEEEFJ ", "  AEEEEEA  ", "  AEECEEA  ", "  AEEEEEA  ", " JFEEEEEFJ ", "  BFAAAFB  ", "   J   J   ", "           "}, {"           ", "   J   J   ", "  BFAAAFB  ", " JFEEEEEFJ ", "  AEEEEEA  ", "  AEECEEA  ", "  AEEEEEA  ", " JFEEEEEFJ ", "  BFAAAFB  ", "   J   J   ", "           "}, {"           ", "   HHHHH   ", "  HFFFFFH  ", " HFEEEEEFH ", " HFEEEEEFH ", " HFEECEEFH ", " HFEEEEEFH ", " HFEEEEEFH ", "  HFFFFFH  ", "   HHHHH   ", "           "}, {"   FFFFF   ", "  FMMMMMF  ", " FMFJJJFMF ", "FMFEEEEEFMF", "FMJEEEEEJMF", "FMJEECEEJMF", "FMJEEEEEJMF", "FMFEEEEEFMF", " FMFJJJFMF ", "  FMMMMMF  ", "   FFFFF   "}, {"           ", "   JJ JJ   ", "  JNNNNNJ  ", " JNEDDDDNJ ", "JJNDEEEDNJ ", "  NDECEDN  ", "JJNDEEEDNJ ", " JNEDDDENJ ", "  JNNNNNJ  ", "   JJ JJ   ", "           "}, {"           ", "    J J    ", "   NHNHN   ", "  NEDDDEN  ", " JHDEEEDHJ ", "  NDECEDN  ", " JHDEEEDHJ ", "  NEDDDEN  ", "   NHNHN   ", "    J J    ", "           "}, {"           ", "    J J    ", "   NHNHN   ", "  NEDDDEN  ", " JHDEEEDHJ ", "  NDECEDN  ", " JHDEEEDHJ ", "  NEDDDEN  ", "   NHNHN   ", "    J J    ", "           "}, {"           ", "           ", "   NHNHN   ", "  NEDDDEN  ", "  HDEEEDH  ", "  NDECEDN  ", "  HDEEEDH  ", "  NEDDDEN  ", "   NHNHN   ", "           ", "           "}, {"           ", "           ", "   NHNHN   ", "  NEDDDEN  ", "  HDEEEDH  ", "  NDECEDN  ", "  HDEEEDH  ", "  NEDDDEN  ", "   NHNHN   ", "           ", "           "}, {"           ", "           ", "   NHNHN   ", "  NEDDDEN  ", "  HDEEEDH  ", "  NDECEDN  ", "  HDEEEDH  ", "  NEDDDEN  ", "   NHNHN   ", "           ", "           "}, {"           ", "           ", "   NNNNN   ", "  NNDDDNN  ", "  NDEEEDN  ", "  NDECEDN  ", "  NDEEEDN  ", "  NNDDDNN  ", "   NNNNN   ", "           ", "           "}, {"           ", "   NNNNN   ", "  N     N  ", " N  DDD  N ", " N DEEED N ", " N DECED N ", " N DEEED N ", " N  DDD  N ", "  N     N  ", "   NNNNN   ", "           "}, {"           ", "   MOOOM   ", "  M     M  ", " M  MMM  M ", " M MEEEM M ", " M MECEM M ", " M MEEEM M ", " M  MMM  M ", "  M     M  ", "   MMMMM   ", "           "}, {"           ", "   MO~OM   ", "  A     A  ", " A  KKK  A ", " A KEEEK A ", " A KECEK A ", " A KEEEK A ", " A  KKK  A ", "  A     A  ", "   AAAAA   ", "           "}, {"           ", "   MOSOM   ", "  M     M  ", " M  MMM  M ", " M MEEEM M ", " M MECEM M ", " M MEEEM M ", " M  MMM  M ", "  M     M  ", "   MMMMM   ", "           "}, {"           ", "   PPPPP   ", "  PDDDDDP  ", " PDDDDDDDP ", " PDDDDDDDP ", " PDDDDDDDP ", " PDDDDDDDP ", " PDDDDDDDP ", "  PDDDDDP  ", "   PPPPP   ", "           "}};
    private static final String[][] shapeMainT2 = new String[][]{{"                      ", "                      ", "   NNNNN              ", "  NNNNNNN             ", "  NNNNNNN             ", "  NNNNNNN             ", "  NNNNNNN             ", "  NNNNNNN             ", "   NNNNN              ", "                      ", "                      "}, {"                      ", "   NNNNN              ", "  NHHHHHN             ", " NHDDDDDHN       NNN  ", " NHDDDDDHN      NNNNN ", " NHDDDDDHN      NNNNN ", " NHDDDDDHN      NNNNN ", " NHDDDDDHN       NNN  ", "  NHHHHHN             ", "   NNNNN              ", "                      "}, {"   FFFFF              ", "  FMMMMMF             ", " FMFKKKFMF      GGGGG ", "FMFEEEEEFMF    GGGGGGG", "FMKEEEEEKMFJJJJGGGGGGG", "FMKEECEEKMF    GGGGGGG", "FMKEEEEEKMFJJJJGGGGGGG", "FMFEEEEEFMF    GGGGGGG", " FMFKKKFMF      GGGGG ", "  FMMMMMF             ", "   FFFFF              "}, {"                      ", "   HHHHH              ", "  HFFFFFH        HHH  ", " HFEEEEEFH      HNNNH ", " HFEEEEEFHHHHHHHNLLLNH", " HFEECEEFNNNNNNNNLLLNh", " HFEEEEEFHHHHHHHNLLLNH", " HFEEEEEFH      HNNNH ", "  HFFFFFH        HHH  ", "   HHHHH              ", "                      "}, {"                      ", "   J   J              ", "  BFAAAFB             ", " JFEEEEEFJ      GAAAG ", "  AEEEEEHAAAAAAAA   A ", "  AEECEEN       - L a ", "  AEEEEEHAAAAAAAA   A ", " JFEEEEEFJ      GAAAG ", "  BFAAAFB             ", "   J   J              ", "                      "}, {"                      ", "   J   J              ", "  BFAAAFB             ", " JFEEEEEFJ      GAAAG ", "  AEEEEEHAAAAAAAA   A ", "  AEECEEN       - L a ", "  AEEEEEHAAAAAAAA   A ", " JFEEEEEFJ      GAAAG ", "  BFAAAFB             ", "   J   J              ", "                      "}, {"                      ", "   HHHHH              ", "  HFFFFFH        HHH  ", " HFEEEEEFH      HNNNH ", " HFEEEEEFHHHHHHHN   NH", " HFEECEEFNNNNNNNN L Nh", " HFEEEEEFHHHHHHHN   NH", " HFEEEEEFH      HNNNH ", "  HFFFFFH        HHH  ", "   HHHHH              ", "                      "}, {"   FFFFF              ", "  FMMMMMF             ", " FMFJJJFMF       GGG  ", "FMFEEEEEFMF     GAAAG ", "FMJEEEEEJMFJJJJGA   AG", "FMJEECEEJMF    GN L NG", "FMJEEEEEJMFJJJJGA   AG", "FMFEEEEEFMF     GAAAG ", " FMFJJJFMF       GGG  ", "  FMMMMMF             ", "   FFFFF              "}, {"                      ", "   JJ JJ              ", "  JNNNNNJ        JJJ  ", " JNEDDDDNJ      JAAAJ ", "JJNDEEEDNJJ    JA   AJ", "  NDECEDN      JN L NJ", "JJNDEEEDNJJ    JA   AJ", " JNEDDDENJ      JAAAJ ", "  JNNNNNJ        JJJ  ", "   JJ JJ              ", "                      "}, {"                      ", "    J J               ", "   NHNHN              ", "  NEDDDEN       BAAAB ", " JHDEEEDHJ      A   A ", "  NDECEDN       N L N ", " JHDEEEDHJ      A   A ", "  NEDDDEN       BAAAB ", "   NHNHN              ", "    J J               ", "                      "}, {"                      ", "    J J               ", "   NHNHN              ", "  NEDDDEN       BAAAB ", " JHDEEEDHJ      A   A ", "  NDECEDN       N L N ", " JHDEEEDHJ      A   A ", "  NEDDDEN       BAAAB ", "   NHNHN              ", "    J J               ", "                      "}, {"                      ", "                      ", "   NHNHN              ", "  NEDDDEN       BAAAB ", "  HDEEEDH       A   A ", "  NDECEDN       N L N ", "  HDEEEDH       A   A ", "  NEDDDEN       BAAAB ", "   NHNHN              ", "                      ", "                      "}, {"                      ", "                      ", "   NHNHN              ", "  NEDDDEN       BAAAB ", "  HDEEEDH       A   A ", "  NDECEDN       N L N ", "  HDEEEDH       A   A ", "  NEDDDEN       BAAAB ", "   NHNHN              ", "                      ", "                      "}, {"                      ", "                      ", "   NHNHN              ", "  NEDDDEN       BAAAB ", "  HDEEEDH       A   A ", "  NDECEDN       N L N ", "  HDEEEDH       A   A ", "  NEDDDEN       BAAAB ", "   NHNHN              ", "                      ", "                      "}, {"                      ", "                      ", "   NNNNN              ", "  NNDDDNN       BAAAB ", "  NDEEEDN       A   A ", "  NDECEDN       N L N ", "  NDEEEDN       A   A ", "  NNDDDNN       BAAAB ", "   NNNNN              ", "                      ", "                      "}, {"                      ", "   NNNNN              ", "  N     N       GGGGG ", " N  DDD  N     GGNNNGG", " N DEEED N     GN   NG", " N DECED N     GN L NG", " N DEEED N     GN   NG", " N  DDD  N     GGNNNGG", "  N     N       GGGGG ", "   NNNNN              ", "                      "}, {"                      ", "   MOOOM              ", "  M     M       BGIGB ", " M  MMM  M     BHDIDHB", " M MEEEM M     GD   DG", " M MECEM M     II L II", " M MEEEM M     GD   DG", " M  MMM  M     BHDIDHB", "  M     M       BGIGB ", "   MMMMM              ", "                      "}, {"                      ", "   MO~OM              ", "  A     A       BNSNB ", " A  KKK  A     BHDDDHB", " A KEEEK A     ND   DN", " A KECEK A     ND L DN", " A KEEEK A     ND   DN", " A  KKK  A     BHDDDHB", "  A     A       BNONB ", "   AAAAA              ", "                      "}, {"                      ", "   MOOOM              ", "  M     M       BGIGB ", " M  MMM  M     BHDIDHB", " M MEEEM M     GD   DG", " M MECEM M     II L II", " M MEEEM M     GD   DG", " M  MMM  M     BHDIDHB", "  M     M       BGIGB ", "   MMMMM              ", "                      "}, {"                      ", "   PPPPP              ", "  PDDDDDP       GGGGG ", " PDDDDDDDP     GGNNNGG", " PDDDDDDDP     GNNNNNG", " PDDDDDDDP     GNNNNNG", " PDDDDDDDP     GNNNNNG", " PDDDDDDDP     GGNNNGG", "  PDDDDDP       GGGGG ", "   PPPPP              ", "                      "}};
    private static final String[][] shapeBlazeT1 = new String[][]{{"       ", "       ", "       ", "       ", "       ", "       ", "       "}, {"       ", "       ", "       ", "       ", "       ", "       ", "       "}, {"       ", "       ", "       ", "       ", "       ", "       ", "       "}, {"       ", "       ", "       ", "       ", "       ", "       ", "       "}, {"       ", "       ", "       ", "       ", "       ", "       ", "       "}, {"       ", "       ", "       ", "       ", "       ", "       ", "       "}, {"       ", "       ", "       ", "       ", "       ", "       ", "       "}, {"       ", "       ", "       ", "       ", "       ", "       ", "       "}, {"       ", "       ", "       ", "       ", "       ", "       ", "       "}, {" ZZZZZ ", "ZZ   ZZ", "Z     Z", "Z     Z", "Z     Z", "ZZ   ZZ", " ZZZZZ "}, {" ZZZZZ ", "ZZ   ZZ", "Z     Z", "Z     Z", "Z     Z", "ZZ   ZZ", " ZZZZZ "}, {" ZZZZZ ", "ZZ   ZZ", "Z     Z", "Z     Z", "Z     Z", "ZZ   ZZ", " ZZZZZ "}};
    private static final String[][] shapeBlazeT2 = new String[][]{{"                  ", "                  ", "               ZZZ", "               Z Z", "               ZZZ", "                  ", "                  "}, {"                  ", "                  ", "               ZZZ", "               Z Z", "               ZZZ", "                  ", "                  "}, {"                  ", "                  ", "               ZZZ", "               Z Z", "               ZZZ", "                  ", "                  "}, {"                  ", "                  ", "               ZZZ", "               Z Z", "               ZZZ", "                  ", "                  "}, {"                  ", "                  ", "               ZZZ", "               Z Z", "               ZZZ", "                  ", "                  "}, {"                  ", "                  ", "               ZZZ", "               Z Z", "               ZZZ", "                  ", "                  "}, {"                  ", "                  ", "               ZZZ", "               Z Z", "               ZZZ", "                  ", "                  "}, {"                  ", "                  ", "               ZZZ", "               Z Z", "               ZZZ", "                  ", "                  "}, {"                  ", "                  ", "               ZZZ", "               Z Z", "               ZZZ", "                  ", "                  "}, {" ZZZZZ            ", "ZZ   ZZ           ", "Z     Z        ZZZ", "Z     Z        Z Z", "Z     Z        ZZZ", "ZZ   ZZ           ", " ZZZZZ            "}, {" ZZZZZ            ", "ZZ   ZZ           ", "Z     Z        ZZZ", "Z     Z        Z Z", "Z     Z        ZZZ", "ZZ   ZZ           ", " ZZZZZ            "}, {" ZZZZZ            ", "ZZ   ZZ           ", "Z     Z        ZZZ", "Z     Z        Z Z", "Z     Z        ZZZ", "ZZ   ZZ           ", " ZZZZZ            "}};
    private static IStructureDefinition<TST_SwelegfyrBlastFurnace> STRUCTURE_DEFINITION = null;
    byte glassTier = 0;
    byte controllerTier = 1;
    boolean isBlazeFinishSet = false;
    boolean isBlazeFinishClear = true;
    boolean isPassiveMode = false;
    boolean inPassiveMode = false;
    boolean isRapidHeating = false;
    boolean inRapidHeating = false;
    boolean isHoldingHeat = false;
    static ItemStack UpgradeItem = null;
    int previousRecipeCode = 0;
    int correctBlazeCost = 0;
    private MTEHatchInput mBlazeHatch;
    public HeatingCoilLevel coilLevel;
    private int mHeatingCapacity;
    private int maxHeatingCapacity;
    protected int recipeHeatLimitation;
    private long runningTick = 0L;

    public TST_SwelegfyrBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_SwelegfyrBlastFurnace(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_SwelegfyrBlastFurnace(this.mName);
    }

    public IStructureDefinition<TST_SwelegfyrBlastFurnace> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN_T1, StructureUtility.transpose((String[][])shapeMainT1)).addShape(STRUCTURE_PIECE_MAIN_T2, StructureUtility.transpose((String[][])shapeMainT2)).addShape(STRUCTURE_PIECE_Blaze_T1, StructureUtility.transpose((String[][])shapeBlazeT1)).addShape(STRUCTURE_PIECE_Blaze_T2, StructureUtility.transpose((String[][])shapeBlazeT2)).addElement('-', StructureUtility.isAir()).addElement('A', StructureUtility.withChannel((String)"glass", (IStructureElement)BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
                te.glassTier = t;
            }, te -> te.glassTier))).addElement('a', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.withChannel((String)"glass", (IStructureElement)BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
                te.glassTier = t;
            }, te -> te.glassTier)), StructureUtility.isAir()})).addElement('B', StructureUtility.ofBlock((Block)GameRegistry.findBlock((String)Mods.IndustrialCraft2.ID, (String)"blockFenceIron"), (int)0)).addElement('C', StructureUtility.ofBlock((Block)Loaders.compactFusionCoil, (int)0)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)11)).addElement('E', StructureUtility.withChannel((String)"coil", (IStructureElement)GTStructureUtility.ofCoil(TST_SwelegfyrBlastFurnace::setCoilLevel, TST_SwelegfyrBlastFurnace::getCoilLevel))).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)5)).addElement('G', StructureUtility.ofBlock((Block)TstBlocks.MetaBlockCasing02, (int)2)).addElement('H', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)10)).addElement('h', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)10), StructureUtility.ofBlock((Block)TstBlocks.MetaBlockCasing01, (int)15)})).addElement('I', GTStructureUtility.ofFrame((Materials)Materials.Neutronium)).addElement('J', GTStructureUtility.ofFrame((Materials)Materials.NaquadahAlloy)).addElement('K', GTStructureUtility.ofFrame((Materials)Materials.CosmicNeutronium)).addElement('L', StructureUtility.ofBlock((Block)ModBlocks.blockCustomMachineCasings, (int)3)).addElement('M', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)14)).addElement('N', StructureUtility.ofBlock((Block)TstBlocks.MetaBlockCasing01, (int)15)).addElement('O', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy)}).adder(GTCM_MultiMachineBase::addToMachineList).dot(1).casingIndex(TstBlocks.MetaBlockCasing01.getTextureIndex(15)).buildAndChain((Block)TstBlocks.MetaBlockCasing01, 15)).addElement('P', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy)}).adder(GTCM_MultiMachineBase::addToMachineList).dot(2).casingIndex(TstBlocks.MetaBlockCasing01.getTextureIndex(15)).buildAndChain((Block)TstBlocks.MetaBlockCasing01, 15)).addElement('S', (IStructureElement)GTStructureUtility.buildHatchAdder(TST_SwelegfyrBlastFurnace.class).hatchClass(MTEHatchInput.class).adder(TST_SwelegfyrBlastFurnace::addBlazeHatch).casingIndex(TstBlocks.MetaBlockCasing01.getTextureIndex(15)).dot(3).buildAndChain((Block)TstBlocks.MetaBlockCasing01, 15)).addElement('Z', StructureUtility.ofBlock((Block)TFFluids.fluidPyrotheum.getBlock(), (int)0)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.repairMachine();
        this.buildPiece("mainT" + this.controllerTier, stackSize, hintsOnly, 5, 17, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int structureTier = stackSize.field_77994_a > 1 ? 2 : 1;
        int built = this.survivalBuildPiece("mainT" + structureTier, stackSize, 5, 17, 1, elementBudget, env, false, true);
        int builtW = this.survivalBuildPiece("BlazeT" + structureTier, stackSize, 3, 10, -1, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        return built + builtW;
    }

    public void clearHatches() {
        super.clearHatches();
        this.glassTier = 0;
        this.mBlazeHatch = null;
        this.setCoilLevel(HeatingCoilLevel.None);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.recipeHeatLimitation = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN_T2, 5, 17, 1)) {
            this.clearHatches();
            if (!this.checkPiece(STRUCTURE_PIECE_MAIN_T1, 5, 17, 1) || this.controllerTier > 1) {
                return false;
            }
        }
        if (this.mHeatingCapacity < this.getCoilHeat()) {
            this.mHeatingCapacity = this.getCoilHeat();
        }
        this.maxHeatingCapacity = (int)(Math.floor(Math.pow(this.getCoilHeat(), 1.08) / 100.0) * 100.0 + 1.0);
        if (this.glassTier < 12) {
            for (MTEHatchEnergy mEnergyHatch : this.mEnergyHatches) {
                if (this.glassTier >= mEnergyHatch.mTier) continue;
                return false;
            }
            for (MTEHatch hatch : this.mExoticEnergyHatches) {
                if (this.glassTier >= hatch.mTier) continue;
                return false;
            }
        }
        this.recipeHeatLimitation = (int)this.getCoilLevel().getHeat() + 100 * (this.getTotalPowerTier() - 2);
        return this.mBlazeHatch != null;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.coilLevel;
    }

    public int getCoilHeat() {
        return (int)this.getCoilLevel().getHeat();
    }

    public void setCoilLevel(HeatingCoilLevel coilLevel) {
        this.coilLevel = coilLevel;
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (UpgradeItem == null) {
            UpgradeItem = GTCMItemList.SwelegfyrUpgradeChip.get(1, new Object[0]);
        }
    }

    private boolean setRemoveBlaze() {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        String[][] StructureDef = this.controllerTier > 1 ? shapeBlazeT2 : shapeBlazeT1;
        Block Air = Blocks.field_150350_a;
        Block Blaze = TFFluids.fluidPyrotheum.getBlock();
        boolean isFlipped = this.getFlip().isHorizontallyFlipped();
        int BlazeAmount = this.controllerTier > 1 ? 168000 : 72000;
        int OffSetX = 3;
        int OffSetY = 10;
        int OffSetZ = -1;
        if (!this.isBlazeFinishSet) {
            if (!this.drainPyrotheumFromBlazeHatch(BlazeAmount, false)) {
                return false;
            }
            this.drainPyrotheumFromBlazeHatch(BlazeAmount, true);
            this.isBlazeFinishClear = false;
            TstUtils.setStringBlockXZ(aBaseMetaTileEntity, OffSetX, OffSetY, OffSetZ, StructureDef, isFlipped, "Z", Blaze);
            this.isBlazeFinishSet = true;
            return true;
        }
        if (!this.isBlazeFinishClear) {
            this.isBlazeFinishSet = false;
            TstUtils.setStringBlockXZ(aBaseMetaTileEntity, OffSetX, OffSetY, OffSetZ, StructureDef, isFlipped, "Z", Air);
            this.isBlazeFinishClear = true;
            return true;
        }
        return false;
    }

    private boolean checkBlaze() {
        if (this.isBlazeFinishClear || !this.isBlazeFinishSet) {
            return !this.setRemoveBlaze();
        }
        return false;
    }

    public boolean addBlazeHatch(IGregTechTileEntity aTileEntity, short aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture((int)aBaseCasingIndex);
            ((MTEHatchInput)aMetaTileEntity).mRecipeMap = null;
            this.mBlazeHatch = (MTEHatchInput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.blastFurnaceRecipes;
    }

    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.blastFurnaceRecipes);
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return false;
    }

    @Override
    protected float getSpeedBonus() {
        return 1.0f / (this.isPassiveMode ? Config.SpeedMultiplier_PassiveMode_SwelegfyrBlastFurnace : Config.SpeedMultiplier_NormalMode_SwelegfyrBlastFurnace);
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.isPassiveMode ? Config.Parallel_PassiveMode_SwelegfyrBlastFurnace : Config.Parallel_NormalMode_SwelegfyrBlastFurnace;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                TST_SwelegfyrBlastFurnace.this.inPassiveMode = TST_SwelegfyrBlastFurnace.this.isPassiveMode;
                if (TST_SwelegfyrBlastFurnace.this.previousRecipeCode != recipe.hashCode() && TST_SwelegfyrBlastFurnace.this.previousRecipeCode == 0) {
                    TST_SwelegfyrBlastFurnace.this.previousRecipeCode = recipe.hashCode();
                    TST_SwelegfyrBlastFurnace.this.mHeatingCapacity = TST_SwelegfyrBlastFurnace.this.getCoilHeat();
                }
                this.euModifier = (float)Math.pow(0.9, Math.max(TST_SwelegfyrBlastFurnace.this.mHeatingCapacity - recipe.mSpecialValue, 0) / 1800);
                return recipe.mSpecialValue <= TST_SwelegfyrBlastFurnace.this.recipeHeatLimitation ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.insufficientHeat((int)recipe.mSpecialValue);
            }

            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setRecipeHeat(recipe.mSpecialValue).setMachineHeat(TST_SwelegfyrBlastFurnace.this.mHeatingCapacity).setHeatOC(true).setHeatDiscount(true);
            }

            @Nonnull
            public CheckRecipeResult process() {
                this.setSpeedBonus(TST_SwelegfyrBlastFurnace.this.getSpeedBonus());
                this.setEuModifier(TST_SwelegfyrBlastFurnace.this.getEuModifier());
                if (TST_SwelegfyrBlastFurnace.this.checkBlaze()) {
                    return TST_SwelegfyrBlastFurnace.this.shutDownOfMissingPyrotheum(TST_SwelegfyrBlastFurnace.this.controllerTier > 1 ? 168000 : 72000);
                }
                if (TST_SwelegfyrBlastFurnace.this.isPassiveMode && TST_SwelegfyrBlastFurnace.this.isRapidHeating) {
                    TST_SwelegfyrBlastFurnace.this.inPassiveMode = true;
                    TST_SwelegfyrBlastFurnace.this.inRapidHeating = true;
                    return this.RapidHeating();
                }
                TST_SwelegfyrBlastFurnace.this.inRapidHeating = false;
                return super.process();
            }

            private CheckRecipeResult RapidHeating() {
                if (TST_SwelegfyrBlastFurnace.this.mHeatingCapacity < TST_SwelegfyrBlastFurnace.this.maxHeatingCapacity) {
                    int euTier = (int)Math.max(0.0, Math.log((double)(this.availableVoltage * this.availableAmperage) / 8.0) / Math.log(4.0));
                    if (euTier < 1) {
                        TST_SwelegfyrBlastFurnace.this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
                    }
                    TST_SwelegfyrBlastFurnace.this.correctBlazeCost = TST_SwelegfyrBlastFurnace.this.mHeatingCapacity * TST_SwelegfyrBlastFurnace.this.maxHeatingCapacity / (int)Math.pow(euTier, 3.0);
                    if (!TST_SwelegfyrBlastFurnace.this.drainPyrotheumFromBlazeHatch(TST_SwelegfyrBlastFurnace.this.correctBlazeCost, true)) {
                        return TST_SwelegfyrBlastFurnace.this.shutDownOfMissingPyrotheum(TST_SwelegfyrBlastFurnace.this.correctBlazeCost);
                    }
                    this.calculatedEut = this.availableVoltage * this.availableAmperage * 15L / 16L;
                    this.duration = 20;
                    TST_SwelegfyrBlastFurnace.this.mHeatingCapacity = RecipeMathUtils.numericalApproximation(TST_SwelegfyrBlastFurnace.this.mHeatingCapacity, TST_SwelegfyrBlastFurnace.this.maxHeatingCapacity, 100);
                    return CheckRecipeResults.RapidHeating;
                }
                TST_SwelegfyrBlastFurnace.this.correctBlazeCost = TST_SwelegfyrBlastFurnace.this.mHeatingCapacity / 20;
                if (!TST_SwelegfyrBlastFurnace.this.drainPyrotheumFromBlazeHatch(TST_SwelegfyrBlastFurnace.this.correctBlazeCost * 10, true)) {
                    return TST_SwelegfyrBlastFurnace.this.shutDownOfMissingPyrotheum(TST_SwelegfyrBlastFurnace.this.correctBlazeCost * 10);
                }
                this.duration = 200;
                return CheckRecipeResults.RapidHeatFinish;
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.runningTick % 20L == 0L) {
            if (!this.isPassiveMode) {
                this.correctBlazeCost = 1000;
                if (!this.drainPyrotheumFromBlazeHatch(this.correctBlazeCost, true)) {
                    this.stopMachineOfMissingPyrotheum(this.correctBlazeCost);
                    return false;
                }
            } else if (this.inPassiveMode && !this.isRapidHeating) {
                this.correctBlazeCost = this.mHeatingCapacity / 5;
                if (!this.drainPyrotheumFromBlazeHatch(this.correctBlazeCost, true)) {
                    this.stopMachineOfMissingPyrotheum(this.correctBlazeCost);
                    return false;
                }
                this.mHeatingCapacity = RecipeMathUtils.numericalApproximation(this.mHeatingCapacity, this.maxHeatingCapacity, 5);
            }
            this.runningTick = 1L;
        } else {
            ++this.runningTick;
        }
        return super.onRunningTick(aStack);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            ItemStack ControllerSlot;
            if (this.controllerTier == 1 && aTick % 20L == 0L && GTUtility.areStacksEqual((ItemStack)UpgradeItem, (ItemStack)(ControllerSlot = this.getControllerSlot()))) {
                this.controllerTier = (byte)2;
                this.mInventory[1] = ItemUtils.depleteStack((ItemStack)ControllerSlot, (int)1);
                this.func_70296_d();
                this.mUpdated = true;
            }
            if (aTick % 200L == 0L) {
                boolean isActive = aBaseMetaTileEntity.isActive();
                if (!isActive && this.isPassiveMode && !this.isRapidHeating && this.isHoldingHeat) {
                    if (this.checkBlaze()) {
                        this.mHeatingCapacity = this.getCoilHeat();
                        this.isHoldingHeat = false;
                        return;
                    }
                    this.correctBlazeCost = this.mHeatingCapacity / 20;
                    if (!this.drainPyrotheumFromBlazeHatch(this.correctBlazeCost * 10, true)) {
                        this.isHoldingHeat = false;
                    }
                } else if (!this.isPassiveMode || !isActive && !this.isHoldingHeat) {
                    double lossRat;
                    int targetHeat = this.getCoilHeat();
                    double d = lossRat = isActive && !this.isPassiveMode ? 0.1 : 0.2;
                    if (!isActive && !this.isHoldingHeat) {
                        this.correctBlazeCost = 0;
                    }
                    if (this.mHeatingCapacity != targetHeat) {
                        int delta = (int)((double)Math.abs(this.mHeatingCapacity - targetHeat) * lossRat);
                        this.mHeatingCapacity = RecipeMathUtils.numericalApproximation(this.mHeatingCapacity, targetHeat, delta > 0 ? delta : 1);
                    }
                }
            }
        }
    }

    private boolean drainPyrotheumFromBlazeHatch(int amount, boolean doDrain) {
        return this.drain((MTEHatch)this.mBlazeHatch, new FluidStack(TFFluids.fluidPyrotheum, amount), doDrain);
    }

    private void stopMachineOfMissingPyrotheum(int amount) {
        this.stopMachine(ShutDownReasonRegistry.outOfFluid((FluidStack)new FluidStack(TFFluids.fluidPyrotheum, amount)));
    }

    private CheckRecipeResult shutDownOfMissingPyrotheum(int amount) {
        return SimpleResultWithText.outOfFluid(new FluidStack(TFFluids.fluidPyrotheum, amount));
    }

    public void stopMachine(@NotNull ShutDownReason reason) {
        this.runningTick = 0L;
        this.previousRecipeCode = 0;
        this.mHeatingCapacity = this.getCoilHeat();
        super.stopMachine(reason);
    }

    @Override
    public int totalMachineMode() {
        return 2;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.add(UITextures.SBF_ModeBase);
        this.machineModeIcons.add(UITextures.SBF_ModePassive);
    }

    public void setMachineMode(int index) {
        super.setMachineMode(index);
        this.isPassiveMode = index != 0;
    }

    @Override
    public String getMachineModeName(int mode) {
        return this.getMachineModeName(mode != 0, this.inPassiveMode, this.inRapidHeating);
    }

    public String getMachineModeName(boolean isPassiveMode, boolean inPassiveMode, boolean inRapidHeating) {
        int correctMode = 0;
        boolean isActive = this.getBaseMetaTileEntity().isActive();
        String suffixKey = null;
        if (isActive) {
            if (inPassiveMode) {
                correctMode = 1;
                if (inRapidHeating) {
                    suffixKey = "SBF.Msg.enableRapidHeating";
                }
            }
        } else if (isPassiveMode) {
            correctMode = 1;
            if (this.isHoldingHeat) {
                suffixKey = "SBF.Msg.enableHoldingHeat";
            }
        }
        String base = StatCollector.func_74838_a((String)("Swelegfyr.modeMsg." + correctMode));
        if (suffixKey != null) {
            return base + "-" + StatCollector.func_74838_a((String)suffixKey);
        }
        return base;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)this.createBlazeStatusButton((IWidgetBuilder<?>)builder));
        builder.widget((Widget)this.createRapidHeatingButton((IWidgetBuilder<?>)builder));
        builder.widget((Widget)this.createHoldingHeatButton((IWidgetBuilder<?>)builder));
    }

    public ButtonWidget createBlazeStatusButton(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.checkStructure(true) && !this.getBaseMetaTileEntity().isActive()) {
                this.setRemoveBlaze();
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> layers = new ArrayList<UITexture>();
            if (!this.isBlazeFinishClear) {
                layers.add(GTUITextures.BUTTON_STANDARD);
                layers.add(UITextures.SBF_BlazeClear);
            } else if (!this.isBlazeFinishSet) {
                layers.add(GTUITextures.BUTTON_STANDARD);
                layers.add(UITextures.SBF_BlazeSet);
            }
            return layers.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.isBlazeFinishSet, val -> {
            this.isBlazeFinishSet = val;
        }), builder).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.isBlazeFinishClear, val -> {
            this.isBlazeFinishClear = val;
        }), builder).addTooltip(StatCollector.func_74838_a((String)"SBF.Msg.setOrClearBlaze")).setTooltipShowUpDelay(5).setPos(98, 91).setSize(16, 16);
        return (ButtonWidget)button;
    }

    public ButtonWidget createRapidHeatingButton(IWidgetBuilder<?> builder) {
        if (this.controllerTier != 2) {
            return null;
        }
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.isPassiveMode) {
                this.setRapidHeating(!this.isRapidHeating);
                if (this.isRapidHeating) {
                    this.isHoldingHeat = false;
                }
            }
        }).setPlayClickSound(this.isPassiveMode).setBackground(() -> {
            ArrayList<UITexture> layers = new ArrayList<UITexture>();
            if (this.isPassiveMode) {
                if (this.getRapidHeating()) {
                    layers.add(GTUITextures.BUTTON_STANDARD_PRESSED);
                    layers.add(UITextures.SBF_RapidHeating_On);
                } else {
                    layers.add(GTUITextures.BUTTON_STANDARD);
                    layers.add(UITextures.SBF_RapidHeating_Off);
                }
            } else {
                layers.add(GTUITextures.BUTTON_STANDARD);
                layers.add(UITextures.SBF_RapidHeating_Forbidden);
            }
            return layers.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(this::getRapidHeating, this::setRapidHeating), builder).addTooltip(StatCollector.func_74838_a((String)"SBF.Msg.enableRapidHeating")).setTooltipShowUpDelay(5).setPos(116, 91).setSize(16, 16);
        return (ButtonWidget)button;
    }

    public boolean getRapidHeating() {
        return this.isRapidHeating;
    }

    public void setRapidHeating(boolean b) {
        this.isRapidHeating = b;
    }

    public ButtonWidget createHoldingHeatButton(IWidgetBuilder<?> builder) {
        if (this.controllerTier != 2) {
            return null;
        }
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.isPassiveMode) {
                this.setHoldingHeat(!this.isHoldingHeat);
                if (this.isHoldingHeat) {
                    this.isRapidHeating = false;
                }
            }
        }).setPlayClickSound(this.isPassiveMode).setBackground(() -> {
            ArrayList<UITexture> layers = new ArrayList<UITexture>();
            if (this.isPassiveMode) {
                if (this.getHoldingHeat()) {
                    layers.add(GTUITextures.BUTTON_STANDARD_PRESSED);
                    layers.add(UITextures.SBF_HoldingHeat_On);
                } else {
                    layers.add(GTUITextures.BUTTON_STANDARD);
                    layers.add(UITextures.SBF_HoldingHeat_Off);
                }
            } else {
                layers.add(GTUITextures.BUTTON_STANDARD);
                layers.add(UITextures.SBF_HoldingHeat_Forbidden);
            }
            return layers.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(this::getHoldingHeat, this::setHoldingHeat), builder).addTooltip(StatCollector.func_74838_a((String)"SBF.Msg.enableHoldingHeat")).setTooltipShowUpDelay(5).setPos(134, 91).setSize(16, 16);
        return (ButtonWidget)button;
    }

    public boolean getHoldingHeat() {
        return this.isHoldingHeat;
    }

    public void setHoldingHeat(boolean b) {
        this.isHoldingHeat = b;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        ItemStack heldItem;
        if (this.controllerTier == 1 && !aPlayer.func_70093_af() && GTUtility.areStacksEqual((ItemStack)UpgradeItem, (ItemStack)(heldItem = aPlayer.func_70694_bm()))) {
            this.controllerTier = (byte)2;
            aPlayer.func_70062_b(0, ItemUtils.depleteStack((ItemStack)heldItem, (int)1));
            if (this.getBaseMetaTileEntity().isServerSide()) {
                this.func_70296_d();
                aPlayer.field_71071_by.func_70296_d();
                this.mUpdated = true;
            }
            if (this.isBlazeFinishSet) {
                this.setRemoveBlaze();
            }
            return true;
        }
        return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
    }

    public void onValueUpdate(byte aValue) {
        this.controllerTier = aValue;
    }

    public byte getUpdateData() {
        return this.controllerTier;
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        if (this.controllerTier > 1) {
            aNBT.func_74774_a("mTier", this.controllerTier);
        }
    }

    public void initDefaultModes(NBTTagCompound aNBT) {
        super.initDefaultModes(aNBT);
        this.controllerTier = aNBT == null || !aNBT.func_74764_b("mTier") ? (byte)1 : aNBT.func_74771_c("mTier");
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mTier", this.controllerTier);
        aNBT.func_74774_a("mGlass", this.glassTier);
        aNBT.func_74774_a("mMode", (byte)this.machineMode);
        aNBT.func_74768_a("mHeatingCapacity", this.mHeatingCapacity);
        aNBT.func_74757_a("isBlazeFinishSet", this.isBlazeFinishSet);
        aNBT.func_74757_a("isBlazeFinishClear", this.isBlazeFinishClear);
        aNBT.func_74757_a("isPassiveMode", this.isPassiveMode);
        aNBT.func_74757_a("inPassiveMode", this.inPassiveMode);
        aNBT.func_74757_a("isRapidHeating", this.isRapidHeating);
        aNBT.func_74757_a("inRapidHeating", this.inRapidHeating);
        aNBT.func_74757_a("isHoldingHeat", this.isHoldingHeat);
        aNBT.func_74768_a("previousRecipeCode", this.previousRecipeCode);
        aNBT.func_74768_a("correctBlazeCost", this.correctBlazeCost);
        aNBT.func_74768_a("recipeHeatLimitation", this.recipeHeatLimitation);
        aNBT.func_74772_a("runningTick", this.runningTick);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.controllerTier = aNBT.func_74771_c("mTier");
        this.glassTier = aNBT.func_74771_c("mGlass");
        this.machineMode = aNBT.func_74771_c("mMode");
        this.mHeatingCapacity = aNBT.func_74762_e("mHeatingCapacity");
        this.isBlazeFinishSet = aNBT.func_74767_n("isBlazeFinishSet");
        this.isBlazeFinishClear = aNBT.func_74767_n("isBlazeFinishClear");
        this.isPassiveMode = aNBT.func_74767_n("isPassiveMode");
        this.inPassiveMode = aNBT.func_74767_n("inPassiveMode");
        this.isRapidHeating = aNBT.func_74767_n("isRapidHeating");
        this.inRapidHeating = aNBT.func_74767_n("inRapidHeating");
        this.isHoldingHeat = aNBT.func_74767_n("isHoldingHeat");
        this.previousRecipeCode = aNBT.func_74762_e("previousRecipeCode");
        this.correctBlazeCost = aNBT.func_74762_e("correctBlazeCost");
        this.recipeHeatLimitation = aNBT.func_74762_e("recipeHeatLimitation");
        this.runningTick = aNBT.func_74763_f("runningTick");
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        IGregTechTileEntity tileEntity = this.getBaseMetaTileEntity();
        if (tileEntity != null) {
            tag.func_74768_a("recipeHeatLimitation", this.recipeHeatLimitation);
            tag.func_74768_a("mHeatingCapacity", this.mHeatingCapacity);
            tag.func_74768_a("maxHeatingCapacity", this.maxHeatingCapacity);
            tag.func_74768_a("correctBlazeCost", this.correctBlazeCost);
            tag.func_74757_a("isPassiveMode", this.isPassiveMode);
            tag.func_74757_a("inPassiveMode", this.inPassiveMode);
            tag.func_74757_a("inRapidHeating", this.inRapidHeating);
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        boolean IsPassiveMode = tag.func_74767_n("isPassiveMode");
        boolean InPassiveMode = tag.func_74767_n("inPassiveMode");
        boolean InRapidHeating = tag.func_74767_n("inRapidHeating");
        boolean IsActive = this.getBaseMetaTileEntity().isActive();
        if (tag.func_74764_b("mode")) {
            currentTip.removeIf(s -> s.contains(StatCollector.func_74838_a((String)"GT5U.machines.oreprocessor1")));
            currentTip.add(StatCollector.func_74838_a((String)"GT5U.machines.oreprocessor1") + " " + EnumChatFormatting.WHITE + this.getMachineModeName(IsPassiveMode, InPassiveMode, InRapidHeating) + EnumChatFormatting.RESET);
        }
        currentTip.add(EnumChatFormatting.YELLOW + TextEnums.tr("Waila.SBF.0") + TextLocalization.textColon + EnumChatFormatting.WHITE + tag.func_74762_e("recipeHeatLimitation") + TextLocalization.Kelvin);
        currentTip.add(EnumChatFormatting.YELLOW + TextEnums.tr("Waila.SBF.1") + TextLocalization.textColon + EnumChatFormatting.WHITE + tag.func_74762_e("mHeatingCapacity") + TextLocalization.Kelvin);
        if (IsActive && InPassiveMode || !IsActive && IsPassiveMode) {
            currentTip.add(EnumChatFormatting.YELLOW + TextEnums.tr("Waila.SBF.2") + TextLocalization.textColon + EnumChatFormatting.WHITE + tag.func_74762_e("maxHeatingCapacity") + TextLocalization.Kelvin);
        }
        currentTip.add(EnumChatFormatting.YELLOW + TextEnums.tr("Waila.SBF.3") + TextLocalization.textColon + EnumChatFormatting.WHITE + tag.func_74762_e("correctBlazeCost") + " L/s");
    }

    @Override
    public String[] getInfoData() {
        String[] origin = super.getInfoData();
        String[] ret = new String[origin.length + 2];
        System.arraycopy(origin, 0, ret, 0, origin.length);
        ret[origin.length] = EnumChatFormatting.AQUA + TextEnums.tr("Waila.SBF.0") + TextLocalization.textColon + EnumChatFormatting.GOLD + this.recipeHeatLimitation + TextLocalization.Kelvin;
        ret[origin.length + 1] = EnumChatFormatting.AQUA + TextEnums.tr("Waila.SBF.1") + TextLocalization.textColon + EnumChatFormatting.GOLD + this.mHeatingCapacity + TextLocalization.Kelvin;
        return ret;
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        ITexture base = Textures.BlockIcons.casingTexturePages[115][TstBlocks.MetaBlockCasing01.getTextureIndexInPage(15)];
        if (side == facing) {
            if (active) {
                return new ITexture[]{base, TextureFactory.builder().addIcon((IIconContainer)TexturesGtBlock.oMCAAdvancedEBF).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TexturesGtBlock.oMCAAdvancedEBFActive).extFacing().glow().build()};
            }
            return new ITexture[]{base, TextureFactory.builder().addIcon((IIconContainer)TexturesGtBlock.oMCAAdvancedEBF).extFacing().glow().build()};
        }
        return new ITexture[]{base};
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace_MachineType")).addInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace_Controller")).addInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.01")).addInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.02")).addInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.03")).addInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.04")).addInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.05")).addInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.06")).addInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.07")).addInfo(TextLocalization.textSpace).addInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.08")).addSeparator().addInfo(TextEnums.MoreInfoCheckingInScanner.getText()).addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addStructureInfo(TextLocalization.Text_SeparatingLine).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.11")).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.12")).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.13")).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.14")).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.15")).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.16")).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.17")).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.18")).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.21")).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.22")).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.23")).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.24")).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.25")).addStructureInfo(TextLocalization.Text_SeparatingLine).addStructureInfo(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.tooltips.structureWarn")).addStructureInfo(TextLocalization.Tooltip_DoNotNeedMaintenance).addController(TextLocalization.textFrontBottom).addInputHatch(TextLocalization.getBlueprintWithDot(1), new int[]{1}).addOutputHatch(TextLocalization.getBlueprintWithDot(1), new int[]{1}).addInputBus(TextLocalization.getBlueprintWithDot(1), new int[]{1}).addOutputBus(TextLocalization.getBlueprintWithDot(1), new int[]{1}).addEnergyHatch(TextLocalization.getBlueprintWithDot(2), new int[]{2}).addOtherStructurePart(TextEnums.tr("Tooltip_SwelegfyrBlastFurnace.31"), TextLocalization.getBlueprintWithDot(3), new int[]{3}).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }
}

