/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.client.texture.TstMachineTextures;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.processingLogics.TstProcessingLogic;
import com.Nxer.TwistSpaceTechnology.system.ProcessingArrayBackend.PAHelper;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEBasicMachineWithRecipe;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMetadataKey;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.recipe.metadata.CompressionTierKey;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class TST_ProcessingArray
extends GTCM_MultiMachineBase<TST_ProcessingArray> {
    public TST_ItemID internalMachine;
    public RecipeMap<?> recipeMap;
    public long voltage;
    public SoundResource sound = SoundResource.NONE;
    protected static final int horizontalOffSet = 1;
    protected static final int verticalOffSet = 1;
    protected static final int depthOffSet = 0;
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    protected static IStructureDefinition<TST_ProcessingArray> STRUCTURE_DEFINITION = null;

    public TST_ProcessingArray(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_ProcessingArray(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_ProcessingArray(this.mName);
    }

    public void checkInternalMachine() {
        ItemStack controllerStack = this.getControllerSlot();
        if (controllerStack == null || controllerStack.field_77994_a < 1) {
            this.resetMachineInfo();
            return;
        }
        if (this.internalMachine == null || !this.internalMachine.equalItemStack(controllerStack)) {
            MTEBasicMachineWithRecipe mte = PAHelper.getMTE(controllerStack);
            if (mte == null) {
                this.resetMachineInfo();
            } else {
                this.internalMachine = TST_ItemID.createNoNBT(controllerStack);
                this.recipeMap = PAHelper.getRecipeMapFromMTE(mte);
                this.maxParallel = controllerStack.field_77994_a;
                this.voltage = PAHelper.getVoltageFromMTE(mte);
                this.sound = PAHelper.getSoundFromMTE(mte);
                for (MTEHatchInputBus tInputBus : this.mInputBusses) {
                    tInputBus.mRecipeMap = this.recipeMap;
                }
                for (MTEHatchInput tInputHatch : this.mInputHatches) {
                    tInputHatch.mRecipeMap = this.recipeMap;
                }
            }
        }
        this.maxParallel = controllerStack.field_77994_a;
    }

    public void resetMachineInfo() {
        if (this.internalMachine == null) {
            return;
        }
        this.internalMachine = null;
        this.maxParallel = 0;
        this.voltage = 0L;
        this.recipeMap = null;
        this.sound = SoundResource.NONE;
        for (MTEHatchInputBus tInputBus : this.mInputBusses) {
            tInputBus.mRecipeMap = null;
        }
        for (MTEHatchInput tInputHatch : this.mInputHatches) {
            tInputHatch.mRecipeMap = null;
        }
    }

    protected void sendStartMultiBlockSoundLoop() {
        if (this.sound != null && this.sound != SoundResource.NONE) {
            this.sendLoopStart((byte)this.sound.id);
        }
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        SoundResource sound = SoundResource.get((int)(aIndex < 0 ? aIndex + 256 : 0));
        if (sound != null) {
            GTUtility.doSoundAtClient((SoundResource)sound, (int)this.getTimeBetweenProcessSounds(), (float)1.0f, (double)aX, (double)aY, (double)aZ);
        }
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        this.checkInternalMachine();
        if (this.internalMachine == null) {
            return SimpleCheckRecipeResult.ofFailure((String)"no_machine");
        }
        return super.checkProcessing();
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new TstProcessingLogic(){

            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if ((Integer)recipe.getMetadataOrDefault((RecipeMetadataKey)CompressionTierKey.INSTANCE, (Object)0) > 0) {
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                if ((long)recipe.mEUt > this.availableVoltage) {
                    return CheckRecipeResultRegistry.insufficientPower((long)recipe.mEUt);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(this.voltage);
        logic.setAvailableAmperage((long)this.getMaxParallelRecipes());
        logic.setAmperageOC(false);
    }

    public RecipeMap<?> getRecipeMap() {
        return this.recipeMap;
    }

    protected boolean canUseControllerSlotForRecipe() {
        return false;
    }

    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Collections.emptyList();
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        if (this.recipeMap != null) {
            tag.func_74778_a("recipeMap", this.recipeMap.unlocalizedName);
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("recipeMap")) {
            currentTip.add(TextEnums.tr("TST_ProcessingArray.Waila.Machine") + " : " + EnumChatFormatting.YELLOW + TextEnums.tr(tag.func_74779_i("recipeMap")));
        }
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 1, 0)) {
            return false;
        }
        this.checkInternalMachine();
        return true;
    }

    public void construct(ItemStack aStack, boolean aHintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, aStack, aHintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public IStructureDefinition<TST_ProcessingArray> getStructureDefinition() {
        if (null == STRUCTURE_DEFINITION) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"hhh", "hhh", "hhh"}, {"h~h", "h h", "hhh"}, {"hhh", "hhh", "hhh"}})).addElement('h', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.OutputHatch, HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy)}).adder(GTCM_MultiMachineBase::addToMachineList).dot(1).casingIndex(48).buildAndChain(GregTechAPI.sBlockCasings4, 0)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48]};
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tooltips = new MultiblockTooltipBuilder();
        tooltips.addMachineType(TextEnums.tr("TST_ProcessingArray.tooltips.MachineType")).addInfo(TextEnums.Machine_of_TwistSpaceTechnology.getText()).addInfo(TextEnums.tr("TST_ProcessingArray.tooltips.01")).addInfo(TextEnums.tr("TST_ProcessingArray.tooltips.02")).addInfo(TextEnums.tr("TST_ProcessingArray.tooltips.03")).addInfo(TextEnums.tr("TST_ProcessingArray.tooltips.04")).addInfo(TextEnums.tr("TST_ProcessingArray.tooltips.05")).beginStructureBlock(3, 3, 3, true).addController(TextLocalization.textFrontCenter).addEnergyHatch(TextLocalization.textAnyCasing, new int[]{1}).addInputBus(TextLocalization.textAnyCasing, new int[]{1}).addInputHatch(TextLocalization.textAnyCasing, new int[]{1}).addOutputBus(TextLocalization.textAnyCasing, new int[]{1}).addOutputHatch(TextLocalization.textAnyCasing, new int[]{1}).toolTipFinisher(new String[0]);
        return tooltips;
    }
}

