/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.machine.ValueEnum;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.blocks.tileEntity.MTEEssentiaOutputHatch;
import goodgenerator.blocks.tileEntity.base.MTETooltipMultiBlockBaseEM;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchMuffler;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.visnet.VisNetHandler;
import thaumcraft.common.config.ConfigBlocks;

public class TST_PrimordialDisjunctus
extends MTETooltipMultiBlockBaseEM
implements IConstructable,
ISurvivalConstructable {
    private static final int CASING_INDEX = 1536;
    private final ArrayList<MTEEssentiaOutputHatch> mEssentiaOutputHatches = new ArrayList();
    public AspectList mOutputAspects = new AspectList();
    protected int mCasing = 0;
    protected double mParallel = 0.0;
    private int pTier = 0;
    protected int primalAspectsGenerated = 0;
    protected int nodeIncrease = 0;
    protected int nodePurificationEfficiency = 0;
    private static final int SECOND_IN_TICKS = 20;
    private static final int RECIPE_EUT = 1920;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private IStructureDefinition<TST_PrimordialDisjunctus> multiDefinition = null;
    private static final int STANDARD_RECIPE_DURATION = ValueEnum.BaseRecipeDuration_PrimordialDisjunctus;
    private static final int STANDARD_DIFFUSION_CELL_PARALLEL = ValueEnum.DiffusionCellParallel_PrimordialDisjunctus;
    private static final int STANDARD_PRIMAL_ASPECTS_PER_PARALLEL = ValueEnum.PrimalAspectsPerParallel_PrimordialDisjunctus;
    private static final int STANDARD_PURIFICATION_GAIN_MULTIPLIER = ValueEnum.PurificationGainMultiplier_PrimordialDisjunctus;
    private static final int STANDARD_PURIFICATION_REDUCTION = ValueEnum.PurificationReduction_PrimordialDisjunctus;
    private static final int STANDARD_BOOST_MULTIPLIER = ValueEnum.BoostMultiplier_PrimordialDisjunctus;
    private static final int STANDARD_BOOST_GAIN_MULTIPLIER = ValueEnum.BoostGainMultiplier_PrimordialDisjunctus;
    private static final int STANDARD_BOOST_REDUCTION = ValueEnum.BoostReduction_PrimordialDisjunctus;
    private final XSTR xstr = new XSTR();
    private static final String[][] shapePrimordialDisjunctus = new String[][]{{"               ", "               ", "ABA         ABA", "ABA         ABA", "BCB         BCB", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "               ", "   DDDDDDDDD   ", "   DBBBEBBBD   ", "   DBFBEBFBD   ", "   DBBBEBBBD   ", "   DEEEKEEED   ", "   DBBBEBBBD   ", "   DBFBEBFBD   ", "   DBBBEBBBD   ", "   DDDDDDDDD   ", "               ", "               ", "               "}, {"               ", "ABA         ABA", " J           J ", "   GGGGGGGGG   ", "   G       G   ", "   G       G   ", "   G       G   ", "   G   H   G   ", "   G       G   ", "   G       G   ", "   G       G   ", "   GGGGGGGGG   ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "J J         J J", " J GGGGGGGGG J ", "   G   I   G   ", "   G   I   G   ", "   G   I   G   ", "   GIIIHIIIG   ", "   G   I   G   ", "   G   I   G   ", "   G   I   G   ", "   GGGGGGGGG   ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "               ", "J JGGGGGGGGGJ J", " J G       G J ", "   G       G   ", "   G       G   ", "   G   H   G   ", "   G       G   ", "   G       G   ", "   G       G   ", "   GGGGGGGGG   ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "               ", "   GGGGGGGGG   ", "J JG       GJ J", " J G I   I G J ", "   G  I I  G   ", "   G   H   G   ", "   G  I I  G   ", "   G I   I G   ", "   G       G   ", "   GGGGGGGGG   ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "               ", "   GGGGGGGGG   ", "   G       G   ", "J JG       GJ J", " J G       G J ", "   G   H   G   ", "   G       G   ", "   G       G   ", "   G       G   ", "   GGGGGGGGG   ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "               ", "   GGGGGGGGG   ", "   G       G   ", "   G   I   G   ", "J JG   I   GJ J", " J G IIHII G J ", "   G   I   G   ", "   G   I   G   ", "   G       G   ", "   GGGGGGGGG   ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "               ", "   GGGGGGGGG   ", "   G       G   ", "   G       G   ", "   G       G   ", "J JG   H   GJ J", " J G       G J ", "   G       G   ", "   G       G   ", "   GGGGGGGGG   ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "               ", "   GGGGGGGGG   ", "   G       G   ", "   G       G   ", "   G  I I  G   ", "   G   H   G   ", "J JG  I I  GJ J", " J G       G J ", "   G       G   ", "   GGGGGGGGG   ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "               ", "   GGGGGGGGG   ", "   G       G   ", "   G       G   ", "   G       G   ", "   G   H   G   ", "   G       G   ", "J JG       GJ J", " J G       G J ", "   GGGGGGGGG   ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "               ", "   GGGGGGGGG   ", "   G       G   ", "   G       G   ", "   G   I   G   ", "   G  IHI  G   ", "   G   I   G   ", "   G       G   ", "J JG       GJ J", " J GGGGGGGGG J ", "               ", "               ", "               "}, {"               ", "ABA         ABA", "               ", "   GGGGGGGGG   ", "   G       G   ", "   G       G   ", "   G       G   ", "   G   H   G   ", "   G       G   ", "   G       G   ", "   G       G   ", "J JGGGGGGGGGJ J", " J           J ", "               ", "               "}, {"BBB         BBB", "ABBBBBB~BBBBBBA", "AAA         AAA", "AAADDDDDDDDDAAA", "AAADDDDDDDDDAAA", "AAADDDDDDDDDAAA", "AAADDDDDDDDDAAA", "AAADDDDDDDDDAAA", "AAADDDDDDDDDAAA", "AAADDDDDDDDDAAA", "AAADDDDDDDDDAAA", "AAADDDDDDDDDAAA", "AAA         AAA", "AAA         AAA", "AAA         AAA"}};

    public TST_PrimordialDisjunctus(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected void clearHatches_EM() {
        super.clearHatches_EM();
        this.mEssentiaOutputHatches.clear();
    }

    public TST_PrimordialDisjunctus(String mName) {
        super(mName);
    }

    public IStructureDefinition<? extends TTMultiblockBase> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])shapePrimordialDisjunctus)).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0)).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(TST_PrimordialDisjunctus.class).atLeast(new IHatchElement[]{HatchElement.Energy, HatchElement.InputBus, HatchElement.InputHatch}).casingIndex(1536).dot(1).build(), StructureUtility.ofSpecificTileAdder(TST_PrimordialDisjunctus::addEssentiaOutputHatchToMachineList, MTEEssentiaOutputHatch.class, (Block)Loaders.essentiaOutputHatch, (int)0), StructureUtility.onElementPass(TST_PrimordialDisjunctus::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)Loaders.magicCasing, (int)0))})).addElement('C', HatchElement.InputHatch.newAny(1536, 2)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)0)).addElement('E', HatchElement.Muffler.newAny(1536, 3)).addElement('F', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(x -> x.onEssentiaCellFound(0), (IStructureElement)StructureUtility.ofBlock((Block)Loaders.essentiaCell, (int)0)), StructureUtility.onElementPass(x -> x.onEssentiaCellFound(1), (IStructureElement)StructureUtility.ofBlock((Block)Loaders.essentiaCell, (int)1)), StructureUtility.onElementPass(x -> x.onEssentiaCellFound(2), (IStructureElement)StructureUtility.ofBlock((Block)Loaders.essentiaCell, (int)2)), StructureUtility.onElementPass(x -> x.onEssentiaCellFound(3), (IStructureElement)StructureUtility.ofBlock((Block)Loaders.essentiaCell, (int)3))})).addElement('G', StructureUtility.ofBlock((Block)ConfigBlocks.blockCosmeticOpaque, (int)2)).addElement('H', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)15)).addElement('K', StructureUtility.ofBlock((Block)Loaders.essentiaFilterCasing, (int)0)).addElement('J', GTStructureUtility.ofFrame((Materials)Materials.Steel)).addElement('I', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)0)).build();
        }
        return this.multiDefinition;
    }

    public String[] getInfoData() {
        String[] inInfo = super.getInfoData();
        String[] outInfo = new String[inInfo.length + 3];
        System.arraycopy(inInfo, 0, outInfo, 0, inInfo.length);
        outInfo[inInfo.length] = EnumChatFormatting.AQUA + "Generating: " + EnumChatFormatting.GOLD + this.primalAspectsGenerated + " Primal Aspects";
        outInfo[inInfo.length + 1] = EnumChatFormatting.AQUA + "Boost: " + EnumChatFormatting.GOLD + this.nodeIncrease + "%";
        outInfo[inInfo.length + 2] = EnumChatFormatting.AQUA + "Purification Efficiency: " + EnumChatFormatting.GOLD + this.nodePurificationEfficiency + "%";
        return outInfo;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74780_a("mParallel", this.mParallel);
        aNBT.func_74780_a("nodePurificationEfficiency", (double)this.nodePurificationEfficiency);
        aNBT.func_74780_a("nodeIncrease", (double)this.nodeIncrease);
        Aspect[] aspectA = this.mOutputAspects.getAspects();
        NBTTagList nbtTagList = new NBTTagList();
        for (Aspect aspect : aspectA) {
            if (aspect == null) continue;
            NBTTagCompound f = new NBTTagCompound();
            f.func_74778_a("key", aspect.getTag());
            f.func_74768_a("amount", this.mOutputAspects.getAmount(aspect));
            nbtTagList.func_74742_a((NBTBase)f);
        }
        aNBT.func_74782_a("Aspects", (NBTBase)nbtTagList);
        super.saveNBTData(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.mParallel = aNBT.func_74769_h("mParallel");
        this.nodePurificationEfficiency = aNBT.func_74762_e("nodePurificationEfficiency");
        this.nodeIncrease = aNBT.func_74762_e("nodeIncrease");
        this.mOutputAspects.aspects.clear();
        NBTTagList tlist = aNBT.func_150295_c("Aspects", 10);
        for (int j = 0; j < tlist.func_74745_c(); ++j) {
            NBTTagCompound rs = tlist.func_150305_b(j);
            if (!rs.func_74764_b("key")) continue;
            this.mOutputAspects.add(Aspect.getAspect((String)rs.func_74779_i("key")), rs.func_74762_e("amount"));
        }
        super.loadNBTData(aNBT);
    }

    protected boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.mCasing = 0;
        this.mParallel = 0.0;
        this.pTier = 0;
        boolean bStructureCheck = this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 16, 1);
        if (!bStructureCheck) {
            this.nodeIncrease = 0;
            this.nodePurificationEfficiency = 0;
        }
        return bStructureCheck;
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 7, 16, 1, elementBudget, env, false, true);
    }

    private boolean addEssentiaOutputHatchToMachineList(MTEEssentiaOutputHatch aTileEntity) {
        if (aTileEntity instanceof MTEEssentiaOutputHatch) {
            return this.mEssentiaOutputHatches.add(aTileEntity);
        }
        return false;
    }

    protected void onCasingFound() {
        ++this.mCasing;
    }

    protected void onEssentiaCellFound(int tier) {
        this.mParallel += (double)(STANDARD_DIFFUSION_CELL_PARALLEL << tier);
        this.pTier = Math.max(this.pTier, tier);
    }

    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        int parallel = (int)this.mParallel;
        if (parallel <= 0) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.primalAspectsGenerated = (int)((double)(parallel * STANDARD_PRIMAL_ASPECTS_PER_PARALLEL) * (1.0 + (double)this.nodeIncrease * 0.01 * (double)STANDARD_BOOST_MULTIPLIER));
        OverclockCalculator calculator = new OverclockCalculator().setRecipeEUt(1920L).setEUt(this.getMaxInputEu()).setDuration(20 * STANDARD_RECIPE_DURATION).setDurationDecreasePerOC(2.0).calculate();
        this.useLongPower = true;
        this.lEUt = -calculator.getConsumption();
        this.mMaxProgresstime = calculator.getDuration();
        if (this.mMaxProgresstime < 20) {
            this.primalAspectsGenerated = (int)(20.0 / (double)this.mMaxProgresstime * (double)this.primalAspectsGenerated);
            this.mMaxProgresstime = 20;
        }
        AspectList generatedAspects = new AspectList();
        generatedAspects.add(Aspect.AIR, this.primalAspectsGenerated);
        generatedAspects.add(Aspect.EARTH, this.primalAspectsGenerated);
        generatedAspects.add(Aspect.FIRE, this.primalAspectsGenerated);
        generatedAspects.add(Aspect.WATER, this.primalAspectsGenerated);
        generatedAspects.add(Aspect.ORDER, this.primalAspectsGenerated);
        generatedAspects.add(Aspect.ENTROPY, this.primalAspectsGenerated);
        this.mOutputAspects.add(generatedAspects);
        this.mEfficiencyIncrease = 10000;
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    protected void addClassicOutputs_EM() {
        super.addClassicOutputs_EM();
        this.fillEssentiaOutputHatch();
    }

    private void fillEssentiaOutputHatch() {
        for (MTEEssentiaOutputHatch outputHatch : this.mEssentiaOutputHatches) {
            for (Map.Entry entry : this.mOutputAspects.copy().aspects.entrySet()) {
                Aspect aspect = (Aspect)entry.getKey();
                int amount = (Integer)entry.getValue();
                this.mOutputAspects.remove(aspect, outputHatch.addEssentia(aspect, amount, null));
            }
        }
        this.mOutputAspects.aspects.clear();
    }

    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.runMachine(aBaseMetaTileEntity, aTick);
    }

    public void stopMachine() {
        super.stopMachine();
        this.mCasing = 0;
        this.mParallel = 0.0;
        this.pTier = 0;
        this.primalAspectsGenerated = 0;
        this.mOutputAspects.aspects.clear();
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aTick % 5L == 0L && this.mMachine) {
            World WORLD = this.getBaseMetaTileEntity().getWorld();
            int x = this.getBaseMetaTileEntity().getXCoord();
            short y = this.getBaseMetaTileEntity().getYCoord();
            int z = this.getBaseMetaTileEntity().getZCoord();
            this.nodePurificationEfficiency = Math.max(0, this.nodePurificationEfficiency - STANDARD_PURIFICATION_REDUCTION);
            if (this.nodePurificationEfficiency < 100) {
                this.nodePurificationEfficiency = Math.min(100, this.nodePurificationEfficiency + (int)((double)VisNetHandler.drainVis((World)WORLD, (int)x, (int)y, (int)z, (Aspect)Aspect.ORDER, (int)200) * 0.02 * (double)STANDARD_PURIFICATION_GAIN_MULTIPLIER));
            }
            this.nodeIncrease = Math.max(0, this.nodeIncrease - STANDARD_BOOST_REDUCTION);
            if (this.nodeIncrease < 100) {
                this.nodeIncrease = Math.min(100, this.nodeIncrease + (int)((double)VisNetHandler.drainVis((World)WORLD, (int)x, (int)y, (int)z, (Aspect)Aspect.ENTROPY, (int)125) * 0.024 * (double)STANDARD_BOOST_GAIN_MULTIPLIER));
            }
        }
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.xstr.nextInt(40) == 0 && this.xstr.nextInt(100) < Math.max(100 - this.nodePurificationEfficiency, 0)) {
            World WORLD = this.getBaseMetaTileEntity().getWorld();
            MTEHatchMuffler mufflerHatch = (MTEHatchMuffler)this.mMufflerHatches.get(this.xstr.nextInt(this.mMufflerHatches.size()));
            int x = mufflerHatch.getBaseMetaTileEntity().getXCoord();
            int y = mufflerHatch.getBaseMetaTileEntity().getYCoord();
            int z = mufflerHatch.getBaseMetaTileEntity().getZCoord();
            ForgeDirection facing = mufflerHatch.getBaseMetaTileEntity().getFrontFacing();
            switch (facing) {
                case SOUTH: {
                    ++z;
                    break;
                }
                case NORTH: {
                    --z;
                    break;
                }
                case WEST: {
                    --x;
                    break;
                }
                case EAST: {
                    ++x;
                    break;
                }
                default: {
                    ++y;
                }
            }
            this.generateFluxGas(WORLD, x, y, z);
        }
        return super.onRunningTick(aStack);
    }

    private void generateFluxGas(World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, ConfigBlocks.blockFluxGas, 8, 3);
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextEnums.tr("Tooltip_PrimordialDisjunctus_MachineType")).addInfo(TextEnums.tr("Tooltip_PrimordialDisjunctus_00")).addInfo(TextEnums.tr("Tooltip_PrimordialDisjunctus_01")).addInfo(TextEnums.tr("Tooltip_PrimordialDisjunctus_02")).addInfo(TextEnums.tr("Tooltip_PrimordialDisjunctus_03")).addInfo(TextEnums.tr("Tooltip_PrimordialDisjunctus_04")).addInfo(TextEnums.tr("Tooltip_PrimordialDisjunctus_05")).addInfo(TextEnums.tr("Tooltip_PrimordialDisjunctus_06")).addInfo(TextEnums.tr("Tooltip_PrimordialDisjunctus_07")).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).beginStructureBlock(11, 10, 23, true).addController(TextLocalization.textFrontCenter).addOutputHatch(TextEnums.tr("Tooltip_PrimordialDisjunctus_HatchBusInfo")).addEnergyHatch(TextEnums.tr("Tooltip_PrimordialDisjunctus_HatchBusInfo")).addOtherStructurePart(TextEnums.tr("Tooltip.EssentiaOutputHatch"), TextEnums.tr("Tooltip_PrimordialDisjunctus_HatchBusInfo")).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1536), TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE_GLOW).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1536), TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_GLOW).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)1536)};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(STRUCTURE_PIECE_MAIN, 7, 16, 1, stackSize, hintsOnly);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_PrimordialDisjunctus(this.mName);
    }

    public final boolean shouldCheckMaintenance() {
        return false;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public boolean doRandomMaintenanceDamage() {
        return true;
    }

    public boolean willExplodeInRain() {
        return false;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("primalAspectsPerCycle", this.primalAspectsGenerated);
        tag.func_74768_a("boost", this.nodeIncrease);
        tag.func_74768_a("purificationEfficiency", this.nodePurificationEfficiency);
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("primalAspectsPerCycle")) {
            currentTip.add(EnumChatFormatting.AQUA + "Generating: " + EnumChatFormatting.GOLD + tag.func_74762_e("primalAspectsPerCycle") + " Primal Aspects" + EnumChatFormatting.RESET);
        }
        if (tag.func_74764_b("boost")) {
            currentTip.add(EnumChatFormatting.AQUA + "Boost: " + EnumChatFormatting.GOLD + tag.func_74762_e("boost") + "%" + EnumChatFormatting.RESET);
        }
        if (tag.func_74764_b("purificationEfficiency")) {
            currentTip.add(EnumChatFormatting.AQUA + "Purification Efficiency: " + EnumChatFormatting.GOLD + tag.func_74762_e("purificationEfficiency") + "%" + EnumChatFormatting.RESET);
        }
    }
}

