/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.entity.TileEntityLaserBeacon;
import com.Nxer.TwistSpaceTechnology.common.init.TstBlocks;
import com.Nxer.TwistSpaceTechnology.common.machine.MiscHelper;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.blocks.BlockCasings8;
import gtPlusPlus.core.block.ModBlocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class TST_LaserMeteorMiner
extends MTEEnhancedMultiBlockBase<TST_LaserMeteorMiner>
implements ISurvivalConstructable {
    public static Textures.BlockIcons.CustomIcon OVERLAY_FRONT_METEOR_MINER = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:iconSets/OVERLAY_FRONT_METEOR_MINER");
    public static Textures.BlockIcons.CustomIcon OVERLAY_FRONT_METEOR_MINER_ACTIVE = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:iconSets/OVERLAY_FRONT_METEOR_MINER_ACTIVE");
    public static Textures.BlockIcons.CustomIcon OVERLAY_FRONT_METEOR_MINER_ACTIVE_GLOW = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:iconSets/OVERLAY_FRONT_METEOR_MINER_ACTIVE_GLOW");
    public static Textures.BlockIcons.CustomIcon OVERLAY_FRONT_METEOR_MINER_GLOW = new Textures.BlockIcons.CustomIcon("gtnhcommunitymod:iconSets/OVERLAY_FRONT_METEOR_MINER_GLOW");
    private static final int distanceFromMeteor = 48;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    protected static final int horizontalOffSet_T1 = 9;
    protected static final int verticalOffSet_T1 = 13;
    protected static final int depthOffSet_T1 = 7;
    private static final String STRUCTURE_PIECE_TIER2 = "tier2";
    protected static final int horizontalOffSet_T2 = 9;
    protected static final int verticalOffSet_T2 = 15;
    protected static final int depthOffSet_T2 = 3;
    private static final int MAX_RADIUS = 40;
    private static IStructureDefinition<TST_LaserMeteorMiner> STRUCTURE_DEFINITION;
    protected TileEntityLaserBeacon renderer;
    private int currentRadius = 40;
    private int xDrill;
    private int yDrill;
    private int zDrill;
    private int xStart;
    private int yStart;
    private int zStart;
    private int fortuneTier = 0;
    private boolean isStartInitialized = false;
    private boolean hasFinished = true;
    private boolean isWaiting = false;
    private boolean isResetting = false;
    Collection<ItemStack> res = new HashSet<ItemStack>();
    private int multiTier = 0;
    protected static final String[][] shape_T1;
    protected static final String[][] shape_T2;
    private boolean stopAllRendering = false;

    public IStructureDefinition<TST_LaserMeteorMiner> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])shape_T1)).addShape(STRUCTURE_PIECE_TIER2, StructureUtility.transpose((String[][])shape_T2)).addElement('A', GTStructureUtility.chainAllGlasses()).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)15)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)7)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)2)).addElement('E', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)3)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)11)).addElement('G', GTStructureUtility.ofFrame((Materials)Materials.Neutronium)).addElement('H', GTStructureUtility.ofFrame((Materials)Materials.BlackPlutonium)).addElement('I', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings5, (int)5)).addElement('J', GTStructureUtility.ofFrame((Materials)Materials.StainlessSteel)).addElement('K', StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)6)).addElement('L', StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)8)).addElement('W', (IStructureElement)GTStructureUtility.buildHatchAdder(TST_LaserMeteorMiner.class).atLeast(new IHatchElement[]{HatchElement.OutputBus, HatchElement.Energy, HatchElement.Maintenance}).casingIndex(TAE.getIndexFromPage((int)3, (int)9)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)6)})).addElement('Y', (IStructureElement)GTStructureUtility.buildHatchAdder(TST_LaserMeteorMiner.class).atLeast(new IHatchElement[]{HatchElement.InputBus}).adder(TST_LaserMeteorMiner::addInjector).casingIndex(TAE.getIndexFromPage((int)3, (int)9)).dot(2).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)6)})).addElement('X', (IStructureElement)GTStructureUtility.buildHatchAdder(TST_LaserMeteorMiner.class).atLeast(new IHatchElement[]{HatchElement.OutputBus, HatchElement.Energy, HatchElement.Maintenance}).casingIndex(((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(2)).dot(3).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)2)})).addElement('Z', StructureUtility.ofBlock((Block)TstBlocks.LaserBeaconRender, (int)0)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> (d.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    public TST_LaserMeteorMiner(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_LaserMeteorMiner(String aName) {
        super(aName);
    }

    public void onDisableWorking() {
        if (this.renderer != null) {
            this.renderer.setShouldRender(false);
        }
        super.onDisableWorking();
    }

    public void onBlockDestroyed() {
        if (this.renderer != null) {
            this.renderer.setShouldRender(false);
        }
        super.onBlockDestroyed();
    }

    private boolean addInjector(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof MTEHatchInputBus)) {
            return false;
        }
        MTEHatchInputBus bus = (MTEHatchInputBus)aMetaTileEntity;
        bus.updateTexture(aBaseCasingIndex);
        return this.mInputBusses.add(bus);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        if (stackSize.field_77994_a > 1) {
            this.buildPiece(STRUCTURE_PIECE_TIER2, stackSize, hintsOnly, 9, 15, 3);
        } else {
            this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 9, 13, 7);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return stackSize.field_77994_a < 2 ? this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 9, 13, 7, elementBudget, env, false, true) : this.survivialBuildPiece(STRUCTURE_PIECE_TIER2, stackSize, 9, 15, 3, elementBudget, env, false, true);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_LaserMeteorMiner(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.getIndexFromPage((int)0, (int)8)), TextureFactory.builder().addIcon((IIconContainer)OVERLAY_FRONT_METEOR_MINER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)OVERLAY_FRONT_METEOR_MINER_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.getIndexFromPage((int)0, (int)8)), TextureFactory.builder().addIcon((IIconContainer)OVERLAY_FRONT_METEOR_MINER).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)OVERLAY_FRONT_METEOR_MINER_GLOW).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.getIndexFromPage((int)0, (int)8))};
        return rTexture;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextEnums.tr("TST_LaserMeteorMiner_tooltips_machineType")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_01")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_02")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_03")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_04")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_05")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_06")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_07")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_08")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_needSchematic")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_09")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_10")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_11")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_12")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_13")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_14")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_15")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_16")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_17")).addInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_18")).addInfo(TextEnums.Author_Totto.getText()).addSeparator().addStructureInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_T1")).addController(TextEnums.tr("TST_LaserMeteorMiner_structure_info_T1_controller")).addOutputBus(TextEnums.tr("TST_LaserMeteorMiner_structure_info_T1_hatches"), new int[]{1}).addEnergyHatch(TextEnums.tr("TST_LaserMeteorMiner_structure_info_T1_hatches"), new int[]{1}).addMaintenanceHatch(TextEnums.tr("TST_LaserMeteorMiner_structure_info_T1_hatches"), new int[]{1}).addInputBus(TextEnums.tr("TST_LaserMeteorMiner_structure_info_T1_hatches_input_bus"), new int[]{2}).addStructureInfo(TextEnums.tr("TST_LaserMeteorMiner_tooltips_T2")).addController(TextEnums.tr("TST_LaserMeteorMiner_structure_info_T2_controller")).addOutputBus(TextEnums.tr("TST_LaserMeteorMiner_structure_info_T2_hatches"), new int[]{3}).addEnergyHatch(TextEnums.tr("TST_LaserMeteorMiner_structure_info_T2_hatches"), new int[]{3}).addMaintenanceHatch(TextEnums.tr("TST_LaserMeteorMiner_structure_info_T2_hatches"), new int[]{3}).toolTipFinisher(new String[]{TextEnums.Mod_TwistSpaceTechnology.getText()});
        return tt;
    }

    private boolean findLaserRenderer() {
        this.setStartCoords();
        TileEntity tileEntity = this.getBaseMetaTileEntity().getWorld().func_147438_o(this.xStart, this.getBaseMetaTileEntity().getYCoord() + (this.multiTier == 1 ? 10 : 15), this.zStart);
        if (tileEntity instanceof TileEntityLaserBeacon) {
            TileEntityLaserBeacon laser;
            this.renderer = laser = (TileEntityLaserBeacon)tileEntity;
            this.renderer.setRotationFields(this.getDirection(), this.getRotation(), this.getFlip());
            return true;
        }
        return false;
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aStack) {
        boolean bl = this.stopAllRendering = !this.stopAllRendering;
        if (this.stopAllRendering) {
            TstUtils.sendMessageKeyToPlayer(aPlayer, "TST_LaserMeteorMiner_message_screwdriverRightClick_off");
            if (this.renderer != null) {
                this.renderer.setShouldRender(false);
            }
        } else {
            TstUtils.sendMessageKeyToPlayer(aPlayer, "TST_LaserMeteorMiner_message_screwdriverRightClick_on");
        }
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.multiTier = 0;
        if (this.checkPiece(STRUCTURE_PIECE_MAIN, 9, 13, 7)) {
            this.multiTier = 1;
        } else if (this.checkPiece(STRUCTURE_PIECE_TIER2, 9, 15, 3)) {
            this.multiTier = 2;
        } else {
            return false;
        }
        if (!this.findLaserRenderer()) {
            return false;
        }
        return !this.mEnergyHatches.isEmpty();
    }

    private int getMultiTier(ItemStack inventory) {
        if (inventory == null || inventory.field_77994_a < 1) {
            return 0;
        }
        return GTCMItemList.MeteorMinerSchematic2.equal(inventory) ? 2 : (GTCMItemList.MeteorMinerSchematic1.equal(inventory) ? 1 : 0);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    protected boolean supportsCraftingMEBuffer() {
        return false;
    }

    protected int getXDrill() {
        return this.xDrill;
    }

    protected int getYDrill() {
        return this.yDrill;
    }

    protected int getZDrill() {
        return this.zDrill;
    }

    private int getLaserToEndHeight() {
        return this.multiTier == 1 ? 3 : 0;
    }

    private void setFortuneTier() {
        Optional<ItemStack> input;
        this.fortuneTier = 0;
        if (this.multiTier == 2) {
            this.fortuneTier = 3;
            return;
        }
        if (!this.mInputBusses.isEmpty() && (input = Optional.ofNullable(((MTEHatchInputBus)this.mInputBusses.get(0)).getInventoryHandler().getStackInSlot(0))).isPresent()) {
            this.fortuneTier = TST_LaserMeteorMiner.getFortuneTier(input.get());
        }
    }

    private static int getFortuneTier(ItemStack itemStack) {
        if (itemStack == null || itemStack.field_77994_a < 1) {
            return 0;
        }
        Item t = itemStack.func_77973_b();
        if (MiscHelper.PickaxeOfTheCore.equals(t)) {
            return 1;
        }
        if (MiscHelper.BoundPickaxe.equals(t)) {
            return 2;
        }
        if (MiscHelper.TerraShatterer.equals(t)) {
            return 3;
        }
        return 0;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("currentRadius", this.currentRadius);
        aNBT.func_74768_a("xDrill", this.xDrill);
        aNBT.func_74768_a("yDrill", this.yDrill);
        aNBT.func_74768_a("zDrill", this.zDrill);
        aNBT.func_74768_a("xStart", this.xStart);
        aNBT.func_74768_a("yStart", this.yStart);
        aNBT.func_74768_a("zStart", this.zStart);
        aNBT.func_74757_a("isStartInitialized", this.isStartInitialized);
        aNBT.func_74757_a("hasFinished", this.hasFinished);
        aNBT.func_74757_a("isWaiting", this.isWaiting);
        aNBT.func_74757_a("stopAllRendering", this.stopAllRendering);
        aNBT.func_74768_a("multiTier", this.multiTier);
        aNBT.func_74768_a("fortuneTier", this.fortuneTier);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.currentRadius = aNBT.func_74762_e("currentRadius");
        this.xDrill = aNBT.func_74762_e("xDrill");
        this.yDrill = aNBT.func_74762_e("yDrill");
        this.zDrill = aNBT.func_74762_e("zDrill");
        this.xStart = aNBT.func_74762_e("xStart");
        this.yStart = aNBT.func_74762_e("yStart");
        this.zStart = aNBT.func_74762_e("zStart");
        this.isStartInitialized = aNBT.func_74767_n("isStartInitialized");
        this.hasFinished = aNBT.func_74767_n("hasFinished");
        this.isWaiting = aNBT.func_74767_n("isWaiting");
        this.stopAllRendering = aNBT.func_74767_n("stopAllRendering");
        this.multiTier = aNBT.func_74762_e("multiTier");
        this.fortuneTier = aNBT.func_74762_e("fortuneTier");
    }

    private void reset() {
        this.isResetting = false;
        this.hasFinished = true;
        this.isWaiting = false;
        this.currentRadius = 40;
        this.initializeDrillPos();
    }

    private void startReset() {
        this.isResetting = true;
        this.stopMachine(ShutDownReasonRegistry.NONE);
        this.enableWorking();
    }

    @NotNull
    public CheckRecipeResult checkProcessing() {
        if (this.multiTier != this.getMultiTier(this.mInventory[1])) {
            return SimpleCheckRecipeResult.ofFailure((String)"missing_schematic");
        }
        if (this.renderer != null) {
            this.renderer.setColors(1.0f, 0.0f, 0.0f);
        }
        if (this.isResetting) {
            this.reset();
            return SimpleCheckRecipeResult.ofSuccess((String)"meteor_reset");
        }
        this.setElectricityStats();
        if (!this.isEnergyEnough()) {
            this.stopMachine(ShutDownReasonRegistry.NONE);
            return SimpleCheckRecipeResult.ofFailure((String)"not_enough_energy");
        }
        if (!this.isStartInitialized) {
            this.setStartCoords();
            this.findBestRadius();
            this.initializeDrillPos();
        }
        if (!this.hasFinished) {
            this.renderer.setShouldRender(true);
            this.renderer.setRange((double)(this.currentRadius + 48) + 0.5 + (double)this.getLaserToEndHeight());
            this.setFortuneTier();
            this.startMining(this.multiTier);
            this.mOutputItems = this.res.toArray(new ItemStack[0]);
            this.res.clear();
        } else {
            this.renderer.setShouldRender(false);
            this.isWaiting = true;
            this.setElectricityStats();
            boolean isReady = this.checkCenter();
            if (isReady) {
                this.isWaiting = false;
                this.setElectricityStats();
                this.setReady();
                this.hasFinished = false;
            } else {
                return SimpleCheckRecipeResult.ofSuccess((String)"meteor_waiting");
            }
        }
        return SimpleCheckRecipeResult.ofSuccess((String)"meteor_mining");
    }

    private void startMining(int tier) {
        switch (tier) {
            case 1: {
                this.mineSingleBlock();
                break;
            }
            case 2: {
                this.mineRow();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Multiblock Tier");
            }
        }
    }

    private void mineSingleBlock() {
        while (this.getBaseMetaTileEntity().getWorld().func_147437_c(this.xDrill, this.yDrill, this.zDrill)) {
            this.moveToNextBlock();
            if (!this.hasFinished) continue;
            return;
        }
        this.mineBlock(this.xDrill, this.yDrill, this.zDrill);
        this.moveToNextBlock();
    }

    private void mineRow() {
        int currentX = this.xDrill;
        int currentY = this.yDrill;
        while (this.getBaseMetaTileEntity().getWorld().func_147437_c(currentX, currentY, this.zStart)) {
            this.moveToNextColumn();
            if (this.hasFinished) {
                return;
            }
            currentX = this.xDrill;
            currentY = this.yDrill;
        }
        int opposite = 0;
        for (int z = -this.currentRadius; z <= this.currentRadius - opposite; ++z) {
            int currentZ = this.zStart + z;
            if (!this.getBaseMetaTileEntity().getWorld().func_147437_c(this.xDrill, this.yDrill, currentZ)) {
                this.mineBlock(this.xDrill, this.yDrill, currentZ);
                continue;
            }
            ++opposite;
        }
        this.moveToNextColumn();
    }

    private void mineBlock(int currentX, int currentY, int currentZ) {
        Block target = this.getBaseMetaTileEntity().getBlock(currentX, currentY, currentZ);
        if (target.func_149712_f(this.getBaseMetaTileEntity().getWorld(), currentX, currentY, currentZ) > 0.0f) {
            int targetMeta = this.getBaseMetaTileEntity().getMetaID(currentX, currentY, currentZ);
            ArrayList drops = target.getDrops(this.getBaseMetaTileEntity().getWorld(), currentX, currentY, currentZ, targetMeta, 0);
            if (GTUtility.isOre((Block)target, (int)targetMeta)) {
                this.res.addAll(this.getOutputByDrops(drops));
            } else {
                this.res.addAll(drops);
            }
            this.getBaseMetaTileEntity().getWorld().func_147468_f(currentX, currentY, currentZ);
        }
    }

    private Collection<ItemStack> getOutputByDrops(Collection<ItemStack> oreBlockDrops) {
        long voltage = this.getMaxInputVoltage();
        HashSet<ItemStack> outputItems = new HashSet<ItemStack>();
        oreBlockDrops.forEach(currentItem -> {
            if (!this.doUseMaceratorRecipe((ItemStack)currentItem)) {
                outputItems.add(this.multiplyStackSize((ItemStack)currentItem));
                return;
            }
            GTRecipe tRecipe = RecipeMaps.maceratorRecipes.findRecipeQuery().items(new ItemStack[]{currentItem}).voltage(voltage).find();
            if (tRecipe == null) {
                outputItems.add((ItemStack)currentItem);
                return;
            }
            for (int i = 0; i < tRecipe.mOutputs.length; ++i) {
                ItemStack recipeOutput = tRecipe.mOutputs[i].func_77946_l();
                if (this.getBaseMetaTileEntity().getRandomNumber(10000) < tRecipe.getOutputChance(i)) {
                    this.multiplyStackSize(recipeOutput);
                }
                outputItems.add(recipeOutput);
            }
        });
        return outputItems;
    }

    private ItemStack multiplyStackSize(ItemStack itemStack) {
        itemStack.field_77994_a *= this.getBaseMetaTileEntity().getRandomNumber(this.fortuneTier + 1) + 1;
        return itemStack;
    }

    private boolean doUseMaceratorRecipe(ItemStack currentItem) {
        ItemData itemData = GTOreDictUnificator.getItemData((ItemStack)currentItem);
        return itemData == null || itemData.mPrefix != OrePrefixes.crushed && itemData.mPrefix != OrePrefixes.dustImpure && itemData.mPrefix != OrePrefixes.dust && itemData.mPrefix != OrePrefixes.gem && itemData.mPrefix != OrePrefixes.gemChipped && itemData.mPrefix != OrePrefixes.gemExquisite && itemData.mPrefix != OrePrefixes.gemFlawed && itemData.mPrefix != OrePrefixes.gemFlawless && itemData.mMaterial.mMaterial != Materials.Oilsands;
    }

    private void moveToNextBlock() {
        if (this.zDrill <= this.zStart + this.currentRadius) {
            ++this.zDrill;
        } else {
            this.zDrill = this.zStart - this.currentRadius;
            this.moveToNextColumn();
        }
    }

    private void moveToNextColumn() {
        if (this.xDrill <= this.xStart + this.currentRadius) {
            ++this.xDrill;
        } else if (this.yDrill <= this.yStart + this.currentRadius) {
            this.xDrill = this.xStart - this.currentRadius;
            ++this.yDrill;
        } else {
            this.hasFinished = true;
        }
    }

    private void setStartCoords() {
        ForgeDirection facing = this.getBaseMetaTileEntity().getBackFacing();
        if (facing == ForgeDirection.NORTH || facing == ForgeDirection.SOUTH) {
            this.xStart = this.getBaseMetaTileEntity().getXCoord();
            this.zStart = (this.multiTier == 1 ? 2 : 6) * this.getExtendedFacing().getRelativeBackInWorld().offsetZ + this.getBaseMetaTileEntity().getZCoord();
        } else {
            this.xStart = (this.multiTier == 1 ? 2 : 6) * this.getExtendedFacing().getRelativeBackInWorld().offsetX + this.getBaseMetaTileEntity().getXCoord();
            this.zStart = this.getBaseMetaTileEntity().getZCoord();
        }
        this.yStart = 48 + (this.multiTier == 1 ? 13 : 15) + this.getBaseMetaTileEntity().getYCoord();
    }

    private void setReady() {
        this.findBestRadius();
        this.initializeDrillPos();
    }

    private void initializeDrillPos() {
        this.xDrill = this.xStart - this.currentRadius;
        this.yDrill = this.yStart - this.currentRadius;
        this.zDrill = this.zStart - this.currentRadius;
        this.isStartInitialized = true;
        this.hasFinished = false;
    }

    private boolean checkCenter() {
        return !this.getBaseMetaTileEntity().getWorld().func_147437_c(this.xStart, this.yStart + 1, this.zStart);
    }

    private void findBestRadius() {
        this.currentRadius = 40;
        int delta = 0;
        int zCoord = this.zStart - this.currentRadius;
        while (delta < 39 && this.getBaseMetaTileEntity().getWorld().func_147437_c(this.xStart, this.yStart, zCoord)) {
            ++delta;
            ++zCoord;
        }
        this.currentRadius -= delta;
    }

    protected void setElectricityStats() {
        this.mOutputItems = new ItemStack[0];
        this.mEfficiency = 10000;
        this.mEfficiencyIncrease = 10000;
        OverclockCalculator calculator = new OverclockCalculator().setEUt(this.getAverageInputVoltage()).setAmperage(this.getMaxInputAmps()).setRecipeEUt(TierEU.RECIPE_MV).setDuration(Config.StandardRecipeDuration_Second_LaserMeteorMiner * 20).setAmperageOC(this.mEnergyHatches.size() != 1).enablePerfectOC();
        calculator.calculate();
        this.mMaxProgresstime = this.isWaiting ? 20 * Config.StandardRecipeDuration_Second_LaserMeteorMiner : calculator.getDuration();
        this.mEUt = (int)(this.isWaiting ? 0L : -calculator.getConsumption());
    }

    private boolean isEnergyEnough() {
        long requiredEnergy = 512L + this.getMaxInputVoltage() * 4L;
        for (MTEHatchEnergy energyHatch : this.mEnergyHatches) {
            if ((requiredEnergy -= energyHatch.getEUVar()) > 0L) continue;
            return true;
        }
        return false;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> this.startReset()).setPlayClickSound(true).setBackground(() -> new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_CYCLIC}).setPos(new Pos2d(174, 112)).addTooltip(TextEnums.tr("TST_LaserMeteorMiner.button.reset")).setSize(16, 16));
    }

    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("fortune", this.fortuneTier);
        tag.func_74768_a("tier", this.multiTier);
    }

    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(TextEnums.tr("Tooltip_METEOR_MINER_CONTROLLER.tier." + tag.func_74762_e("tier")) + EnumChatFormatting.RESET);
        currentTip.add(TextEnums.tr("Tooltip_METEOR_MINER_CONTROLLER.fortune." + tag.func_74762_e("fortune")) + EnumChatFormatting.RESET);
    }

    static {
        shape_T1 = new String[][]{{"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         J         ", "        J J        ", "         J         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         J         ", "        J J        ", "       J   J       ", "        J J        ", "         J         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         J         ", "       J   J       ", "                   ", "      J     J      ", "                   ", "       J   J       ", "         J         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "         J         ", "      J     J      ", "                   ", "                   ", "     J   Z   J     ", "                   ", "                   ", "      J     J      ", "         J         ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "         J         ", "     J       J     ", "                   ", "                   ", "    J              ", "    J    B    J    ", "                   ", "                   ", "                   ", "     J       J     ", "         J         ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "         J         ", "    J         J    ", "                   ", "                   ", "                   ", "         I         ", "   J    IBI    J   ", "         I         ", "                   ", "                   ", "                   ", "    J         J    ", "         J         ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "    JJJJJJJJJJJ    ", "   JJLLLLLLLLLJJ   ", "  JJLL       LLJJ  ", "  JLL         LLJ  ", "  JL           LJ  ", "  JL           LJ  ", "  JL     I     LJ  ", "  JL    IBI    LJ  ", "  JL     I     LJ  ", "  JL           LJ  ", "  JL           LJ  ", "  JLL         LLJ  ", "  JJLL       LLJJ  ", "   JJLLLLLLLLLJJ   ", "    JJJJJJJJJJJ    ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "         J         ", "      LLLLLLL      ", "     LL     LL     ", "    LL       LL    ", "    L         L    ", "    L    I    L    ", "   JL   IBI   LJ   ", "    L    I    L    ", "    L         L    ", "    LL       LL    ", "     LL     LL     ", "      LLLLLLL      ", "         J         ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "         J         ", "       LLLLL       ", "      LL   LL      ", "     LL  I  LL     ", "     L  III  L     ", "    JL IIBII LJ    ", "     L  III  L     ", "     LL  I  LL     ", "      LL   LL      ", "       LLLLL       ", "         J         ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "         J         ", "        LLL        ", "       LLLLL       ", "      LLLLLLL      ", "     JLLLBLLLJ     ", "      LLLLLLL      ", "       LLLLL       ", "        LLL        ", "         J         ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         J         ", "        JJJ        ", "       JKAKJ       ", "      JJABAJJ      ", "       JKAKJ       ", "        JJJ        ", "         J         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "        KAK        ", "        ABA        ", "        KAK        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "        KAK        ", "        ABA        ", "        KAK        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "        W~W        ", "       WKKKW       ", "       WKBKW       ", "       WKKKW       ", "        WWW        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "        KYK        ", "       KKKKK       ", "      KKBBBKK      ", "      KKBBBKK      ", "      KKBBBKK      ", "       KKKKK       ", "        KKK        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "        K K        ", "       K   K       ", "      A     A      ", "     K       K     ", "    K         K    ", "                   ", "    K         K    ", "     K       K     ", "      A     A      ", "       K   K       ", "        K K        ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "        K K        ", "                   ", "       K   K       ", "      A     A      ", "     K       K     ", "   K           K   ", "                   ", "   K           K   ", "     K       K     ", "      A     A      ", "       K   K       ", "                   ", "        K K        ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "        K K        ", "                   ", "                   ", "       K   K       ", "      A     A      ", "     K       K     ", "  K             K  ", "                   ", "  K             K  ", "     K       K     ", "      A     A      ", "       K   K       ", "                   ", "                   ", "        K K        ", "                   ", "                   "}, {"         K         ", "        K K        ", "       K   K       ", "       K   K       ", "       K   K       ", "      K     K      ", "     KK     KK     ", "  KKK         KKK  ", " K               K ", "K                 K", " K               K ", "  KKK         KKK  ", "     KK     KK     ", "      K     K      ", "       K   K       ", "       K   K       ", "       K   K       ", "        K K        ", "         K         "}};
        shape_T2 = new String[][]{{"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         Z         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         B         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         B         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         E         ", "        EBE        ", "         E         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         E         ", "        EBE        ", "         E         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         E         ", "        EBE        ", "         E         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         E         ", "        ECE        ", "       ECBCE       ", "        ECE        ", "         E         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         E         ", "        ECE        ", "       ECBCE       ", "        ECE        ", "         E         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         E         ", "        CCC        ", "       ECBCE       ", "        CCC        ", "         E         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         E         ", "         E         ", "        C C        ", "      EE B EE      ", "        C C        ", "         E         ", "         E         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         E         ", "        HEH        ", "       HC CH       ", "      EE B EE      ", "       HC CH       ", "        HEH        ", "         E         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "        HEH        ", "       H C H       ", "      H C C H      ", "      EC B CE      ", "      H C C H      ", "       H C H       ", "        HEH        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "         E         ", "        AEA        ", "       E C E       ", "      A     A      ", "     EEC B CEE     ", "      A     A      ", "       E C E       ", "        AEA        ", "         E         ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "                   ", "         E         ", "        A A        ", "       E C E       ", "      A     A      ", "     E C B C E     ", "      A     A      ", "       E C E       ", "        A A        ", "         E         ", "                   ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "                   ", "         E         ", "         E         ", "       EA AE       ", "      EE   EE      ", "      A     A      ", "    EE       EE    ", "      A     A      ", "      EE   EE      ", "       EA AE       ", "         E         ", "         E         ", "                   ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "                   ", "         ~         ", "       DD DD       ", "      D     D      ", "     D  FFF  D     ", "    D  F   F  D    ", "    D F     F D    ", "   E  F     F  E   ", "    D F     F D    ", "    D  F   F  D    ", "     D  FFF  D     ", "      D     D      ", "       DD DD       ", "         E         ", "                   ", "                   ", "                   "}, {"                   ", "                   ", "         X         ", "        E E        ", "                   ", "                   ", "                   ", "                   ", "   E           E   ", "  X             X  ", "   E           E   ", "                   ", "                   ", "                   ", "                   ", "        E E        ", "         X         ", "                   ", "                   "}, {"                   ", "         X         ", "        X X        ", "      GGG GGG      ", "     GG     GG     ", "    GG       GG    ", "   GG         GG   ", "   G           G   ", "  XG           GX  ", " X               X ", "  XG           GX  ", "   G           G   ", "   GG         GG   ", "    GG       GG    ", "     GG     GG     ", "      GGG GGG      ", "        X X        ", "         X         ", "                   "}, {"         X         ", "        X X        ", "       X   X       ", "                   ", "                   ", "                   ", "                   ", "  X             X  ", " X               X ", "X                 X", " X               X ", "  X             X  ", "                   ", "                   ", "                   ", "                   ", "       X   X       ", "        X X        ", "         X         "}, {"         X         ", "        X X        ", "       X   X       ", "                   ", "                   ", "                   ", "                   ", "  X             X  ", " X               X ", "X                 X", " X               X ", "  X             X  ", "                   ", "                   ", "                   ", "                   ", "       X   X       ", "        X X        ", "         X         "}, {"         X         ", "        X X        ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", " X               X ", "X                 X", " X               X ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "        X X        ", "         X         "}, {"         X         ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "X                 X", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "                   ", "         X         "}};
    }
}

