/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.TST_SteamMultiMachineBase;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTESteamMultiBase;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TST_LargeSteamForgeHammer
extends TST_SteamMultiMachineBase<TST_LargeSteamForgeHammer>
implements ISurvivalConstructable {
    protected int steamCasingTier = 1;
    protected int parallel = 1;
    protected static IStructureDefinition<TST_LargeSteamForgeHammer> STRUCTURE_DEFINITION = null;

    public TST_LargeSteamForgeHammer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_LargeSteamForgeHammer(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_LargeSteamForgeHammer(this.mName);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("steamCasingTier", this.steamCasingTier);
        aNBT.func_74768_a("parallel", this.parallel);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.steamCasingTier = aNBT.func_74762_e("steamCasingTier");
        this.parallel = aNBT.func_74762_e("parallel");
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.parallel;
    }

    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.hammerRecipes;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.steamCasingTier = -1;
        if (!this.checkPiece(this.mName, 1, 1, 0)) {
            return false;
        }
        if (this.steamCasingTier < 1) {
            return false;
        }
        this.updateHatchTexture();
        this.parallel = 16 * this.steamCasingTier;
        return true;
    }

    public String getMachineType() {
        return "Forge Hammer";
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    protected void updateHatchTexture() {
        int casingIndex = TST_LargeSteamForgeHammer.getCasingTextureID(this.steamCasingTier);
        for (MTEHatch h : this.mSteamInputs) {
            h.updateTexture(casingIndex);
        }
        for (MTEHatch h : this.mSteamOutputs) {
            h.updateTexture(casingIndex);
        }
        for (MTEHatch h : this.mSteamInputFluids) {
            h.updateTexture(casingIndex);
        }
    }

    public void setSteamCasingTier(int steamCasingTier) {
        this.steamCasingTier = steamCasingTier;
    }

    public int getSteamCasingTier() {
        return this.steamCasingTier;
    }

    public IStructureDefinition<TST_LargeSteamForgeHammer> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{TST_LargeSteamForgeHammer.buildSteamInput(TST_LargeSteamForgeHammer.class).casingIndex(10).dot(1).build(), GTStructureUtility.buildHatchAdder(TST_LargeSteamForgeHammer.class).atLeast(new IHatchElement[]{MTESteamMultiBase.SteamHatchElement.InputBus_Steam, MTESteamMultiBase.SteamHatchElement.OutputBus_Steam}).casingIndex(10).dot(1).build(), StructureUtility.ofBlocksTiered(TST_SteamMultiMachineBase::checkSteamCasingTier, (List)STEAM_CASING_LIST, (Object)-1, TST_LargeSteamForgeHammer::setSteamCasingTier, TST_LargeSteamForgeHammer::getSteamCasingTier)})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextLocalization.Tooltip_LargeSteamForgeHammer_MachineType).addInfo(TextLocalization.Tooltip_LargeSteamForgeHammer_Controller).addInfo(TextLocalization.Tooltip_LargeSteamForgeHammer_01).addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addSeparator().beginStructureBlock(3, 3, 3, true).addController(TextLocalization.textFrontCenter).addInputBus(TextLocalization.textAnyCasing, new int[]{2}).addOutputBus(TextLocalization.textAnyCasing, new int[]{2}).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    protected ITexture getFrontOverlay() {
        return TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_STEAM_HAMMER);
    }

    protected ITexture getFrontOverlayActive() {
        return TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_STEAM_HAMMER_ACTIVE);
    }

    public int getTierRecipes() {
        return 0;
    }

    public void onValueUpdate(byte aValue) {
        this.steamCasingTier = aValue;
    }

    public byte getUpdateData() {
        return (byte)this.steamCasingTier;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TST_LargeSteamForgeHammer.getCasingTextureID(this.steamCasingTier)), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TST_LargeSteamForgeHammer.getCasingTextureID(this.steamCasingTier))};
    }

    public boolean doRandomMaintenanceDamage() {
        return true;
    }

    public void checkMaintenance() {
    }

    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    public final boolean shouldCheckMaintenance() {
        return false;
    }
}

