/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.client.texture.TstMachineTextures;
import com.Nxer.TwistSpaceTechnology.common.GTCMItemList;
import com.Nxer.TwistSpaceTechnology.common.api.ModBlocksHandler;
import com.Nxer.TwistSpaceTechnology.common.init.TstBlocks;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.processingLogics.TstProcessingLogic;
import com.Nxer.TwistSpaceTechnology.common.misc.OverclockType;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import com.Nxer.TwistSpaceTechnology.common.tile.TileArcaneHole;
import com.Nxer.TwistSpaceTechnology.system.Thaumcraft.TCRecipeTools;
import com.Nxer.TwistSpaceTechnology.util.TSTStructureUtility;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import emt.init.EMTBlocks;
import emt.tile.TileElectricCloud;
import goodgenerator.loader.Loaders;
import gregtech.api.enums.HatchElement;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.tiles.TileCrucible;
import thaumcraft.common.tiles.TileNitor;
import thaumcraft.common.tiles.TileNodeConverter;
import thaumcraft.common.tiles.TileNodeEnergized;
import thaumcraft.common.tiles.TileNodeStabilizer;
import thaumcraft.common.tiles.TileOwned;
import thaumicenergistics.common.blocks.BlockEnum;
import thaumicenergistics.common.storage.EnumEssentiaStorageTypes;
import thaumicenergistics.common.tiles.TileInfusionProvider;

public class TST_IndustrialAlchemyTower
extends GTCM_MultiMachineBase<TST_IndustrialAlchemyTower> {
    private double mSpeedBonus;
    private int essentiaCellTier = 0;
    private final ItemStack EssentiaCell_Creative = EnumEssentiaStorageTypes.Type_Creative.getCell();
    private final ItemStack ProofOfHeroes = GTCMItemList.ProofOfHeroes.get(1, 0);
    protected ArrayList<TileInfusionProvider> mTileInfusionProvider = new ArrayList();
    protected ArrayList<TileNodeEnergized> mNodeEnergized = new ArrayList();
    protected ArrayList<String> Research = new ArrayList();
    public static final CheckRecipeResult Essentia_InsentiaL = SimpleCheckRecipeResult.ofFailurePersistOnShutdown((String)"Essentiainsentia");
    public static final CheckRecipeResult Research_not_completed = SimpleCheckRecipeResult.ofFailurePersistOnShutdown((String)"Research_not_completed");
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private final int horizontalOffSet = 7;
    private final int verticalOffSet = 15;
    private final int depthOffSet = 1;
    private static final String[][] shape = new String[][]{{"               ", "               ", "               ", "               ", "               ", "               ", "      HHH      ", "      H H      ", "      HHH      ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "      HHH      ", "     H   H     ", "     H   H     ", "     H   H     ", "      HHH      ", "               ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "      ONO      ", "     O   O     ", "    O     O    ", "    N     N    ", "    O     O    ", "     O   O     ", "      ONO      ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "     GSSSG     ", "    G     G    ", "    D     D    ", "    D     D    ", "    D     D    ", "    G     G    ", "     GSSSG     ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "     GSSSG     ", "    G     G    ", "    D     D    ", "    D     D    ", "    D     D    ", "    G     G    ", "     GSSSG     ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "     GSSSG     ", "    GX   XG    ", "    D     D    ", "    D  Y  D    ", "    D     D    ", "    GX   XG    ", "     GSSSG     ", "               ", "               ", "               ", "               "}, {"               ", "               ", "      EEE      ", "     EHHHE     ", "    EHBBBHE    ", "   EHFBBBFHE   ", "  EHBBCCCBBHE  ", "  EHBBCCCBBHE  ", "  EHBBCCCBBHE  ", "   EHFBBBFHE   ", "    EHBBBHE    ", "     EHHHE     ", "      EEE      ", "               ", "               "}, {"               ", "               ", "     OONOO     ", "    OHQQQHO    ", "   OHQQBQQHO   ", "  OHQQBCBQQHO  ", "  OQQBCCCBQQO  ", "  NQBCCCCCBQN  ", "  OQQBCCCBQQO  ", "  OHQQBCBQQHO  ", "   OHQQBQQHO   ", "    OHQQQHO    ", "     OONOO     ", "               ", "               "}, {"               ", "               ", "     GSSSG     ", "    S     S    ", "   S       S   ", "  G         G  ", "  D         D  ", "  D         D  ", "  D         D  ", "  G         G  ", "   S       S   ", "    S     S    ", "     GSSSG     ", "               ", "               "}, {"               ", "               ", "     GSSSG     ", "    S     S    ", "   S       S   ", "  G         G  ", "  D         D  ", "  D         D  ", "  D         D  ", "  G         G  ", "   S       S   ", "    S     S    ", "     GSSSG     ", "               ", "               "}, {"               ", "               ", "     GSSSG     ", "    S  X  S    ", "   S       S   ", "  G         G  ", "  D         D  ", "  DX   X   XD  ", "  D         D  ", "  G         G  ", "   S       S   ", "    S  X  S    ", "     GSSSG     ", "               ", "               "}, {"               ", "     EEEEE     ", "    EHBBBHE    ", "   EBBBFBBBE   ", "  EBAABBBAABE  ", " EHBABBSBBABHE ", " EBBBBSSSBBBBE ", " EBFBSSSSSBFBE ", " EBBBBSSSBBBBE ", " EHBABBSBBABHE ", "  EBAABBBAABE  ", "   EBBBFBBBE   ", "    EHBBBHE    ", "     EEEEE     ", "               "}, {"               ", "    OOONOOO    ", "   OHBBBBBHO   ", "  OHBBALABBHO  ", " OHBBBAJABBBHO ", " OBBBJAJAJBBBO ", " OBAAAJJJAAABO ", " NBLJJJJJJJLBN ", " OBAAAJJJAAABO ", " OBBBJAJAJBBBO ", " OHBBBAJABBBHO ", "  OHBBALABBHO  ", "   OHBBBBBHO   ", "    OOONOOO    ", "               "}, {"               ", "    IGHHHGI    ", "   IB     BI   ", "  IB       BI  ", " IB         BI ", " G           G ", " H           H ", " H           H ", " H           H ", " G           G ", " IB         BI ", "  IB       BI  ", "   IB     BI   ", "    IGHHHGI    ", "               "}, {"               ", "     GSSSG     ", "    S     S    ", "   S       S   ", "  S V     V S  ", " G           G ", " D           D ", " D     K     D ", " D           D ", " G           G ", "  S V     V S  ", "   S       S   ", "    S     S    ", "     GSSSG     ", "               "}, {"               ", "     GS~SG     ", "    S     S    ", "   S       S   ", "  S W     W S  ", " G           G ", " D           D ", " D     K     D ", " D           D ", " G           G ", "  S W     W S  ", "   S       S   ", "    S     S    ", "     GSSSG     ", "               "}, {"     Z   Z     ", "    EGSSSGE    ", "   EB     BE   ", "  EB       BE  ", " EB U     U BE ", "ZG           GZ", " D           D ", " D     R     D ", " D           D ", "ZG           GZ", " EB U     U BE ", "  EB       BE  ", "   EB     BE   ", "    EGSSSGE    ", "     Z   Z     "}, {"     NEEEN     ", "   OOHHHHHOO   ", "  OHMMMMMMMHO  ", " OHMMBBBBBMMHO ", " OMMBBPPPBBMMO ", "NHMBBPPCPPBBMHN", "EHMBPPCCCPPBMHE", "EHMBPCCCCCPBMHE", "EHMBPPCCCPPBMHE", "NHMBBPPCPPBBMHN", " OMMBBPPPBBMMO ", " OHMMBBBBBMMHO ", "  OHMMMMMMMHO  ", "   OOHHHHHOO   ", "     NEEEN     "}};
    private static IStructureDefinition<TST_IndustrialAlchemyTower> STRUCTURE_DEFINITION = null;

    public TST_IndustrialAlchemyTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_IndustrialAlchemyTower(String aName) {
        super(aName);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new TstProcessingLogic(){
            final HashMap<Aspect, TileInfusionProvider> aspectProvider = new HashMap();
            AspectList aspects = null;

            @NotNull
            public CheckRecipeResult process() {
                this.setSpeedBonus(TST_IndustrialAlchemyTower.this.getSpeedBonus());
                this.setOverclockType(TST_IndustrialAlchemyTower.this.isEnablePerfectOverclock() ? OverclockType.PerfectOverclock : OverclockType.NormalOverclock);
                return super.process();
            }

            @Nonnull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                ItemStack input1 = recipe.mInputs[0];
                ItemStack circuit = recipe.mInputs[1];
                String key = TCRecipeTools.toStringWithoutStackSize(input1);
                int circuitNum = circuit.func_77960_j();
                if (circuitNum <= 0) {
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                ArrayList<TCRecipeTools.CrucibleCraftingRecipe> recipes = TCRecipeTools.CCR.get(key);
                if (recipes.size() < circuitNum) {
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                TCRecipeTools.CrucibleCraftingRecipe recipe1 = recipes.get(circuitNum - 1);
                if (!TST_IndustrialAlchemyTower.this.isResearchComplete(recipe1.getResearch())) {
                    return Research_not_completed;
                }
                if (TST_IndustrialAlchemyTower.this.getControllerSlot() != null && (TST_IndustrialAlchemyTower.this.getControllerSlot().func_77969_a(TST_IndustrialAlchemyTower.this.EssentiaCell_Creative) || TST_IndustrialAlchemyTower.this.getControllerSlot().func_77969_a(TST_IndustrialAlchemyTower.this.ProofOfHeroes))) {
                    return CheckRecipeResultRegistry.SUCCESSFUL;
                }
                this.aspectProvider.clear();
                this.aspects = recipe1.getInputAspects();
                if (this.aspects.visSize() == 0) {
                    return CheckRecipeResultRegistry.SUCCESSFUL;
                }
                if (TST_IndustrialAlchemyTower.this.mTileInfusionProvider.isEmpty()) {
                    return Essentia_InsentiaL;
                }
                HashMap<Aspect, Integer> aspectMaxParallel = new HashMap<Aspect, Integer>();
                for (Aspect aspect : this.aspects.getAspects()) {
                    int amount = this.aspects.getAmount(aspect);
                    if (amount <= 0) continue;
                    for (TileInfusionProvider hatch : TST_IndustrialAlchemyTower.this.mTileInfusionProvider) {
                        int possibleParallel = GTUtility.safeInt((long)(hatch.getAspectAmountInNetwork(aspect) / (long)amount), (int)1);
                        if (possibleParallel <= 0 || possibleParallel <= aspectMaxParallel.computeIfAbsent(aspect, k -> 0)) continue;
                        aspectMaxParallel.put(aspect, possibleParallel);
                        this.aspectProvider.put(aspect, hatch);
                    }
                    if ((Integer)aspectMaxParallel.get(aspect) != 0) continue;
                    return Essentia_InsentiaL;
                }
                this.maxParallel = Integer.min((Integer)Collections.min(aspectMaxParallel.values()), this.maxParallel);
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @NotNull
            protected CheckRecipeResult onRecipeStart(@NotNull GTRecipe recipe) {
                for (Aspect aspect : this.aspectProvider.keySet()) {
                    this.aspectProvider.get(aspect).takeFromContainer(aspect, this.aspects.getAmount(aspect) * this.getCurrentParallels());
                }
                return super.onRecipeStart(recipe);
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    public boolean isResearchComplete(String key) {
        if (!key.startsWith("@") && ResearchCategories.getResearch((String)key) == null) {
            return false;
        }
        return this.Research != null && !this.Research.isEmpty() && this.Research.contains(key);
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        return super.checkProcessing();
    }

    private String getUsername() {
        return this.getBaseMetaTileEntity().getOwnerName();
    }

    public RecipeMap<?> getRecipeMap() {
        return GTCMRecipe.IndustrialAlchemyTowerRecipes;
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return this.mSpeedBonus == 0.08732556717955883;
    }

    @Override
    protected float getSpeedBonus() {
        this.mSpeedBonus = 0.0;
        this.countSpeedBonus();
        return (float)this.mSpeedBonus;
    }

    private void countSpeedBonus() {
        if (this.mNodeEnergized.isEmpty()) {
            this.mSpeedBonus = 1.0;
            return;
        }
        if (this.mNodeEnergized.size() < 4) {
            this.mSpeedBonus = 1.0 - (double)this.mNodeEnergized.size() * 0.1;
            return;
        }
        int fire = this.getMaxPurityNodeAmount(this.mNodeEnergized, Aspect.FIRE);
        int air = this.getMaxPurityNodeAmount(this.mNodeEnergized, Aspect.AIR);
        int order = this.getMaxPurityNodeAmount(this.mNodeEnergized, Aspect.ORDER);
        int entropy = this.getMaxPurityNodeAmount(this.mNodeEnergized, Aspect.ENTROPY);
        List<Integer> data = Arrays.asList(fire, air, order, entropy, 10);
        int min = Collections.min(data);
        int max = Collections.max(data);
        double baseSpeedBonus = 0.08732556717955883 + 0.6126744328204411 * (1.0 - Math.pow(Math.E, min - 10));
        double punishSpeedBonus = (0.7 - baseSpeedBonus) * (double)(max - min) / (double)max;
        this.mSpeedBonus = baseSpeedBonus + punishSpeedBonus;
    }

    private int findMaxIndex(ArrayList<Double> arrayList) {
        int index = 0;
        for (int i = 1; i < arrayList.size(); ++i) {
            if (!(arrayList.get(i) > arrayList.get(index))) continue;
            index = i;
        }
        return index;
    }

    private int getMaxPurityNodeAmount(ArrayList<TileNodeEnergized> mNodeEnergized, Aspect aspect) {
        ArrayList<Double> Purity = new ArrayList<Double>();
        for (TileNodeEnergized node : mNodeEnergized) {
            AspectList aspects = node.getAspects();
            double sum = 0.0;
            for (Aspect a : node.getAspects().getPrimalAspects()) {
                sum += (double)aspects.getAmount(a);
            }
            double sAspect = node.getAspects().getAmount(aspect);
            Purity.add(sAspect / sum);
        }
        return mNodeEnergized.get(this.findMaxIndex(Purity)).getAspects().getAmount(aspect);
    }

    private int getmParallel() {
        return (int)Math.pow(this.essentiaCellTier, 5.0);
    }

    @Override
    protected int getLimitedMaxParallel() {
        return this.getMaxParallelRecipes();
    }

    @Override
    public int getMaxParallelRecipes() {
        if (this.getControllerSlot() == null) {
            return this.getmParallel();
        }
        if (this.getControllerSlot().func_77969_a(this.ProofOfHeroes)) {
            return Integer.MAX_VALUE;
        }
        return this.getmParallel();
    }

    @Override
    public String[] getInfoData() {
        return super.getInfoData();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 7, 15, 1);
    }

    public IStructureDefinition<TST_IndustrialAlchemyTower> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            String channel = "chisel";
            ImmutableList list = ImmutableList.of((Object)TstUtils.newItemWithMeta(ConfigBlocks.blockCosmeticSolid, 6), (Object)TstUtils.newItemWithMeta((Block)ModBlocksHandler.BlockArcane_1.getLeft(), (int)((Integer)ModBlocksHandler.BlockArcane_1.getRight())), (Object)TstUtils.newItemWithMeta((Block)ModBlocksHandler.BlockArcane_4.getLeft(), (int)((Integer)ModBlocksHandler.BlockArcane_4.getRight())));
            STRUCTURE_DEFINITION = TSTStructureUtility.StructureDefinitionBuilder(TST_IndustrialAlchemyTower.class).addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])shape)).addElement('A', StructureUtility.withChannel((String)"essentia_cell", (IStructureElement)StructureUtility.ofBlocksTiered((a, b) -> a == Loaders.essentiaCell ? b + 1 : 0, (List)ImmutableList.of((Object)Pair.of((Object)Loaders.essentiaCell, (Object)0), (Object)Pair.of((Object)Loaders.essentiaCell, (Object)1), (Object)Pair.of((Object)Loaders.essentiaCell, (Object)2), (Object)Pair.of((Object)Loaders.essentiaCell, (Object)3)), (Object)0, (x, y) -> {
                x.essentiaCellTier = y;
            }, x -> x.essentiaCellTier))).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(TST_IndustrialAlchemyTower.class).atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Energy}).adder(GTCM_MultiMachineBase::addToMachineList).casingIndex(1536).dot(1).buildAndChain(Loaders.magicCasing, 0), TSTStructureUtility.ofAccurateTileAdder(TST_IndustrialAlchemyTower::addInfusionProvider, BlockEnum.INFUSION_PROVIDER.getBlock(), 0), TSTStructureUtility.ofAccurateBlockAdder(TST_IndustrialAlchemyTower::addTravelAnchor, (Block)ModBlocksHandler.BlockTravelAnchor.getLeft(), (Integer)ModBlocksHandler.BlockTravelAnchor.getRight())})).addElement('C', StructureUtility.ofBlock((Block)((Block)ModBlocksHandler.FieryBlock.getLeft()), (int)((Integer)ModBlocksHandler.FieryBlock.getRight()))).addElement('D', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{TSTStructureUtility.ofAccurateTileAdder(TST_IndustrialAlchemyTower::addCosmeticOpaque, ConfigBlocks.blockCosmeticOpaque, 2), TSTStructureUtility.ofAccurateTile(TileArcaneHole.class, TstBlocks.BlockArcaneHole, 0)})).addElement('E', TSTStructureUtility.ofBlockStrict(ConfigBlocks.blockSlabStone, 0)).addElement('F', StructureUtility.ofBlock((Block)ConfigBlocks.blockCosmeticSolid, (int)0)).addElement('G', TSTStructureUtility.ofVariableBlock(channel, ConfigBlocks.blockCosmeticSolid, 6, (List<ItemStack>)list)).addElement('H', StructureUtility.ofBlock((Block)ConfigBlocks.blockCosmeticSolid, (int)7)).addElement('I', TSTStructureUtility.ofBlockStrictExt(ConfigBlocks.blockSlabStone, 8, ConfigBlocks.blockSlabStone, 0)).addElement('J', StructureUtility.ofBlock((Block)ConfigBlocks.blockMetalDevice, (int)3)).addElement('K', StructureUtility.ofBlock((Block)ConfigBlocks.blockMetalDevice, (int)9)).addElement('L', StructureUtility.ofBlock((Block)((Block)ModBlocksHandler.BlockTranslucent.getLeft()), (int)((Integer)ModBlocksHandler.BlockTranslucent.getRight()))).addElement('M', StructureUtility.ofBlock((Block)((Block)ModBlocksHandler.BlockTranslucent.getLeft()), (int)((Integer)ModBlocksHandler.BlockTranslucent.getRight()))).addElement('N', TSTStructureUtility.ofVariableBlock(channel, (Block)ModBlocksHandler.BlockArcane_1.getLeft(), (Integer)ModBlocksHandler.BlockArcane_1.getRight(), (List<ItemStack>)list)).addElement('O', TSTStructureUtility.ofVariableBlock(channel, (Block)ModBlocksHandler.BlockArcane_4.getLeft(), (Integer)ModBlocksHandler.BlockArcane_4.getRight(), (List<ItemStack>)list)).addElement('P', StructureUtility.ofBlock((Block)((Block)ModBlocksHandler.EldritchArk.getLeft()), (int)((Integer)ModBlocksHandler.EldritchArk.getRight()))).addElement('Q', StructureUtility.ofBlock((Block)((Block)ModBlocksHandler.CarvedEminenceStone.getLeft()), (int)((Integer)ModBlocksHandler.CarvedEminenceStone.getRight()))).addElement('R', TSTStructureUtility.ofAccurateTile(TileCrucible.class, ConfigBlocks.blockMetalDevice, 0)).addElement('S', TSTStructureUtility.ofAccurateTileAdder(TST_IndustrialAlchemyTower::addCosmeticOpaque, ConfigBlocks.blockCosmeticOpaque, 2)).addElement('U', TSTStructureUtility.ofAccurateTile(TileNodeStabilizer.class, ConfigBlocks.blockStoneDevice, 10)).addElement('V', TSTStructureUtility.ofAccurateTile(TileNodeConverter.class, ConfigBlocks.blockStoneDevice, 11)).addElement('W', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofTileAdder(TST_IndustrialAlchemyTower::addNodeEnergized, (Block)ConfigBlocks.blockAiry, (int)0), StructureUtility.ofBlock((Block)Blocks.field_150350_a, (int)0)})).addElement('X', TSTStructureUtility.ofAccurateTile(TileElectricCloud.class, EMTBlocks.electricCloud, 0)).addElement('Y', TSTStructureUtility.ofAccurateTile(TileEntityBeacon.class, (Block)Blocks.field_150461_bJ, 0)).addElement('Z', TSTStructureUtility.ofAccurateTileExt(TileNitor.class, ConfigBlocks.blockAiry, 1, ConfigItems.itemResource, 1)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    private String getPlayName() {
        return this.getBaseMetaTileEntity().getOwnerName();
    }

    public boolean addTravelAnchor(Block block, int meta) {
        if (block instanceof ITileEntityProvider) {
            return block.getClass().getSimpleName().equals("BlockTravelAnchor");
        }
        return block == Blocks.field_150348_b;
    }

    public boolean addCosmeticOpaque(TileEntity tileEntity) {
        if (tileEntity instanceof TileOwned) {
            TileOwned tileOwned = (TileOwned)tileEntity;
            if (this.getPlayName() != null && Objects.equals(tileOwned.owner, "")) {
                tileOwned.owner = this.getPlayName();
            }
            return true;
        }
        return false;
    }

    public final boolean addNodeEnergized(TileEntity aTileEntity) {
        if (aTileEntity instanceof TileNodeEnergized) {
            if (this.mNodeEnergized.size() != 4) {
                return this.mNodeEnergized.add((TileNodeEnergized)aTileEntity);
            }
            return true;
        }
        return false;
    }

    public boolean addInfusionProvider(TileEntity aTileEntity) {
        if (aTileEntity instanceof TileInfusionProvider) {
            return this.mTileInfusionProvider.add((TileInfusionProvider)aTileEntity);
        }
        return false;
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 7, 15, 1, elementBudget, env, false, true);
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextEnums.tr("Tooltip_IndustrialAlchemyTower_MachineType")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_Controller")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_00")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_01")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_02")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_03")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_04")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_05")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_06")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_07")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_08")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_09")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_10")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_11")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_12")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_13")).addInfo(TextEnums.tr("Tooltip_IndustrialAlchemyTower_14")).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addInfo(TextEnums.tr("Tooltip_Channel_Helper")).addOtherStructurePart(TextEnums.tr("Tooltip_IndustrialAlchemyTower_15"), TextEnums.tr("Tooltip_IndustrialAlchemyTower_16")).addInputBus(TextEnums.tr("Tooltip_IndustrialAlchemyTower_16")).addOutputBus(TextEnums.tr("Tooltip_IndustrialAlchemyTower_16")).addEnergyHatch(TextEnums.tr("Tooltip_IndustrialAlchemyTower_16")).addOtherStructurePart(TextEnums.tr("Tooltip_IndustrialAlchemyTower_17"), TextEnums.tr("Tooltip_IndustrialAlchemyTower_16")).addOtherStructurePart(TextEnums.tr("Tooltip_IndustrialAlchemyTower_18"), TextEnums.tr("Tooltip_IndustrialAlchemyTower_19")).addOtherStructurePart(TextEnums.tr("Tooltip_IndustrialAlchemyTower_20"), TextEnums.tr("Tooltip_IndustrialAlchemyTower_21")).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        NBTTagList nbtTagList = new NBTTagList();
        for (String string : this.Research) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("ResearchName", string);
            nbtTagList.func_74742_a((NBTBase)tag);
        }
        aNBT.func_74768_a("essentiaCellTier", this.essentiaCellTier);
        aNBT.func_74780_a("mSpeedBonus", this.mSpeedBonus);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.Research.clear();
        for (int i = 0; i < aNBT.func_150295_c("Research", 10).func_74745_c(); ++i) {
            if (!aNBT.func_150295_c("Research", 10).func_150305_b(i).func_74764_b("ResearchName")) continue;
            this.Research.add(aNBT.func_150295_c("Research", 10).func_150305_b(i).func_74779_i("ResearchName"));
        }
        this.essentiaCellTier = aNBT.func_74762_e("essentiaCellTier");
        this.mSpeedBonus = aNBT.func_74769_h("mSpeedBonus");
        super.loadNBTData(aNBT);
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aTick % 100L == 0L) {
            super.onPreTick(aBaseMetaTileEntity, aTick);
            if (aBaseMetaTileEntity.isServerSide()) {
                ArrayList list = ResearchManager.getResearchForPlayer((String)this.getUsername());
                if (this.Research == null && list != null || list != null && !list.isEmpty() && this.Research.size() != list.size()) {
                    this.Research = list;
                }
            }
        }
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.essentiaCellTier = 0;
        this.mNodeEnergized.clear();
        this.repairMachine();
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 15, 1);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_IndustrialAlchemyTower(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{TextureFactory.of((Block)ConfigBlocks.blockMetalDevice, (int)9), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{TextureFactory.of((Block)ConfigBlocks.blockMetalDevice, (int)9), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{TextureFactory.of((Block)ConfigBlocks.blockMetalDevice, (int)9)};
    }
}

