/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.client.texture.UITextures;
import com.Nxer.TwistSpaceTechnology.common.init.TstBlocks;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.recipeMap.GTCMRecipe;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.google.common.collect.Lists;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchMultiInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import gtPlusPlus.core.block.base.BasicBlock;
import gtPlusPlus.core.block.base.BlockBaseModular;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialsAlloy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class TST_HyperThermalConvector
extends GTCM_MultiMachineBase<TST_HyperThermalConvector> {
    private static final int baseHorizontalOffSet = 10;
    private static final int baseVerticalOffSet = 6;
    private static final int baseDepthOffSet = 2;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String[][] shapeMain = new String[][]{{"                     ", "                     ", "                     ", "       HHGGGHH       ", "      HHHHHHHHH      ", "     JGHHHHHHHGJ     ", "    JGGGGGGGGGGGJ    ", "    JGIIIIIIIIIGJ    ", "    JGGGGGGGGGGGJ    ", "     JGHHHHHHHGJ     ", "      HHHHHHHHH      ", "       HHHHHHH       ", "                     ", "                     ", "                     "}, {"                     ", "                     ", "       HGGGGGH       ", "      HEEEEEEEH      ", "     EECCCCCCCEE     ", "  EEEGCCCCCCCCCGEEE  ", " EGGGCCCCCCCCCCCGGGE ", " EGGGCCCCCCCCCCCGGGE ", " EGGGCCCCCCCCCCCGGGE ", "  EEEGCCCCCCCCCGEEE  ", "     EECCCCCCCEE     ", "      HEEEEEEEH      ", "       HGGGGGH       ", "                     ", "                     "}, {"                     ", "                     ", "       HGGGGGH       ", "      HDDDDDDDH      ", "     GECCCCCCCEG     ", "  GGGCCLLQQQLLCCGGG  ", " GPPPPPPLNNNLPPPPPPG ", " GPPPPPPLNNNLPPPPPPG ", " GPPPPPPLNNNLPPPPPPG ", "  GGGCCLLQQQLLCCGGG  ", "     GECCCCCCCEG     ", "      HDDDDDDDH      ", "       HGGGGGH       ", "                     ", "                     "}, {"                     ", "                     ", "       HGGGGGH       ", "      HDDDDDDDH      ", "     GECCCCCCCEG     ", "  GRGCCLLNNNLLCCGTG  ", " GPFPPPPBOOOAPPPPFPG ", " GPFFFFPBOOOAPFFFFPG ", " GPPPPPPBOOOAPPPPPPG ", "  GGGCCLLNNNLLCCGGG  ", "     GECCCCCCCEG     ", "      HDDDDDDDH      ", "       HGGGGGH       ", "                     ", "                     "}, {"                     ", "                     ", "      HGGGGGGGH      ", "     HKDDDDDDDKH     ", "     GECCCCCCCEG     ", "  GGGCCLLNNNLLCCGGG  ", " GPPPPPPBOOOAPPPPPPG ", " GPPPPFPBOOOAPFPPPPG ", " GPPPPPPBOOOAPPPPPPG ", "  GGGCCLLNNNLLCCGGG  ", "     GECCCCCCCEG     ", "     HKDDDDDDDKH     ", "      HGGGGGGGH      ", "                     ", "                     "}, {"                     ", "                     ", "      HGGGGGGGH      ", "     HKDDDDDDDKH     ", "     EECCCCCCCEE     ", "  EEECCLLNNNLLCCEEE  ", " EQQQPPPBOOOAPPPQQQE ", " EQQQPFPBOOOAPFPQQQE ", " EQQQPPPBOOOAPPPQQQE ", "  EEECCLLNNNLLCCEEE  ", "     EECCCCCCCEE     ", "     HKDDDDDDDKH     ", "      HGGGGGGGH      ", "                     ", "                     "}, {"                     ", "                     ", "      HGGG~GGGH      ", "     HKDDDDDDDKH     ", "     DDCCCCCCCDD     ", "  DDDCCLLNNNLLCCDDD  ", " DCCCPPPBOOOAPPPCCCD ", " DCCCPFPBOOOAPFPCCCD ", " DCCCPPPBOOOAPPPCCCD ", "  DDDCCLLNNNLLCCDDD  ", "     DDCCCCCCCDD     ", "     HKDDDDDDDEH     ", "      HGGGGGGGH      ", "                     ", "                     "}, {"                     ", "                     ", "      HGGGGGGGH      ", "     HKDDDDDDDKH     ", "     EECCCCCCCEE     ", "  EEECCLLNNNLLCCEEE  ", " EQQQPPPBOOOAPPPQQQE ", " EQQQPFPBOOOAPFPQQQE ", " EQQQPPPBOOOAPPPQQQE ", "  EEECCLLNNNLLCCEEE  ", "     EECCCCCCCEE     ", "     HKDDDDDDDKH     ", "      HGGGGGGGH      ", "                     ", "                     "}, {"                     ", "                     ", "      HGGGGGGGH      ", "     HKDDDDDDDKH     ", "     GECCCCCCCEG     ", "  GGGCCLLNNNLLCCGGG  ", " GPPPPPPBOOOAPPPPPPG ", " GPPPPFPBOOOAPFPPPPG ", " GPPPPPPBOOOAPPPPPPG ", "  GGGCCLLNNNLLCCGGG  ", "     GECCCCCCCEG     ", "     HKDDDDDDDKH     ", "      HGGGGGGGH      ", "                     ", "                     "}, {"                     ", "                     ", "       HGGGGGH       ", "      HDDDDDDDH      ", "     GECCCCCCCEG     ", "  GSGCCLLNNNLLCCGUG  ", " GPFPPPPBOOOAPPPPFPG ", " GPFFFFPBOOOAPFFFFPG ", " GPPPPPPBOOOAPPPPPPG ", "  GGGCCLLNNNLLCCGNG  ", "     GECCCCCCCEG     ", "      HDDDDDDDH      ", "       HGGGGGH       ", "                     ", "                     "}, {"                     ", "                     ", "       HGGGGGH       ", "      HDDDDDDDH      ", "     GECCCCCCCEG     ", "  GGGCCLLQQQLLCCGGG  ", " GPPPPPPLNNNLPPPPPPG ", " GPPPPPPLNNNLPPPPPPG ", " GPPPPPPLNNNLPPPPPPG ", "  GGGCCLLQQQLLCCGGG  ", "     GECCCCCCCEG     ", "      HDDDDDDDH      ", "       HGGGGGH       ", "                     ", "                     "}, {"                     ", "                     ", "       HGGGGGH       ", "      HEEEEEEEH      ", "     EECCCCCCCEE     ", "  EEEGCCCCCCCCCGEEE  ", " EGGGCCCCCCCCCCCGGGE ", " EGGGCCCCCCCCCCCGGGE ", " EGGGCCCCCCCCCCCGGGE ", "  EEEGCCCCCCCCCGEEE  ", "     EECCCCCCCEE     ", "      HEEEEEEEH      ", "       HGGGGGH       ", "                     ", "                     "}, {"       MMMMMMM       ", "      MMMMMMMMM      ", "    MMMMMMMMMMMMM    ", " MMMMMMHHGGGHHMMMMMM ", "MMMMMMHHHHHHHHHMMMMMM", "MMMMMGGHHHHHHHGGMMMMM", "MMMMGGGGGGGGGGGGGMMMM", "MMMMGGGGGGGGGGGGGMMMM", "MMMMGGGGGGGGGGGGGMMMM", "MMMMMGGHHHHHHHGGMMMMM", "MMMMMMHHHHHHHHHMMMMMM", " MMMMMMHHHHHHHMMMMMM ", "    MMMMMMMMMMMMM    ", "      MMMMMMMMM      ", "       MMMMMMM       "}, {"       MMMMMMM       ", "      MMMMMMMMM      ", "    MMMMMMMMMMMMM    ", " MMMMMMMMMMMMMMMMMMM ", "MMMMMMMMMMMMMMMMMMMMM", "MMMMMMMMMMMMMMMMMMMMM", "MMMMMMMMMMMMMMMMMMMMM", "MMMMMMMMMMMMMMMMMMMMM", "MMMMMMMMMMMMMMMMMMMMM", "MMMMMMMMMMMMMMMMMMMMM", "MMMMMMMMMMMMMMMMMMMMM", " MMMMMMMMMMMMMMMMMMM ", "    MMMMMMMMMMMMM    ", "      MMMMMMMMM      ", "       MMMMMMM       "}};
    private static IStructureDefinition<TST_HyperThermalConvector> STRUCTURE_DEFINITION = null;
    private MTEHatchInput mDistilledWaterHatch;
    private MTEHatchOutput mSteamHatch;
    private MTEHatchInput mHotFluidHatch;
    private MTEHatchOutput mColdFluidHatch;
    List<MTEHatchInput> dedicatedHatches = new ArrayList<MTEHatchInput>();
    static Fluid distilledWater;
    protected boolean isRecipeProcessing = false;

    public TST_HyperThermalConvector(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_HyperThermalConvector(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_HyperThermalConvector(this.mName);
    }

    public IStructureDefinition<TST_HyperThermalConvector> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])shapeMain)).addElement('A', StructureUtility.ofBlock((Block)(BlockBaseModular.getMaterialBlock((Material)MaterialsAlloy.HS188A, (BasicBlock.BlockTypes)BasicBlock.BlockTypes.STANDARD) != null ? BlockBaseModular.getMaterialBlock((Material)MaterialsAlloy.HS188A, (BasicBlock.BlockTypes)BasicBlock.BlockTypes.STANDARD) : Blocks.field_150348_b), (int)0)).addElement('B', StructureUtility.ofBlock((Block)(BlockBaseModular.getMaterialBlock((Material)MaterialsAlloy.QUANTUM, (BasicBlock.BlockTypes)BasicBlock.BlockTypes.STANDARD) != null ? BlockBaseModular.getMaterialBlock((Material)MaterialsAlloy.QUANTUM, (BasicBlock.BlockTypes)BasicBlock.BlockTypes.STANDARD) : Blocks.field_150348_b), (int)0)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)11)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)1)).addElement('E', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)14)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings6, (int)10)).addElement('G', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)7)).addElement('H', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)10)).addElement('I', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)1)).addElement('J', GTStructureUtility.ofFrame((Materials)Materials.Iridium)).addElement('K', GTStructureUtility.ofFrame((Materials)Materials.CosmicNeutronium)).addElement('L', StructureUtility.ofBlock((Block)Loaders.pressureResistantWalls, (int)0)).addElement('M', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsDyson, (int)9)).addElement('N', StructureUtility.ofBlock((Block)TstBlocks.MetaBlockCasing02, (int)2)).addElement('O', StructureUtility.ofBlock((Block)TstBlocks.MetaBlockCasing02, (int)3)).addElement('P', StructureUtility.ofBlock((Block)TstBlocks.MetaBlockCasing02, (int)4)).addElement('Q', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)8)).addElement('R', (IStructureElement)GTStructureUtility.buildHatchAdder(TST_HyperThermalConvector.class).hatchClass(MTEHatchInput.class).adder(TST_HyperThermalConvector::addHotFluidInputHatch).dot(1).casingIndex(TstBlocks.MetaBlockCasing02.getTextureIndex(2)).buildAndChain((Block)TstBlocks.MetaBlockCasing02, 2)).addElement('S', (IStructureElement)GTStructureUtility.buildHatchAdder(TST_HyperThermalConvector.class).hatchClass(MTEHatchOutput.class).adder(TST_HyperThermalConvector::addColdFluidOutputHatch).dot(2).casingIndex(TstBlocks.MetaBlockCasing02.getTextureIndex(2)).buildAndChain((Block)TstBlocks.MetaBlockCasing02, 2)).addElement('T', (IStructureElement)GTStructureUtility.buildHatchAdder(TST_HyperThermalConvector.class).hatchClass(MTEHatchOutput.class).adder(TST_HyperThermalConvector::addSteamOutputHatch).dot(3).casingIndex(TstBlocks.MetaBlockCasing02.getTextureIndex(2)).buildAndChain((Block)TstBlocks.MetaBlockCasing02, 2)).addElement('U', (IStructureElement)GTStructureUtility.buildHatchAdder(TST_HyperThermalConvector.class).hatchClass(MTEHatchInput.class).adder(TST_HyperThermalConvector::addDistilledWaterInputHatch).dot(4).casingIndex(TstBlocks.MetaBlockCasing02.getTextureIndex(2)).buildAndChain((Block)TstBlocks.MetaBlockCasing02, 2)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.repairMachine();
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 10, 6, 2);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 10, 6, 2, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.mHotFluidHatch = null;
        this.mDistilledWaterHatch = null;
        this.mSteamHatch = null;
        this.mColdFluidHatch = null;
        this.dedicatedHatches.clear();
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 10, 6, 2)) {
            return false;
        }
        Collections.addAll(this.dedicatedHatches, this.mHotFluidHatch, this.mDistilledWaterHatch);
        return this.mHotFluidHatch != null && this.mColdFluidHatch != null;
    }

    public RecipeMap<?> getRecipeMap() {
        return this.machineMode == 0 ? GTCMRecipe.RapidHeatExchangeRecipes : GTCMRecipe.RapidCoolingDownRecipes;
    }

    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(GTCMRecipe.RapidHeatExchangeRecipes, GTCMRecipe.RapidCoolingDownRecipes);
    }

    @Override
    public int totalMachineMode() {
        return 2;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.add(UITextures.HESTTD_HeatExchanger);
        this.machineModeIcons.add(UITextures.HESTTD_RapidCooling);
    }

    public void setMachineMode(int index) {
        super.setMachineMode(index);
    }

    @Override
    public String getMachineModeName(int mode) {
        return TextEnums.tr("HyperThermalConvector.modeMsg." + mode);
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (distilledWater == null) {
            distilledWater = FluidRegistry.getFluid((String)"ic2distilledwater");
        }
    }

    public boolean addHotFluidInputHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.mHotFluidHatch = (MTEHatchInput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addColdFluidOutputHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.mColdFluidHatch = (MTEHatchOutput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addDistilledWaterInputHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.mDistilledWaterHatch = (MTEHatchInput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addSteamOutputHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.mSteamHatch = (MTEHatchOutput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public List<? extends IFluidStore> getFluidOutputSlots(FluidStack[] toOutput) {
        return (List)GTUtility.filterValidMTEs((Collection)Lists.newArrayList((Object[])new MTEHatchOutput[]{this.mColdFluidHatch, this.mSteamHatch}));
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return false;
    }

    @Override
    protected float getSpeedBonus() {
        return 1.0f;
    }

    @Override
    public int getMaxParallelRecipes() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Nonnull
    public CheckRecipeResult checkProcessing() {
        int cycleNum = this.machineMode == 0 ? 128 : 16;
        boolean succeeded = false;
        CheckRecipeResult finalResult = CheckRecipeResultRegistry.SUCCESSFUL;
        for (int i = 0; i < cycleNum; ++i) {
            CheckRecipeResult r = this.processSingleBatch();
            if (!r.wasSuccessful()) {
                finalResult = r;
                break;
            }
            succeeded = true;
        }
        this.updateSlots();
        if (!succeeded) {
            return finalResult;
        }
        this.mMaxProgresstime = 20;
        this.mEfficiency = 10000;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private CheckRecipeResult processSingleBatch() {
        if (!this.isRecipeProcessing) {
            this.startRecipeProcessing();
        }
        this.setupProcessingLogic(this.processingLogic);
        CheckRecipeResult result = this.doCheckRecipe();
        if (!result.wasSuccessful()) {
            return result;
        }
        this.mOutputFluids = (FluidStack[])ArrayUtils.addAll((Object[])this.mOutputFluids, (Object[])this.processingLogic.getOutputFluids());
        this.endRecipeProcessing();
        return result;
    }

    public void startRecipeProcessing() {
        super.startRecipeProcessing();
        this.isRecipeProcessing = true;
        for (MTEHatchInput mHatch : this.dedicatedHatches) {
            if (null == mHatch || !mHatch.isValid() || !(mHatch instanceof IRecipeProcessingAwareHatch)) continue;
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)mHatch;
            aware.startRecipeProcessing();
        }
    }

    public void endRecipeProcessing() {
        this.isRecipeProcessing = false;
        super.endRecipeProcessing();
        for (MTEHatchInput mHatch : this.dedicatedHatches) {
            if (null == mHatch || !mHatch.isValid() || !(mHatch instanceof IRecipeProcessingAwareHatch)) continue;
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)mHatch;
            this.setResultIfFailure(aware.endRecipeProcessing((MTEMultiBlockBase)this));
        }
    }

    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        HashMap<Fluid, FluidStack> inputsFromME = new HashMap<Fluid, FluidStack>();
        for (MTEHatchInput tHatch : this.dedicatedHatches) {
            boolean isWaterHatch;
            if (tHatch == null) continue;
            boolean bl = isWaterHatch = tHatch == this.mDistilledWaterHatch;
            if (tHatch instanceof MTEHatchMultiInput) {
                MTEHatchMultiInput multiInputHatch = (MTEHatchMultiInput)tHatch;
                for (FluidStack tFluid : multiInputHatch.getStoredFluid()) {
                    if (tFluid == null || isWaterHatch && this.isNotDistilledWater(tFluid.getFluid())) continue;
                    rList.add(tFluid);
                }
                continue;
            }
            if (tHatch instanceof MTEHatchInputME) {
                MTEHatchInputME meHatch = (MTEHatchInputME)tHatch;
                for (FluidStack fluidStack : meHatch.getStoredFluids()) {
                    if (fluidStack == null || isWaterHatch && this.isNotDistilledWater(fluidStack.getFluid())) continue;
                    inputsFromME.put(fluidStack.getFluid(), fluidStack);
                }
                continue;
            }
            FluidStack fillableStack = tHatch.getFillableStack();
            if (fillableStack == null || isWaterHatch && this.isNotDistilledWater(fillableStack.getFluid())) continue;
            rList.add(fillableStack);
        }
        if (!inputsFromME.isEmpty()) {
            rList.addAll(inputsFromME.values());
        }
        return rList;
    }

    public boolean addOutput(FluidStack aLiquid) {
        if (aLiquid == null || aLiquid.amount == 0) {
            return false;
        }
        FluidStack copiedFluidStack = aLiquid.copy();
        List<MTEHatchOutput> targetHatches = Collections.singletonList(this.isSteam(aLiquid) ? this.mSteamHatch : this.mColdFluidHatch);
        if (!TST_HyperThermalConvector.dumpFluid(targetHatches, (FluidStack)copiedFluidStack, (boolean)true)) {
            TST_HyperThermalConvector.dumpFluid(targetHatches, (FluidStack)copiedFluidStack, (boolean)false);
        }
        return false;
    }

    private boolean isSteam(FluidStack stack) {
        return stack != null && (stack.isFluidEqual(Materials.DenseSupercriticalSteam.getGas(1L)) || stack.isFluidEqual(Materials.DenseSuperheatedSteam.getGas(1L)));
    }

    private boolean isNotDistilledWater(Fluid fluid) {
        return fluid != null && fluid != distilledWater;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        ITexture Base = Textures.BlockIcons.getCasingTextureForId((int)183);
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Base, TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_DTPF_ON).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FUSION1_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Base, TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_DTPF_OFF).extFacing().build()};
        }
        return new ITexture[]{Base};
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextEnums.tr("Tooltip_HyperThermalConvector_MachineType")).addInfo(TextEnums.tr("Tooltip_HyperThermalConvector_Controller")).addInfo(TextEnums.tr("Tooltip_HyperThermalConvector.1")).addInfo(TextEnums.tr("Tooltip_HyperThermalConvector.2")).addInfo(TextEnums.tr("Tooltip_HyperThermalConvector.3")).addInfo(TextEnums.tr("Tooltip_HyperThermalConvector.4")).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addOtherStructurePart(TextEnums.tr("Tooltip_HyperThermalConvector.11"), TextLocalization.getBlueprintWithDot(1), new int[]{1}).addOtherStructurePart(TextEnums.tr("Tooltip_HyperThermalConvector.12"), TextLocalization.getBlueprintWithDot(2), new int[]{2}).addOtherStructurePart(TextEnums.tr("Tooltip_HyperThermalConvector.13"), TextLocalization.getBlueprintWithDot(3), new int[]{3}).addOtherStructurePart(TextEnums.tr("Tooltip_HyperThermalConvector.14"), TextLocalization.getBlueprintWithDot(4), new int[]{4}).addStructureInfo(TextLocalization.Text_SeparatingLine).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }
}

