/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import bwcrossmod.galacticgreg.VoidMinerUtility;
import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.common.init.TstBlocks;
import com.Nxer.TwistSpaceTechnology.common.machine.ValueEnum;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.config.Config;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class TST_EyeOfWood
extends GTCM_MultiMachineBase<TST_EyeOfWood> {
    protected static VoidMinerUtility.DropMap dropMap = null;
    protected static VoidMinerUtility.DropMap extraDropMap = null;
    protected static float totalWeight = 0.0f;
    private static boolean preGenerated = false;
    private static Fluid WATER;
    private static Fluid LAVA;
    private static final int STANDARD_WATER_BUCKET;
    private static final int STANDARD_WATER_AMOUNT;
    private static final int STANDARD_LAVA_BUCKET;
    private static final int STANDARD_LAVA_AMOUNT;
    private static final int STANDARD_DIMENSION_ID;
    private static final boolean ALLOW_PERSONAL_SPACE;
    private static final double STANDARD_SUBSTRATE;
    private int storedWater = 0;
    private int storedLava = 0;
    private boolean enableRender = Config.EnableRenderDefault_EyeOfWood;
    public boolean isRendering = false;
    private static final String STRUCTURE_PIECE_MAIN = "mainEyeOfWood";
    private final int horizontalOffSet = 16;
    private final int verticalOffSet = 16;
    private final int depthOffSet = 0;
    private static IStructureDefinition<TST_EyeOfWood> STRUCTURE_DEFINITION;
    private static MultiblockTooltipBuilder tt;

    public TST_EyeOfWood(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_EyeOfWood(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_EyeOfWood(this.mName);
    }

    @Override
    public String[] getInfoData() {
        String[] origin = super.getInfoData();
        String[] ret = new String[origin.length + 3];
        System.arraycopy(origin, 0, ret, 0, origin.length);
        ret[origin.length] = TextEnums.tr("getInfoData.StoredWater") + " : " + EnumChatFormatting.BLUE + this.storedWater + EnumChatFormatting.RESET + "L / " + STANDARD_WATER_AMOUNT + "L";
        ret[origin.length + 1] = TextEnums.tr("getInfoData.StoredLava") + " : " + EnumChatFormatting.RED + this.storedLava + EnumChatFormatting.RESET + "L / " + STANDARD_LAVA_AMOUNT + "L";
        ret[origin.length + 2] = TextEnums.tr("getInfoData.SuccessChance") + " : " + EnumChatFormatting.GOLD + this.getSuccessChance() + " / 10000";
        return ret;
    }

    private void resetStored() {
        this.storedWater = 0;
        this.storedLava = 0;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("storedWater", this.storedWater);
        aNBT.func_74768_a("storedLava", this.storedLava);
        aNBT.func_74757_a("isRendering", this.isRendering);
        aNBT.func_74757_a("enableRender", this.enableRender);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.storedWater = aNBT.func_74762_e("storedWater");
        this.storedLava = aNBT.func_74762_e("storedLava");
        this.isRendering = aNBT.func_74767_n("isRendering");
        this.enableRender = aNBT.func_74767_n("enableRender");
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aStack) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.enableRender = !this.enableRender;
            TstUtils.sendMessageKeyToPlayer(aPlayer, "EyeOfWood.enableRender." + this.enableRender);
            if (!this.enableRender && this.isRendering) {
                this.destroyRenderBlock();
                this.isRendering = false;
            }
        }
    }

    public void createRenderBlock() {
        int x = this.getBaseMetaTileEntity().getXCoord();
        short y = this.getBaseMetaTileEntity().getYCoord();
        int z = this.getBaseMetaTileEntity().getZCoord();
        double xOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        double zOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        double yOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        this.getBaseMetaTileEntity().getWorld().func_147449_b((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset), Blocks.field_150350_a);
        this.getBaseMetaTileEntity().getWorld().func_147449_b((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset), TstBlocks.BlockEyeOfWoodRender);
    }

    private void destroyRenderBlock() {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        double xOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        double zOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        double yOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        this.getBaseMetaTileEntity().getWorld().func_147449_b((int)((double)x + xOffset), (int)((double)y + yOffset), (int)((double)z + zOffset), Blocks.field_150350_a);
        this.isRendering = false;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        if (dropMap == null || totalWeight == 0.0f) {
            IGregTechTileEntity bmte = this.getBaseMetaTileEntity();
            TwistSpaceTechnology.LOG.info("Invalid dropMap for Eye of Wood at {} {} {} (dim: {}), because the dropMap is {}, totalWeight is {}.", new Object[]{bmte.getXCoord(), bmte.getYCoord(), bmte.getZCoord(), bmte.getWorld().field_73011_w.field_76574_g, dropMap, Float.valueOf(totalWeight)});
            return CheckRecipeResultRegistry.INTERNAL_ERROR;
        }
        int successChance = this.getSuccessChance();
        this.resetStored();
        if (successChance > XSTR.XSTR_INSTANCE.nextInt(10000)) {
            this.mOutputItems = this.getItemOutputs();
        } else {
            this.mOutputFluids = new FluidStack[]{Materials.Water.getGas(36000L * (long)successChance)};
        }
        this.updateSlots();
        this.mMaxProgresstime = ValueEnum.TicksPerProcessing_EyeOfWood;
        if (this.enableRender && !this.isRendering) {
            this.createRenderBlock();
            this.isRendering = true;
        }
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private ItemStack[] getItemOutputs() {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (int i = 0; i < 8; ++i) {
            ItemData oreData = GTOreDictUnificator.getItemData((ItemStack)this.generateOneStackOre());
            if (oreData == null) {
                TwistSpaceTechnology.LOG.info("EOW getItemOutputs error: oreData is null");
                return new ItemStack[0];
            }
            outputs.addAll(this.getOutputs(oreData.mMaterial.mMaterial, (int)oreData.mMaterial.mAmount));
        }
        if (outputs.isEmpty()) {
            return new ItemStack[0];
        }
        return outputs.toArray(new ItemStack[0]);
    }

    public List<ItemStack> getOutputs(Materials material, int multiplier) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (!material.mOreByProducts.isEmpty()) {
            outputs.add(this.getDustStack(material, 64));
            if (material.mOreByProducts.size() == 1) {
                for (Materials byproduct : material.mOreByProducts) {
                    if (byproduct == null) continue;
                    outputs.add(this.getDustStack(byproduct, 48));
                }
            } else {
                for (Materials byproduct : material.mOreByProducts) {
                    if (byproduct == null || byproduct == Materials.Netherrack || byproduct == Materials.Endstone || byproduct == Materials.Stone) continue;
                    outputs.add(this.getDustStack(byproduct, 32));
                }
            }
        } else {
            outputs.add(this.getDustStack(material, 128));
        }
        if (GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)material, (long)1L) != null) {
            if (GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gemExquisite, (Object)material, (long)1L) != null) {
                outputs.add(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gemExquisite, (Object)material, (long)16L));
                outputs.add(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gemFlawless, (Object)material, (long)32L));
                outputs.add(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)material, (long)32L));
            } else {
                outputs.add(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)material, (long)64L));
            }
        }
        if (multiplier > 1) {
            for (ItemStack out : outputs) {
                out.field_77994_a *= multiplier;
            }
        }
        return outputs;
    }

    public ItemStack getDustStack(Materials material, int amount) {
        return GTUtility.copyAmountUnsafe((int)amount, (ItemStack)GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)material, (long)1L));
    }

    private int getSuccessChance() {
        if (this.storedWater == STANDARD_WATER_AMOUNT && this.storedLava == STANDARD_LAVA_AMOUNT) {
            return 7500;
        }
        int waterBucketDifference = Math.abs(this.storedWater - STANDARD_WATER_AMOUNT) / 1000;
        int lavaBucketDifference = Math.abs(this.storedLava - STANDARD_LAVA_AMOUNT) / 1000;
        if (waterBucketDifference >= STANDARD_WATER_BUCKET || lavaBucketDifference >= STANDARD_LAVA_BUCKET) {
            return 1;
        }
        double waterMultiplier = 1.0 / Math.pow(STANDARD_SUBSTRATE, waterBucketDifference);
        double lavaMultiplier = 1.0 / Math.pow(STANDARD_SUBSTRATE, lavaBucketDifference);
        return (int)(7500.0 - 7499.0 * (1.0 - waterMultiplier * lavaMultiplier));
    }

    private ItemStack generateOneStackOre() {
        Map.Entry entry2;
        float currentWeight = 0.0f;
        block0: while (true) {
            float randomNumber = XSTR.XSTR_INSTANCE.nextFloat() * totalWeight;
            for (Map.Entry entry2 : dropMap.getInternalMap().entrySet()) {
                if (!(randomNumber < (currentWeight += ((Float)entry2.getValue()).floatValue()))) continue;
                return ((GTUtility.ItemId)entry2.getKey()).getItemStack();
            }
            Iterator iterator = extraDropMap.getInternalMap().entrySet().iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while (!(randomNumber < (currentWeight += ((Float)(entry2 = iterator.next()).getValue()).floatValue())));
            break;
        }
        return ((GTUtility.ItemId)entry2.getKey()).getItemStack();
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (aBaseMetaTileEntity.isServerSide()) {
            if (!TST_EyeOfWood.isWorkableDimension(aBaseMetaTileEntity.getWorld().field_73011_w)) {
                this.explodeMultiblock();
                return;
            }
            if (!preGenerated) {
                this.initDropMap();
                WATER = Materials.Water.mFluid;
                LAVA = Materials.Lava.mFluid;
                preGenerated = true;
            }
        }
    }

    public void stopMachine(@Nonnull ShutDownReason reason) {
        this.destroyRenderBlock();
        super.stopMachine(reason);
    }

    public void onBlockDestroyed() {
        this.destroyRenderBlock();
        super.onBlockDestroyed();
    }

    protected void initDropMap() {
        dropMap = new VoidMinerUtility.DropMap();
        extraDropMap = new VoidMinerUtility.DropMap();
        WorldProvider worldProvider = this.getBaseMetaTileEntity().getWorld().field_73011_w;
        int dimensionId = worldProvider.field_76574_g;
        if (TST_EyeOfWood.isPersonalSpace(worldProvider) && ALLOW_PERSONAL_SPACE) {
            dimensionId = 0;
        }
        this.handleModDimDef(dimensionId);
        this.handleExtraDrops(dimensionId);
        totalWeight = dropMap.getTotalWeight() + extraDropMap.getTotalWeight();
        if (totalWeight <= 0.0f) {
            TwistSpaceTechnology.LOG.warn("Failed to generate the dropMap of dimension {}", new Object[]{dimensionId});
            dropMap = null;
            extraDropMap = null;
        }
    }

    protected static boolean isPersonalSpace(@NotNull WorldProvider worldProvider) {
        return worldProvider.getClass().getName().contains("PersonalWorldProvider");
    }

    protected static boolean isWorkableDimension(@NotNull WorldProvider worldProvider) {
        return worldProvider.field_76574_g == STANDARD_DIMENSION_ID || ALLOW_PERSONAL_SPACE && TST_EyeOfWood.isPersonalSpace(worldProvider);
    }

    private void handleModDimDef(int id) {
        if (VoidMinerUtility.dropMapsByDimId.containsKey(id)) {
            dropMap = (VoidMinerUtility.DropMap)VoidMinerUtility.dropMapsByDimId.get(id);
        } else {
            String chunkProviderName = ((ChunkProviderServer)this.getBaseMetaTileEntity().getWorld().func_72863_F()).field_73246_d.getClass().getName();
            if (VoidMinerUtility.dropMapsByChunkProviderName.containsKey(chunkProviderName)) {
                dropMap = (VoidMinerUtility.DropMap)VoidMinerUtility.dropMapsByChunkProviderName.get(chunkProviderName);
            }
        }
    }

    private void handleExtraDrops(int id) {
        if (VoidMinerUtility.extraDropsDimMap.containsKey(id)) {
            extraDropMap = (VoidMinerUtility.DropMap)VoidMinerUtility.extraDropsDimMap.get(id);
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick % 20L == 0L) {
            this.startRecipeProcessing();
            ArrayList fluidInputs = this.getStoredFluids();
            if (fluidInputs != null && !fluidInputs.isEmpty()) {
                for (FluidStack fluidStack : fluidInputs) {
                    long t;
                    Fluid fluid = fluidStack.getFluid();
                    if (fluid == WATER) {
                        t = (long)this.storedWater + (long)fluidStack.amount;
                        this.storedWater = t > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)t;
                        fluidStack.amount = 0;
                        continue;
                    }
                    if (fluid != LAVA) continue;
                    t = (long)this.storedLava + (long)fluidStack.amount;
                    this.storedLava = t > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)t;
                    fluidStack.amount = 0;
                }
                this.updateSlots();
            }
            this.endRecipeProcessing();
        }
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return false;
    }

    @Override
    protected float getSpeedBonus() {
        return 1.0f;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 16, 16, 0);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 16, 16, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 16, 16, 0, elementBudget, env, false, true);
    }

    public IStructureDefinition<TST_EyeOfWood> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               D D               ", "               D D               ", "               D D               ", "            DDDDDDDDD            ", "               D D               ", "            DDDDDDDDD            ", "               D D               ", "               D D               ", "               D D               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               D D               ", "               D D               ", "               D D               ", "               D D               ", "              FFFFF              ", "             FFDFDFF             ", "         DDDDFDDFDDFDDDD         ", "             FFFFFFF             ", "         DDDDFDDFDDFDDDD         ", "             FFDFDFF             ", "              FFFFF              ", "               D D               ", "               D D               ", "               D D               ", "               D D               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               D D               ", "               D D               ", "               D D               ", "                F                ", "                F                ", "             FFFFFFF             ", "            FF     FF            ", "            F  BBB  F            ", "       DDD  F BCCCB F  DDD       ", "          FFF BCCCB FFF          ", "       DDD  F BCCCB F  DDD       ", "            F  BBB  F            ", "            FF     FF            ", "             FFFFFFF             ", "                F                ", "                F                ", "               D D               ", "               D D               ", "               D D               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               D D               ", "               D D               ", "                F                ", "                F                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "      DD                 DD      ", "        FF             FF        ", "      DD                 DD      ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                F                ", "                F                ", "               D D               ", "               D D               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               D D               ", "              DDDDD              ", "                F                ", "                C                ", "                C                ", "                                 ", "                                 ", "                                 ", "                                 ", "      D                   D      ", "     DD                   DD     ", "      DFCC             CCFD      ", "     DD                   DD     ", "      D                   D      ", "                                 ", "                                 ", "                                 ", "                                 ", "                C                ", "                C                ", "                F                ", "              DDDDD              ", "               D D               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "               D D               ", "               D D               ", "                F                ", "             EBBCBBE             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "       E                 E       ", "       B                 B       ", "    DD B                 B DD    ", "      FC                 CF      ", "    DD B                 B DD    ", "       B                 B       ", "       E                 E       ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             EBBCBBE             ", "                F                ", "               D D               ", "               D D               ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "               D D               ", "              DDDDD              ", "                F                ", "                C                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "    D                       D    ", "   DD                       DD   ", "    DFC                   CFD    ", "   DD                       DD   ", "    D                       D    ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                C                ", "                F                ", "              DDDDD              ", "               D D               ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "               D D               ", "               D D               ", "                F                ", "             EBBCBBE             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "     E                     E     ", "     B                     B     ", "  DD B                     B DD  ", "    FC                     CF    ", "  DD B                     B DD  ", "     B                     B     ", "     E                     E     ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             EBBCBBE             ", "                F                ", "               D D               ", "               D D               ", "                                 ", "                                 "}, {"                                 ", "                                 ", "               D D               ", "                F                ", "                C                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", "   FC                       CF   ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                C                ", "                F                ", "               D D               ", "                                 ", "                                 "}, {"                                 ", "               D D               ", "               D D               ", "                F                ", "                C                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " DD                           DD ", "   FC                       CF   ", " DD                           DD ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                C                ", "                F                ", "               D D               ", "               D D               ", "                                 "}, {"                                 ", "               D D               ", "                F                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " D                             D ", "  F                           F  ", " D                             D ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                F                ", "               D D               ", "                                 "}, {"                                 ", "               D D               ", "                F                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " D                             D ", "  F                           F  ", " D                             D ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                F                ", "               D D               ", "                                 "}, {"             DDDDDDD             ", "               D D               ", "             FFFFFFF             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  F                           F  ", "  F                           F  ", "DDF                           FDD", "  F                           F  ", "DDF                           FDD", "  F                           F  ", "  F                           F  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             FFFFFFF             ", "               D D               ", "               D D               "}, {"            DDAAAAADD            ", "              FFFFF              ", "            FF     FF            ", "                                 ", "                                 ", "       E                 E       ", "                                 ", "     E                     E     ", "                                 ", "                                 ", "                                 ", "                                 ", "  F                           F  ", "  F                           F  ", " F                             F ", "DF                             FD", " F                             F ", "DF                             FD", " F                             F ", "  F                           F  ", "  F                           F  ", "                                 ", "                                 ", "                                 ", "                                 ", "     E                     E     ", "                                 ", "       E                 E       ", "                                 ", "                                 ", "            FF     FF            ", "              FFFFF              ", "               D D               "}, {"            DAAAAAAAD            ", "             FFDFDFF             ", "            F  BBB  F            ", "                                 ", "      D                   D      ", "       B                 B       ", "    D                       D    ", "     B                     B     ", "                                 ", "                                 ", "                                 ", "                                 ", "  F                           F  ", " F                             F ", " F                             F ", "DDB                           BDD", " FB                           BF ", "DDB                           BDD", " F                             F ", " F                             F ", "  F                           F  ", "                                 ", "                                 ", "                                 ", "                                 ", "     B                     B     ", "    D                       D    ", "       B                 B       ", "      D                   D      ", "                                 ", "            F  BBB  F            ", "             FFDFDFF             ", "               D D               "}, {"            DAADDDAAD            ", "         DDDDFDDFDDFDDDD         ", "       DDD  F BCCCB F  DDD       ", "      DD                 DD      ", "     DD                   DD     ", "    DD B                 B DD    ", "   DD                       DD   ", "  DD B                     B DD  ", "  D                           D  ", " DD                           DD ", " D                             D ", " D                             D ", "DDF                           FDD", "DF                             FD", "DDB                           BDD", "DDC                           CDD", "DFC                           CFD", "DDC                           CDD", "DDB                           BDD", "DF                             FD", "DDF                           FDD", " D                             D ", " D                             D ", " DD                           DD ", "  D                           D  ", "  DD B                     B DD  ", "   DD                       DD   ", "    DD B                 B DD    ", "     DD                   DD     ", "      DD                 DD      ", "       DDD  F BCCCB F  DDD       ", "         DDDDFDDFDDFDDDD         ", "            DDDDDDDDD            "}, {"            DAAD~DAAD            ", "             FFFFFFF             ", "          FFF BCCCB FFF          ", "        FF             FF        ", "      DFCC             CCFD      ", "      FC                 CF      ", "    DFC                   CFD    ", "    FC                     CF    ", "   FC                       CF   ", "   FC                       CF   ", "  F                           F  ", "  F                           F  ", "  F                           F  ", " F                             F ", " FB                           BF ", "DFC                           CFD", " FC                           CF ", "DFC                           CFD", " FB                           BF ", " F                             F ", "  F                           F  ", "  F                           F  ", "  F                           F  ", "   FC                       CF   ", "   FC                       CF   ", "    FC                     CF    ", "    DFC                   CFD    ", "      FC                 CF      ", "      DFCC             CCFD      ", "        FF             FF        ", "          FFF BCCCB FFF          ", "             FFFFFFF             ", "               D D               "}, {"            DAADDDAAD            ", "         DDDDFDDFDDFDDDD         ", "       DDD  F BCCCB F  DDD       ", "      DD                 DD      ", "     DD                   DD     ", "    DD B                 B DD    ", "   DD                       DD   ", "  DD B                     B DD  ", "  D                           D  ", " DD                           DD ", " D                             D ", " D                             D ", "DDF                           FDD", "DF                             FD", "DDB                           BDD", "DDC                           CDD", "DFC                           CFD", "DDC                           CDD", "DDB                           BDD", "DF                             FD", "DDF                           FDD", " D                             D ", " D                             D ", " DD                           DD ", "  D                           D  ", "  DD B                     B DD  ", "   DD                       DD   ", "    DD B                 B DD    ", "     DD                   DD     ", "      DD                 DD      ", "       DDD  F BCCCB F  DDD       ", "         DDDDFDDFDDFDDDD         ", "            DDDDDDDDD            "}, {"            DAAAAAAAD            ", "             FFDFDFF             ", "            F  BBB  F            ", "                                 ", "      D                   D      ", "       B                 B       ", "    D                       D    ", "     B                     B     ", "                                 ", "                                 ", "                                 ", "                                 ", "  F                           F  ", " F                             F ", " F                             F ", "DDB                           BDD", " FB                           BF ", "DDB                           BDD", " F                             F ", " F                             F ", "  F                           F  ", "                                 ", "                                 ", "                                 ", "                                 ", "     B                     B     ", "    D                       D    ", "       B                 B       ", "      D                   D      ", "                                 ", "            F  BBB  F            ", "             FFDFDFF             ", "               D D               "}, {"            DDAAAAADD            ", "              FFFFF              ", "            FF     FF            ", "                                 ", "                                 ", "       E                 E       ", "                                 ", "     E                     E     ", "                                 ", "                                 ", "                                 ", "                                 ", "  F                           F  ", "  F                           F  ", " F                             F ", "DF                             FD", " F                             F ", "DF                             FD", " F                             F ", "  F                           F  ", "  F                           F  ", "                                 ", "                                 ", "                                 ", "                                 ", "     E                     E     ", "                                 ", "       E                 E       ", "                                 ", "                                 ", "            FF     FF            ", "              FFFFF              ", "               D D               "}, {"             DDDDDDD             ", "               D D               ", "             FFFFFFF             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  F                           F  ", "  F                           F  ", "DDF                           FDD", "  F                           F  ", "DDF                           FDD", "  F                           F  ", "  F                           F  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             FFFFFFF             ", "               D D               ", "               D D               "}, {"                                 ", "               D D               ", "                F                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " D                             D ", "  F                           F  ", " D                             D ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                F                ", "               D D               ", "                                 "}, {"                                 ", "               D D               ", "                F                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " D                             D ", "  F                           F  ", " D                             D ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                F                ", "               D D               ", "                                 "}, {"                                 ", "               D D               ", "               D D               ", "                F                ", "                C                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " DD                           DD ", "   FC                       CF   ", " DD                           DD ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                C                ", "                F                ", "               D D               ", "               D D               ", "                                 "}, {"                                 ", "                                 ", "               D D               ", "                F                ", "                C                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  D                           D  ", "   FC                       CF   ", "  D                           D  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                C                ", "                F                ", "               D D               ", "                                 ", "                                 "}, {"                                 ", "                                 ", "               D D               ", "               D D               ", "                F                ", "             EBBCBBE             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "     E                     E     ", "     B                     B     ", "  DD B                     B DD  ", "    FC                     CF    ", "  DD B                     B DD  ", "     B                     B     ", "     E                     E     ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             EBBCBBE             ", "                F                ", "               D D               ", "               D D               ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "               D D               ", "              DDDDD              ", "                F                ", "                C                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "    D                       D    ", "   DD                       DD   ", "    DFC                   CFD    ", "   DD                       DD   ", "    D                       D    ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                C                ", "                F                ", "              DDDDD              ", "               D D               ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "               D D               ", "               D D               ", "                F                ", "             EBBCBBE             ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "       E                 E       ", "       B                 B       ", "    DD B                 B DD    ", "      FC                 CF      ", "    DD B                 B DD    ", "       B                 B       ", "       E                 E       ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "             EBBCBBE             ", "                F                ", "               D D               ", "               D D               ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               D D               ", "              DDDDD              ", "                F                ", "                C                ", "                C                ", "                                 ", "                                 ", "                                 ", "                                 ", "      D                   D      ", "     DD                   DD     ", "      DFCC             CCFD      ", "     DD                   DD     ", "      D                   D      ", "                                 ", "                                 ", "                                 ", "                                 ", "                C                ", "                C                ", "                F                ", "              DDDDD              ", "               D D               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               D D               ", "               D D               ", "                F                ", "                F                ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "      DD                 DD      ", "        FF             FF        ", "      DD                 DD      ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                F                ", "                F                ", "               D D               ", "               D D               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               D D               ", "               D D               ", "               D D               ", "                F                ", "                F                ", "             FFFFFFF             ", "            FF     FF            ", "            F  BBB  F            ", "       DDD  F BCCCB F  DDD       ", "          FFF BCCCB FFF          ", "       DDD  F BCCCB F  DDD       ", "            F  BBB  F            ", "            FF     FF            ", "             FFFFFFF             ", "                F                ", "                F                ", "               D D               ", "               D D               ", "               D D               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               D D               ", "               D D               ", "               D D               ", "               D D               ", "              FFFFF              ", "             FFDFDFF             ", "         DDDDFDDFDDFDDDD         ", "             FFFFFFF             ", "         DDDDFDDFDDFDDDD         ", "             FFDFDFF             ", "              FFFFF              ", "               D D               ", "               D D               ", "               D D               ", "               D D               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}, {"                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "               D D               ", "               D D               ", "               D D               ", "            DDDDDDDDD            ", "               D D               ", "            DDDDDDDDD            ", "               D D               ", "               D D               ", "               D D               ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 "}})).addElement('A', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.OutputHatch}).adder(GTCM_MultiMachineBase::addToMachineList).dot(1).casingIndex(10).buildAndChain(GregTechAPI.sBlockCasings1, 10)).addElement('B', StructureUtility.ofBlock((Block)Blocks.field_150368_y, (int)0)).addElement('C', StructureUtility.ofBlock((Block)Blocks.field_150342_X, (int)0)).addElement('D', StructureUtility.ofBlock((Block)Blocks.field_150336_V, (int)0)).addElement('E', StructureUtility.ofBlock((Block)Blocks.field_150417_aV, (int)3)).addElement('F', StructureUtility.ofBlockAnyMeta((Block)Blocks.field_150344_f)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean supportsVoidProtection() {
        return false;
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public boolean supportsInputSeparation() {
        return false;
    }

    protected boolean supportsCraftingMEBuffer() {
        return false;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        if (tt == null) {
            tt = new MultiblockTooltipBuilder();
            tt.addMachineType(TextLocalization.Tooltip_EyeOfWood_MachineType).addInfo(TextLocalization.Tooltip_EyeOfWood_Controller).addInfo(TextLocalization.Tooltip_EyeOfWood_01).addInfo(TextEnums.tr("Tooltip_EyeOfWood_02")).addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addSeparator().addStructureInfo(TextEnums.tr("Tooltip_EyeOfWood_2_01")).addStructureInfo(TextEnums.tr("Tooltip_EyeOfWood_2_02")).addStructureInfo(TextEnums.tr("Tooltip_EyeOfWood_2_03")).addStructureInfo(TextLocalization.Text_SeparatingLine).addStructureInfo(TextEnums.tr("Tooltip_EyeOfWood_2_04")).addStructureInfo(TextEnums.tr("Tooltip_EyeOfWood_2_05")).addStructureInfo(TextEnums.tr("Tooltip_EyeOfWood_2_06")).addStructureInfo(TextEnums.tr("Tooltip_EyeOfWood_2_07")).addStructureInfo(TextEnums.tr("Tooltip_EyeOfWood_2_08")).addStructureInfo(TextLocalization.Text_SeparatingLine).addStructureInfo(TextEnums.tr("Tooltip_EyeOfWood_2_09")).addStructureInfo(TextEnums.tr("Tooltip_EyeOfWood_2_10")).addStructureInfo(TextEnums.tr("Tooltip_EyeOfWood_2_11")).addStructureInfo(TextEnums.tr("Tooltip_EyeOfWood_2_12")).addStructureInfo(TextLocalization.Text_SeparatingLine).beginStructureBlock(33, 33, 33, false).addController(TextLocalization.textFrontCenter).addInputBus(TextLocalization.textAnyCasing, new int[]{2}).addOutputBus(TextLocalization.textAnyCasing, new int[]{2}).toolTipFinisher(new String[]{"Twist Space Technology"});
        }
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)10), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_DTPF_ON).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FUSION1_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)10), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_DTPF_OFF).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)10)};
    }

    static {
        STANDARD_WATER_BUCKET = ValueEnum.StandardWaterNeed_EyeOfWood;
        STANDARD_WATER_AMOUNT = STANDARD_WATER_BUCKET * 1000;
        STANDARD_LAVA_BUCKET = ValueEnum.StandardLavaNeed_EyeOfWood;
        STANDARD_LAVA_AMOUNT = STANDARD_LAVA_BUCKET * 1000;
        STANDARD_DIMENSION_ID = ValueEnum.StandardDimensionID_EyeOfWood;
        ALLOW_PERSONAL_SPACE = Config.AllowPersonalSpace_EyeOfWood;
        STANDARD_SUBSTRATE = Math.pow(2.0E9, 1.0 / (double)Math.max(STANDARD_WATER_BUCKET, STANDARD_LAVA_BUCKET));
        STRUCTURE_DEFINITION = null;
        tt = null;
    }
}

