/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import bartworks.API.BorosilicateGlass;
import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.common.configs.Configuration;
import bartworks.common.tileentities.tiered.MTERadioHatch;
import bartworks.util.BWUtil;
import bartworks.util.MathUtils;
import bartworks.util.ResultWrongSievert;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.processingLogics.TstProcessingLogic;
import com.Nxer.TwistSpaceTechnology.common.misc.OverclockType;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstSharedLocalization;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.ParallelHelper;
import gregtech.api.util.recipe.Sievert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TST_BiosphereIII
extends GTCM_MultiMachineBase<TST_BiosphereIII> {
    private byte mGlassTier = 0;
    private int mNeededGlassTier = 0;
    private int mSievert = 0;
    private int mNeededSievert = 0;
    private int efficiency = 1;
    private ArrayList<MTERadioHatch> mRadHatches = new ArrayList();
    private static final Sievert DEFAULT_SIEVERT = new Sievert(0, false);
    private final int horizontalOffSet = 8;
    private final int verticalOffSet = 17;
    private final int depthOffSet = 1;
    private final String STRUCTURE_PIECE_MAIN = "mainBiosphereIII";
    private final String[][] shapeMain = new String[][]{{"                 ", "                 ", "                 ", "                 ", "                 ", "EEEEEEEEEEEEEEEEE", "EJJJJJJJJJJJJJJJE", "EEEEEEEEEEEEEEEEE", "                 ", "                 ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "                 ", "                 ", "EJJJJJJJJJJJJJJJE", "JBBBBBBBBBBBBBBBJ", "EJJJJJJJJJJJJJJJE", "                 ", "                 ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "                 ", "                 ", "EJ             JE", "JBJJJJJ B JJJJJBJ", "EJ             JE", "                 ", "                 ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "                 ", "                 ", "EJ     CCC     JE", "JBJ    CBC    JBJ", "EJ     CCC     JE", "                 ", "                 ", "                 ", "                 ", "                 "}, {"                 ", "                 ", "                 ", "       CCC       ", "      CCCCC      ", "EJ   CCCCCCC   JE", "JBJ  CCCBCCC  JBJ", "EJ   CCCCCCC   JE", "      CCCCC      ", "       CCC       ", "                 ", "                 ", "                 "}, {"                 ", "       CCC       ", "     CCDDDCC     ", "    CDDDDDDDC    ", "    CDDDDDDDC    ", "EJ CDDDDDDDDDC JE", "JBJCDDDDBDDDDCJBJ", "EJ CDDDDDDDDDC JE", "    CDDDDDDDC    ", "    CDDDDDDDC    ", "     CCDDDCC     ", "       CCC       ", "                 "}, {"                 ", "       AAA       ", "     CAIIIAC     ", "    CIIIIIIIC    ", "    AIIICIIIA    ", "EJ AIIICCCIIIA JE", "JB AIICCBCCIIA BJ", "EJ AIIICCCIIIA JE", "    AIIICIIIA    ", "    CIIIIIIIC    ", "     CAIIIAC     ", "       AAA       ", "                 "}, {"                 ", "       AAA       ", "     CAIIIAC     ", "    CIIIIIIIC    ", "    AIIIIIIIA    ", "EJ AIIIICIIIIA JE", "JB AIIICBCIIIA BJ", "EJ AIIIICIIIIA JE", "    AIIIIIIIA    ", "    CIIIIIIIC    ", "     CAIIIAC     ", "       AAA       ", "                 "}, {"                 ", "       AAA       ", "     CAIIIAC     ", "    CIIIIIIIC    ", "    AIIIIIIIA    ", "EJ AIIIIIIIIIA JE", "JB AIIIIBIIIIA BJ", "EJ AIIIIIIIIIA JE", "    AIIIIIIIA    ", "    CIIIIIIIC    ", "     CAIIIAC     ", "       AAA       ", "                 "}, {"                 ", "       AAA       ", "     CAIIIAC     ", "    CIIICIIIC    ", "    AIIICIIIA    ", "EJ AIIIICIIIIA JE", "JBBBBCCCBCCCBBBBJ", "EJ AIIIICIIIIA JE", "    AIIICIIIA    ", "    CIIICIIIC    ", "     CAIIIAC     ", "       AAA       ", "                 "}, {"                 ", "       AAA       ", "     CAIIIAC     ", "    CIIICIIIC    ", "    AIIICIIIA    ", "EJ AIIIICIIIIA JE", "JB AICCCBCCCIA BJ", "EJ AIIIICIIIIA JE", "    AIIICIIIA    ", "    CIIICIIIC    ", "     CAIIIAC     ", "       AAA       ", "                 "}, {"                 ", "       AAA       ", "     CAIIIAC     ", "    CIIICIIIC    ", "    AIIICIIIA    ", "EJ AIIIICIIIIA JE", "JBBBBCCCBCCCBBBBJ", "EJ AIIIICIIIIA JE", "    AIIICIIIA    ", "    CIIICIIIC    ", "     CAIIIAC     ", "       AAA       ", "                 "}, {"                 ", "       AAA       ", "     CAIIIAC     ", "    CIIICIIIC    ", "    AIIICIIIA    ", "EJ AIIIICIIIIA JE", "JB AICCCBCCCIA BJ", "EJ AIIIICIIIIA JE", "    AIIICIIIA    ", "    CIIICIIIC    ", "     CAIIIAC     ", "       AAA       ", "                 "}, {"                 ", "       AAA       ", "     CAIIIAC     ", "    CIIICIIIC    ", "    AIIICIIIA    ", "EJ AIIIICIIIIA JE", "JBBBBCCCBCCCBBBBJ", "EJ AIIIICIIIIA JE", "    AIIICIIIA    ", "    CIIICIIIC    ", "     CAIIIAC     ", "       AAA       ", "                 "}, {"                 ", "       AAA       ", "     CAIIIAC     ", "    CIIIIIIIC    ", "    AIIIIIIIA    ", "EJ AIIIIIIIIIA JE", "JB AIIIIBIIIIA BJ", "EJ AIIIIIIIIIA JE", "    AIIIIIIIA    ", "    CIIIIIIIC    ", "     CAIIIAC     ", "       AAA       ", "                 "}, {"                 ", "       AAA       ", "     CAIIIAC     ", "    CIIIIIIIC    ", "    AIIIIIIIA    ", "EJ AIIIICIIIIA JE", "JB AIIICBCIIIA BJ", "EJ AIIIICIIIIA JE", "    AIIIIIIIA    ", "    CIIIIIIIC    ", "     CAIIIAC     ", "       AAA       ", "                 "}, {"                 ", "       AAA       ", "     CAIIIAC     ", "    CIIIIIIIC    ", "    AIIICIIIA    ", "EJ AIIICCCIIIA JE", "JB AIICCBCCIIA BJ", "EJ AIIICCCIIIA JE", "    AIIICIIIA    ", "    CIIIIIIIC    ", "     CAIIIAC     ", "       AAA       ", "                 "}, {"                 ", "       H~H       ", "     HHDDDHH     ", "    HDDDDDDDH    ", "    HDDDDDDDH    ", "EJ HDDDDDDDDDH JE", "JBBBBBBBBBBBBBBBJ", "EJ HDDDDDDDDDH JE", "    HDDDDDDDH    ", "    HDDDDDDDH    ", "     HHDDDHH     ", "       HHH       ", "                 "}, {"FFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFF"}};
    private static final int STAINLESS_STEEL_CASING_INDEX = 49;
    private static IStructureDefinition<TST_BiosphereIII> STRUCTURE_DEFINITION = null;

    public TST_BiosphereIII(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_BiosphereIII(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_BiosphereIII(this.mName);
    }

    @Override
    public int totalMachineMode() {
        return 4;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_SIMPLEWASHER);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_WASHPLANT);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_PACKAGER);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_LPF_FLUID);
    }

    @Override
    public String getMachineModeName(int mode) {
        String string;
        switch (mode) {
            case 0: {
                string = TextLocalization.BiosphereIII_Mode_00;
                break;
            }
            case 1: {
                string = TextLocalization.BiosphereIII_Mode_01;
                break;
            }
            case 2: {
                string = TextLocalization.BiosphereIII_Mode_02;
                break;
            }
            default: {
                string = TextLocalization.BiosphereIII_Mode_03;
            }
        }
        return string;
    }

    public RecipeMap<?> getRecipeMap() {
        RecipeMap recipeMap;
        switch (this.machineMode) {
            case 0: 
            case 1: {
                recipeMap = BartWorksRecipeMaps.bacterialVatRecipes;
                break;
            }
            case 2: {
                recipeMap = RecipeMaps.brewingRecipes;
                break;
            }
            default: {
                recipeMap = RecipeMaps.fermentingRecipes;
            }
        }
        return recipeMap;
    }

    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(BartWorksRecipeMaps.bacterialVatRecipes, RecipeMaps.brewingRecipes, RecipeMaps.fermentingRecipes);
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return false;
    }

    @Override
    protected float getSpeedBonus() {
        float f;
        switch (this.machineMode) {
            case 0: {
                f = 0.5f;
                break;
            }
            case 1: {
                f = 1.0f;
                break;
            }
            default: {
                f = 0.25f;
            }
        }
        return f;
    }

    @Override
    public int getMaxParallelRecipes() {
        int n;
        switch (this.machineMode) {
            case 0: {
                if (this.getControllerSlot() == null) {
                    n = 0;
                    break;
                }
                n = this.getControllerSlot().field_77994_a * 4;
                break;
            }
            case 1: {
                if (this.getControllerSlot() == null) {
                    n = 0;
                    break;
                }
                n = this.getControllerSlot().field_77994_a;
                break;
            }
            default: {
                n = 1 << Math.max(this.mGlassTier * 2 - 6, 0);
            }
        }
        return n;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new TstProcessingLogic(){

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (TST_BiosphereIII.this.machineMode == 2 || TST_BiosphereIII.this.machineMode == 3) {
                    return CheckRecipeResultRegistry.SUCCESSFUL;
                }
                if (!BWUtil.areStacksEqualOrNull((ItemStack)((ItemStack)recipe.mSpecialItems), (ItemStack)TST_BiosphereIII.this.getControllerSlot())) {
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                Sievert data = (Sievert)recipe.getMetadataOrDefault(GTRecipeConstants.SIEVERT, (Object)DEFAULT_SIEVERT);
                boolean checkSievertExact = data.isExact;
                TST_BiosphereIII.this.mNeededSievert = data.sievert;
                TST_BiosphereIII.this.mNeededGlassTier = (Integer)recipe.getMetadataOrDefault(GTRecipeConstants.GLASS, (Object)0);
                if (TST_BiosphereIII.this.mGlassTier < TST_BiosphereIII.this.mNeededGlassTier) {
                    return CheckRecipeResultRegistry.insufficientMachineTier((int)TST_BiosphereIII.this.mNeededGlassTier);
                }
                if (!checkSievertExact) {
                    if (TST_BiosphereIII.this.mSievert < TST_BiosphereIII.this.mNeededSievert) {
                        return ResultWrongSievert.insufficientSievert((int)TST_BiosphereIII.this.mNeededSievert);
                    }
                } else if (TST_BiosphereIII.this.mSievert != TST_BiosphereIII.this.mNeededSievert) {
                    return ResultWrongSievert.wrongSievert((int)TST_BiosphereIII.this.mNeededSievert);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected ParallelHelper createParallelHelper(@NotNull GTRecipe recipe) {
                return super.createParallelHelper(TST_BiosphereIII.this.recipeAfterEfficiencyCalculation(recipe, this.inputFluids));
            }

            @NotNull
            public CheckRecipeResult process() {
                this.setEuModifier(TST_BiosphereIII.this.getEuModifier());
                this.setSpeedBonus(TST_BiosphereIII.this.getSpeedBonus());
                this.setOverclockType(TST_BiosphereIII.this.isEnablePerfectOverclock() ? OverclockType.PerfectOverclock : OverclockType.NormalOverclock);
                return super.process();
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        logic.setSpecialSlotItem(this.getControllerSlot());
    }

    private GTRecipe recipeAfterEfficiencyCalculation(GTRecipe recipe, FluidStack[] inputFluids) {
        if (this.machineMode == 2 || this.machineMode == 3) {
            return recipe;
        }
        GTRecipe tRecipe = recipe.copy();
        this.efficiency = this.machineMode == 0 ? this.getExpectedMultiplier(tRecipe.mFluidOutputs[0]) : (int)(((double)((this.mGlassTier - this.mNeededGlassTier) * 600) + 1601.0) / 1000.0 * (double)Configuration.Multiblocks.bioVatMaxParallelBonus);
        long fluidAmount = 0L;
        for (FluidStack fluid : inputFluids) {
            if (!fluid.isFluidEqual(recipe.mFluidInputs[0])) continue;
            fluidAmount += (long)fluid.amount;
        }
        this.efficiency = (int)Math.min((long)this.efficiency, fluidAmount / (long)recipe.mFluidInputs[0].amount);
        this.efficiency = Math.max(this.efficiency, 1);
        tRecipe.mFluidInputs[0].amount *= this.efficiency;
        tRecipe.mFluidOutputs[0].amount *= this.efficiency;
        return tRecipe;
    }

    private int getExpectedMultiplier(@Nullable FluidStack recipeFluidOutput) {
        FluidStack storedFluidOutputs = this.getStoredFluidOutputs();
        if (storedFluidOutputs == null) {
            return 1;
        }
        if (storedFluidOutputs.isFluidEqual(recipeFluidOutput)) {
            return this.calcMod(storedFluidOutputs.amount) + 1;
        }
        return 1;
    }

    private int calcMod(double x) {
        double y = (double)this.getOutputCapacity() / 2.0;
        double z = Configuration.Multiblocks.bioVatMaxParallelBonus;
        int ret = (int)Math.ceil((-1.0 / y * Math.pow(x - y, 2.0) + y) / y * z);
        return MathUtils.clamp((int)1, (int)ret, (int)Configuration.Multiblocks.bioVatMaxParallelBonus);
    }

    private int getOutputCapacity() {
        return ((MTEHatchOutput)this.mOutputHatches.get(0)).getCapacity();
    }

    private FluidStack getStoredFluidOutputs() {
        return ((MTEHatchOutput)this.mOutputHatches.get(0)).getFluid();
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.mRadHatches.clear();
        this.mGlassTier = 0;
        if (!this.checkPiece("mainBiosphereIII", 8, 17, 1)) {
            return false;
        }
        if (this.mGlassTier <= 0) {
            return false;
        }
        return this.mRadHatches.size() <= 1 || this.mOutputHatches.size() <= 1;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide() && this.mRadHatches.size() == 1) {
            this.mSievert = this.mRadHatches.get(0).getSievert();
            if (this.getBaseMetaTileEntity().isActive() && this.mNeededSievert > this.mSievert) {
                this.mOutputFluids = null;
            }
        }
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("mainBiosphereIII", stackSize, hintsOnly, 8, 17, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece("mainBiosphereIII", stackSize, 8, 17, 1, elementBudget, env, false, true);
    }

    public IStructureDefinition<TST_BiosphereIII> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("mainBiosphereIII", StructureUtility.transpose((String[][])this.shapeMain)).addElement('A', StructureUtility.withChannel((String)"glass", (IStructureElement)BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
                te.mGlassTier = t;
            }, te -> te.mGlassTier))).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)15)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)0)).addElement('E', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)6)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)5)).addElement('H', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(TST_BiosphereIII::addRadiationInputToMachineList, (int)49, (int)1), HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.OutputHatch, HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy)}).adder(GTCM_MultiMachineBase::addToMachineList).dot(1).casingIndex(49).buildAndChain(GregTechAPI.sBlockCasings4, 1)})).addElement('I', StructureUtility.isAir()).addElement('J', GTStructureUtility.ofFrame((Materials)Materials.Osmiridium)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    private boolean addRadiationInputToMachineList(IGregTechTileEntity aTileEntity, int CasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!(aMetaTileEntity instanceof MTERadioHatch)) {
            return false;
        }
        ((MTERadioHatch)aMetaTileEntity).updateTexture(CasingIndex);
        return this.mRadHatches.add((MTERadioHatch)aMetaTileEntity);
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextLocalization.Tooltip_BiosphereIII_MachineType).addInfo(TextLocalization.Tooltip_BiosphereIII_Controller).addInfo(TextLocalization.Tooltip_BiosphereIII_00).addInfo(TextLocalization.textScrewdriverChangeMode).addInfo(TextLocalization.BiosphereIII_Mode_00).addInfo(TextLocalization.Tooltip_BiosphereIII_Mode0_00).addInfo(TextLocalization.Tooltip_BiosphereIII_Mode0_01).addInfo(TextLocalization.Tooltip_BiosphereIII_Mode0_02).addInfo(TextLocalization.BiosphereIII_Mode_01).addInfo(TextLocalization.Tooltip_BiosphereIII_Mode1_00).addInfo(TextLocalization.Tooltip_BiosphereIII_Mode1_01).addInfo(TextLocalization.Tooltip_BiosphereIII_Mode1_02).addInfo(TextLocalization.Tooltip_BiosphereIII_Mode1_03).addInfo(TextLocalization.BiosphereIII_Mode_02).addInfo(TextLocalization.Tooltip_BiosphereIII_Mode2n3_00).addInfo(TextLocalization.Tooltip_BiosphereIII_Mode2n3_01).addInfo(TextLocalization.Tooltip_BiosphereIII_Mode2n3_02).addInfo(TextLocalization.BiosphereIII_Mode_03).addInfo(TextLocalization.Tooltip_BiosphereIII_Mode2n3_00).addInfo(TextLocalization.Tooltip_BiosphereIII_Mode2n3_01).addInfo(TextLocalization.Tooltip_BiosphereIII_Mode2n3_02).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).beginStructureBlock(13, 19, 17, false).addController(TextLocalization.textFrontBottom).addInputHatch(TextLocalization.textBiosphereIIIHatchLocation, new int[]{1}).addOutputHatch(TextLocalization.textBiosphereIIIHatchLocation, new int[]{1}).addInputBus(TextLocalization.textBiosphereIIIHatchLocation, new int[]{1}).addOutputBus(TextLocalization.textBiosphereIIIHatchLocation, new int[]{1}).addEnergyHatch(TextLocalization.textBiosphereIIIHatchLocation, new int[]{1}).addStructureInfo(TextLocalization.textBiosphereIIIRadioHatch + ", " + TextLocalization.textBiosphereIIIHatchLocation).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49)};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mSievert", this.mSievert);
        aNBT.func_74768_a("mNeededSievert", this.mNeededSievert);
        aNBT.func_74774_a("mode", (byte)this.machineMode);
        aNBT.func_74768_a("efficiency", this.efficiency);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mSievert = aNBT.func_74762_e("mSievert");
        this.mNeededSievert = aNBT.func_74762_e("mNeededSievert");
        this.machineMode = aNBT.func_74771_c("mode");
        this.efficiency = aNBT.func_74762_e("efficiency");
        super.loadNBTData(aNBT);
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public String[] getInfoData() {
        String[] origin = super.getInfoData();
        String[] ret = new String[origin.length + 3];
        System.arraycopy(origin, 0, ret, 0, origin.length);
        ret[origin.length] = TstSharedLocalization.MachineInfo.glassTier(this.mGlassTier);
        ret[origin.length + 1] = EnumChatFormatting.BLUE + this.getMachineModeName(this.machineMode);
        ret[origin.length + 2] = TextLocalization.BiosphereIIIEfficiency + (this.machineMode == 2 || this.machineMode == 3 ? EnumChatFormatting.GREEN + "100" + EnumChatFormatting.RESET + "%" : EnumChatFormatting.GREEN + GTUtility.formatNumbers((long)this.efficiency) + EnumChatFormatting.RESET + "x");
        return ret;
    }
}

