/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.GeneratorMultis;

import com.Nxer.TwistSpaceTechnology.client.texture.TstMachineTextures;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.maps.FuelBackend;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings1;
import gtPlusPlus.core.block.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class TST_UniversalGenerator
extends GTCM_MultiMachineBase<TST_UniversalGenerator> {
    private int mCasing = 0;
    private int mSetTier = 1;
    private double fuelBurning;
    private long DYNAMO_AMP;
    private long DYNAMO_TIER;
    private long euPerTick;
    private String fuelName = "";
    private static final String STRUCTURE_PIECE_GAS = "mainGas";
    private static final String STRUCTURE_PIECE_FUEL = "mainFuel";
    private final int horizontalOffSetGas = 4;
    private final int verticalOffSetGas = 3;
    private final int depthOffSetGas = 0;
    private final int horizontalOffSetFuel = 2;
    private final int verticalOffSetFuel = 5;
    private final int depthOffSetFuel = 0;
    private final int mainTextureID = ((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(11);
    private static IStructureDefinition<TST_UniversalGenerator> STRUCTURE_DEFINITION = null;
    private final String[][] shapeGas = new String[][]{{"         ", "         ", "         ", "         ", "         ", "D   A   D", "DAAAAAAAD", "DAAAAAAAD", "DAAAAAAAD", "D   A   D"}, {"         ", "    D    ", "         ", "         ", "         ", "DAFFAFFAD", "A       A", "AE   E  A", "A       A", "DAFFAFFAD"}, {"    D    ", "   DAD   ", "    D    ", "         ", "         ", "DAFFAFFAD", "A   E   A", "ACCCCCCCA", "A E   E A", "DAFFAFFAD"}, {"   D~D   ", "   ABA   ", "   DAD   ", "         ", "         ", "DAFFAFFAD", "A       A", "A  E   EA", "A       A", "DAFFAFFAD"}, {"   DAD   ", "   AAA   ", "   DAD   ", "         ", "         ", "D   A   D", " AAAAAAA ", " AAAAAAA ", " AAAAAAA ", "D   A   D"}};
    private final String[][] shapeFuel = new String[][]{{"     ", "     ", "     ", "     ", "     ", "  D  ", " AAA ", "DAAAD", " AAA ", "  D  "}, {"     ", "     ", "     ", "     ", "     ", "DAAAD", "A   A", "A CEA", "A   A", "DAAAD"}, {"     ", "     ", "     ", "     ", "     ", "DFFFD", "F   F", "F C F", "F E F", "DFFFD"}, {"     ", "  D  ", "     ", "     ", "     ", "DFFFD", "F   F", "FEC F", "F   F", "DFFFD"}, {"  D  ", " DAD ", "  D  ", "     ", "     ", "DFFFD", "F E F", "F C F", "F   F", "DFFFD"}, {" D~D ", " ABA ", " DAD ", "     ", "     ", "DFFFD", "F   F", "F CEF", "F   F", "DFFFD"}, {" DAD ", " AAA ", " DAD ", "     ", "     ", "DAAAD", "AAAAA", "AAAAA", "AAAAA", "DAAAD"}};

    public TST_UniversalGenerator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public TST_UniversalGenerator(String aName) {
        super(aName);
    }

    public RecipeMap<FuelBackend> getRecipeMap() {
        if (this.mSetTier == 2) {
            return RecipeMaps.dieselFuels;
        }
        return RecipeMaps.gasTurbineFuels;
    }

    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.gasTurbineFuels, RecipeMaps.dieselFuels);
    }

    protected boolean filtersFluid() {
        return false;
    }

    public void clearHatches() {
        super.clearHatches();
        this.mSetTier = 0;
        this.mCasing = 0;
    }

    @Override
    @Nonnull
    public CheckRecipeResult checkProcessing() {
        ArrayList tFluids = this.getStoredFluids();
        if (!tFluids.isEmpty()) {
            for (FluidStack tFluid : tFluids) {
                GTRecipe tRecipe = ((FuelBackend)this.getRecipeMap().getBackend()).findFuel(tFluid);
                if (tRecipe == null) continue;
                int fuelValue = tRecipe.mSpecialValue * 1000;
                this.euPerTick = this.DYNAMO_TIER * this.DYNAMO_AMP;
                this.fuelBurning = (double)fuelValue / (double)(this.euPerTick * 20L);
                this.fuelName = tFluid.getLocalizedName();
                FluidStack consumeFluid = tFluid.copy();
                consumeFluid.amount = 1000;
                if (tFluid.amount < 1000 || !this.depleteInput(consumeFluid)) continue;
                this.mMaxProgresstime = (int)(this.fuelBurning * 20.0);
                this.mEfficiency = this.getMaxEfficiency(null);
                this.lEUt = this.euPerTick;
                return CheckRecipeResultRegistry.GENERATING;
            }
        }
        this.lEUt = 0L;
        this.mEfficiency = 0;
        this.mProgresstime = 0;
        return CheckRecipeResultRegistry.NO_FUEL_FOUND;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        Object[][] pieces;
        for (Object[] piece : pieces = new Object[][]{{STRUCTURE_PIECE_GAS, 4, 3, 0, 1}, {STRUCTURE_PIECE_FUEL, 2, 5, 0, 2}}) {
            this.clearHatches();
            if (!this.checkPiece((String)piece[0], (Integer)piece[1], (Integer)piece[2], (Integer)piece[3])) continue;
            this.mSetTier = (Integer)piece[4];
            break;
        }
        if (this.mSetTier == 0) {
            return false;
        }
        this.DYNAMO_AMP = this.getDynamoAmperage();
        this.DYNAMO_TIER = this.getTierDynamo();
        return this.mCasing >= 45 && this.checkCountDynamo(2) && !this.checkMixedDynamo() && this.setDynamoTier(3, false);
    }

    public void construct(ItemStack itemStack, boolean b) {
        if (itemStack.field_77994_a == 1) {
            this.buildPiece(STRUCTURE_PIECE_GAS, itemStack, b, 4, 3, 0);
        } else {
            this.buildPiece(STRUCTURE_PIECE_FUEL, itemStack, b, 2, 5, 0);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = 0;
        if (stackSize.field_77994_a == 1) {
            this.mSetTier = 1;
            built += this.survivalBuildPiece(STRUCTURE_PIECE_GAS, stackSize, 4, 3, 0, elementBudget, env, false, true);
        } else {
            this.mSetTier = 2;
            built += this.survivalBuildPiece(STRUCTURE_PIECE_FUEL, stackSize, 2, 5, 0, elementBudget, env, false, true);
        }
        return built;
    }

    public IStructureDefinition<TST_UniversalGenerator> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_GAS, StructureUtility.transpose((String[][])this.shapeGas)).addShape(STRUCTURE_PIECE_FUEL, StructureUtility.transpose((String[][])this.shapeFuel)).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(TST_UniversalGenerator.class).atLeast(new IHatchElement[]{HatchElement.Dynamo}).casingIndex(this.mainTextureID).dot(1).build(), GTStructureUtility.buildHatchAdder(TST_UniversalGenerator.class).atLeast(new IHatchElement[]{HatchElement.InputHatch}).casingIndex(this.mainTextureID).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)11))})).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)3)).addElement('C', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)2)).addElement('D', GTStructureUtility.ofFrame((Materials)Materials.Steel)).addElement('E', StructureUtility.ofBlock((Block)GregTechAPI.sBlockMetal6, (int)13)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockTintedGlass, (int)0)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextLocalization.Tooltip_UniversalGenerator_MachineType).addInfo(TextLocalization.Tooltip_UniversalGenerator_00).addInfo(TextLocalization.Tooltip_UniversalGenerator_01).addInfo(TextLocalization.Tooltip_UniversalGenerator_02).addInfo(TextLocalization.Tooltip_UniversalGenerator_03).addInfo(TextEnums.Author_EvgenWarGold.getText()).addInputHatch(TextLocalization.textUseBlueprint, new int[]{1}).addDynamoHatch(TextLocalization.textUseBlueprint, new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    @Override
    public boolean supportsVoidProtection() {
        return false;
    }

    @Override
    public boolean supportsInputSeparation() {
        return false;
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TST_UniversalGenerator(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.mainTextureID), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.mainTextureID), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)TstMachineTextures.OVERLAY_FRONT_PROCESSING_ARRAY_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.mainTextureID)};
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)((Column)((Column)((Column)((Column)screenElements.widget(new TextWidget().setStringSupplier(() -> EnumChatFormatting.WHITE + TextEnums.tr("TST_UniversalGenerator.gui.01") + " " + EnumChatFormatting.GOLD + (this.mSetTier == 2 ? TextEnums.tr("TST_UniversalGenerator.gui.03") : TextEnums.tr("TST_UniversalGenerator.gui.02")) + EnumChatFormatting.RESET).setEnabled(this.mSetTier != 0))).widget(new TextWidget().setStringSupplier(() -> EnumChatFormatting.WHITE + TextEnums.tr("TST_UniversalGenerator.gui.04") + " " + EnumChatFormatting.GOLD + this.fuelName + EnumChatFormatting.RESET).setEnabled(!Objects.equals(this.fuelName, "")))).widget(new TextWidget().setStringSupplier(() -> EnumChatFormatting.WHITE + TextEnums.tr("TST_UniversalGenerator.gui.05") + " " + EnumChatFormatting.GOLD + this.numberFormat.format(this.euPerTick) + EnumChatFormatting.RESET).setEnabled(this.euPerTick != 0L))).widget(new TextWidget().setStringSupplier(() -> EnumChatFormatting.WHITE + TextEnums.tr("TST_UniversalGenerator.gui.06") + " " + EnumChatFormatting.GOLD + this.numberFormat.format(this.fuelBurning) + EnumChatFormatting.WHITE + TextEnums.tr("TST_SteamBasicGenerator.gui.02") + EnumChatFormatting.RESET).setEnabled(this.fuelBurning != 0.0))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.euPerTick, val -> {
            this.euPerTick = val;
        }))).widget((Widget)new FakeSyncWidget.DoubleSyncer(() -> this.fuelBurning, val -> {
            this.fuelBurning = val;
        }))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.fuelName, val -> {
            this.fuelName = val;
        }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mSetTier, val -> {
            this.mSetTier = val;
        }));
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mSetTier", this.mSetTier);
        aNBT.func_74772_a("euPerTick", this.euPerTick);
        aNBT.func_74780_a("fuelBurning", this.fuelBurning);
        aNBT.func_74778_a("fuelName", this.fuelName);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mSetTier = aNBT.func_74762_e("mSetTier");
        this.euPerTick = aNBT.func_74763_f("euPerTick");
        this.fuelBurning = aNBT.func_74769_h("fuelBurning");
        this.fuelName = aNBT.func_74779_i("fuelName");
    }
}

