/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine.GeneratorMultis;

import com.Nxer.TwistSpaceTechnology.common.init.TstBlocks;
import com.Nxer.TwistSpaceTechnology.common.machine.ValueEnum;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.TT_MultiMachineBase_EM;
import com.Nxer.TwistSpaceTechnology.util.MathUtils;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.google.common.collect.Lists;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoMulti;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoTunnel;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;

public class GT_TileEntity_MegaEggGenerator
extends TT_MultiMachineBase_EM
implements IConstructable,
ISurvivalConstructable {
    private int mPieces = 1;
    private int mInfinityEggs = 0;
    private int mDragonEggs = 0;
    private int mCreeperEggs = 0;
    private int mAirPosed = 0;
    private long genVol = 0L;
    private long genAmp = 0L;
    private int efficiencyIncrement = 1;
    private IStructureDefinition<GT_TileEntity_MegaEggGenerator> structureDef = null;
    private static final String STRUCTURE_PIECE_BASE = "baseEggGenerator";
    private static final String STRUCTURE_PIECE_MIDDLE = "middleEggGenerator";
    private static final String STRUCTURE_PIECE_TOP = "topEggGenerator";
    private final int horizontalOffSet = 7;
    private final int verticalOffSet = 0;
    private final int depthOffSet = 6;
    private final String[][] shapeBase = new String[][]{{"               ", "      AAA      ", "    AA   AA    ", "   A       A   ", "  A         A  ", "  A         A  ", " A    G~G    A ", " A    GGG    A ", " A    GGG    A ", "  A         A  ", "  A         A  ", "   A       A   ", "    AA   AA    ", "      AAA      ", "               "}};
    private final String[][] shapeMiddle = new String[][]{{"               ", "      AAA      ", "    AAK KAA    ", "   AK     KA   ", "  AK       KA  ", "  A         A  ", " AK    D    KA ", " A    DFD    A ", " AK    D    KA ", "  A         A  ", "  AK       KA  ", "   AK     KA   ", "    AAK KAA    ", "      AAA      ", "               "}, {"      AAA      ", "    AABBBAA    ", "   ABBCACBBA   ", "  ABCA   ACBA  ", " ABC       CBA ", " ABA       ABA ", "ABC    D    CBA", "ABA   DFD   ABA", "ABC    D    CBA", " ABA       ABA ", " ABC       CBA ", "  ABCA   ACBA  ", "   ABBCACBBA   ", "    AABBBAA    ", "      AAA      "}};
    private final String[][] shapeTop = new String[][]{{"               ", "               ", "               ", "               ", "               ", "               ", "               ", "       F       ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}};

    public GT_TileEntity_MegaEggGenerator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.useLongPower = true;
    }

    public GT_TileEntity_MegaEggGenerator(String aName) {
        super(aName);
        this.useLongPower = true;
    }

    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        this.mMaxProgresstime = 20;
        this.lEUt = Math.abs(this.genVol);
        this.eAmpereFlow = this.genAmp;
        this.mEfficiencyIncrease = this.efficiencyIncrement;
        return CheckRecipeResultRegistry.GENERATING;
    }

    private void updateEfficiencyIncrement() {
        this.efficiencyIncrement = 20;
        if (this.mInfinityEggs != 0) {
            this.efficiencyIncrement += this.mInfinityEggs * 100;
        }
        if (this.mDragonEggs != 0) {
            this.efficiencyIncrement = this.mDragonEggs < 100 ? (this.efficiencyIncrement += this.mDragonEggs / 2) : (this.efficiencyIncrement += 50);
        }
    }

    private long getOutputEUt() {
        return (long)ValueEnum.MEG_Overall_Multiply * (ValueEnum.MEG_CrepperEgg_Gen * (long)this.mCreeperEggs + ValueEnum.MEG_DragonEgg_Gen * (long)this.mDragonEggs + ValueEnum.MEG_InfinityEgg_Gen * (long)this.mInfinityEggs);
    }

    private void updateOutput() {
        long expectedEUt;
        long hatchVol = 0L;
        long hatchAmp = 0L;
        for (MTEHatchDynamo tHatch : this.mDynamoHatches) {
            hatchVol += tHatch.maxEUOutput();
            hatchAmp += tHatch.maxAmperesOut();
        }
        for (MTEHatchDynamo tHatch : this.eDynamoMulti) {
            hatchVol += tHatch.maxEUOutput();
            hatchAmp += tHatch.maxAmperesOut();
        }
        if (hatchVol > Integer.MAX_VALUE) {
            hatchVol = Integer.MAX_VALUE;
        }
        if (hatchAmp > Integer.MAX_VALUE) {
            hatchAmp = Integer.MAX_VALUE;
        }
        if ((expectedEUt = this.getOutputEUt()) > hatchVol) {
            this.genVol = hatchVol;
            long expectedAmp = expectedEUt / hatchVol;
            this.genAmp = MathUtils.clamp(expectedAmp, 1L, hatchAmp);
        } else {
            this.genVol = expectedEUt;
            this.genAmp = 1L;
        }
    }

    private int getMaxEfficiency() {
        return Math.max(0, 10000 + ValueEnum.MEG_Efficiency_PiecesBuff * (int)(Math.log(this.mPieces) / Math.log(2.0)) + ValueEnum.MEG_Efficiency_InfinityEggBuff * this.mInfinityEggs - ValueEnum.MEG_Efficiency_Lost * this.mAirPosed);
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.mInfinityEggs = 0;
        this.mDragonEggs = 0;
        this.mCreeperEggs = 0;
        this.mAirPosed = 0;
        this.mPieces = 0;
        return this.checkAllPieces() && this.checkInfinityEgg() && this.checkLaser() && this.checkDynamo() && this.checkAnyDynamoHatch() && this.initValues();
    }

    private boolean checkAllPieces() {
        if (!this.checkPiece(STRUCTURE_PIECE_BASE, 7, 0, 6)) {
            return false;
        }
        while (this.checkPiece(STRUCTURE_PIECE_MIDDLE, 7, 0 + (this.mPieces + 1) * 2, 6)) {
            ++this.mPieces;
        }
        if (this.mPieces < 1) {
            return false;
        }
        return this.checkPiece(STRUCTURE_PIECE_TOP, 7, 0 + this.mPieces * 2 + 1, 6);
    }

    private boolean checkInfinityEgg() {
        return this.mInfinityEggs <= this.mPieces;
    }

    private boolean checkLaser() {
        if (this.mPieces < ValueEnum.MEG_Laser_Pieces) {
            for (MTEHatchDynamoMulti tHatch : this.eDynamoMulti) {
                if (!(tHatch instanceof MTEHatchDynamoTunnel)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkDynamo() {
        return this.mDynamoHatches.size() + this.eDynamoMulti.size() <= ValueEnum.MEG_Dynamo_Limit;
    }

    private boolean checkAnyDynamoHatch() {
        return !this.mDynamoHatches.isEmpty() || !this.eDynamoMulti.isEmpty();
    }

    private boolean initValues() {
        this.updateOutput();
        this.updateEfficiencyIncrement();
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 7, 0, 6);
        int piece = stackSize.field_77994_a;
        for (int i = 1; i <= piece; ++i) {
            this.buildPiece(STRUCTURE_PIECE_MIDDLE, stackSize, hintsOnly, 7, 0 + i * 2, 6);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP, stackSize, hintsOnly, 7, 0 + piece * 2 + 1, 6);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int built = 0;
        built += this.survivialBuildPiece(STRUCTURE_PIECE_BASE, stackSize, 7, 0, 6, elementBudget, source, actor, false, true);
        int piece = stackSize.field_77994_a;
        for (int i = 1; i <= piece; ++i) {
            built += this.survivialBuildPiece(STRUCTURE_PIECE_MIDDLE, stackSize, 7, 0 + i * 2, 6, elementBudget, source, actor, false, true);
        }
        return built += this.survivialBuildPiece(STRUCTURE_PIECE_TOP, stackSize, 7, 0 + piece * 2 + 1, 6, elementBudget, source, actor, false, true);
    }

    private Block InfinityEgg() {
        if (Mods.Witchery.isModLoaded()) {
            return Block.func_149684_b((String)(Mods.Witchery.ID + ":infinityegg"));
        }
        return TstBlocks.PhotonControllerUpgrade;
    }

    public IStructureDefinition<GT_TileEntity_MegaEggGenerator> getStructure_EM() {
        if (this.structureDef == null) {
            this.structureDef = StructureDefinition.builder().addShape(STRUCTURE_PIECE_BASE, StructureUtility.transpose((String[][])this.shapeBase)).addShape(STRUCTURE_PIECE_MIDDLE, StructureUtility.transpose((String[][])this.shapeMiddle)).addShape(STRUCTURE_PIECE_TOP, StructureUtility.transpose((String[][])this.shapeTop)).addElement('A', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.Dynamo.or((IHatchElement)TTMultiblockBase.HatchElement.DynamoMulti)}).adder(TTMultiblockBase::addToMachineList).casingIndex(1536).dot(1).buildAndChain(Loaders.magicCasing, 0)).addElement('B', GTStructureUtility.ofFrame((Materials)Materials.Trinium)).addElement('C', StructureUtility.ofBlock((Block)Loaders.essentiaCell, (int)0)).addElement('D', GTStructureUtility.ofFrame((Materials)Materials.Iridium)).addElement('F', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)8)).addElement('G', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)7)).addElement('K', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(k -> ++k.mAirPosed, (IStructureElement)StructureUtility.isAir()), StructureUtility.onElementPass(k -> ++k.mCreeperEggs, (IStructureElement)StructureUtility.ofBlock((Block)MarsBlocks.creeperEgg, (int)0)), StructureUtility.onElementPass(k -> ++k.mDragonEggs, (IStructureElement)StructureUtility.ofBlock((Block)Blocks.field_150380_bt, (int)0)), StructureUtility.onElementPass(k -> ++k.mInfinityEggs, (IStructureElement)StructureUtility.ofBlock((Block)this.InfinityEgg(), (int)0))})).build();
        }
        return this.structureDef;
    }

    public boolean isRotationChangeAllowed() {
        return ValueEnum.MEG_AllowRotation;
    }

    public String[] getInfoData() {
        ArrayList info = Lists.newArrayList((Object[])super.getInfoData());
        info.add(EnumChatFormatting.AQUA + "Infinity Eggs: " + EnumChatFormatting.GOLD + this.mInfinityEggs);
        info.add(EnumChatFormatting.AQUA + "Dragon Eggs: " + EnumChatFormatting.GOLD + this.mDragonEggs);
        info.add(EnumChatFormatting.AQUA + "Crepper Eggs: " + EnumChatFormatting.GOLD + this.mCreeperEggs);
        info.add(EnumChatFormatting.AQUA + "Air Voids: " + EnumChatFormatting.GOLD + this.mAirPosed);
        info.add(EnumChatFormatting.AQUA + "Pieces: " + EnumChatFormatting.GOLD + this.mPieces);
        info.add(EnumChatFormatting.BLUE + "Generating Vol: " + EnumChatFormatting.GOLD + this.genVol);
        info.add(EnumChatFormatting.BLUE + "Generating Amp: " + EnumChatFormatting.GOLD + this.genAmp);
        info.add(EnumChatFormatting.BLUE + "Efficiency: " + EnumChatFormatting.GOLD + this.mEfficiency + EnumChatFormatting.GRAY + " (" + EnumChatFormatting.GREEN + String.format("%.2f%%", (double)this.mEfficiency * 100.0 / (double)this.getMaxEfficiency()) + EnumChatFormatting.GRAY + ", " + EnumChatFormatting.BLUE + "Max: " + EnumChatFormatting.GOLD + this.getMaxEfficiency() + EnumChatFormatting.GRAY + ", " + EnumChatFormatting.BLUE + "Incr.: " + EnumChatFormatting.GOLD + this.efficiencyIncrement + EnumChatFormatting.GRAY + ")");
        info.add(EnumChatFormatting.BLUE + "Possibly Generating EUt: " + EnumChatFormatting.GOLD + this.genVol * (long)this.mEfficiency / 10000L + EnumChatFormatting.GRAY + " (" + EnumChatFormatting.BLUE + "Max: " + EnumChatFormatting.GOLD + this.getOutputEUt() + EnumChatFormatting.GRAY + ")");
        return info.toArray(new String[0]);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mInfinityEggs", this.mInfinityEggs);
        aNBT.func_74768_a("mDragonEggs", this.mDragonEggs);
        aNBT.func_74768_a("mCrepperEggs", this.mCreeperEggs);
        aNBT.func_74768_a("mAirPosed", this.mAirPosed);
        aNBT.func_74768_a("mPieces", this.mPieces);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mInfinityEggs = aNBT.func_74762_e("mInfinityEggs");
        this.mDragonEggs = aNBT.func_74762_e("mDragonEggs");
        this.mCreeperEggs = aNBT.func_74762_e("mCrepperEggs");
        this.mAirPosed = aNBT.func_74762_e("mAirPosed");
        this.mPieces = aNBT.func_74762_e("mPieces");
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextLocalization.Tooltip_MegaEggGenerator_MachineType).addInfo(TextLocalization.Tooltip_MegaEggGenerator_Controller).addInfo(TextLocalization.Tooltip_MegaEggGenerator_00).addInfo(TextLocalization.Tooltip_MegaEggGenerator_01).addInfo(TextLocalization.Tooltip_MegaEggGenerator_02).addInfo(TextLocalization.Tooltip_MegaEggGenerator_03).addInfo(TextLocalization.Tooltip_MegaEggGenerator_04).addInfo(TextLocalization.Tooltip_MegaEggGenerator_05).addInfo(TextLocalization.Tooltip_MegaEggGenerator_06).addInfo(TextLocalization.Tooltip_MegaEggGenerator_07).addInfo(TextLocalization.Tooltip_MegaEggGenerator_08).addInfo(TextLocalization.Tooltip_MegaEggGenerator_09).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addOtherStructurePart(TextLocalization.Tooltip_MegaEggGenerator_D, TextLocalization.Tooltip_MegaEggGenerator_C, new int[]{1}).addStructureInfo(TextLocalization.Tooltip_MegaEggGenerator_L).addStructureInfo(TextLocalization.Tooltip_MegaEggGenerator_M).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return this.getMaxEfficiency();
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_MegaEggGenerator(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)183), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.MACHINE_CASING_DRAGONEGG_GLOW).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.MACHINE_CASING_DRAGONEGG_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)183), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.MACHINE_CASING_DRAGONEGG).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.MACHINE_CASING_DRAGONEGG).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)183)};
    }
}

