/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.init.TstBlocks;
import com.Nxer.TwistSpaceTechnology.recipe.machineRecipe.expanded.StellarMaterialSiphonRecipePool;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IChunkLoader;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.objects.GTChunkManager;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gtPlusPlus.core.block.ModBlocks;
import gtnhintergalactic.client.IGTextures;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.thing.casing.TTCasingsContainer;

public class GT_TileEntity_StellarMaterialSiphon
extends MTEExtendedPowerMultiBlockBase<GT_TileEntity_StellarMaterialSiphon>
implements IChunkLoader {
    private static String loreTooltip;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final double LOG4;
    private static final String[][] shape;
    private static final String shapeName = "main";
    private static IStructureDefinition<GT_TileEntity_StellarMaterialSiphon> STRUCTURE_DEFINITION;
    private int depth;
    private FluidStack fluid = new FluidStack(FluidRegistry.WATER, 0){

        public String getLocalizedName() {
            return "None";
        }
    };
    private boolean mChunkLoadingEnabled = true;
    private ChunkCoordIntPair mCurrentChunk = null;
    private boolean mWorkChunkNeedsReload = true;

    public GT_TileEntity_StellarMaterialSiphon(int id, String name, String regionalName) {
        super(id, name, regionalName);
    }

    public GT_TileEntity_StellarMaterialSiphon(String name) {
        super(name);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("main", stackSize, hintsOnly, 7, 21, 0);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
        return new GT_TileEntity_StellarMaterialSiphon(this.mName);
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.type")).addInfo(loreTooltip != null ? EnumChatFormatting.ITALIC + loreTooltip : "").addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc3")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc4")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.ig.siphon.desc5")).addSeparator().beginStructureBlock(3, 7, 3, false).addController(GCCoreUtil.translate((String)"ig.siphon.structure.ControllerPos")).addOtherStructurePart(GCCoreUtil.translate((String)"ig.siphon.structure.AdvMachineFrame"), GCCoreUtil.translate((String)"ig.siphon.structure.Base")).addOtherStructurePart(GCCoreUtil.translate((String)"ig.siphon.structure.ReboltedRhodiumPalladiumCasing"), GCCoreUtil.translate((String)"ig.siphon.structure.PillarMiddle")).addOtherStructurePart(GCCoreUtil.translate((String)"ig.siphon.structure.FrameTungstensteel"), GCCoreUtil.translate((String)"ig.siphon.structure.Sides")).addEnergyHatch(GCCoreUtil.translate((String)"ig.siphon.structure.AnyAdvMachineFrame"), new int[]{1}).addMaintenanceHatch(GCCoreUtil.translate((String)"ig.siphon.structure.AnyAdvMachineFrame"), new int[]{1}).addInputBus(GCCoreUtil.translate((String)"ig.siphon.structure.AnyAdvMachineFrame"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.siphon.structure.AnyAdvMachineFrame"), new int[]{1}).toolTipFinisher(new String[]{EnumChatFormatting.DARK_PURPLE + "GTNH-Intergalactic"});
        return tt;
    }

    public IStructureDefinition<GT_TileEntity_StellarMaterialSiphon> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", shape).addElement('A', StructureUtility.ofBlock((Block)TstBlocks.SpaceStationStructureBlock, (int)12)).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings5, (int)13)).addElement('C', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)12)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSE, (int)0)).addElement('E', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSE, (int)1)).addElement('F', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSE, (int)2)).addElement('G', StructureUtility.ofBlock((Block)TTCasingsContainer.SpacetimeCompressionFieldGenerators, (int)2)).addElement('H', StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)7)).addElement('I', StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)11)).addElement('J', StructureUtility.ofBlock((Block)ModBlocks.blockCasings6Misc, (int)1)).addElement('K', StructureUtility.ofBlock((Block)TstBlocks.SpaceStationAntiGravityBlock, (int)13)).addElement('L', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addMaintenanceToMachineList, (int)154, (int)1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addExoticEnergyInputToMachineList, (int)154, (int)1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addInputToMachineList, (int)154, (int)1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, (int)154, (int)1), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsSE, (int)0)})).addElement('M', StructureUtility.ofBlock((Block)TstBlocks.SpaceStationAntiGravityBlock, (int)13)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public ChunkCoordIntPair getActiveChunk() {
        return this.mCurrentChunk;
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstone) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)154), TextureFactory.of((ITexture)IGTextures.SIPHON_OVERLAY_FRONT), TextureFactory.builder().addIcon(IGTextures.SIPHON_OVERLAY_FRONT_ACTIVE_GLOW).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)154), TextureFactory.of((ITexture)IGTextures.SIPHON_OVERLAY_FRONT), TextureFactory.builder().addIcon(IGTextures.SIPHON_OVERLAY_FRONT_GLOW).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)154)};
    }

    public boolean isCorrectMachinePart(ItemStack stack) {
        return true;
    }

    @NotNull
    public CheckRecipeResult checkProcessing() {
        if (this.mInputBusses.isEmpty() || !((MTEHatchInputBus)this.mInputBusses.get(0)).isValid()) {
            this.resetMachine(true);
            return SimpleCheckRecipeResult.ofFailure((String)"no_mining_pipe");
        }
        Map<Integer, FluidStack> planetRecipes = StellarMaterialSiphonRecipePool.RECIPES.get("blackHole");
        MTEHatchInputBus bus = (MTEHatchInputBus)this.mInputBusses.get(0);
        for (int i = 0; i < bus.getBaseMetaTileEntity().func_70302_i_(); ++i) {
            ItemStack stack = bus.getBaseMetaTileEntity().func_70301_a(i);
            if (stack == null || stack.func_77973_b() != ItemList.Circuit_Integrated.getItem()) continue;
            this.depth = stack.func_77960_j();
            break;
        }
        FluidStack recipeFluid = planetRecipes.get(1).copy();
        recipeFluid.amount *= 1 << this.depth;
        if (!this.canOutputAll(new FluidStack[]{recipeFluid})) {
            return CheckRecipeResultRegistry.FLUID_OUTPUT_FULL;
        }
        long recipeEUt = Integer.MAX_VALUE << this.depth;
        this.fluid = recipeFluid.copy();
        this.lEUt = -recipeEUt;
        this.mOutputFluids = new FluidStack[]{this.fluid};
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = 20;
        return SimpleCheckRecipeResult.ofSuccess((String)"drilling");
    }

    public void repairMachine() {
        this.mHardHammer = true;
        this.mSoftMallet = true;
        this.mScrewdriver = true;
        this.mCrowbar = true;
        this.mSolderingTool = true;
        this.mWrench = true;
    }

    public boolean doRandomMaintenanceDamage() {
        return true;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack stack) {
        this.repairMachine();
        return this.checkPiece("main", 7, 21, 0);
    }

    public int getMaxEfficiency(ItemStack stack) {
        return 10000;
    }

    public int getDamageToComponent(ItemStack stack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack stack) {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("chunkLoadingEnabled", this.mChunkLoadingEnabled);
        aNBT.func_74757_a("isChunkloading", this.mCurrentChunk != null);
        if (this.mCurrentChunk != null) {
            aNBT.func_74768_a("loadedChunkXPos", this.mCurrentChunk.field_77276_a);
            aNBT.func_74768_a("loadedChunkZPos", this.mCurrentChunk.field_77275_b);
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("chunkLoadingEnabled")) {
            this.mChunkLoadingEnabled = aNBT.func_74767_n("chunkLoadingEnabled");
        }
        if (aNBT.func_74767_n("isChunkloading")) {
            this.mCurrentChunk = new ChunkCoordIntPair(aNBT.func_74762_e("loadedChunkXPos"), aNBT.func_74762_e("loadedChunkZPos"));
        }
    }

    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer player, float aX, float aY, float aZ, ItemStack aTool) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mChunkLoadingEnabled = !this.mChunkLoadingEnabled;
            GTUtility.sendChatToPlayer((EntityPlayer)player, (String)(this.mChunkLoadingEnabled ? GTUtility.trans((String)"502", (String)"Mining chunk loading enabled") : GTUtility.trans((String)"503", (String)"Mining chunk loading disabled")));
            return true;
        }
        return super.onSolderingToolRightClick(side, wrenchingSide, player, aX, aY, aZ, aTool);
    }

    private void resetMachine(boolean resetDepth) {
        if (resetDepth) {
            this.depth = 0;
        }
        this.mEUt = 0;
        this.mEfficiency = 0;
    }

    public void onRemoval() {
        if (this.mChunkLoadingEnabled) {
            GTChunkManager.releaseTicket((TileEntity)((TileEntity)this.getBaseMetaTileEntity()));
        }
        super.onRemoval();
    }

    public void onPostTick(IGregTechTileEntity baseMetaTileEntity, long tick) {
        super.onPostTick(baseMetaTileEntity, tick);
        if (baseMetaTileEntity.isServerSide() && this.mCurrentChunk != null && !this.mWorkChunkNeedsReload && !baseMetaTileEntity.isAllowedToWork()) {
            GTChunkManager.releaseTicket((TileEntity)((TileEntity)baseMetaTileEntity));
            this.mWorkChunkNeedsReload = true;
        }
    }

    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.LIGHT_PURPLE + "Operational Data:" + EnumChatFormatting.RESET, "Depth: " + EnumChatFormatting.YELLOW + this.depth + EnumChatFormatting.RESET, "Fluid: " + EnumChatFormatting.YELLOW + this.fluid.amount + EnumChatFormatting.RESET + "L/s " + EnumChatFormatting.BLUE + this.fluid.getLocalizedName() + EnumChatFormatting.RESET, "EU/t required: " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((long)(-this.mEUt)) + EnumChatFormatting.RESET + " EU/t", "Maintenance Status: " + (this.getRepairStatus() == this.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has problems" + EnumChatFormatting.RESET), "---------------------------------------------"};
    }

    public boolean supportsVoidProtection() {
        return true;
    }

    static {
        LOG4 = Math.log10(4.0);
        shape = new String[][]{{"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      LLL      ", "      L~L      ", "KKKKKKKKKKKKKKK", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      FFF      ", "KDDDDDDCDDDDDDK", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      FFF      ", "     FEEEF     ", "KDGGGGDCDGGGGDK", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      AAA      ", "      AAA      ", "      AAA      ", "     FEEEF     ", "    FE   EF    ", "KDGGGGDCDGGGGDK", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      HCH      ", "      HCH      ", "      HCH      ", "      HCH      ", "     ABBBA     ", "     ABBBA     ", "     ABBBA     ", "    FEBBBEF    ", "   FE     EF   ", "KDGGGGDCDGGGGDK", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "       C       ", "       C       ", "       C       ", "       C       ", "      HCH      ", "     IEEEI     ", "     IEEEI     ", "     IEEEI     ", "     IEEEI     ", "    AB   BA    ", "    AB   BA    ", "    AB   BA    ", "   FEB   BEF   ", "  FE       EF  ", "KDGGGGDCDGGGGDK", "       M       ", "       M       ", "       M       ", "       M       ", "       M       ", "       M       ", "       M       ", "       M       ", "       M       ", "       M       ", "       M       "}, {"               ", "               ", "               ", "               ", "               ", "       H       ", "       H       ", "       H       ", "      HJH      ", "      HJH      ", "      HJH      ", "      HJH      ", "     HHJHH     ", "    HEEJEEH    ", "    HE J EH    ", "    HE J EH    ", "    HE J EH    ", "   AB  J  BA   ", "   AB  J  BA   ", "   AB  J  BA   ", "  FEB  J  BEF  ", " FE    J    EF ", "KDDDDDDCDDDDDDK", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      "}, {"       I       ", "       I       ", "       I       ", "       I       ", "       I       ", "      HIH      ", "      HIH      ", "      HIH      ", "     CJJJC     ", "     CJ JC     ", "     CJ JC     ", "     CJ JC     ", "     CJ JC     ", "    CEJ JEC    ", "    CEJ JEC    ", "    CEJ JEC    ", "    CEJ JEC    ", "   AB J J BA   ", "   AB J J BA   ", "   AB J J BA   ", "  FEB J J BEF  ", " FE   J J   EF ", "KCCCCCC CCCCCCK", "     MJ JM     ", "     MJ JM     ", "     MJ JM     ", "     MJ JM     ", "     MJ JM     ", "     MJ JM     ", "     MJ JM     ", "     MJ JM     ", "     MJ JM     ", "     MJ JM     ", "     MJ JM     "}, {"               ", "               ", "               ", "               ", "               ", "       H       ", "       H       ", "       H       ", "      HJH      ", "      HJH      ", "      HJH      ", "      HJH      ", "     HHJMH     ", "    HEEJEEH    ", "    HE J EH    ", "    HE J EH    ", "    HE J EH    ", "   AB  J  BA   ", "   AB  J  BA   ", "   AB  J  BA   ", "  FEB  J  BEF  ", " FE    J    EF ", "KDDDDDDCDDDDDDK", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      ", "      MJM      "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "       C       ", "       C       ", "       C       ", "       C       ", "      HCH      ", "     IEEEI     ", "     IEEEI     ", "     IEEEI     ", "     IEEEI     ", "    AB   BA    ", "    AB   BA    ", "    AB   BA    ", "   FEB   BEF   ", "  FE       EF  ", "KDGGGGDCDGGGGDK", "       M       ", "       M       ", "       M       ", "       M       ", "       M       ", "       M       ", "       M       ", "       M       ", "       M       ", "       M       ", "       M       "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      HCH      ", "      HCH      ", "      HCH      ", "      HCH      ", "     ABBBA     ", "     ABBBA     ", "     ABBBA     ", "    FEBBBEF    ", "   FE     EF   ", "KDGGGGDCDGGGGDK", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      AAA      ", "      AAA      ", "      AAA      ", "     FEEEF     ", "    FE   EF    ", "KDGGGGDCDGGGGDK", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      FFF      ", "     FEEEF     ", "KDGGGGDCDGGGGDK", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      FFF      ", "KDDDDDDCDDDDDDK", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "KKKKKKKKKKKKKKK", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}};
    }
}

