/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.api.ModBlocksHandler;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.util.TSTStructureUtility;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GTChunkManager;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.Pollution;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class GT_TileEntity_MegaBrickedBlastFurnace
extends GTCM_MultiMachineBase<GT_TileEntity_MegaBrickedBlastFurnace>
implements ISurvivalConstructable {
    private static final double max_efficiency_time_in_ticks = 576000.0;
    private static final double maximum_fuelEfficiency = 8.0;
    private double fuelEfficiency = 1.0;
    private long running_time = 0L;
    private static ItemStack cokeCoal;
    private static ItemStack cokeCoalBlock;
    private boolean usePrimitiveRecipes = false;
    private static Set<TST_ItemID> fuels;
    private static Set<TST_ItemID> fuelBlocks;
    private static ItemStack iron;
    private static ItemStack wroughtIron;
    private static ItemStack steel;
    private static ItemStack ash;
    private static final int max_input_bus = 6;
    private static final int max_output_bus = 6;
    private static final ITexture[] FACING_SIDE;
    private static final ITexture[] FACING_FRONT;
    private static final ITexture[] FACING_ACTIVE;
    private static final String[][] structure_string;
    private static final int BRONZE_PLATED_BRICKS_INDEX = 10;
    private static final int FIREBRICK_METAID = 15;
    private boolean isMultiChunkloaded = true;
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    private static IStructureDefinition<GT_TileEntity_MegaBrickedBlastFurnace> STRUCTURE_DEFINITION;

    public static void initStatics() {
        cokeCoal = GTModHandler.getModItem((String)"Railcraft", (String)"fuel.coke", (long)1L);
        if (cokeCoal == null) {
            cokeCoal = Materials.Coal.getGems(1);
        }
        if ((cokeCoalBlock = GTModHandler.getModItem((String)"Railcraft", (String)"cube", (long)1L)) == null) {
            cokeCoalBlock = Materials.Coal.getBlocks(1);
        }
        ItemStack charCoal = Materials.Charcoal.getGems(1);
        ItemStack charCoalBlock = Materials.Charcoal.getBlocks(1);
        ItemStack gemCoal = Materials.Coal.getGems(1);
        ItemStack dustCoal = Materials.Coal.getDust(1);
        ItemStack blockCoal = Materials.Coal.getBlocks(1);
        ItemStack dustCharCoal = Materials.Charcoal.getDust(1);
        ItemStack cactusCoke = GTModHandler.getModItem((String)"miscutils", (String)"itemCactusCoke", (long)1L);
        ItemStack cactusCharCoal = GTModHandler.getModItem((String)"miscutils", (String)"itemCactusCharcoal", (long)1L);
        ItemStack sugarCharCoal = GTModHandler.getModItem((String)"miscutils", (String)"itemSugarCharcoal", (long)1L);
        ItemStack sugarCoke = GTModHandler.getModItem((String)"miscutils", (String)"itemSugarCoke", (long)1L);
        fuels = Sets.newHashSet((Object[])new TST_ItemID[]{TST_ItemID.create(charCoal), TST_ItemID.create(charCoalBlock), TST_ItemID.create(cokeCoal), TST_ItemID.create(cokeCoalBlock), TST_ItemID.create(blockCoal), TST_ItemID.create(gemCoal), TST_ItemID.create(dustCoal), TST_ItemID.create(dustCharCoal), TST_ItemID.create(cactusCoke), TST_ItemID.create(cactusCharCoal), TST_ItemID.create(sugarCharCoal), TST_ItemID.create(sugarCoke)});
        fuelBlocks = Sets.newHashSet((Object[])new TST_ItemID[]{TST_ItemID.create(charCoalBlock), TST_ItemID.create(cokeCoalBlock)});
        iron = GTOreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Iron, (long)1L);
        wroughtIron = GTOreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.WroughtIron, (long)1L);
        steel = GTOreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Steel, (long)1L);
        ash = GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Ash, (long)1L);
    }

    public GT_TileEntity_MegaBrickedBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MegaBrickedBlastFurnace(String aName) {
        super(aName);
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return false;
    }

    @Override
    protected float getSpeedBonus() {
        return 0.0f;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 0;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_MegaBrickedBlastFurnace(this.mName);
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextLocalization.Tooltip_MegaBrickedBlastFurnace_MachineType).addInfo(TextLocalization.Tooltip_MegaBrickedBlastFurnace_Controller).addInfo(TextLocalization.Tooltip_MegaBrickedBlastFurnace_00).addInfo(TextLocalization.Tooltip_MegaBrickedBlastFurnace_01).addInfo(TextLocalization.Tooltip_MegaBrickedBlastFurnace_02).addInfo(TextLocalization.Tooltip_MegaBrickedBlastFurnace_03).addInfo(TextLocalization.Tooltip_MegaBrickedBlastFurnace_04).addInfo(TextLocalization.Tooltip_MegaBrickedBlastFurnace_05).addInfo(TextLocalization.Tooltip_MegaBrickedBlastFurnace_06).addInfo(TextLocalization.Tooltip_MegaBrickedBlastFurnace_07).addInfo(TextLocalization.Tooltip_MegaBrickedBlastFurnace_08).addInfo(TextLocalization.Tooltip_MegaBrickedBlastFurnace_09).addPollutionAmount(this.getPollutionPerSecond(null)).addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addInfo(TextEnums.tr("Tooltip_Channel_Helper")).addSeparator().addStructureInfo(TextLocalization.textMegaBrickedBlastFurnaceTips).addInputBus(TextLocalization.textMegaBrickedBlastFurnaceLocation, new int[]{1}).addOutputBus(TextLocalization.textMegaBrickedBlastFurnaceLocation, new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aStack) {
        this.usePrimitiveRecipes = !this.usePrimitiveRecipes;
        GTUtility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(this.usePrimitiveRecipes ? "Now Bricked DTPF accepts primitive blast furnace recipes" : "Now Bricked DTPF only accepts iron/wrought iron and charcoal"));
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            return aActive ? FACING_ACTIVE : FACING_FRONT;
        }
        return FACING_SIDE;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 30000;
    }

    public IStructureDefinition<GT_TileEntity_MegaBrickedBlastFurnace> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, structure_string).addElement('C', TSTStructureUtility.ofVariableBlock("chisel", (Block)ModBlocksHandler.HorizontalDirt.getLeft(), (Integer)ModBlocksHandler.HorizontalDirt.getRight(), (List<ItemStack>)ImmutableList.of((Object)TstUtils.newItemWithMeta((Block)ModBlocksHandler.HorizontalDirt.getLeft(), (int)((Integer)ModBlocksHandler.HorizontalDirt.getRight())), (Object)TstUtils.newItemWithMeta(Blocks.field_150346_d, 0)))).addElement('b', (IStructureElement)GTStructureUtility.buildHatchAdder(GT_TileEntity_MegaBrickedBlastFurnace.class).atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.OutputBus}).casingIndex(10).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)10)})).addElement('N', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)15)).addElement('s', StructureUtility.ofBlock((Block)Blocks.field_150336_V, (int)0)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    private GTRecipe findRecipe(ArrayList<ItemStack> inputList) {
        RecipeMap primitiveBlastRecipes = RecipeMaps.primitiveBlastRecipes;
        ItemStack[] inputArr = inputList.toArray(new ItemStack[inputList.size()]);
        return primitiveBlastRecipes.findRecipeQuery().items(inputArr).find();
    }

    static MaterialConsumption calculateMaterialConsumption(GTRecipe recipe, List<ItemStack> inputList) {
        TST_ItemID itemWithDamage;
        MaterialConsumption result = new MaterialConsumption();
        HashMap<TST_ItemID, Integer> itemCountInput = new HashMap<TST_ItemID, Integer>();
        HashMap<TST_ItemID, Integer> recipeItems = new HashMap<TST_ItemID, Integer>();
        int recipefuelAmount = 0;
        TST_ItemID fuelItem = null;
        for (ItemStack ingredient : recipe.mInputs) {
            if (ingredient == null) continue;
            itemWithDamage = TST_ItemID.create(ingredient);
            recipeItems.put(itemWithDamage, ingredient.field_77994_a);
            if (!fuels.contains((Object)itemWithDamage)) continue;
            recipefuelAmount = ingredient.field_77994_a;
            fuelItem = itemWithDamage;
        }
        for (ItemStack ingredient : recipe.mInputs) {
            if (ingredient == null || fuels.contains((Object)(itemWithDamage = TST_ItemID.create(ingredient)))) continue;
            result.originalRatio.put(itemWithDamage, (double)ingredient.field_77994_a / (double)recipefuelAmount);
        }
        for (ItemStack itemStack : inputList) {
            TST_ItemID itemWithDamage2 = TST_ItemID.create(itemStack);
            itemCountInput.merge(itemWithDamage2, itemStack.field_77994_a, Integer::sum);
        }
        int fuelAmount = (Integer)itemCountInput.get((Object)fuelItem);
        int parallelism = Integer.MAX_VALUE;
        for (TST_ItemID item : recipeItems.keySet()) {
            if (item == null) continue;
            parallelism = Math.min((Integer)itemCountInput.get((Object)item) / (Integer)recipeItems.get((Object)item), parallelism);
            if (fuels.contains((Object)item)) continue;
            result.actualRatio.put(item, (double)((Integer)itemCountInput.get((Object)item)).intValue() / (double)fuelAmount);
        }
        result.parallelism = parallelism;
        ItemStack fuelToBeConsumed = ItemStack.func_77944_b((ItemStack)fuelItem.getItemStack());
        fuelToBeConsumed.field_77994_a = fuelAmount;
        result.fuelToBeConsumed = fuelToBeConsumed;
        for (ItemStack ingredient : recipe.mInputs) {
            TST_ItemID itemWithDamage3;
            if (ingredient == null || fuels.contains((Object)(itemWithDamage3 = TST_ItemID.create(ingredient)))) continue;
            ItemStack newstack = ItemStack.func_77944_b((ItemStack)ingredient);
            newstack.field_77994_a = parallelism * newstack.field_77994_a;
            result.materialToBeConsumed.add(newstack);
        }
        return result;
    }

    public ItemStack[] getPrimitiveOutputs(GTRecipe recipe, int parallelism) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack output : recipe.mOutputs) {
            if (output == null) continue;
            int count = output.field_77994_a * parallelism;
            ItemStack copy = output.func_77946_l();
            copy.field_77994_a = count;
            result.add(copy);
        }
        return result.toArray(new ItemStack[0]);
    }

    public void consumePrimitiveInput(MaterialConsumption materialConsumption, List<ItemStack> inputList) {
        for (int i = 0; i < inputList.size(); ++i) {
            ItemStack input = inputList.get(i);
            if (input == null || input.func_77973_b() != materialConsumption.fuelToBeConsumed.func_77973_b() || input.func_77960_j() != materialConsumption.fuelToBeConsumed.func_77960_j()) continue;
            input.field_77994_a = 0;
        }
        for (ItemStack toBeConsumed : materialConsumption.materialToBeConsumed) {
            int consumeSize = toBeConsumed.field_77994_a;
            while (consumeSize > 0) {
                for (int i = 0; i < inputList.size(); ++i) {
                    ItemStack input = inputList.get(i);
                    if (input == null || !GTUtility.areStacksEqual((ItemStack)input, (ItemStack)toBeConsumed, (boolean)false)) continue;
                    int consumeThisTime = Math.min(input.field_77994_a, consumeSize);
                    input.field_77994_a -= consumeThisTime;
                    consumeSize -= consumeThisTime;
                }
            }
        }
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ArrayList tInputList = this.getStoredInputs();
        if (tInputList.isEmpty()) {
            this.resetEfficiency();
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        double time_percentage = (double)this.running_time / 576000.0;
        time_percentage = Math.min(time_percentage, 1.0);
        if (this.usePrimitiveRecipes) {
            int n;
            GTRecipe recipe = this.findRecipe(tInputList);
            if (recipe == null) {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            MaterialConsumption materialConsumption = GT_TileEntity_MegaBrickedBlastFurnace.calculateMaterialConsumption(recipe, tInputList);
            this.fuelEfficiency = 1.0 + time_percentage * 7.0;
            this.fuelEfficiency = Math.min(8.0, this.fuelEfficiency);
            ItemStack fuelToBeConsumed = materialConsumption.fuelToBeConsumed;
            for (TST_ItemID tST_ItemID : materialConsumption.actualRatio.keySet()) {
                double originalRatio = materialConsumption.originalRatio.get((Object)tST_ItemID);
                double actualRatio = materialConsumption.actualRatio.get((Object)tST_ItemID);
                if (!(actualRatio > originalRatio)) continue;
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            int consumeTotalMaterial = 0;
            for (ItemStack itemStack : materialConsumption.materialToBeConsumed) {
                consumeTotalMaterial += itemStack.field_77994_a;
            }
            this.mEfficiency = 10000;
            this.mEfficiencyIncrease = 10000;
            this.mOutputItems = this.getPrimitiveOutputs(recipe, materialConsumption.parallelism);
            boolean bl = false;
            for (ItemStack mInput : recipe.mInputs) {
                if (mInput == null || fuels.contains((Object)TST_ItemID.create(mInput))) continue;
                n = Math.max(n, mInput.field_77994_a);
            }
            TST_ItemID fuelItem = TST_ItemID.create(fuelToBeConsumed);
            this.mMaxProgresstime = this.calculateDuration(recipe.mDuration, 0.0, consumeTotalMaterial / n, (int)((double)fuelToBeConsumed.field_77994_a * this.fuelEfficiency * (double)(fuelBlocks.contains((Object)fuelItem) ? 10 : 1)));
            this.consumePrimitiveInput(materialConsumption, tInputList);
            this.updateSlots();
            this.running_time += (long)this.mMaxProgresstime;
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        int coalAmount = 0;
        int ironAmount = 0;
        int wroughtIronAmount = 0;
        double originalDuration = 4800.0;
        for (ItemStack item : tInputList) {
            if (item == null) continue;
            if (item.func_77969_a(cokeCoal)) {
                coalAmount += item.field_77994_a;
                continue;
            }
            if (item.func_77969_a(cokeCoalBlock)) {
                coalAmount += item.field_77994_a * 10;
                continue;
            }
            if (item.func_77969_a(iron)) {
                ironAmount += item.field_77994_a;
                continue;
            }
            if (!item.func_77969_a(wroughtIron)) continue;
            wroughtIronAmount += item.field_77994_a;
        }
        if (ironAmount == 0 && wroughtIronAmount == 0) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.fuelEfficiency = 1.0 + time_percentage * 7.0;
        this.fuelEfficiency = Math.min(8.0, this.fuelEfficiency);
        int consumeTotalIron = Math.max((ironAmount + wroughtIronAmount) / 2, 1);
        int consumeCoal = this.calculateConsumeCoal(coalAmount, consumeTotalIron);
        if (coalAmount < consumeCoal) {
            this.resetEfficiency();
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        double WroughtIronRatio = (double)wroughtIronAmount / (double)(ironAmount + wroughtIronAmount);
        int consumeIron = (int)((double)consumeTotalIron * (1.0 - WroughtIronRatio));
        int consumeWroughtIron = Math.min(consumeTotalIron - consumeIron, wroughtIronAmount);
        consumeIron = consumeTotalIron - consumeWroughtIron;
        this.mEfficiency = 10000;
        this.mEfficiencyIncrease = 10000;
        this.mOutputItems = this.calculateOutputs(consumeTotalIron, consumeCoal);
        this.mMaxProgresstime = this.calculateDuration(originalDuration, WroughtIronRatio, consumeTotalIron, (int)((double)consumeCoal * this.fuelEfficiency));
        this.consumeInputs(consumeIron, consumeWroughtIron, tInputList);
        this.updateSlots();
        this.running_time += (long)this.mMaxProgresstime;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    protected ItemStack[] calculateOutputs(int consumeTotalIron, int consumeCoal) {
        ItemStack outputSteel = steel.func_77946_l();
        outputSteel.field_77994_a = consumeTotalIron;
        ItemStack outputAsh = ash.func_77946_l();
        outputAsh.field_77994_a = consumeCoal / 9;
        double remain = 1.0 / (double)(consumeCoal % 9) * 10000.0;
        if ((double)this.getBaseMetaTileEntity().getRandomNumber(10000) < remain) {
            ++outputAsh.field_77994_a;
        }
        return new ItemStack[]{outputSteel, outputAsh};
    }

    protected int calculateDuration(double originalDuration, double wroughtIronRatio, int consumeTotalIron, int coalAmount) {
        return (int)(originalDuration * (double)consumeTotalIron / ((1.0 + 4.0 * wroughtIronRatio) * Math.sqrt(coalAmount)));
    }

    protected void consumeInputs(int consumeIron, int consumeWroughtIron, ArrayList<ItemStack> tInputList) {
        int[] consumeAmounts = new int[]{consumeIron, consumeWroughtIron};
        for (ItemStack item : tInputList) {
            int i;
            if (item == null) continue;
            if (item.func_77969_a(cokeCoal) || item.func_77969_a(cokeCoalBlock)) {
                item.field_77994_a = 0;
                continue;
            }
            if (item.func_77969_a(iron)) {
                i = 0;
            } else {
                if (!item.func_77969_a(wroughtIron)) continue;
                i = 1;
            }
            if (consumeAmounts[i] >= item.field_77994_a) {
                int n = i;
                consumeAmounts[n] = consumeAmounts[n] - item.field_77994_a;
                item.field_77994_a = 0;
                continue;
            }
            item.field_77994_a -= consumeAmounts[i];
            consumeAmounts[i] = 0;
        }
    }

    protected int calculateConsumeCoal(int coalAmount, int consumeTotalIron) {
        return (int)Math.max((double)coalAmount, (double)(consumeTotalIron * 2) / this.fuelEfficiency);
    }

    protected void resetEfficiency() {
        this.running_time = 0L;
        this.fuelEfficiency = 1.0;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 16, 21, 16)) {
            return false;
        }
        if (this.mInputBusses.size() > 6) {
            return false;
        }
        return this.mOutputBusses.size() <= 6;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers((long)this.mProgresstime) + EnumChatFormatting.RESET + "t / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((long)this.mMaxProgresstime) + EnumChatFormatting.RESET + "t", "Ticks run: " + EnumChatFormatting.GREEN + GTUtility.formatNumbers((long)this.running_time) + EnumChatFormatting.RESET + ", Fuel Efficiency: " + EnumChatFormatting.RED + GTUtility.formatNumbers((double)(100.0 * this.fuelEfficiency)) + EnumChatFormatting.RESET + "%"};
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && !aBaseMetaTileEntity.isAllowedToWork()) {
            GTChunkManager.releaseTicket((TileEntity)((TileEntity)aBaseMetaTileEntity));
            this.isMultiChunkloaded = false;
        } else if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && !this.isMultiChunkloaded) {
            GTChunkManager.releaseTicket((TileEntity)((TileEntity)aBaseMetaTileEntity));
            int ControllerXCoordinate = ((TileEntity)aBaseMetaTileEntity).field_145851_c;
            int ControllerZCoordinate = ((TileEntity)aBaseMetaTileEntity).field_145849_e;
            GTChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(ControllerXCoordinate, ControllerZCoordinate));
            GTChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(ControllerXCoordinate + 16, ControllerZCoordinate));
            GTChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(ControllerXCoordinate - 16, ControllerZCoordinate));
            GTChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(ControllerXCoordinate, ControllerZCoordinate + 16));
            GTChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(ControllerXCoordinate, ControllerZCoordinate - 16));
            GTChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(ControllerXCoordinate + 16, ControllerZCoordinate + 16));
            GTChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(ControllerXCoordinate + 16, ControllerZCoordinate - 16));
            GTChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(ControllerXCoordinate - 16, ControllerZCoordinate + 16));
            GTChunkManager.requestChunkLoad((TileEntity)((TileEntity)aBaseMetaTileEntity), (ChunkCoordIntPair)new ChunkCoordIntPair(ControllerXCoordinate - 16, ControllerZCoordinate - 16));
            this.isMultiChunkloaded = true;
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public boolean polluteEnvironment(int aPollutionLevel) {
        Pollution.addPollution((IGregTechTileEntity)this.getBaseMetaTileEntity(), (int)this.getPollutionPerTick(null));
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 16, 21, 16);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 16, 21, 16, elementBudget, env, false, true);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74772_a("eRunningTime", this.running_time);
        aNBT.func_74780_a("eLongEfficiencyValue", this.fuelEfficiency);
        aNBT.func_74757_a("usePrimitiveRecipes", this.usePrimitiveRecipes);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.running_time = aNBT.func_74763_f("eRunningTime");
        this.fuelEfficiency = aNBT.func_74769_h("eLongEfficiencyValue");
        this.usePrimitiveRecipes = aNBT.func_74767_n("usePrimitiveRecipes");
        super.loadNBTData(aNBT);
    }

    @Override
    public boolean supportsVoidProtection() {
        return false;
    }

    @Override
    public boolean supportsInputSeparation() {
        return false;
    }

    static {
        FACING_SIDE = new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_DENSEBRICKS)};
        FACING_FRONT = new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_BRICKEDBLASTFURNACE_INACTIVE)};
        FACING_ACTIVE = new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_BRICKEDBLASTFURNACE_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.MACHINE_CASING_BRICKEDBLASTFURNACE_ACTIVE_GLOW).glow().build()};
        structure_string = new String[][]{{"                                 ", "         N   N     N   N         ", "         N   N     N   N         ", "         N   N     N   N         ", "                                 ", "                                 ", "                                 ", "         N   N     N   N         ", "         N   N     N   N         ", " NNN   NNN   N     N   NNN   NNN ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN "}, {"         N   N     N   N         ", "         bCCCb     bCCCb         ", "         bCCCb     bCCCb         ", "         bCCCb     bCCCb         ", "         N   N     N   N         ", "                                 ", "         N   N     N   N         ", "         bCCCb     bCCCb         ", "         bCCCb     bCCCb         ", "NbbbN NbbNCCCb     bCCCNbbN NbbbN", " CCC   CCC   N     N   CCC   CCC ", " CCC   CCC             CCC   CCC ", " CCC   CCC             CCC   CCC ", "NbbbN NbbbN           NbbbN NbbbN", "  N     N               N     N  ", "  N     N               N     N  ", "                                 ", "  N     N               N     N  ", "  N     N               N     N  ", "NbbbN NbbbN           NbbbN NbbbN", " CCC   CCC             CCC   CCC ", " CCC   CCC             CCC   CCC ", " CCC   CCC             CCC   CCC ", "NbbbN NbbbN    N N    NbbbN NbbbN"}, {"         N   N     N   N         ", "         bCCCb     bCCCb         ", "      NNNbbbbbNNsNNbbbbbNNN      ", "    ss   bCCCb     bCCCb   ss    ", "   s     N   N     N   N     s   ", "   s                         s   ", "  N      N   N     N   N      N  ", "  N      bCCCb     bCCCb      N  ", "  N     sbbbbbNNsNNbbbbbs     N  ", "NbbbN NbbNCCCb     bCCCNbbN NbbbN", " CbC   CbC   N     N   CbC   CbC ", " CbC   CbC             CbC   CbC ", " CbC   CbC             CbC   CbC ", "NbbbN NbbbN           NbbbN NbbbN", " NNN   NNN             NNN   NNN ", " NNN   NNN             NNN   NNN ", "  s     s               s     s  ", " NNN   NNN             NNN   NNN ", " NNN   NNN             NNN   NNN ", "NbbbN NbbbN           NbbbN NbbbN", " CbC   CbC             CbC   CbC ", " CbC   CbC             CbC   CbC ", " CbC   CbC             CbC   CbC ", "NbbbN NbbbNNNNNsNsNNNNNbbbN NbbbN"}, {"         N   N     N   N         ", "         bCCCb     bCCCb         ", "    ss   bCCCb     bCCCb   ss    ", "         bCCCb     bCCCb         ", "  s      NCCCN     NCCCN      s  ", "  s      NCCCN     NCCCN      s  ", "         NCCCN     NCCCN         ", "         bCCCb     bCCCb         ", "         bCCCb     bCCCb         ", "NbbbNNNbbNCCCb     bCCCNbbNNNbbbN", " CCCCCCCCC   N     N   CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", "NbbbNNNbbbN           NbbbNNNbbbN", "  N     N               N     N  ", "  N     N               N     N  ", "                                 ", "  N     N               N     N  ", "  N     N               N     N  ", "NbbbNNNbbbN           NbbbNNNbbbN", " CCCCCCCCC             CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", "NbbbNNNbbbN    NbN    NbbbNNNbbbN"}, {"                                 ", "         N   N     N   N         ", "   s     N   N     N   N     s   ", "  s      NCCCN     NCCCN      s  ", "                                 ", "                                 ", "                                 ", "         NCCCN     NCCCN         ", "         N   N     N   N         ", " NNN   NN    N     N    NN   NNN ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " NNN   NNN     NbN     NNN   NNN "}, {"                                 ", "                                 ", "   s                         s   ", "  s      NCCCN     NCCCN      s  ", "                                 ", "                                 ", "                                 ", "         NCCCN     NCCCN         ", "                                 ", "   N   N                 N   N   ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   N   N                 N   N   ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "   N   N                 N   N   ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   N   N       NbN       N   N   "}, {"                                 ", "         N   N     N   N         ", "  N      N   N     N   N      N  ", "         NCCCN     NCCCN         ", "                                 ", "                                 ", "                                 ", "         NCCCN     NCCCN         ", "         N   N     N   N         ", " NNN   NN    N     N    NN   NNN ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " NNN   NNN     NbN     NNN   NNN "}, {"         N   N     N   N         ", "         bCCCb     bCCCb         ", "  N      bCCCb     bCCCb      N  ", "         bCCCb     bCCCb         ", "         NCCCN     NCCCN         ", "         NCCCN     NCCCN         ", "         NCCCN     NCCCN         ", "         bCCCb     bCCCb         ", "         bCCCb     bCCCb         ", "NbbbNNNbbNCCCb     bCCCNbbNNNbbbN", " CCCCCCCCC   N     N   CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", "NbbbNNNbbbN           NbbbNNNbbbN", "  N     N               N     N  ", "  N     N               N     N  ", "                                 ", "  N     N               N     N  ", "  N     N               N     N  ", "NbbbNNNbbbN           NbbbNNNbbbN", " CCCCCCCCC             CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", "NbbbNNNbbbN    NbN    NbbbNNNbbbN"}, {"         N   N     N   N         ", "         bCCCb     bCCCb         ", "  N     sbbbbbNNsNNbbbbbs     N  ", "         bCCCb     bCCCb         ", "         N   N     N   N         ", "                                 ", "         N   N     N   N         ", "         bCCCb     bCCCb         ", "  s     sbbbbbNNsNNbbbbbs     s  ", "NbbbN NbbNCCCb     bCCCNbbN NbbbN", " CbC   CbC   N     N   CbC   CbC ", " CbC   CbC             CbC   CbC ", " CbC   CbC             CbC   CbC ", "NbbbN NbbbN           NbbbN NbbbN", " NNN   NNN             NNN   NNN ", " NNN   NNN             NNN   NNN ", "  s     s               s     s  ", " NNN   NNN             NNN   NNN ", " NNN   NNN             NNN   NNN ", "NbbbN NbbbN           NbbbN NbbbN", " CbC   CbC             CbC   CbC ", " CbC   CbC             CbC   CbC ", " CbC   CbC             CbC   CbC ", "NbbbN NbbbNNNNNsNsNNNNNbbbN NbbbN"}, {" NNN   NNN   N     N   NNN   NNN ", "NbbbN NbbNCCCb     bCCCNbbN NbbbN", "NbbbN NbbNCCCb     bCCCNbbN NbbbN", "NbbbNNNbbNCCCb     bCCCNbbNNNbbbN", " NNN   NNN   N     N   NNN   NNN ", "   N   N                 N   N   ", " NNN   NNN   N     N   NNN   NNN ", "NbbbNNNbbNCCCb     bCCCNbbNNNbbbN", "NbbbN NbbNCCCb     bCCCNbbN NbbbN", "NNNN   NNNCCCb     bCCCNNN   NNNN", " CCC   CCC   N     N   CCC   CCC ", " CCC   CCC             CCC   CCC ", " CCC   CCC             CCC   CCC ", "NbbbN NbbbN           NbbbN NbbbN", "  N     N               N     N  ", "  N     N               N     N  ", "                                 ", "  N     N               N     N  ", "  N     N               N     N  ", "NbbbN NbbbN           NbbbN NbbbN", " CCC   CCC             CCC   CCC ", " CCC   CCC             CCC   CCC ", " CCC   CCC             CCC   CCC ", "NbbbN NbbbN    NbN    NbbbN NbbbN"}, {"                                 ", " CCC   CCC   N     N   CCC   CCC ", " CbC   CbC   N     N   CbC   CbC ", " CCCCCCCCC   N     N   CCCCCCCCC ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " CCCCCCCCC   N     N   CCCCCCCCC ", " CbC   CbC   N     N   CbC   CbC ", " CCC   CCC   N     N   CCC   CCC ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", " NNN   NNN     NbN     NNN   NNN "}, {"                                 ", " CCC   CCC             CCC   CCC ", " CbC   CbC             CbC   CbC ", " CCCCCCCCC             CCCCCCCCC ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " CCCCCCCCC             CCCCCCCCC ", " CbC   CbC             CbC   CbC ", " CCC   CCC             CCC   CCC ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  N     N      NbN      N     N  "}, {"                                 ", " CCC   CCC             CCC   CCC ", " CbC   CbC             CbC   CbC ", " CCCCCCCCC             CCCCCCCCC ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " CCCCCCCCC             CCCCCCCCC ", " CbC   CbC             CbC   CbC ", " CCC   CCC             CCC   CCC ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  N     N      NbN      N     N  "}, {" NNN   NNN             NNN   NNN ", "NbbbN NbbbN           NbbbN NbbbN", "NbbbN NbbbN           NbbbN NbbbN", "NbbbNNNbbbN           NbbbNNNbbbN", " NNN   NNN             NNN   NNN ", "   N   N                 N   N   ", " NNN   NNN             NNN   NNN ", "NbbbNNNbbbN           NbbbNNNbbbN", "NbbbN NbbbN           NbbbN NbbbN", "NbbbN NbbbN           NbbbN NbbbN", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  N     N     NsNsN     N     N  "}, {"                                 ", "                                 ", "  N     N               N     N  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  N     N               N     N  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  N     N    NbbbbbN    N     N  "}, {"                                 ", "                                 ", "  N     N               N     N  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  N     N               N     N  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                N                ", " NsNNNNNsNNNNsbbbbbsNNNNsNNNNNsN "}, {"                                 ", "                                 ", "  s     s               s     s  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  s     s               s     s  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                ~                ", "               NNN               ", "  NbbbbbNbbbbNbbbbbNbbbbNbbbbbN  "}, {"                                 ", "                                 ", "  N     N               N     N  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  N     N               N     N  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                N                ", " NsNNNNNsNNNNsbbbbbsNNNNsNNNNNsN "}, {"                                 ", "                                 ", "  N     N               N     N  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  N     N               N     N  ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  N     N    NbbbbbN    N     N  "}, {" NNN   NNN             NNN   NNN ", "NbbbN NbbbN           NbbbN NbbbN", "NbbbN NbbbN           NbbbN NbbbN", "NbbbNNNbbbN           NbbbNNNbbbN", " NNN   NNN             NNN   NNN ", "   N   N                 N   N   ", " NNN   NNN             NNN   NNN ", "NbbbNNNbbbN           NbbbNNNbbbN", "NbbbN NbbbN           NbbbN NbbbN", "NbbbN NbbbN           NbbbN NbbbN", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  N     N     NsNsN     N     N  "}, {"                                 ", " CCC   CCC             CCC   CCC ", " CbC   CbC             CbC   CbC ", " CCCCCCCCC             CCCCCCCCC ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " CCCCCCCCC             CCCCCCCCC ", " CbC   CbC             CbC   CbC ", " CCC   CCC             CCC   CCC ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  N     N      NbN      N     N  "}, {"                                 ", " CCC   CCC             CCC   CCC ", " CbC   CbC             CbC   CbC ", " CCCCCCCCC             CCCCCCCCC ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " CCCCCCCCC             CCCCCCCCC ", " CbC   CbC             CbC   CbC ", " CCC   CCC             CCC   CCC ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "  N     N      NbN      N     N  "}, {"                                 ", " CCC   CCC   N     N   CCC   CCC ", " CbC   CbC   N     N   CbC   CbC ", " CCCCCCCCC   N     N   CCCCCCCCC ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " CCCCCCCCC   N     N   CCCCCCCCC ", " CbC   CbC   N     N   CbC   CbC ", " CCC   CCC   N     N   CCC   CCC ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", " NNN   NNN     NbN     NNN   NNN "}, {" NNN   NNN   N     N   NNN   NNN ", "NbbbN NbbNCCCb     bCCCNbbN NbbbN", "NbbbN NbbNCCCb     bCCCNbbN NbbbN", "NbbbNNNbbNCCCb     bCCCNbbNNNbbbN", " NNN   NNN   N     N   NNN   NNN ", "   N   N                 N   N   ", " NNN   NNN   N     N   NNN   NNN ", "NbbbNNNbbNCCCb     bCCCNbbNNNbbbN", "NbbbN NbbNCCCb     bCCCNbbN NbbbN", "NNNN   NNNCCCb     bCCCNNN   NNNN", " CCC   CCC   N     N   CCC   CCC ", " CCC   CCC             CCC   CCC ", " CCC   CCC             CCC   CCC ", "NbbbN NbbbN           NbbbN NbbbN", "  N     N               N     N  ", "  N     N               N     N  ", "                                 ", "  N     N               N     N  ", "  N     N               N     N  ", "NbbbN NbbbN           NbbbN NbbbN", " CCC   CCC             CCC   CCC ", " CCC   CCC             CCC   CCC ", " CCC   CCC             CCC   CCC ", "NbbbN NbbbN    NbN    NbbbN NbbbN"}, {"         N   N     N   N         ", "         bCCCb     bCCCb         ", "  N     sbbbbbNNsNNbbbbbs     N  ", "         bCCCb     bCCCb         ", "         N   N     N   N         ", "                                 ", "         N   N     N   N         ", "         bCCCb     bCCCb         ", "  s     sbbbbbNNsNNbbbbbs     s  ", "NbbbN NbbNCCCb     bCCCNbbN NbbbN", " CbC   CbC   N     N   CbC   CbC ", " CbC   CbC             CbC   CbC ", " CbC   CbC             CbC   CbC ", "NbbbN NbbbN           NbbbN NbbbN", " NNN   NNN             NNN   NNN ", " NNN   NNN             NNN   NNN ", "  s     s               s     s  ", " NNN   NNN             NNN   NNN ", " NNN   NNN             NNN   NNN ", "NbbbN NbbbN           NbbbN NbbbN", " CbC   CbC             CbC   CbC ", " CbC   CbC             CbC   CbC ", " CbC   CbC             CbC   CbC ", "NbbbN NbbbNNNNNsNsNNNNNbbbN NbbbN"}, {"         N   N     N   N         ", "         bCCCb     bCCCb         ", "  N      bCCCb     bCCCb      N  ", "         bCCCb     bCCCb         ", "         NCCCN     NCCCN         ", "         NCCCN     NCCCN         ", "         NCCCN     NCCCN         ", "         bCCCb     bCCCb         ", "         bCCCb     bCCCb         ", "NbbbNNNbbNCCCb     bCCCNbbNNNbbbN", " CCCCCCCCC   N     N   CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", "NbbbNNNbbbN           NbbbNNNbbbN", "  N     N               N     N  ", "  N     N               N     N  ", "                                 ", "  N     N               N     N  ", "  N     N               N     N  ", "NbbbNNNbbbN           NbbbNNNbbbN", " CCCCCCCCC             CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", "NbbbNNNbbbN    NbN    NbbbNNNbbbN"}, {"                                 ", "         N   N     N   N         ", "  N      N   N     N   N      N  ", "         NCCCN     NCCCN         ", "                                 ", "                                 ", "                                 ", "         NCCCN     NCCCN         ", "         N   N     N   N         ", " NNN   NN    N     N    NN   NNN ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " NNN   NNN     NbN     NNN   NNN "}, {"                                 ", "                                 ", "   s                         s   ", "  s      NCCCN     NCCCN      s  ", "                                 ", "                                 ", "                                 ", "         NCCCN     NCCCN         ", "                                 ", "   N   N                 N   N   ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   N   N                 N   N   ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", "   N   N                 N   N   ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   N   N       NbN       N   N   "}, {"                                 ", "         N   N     N   N         ", "   s     N   N     N   N     s   ", "  s      NCCCN     NCCCN      s  ", "                                 ", "                                 ", "                                 ", "         NCCCN     NCCCN         ", "         N   N     N   N         ", " NNN   NN    N     N    NN   NNN ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN ", "   C   C                 C   C   ", "   C   C                 C   C   ", "   C   C                 C   C   ", " NNN   NNN     NbN     NNN   NNN "}, {"         N   N     N   N         ", "         bCCCb     bCCCb         ", "    ss   bCCCb     bCCCb   ss    ", "         bCCCb     bCCCb         ", "  s      NCCCN     NCCCN      s  ", "  s      NCCCN     NCCCN      s  ", "         NCCCN     NCCCN         ", "         bCCCb     bCCCb         ", "         bCCCb     bCCCb         ", "NbbbNNNbbNCCCb     bCCCNbbNNNbbbN", " CCCCCCCCC   N     N   CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", "NbbbNNNbbbN           NbbbNNNbbbN", "  N     N               N     N  ", "  N     N               N     N  ", "                                 ", "  N     N               N     N  ", "  N     N               N     N  ", "NbbbNNNbbbN           NbbbNNNbbbN", " CCCCCCCCC             CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", " CCCCCCCCC             CCCCCCCCC ", "NbbbNNNbbbN    NbN    NbbbNNNbbbN"}, {"         N   N     N   N         ", "         bCCCb     bCCCb         ", "      NNNbbbbbNNsNNbbbbbNNN      ", "    ss   bCCCb     bCCCb   ss    ", "   s     N   N     N   N     s   ", "   s                         s   ", "  N      N   N     N   N      N  ", "  N      bCCCb     bCCCb      N  ", "  N     sbbbbbNNsNNbbbbbs     N  ", "NbbbN NbbNCCCb     bCCCNbbN NbbbN", " CbC   CbC   N     N   CbC   CbC ", " CbC   CbC             CbC   CbC ", " CbC   CbC             CbC   CbC ", "NbbbN NbbbN           NbbbN NbbbN", " NNN   NNN             NNN   NNN ", " NNN   NNN             NNN   NNN ", "  s     s               s     s  ", " NNN   NNN             NNN   NNN ", " NNN   NNN             NNN   NNN ", "NbbbN NbbbN           NbbbN NbbbN", " CbC   CbC             CbC   CbC ", " CbC   CbC             CbC   CbC ", " CbC   CbC             CbC   CbC ", "NbbbN NbbbNNNNNsNsNNNNNbbbN NbbbN"}, {"         N   N     N   N         ", "         bCCCb     bCCCb         ", "         bCCCb     bCCCb         ", "         bCCCb     bCCCb         ", "         N   N     N   N         ", "                                 ", "         N   N     N   N         ", "         bCCCb     bCCCb         ", "         bCCCb     bCCCb         ", "NbbbN NbbNCCCb     bCCCNbbN NbbbN", " CCC   CCC   N     N   CCC   CCC ", " CCC   CCC             CCC   CCC ", " CCC   CCC             CCC   CCC ", "NbbbN NbbbN           NbbbN NbbbN", "  N     N               N     N  ", "  N     N               N     N  ", "                                 ", "  N     N               N     N  ", "  N     N               N     N  ", "NbbbN NbbbN           NbbbN NbbbN", " CCC   CCC             CCC   CCC ", " CCC   CCC             CCC   CCC ", " CCC   CCC             CCC   CCC ", "NbbbN NbbbN    N N    NbbbN NbbbN"}, {"                                 ", "         N   N     N   N         ", "         N   N     N   N         ", "         N   N     N   N         ", "                                 ", "                                 ", "                                 ", "         N   N     N   N         ", "         N   N     N   N         ", " NNN   NNN   N     N   NNN   NNN ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN ", "                                 ", "                                 ", "                                 ", " NNN   NNN             NNN   NNN "}};
        STRUCTURE_DEFINITION = null;
    }

    static class MaterialConsumption {
        public int parallelism = 1;
        Map<TST_ItemID, Double> originalRatio = new HashMap<TST_ItemID, Double>();
        Map<TST_ItemID, Double> actualRatio = new HashMap<TST_ItemID, Double>();
        List<ItemStack> materialToBeConsumed = new ArrayList<ItemStack>();
        ItemStack fuelToBeConsumed;

        MaterialConsumption() {
        }
    }
}

