/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.machine;

import com.Nxer.TwistSpaceTechnology.common.machine.ValueEnum;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.GTCM_MultiMachineBase;
import com.Nxer.TwistSpaceTechnology.common.machine.multiMachineClasses.processingLogics.TstProcessingLogic;
import com.Nxer.TwistSpaceTechnology.util.TextLocalization;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings8;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class GT_TileEntity_MagneticDomainConstructor
extends GTCM_MultiMachineBase<GT_TileEntity_MagneticDomainConstructor> {
    private int rings = 1;
    private final int baseHorizontalOffSet = 7;
    private final int baseVerticalOffSet = 15;
    private final int baseDepthOffSet = 0;
    private static final String STRUCTURE_PIECE_MAIN = "mainMagneticDomainConstructor";
    private static final String STRUCTURE_PIECE_MIDDLE = "middleMagneticDomainConstructor";
    private static final String STRUCTURE_PIECE_END = "endMagneticDomainConstructor";
    private static IStructureDefinition<GT_TileEntity_MagneticDomainConstructor> STRUCTURE_DEFINITION = null;
    private final String[][] shapeMain = new String[][]{{"               ", "               ", "               ", "               ", "               ", "      DDD      ", "     DEEED     ", "     DEEED     ", "     DEEED     ", "      DDD      ", "      FDF      ", "      FDF      ", "      FDF      ", "      FDF      ", "      FDF      ", "      D~D      ", "     DDDDD     "}, {"               ", "      BBB      ", "    BB   BB    ", "   B       B   ", "  B         B  ", "  B         B  ", " B     C     B ", " B    CCC    B ", " B     C     B ", "  B         B  ", "  B         B  ", "   B       B   ", "   FBB   BBF   ", "  F   BBB   F  ", " F    DDD    F ", "F     DDD     F", "DDDDDDDDDDDDDDD"}, {"      BBB      ", "    BBAAABB    ", "   BAAGGGAAB   ", "  BAGG   GGAB  ", " BAG       GAB ", " BAG       GAB ", "BAG    C    GAB", "BAG   CCC   GAB", "BAG    C    GAB", " BAG       GAB ", " BAG       GAB ", "  BAGG   GGAB  ", "   BAAGGGAAB   ", "    BBAAABB    ", "      BBB      ", "DDDDDDDDDDDDDDD", "DDDDDDDDDDDDDDD"}, {"               ", "      BBB      ", "    BB   BB    ", "   B       B   ", "  B         B  ", "  B         B  ", " B     C     B ", " B    CCC    B ", " B     C     B ", "  B         B  ", "  B         B  ", "   B       B   ", "   FBB   BBF   ", "  F   BBB   F  ", " F    DDD    F ", "F     DDD     F", "DDDDDDDDDDDDDDD"}};
    private final String[][] shapeMiddle = new String[][]{{"               ", "               ", "               ", "               ", "               ", "               ", "       C       ", "      CCC      ", "       C       ", "               ", "               ", "               ", "               ", "               ", "      DDD      ", "      DDD      ", "     DDDDD     "}, {"               ", "      BBB      ", "    BB   BB    ", "   B       B   ", "  B         B  ", "  B         B  ", " B     C     B ", " B    CCC    B ", " B     C     B ", "  B         B  ", "  B         B  ", "   B       B   ", "   FBB   BBF   ", "  F   BBB   F  ", " F    DDD    F ", "F     DDD     F", "DDDDDDDDDDDDDDD"}, {"      BBB      ", "    BBAAABB    ", "   BAAGGGAAB   ", "  BAGG   GGAB  ", " BAG       GAB ", " BAG       GAB ", "BAG    C    GAB", "BAG   CCC   GAB", "BAG    C    GAB", " BAG       GAB ", " BAG       GAB ", "  BAGG   GGAB  ", "   BAAGGGAAB   ", "    BBAAABB    ", "      BBB      ", "DDDDDDDDDDDDDDD", "DDDDDDDDDDDDDDD"}, {"               ", "      BBB      ", "    BB   BB    ", "   B       B   ", "  B         B  ", "  B         B  ", " B     C     B ", " B    CCC    B ", " B     C     B ", "  B         B  ", "  B         B  ", "   B       B   ", "   FBB   BBF   ", "  F   BBB   F  ", " F    DDD    F ", "F     DDD     F", "DDDDDDDDDDDDDDD"}};
    private final String[][] shapeEnd = new String[][]{{"               ", "               ", "               ", "               ", "               ", "      DDD      ", "     DOOOD     ", "     DOOOD     ", "     DOOOD     ", "      DDD      ", "      FDF      ", "      FDF      ", "      FDF      ", "      FDF      ", "      FDF      ", "      DDD      ", "     DDDDD     "}};

    public GT_TileEntity_MagneticDomainConstructor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MagneticDomainConstructor(String aName) {
        super(aName);
    }

    @Override
    public int totalMachineMode() {
        return 2;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_SEPARATOR);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_POLARIZER);
    }

    @Override
    public String getMachineModeName(int mode) {
        return StatCollector.func_74838_a((String)("MagneticDomainConstructor.modeMsg." + mode));
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mode", (byte)this.machineMode);
        aNBT.func_74768_a("rings", this.rings);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.machineMode = aNBT.func_74771_c("mode");
        this.rings = aNBT.func_74762_e("rings");
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new TstProcessingLogic(){

            @NotNull
            public CheckRecipeResult process() {
                this.setSpeedBonus(GT_TileEntity_MagneticDomainConstructor.this.getSpeedBonus());
                return super.process();
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    protected boolean isEnablePerfectOverclock() {
        return false;
    }

    public RecipeMap<?> getRecipeMap() {
        return this.machineMode == 1 ? RecipeMaps.polarizerRecipes : RecipeMaps.electroMagneticSeparatorRecipes;
    }

    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.polarizerRecipes, RecipeMaps.electroMagneticSeparatorRecipes);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.repairMachine();
        this.rings = 1;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 15, 0)) {
            return false;
        }
        while (this.checkPiece(STRUCTURE_PIECE_MIDDLE, 7, 15, 0 - this.rings * 4)) {
            ++this.rings;
        }
        if (!this.checkPiece(STRUCTURE_PIECE_END, 7, 15, 0 - this.rings * 4)) {
            return false;
        }
        this.maxParallel = (int)Math.min((long)this.rings * (long)ValueEnum.Parallel_PerRing_MagneticDomainConstructor, Integer.MAX_VALUE);
        this.speedBonus = (float)Math.pow(ValueEnum.SpeedBonus_MultiplyPerTier_MagneticDomainConstructor, this.getTotalPowerTier());
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int Ring = stackSize.field_77994_a;
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 7, 15, 0);
        if (Ring > 1) {
            for (int pointer = 1; pointer < Ring; ++pointer) {
                this.buildPiece(STRUCTURE_PIECE_MIDDLE, stackSize, hintsOnly, 7, 15, 0 - pointer * 4);
            }
        }
        this.buildPiece(STRUCTURE_PIECE_END, stackSize, hintsOnly, 7, 15, 0 - Ring * 4);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int[] built = new int[stackSize.field_77994_a + 2];
        built[0] = this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 7, 15, 0, elementBudget, env, false, true);
        int ring = stackSize.field_77994_a;
        if (ring > 1) {
            for (int pointer = 1; pointer < ring; ++pointer) {
                built[pointer] = this.survivialBuildPiece(STRUCTURE_PIECE_MIDDLE, stackSize, 7, 15, 0 - pointer * 4, elementBudget, env, false, true);
            }
        }
        built[ring + 1] = this.survivialBuildPiece(STRUCTURE_PIECE_END, stackSize, 7, 15, 0 - ring * 4, elementBudget, env, false, true);
        return TstUtils.multiBuildPiece(built);
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return super.addToMachineList(aTileEntity, aBaseCasingIndex) || this.addExoticEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public IStructureDefinition<GT_TileEntity_MagneticDomainConstructor> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, this.shapeMain).addShape(STRUCTURE_PIECE_MIDDLE, this.shapeMiddle).addShape(STRUCTURE_PIECE_END, this.shapeEnd).addElement('A', StructureUtility.ofBlock((Block)Loaders.compactFusionCoil, (int)0)).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)8)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)7)).addElement('D', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.Energy.or((IHatchElement)HatchElement.ExoticEnergy)}).adder(GT_TileEntity_MagneticDomainConstructor::addToMachineList).dot(1).casingIndex(((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(10)).buildAndChain(GregTechAPI.sBlockCasings8, 10)).addElement('E', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.InputBus, HatchElement.InputHatch}).adder(GT_TileEntity_MagneticDomainConstructor::addToMachineList).dot(2).casingIndex(((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(7)).buildAndChain(GregTechAPI.sBlockCasings8, 7)).addElement('O', (IStructureElement)HatchElementBuilder.builder().atLeast(new IHatchElement[]{HatchElement.OutputBus, HatchElement.OutputHatch}).adder(GT_TileEntity_MagneticDomainConstructor::addToMachineList).dot(3).casingIndex(((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(7)).buildAndChain(GregTechAPI.sBlockCasings8, 7)).addElement('F', GTStructureUtility.ofFrame((Materials)Materials.NaquadahAlloy)).addElement('G', GTStructureUtility.ofFrame((Materials)Materials.TengamAttuned)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    @Override
    public String[] getInfoData() {
        String[] origin = super.getInfoData();
        String[] ret = new String[origin.length + 1];
        System.arraycopy(origin, 0, ret, 0, origin.length);
        ret[origin.length] = EnumChatFormatting.AQUA + "Rings: " + EnumChatFormatting.GOLD + this.rings;
        return ret;
    }

    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(TextLocalization.Tooltip_MagneticDomainConstructor_MachineType).addInfo(TextLocalization.Tooltip_MagneticDomainConstructor_00).addInfo(TextLocalization.Tooltip_MagneticDomainConstructor_01).addInfo(TextLocalization.Tooltip_MagneticDomainConstructor_02).addInfo(TextLocalization.Tooltip_MagneticDomainConstructor_03).addInfo(TextLocalization.Tooltip_MagneticDomainConstructor_04).addInfo(TextLocalization.textScrewdriverChangeMode).addSeparator().addInfo(TextLocalization.StructureTooComplex).addInfo(TextLocalization.BLUE_PRINT_INFO).addInputHatch(TextLocalization.textUseBlueprint, new int[]{2}).addOutputHatch(TextLocalization.textUseBlueprint, new int[]{3}).addInputBus(TextLocalization.textUseBlueprint, new int[]{2}).addOutputBus(TextLocalization.textUseBlueprint, new int[]{3}).addEnergyHatch(TextLocalization.textUseBlueprint, new int[]{1}).toolTipFinisher(new String[]{"Twist Space Technology"});
        return tt;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_MagneticDomainConstructor(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GTUtility.getCasingTextureIndex((Block)GregTechAPI.sBlockCasings8, (int)10)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GTUtility.getCasingTextureIndex((Block)GregTechAPI.sBlockCasings8, (int)10)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GTUtility.getCasingTextureIndex((Block)GregTechAPI.sBlockCasings8, (int)10))};
    }
}

