/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.item;

import com.Nxer.TwistSpaceTechnology.TwistSpaceTechnology;
import com.Nxer.TwistSpaceTechnology.client.TstCreativeTabs;
import com.Nxer.TwistSpaceTechnology.common.init.TstBlocks;
import com.Nxer.TwistSpaceTechnology.util.TextEnums;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gregtech.api.GregTechAPI;
import gregtech.api.damagesources.GTDamageSources;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import ic2.api.item.IElectricItem;
import ic2.core.init.InternalName;
import ic2.core.item.armor.ItemArmorElectric;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public class ItemCardigan
extends ItemArmorElectric
implements IElectricItem {
    private static final double[] TIERED_MAX_CHARGE = new double[]{60000.0, 600000.0, 2000000.0, 2.0E7};
    private static final double[] TIERED_TRANSFER_LIMIT = new double[]{100.0, 1000.0, 1000.0, 5000.0};
    private static final int MULTIPLIER_SPRINTING = 20;
    private static final int MULTIPLIER_RUBBING_CATS = 40;
    private static final int MULTIPLIER_RUBBING_SHEEP = 30;
    private static final int MULTIPLIER_RUBBING_WOOLS = 25;
    private static boolean CARDIGAN_DEBUG_MODE = Boolean.getBoolean("cardigan_debug_mode");
    public static final InternalName Cardigan = Objects.requireNonNull(InternalName.valueOf((String)"Cardigan"), "Failed to get InternalName instance for Cardigan!");
    public static ItemStack CardiganULV;
    public static ItemStack CardiganLV;
    public static ItemStack CardiganMV;
    public static ItemStack CardiganHV;
    public static ItemStack CardiganHV_Charged;
    public static final Map<UUID, Integer> CHARGE_COOLDOWN_MAP;
    public static final int CHARGE_COOLDOWN_TICK = 200;

    public ItemCardigan() {
        super(Cardigan, Cardigan, 1, TIERED_MAX_CHARGE[0], TIERED_TRANSFER_LIMIT[0], 0);
        this.func_77655_b("chestplateCardigan");
        this.func_77637_a(TstCreativeTabs.TabGeneral);
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public double getDamageAbsorptionRatio() {
        return 0.0;
    }

    public int getEnergyPerDamage() {
        return 0;
    }

    public int getTier(ItemStack itemStack) {
        return ItemCardigan.getCardiganTier(itemStack);
    }

    public static int getCardiganTier(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        int tier = tag.func_74762_e("cardiganTier");
        return tier >= 0 && tier < TIERED_MAX_CHARGE.length ? tier : 0;
    }

    public void setCardiganTier(ItemStack itemStack, int tier) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74768_a("cardiganTier", tier);
        itemStack.func_77982_d(tag);
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        CardiganULV = new ItemStack((Item)this, 1, this.func_77612_l());
        this.setCardiganTier(CardiganULV, 0);
        itemList.add(CardiganULV);
        CardiganLV = new ItemStack((Item)this, 1, this.func_77612_l());
        this.setCardiganTier(CardiganLV, 1);
        itemList.add(CardiganLV);
        CardiganMV = new ItemStack((Item)this, 1, this.func_77612_l());
        this.setCardiganTier(CardiganMV, 2);
        itemList.add(CardiganMV);
        CardiganHV = new ItemStack((Item)this, 1, this.func_77612_l());
        this.setCardiganTier(CardiganHV, 3);
        itemList.add(CardiganHV);
        CardiganHV_Charged = new ItemStack((Item)this, 1, this.func_77612_l());
        this.setCardiganTier(CardiganHV_Charged, 3);
        GTModHandler.chargeElectricItem((ItemStack)CardiganHV_Charged, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (boolean)true, (boolean)false);
        itemList.add(CardiganHV_Charged);
    }

    public double getMaxCharge(ItemStack itemStack) {
        return TIERED_MAX_CHARGE[ItemCardigan.getCardiganTier(itemStack)];
    }

    public double getTransferLimit(ItemStack itemStack) {
        return TIERED_TRANSFER_LIMIT[ItemCardigan.getCardiganTier(itemStack)];
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        this.addInformationTypeChecked(itemStack, info);
    }

    private void addInformationTypeChecked(ItemStack itemStack, List<String> tooltips) {
        int tier = ItemCardigan.getCardiganTier(itemStack);
        tooltips.add(EnumChatFormatting.GRAY + "Tier: " + GTUtility.getColoredTierNameFromTier((byte)((byte)tier)));
        Optional chargeOptional = GTModHandler.getElectricItemCharge((ItemStack)itemStack);
        if (chargeOptional.isPresent()) {
            Long current = ((Long[])chargeOptional.get())[0];
            Long max = ((Long[])chargeOptional.get())[1];
            String s = StatCollector.func_74837_a((String)"tst.cardigan.tooltip.power", (Object[])new Object[]{GTUtility.formatNumbers((long)current), GTUtility.formatNumbers((long)max)});
            tooltips.add(s);
        } else {
            tooltips.add(StatCollector.func_74838_a((String)"tst.cardigan.tooltip.error"));
        }
        if (tier == 0) {
            tooltips.add(StatCollector.func_74838_a((String)"tst.cardigan.tooltip.ulv"));
        }
        tooltips.add(StatCollector.func_74838_a((String)"tst.cardigan.tooltip.1"));
        tooltips.add(StatCollector.func_74838_a((String)"tst.cardigan.tooltip.2"));
        tooltips.add(StatCollector.func_74838_a((String)"tst.cardigan.tooltip.3"));
        tooltips.add(StatCollector.func_74838_a((String)"tst.cardigan.tooltip.4"));
        tooltips.add(TextEnums.Author_Taskeren.toString());
        tooltips.add(TextEnums.AddByTwistSpaceTechnology.toString());
    }

    public String func_77658_a() {
        return "item." + this.field_77774_bZ;
    }

    public String func_77667_c(ItemStack itemStack) {
        return "item." + this.field_77774_bZ + "." + ItemCardigan.getCardiganTier(itemStack);
    }

    public String func_77653_i(ItemStack itemStack) {
        return StatCollector.func_74838_a((String)(this.func_77667_c(itemStack) + ".name")).trim();
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("gtnhcommunitymod:Cardigan");
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "gtnhcommunitymod:textures/armor/Cardigan_1.png";
    }

    public static boolean isCardigan(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() instanceof ItemCardigan;
    }

    public static int getChargeBase(ItemStack cardiganStack) {
        int n;
        if (!ItemCardigan.isCardigan(cardiganStack)) {
            return -1;
        }
        switch (ItemCardigan.getCardiganTier(cardiganStack)) {
            case 0: {
                n = 2;
                break;
            }
            case 1: {
                n = 32;
                break;
            }
            case 2: {
                n = 256;
                break;
            }
            case 3: {
                n = 1024;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private static boolean checkCooldown(EntityPlayer player) {
        int tickNow = MinecraftServer.func_71276_C().func_71259_af();
        return !CHARGE_COOLDOWN_MAP.containsKey(player.func_110124_au()) || tickNow > CHARGE_COOLDOWN_MAP.get(player.func_110124_au());
    }

    private static void tryCharge(EntityPlayer player, ItemStack cardiganStack, int value) {
        int tickNow = MinecraftServer.func_71276_C().func_71259_af();
        int charged = GTModHandler.chargeElectricItem((ItemStack)cardiganStack, (int)value, (int)Integer.MAX_VALUE, (boolean)true, (boolean)false);
        if (charged > 0) {
            CHARGE_COOLDOWN_MAP.put(player.func_110124_au(), tickNow + 200);
            TwistSpaceTechnology.LOG.info("Charged: {}", new Object[]{charged});
        }
    }

    private static int discharge(ItemStack cardiganStack, int value) {
        return GTModHandler.dischargeElectricItem((ItemStack)cardiganStack, (int)value, (int)Integer.MAX_VALUE, (boolean)false, (boolean)false, (boolean)true);
    }

    private static void applyElectricDamage(Entity target, float damage) {
        target.func_70097_a(GTDamageSources.getElectricDamage(), damage);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.player;
        if (ItemCardigan.checkCooldown(player)) {
            for (ItemStack armorStack : player.field_71071_by.field_70460_b) {
                if (armorStack == null || !ItemCardigan.isCardigan(armorStack)) continue;
                if (player.func_70051_ag()) {
                    ItemCardigan.tryCharge(player, armorStack, ItemCardigan.getChargeBase(armorStack) * 20);
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRubbingEntity(EntityInteractEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        for (ItemStack armorStack : player.field_71071_by.field_70460_b) {
            if (armorStack == null || !ItemCardigan.isCardigan(armorStack)) continue;
            Entity target = event.target;
            if (ItemCardigan.checkCooldown(player)) {
                if (target instanceof EntityOcelot) {
                    ItemCardigan.tryCharge(player, armorStack, ItemCardigan.getChargeBase(armorStack) * 40);
                } else if (target instanceof EntitySheep) {
                    ItemCardigan.tryCharge(player, armorStack, ItemCardigan.getChargeBase(armorStack) * 30);
                }
            }
            if (target instanceof EntityPlayer) {
                EntityPlayer targetPlayer = (EntityPlayer)target;
                ItemCardigan.discharge(armorStack, 10);
                ItemCardigan.applyElectricDamage((Entity)player, Math.min(player.func_110143_aJ() - 1.0f, 6.0f));
                ItemCardigan.applyElectricDamage((Entity)targetPlayer, 4.0f);
            }
            return;
        }
    }

    @SubscribeEvent
    public static void onPlayerRubbingBlock(PlayerInteractEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        for (ItemStack armorStack : player.field_71071_by.field_70460_b) {
            TileEntity te;
            int discharge;
            if (armorStack == null || !ItemCardigan.isCardigan(armorStack)) continue;
            World world = event.world;
            Block target = world.func_147439_a(event.x, event.y, event.z);
            if (target == Blocks.field_150348_b && (discharge = ItemCardigan.discharge(armorStack, 1000)) > 0 && (CARDIGAN_DEBUG_MODE || world.field_73012_v.nextInt(10) > 8)) {
                ItemCardigan.applyElectricDamage((Entity)player, Math.min(player.func_110143_aJ() - 1.0f, 4.0f));
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("tst.cardigan.ouch", new Object[0]));
            }
            if (target == TstBlocks.BlockPowerChair) {
                ItemCardigan.tryCharge(player, armorStack, Integer.MAX_VALUE);
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("tst.cardigan.powah", new Object[0]));
            }
            if (target == GregTechAPI.sBlockMachines && (te = world.func_147438_o(event.x, event.y, event.z)) != null && te instanceof BaseMetaTileEntity) {
                BaseMetaTileEntity bmte = (BaseMetaTileEntity)te;
                IMetaTileEntity mte = bmte.getMetaTileEntity();
                if (mte instanceof MTEBasicMachine) {
                    byte targetTier;
                    MTEBasicMachine basicMachine = (MTEBasicMachine)mte;
                    int tier = ItemCardigan.getCardiganTier(armorStack);
                    if (tier > (targetTier = basicMachine.mTier) && (CARDIGAN_DEBUG_MODE || world.field_73012_v.nextInt(100) == 99)) {
                        bmte.doExplosion(GTValues.V[basicMachine.mTier]);
                    }
                }
                if (mte instanceof MTEMultiBlockBase) {
                    MTEMultiBlockBase multiBlockBase = (MTEMultiBlockBase)mte;
                    if (CARDIGAN_DEBUG_MODE || world.field_73012_v.nextInt(100) == 99) {
                        multiBlockBase.causeMaintenanceIssue();
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("tst.cardigan.damageMachine", new Object[0]));
                    }
                }
            }
            if (ItemCardigan.checkCooldown(player) && target == Blocks.field_150325_L) {
                ItemCardigan.tryCharge(player, armorStack, ItemCardigan.getChargeBase(armorStack) * 25);
            }
            return;
        }
    }

    static {
        CHARGE_COOLDOWN_MAP = new HashMap<UUID, Integer>();
    }
}

