/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.block.meta;

import com.Nxer.TwistSpaceTechnology.client.TstCreativeTabs;
import com.Nxer.TwistSpaceTechnology.common.api.IHasVariantAndTooltips;
import com.Nxer.TwistSpaceTechnology.util.TstUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class AbstractTstMetaBlock
extends Block
implements IHasVariantAndTooltips {
    protected final Set<Integer> usedMetaSet = new HashSet<Integer>(16);
    protected final Map<Integer, String[]> tooltipMap = new HashMap<Integer, String[]>();
    protected Map<Integer, IIcon> iconMap = new HashMap<Integer, IIcon>();

    public AbstractTstMetaBlock(String unlocalizedName) {
        this(Material.field_151573_f, unlocalizedName);
    }

    public AbstractTstMetaBlock(Material material, String unlocalizedName) {
        super(material);
        this.func_149663_c(unlocalizedName);
        this.func_149647_a(TstCreativeTabs.TabMetaBlocks);
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.iconMap.get(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.iconMap = this.registerAllVariantIcons(register, meta -> "gtnhcommunitymod:" + this.field_149770_b + "/" + meta);
        this.field_149761_L = this.iconMap.get(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item aItem, CreativeTabs aCreativeTabs, List<ItemStack> list) {
        list.addAll(Arrays.asList(this.getVariants()));
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public int func_149643_k(World aWorld, int aX, int aY, int aZ) {
        return aWorld.func_72805_g(aX, aY, aZ);
    }

    @Override
    public String[] getTooltips(int meta, boolean advanced) {
        return this.tooltipMap.get(meta);
    }

    @Override
    public void setTooltips(int metaValue, @Nullable String[] tooltips, boolean advanced) {
        this.tooltipMap.put(metaValue, tooltips);
    }

    @Override
    public ItemStack getVariant(int meta) throws IllegalArgumentException {
        return AbstractTstMetaBlock.checkAndGetVariant(this, meta, this.usedMetaSet);
    }

    @Override
    public ItemStack[] getVariants() {
        return AbstractTstMetaBlock.getAllVariants(this, this.usedMetaSet);
    }

    @Override
    public ItemStack registerVariant(int meta) throws IllegalArgumentException {
        return AbstractTstMetaBlock.checkAndRegisterVariant(this, meta, this.usedMetaSet);
    }

    @Override
    public @Unmodifiable Set<Integer> getVariantIds() {
        return new HashSet<Integer>(this.usedMetaSet);
    }

    @ApiStatus.Internal
    protected static ItemStack checkAndGetVariant(Block self, int meta, Collection<Integer> allowMetaValues) throws IllegalArgumentException {
        if (allowMetaValues.contains(meta)) {
            return TstUtils.newItemWithMeta(self, meta);
        }
        throw new IllegalArgumentException("Invalid meta value: " + meta);
    }

    @ApiStatus.Internal
    protected static ItemStack checkAndRegisterVariant(Block self, int meta, Collection<Integer> allowMetaValues) throws IllegalArgumentException {
        if (allowMetaValues.contains(meta)) {
            throw new IllegalArgumentException("Meta value already exists: " + meta + " in " + self.func_149739_a() + " (" + self.getClass().getSimpleName() + ")");
        }
        allowMetaValues.add(meta);
        return TstUtils.newItemWithMeta(self, meta);
    }

    @ApiStatus.Internal
    protected static ItemStack[] getAllVariants(Block self, Collection<Integer> allowMetaValues) {
        return (ItemStack[])allowMetaValues.stream().map(m -> TstUtils.newItemWithMeta(self, (int)m)).toArray(ItemStack[]::new);
    }
}

