/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.api;

import com.Nxer.TwistSpaceTechnology.util.rewrites.TST_ItemID;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IAlternativeItem {
    default public boolean containsItem(ItemStack itemStack) {
        return this.containsItem(TST_ItemID.create(itemStack)) || this.containsItem(TST_ItemID.createAsWildcard(itemStack));
    }

    public boolean containsItem(TST_ItemID var1);

    public boolean hasSameMember(IAlternativeItem var1);

    @NotNull
    public String getName();

    @Nullable
    public static IAlternativeItem checkAlternativeItemContaining(Collection<IAlternativeItem> alternativeItems, TST_ItemID itemID) {
        for (IAlternativeItem alternativeItem : alternativeItems) {
            if (!alternativeItem.containsItem(itemID)) continue;
            return alternativeItem;
        }
        return null;
    }

    @Nullable
    public static IAlternativeItem checkAlternativeItemContaining(Collection<IAlternativeItem> alternativeItems, ItemStack itemStack) {
        for (IAlternativeItem alternativeItem : alternativeItems) {
            if (!alternativeItem.containsItem(itemStack)) continue;
            return alternativeItem;
        }
        return null;
    }

    @Nullable
    public static IAlternativeItem checkAlternativeItemContainingFast(Collection<IAlternativeItem> alternativeItems, ItemStack itemStack) {
        return IAlternativeItem.checkAlternativeItemContaining(alternativeItems, TST_ItemID.create(itemStack));
    }
}

