/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.common.TechTree;

import com.Nxer.TwistSpaceTechnology.common.TechTree.TechPool;
import com.Nxer.TwistSpaceTechnology.common.TechTree.Technology;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class TechMap
implements Serializable {
    private HashMap<Integer, Technology> techMap = new HashMap();
    private Integer techId = 0;
    private static HashMap<UUID, TechMap> playerTeamTechMap = new HashMap();

    public void addTech(Technology tech) {
        Integer n = this.techId;
        this.techId = this.techId + 1;
        tech.id = this.techId;
        this.techMap.put(this.techId, tech);
    }

    public void addDependency(Integer tech, Integer dependency) {
        if (this.checkLoop(tech, dependency)) {
            return;
        }
        this.techMap.get(tech).setDependency(dependency);
    }

    public void addDependency(Technology tech, Technology dependency) {
        this.addDependency(tech.id, dependency.id);
    }

    public boolean checkValid(Integer tech) {
        for (Integer dependency : this.techMap.get((Object)tech).dependency) {
            if (this.techMap.get((Object)dependency).isResearched) continue;
            return false;
        }
        return true;
    }

    public boolean checkLoop(Integer tech, Integer dependency) {
        for (Integer preDependency : this.techMap.get((Object)dependency).dependency) {
            if (!Objects.equals(preDependency, tech) && !this.checkLoop(tech, preDependency)) continue;
            return true;
        }
        return false;
    }

    public static void initTechMap(EntityPlayer aPlayer) {
        UUID uuid = aPlayer.func_110124_au();
        if (playerTeamTechMap.containsKey(uuid)) {
            return;
        }
        TechMap map = new TechMap();
        for (TechPool tech : TechPool.values()) {
            map.addTech(tech.tech);
        }
        playerTeamTechMap.put(uuid, map);
    }
}

