/*
 * Decompiled with CFR 0.152.
 */
package com.Nxer.TwistSpaceTechnology.client.render;

import com.Nxer.TwistSpaceTechnology.common.tile.TileEyeOfWoodRender;
import com.Nxer.TwistSpaceTechnology.config.Config;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class EyeOfWoodRender
extends TileEntitySpecialRenderer {
    public static final ResourceLocation WOOD_SWEAT_TEXTURE = new ResourceLocation("gtnhcommunitymod:model/Sweat.png");
    public static final IModelCustom WOOD_SWEAT_MODEL = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("gtnhcommunitymod:model/Sweat.obj"));
    public static final ResourceLocation WOOD_THINKING_TEXTURE = new ResourceLocation("gtnhcommunitymod:model/Thinking.png");
    public static final IModelCustom WOOD_THINKING_MODEL = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("gtnhcommunitymod:model/Thinking.obj"));

    public EyeOfWoodRender() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEyeOfWoodRender.class, (TileEntitySpecialRenderer)this);
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        if (!(tile instanceof TileEyeOfWoodRender)) {
            return;
        }
        TileEyeOfWoodRender star = (TileEyeOfWoodRender)tile;
        double teX = tile.field_145851_c;
        double teY = tile.field_145848_d;
        double teZ = tile.field_145849_e;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        double playerX = player.field_70165_t;
        double playerY = player.field_70163_u;
        double playerZ = player.field_70161_v;
        double dx = playerX - (teX + 0.5);
        double dy = playerY - (teY + 0.5);
        double dz = playerZ - (teZ + 0.5);
        double distanceXZ = Math.sqrt(dx * dx + dz * dz);
        double yaw = -Math.atan2(dz, dx) * 57.29577951308232;
        double pitch = Math.atan2(dy, distanceXZ) * 57.29577951308232;
        double size = star.size;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glRotated((double)(yaw + 90.0), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(-pitch), (double)1.0, (double)0.0, (double)0.0);
        this.renderStar(size);
        GL11.glPopMatrix();
    }

    public void renderStar(double size) {
        ResourceLocation texture;
        IModelCustom model;
        switch (Config.RenderModelDefault_EyeOfWood) {
            case 1: {
                model = WOOD_THINKING_MODEL;
                texture = WOOD_THINKING_TEXTURE;
                break;
            }
            default: {
                model = WOOD_SWEAT_MODEL;
                texture = WOOD_SWEAT_TEXTURE;
            }
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_147499_a(texture);
        GL11.glScaled((double)size, (double)size, (double)size);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        model.renderAll();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

