use std::io::Read;

/// Calculate the square of the distance (not the distance itself)
pub fn color_distance(c1: &image::Rgb<u8>, c2: &image::Rgb<u8>) -> usize {
    let x = c1.0[0] as i32 - c2.0[0] as i32;
    let y = c1.0[1] as i32 - c2.0[1] as i32;
    let z = c1.0[2] as i32 - c2.0[2] as i32;
    (x * x + y * y + z * z) as usize
}

pub fn press_any_key_to_continue() {
    let _ = std::io::stdin().read(&mut [0u8]).unwrap();
}
