# Spring Boot 入门案例源码

Spring Boot 入门代码，可以直接下载到本地编辑和使用。

- [spring-boot-hello](https://github.com/ZHENFENG13/spring-boot-projects/tree/master/SpringBoot入门案例源码/spring-boot-helloworld)：Spring Boot 第一个案例代码
- [spring-boot-static-resources](https://github.com/ZHENFENG13/spring-boot-projects/tree/master/SpringBoot入门案例源码/spring-boot-static-resources)：Spring Boot 基础开发之静态资源处理案例
- [spring-boot-ajax](https://github.com/ZHENFENG13/spring-boot-projects/tree/master/SpringBoot入门案例源码/spring-boot-ajax)：Spring Boot 项目实践之 Ajax 技术使用教程
- [spring-boot-jdbc](https://github.com/ZHENFENG13/spring-boot-projects/tree/master/SpringBoot入门案例源码/spring-boot-jdbc)：Spring Boot 连接数据库以及在 Spring Boot 项目中操作数据库
- [spring-boot-mybatis](https://github.com/ZHENFENG13/spring-boot-projects/tree/master/SpringBoot入门案例源码/spring-boot-mybatis)：Spring Boot 整合 MyBatis 操作数据库案例
- [spring-boot-file-upload](https://github.com/ZHENFENG13/spring-boot-projects/tree/master/SpringBoot入门案例源码/spring-boot-file-upload)：Spring Boot 处理文件上传及路径回显
- [spring-boot-RESTful-api](https://github.com/ZHENFENG13/spring-boot-projects/tree/master/SpringBoot入门案例源码/spring-boot-RESTful-api) ：Spring Boot 项目实践之 RESTful API 设计与实现


## 课程介绍

本课程是一个 Spring Boot 技术栈的实战类课程，课程共分为 3 个部分，前面两个部分为基础环境准备和相关概念介绍，第三个部分是 Spring Boot 项目实践开发。Spring Boot 介绍、前后端分离、API 规范等内容旨在让读者更加熟悉 SpringBoot 及企业开发中需要注意的事项并具有使用 SpringBoot 技术进行基本功能开发的能力；最后的项目实战为课程的主要部分，会带着大家实际的开发一个前后端分离的 Spring Boot 实践项目，让大家实际操作并从无到有开发一个线上项目，并学习到一定的开发经验以及其中的开发技巧，旨在让读者具有将 Spring Boot 真正应用于项目开发的能力；

## 课程地址(课程的减免优惠券联系十三进行领取)

- [**项目演示地址:http://lou.springboot.tech/**](http://lou.springboot.tech/)
- [**课程地址:https://www.shiyanlou.com/courses/1244**](https://www.shiyanlou.com/courses/1244)

## 课程的五大特色

- 实践项目页面美观且实用，交互效果完美
- 包含从零搭建项目、功能开发到网站上线的完整流程
- 开发教程详细完整、文档资源齐全
- 代码+讲解+演示网站全方位保证，向 Hello World 教程说拜拜
- 丰富你的开发技术栈，提升个人市场价值

通过本课程你将学到以下内容：

- Spring Boot 2 技术栈的使用和开发技巧；
- MySQL 8 数据库的基本使用方法；
- Maven 的配置及使用；
- SpringBoot 基础 web 功能开发；
- SpringBoot 整合MyBatis；
- SpringBoot 文件上传；
- SpringBoot 全局异常处理；
- 前后端分离详解；
- AJAX 异步技术；
- AdminLTE3、Bootstrap 4、SweetAlert、JqGrid、JQuery 等前端框架组件及控件的使用；
- Swagger 在线 API 文档生成；
- Linux 系统部署及发布项目；
- 上线互联网项目的过程实践。

熟悉我的朋友应该都知道，我在写教程时一般都是“文章”+“源码”+“演示网站”同时提供的，因此在课程完结后，会将源码全部分享给每一位同学用于学习实践，本课程内容主要是抛砖引玉，根据该实践项目中所讲解的技术和开发技巧以及各个单独的功能点实现，可以结合自身业务将其改造成任何企业开发项目。

---

## 交流

> 大家有任何问题或者建议都可以在 [issues](https://github.com/ZHENFENG13/springboot-projects/issues) 中反馈给我，我会慢慢完善这个 Spring Boot 仓库。

- 我的邮箱：2449207463@qq.com
- QQ技术交流群：784785001
