/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import com.google.common.base.Throwables;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;

public final class ByteBufferSupport {
    private static final Method getCleaner;
    private static final Method clean;

    private ByteBufferSupport() {
    }

    public static void unmap(MappedByteBuffer buffer) {
        try {
            Object cleaner = getCleaner.invoke((Object)buffer, new Object[0]);
            clean.invoke(cleaner, new Object[0]);
        }
        catch (Exception ignored) {
            throw Throwables.propagate((Throwable)ignored);
        }
    }

    static {
        try {
            getCleaner = Class.forName("java.nio.DirectByteBuffer").getDeclaredMethod("cleaner", new Class[0]);
            getCleaner.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
        try {
            Class<?> returnType = getCleaner.getReturnType();
            clean = Runnable.class.isAssignableFrom(returnType) ? Runnable.class.getMethod("run", new Class[0]) : returnType.getMethod("clean", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

