/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.Stomp;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompFrameError;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;

public class StompWireFormat
implements WireFormat {
    private static final byte[] NO_DATA = new byte[0];
    private static final byte[] END_OF_FRAME = new byte[]{0, 10};
    private static final int MAX_COMMAND_LENGTH = 1024;
    private static final int MAX_HEADER_LENGTH = 10240;
    private static final int MAX_HEADERS = 1000;
    public static final int MAX_DATA_LENGTH = 0x6400000;
    public static final long DEFAULT_MAX_FRAME_SIZE = Long.MAX_VALUE;
    public static final long DEFAULT_CONNECTION_TIMEOUT = 30000L;
    private int version = 1;
    private int maxDataLength = 0x6400000;
    private long maxFrameSize = Long.MAX_VALUE;
    private String stompVersion = "1.0";
    private long connectionAttemptTimeout = 30000L;
    private final AtomicLong frameSize = new AtomicLong();

    public ByteSequence marshal(Object command) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream((OutputStream)baos);
        this.marshal(command, dos);
        dos.close();
        return baos.toByteSequence();
    }

    public Object unmarshal(ByteSequence packet) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(packet);
        DataInputStream dis = new DataInputStream((InputStream)stream);
        return this.unmarshal(dis);
    }

    private StringBuilder marshalHeaders(StompFrame stomp, StringBuilder buffer) throws IOException {
        buffer.append(stomp.getAction());
        buffer.append("\n");
        for (Map.Entry<String, String> entry : stomp.getHeaders().entrySet()) {
            buffer.append(entry.getKey());
            buffer.append(":");
            buffer.append(this.encodeHeader(entry.getValue()));
            buffer.append("\n");
        }
        buffer.append("\n");
        return buffer;
    }

    public void marshal(Object command, DataOutput os) throws IOException {
        StompFrame stomp = (StompFrame)command;
        if (stomp.getAction().equals("KEEPALIVE")) {
            os.write(10);
            return;
        }
        StringBuilder builder = new StringBuilder();
        os.write(this.marshalHeaders(stomp, builder).toString().getBytes("UTF-8"));
        os.write(stomp.getContent());
        os.write(END_OF_FRAME);
    }

    public String marshalToString(StompFrame stomp) throws IOException {
        if (stomp.getAction().equals("KEEPALIVE")) {
            return String.valueOf('\n');
        }
        StringBuilder buffer = new StringBuilder();
        this.marshalHeaders(stomp, buffer);
        if (stomp.getContent() != null) {
            String contentString = new String(stomp.getContent(), "UTF-8");
            buffer.append(contentString);
        }
        buffer.append('\u0000');
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(DataInput in) throws IOException {
        try {
            String action = this.parseAction(in, this.frameSize);
            HashMap<String, String> headers = this.parseHeaders(in, this.frameSize);
            byte[] data = NO_DATA;
            String contentLength = headers.get("content-length");
            if ((action.equals("SEND") || action.equals("MESSAGE")) && contentLength != null) {
                int length = this.parseContentLength(contentLength, this.frameSize);
                data = new byte[length];
                in.readFully(data);
                if (in.readByte() != 0) {
                    throw new ProtocolException("content-length bytes were read and there was no trailing null byte", true);
                }
            } else {
                byte b;
                ByteArrayOutputStream baos = null;
                while ((b = in.readByte()) != 0) {
                    if (baos == null) {
                        baos = new ByteArrayOutputStream();
                    } else {
                        if (baos.size() > this.getMaxDataLength()) {
                            throw new ProtocolException("The maximum data length was exceeded", true);
                        }
                        if (this.frameSize.incrementAndGet() > this.getMaxFrameSize()) {
                            throw new ProtocolException("The maximum frame size was exceeded", true);
                        }
                    }
                    baos.write((int)b);
                }
                if (baos != null) {
                    baos.close();
                    data = baos.toByteArray();
                }
            }
            StompFrame stompFrame = new StompFrame(action, headers, data);
            return stompFrame;
        }
        catch (ProtocolException e) {
            StompFrameError stompFrameError = new StompFrameError(e);
            return stompFrameError;
        }
        finally {
            this.frameSize.set(0L);
        }
    }

    private String readLine(DataInput in, int maxLength, String errorMessage) throws IOException {
        ByteSequence sequence = this.readHeaderLine(in, maxLength, errorMessage);
        return new String(sequence.getData(), sequence.getOffset(), sequence.getLength(), "UTF-8").trim();
    }

    private ByteSequence readHeaderLine(DataInput in, int maxLength, String errorMessage) throws IOException {
        int lineLength;
        byte b;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(maxLength);
        while ((b = in.readByte()) != 10) {
            if (baos.size() > maxLength) {
                baos.close();
                throw new ProtocolException(errorMessage, true);
            }
            baos.write((int)b);
        }
        baos.close();
        ByteSequence line = baos.toByteSequence();
        if ((this.stompVersion.equals("1.0") || this.stompVersion.equals("1.2")) && (lineLength = line.getLength()) > 0 && line.data[lineLength - 1] == 13) {
            line.setLength(lineLength - 1);
        }
        return line;
    }

    protected String parseAction(DataInput in, AtomicLong frameSize) throws IOException {
        String action = null;
        do {
            if ((action = this.readLine(in, 1024, "The maximum command length was exceeded")) != null) continue;
            throw new IOException("connection was closed");
        } while ((action = action.trim()).length() <= 0);
        frameSize.addAndGet(action.length());
        return action;
    }

    protected HashMap<String, String> parseHeaders(DataInput in, AtomicLong frameSize) throws IOException {
        ByteSequence line;
        HashMap<String, String> headers = new HashMap<String, String>(25);
        while ((line = this.readHeaderLine(in, 10240, "The maximum header length was exceeded")) != null && line.length > 1) {
            if (headers.size() > 1000) {
                throw new ProtocolException("The maximum number of headers was exceeded", true);
            }
            frameSize.addAndGet(line.length);
            try {
                ByteArrayInputStream headerLine = new ByteArrayInputStream(line);
                ByteArrayOutputStream stream = new ByteArrayOutputStream(line.length);
                int result = -1;
                while ((result = headerLine.read()) != -1 && result != 58) {
                    stream.write(result);
                }
                ByteSequence nameSeq = stream.toByteSequence();
                String name = new String(nameSeq.getData(), nameSeq.getOffset(), nameSeq.getLength(), "UTF-8");
                String value = this.decodeHeader((InputStream)headerLine);
                if (this.stompVersion.equals("1.0")) {
                    value = value.trim();
                }
                if (!headers.containsKey(name)) {
                    headers.put(name, value);
                }
                stream.close();
            }
            catch (Exception e) {
                throw new ProtocolException("Unable to parser header line [" + line + "]", true);
            }
        }
        return headers;
    }

    protected int parseContentLength(String contentLength, AtomicLong frameSize) throws ProtocolException {
        int length;
        try {
            length = Integer.parseInt(contentLength.trim());
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Specified content-length is not a valid integer", true);
        }
        if (length > this.getMaxDataLength()) {
            throw new ProtocolException("The maximum data length was exceeded", true);
        }
        if (frameSize.addAndGet(length) > this.getMaxFrameSize()) {
            throw new ProtocolException("The maximum frame size was exceeded", true);
        }
        return length;
    }

    private String encodeHeader(String header) throws IOException {
        String result = header;
        if (!this.stompVersion.equals("1.0")) {
            byte[] utf8buf = header.getBytes("UTF-8");
            ByteArrayOutputStream stream = new ByteArrayOutputStream(utf8buf.length);
            block5: for (byte val : utf8buf) {
                switch (val) {
                    case 92: {
                        stream.write(Stomp.ESCAPE_ESCAPE_SEQ);
                        continue block5;
                    }
                    case 10: {
                        stream.write(Stomp.NEWLINE_ESCAPE_SEQ);
                        continue block5;
                    }
                    case 58: {
                        stream.write(Stomp.COLON_ESCAPE_SEQ);
                        continue block5;
                    }
                    default: {
                        stream.write((int)val);
                    }
                }
            }
            result = new String(stream.toByteArray(), "UTF-8");
            stream.close();
        }
        return result;
    }

    private String decodeHeader(InputStream header) throws IOException {
        ByteArrayOutputStream decoded = new ByteArrayOutputStream();
        PushbackInputStream stream = new PushbackInputStream(header);
        int value = -1;
        block5: while ((value = stream.read()) != -1) {
            if (value == 92) {
                int next = stream.read();
                if (next != -1) {
                    switch (next) {
                        case 110: {
                            decoded.write(10);
                            continue block5;
                        }
                        case 99: {
                            decoded.write(58);
                            continue block5;
                        }
                        case 92: {
                            decoded.write(92);
                            continue block5;
                        }
                    }
                    stream.unread(next);
                    decoded.write(value);
                    continue;
                }
                decoded.write(value);
                continue;
            }
            decoded.write(value);
        }
        decoded.close();
        return new String(decoded.toByteArray(), "UTF-8");
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getStompVersion() {
        return this.stompVersion;
    }

    public void setStompVersion(String stompVersion) {
        this.stompVersion = stompVersion;
    }

    public void setMaxDataLength(int maxDataLength) {
        this.maxDataLength = maxDataLength;
    }

    public int getMaxDataLength() {
        return this.maxDataLength;
    }

    public long getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(long maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public long getConnectionAttemptTimeout() {
        return this.connectionAttemptTimeout;
    }

    public void setConnectionAttemptTimeout(long connectionAttemptTimeout) {
        this.connectionAttemptTimeout = connectionAttemptTimeout;
    }
}

