/*
 * Decompiled with CFR 0.152.
 */
package vmm.internal;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.StandardCharsets;
import leechcore.ILeechCore;
import leechcore.ILeechCoreBarCallback;
import leechcore.ILeechCoreBarContext;
import leechcore.ILeechCoreTlpCallback;
import leechcore.ILeechCoreTlpContext;
import leechcore.LeechCoreException;
import leechcore.entry.LeechCoreBar;
import vmm.IVmm;
import vmm.internal.LeechCoreBarContextImpl;
import vmm.internal.LeechCoreNative;
import vmm.internal.LeechCoreTlpContextImpl;

public class LeechCoreImpl
implements ILeechCore {
    Pointer hLC = null;
    String lcNativeLibraryPath = null;

    private LeechCoreImpl() {
    }

    private LeechCoreImpl(String lcNativeLibraryPath, String strDevice, String strRemote, int flagsVerbose, long paMax) {
        byte[] bDevice = strDevice.getBytes(StandardCharsets.UTF_8);
        byte[] bRemote = strRemote.getBytes(StandardCharsets.UTF_8);
        LeechCoreNative.LC_CONFIG lcConfig = new LeechCoreNative.LC_CONFIG();
        lcConfig.dwVersion = -1057161214;
        System.arraycopy(bDevice, 0, lcConfig.szDevice, 0, Math.min(lcConfig.szDevice.length - 1, bDevice.length));
        System.arraycopy(bRemote, 0, lcConfig.szRemote, 0, Math.min(lcConfig.szRemote.length - 1, bRemote.length));
        lcConfig.dwPrintfVerbosity = flagsVerbose;
        lcConfig.paMax = paMax;
        System.setProperty("jna.library.path", lcNativeLibraryPath);
        this.hLC = LeechCoreNative.INSTANCE.LcCreate(lcConfig);
        if (this.hLC == null) {
            throw new LeechCoreException("LeechCore Init: failed in native code.");
        }
        this.lcNativeLibraryPath = lcNativeLibraryPath;
    }

    public static ILeechCore Initialize(IVmm vmmInstance) {
        if (vmmInstance == null || !vmmInstance.isValid()) {
            return null;
        }
        long lcHandle = vmmInstance.getConfig(0x4000001000000000L);
        String strDevice = "existing://0x" + Long.toHexString(lcHandle);
        String lcNativeLibraryPath = vmmInstance.getNativeLibraryPath();
        return new LeechCoreImpl(lcNativeLibraryPath, strDevice, "", 0, 0L);
    }

    public static ILeechCore Initialize(String lcNativeLibraryPath, String strDevice) {
        return new LeechCoreImpl(lcNativeLibraryPath, strDevice, "", 0, 0L);
    }

    public static ILeechCore Initialize(String lcNativeLibraryPath, String strDevice, String strRemote, int flagsVerbose, long paMax) {
        return new LeechCoreImpl(lcNativeLibraryPath, strDevice, strRemote, flagsVerbose, paMax);
    }

    @Override
    public boolean isValid() {
        return this.hLC != null;
    }

    @Override
    public String getNativeLibraryPath() {
        return this.lcNativeLibraryPath;
    }

    @Override
    public void close() {
        LeechCoreNative.INSTANCE.LcClose(this.hLC);
        this.hLC = null;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.hLC != null ? "LeechCore" : "LeechCoreNotValid";
    }

    @Override
    public long getOption(long fOption) {
        LongByReference pqw = new LongByReference();
        boolean f = LeechCoreNative.INSTANCE.LcGetOption(this.hLC, fOption, pqw);
        if (!f) {
            throw new LeechCoreException("LeechCore.LcGetOption(): failed.");
        }
        return pqw.getValue();
    }

    @Override
    public void setOption(long fOption, long qw) {
        boolean f = LeechCoreNative.INSTANCE.LcSetOption(this.hLC, fOption, qw);
        if (!f) {
            throw new LeechCoreException("LeechCore.LcSetOption(): failed.");
        }
    }

    @Override
    public byte[] memRead(long pa, int size) {
        byte[] pbResult = new byte[size];
        boolean f = LeechCoreNative.INSTANCE.LcRead(this.hLC, pa, size, pbResult);
        if (!f) {
            throw new LeechCoreException("LeechCore.LcRead(): failed.");
        }
        return pbResult;
    }

    @Override
    public void memWrite(long pa, byte[] data) {
        boolean f = LeechCoreNative.INSTANCE.LcWrite(this.hLC, pa, data.length, data);
        if (!f) {
            throw new LeechCoreException("LeechCore.LcWrite(): failed.");
        }
    }

    @Override
    public String getMemMap() {
        return new String(this.command(0x4000020000000000L, null), StandardCharsets.UTF_8);
    }

    @Override
    public void setMemMap(String strMemMap) {
        byte[] bMemMap = strMemMap.getBytes(StandardCharsets.UTF_8);
        this.command(0x4000030000000000L, bMemMap);
    }

    @Override
    public byte[] command(long fCommand, byte[] data) {
        boolean f;
        PointerByReference ppbDataOut = new PointerByReference();
        IntByReference pcbDataOut = new IntByReference();
        int dataInLen = 0;
        Memory dataInPtr = null;
        if (data != null && data.length > 0) {
            dataInLen = data.length;
            dataInPtr = new Memory((long)dataInLen);
            dataInPtr.write(0L, data, 0, dataInLen);
        }
        if (!(f = LeechCoreNative.INSTANCE.LcCommand(this.hLC, fCommand, dataInLen, (Pointer)dataInPtr, ppbDataOut, pcbDataOut))) {
            throw new LeechCoreException("LeechCore.LcCommand(): failed.");
        }
        int cbDataOut = pcbDataOut.getValue();
        if (cbDataOut == 0) {
            return null;
        }
        Pointer pbDataOut = ppbDataOut.getValue();
        if (0L == Pointer.nativeValue((Pointer)pbDataOut)) {
            return null;
        }
        byte[] dataOut = pbDataOut.getByteArray(0L, cbDataOut);
        LeechCoreNative.INSTANCE.LcMemFree(pbDataOut);
        return dataOut;
    }

    @Override
    public void writePCIeTLP(byte[] tlp) {
        if (tlp != null && tlp.length > 0 || tlp.length % 4 == 0) {
            this.command(0x11000000000L, tlp);
        }
    }

    @Override
    public ILeechCoreTlpContext setPCIeTlpCallback(ILeechCoreTlpCallback callback) {
        return LeechCoreTlpContextImpl.initializeLeechCoreTlpContextImpl(this, callback);
    }

    @Override
    public LeechCoreBar[] getBarInfo() {
        PointerByReference ppbDataOut = new PointerByReference();
        IntByReference pcbDataOut = new IntByReference();
        boolean f = LeechCoreNative.INSTANCE.LcCommand(this.hLC, 1254130450432L, 0, null, ppbDataOut, pcbDataOut);
        if (!f) {
            throw new LeechCoreException("LeechCore.LcCommand(): failed.");
        }
        Pointer pbDataOut = ppbDataOut.getValue();
        if (0L == Pointer.nativeValue((Pointer)pbDataOut)) {
            return null;
        }
        LeechCoreNative.LC_BAR_6 nativeBars = new LeechCoreNative.LC_BAR_6(pbDataOut);
        LeechCoreBar[] lcBars = new LeechCoreBar[6];
        LeechCoreNative.LC_BAR[] lC_BARArray = nativeBars.bars;
        int n = nativeBars.bars.length;
        int n2 = 0;
        while (n2 < n) {
            LeechCoreNative.LC_BAR n3 = lC_BARArray[n2];
            LeechCoreBar e = new LeechCoreBar();
            e.fValid = n3.fValid;
            e.f64Bit = n3.f64Bit;
            e.fPrefetchable = n3.fPrefetchable;
            e.iBar = n3.iBar;
            e.pa = n3.pa;
            e.cb = n3.cb;
            lcBars[e.iBar] = e;
            ++n2;
        }
        LeechCoreNative.INSTANCE.LcMemFree(pbDataOut);
        return lcBars;
    }

    @Override
    public ILeechCoreBarContext setPCIeBarCallback(ILeechCoreBarCallback callback) {
        return LeechCoreBarContextImpl.initializeLeechCoreBarContextImpl(this, callback);
    }
}

