/*
 * Decompiled with CFR 0.152.
 */
package vmm.internal;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import leechcore.ILeechCoreBarCallback;
import leechcore.ILeechCoreBarContext;
import leechcore.entry.LeechCoreBar;
import leechcore.entry.LeechCoreBarRequest;
import vmm.internal.JnaObjectMap;
import vmm.internal.LeechCoreBarReplyImpl;
import vmm.internal.LeechCoreImpl;
import vmm.internal.LeechCoreNative;
import vmm.internal.LeechCoreNativeEx;

class LeechCoreBarContextImpl
implements ILeechCoreBarContext {
    private LeechCoreImpl lc;
    private Integer key;
    private Pointer keyPointer;
    private ILeechCoreBarCallback cbUser;
    private LeechCoreNative.CALLBACK_BAR cbNative;

    LeechCoreBarContextImpl() {
    }

    static LeechCoreBarContextImpl initializeLeechCoreBarContextImpl(LeechCoreImpl lc, ILeechCoreBarCallback cbUser) {
        LeechCoreBarContextImpl ctx = new LeechCoreBarContextImpl();
        ctx.cbNative = new LeechCoreNative.CALLBACK_BAR(){

            @Override
            public void invoke(LeechCoreNative.LC_BAR_REQUEST n) {
                try {
                    LeechCoreNative.LC_BAR nbar = new LeechCoreNative.LC_BAR(n.pBar);
                    LeechCoreBar bar = new LeechCoreBar();
                    bar.fValid = nbar.fValid;
                    bar.fIO = nbar.fIO;
                    bar.f64Bit = nbar.f64Bit;
                    bar.fPrefetchable = nbar.fPrefetchable;
                    bar.iBar = nbar.iBar;
                    bar.pa = nbar.pa;
                    bar.cb = nbar.cb;
                    LeechCoreBarReplyImpl reply = new LeechCoreBarReplyImpl();
                    reply.n = n;
                    LeechCoreBarRequest req = new LeechCoreBarRequest();
                    req.reply = reply;
                    req.bar = bar;
                    req.bTag = n.bTag;
                    req.bFirstBE = n.bFirstBE;
                    req.bLastBE = n.bLastBE;
                    req.is64Bit = n.f64;
                    req.isRead = n.fRead;
                    req.isWrite = n.fWrite;
                    req.cbData = n.cbData;
                    req.oData = n.oData;
                    if (req.isWrite) {
                        req.pbDataWrite = new byte[req.cbData];
                        System.arraycopy(n.pbData, 0, req.pbDataWrite, 0, req.cbData);
                    }
                    Integer key = (int)Pointer.nativeValue((Pointer)n.ctx);
                    LeechCoreBarContextImpl ctx = (LeechCoreBarContextImpl)JnaObjectMap.getInstance().get(key);
                    ctx.cbUser.LeechCoreBarCallback(req);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        ctx.lc = lc;
        ctx.cbUser = cbUser;
        ctx.key = JnaObjectMap.getInstance().put(ctx);
        ctx.keyPointer = new Pointer(ctx.key.longValue());
        if (!LeechCoreNative.INSTANCE.LcCommand(lc.hLC, 0x2000012000000000L, 0, ctx.keyPointer, null, null)) {
            ctx.close();
            return null;
        }
        if (!LeechCoreNativeEx.INSTANCE.LcCommand(lc.hLC, 0x2000012200000000L, 0, ctx.cbNative, null, null)) {
            ctx.close();
            return null;
        }
        return ctx;
    }

    @Override
    public void close() {
        if (this.lc == null || this.key == null) {
            return;
        }
        PointerByReference pptr = new PointerByReference();
        if (!LeechCoreNative.INSTANCE.LcCommand(this.lc.hLC, 0x2000012100000000L, 0, null, pptr, null)) {
            return;
        }
        if (Pointer.nativeValue((Pointer)pptr.getPointer()) != this.key.longValue()) {
            return;
        }
        LeechCoreNative.INSTANCE.LcCommand(this.lc.hLC, 0x2000012200000000L, 0, null, null, null);
        LeechCoreNative.INSTANCE.LcCommand(this.lc.hLC, 0x2000012000000000L, 0, null, null, null);
        JnaObjectMap.getInstance().remove(this.key);
        this.keyPointer = null;
        this.cbNative = null;
        this.cbUser = null;
        this.key = null;
        this.lc = null;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return "LeechCoreBarContext";
    }
}

